/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.commands;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.ReifiedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericType
extends ReifiedType {
    private static final GenericType[] EMPTY = new GenericType[0];
    private static final Map<String, Class> primitiveClasses = new HashMap<String, Class>();
    private GenericType[] parameters;

    public GenericType(Type type) {
        this(GenericType.getConcreteClass(type), GenericType.parametersOf(type));
    }

    public GenericType(Class clazz, GenericType ... parameters) {
        super(clazz);
        this.parameters = parameters;
    }

    public static GenericType parse(String type, Object loader) throws ClassNotFoundException, IllegalArgumentException {
        if ((type = type.trim()).endsWith("[]")) {
            GenericType t = GenericType.parse(type.substring(0, type.length() - 2), loader);
            return new GenericType(Array.newInstance(t.getRawClass(), 0).getClass(), t);
        }
        int genericIndex = type.indexOf(60);
        if (genericIndex > 0) {
            if (!type.endsWith(">")) {
                throw new IllegalArgumentException("Can not load type: " + type);
            }
            GenericType base = GenericType.parse(type.substring(0, genericIndex), loader);
            String[] params = type.substring(genericIndex + 1, type.length() - 1).split(",");
            GenericType[] types = new GenericType[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = GenericType.parse(params[i], loader);
            }
            return new GenericType(base.getRawClass(), types);
        }
        if (primitiveClasses.containsKey(type)) {
            return new GenericType(primitiveClasses.get(type));
        }
        if (loader instanceof ClassLoader) {
            return new GenericType(((ClassLoader)loader).loadClass(type));
        }
        if (loader instanceof Bundle) {
            return new GenericType(((Bundle)loader).loadClass(type));
        }
        throw new IllegalArgumentException("Unsupported loader: " + loader);
    }

    public ReifiedType getActualTypeArgument(int i) {
        if (this.parameters.length == 0) {
            return super.getActualTypeArgument(i);
        }
        return this.parameters[i];
    }

    public int size() {
        return this.parameters.length;
    }

    public String toString() {
        Class cl = this.getRawClass();
        if (cl.isArray()) {
            if (this.parameters.length > 0) {
                return this.parameters[0].toString() + "[]";
            }
            return cl.getComponentType().getName() + "[]";
        }
        if (this.parameters.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(cl.getName());
            sb.append("<");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.parameters[i].toString());
            }
            sb.append(">");
            return sb.toString();
        }
        return cl.getName();
    }

    static GenericType[] parametersOf(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                GenericType t = new GenericType(clazz.getComponentType());
                if (t.size() > 0) {
                    return new GenericType[]{t};
                }
                return EMPTY;
            }
            return EMPTY;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] parameters = pt.getActualTypeArguments();
            GenericType[] gts = new GenericType[parameters.length];
            for (int i = 0; i < gts.length; ++i) {
                gts[i] = new GenericType(parameters[i]);
            }
            return gts;
        }
        if (type instanceof GenericArrayType) {
            return new GenericType[]{new GenericType(((GenericArrayType)type).getGenericComponentType())};
        }
        throw new IllegalStateException();
    }

    static Class<?> getConcreteClass(Type type) {
        Type ntype = GenericType.collapse(type);
        if (ntype instanceof Class) {
            return (Class)ntype;
        }
        if (ntype instanceof ParameterizedType) {
            return GenericType.getConcreteClass(GenericType.collapse(((ParameterizedType)ntype).getRawType()));
        }
        throw new RuntimeException("Unknown type " + type);
    }

    static Type collapse(Type target) {
        if (target instanceof Class || target instanceof ParameterizedType) {
            return target;
        }
        if (target instanceof TypeVariable) {
            return GenericType.collapse(((TypeVariable)target).getBounds()[0]);
        }
        if (target instanceof GenericArrayType) {
            Type t = GenericType.collapse(((GenericArrayType)target).getGenericComponentType());
            while (t instanceof ParameterizedType) {
                t = GenericType.collapse(((ParameterizedType)t).getRawType());
            }
            return Array.newInstance((Class)t, 0).getClass();
        }
        if (target instanceof WildcardType) {
            WildcardType wct = (WildcardType)target;
            if (wct.getLowerBounds().length == 0) {
                return GenericType.collapse(wct.getUpperBounds()[0]);
            }
            return GenericType.collapse(wct.getLowerBounds()[0]);
        }
        throw new RuntimeException("Huh? " + target);
    }

    static {
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("boolean", Boolean.TYPE);
    }
}

