/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomElement;
import gnu.xml.dom.DomEvent;
import gnu.xml.dom.html2.DomHTMLDocument;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLElement;

public abstract class DomHTMLElement
extends DomElement
implements HTMLElement {
    protected String getHTMLAttribute(String string) {
        if (this.hasAttributes()) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = namedNodeMap.item(n2);
                String string2 = node2.getLocalName();
                if (string2 == null) {
                    string2 = node2.getNodeName();
                }
                if (string2.equalsIgnoreCase(string)) {
                    return node2.getNodeValue();
                }
                ++n2;
            }
        }
        return "";
    }

    protected int getIntHTMLAttribute(String string) {
        String string2 = this.getHTMLAttribute(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected boolean getBooleanHTMLAttribute(String string) {
        String string2 = this.getHTMLAttribute(string);
        boolean bl = false;
        if (string2 != null) {
            bl = true;
        }
        return bl;
    }

    protected void setHTMLAttribute(String string, String string2) {
        Node node2;
        NamedNodeMap namedNodeMap = this.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            node2 = namedNodeMap.item(n2);
            String string3 = node2.getLocalName();
            if (string3 == null) {
                string3 = node2.getNodeName();
            }
            if (string3.equalsIgnoreCase(string)) {
                if (string2 != null) {
                    node2.setNodeValue(string2);
                } else {
                    namedNodeMap.removeNamedItem(node2.getNodeName());
                }
                return;
            }
            ++n2;
        }
        if (string2 != null) {
            DomHTMLDocument domHTMLDocument = (DomHTMLDocument)this.getOwnerDocument();
            node2 = domHTMLDocument.createAttribute(string);
            node2.setNodeValue(string2);
        }
    }

    protected void setIntHTMLAttribute(String string, int n) {
        this.setHTMLAttribute(string, Integer.toString(n));
    }

    protected void setBooleanHTMLAttribute(String string, boolean bl) {
        this.setHTMLAttribute(string, bl ? string : null);
    }

    protected Node getParentElement(String string) {
        Node node2 = this.getParentNode();
        while (node2 != null) {
            String string2 = node2.getLocalName();
            if (string2 == null) {
                string2 = node2.getNodeName();
            }
            if (string.equalsIgnoreCase(string2)) {
                return node2;
            }
            node2 = node2.getParentNode();
        }
        return null;
    }

    protected Node getChildElement(String string) {
        Node node2 = this.getFirstChild();
        while (node2 != null) {
            String string2 = node2.getLocalName();
            if (string2 == null) {
                string2 = node2.getLocalName();
            }
            if (string.equalsIgnoreCase(string2)) {
                return node2;
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    protected int getIndex() {
        int n = 0;
        Node node2 = this.getParentNode();
        if (node2 != null) {
            Node node3 = node2.getFirstChild();
            while (node3 != null) {
                if (node3 == this) {
                    return n;
                }
                ++n;
                node3 = node3.getNextSibling();
            }
        }
        throw new DomDOMException(8);
    }

    protected void dispatchUIEvent(String string) {
        DomEvent.DomUIEvent domUIEvent = new DomEvent.DomUIEvent(string);
        this.dispatchEvent(domUIEvent);
    }

    public String getId() {
        return this.getHTMLAttribute("id");
    }

    public void setId(String string) {
        this.setHTMLAttribute("id", string);
    }

    public String getTitle() {
        return this.getHTMLAttribute("title");
    }

    public void setTitle(String string) {
        this.setHTMLAttribute("title", string);
    }

    public String getLang() {
        return this.getHTMLAttribute("lang");
    }

    public void setLang(String string) {
        this.setHTMLAttribute("lang", string);
    }

    public String getDir() {
        return this.getHTMLAttribute("dir");
    }

    public void setDir(String string) {
        this.setHTMLAttribute("dir", string);
    }

    public String getClassName() {
        return this.getHTMLAttribute("class");
    }

    public void setClassName(String string) {
        this.setHTMLAttribute("class", string);
    }

    protected DomHTMLElement(DomHTMLDocument domHTMLDocument, String string, String string2) {
        super(domHTMLDocument, string, string2);
    }
}

