/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.metal.MetalBumps;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalPainter
extends BasicPainter {
    private static MetalPainter _instance;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new MetalPainter();
        }
        return _instance;
    }

    public void paintGripper(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        if (orientation == 0) {
            MetalBumps bumps = new MetalBumps(rect.width, rect.height - 6, state == 3 ? MetalLookAndFeel.getPrimaryControlHighlight() : MetalLookAndFeel.getControlHighlight(), state == 3 ? MetalLookAndFeel.getPrimaryControlDarkShadow() : MetalLookAndFeel.getControlDarkShadow(), null);
            bumps.paintIcon(null, g2, rect.x, rect.y + 3);
        } else {
            MetalBumps bumps = new MetalBumps(rect.width - 6, rect.height, state == 3 ? MetalLookAndFeel.getPrimaryControlHighlight() : MetalLookAndFeel.getControlHighlight(), state == 3 ? MetalLookAndFeel.getPrimaryControlDarkShadow() : MetalLookAndFeel.getControlDarkShadow(), null);
            bumps.paintIcon(null, g2, rect.x + 3, rect.y);
        }
    }

    public void paintDockableFrameTitlePane(JComponent c, Graphics g2, Rectangle rect, int orientation, int state) {
        String gradientKey;
        boolean isSelected = state == 3;
        int width = rect.width;
        int height = rect.height;
        ColorUIResource background = isSelected ? MetalLookAndFeel.getWindowTitleBackground() : MetalLookAndFeel.getWindowTitleInactiveBackground();
        String string = gradientKey = isSelected ? "InternalFrame.activeTitleGradient" : "InternalFrame.inactiveTitleGradient";
        if (!MetalPainter.drawGradient(c, g2, gradientKey, 0, 0, width, height, true)) {
            g2.setColor(background);
            g2.fillRect(0, 0, width, height);
        }
    }

    static boolean drawGradient(Component c, Graphics g2, String key, int x, int y, int w, int h2, boolean vertical) {
        Object colors = UIManager.get(key);
        if (!(colors instanceof List)) {
            return false;
        }
        List gradient = (List)colors;
        if (gradient == null || !(g2 instanceof Graphics2D)) {
            return false;
        }
        if (w <= 0 || h2 <= 0) {
            return true;
        }
        GradientPainter.INSTANCE.paint(c, (Graphics2D)g2, gradient, x, y, w, h2, vertical);
        return true;
    }

    private static class GradientPainter {
        public static final GradientPainter INSTANCE = new GradientPainter();

        GradientPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Component c, Graphics2D g2, List gradient, int x, int y, int w, int h2, boolean isVertical) {
            int imageHeight;
            int imageWidth;
            if (isVertical) {
                imageWidth = w;
                imageHeight = h2;
            } else {
                imageWidth = w;
                imageHeight = h2;
            }
            Object object = c.getTreeLock();
            synchronized (object) {
                this.paint(c, g2, imageWidth, imageHeight, gradient, isVertical);
            }
        }

        protected void paint(Component c, Graphics g2, int w, int h2, List gradient, boolean isVertical) {
            Graphics2D g22 = (Graphics2D)g2;
            if (isVertical) {
                this.drawVerticalGradient(g22, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w, h2);
            } else {
                this.drawHorizontalGradient(g22, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w, h2);
            }
        }

        private void drawVerticalGradient(Graphics2D g2, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w, int h2) {
            int mid = (int)(ratio1 * (float)h2);
            int mid2 = (int)(ratio2 * (float)h2);
            if (mid > 0) {
                g2.setPaint(this.getGradient(0.0f, 0.0f, c1, 0.0f, mid, c2));
                g2.fillRect(0, 0, w, mid);
            }
            if (mid2 > 0) {
                g2.setColor(c2);
                g2.fillRect(0, mid, w, mid2);
            }
            if (mid > 0) {
                g2.setPaint(this.getGradient(0.0f, (float)mid + (float)mid2, c2, 0.0f, (float)mid * 2.0f + (float)mid2, c1));
                g2.fillRect(0, mid + mid2, w, mid);
            }
            if (h2 - mid * 2 - mid2 > 0) {
                g2.setPaint(this.getGradient(0.0f, (float)mid * 2.0f + (float)mid2, c1, 0.0f, h2, c3));
                g2.fillRect(0, mid * 2 + mid2, w, h2 - mid * 2 - mid2);
            }
        }

        private void drawHorizontalGradient(Graphics2D g2, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w, int h2) {
            int mid = (int)(ratio1 * (float)w);
            int mid2 = (int)(ratio2 * (float)w);
            if (mid > 0) {
                g2.setPaint(this.getGradient(0.0f, 0.0f, c1, mid, 0.0f, c2));
                g2.fillRect(0, 0, mid, h2);
            }
            if (mid2 > 0) {
                g2.setColor(c2);
                g2.fillRect(mid, 0, mid2, h2);
            }
            if (mid > 0) {
                g2.setPaint(this.getGradient((float)mid + (float)mid2, 0.0f, c2, (float)mid * 2.0f + (float)mid2, 0.0f, c1));
                g2.fillRect(mid + mid2, 0, mid, h2);
            }
            if (w - mid * 2 - mid2 > 0) {
                g2.setPaint(this.getGradient((float)mid * 2.0f + (float)mid2, 0.0f, c1, w, 0.0f, c3));
                g2.fillRect(mid * 2 + mid2, 0, w - mid * 2 - mid2, h2);
            }
        }

        private GradientPaint getGradient(float x1, float y1, Color c1, float x2, float y2, Color c2) {
            return new GradientPaint(x1, y1, c1, x2, y2, c2, true);
        }
    }
}

