/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.EventAggregators;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;

public class AggregatingExecutor
implements Executor {
    final DispatchQueue queue;
    final CustomDispatchSource<Runnable, LinkedList<Runnable>> source;

    public AggregatingExecutor(DispatchQueue queue) {
        this.queue = queue;
        this.source = Dispatch.createSource(EventAggregators.linkedList(), queue);
        this.source.setEventHandler(new Task(){

            public void run() {
                for (Runnable runnable : AggregatingExecutor.this.source.getData()) {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        Thread thread = Thread.currentThread();
                        thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                    }
                }
            }
        });
        this.source.resume();
    }

    public void suspend() {
        this.source.suspend();
    }

    public void resume() {
        this.source.resume();
    }

    public void execute(Runnable task) {
        if (Dispatch.getCurrentQueue() == null) {
            this.queue.execute(new TaskWrapper(task));
        } else {
            this.source.merge(task);
        }
    }
}

