/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.jvm.toolchain.internal.OsXJavaHomeCommand;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOsXJavaHomeCommand
implements OsXJavaHomeCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOsXJavaHomeCommand.class);
    private static final Pattern INSTALLATION_PATTERN = Pattern.compile(".+\\s+(/.+)");
    private final ExecHandleFactory execHandleFactory;

    public DefaultOsXJavaHomeCommand(ExecHandleFactory execHandleFactory) {
        this.execHandleFactory = execHandleFactory;
    }

    @VisibleForTesting
    static Set<File> parse(Reader output) {
        BufferedReader reader = new BufferedReader(output);
        return reader.lines().flatMap(line -> {
            Matcher matcher = INSTALLATION_PATTERN.matcher((CharSequence)line);
            if (matcher.matches()) {
                String javaHome = matcher.group(1);
                return Stream.of(javaHome);
            }
            return Stream.empty();
        }).map(File::new).collect(Collectors.toSet());
    }

    @Override
    public Set<File> findJavaHomes() {
        try {
            Reader output = this.executeJavaHome();
            return DefaultOsXJavaHomeCommand.parse(output);
        }
        catch (ExecException e) {
            String errorMessage = "Java Toolchain auto-detection failed to find local MacOS system JVMs";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(errorMessage, (Throwable)e);
            } else {
                LOGGER.info(errorMessage);
            }
            return Collections.emptySet();
        }
    }

    private Reader executeJavaHome() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.executeCommand(outputStream);
        return new InputStreamReader(new ByteArrayInputStream(outputStream.toByteArray()));
    }

    @VisibleForTesting
    protected void executeCommand(ByteArrayOutputStream outputStream) {
        ExecHandleBuilder execHandleBuilder = this.execHandleFactory.newExec();
        execHandleBuilder.workingDir((Object)new File(".").getAbsoluteFile());
        execHandleBuilder.commandLine(new Object[]{"/usr/libexec/java_home", "-V"});
        execHandleBuilder.getEnvironment().remove("JAVA_VERSION");
        execHandleBuilder.setErrorOutput((OutputStream)outputStream);
        execHandleBuilder.setStandardOutput((OutputStream)new ByteArrayOutputStream());
        execHandleBuilder.build().start().waitForFinish().assertNormalExitValue();
    }
}

