/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.Defaults;
import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.IllegalMultipleDeclarationException;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.QualifiedSwitch;
import com.martiansoftware.jsap.RequiredParameterMissingException;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.SyntaxException;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.UnknownFlagException;
import java.util.Iterator;

class Parser {
    private JSAP config = null;
    private Iterator unflaggedOptions = null;
    private UnflaggedOption curUnflaggedOption = null;
    private String[] args = null;
    private boolean parsed = false;
    private JSAPResult result = null;

    public Parser(JSAP config, String[] args) {
        this.config = config;
        this.args = args;
        this.parsed = false;
        this.result = new JSAPResult();
        this.unflaggedOptions = config.getUnflaggedOptionsIterator();
        this.advanceUnflaggedOption();
    }

    private void advanceUnflaggedOption() {
        this.curUnflaggedOption = this.unflaggedOptions.hasNext() ? (UnflaggedOption)this.unflaggedOptions.next() : null;
    }

    private void processParameter(Parameter param, String valueToParse) {
        if (this.result.getObject(param.getID()) != null && (param instanceof FlaggedOption && !((FlaggedOption)param).allowMultipleDeclarations() || param instanceof Switch || param instanceof QualifiedSwitch || param instanceof UnflaggedOption && !((UnflaggedOption)param).isGreedy())) {
            this.result.addException(param.getID(), new IllegalMultipleDeclarationException(param.getID()));
        }
        if (param instanceof QualifiedSwitch) {
            this.result.registerQualifiedSwitch(param.getID(), true);
        }
        try {
            this.result.add(param.getID(), param.parse(valueToParse));
        }
        catch (ParseException pe) {
            this.result.addException(param.getID(), pe);
        }
    }

    private int parseArg(String[] args, int index) {
        if (args[index].startsWith("--") && !args[index].equals("--")) {
            return this.parseLongForm(args, index);
        }
        if (args[index].startsWith("-") && !args[index].equals("-") && !args[index].equals("--")) {
            return this.parseShortForm(args, index);
        }
        return this.parseUnflaggedOption(args, index);
    }

    private void processDefaults() {
        Defaults defaults = this.config.getDefaults(this.result);
        Iterator i = defaults.idIterator();
        while (i.hasNext()) {
            String[] paramValues;
            String paramID = (String)i.next();
            if (this.result.getObject(paramID) != null || (paramValues = defaults.getDefault(paramID)) == null) continue;
            int z = paramValues.length;
            for (int index = 0; index < z; ++index) {
                this.processParameter(this.config.getByID(paramID), paramValues[index]);
            }
        }
    }

    private void enforceRequirements() {
        IDMap idMap = this.config.getIDMap();
        Iterator i = idMap.idIterator();
        while (i.hasNext()) {
            Option option;
            String id = (String)i.next();
            Parameter o = this.config.getByID(id);
            if (!(o instanceof Option) || !(option = (Option)o).required() || this.result.getObject(id) != null || this.result.getException(id) != null) continue;
            this.result.addException(option.getID(), new RequiredParameterMissingException(id));
        }
    }

    public JSAPResult parse() {
        if (this.parsed) {
            this.result.addException(null, new JSAPException("This Parser has already run."));
        } else {
            this.result.setValuesFromUser(true);
            this.preregisterQualifiedSwitches();
            int z = this.args.length;
            int i = 0;
            while (i < z) {
                i = this.parseArg(this.args, i);
            }
            this.result.setValuesFromUser(false);
            this.processDefaults();
            this.enforceRequirements();
            this.parsed = true;
        }
        return this.result;
    }

    private void preregisterQualifiedSwitches() {
        Iterator iter = this.config.getIDMap().idIterator();
        while (iter.hasNext()) {
            String thisID = (String)iter.next();
            Parameter param = this.config.getByID(thisID);
            if (!(param instanceof QualifiedSwitch)) continue;
            this.result.registerQualifiedSwitch(thisID, false);
        }
    }

    private int parseLongForm(String[] args, int index) {
        int equalsIndex = args[index].indexOf(61);
        int colonIndex = args[index].indexOf(58);
        String paramFlag = null;
        String paramEquals = null;
        String paramColon = null;
        if (equalsIndex == -1 && colonIndex == -1) {
            paramFlag = args[index].substring(2);
        }
        if (equalsIndex != -1) {
            paramFlag = args[index].substring(2, equalsIndex);
            paramEquals = args[index].substring(equalsIndex + 1);
        }
        if (equalsIndex == -1 && colonIndex != -1) {
            paramFlag = args[index].substring(2, colonIndex);
            paramColon = args[index].substring(colonIndex);
        }
        ++index;
        Flagged option = this.config.getByLongFlag(paramFlag);
        Parameter param = (Parameter)((Object)option);
        if (option == null) {
            this.result.addException(null, new UnknownFlagException(paramFlag));
        } else if (option instanceof Switch) {
            if (equalsIndex != -1) {
                this.result.addException(param.getID(), new SyntaxException("Switch \"" + paramFlag + "\" does not take any parameters."));
            } else {
                this.processParameter(param, null);
            }
        } else if (param instanceof QualifiedSwitch) {
            Object paramValue = null;
            if (colonIndex == -1) {
                this.processParameter(param, null);
            } else {
                this.processParameter(param, args[index - 1].substring(colonIndex + 1));
            }
        } else if (equalsIndex == -1) {
            if (index >= args.length) {
                this.result.addException(param.getID(), new SyntaxException("No value specified for option \"" + paramFlag + "\""));
            } else {
                paramEquals = args[index];
                ++index;
                this.processParameter(param, paramEquals);
            }
        } else {
            this.processParameter(param, paramEquals);
        }
        return index;
    }

    private int parseShortForm(String[] args, int index) {
        Character paramFlag = null;
        int equalsIndex = args[index].indexOf(61);
        int parseTo = args[index].length();
        if (equalsIndex != -1) {
            parseTo = equalsIndex;
        }
        for (int charPos = 1; charPos < parseTo; ++charPos) {
            paramFlag = new Character(args[index].charAt(charPos));
            Flagged option = this.config.getByShortFlag(paramFlag);
            Parameter param = (Parameter)((Object)option);
            if (option == null) {
                this.result.addException(null, new UnknownFlagException(paramFlag));
                continue;
            }
            if (option instanceof Switch) {
                if (charPos == equalsIndex - 1) {
                    this.result.addException(param.getID(), new SyntaxException("Switch \"" + paramFlag + "\" does not take any parameters."));
                    continue;
                }
                this.processParameter(param, null);
                continue;
            }
            if (option instanceof QualifiedSwitch) {
                if (args[index].length() > charPos + 1 && args[index].charAt(charPos + 1) == ':') {
                    this.processParameter(param, args[index].substring(charPos + 2));
                    break;
                }
                this.processParameter(param, null);
                continue;
            }
            String paramEquals = null;
            if (equalsIndex != -1) {
                paramEquals = args[index].substring(equalsIndex + 1);
                this.processParameter(param, paramEquals);
                continue;
            }
            if (charPos < parseTo - 1) {
                paramEquals = args[index].substring(charPos + 1, parseTo);
                this.processParameter(param, paramEquals);
                break;
            }
            if (++index >= args.length) {
                this.result.addException(param.getID(), new SyntaxException("No value specified for option \"" + paramFlag + "\"."));
                continue;
            }
            paramEquals = args[index];
            this.processParameter(param, paramEquals);
        }
        return ++index;
    }

    private int parseUnflaggedOption(String[] args, int index) {
        if (this.curUnflaggedOption != null) {
            this.processParameter(this.curUnflaggedOption, args[index]);
            if (!this.curUnflaggedOption.isGreedy()) {
                this.advanceUnflaggedOption();
            }
        } else {
            this.result.addException(null, new JSAPException("Unexpected argument: " + args[index]));
        }
        return index + 1;
    }
}

