var __index = {"config":{"lang":["en"],"separator":"[\\s\\-]+","pipeline":["stopWordFilter"]},"docs":[{"location":"index.html","title":"Jujutsu\u2014a version control system","text":""},{"location":"index.html#welcome-to-jjs-documentation-website","title":"Welcome to <code>jj</code>'s documentation website!","text":"<p>The complete list of the available documentation pages is located in the sidebar on the left of the page. The sidebar may be hidden; if so, you can open it either by widening your browser window or by clicking on the hamburger menu that appears in this situation.</p> <p>Additional help is available using the <code>jj help</code> command if you have <code>jj</code> installed.</p> <p>You may want to jump to:</p> <ul> <li>Documentation for the latest released version of <code>jj</code>.</li> <li>Documentation for the unreleased version of <code>jj</code>. This version of the docs corresponds to the <code>main</code> branch of the <code>jj</code> repo.</li> </ul>"},{"location":"index.html#some-useful-links","title":"Some useful links","text":"<ul> <li>GitHub repo for <code>jj</code></li> <li>Overview of <code>jj</code> in the repo's README</li> <li>Installation and Setup</li> <li>Tutorial and Birds-Eye View</li> <li>Working with GitHub</li> <li>Development Roadmap</li> </ul>"},{"location":"FAQ.html","title":"Frequently asked questions","text":""},{"location":"FAQ.html#why-does-my-bookmark-not-move-to-the-new-commit-after-jj-newcommit","title":"Why does my bookmark not move to the new commit after <code>jj new/commit</code>?","text":"<p>If you're familiar with Git, you might expect the current bookmark to move forward when you commit. However, Jujutsu does not have a concept of a \"current bookmark\".</p> <p>To move bookmarks, use <code>jj bookmark move</code>.</p>"},{"location":"FAQ.html#i-made-a-commit-and-jj-git-push-all-says-nothing-changed-instead-of-pushing-it-what-do-i-do","title":"I made a commit and <code>jj git push --all</code> says \"Nothing changed\" instead of pushing it. What do I do?","text":"<p><code>jj git push --all</code> pushes all bookmarks, not all revisions. You have two options:</p> <ul> <li>Using <code>jj git push --change</code> will automatically create a bookmark and push it.</li> <li>Using <code>jj bookmark</code> commands to create or move a bookmark to either the commit   you want to push or a descendant on it. Unlike Git, Jujutsu doesn't do this   automatically (see previous question).</li> </ul>"},{"location":"FAQ.html#where-is-my-commit-why-is-it-not-visible-in-jj-log","title":"Where is my commit, why is it not visible in <code>jj log</code>?","text":"<p>Is your commit visible with <code>jj log -r 'all()'</code>?</p> <p>If yes, you should be aware that <code>jj log</code> only shows the revisions matching <code>revsets.log</code> by default. You can change it as described in config to show more revisions.</p> <p>If not, the revision may have been abandoned (e.g. because you used <code>jj abandon</code>, or because it's an obsolete version that's been rewritten with <code>jj rebase</code>, <code>jj describe</code>, etc). In that case, <code>jj log -r commit_id</code> should show the revision as \"hidden\". <code>jj new commit_id</code> should make the revision visible again.</p> <p>See revsets and templates for further guidance.</p>"},{"location":"FAQ.html#what-are-elided-revisions-in-the-output-of-jj-log-how-can-i-display-them","title":"What are elided revisions in the output of <code>jj log</code>? How can I display them?","text":"<p>\"Elided revisions\" appears in the log when one revision descends from another, both are in the revset, but the revisions connecting them are not in the revset.</p> <p>For example, suppose you log the revset <code>tyl|mus</code> which contains exactly two revisions:</p> <pre><code>$  jj log -r 'tyl|mus'\n\u25cb  musnqzvt me@example.com 1 minute ago 9a09f8a5\n\u2502  Revision C\n~  (elided revisions)\n\u25cb  tylynnzk me@example.com 1 minute ago f26967c8\n\u2502  Revision A\n</code></pre> <p>Only the two revisions in the revset are displayed. The text \"(elided revisions)\" is shown to indicate that <code>musnqzvt</code> descends from <code>tylynnzk</code>, but the nodes connecting them are not in the revset.</p> <p>To view the elided revisions, change the revset expression so it includes the connecting revisions.  The <code>connected()</code> revset function does exactly this:</p> <pre><code>$ jj log -r 'connected(tyl|mus)'\n\u25cb  musnqzvt me@example.com 43 seconds ago 9a09f8a5\n\u2502  Revision C\n\u25cb  rsvnrznr me@example.com 43 seconds ago 5b490f30\n\u2502  Revision B\n\u25cb  tylynnzk me@example.com 43 seconds ago f26967c8\n\u2502  Revision A\n</code></pre>"},{"location":"FAQ.html#how-can-i-get-jj-log-to-show-me-what-git-log-would-show-me","title":"How can I get <code>jj log</code> to show me what <code>git log</code> would show me?","text":"<p>Use <code>jj log -r ..</code>. The <code>..</code> operator lists all visible commits in the repo, excluding the root (which is never interesting and is shared by all repos).</p>"},{"location":"FAQ.html#can-i-monitor-how-jj-log-evolves","title":"Can I monitor how <code>jj log</code> evolves?","text":"<p>The simplest way to monitor how the history as shown by <code>jj log</code> evolves is by using the watch(1) command (or hwatch or viddy). For example:</p> <pre><code>watch --color jj --ignore-working-copy log --color=always\n</code></pre> <p>This will continuously update the (colored) log output in the terminal. The <code>--ignore-working-copy</code> option avoids conflicts with manual operations during the creation of snapshots. Martin used watch in a tmux pane during his presentation Jujutsu - A Git-compatible VCS.</p> <p>Alternatively, you can use jj-fzf, where the central piece is the <code>jj log</code> view and common operations can be carried out via key bindings while the log view updates.</p> <p>The wiki lists additional TUIs and GUIs beyond the terminal: GUI-and-TUI</p>"},{"location":"FAQ.html#should-i-co-locate-my-repository","title":"Should I co-locate my repository?","text":"<p>Co-locating a Jujutsu repository allows you to use both Jujutsu and Git in the same working copy. The benefits of doing so are:</p> <ul> <li> <p>You can use Git commands when you're not sure how to do something with   Jujutsu, Jujutsu hasn't yet implemented a feature (e.g., bisection), or you   simply prefer Git in some situations.</p> </li> <li> <p>Tooling that expects a Git repository still works (IDEs, build tooling, etc.)</p> </li> </ul> <p>The co-location documentation describes the drawbacks but the most important ones are:</p> <ul> <li> <p>Interleaving <code>git</code> and <code>jj</code> commands may create confusing bookmark conflicts   or divergent changes.</p> </li> <li> <p>If the working copy commit or its parent contain any conflicted files, tools   expecting a Git repo may interpret the commit contents or its diff in a wrong   and confusing way. You should avoid doing mutating operations with Git tools   and ignore the confusing information such tools present for conflicted commits   (unless you are curious about the details of how <code>jj</code> stores   conflicts). See   #3979 for plans to improve   this situation.</p> </li> <li> <p>Jujutsu commands may be a little slower in very large repositories due to   importing and exporting changes to Git. Most repositories are not noticeably   affected by this.</p> </li> </ul> <p>If you primarily use Jujutsu to modify the repository, the drawbacks are unlikely to affect you. Try co-locating while you learn Jujutsu, then switch if you find a specific reason not to co-locate.</p>"},{"location":"FAQ.html#jj-is-said-to-record-the-working-copy-after-jj-log-and-every-other-command-where-can-i-see-these-automatic-saves","title":"<code>jj</code> is said to record the working copy after <code>jj log</code> and every other command. Where can I see these automatic \"saves\"?","text":"<p>Indeed, every <code>jj</code> command updates the current \"working-copy\" revision, marked with <code>@</code> in <code>jj log</code>. You can notice this by how the commit ID of the working copy revision changes when it's updated. Note that, unless you move to another revision (with <code>jj new</code> or <code>jj edit</code>, for example), the change ID will not change.</p> <p>If you expected to see a historical view of your working copy changes in the parent-child relationships between commits you can see in <code>jj log</code>, this is simply not what they mean. What you can see in <code>jj log</code> is that after the working copy commit gets amended (after any edit), the commit ID changes.</p> <p>You can see the actual history of working copy changes using <code>jj evolog</code>. This will show the history of the commits that were previously the \"working-copy commit\", since the last time the change id of the working copy commit changed. The obsolete changes will be marked as \"hidden\". They are still accessible with any <code>jj</code> command (<code>jj diff</code>, for example), but you will need to use the commit id to refer to hidden commits.</p> <p>You can also use <code>jj evolog -r</code> on revisions that were previously the working-copy revisions (or on any other revisions). Use <code>jj evolog -p</code> as an easy way to see the evolution of the commit's contents.</p>"},{"location":"FAQ.html#can-i-prevent-jujutsu-from-recording-my-unfinished-work-im-not-ready-to-commit-it","title":"Can I prevent Jujutsu from recording my unfinished work? I'm not ready to commit it.","text":"<p>Jujutsu automatically records new files in the current working-copy commit and doesn't provide a way to prevent that.</p> <p>However, you can easily record intermediate drafts of your work. If you think you might want to go back to the current state of the working-copy commit, simply use <code>jj new</code>. There's no need for the commit to be \"finished\" or even have a description.</p> <p>Then future edits will go into a new working-copy commit on top of the now former working-copy commit. Whenever you are happy with another set of edits, use <code>jj squash</code> to amend the previous commit.</p> <p>If you have changes you never want to put in a public commit, see: How can I keep my scratch files in the repository without committing them?</p> <p>For more options see the next question.</p>"},{"location":"FAQ.html#can-i-interactively-create-a-new-commit-from-only-some-of-the-changes-in-the-working-copy-like-git-add-p-git-commit-or-hg-commit-i","title":"Can I interactively create a new commit from only some of the changes in the working copy, like <code>git add -p &amp;&amp; git commit</code> or <code>hg commit -i</code>?","text":"<p>Since the changes are already in the working-copy commit, the equivalent to <code>git add -p &amp;&amp; git commit</code>/<code>git commit -p</code>/<code>hg commit -i</code> is to split the working-copy commit with <code>jj split -i</code> (or the practically identical <code>jj commit -i</code>).</p> <p>For the equivalent of <code>git commit --amend -p</code>/<code>hg amend -i</code>, use <code>jj squash -i</code>.</p>"},{"location":"FAQ.html#is-there-something-like-git-rebase-interactive-or-hg-histedit","title":"Is there something like <code>git rebase --interactive</code> or <code>hg histedit</code>?","text":"<p>Not yet, you can check this issue for updates.</p> <p>To reorder commits, it is for now recommended to rebase commits individually, which may require multiple invocations of <code>jj rebase -r</code> or <code>jj rebase -s</code>.</p> <p>To squash or split commits, use <code>jj squash</code> and <code>jj split</code>.</p>"},{"location":"FAQ.html#how-can-i-keep-my-scratch-files-in-the-repository-without-committing-them","title":"How can I keep my scratch files in the repository without committing them?","text":"<p>You can set <code>snapshot.auto-track</code> to only start tracking new files matching the configured pattern (e.g. <code>\"none()\"</code>). Changes to already tracked files will still be snapshotted by every command.</p> <p>You can keep your notes and other scratch files in the repository, if you add a wildcard pattern to either the repo's <code>gitignore</code> or your global <code>gitignore</code>. Something like <code>*.scratch</code> or <code>*.scratchpad</code> should do, after that rename the files you want to keep around to match the pattern.</p> <p>If you keep your scratch files in their own directory with no tracked files, you can create a <code>.gitignore</code> file in that directory containing only <code>*</code>. This will ignore everything in the directory including the <code>.gitignore</code> file itself.</p> <p>If <code>$EDITOR</code> integration is important, something like <code>scratchpad.*</code> may be more helpful, as you can keep the filename extension intact (it matches <code>scratchpad.md</code>, <code>scratchpad.rs</code> and more). Another option is to add a directory to the global <code>.gitignore</code> which then stores all your temporary files and notes. For example, you could add <code>scratch/</code> to <code>~/.git/ignore</code> and then store arbitrary files in <code>&lt;your-git-repo&gt;/scratch/</code>.</p> <p>You can find more details on <code>gitignore</code> files here.</p>"},{"location":"FAQ.html#how-can-i-avoid-committing-my-local-only-changes-to-tracked-files","title":"How can I avoid committing my local-only changes to tracked files?","text":"<p>Suppose your repository tracks a file like <code>secret_config.json</code>, and you make some changes to that file to work locally. Since Jujutsu automatically commits the working copy, there's no way to prevent Jujutsu from committing changes to the file. But, you never want to push those changes to the remote repository.</p> <p>One solution is to keep these changes in a separate commit branched from the trunk. To use those changes in your working copy, merge the private commit into your branch.</p> <p>Suppose you have a commit \"Add new feature\":</p> <pre><code>$ jj log\n@  xxxxxxxx me@example.com 2024-08-21 11:13:21 ef612875\n\u2502  Add new feature\n\u25c9  yyyyyyyy me@example.com 2024-08-21 11:13:09 main b624cf12\n\u2502  Existing work\n~\n</code></pre> <p>First, create a new commit branched from main and add your private changes:</p> <pre><code>$ jj new main -m \"private: my credentials\"\nWorking copy now at: wwwwwwww 861de9eb (empty) private: my credentials\nParent commit      : yyyyyyyy b624cf12 main | Existing work\nAdded 0 files, modified 1 files, removed 0 files\n\n$ echo '{ \"password\": \"p@ssw0rd1\" }' &gt; secret_config.json\n</code></pre> <p>Now create a merge commit with the branch you're working on and the private commit:</p> <pre><code>$ jj new xxxxxxxx wwwwwwww\nWorking copy now at: vvvvvvvv ac4d9fbe (empty) (no description set)\nParent commit      : xxxxxxxx ef612875 Add new feature\nParent commit      : wwwwwwww 2106921e private: my credentials\nAdded 0 files, modified 1 files, removed 0 files\n\n$ jj log\n@    vvvvvvvv me@example.com 2024-08-22 08:57:40 ac4d9fbe\n\u251c\u2500\u256e  (empty) (no description set)\n\u2502 \u25c9  wwwwwwww me@example.com 2024-08-22 08:57:40 2106921e\n\u2502 \u2502  private: my credentials\n\u25c9 \u2502  xxxxxxxx me@example.com 2024-08-21 11:13:21 ef612875\n\u251c\u2500\u256f  Add new feature\n\u25c9  yyyyyyyy me@example.com 2024-08-21 11:13:09 main b624cf12\n\u2502  Existing work\n~\n</code></pre> <p>Now you're ready to work:</p> <ul> <li>Your work in progress xxxxxxxx is the first parent of the merge commit.</li> <li>The private commit wwwwwwww is the second parent of the merge commit.</li> <li>The working copy (vvvvvvvv) contains changes from both.</li> </ul> <p>As you work, squash your changes using <code>jj squash --into xxxxxxxx</code>.</p> <p>If you need a new empty commit on top of <code>xxxxxxxx</code> you can use the <code>--insert-after</code> and <code>--insert-before</code> options (<code>-A</code> and <code>-B</code> for short):</p> <pre><code># Insert a new commit after xxxxxxxx\n$ jj new --no-edit -A xxxxxxxx -m \"Another feature\"\nWorking copy now at: uuuuuuuu 1c3cff09 (empty) Another feature\nParent commit      : xxxxxxxx ef612875 Add new feature\n\n# Insert a new commit between yyyyyyyy and vvvvvvvv\n$ jj new --no-edit -A yyyyyyyy -B vvvvvvvv -m \"Yet another feature\"\nWorking copy now at: tttttttt 938ab831 (empty) Yet another feature\nParent commit      : yyyyyyyy b624cf12 Existing work\n</code></pre> <p>To avoid pushing change wwwwwwww by mistake, use the configuration git.private-commits:</p> <pre><code>jj config set --user git.private-commits 'description(glob:\"private:*\")'\n</code></pre>"},{"location":"FAQ.html#i-accidentally-changed-files-in-the-wrong-commit-how-do-i-move-the-recent-changes-into-another-commit","title":"I accidentally changed files in the wrong commit, how do I move the recent changes into another commit?","text":"<p>Use <code>jj evolog -p</code> to see how your working-copy commit has evolved. Find the commit you want to restore the contents to. Let's say the current commit (with the changes intended for a new commit) are in commit X and the state you wanted is in commit Y. Note the commit id (normally in blue at the end of the line in the log output) of each of them. Now use <code>jj new</code> to create a new working-copy commit, then run <code>jj restore --from Y --into @-</code> to restore the parent commit to the old state, and <code>jj restore --from X</code> to restore the new working-copy commit to the new state.</p>"},{"location":"FAQ.html#how-do-i-resume-working-on-an-existing-change","title":"How do I resume working on an existing change?","text":"<p>There are two ways to resume working on an earlier change: <code>jj new</code> then <code>jj squash</code>, and <code>jj edit</code>. The first is generally recommended, but <code>jj edit</code> can be useful. When you use <code>jj edit</code>, the revision is directly amended with your new changes, making it difficult to tell what exactly you change. You should avoid using <code>jj edit</code> when the revision has a conflict, as you may accidentally break the plain-text annotations on your state without realising.</p> <p>To start, use <code>jj new &lt;rev&gt;</code> to create a change based on that earlier revision. Make your edits, then use <code>jj squash</code> to update the earlier revision with those edits. For when you would use git stashing, use <code>jj edit &lt;rev&gt;</code> for expected behaviour. Other workflows may prefer <code>jj edit</code> as well.</p>"},{"location":"FAQ.html#why-are-most-merge-commits-marked-as-empty","title":"Why are most merge commits marked as \"(empty)\"?","text":"<p>Jujutsu, like Git, is a snapshot-based VCS. That means that each commit logically records the state of all current files in the repo. The changes in a commit are not recorded but are instead calculated when needed by comparing the commit's state to the parent commit's state. Jujutsu defines the changes in a commit to be relative to the auto-merged parents (if there's only one parent, then that merge is trivial - it's the parent commit's state). As a result, a merge commit that was a clean merge (no conflict resolution, no additional changes) is considered empty. Conversely, if the merge commit contains conflict resolutions or additional changes, then it will be considered non-empty.</p> <p>This definition of the changes in a commit is used throughout Jujutsu. It's used by <code>jj diff -r</code> and <code>jj log -p</code> to show the changes in a commit. It's used by <code>jj rebase</code> to rebase the changes in a commit. It's used in <code>jj log</code> to indicate which commits are empty. It's used in the <code>files()</code> revset function (and by <code>jj log &lt;path&gt;</code>) to find commits that modify a certain path. And so on.</p>"},{"location":"FAQ.html#how-do-i-deal-with-divergent-changes-after-the-change-id","title":"How do I deal with divergent changes ('??' after the change ID)?","text":"<p>A divergent change represents a change that has two or more visible commits associated with it. To refer to such commits, you must use their commit ID. Most commonly, the way to resolve this is to abandon the unneeded commits (using <code>jj abandon &lt;commit ID&gt;</code>). If you would like to keep both commits with this change ID, you can <code>jj duplicate</code> one of them before abandoning it.</p>"},{"location":"FAQ.html#how-do-i-deal-with-conflicted-bookmarks-after-bookmark-name","title":"How do I deal with conflicted bookmarks ('??' after bookmark name)?","text":"<p>A conflicted bookmark is a bookmark that refers to multiple different commits because jj couldn't fully resolve its desired position. Resolving conflicted bookmarks is usually done by setting the bookmark to the correct commit using <code>jj bookmark move &lt;name&gt; --to &lt;commit ID&gt;</code>.</p> <p>Usually, the different commits associated with the conflicted bookmark should all appear in the log, but if they don't you can use <code>jj bookmark list</code>to show all the commits associated with it.</p>"},{"location":"FAQ.html#how-do-i-integrate-jujutsu-with-gerrit","title":"How do I integrate Jujutsu with Gerrit?","text":"<p>At the moment you'll need a script, which adds the required fields for Gerrit like the <code>Change-Id</code> footer. Then <code>jj</code> can invoke it via an <code>$EDITOR</code> override in an aliased command. Here's an example from an contributor (look for the <code>jj signoff</code> alias).</p> <p>After you have attached the <code>Change-Id:</code> footer to the commit series, you'll have to manually invoke <code>git push</code> of <code>HEAD</code> on the underlying git repository into the remote Gerrit bookmark <code>refs/for/$BRANCH</code>, where <code>$BRANCH</code> is the base bookmark you want your changes to go to (e.g., <code>git push origin HEAD:refs/for/main</code>). Using a co-located repo will make the underlying git repo directly accessible from the working directory.</p> <p>We hope to integrate with Gerrit natively in the future.</p>"},{"location":"FAQ.html#i-want-to-write-a-tool-which-integrates-with-jujutsu-should-i-use-the-library-or-parse-the-cli","title":"I want to write a tool which integrates with Jujutsu. Should I use the library or parse the CLI?","text":"<p>There are some trade-offs and there is no definitive answer yet.</p> <ul> <li>Using <code>jj-lib</code> avoids parsing command output and makes error handling easier.</li> <li><code>jj-lib</code> is not a stable API, so you may have to make changes to your tool when the API changes.</li> <li>The CLI is not stable either, so you may need to make your tool detect the different versions and call the right command.</li> <li>Using the CLI means that your tool will work with custom-built <code>jj</code> binaries, like the one at Google (if you're using the library, you will not be able to detect custom backends and more).</li> </ul>"},{"location":"bookmarks.html","title":"Bookmarks","text":""},{"location":"bookmarks.html#introduction","title":"Introduction","text":"<p>Bookmarks are named pointers to revisions (just like branches are in Git). You can move them without affecting the target revision's identity. Bookmarks automatically move when revisions are rewritten (e.g. by <code>jj rebase</code>). You can pass a bookmark's name to commands that want a revision as argument. For example, <code>jj new main</code> will create a new revision on top of the <code>main</code> bookmark. Use <code>jj bookmark list</code> to list bookmarks and <code>jj bookmark &lt;subcommand&gt;</code> to create, move, or delete bookmarks. There is currently no concept of an active/current/checked-out bookmark.</p>"},{"location":"bookmarks.html#mapping-to-git-branches","title":"Mapping to Git branches","text":"<p>Jujutsu maps its bookmarks to Git branches when interacting with Git repos. For example, <code>jj git push --bookmark foo</code> will push the state of the <code>foo</code> bookmark to the <code>foo</code> branch on the Git remote. Similarly, if you create a <code>bar</code> branch in the backing Git repo, then a subsequent <code>jj git import</code> will create a <code>bar</code> bookmark (reminder: that import happens automatically in colocated repos).</p>"},{"location":"bookmarks.html#remotes-and-tracked-bookmarks","title":"Remotes and tracked bookmarks","text":"<p>Jujutsu records the last seen position of a bookmark on each remote (just like Git's remote-tracking branches). This record is updated on every <code>jj git fetch</code> and <code>jj git push</code> of the bookmark. You can refer to the remembered remote bookmark positions with <code>&lt;bookmark name&gt;@&lt;remote name&gt;</code>, such as <code>jj new main@origin</code>. <code>jj</code> does not provide a way to manually edit these recorded positions.</p> <p>A remote bookmark can be associated with a local bookmark of the same name. This is called a tracked remote bookmark (which maps to a Git remote branch when using the Git backend). When you pull a tracked bookmark from a remote, any changes compared to the current record of the remote's state will be propagated to the corresponding local bookmark, which will be created if it doesn't exist already.</p> <p>Details: how <code>fetch</code> pulls bookmarks</p> <p>Let's say you run <code>jj git fetch --remote origin</code> and, during the fetch, <code>jj</code> determines that the remote's <code>main</code> bookmark has been moved so that its target is now ahead of the local record in <code>main@origin</code>.</p> <p><code>jj</code> will then update <code>main@origin</code> to the new target. If <code>main@origin</code> is tracked, <code>jj</code> will also apply the change to the local bookmark <code>main</code>. If the local target has also been moved compared to <code>main@origin</code> (probably because you ran <code>jj bookmark set main</code>), then the two updates will be merged. If one is ahead of the other, then that target will become the new target. Otherwise, the local bookmark will become conflicted (see the \"Conflicts\" section below for details).</p> <p>Most commands don't show the tracked remote bookmark if it has the same target as the local bookmark. The local bookmark (without <code>@&lt;remote name&gt;</code>) is considered the bookmark's desired target. Consequently, if you want to update a bookmark on a remote, you first update the bookmark locally and then push the update to the remote. If a local bookmark also exists on some remote but points to a different target there, <code>jj log</code> will show the bookmark name with an asterisk suffix (e.g. <code>main*</code>). That is meant to remind you that you may want to push the bookmark to some remote.</p> <p>If you want to know the internals of bookmark tracking, consult the Design Doc.</p>"},{"location":"bookmarks.html#terminology-summary","title":"Terminology summary","text":"<ul> <li>A remote bookmark is a bookmark ref on the remote. <code>jj</code> can find out its   actual state only when it's actively communicating with the remote. However,   <code>jj</code> does store the last-seen position of the remote bookmark; this is the   commit <code>jj show &lt;bookmark name&gt;@&lt;remote name&gt;</code> would show. This notion is   completely analogous to Git's \"remote-tracking branches\".</li> <li>A tracked (remote) bookmark is defined above. You can make a remote bookmark   tracked with the <code>jj bookmark track</code> command, for   example.</li> <li>A tracking (local) bookmark is the local bookmark that <code>jj</code> tries to keep in   sync with the tracked remote bookmark. For example, after <code>jj bookmark track   mybookmark@origin</code>, there will be a local bookmark <code>mybookmark</code> that's tracking the   remote <code>mybookmark@origin</code> bookmark. A local bookmark can track a bookmark of the same   name on 0 or more remotes.</li> </ul> <p>The notion of tracked bookmarks serves a similar function to the Git notion of an \"upstream branch\". Unlike Git, a single local bookmark can be tracking remote bookmarks on multiple remotes, and the names of the local and remote bookmarks must match.</p>"},{"location":"bookmarks.html#manually-tracking-a-bookmark","title":"Manually tracking a bookmark","text":"<p>To track a bookmark permanently use <code>jj bookmark track &lt;bookmark name&gt;@&lt;remote name&gt;</code>. It will now be imported as a local bookmark until you untrack it or it is deleted on the remote.</p> <p>Example:</p> <pre><code>$ # List all available bookmarks, as we want our colleague's bookmark.\n$ jj bookmark list --all\n$ # Find the bookmark.\n$ # [...]\n$ # Actually track the bookmark.\n$ jj bookmark track &lt;bookmark name&gt;@&lt;remote name&gt; # Example: jj bookmark track my-feature@origin\n$ # From this point on, &lt;bookmark name&gt; will be imported when fetching from &lt;remote name&gt;.\n$ jj git fetch --remote &lt;remote name&gt;\n$ # A local bookmark &lt;bookmark name&gt; should have been created or updated while fetching.\n$ jj new &lt;bookmark name&gt; # Do some local testing, etc.\n</code></pre>"},{"location":"bookmarks.html#untracking-a-bookmark","title":"Untracking a bookmark","text":"<p>To stop following a remote bookmark, you can <code>jj bookmark untrack</code> it. After that, subsequent fetches of that remote will no longer move the local bookmark to match the position of the remote bookmark.</p> <p>Example:</p> <pre><code>$ # List all local and remote bookmarks.\n$ jj bookmark list --all\n$ # Find the bookmark we no longer want to track.\n$ # [...]\n# # Actually untrack it.\n$ jj bookmark untrack &lt;bookmark name&gt;@&lt;remote name&gt; # Example: jj bookmark untrack stuff@origin\n$ # From this point on, this remote bookmark won't be imported anymore.\n$ # The local bookmark (e.g. stuff) is unaffected. It may or may not still\n$ # be tracking bookmarks on other remotes (e.g. stuff@upstream).\n</code></pre>"},{"location":"bookmarks.html#listing-tracked-bookmarks","title":"Listing tracked bookmarks","text":"<p>To list tracked bookmarks, you can <code>jj bookmark list --tracked</code> or <code>jj bookmark list -t</code>. This command omits local Git-tracking bookmarks by default.</p> <p>You can see if a specific bookmark is tracked with <code>jj bookmark list --tracked &lt;bookmark name&gt;</code>.</p>"},{"location":"bookmarks.html#automatic-tracking-of-bookmarks-gitauto-local-bookmark-option","title":"Automatic tracking of bookmarks &amp; <code>git.auto-local-bookmark</code> option","text":"<p>There are two situations where <code>jj</code> tracks bookmarks automatically. <code>jj git clone</code> automatically sets up the default remote bookmark (e.g. <code>main@origin</code>) as tracked. When you push a local bookmark, the newly created bookmark on the remote is marked as tracked.</p> <p>By default, every other remote bookmark is marked as \"not tracked\" when it's fetched. If desired, you need to manually <code>jj bookmark track</code> them. This works well for repositories where multiple people work on a large number of bookmarks.</p> <p>The default can be changed by setting the config <code>git.auto-local-bookmark = true</code>. Then, <code>jj git fetch</code> tracks every newly fetched bookmark with a local bookmark. Branches that already existed before the <code>jj git fetch</code> are not affected. This is similar to Mercurial, which fetches all its bookmarks (equivalent to Git's branches) by default.</p>"},{"location":"bookmarks.html#bookmark-movement","title":"Bookmark movement","text":"<p>Currently Jujutsu automatically moves local bookmarks when these conditions are met:</p> <ul> <li>When a commit has been rewritten (e.g, when you rebase) bookmarks and the    working-copy will move along with it.</li> <li>When a commit has been abandoned, all associated bookmarks will be moved    to its parent(s). If a working copy was pointing to the abandoned commit,    then a new working-copy commit will be created on top of the parent(s).</li> </ul> <p>You could describe the movement as following along the change-id of the current bookmark commit, even if it isn't entirely accurate.</p>"},{"location":"bookmarks.html#pushing-bookmarks-safety-checks","title":"Pushing bookmarks: Safety checks","text":"<p>Before <code>jj git push</code> actually moves, creates, or deletes a remote bookmark, it makes several safety checks.</p> <ol> <li> <p><code>jj</code> will contact the remote and check that the actual state of the remote    bookmark matches <code>jj</code>'s record of its last known position. If there is a    conflict, <code>jj</code> will refuse to push the bookmark. In this case, you need to run    <code>jj git fetch --remote &lt;remote name&gt;</code> and resolve the resulting bookmark    conflict. Then, you can try <code>jj git push</code> again.</p> <p>If you are familiar with Git, this makes <code>jj git push</code> similar to <code>git  push --force-with-lease</code>.</p> <p>There are a few cases where <code>jj git push</code> will succeed even though the remote  bookmark is in an unexpected location. These are the cases where <code>jj git fetch</code>  would not create a bookmark conflict and would not move the local bookmark, e.g.  if the unexpected location is identical to the local position of the bookmark.</p> </li> <li> <p>The local bookmark must not be conflicted. If it is, you would    need to use <code>jj bookmark move</code>, for example, to resolve the conflict.</p> <p>This makes <code>jj git push</code> safe even if <code>jj git fetch</code> is performed on a timer  in the background (this situation is a known issue<sup>1</sup> with some  forms of <code>git push --force-with-lease</code>). If the bookmark moves on a remote in a  problematic way, <code>jj git fetch</code> will create a conflict. This should ensure  that the user becomes aware of the conflict before they can <code>jj git push</code> and  override the bookmark on the remote.</p> </li> <li> <p>If the remote bookmark already exists on the remote, it must be    tracked. If the bookmark does not already    exist on the remote, there is no problem; <code>jj git push --allow-new</code> will    create the remote bookmark and mark it as tracked.</p> </li> </ol>"},{"location":"bookmarks.html#conflicts","title":"Conflicts","text":"<p>Bookmarks can end up in a conflicted state. When that happens, <code>jj status</code> will include information about the conflicted bookmarks (and instructions for how to mitigate it). <code>jj bookmark list</code> will have details. <code>jj log</code> will show the bookmark name with a double question mark suffix (e.g. <code>main??</code>) on each of the conflicted bookmark's potential target revisions. Using the bookmark name to look up a revision will resolve to all potential targets. That means that <code>jj new main</code> will error out, complaining that the revset resolved to multiple revisions.</p> <p>Both local bookmarks (e.g. <code>main</code>) and the remote bookmark (e.g. <code>main@origin</code>) can have conflicts. Both can end up in that state if concurrent operations were run in the repo. The local bookmark more typically becomes conflicted because it was updated both locally and on a remote.</p> <p>To resolve a conflicted state in a local bookmark (e.g. <code>main</code>), you can move the bookmark to the desired target with <code>jj bookmark move</code>. You may want to first either merge the conflicted targets with <code>jj new</code> (e.g. <code>jj new 'all:main'</code>), or you may want to rebase one side on top of the other with <code>jj rebase</code>.</p> <p>To resolve a conflicted state in a remote bookmark (e.g. <code>main@origin</code>), simply pull from the remote (e.g. <code>jj git fetch</code>). The conflict resolution will also propagate to the local bookmark (which was presumably also conflicted).</p>"},{"location":"bookmarks.html#ease-of-use","title":"Ease of use","text":"<p>The use of bookmarks is frequent in some workflows, for example, when interacting with Git repositories containing branches. To this end, one-letter shortcuts have been implemented, both for the <code>jj bookmark</code> command itself through an alias (as <code>jj b</code>), and for its subcommands. For example, <code>jj bookmark create BOOKMARK-NAME</code> can be abbreviated as <code>jj b c BOOKMARK-NAME</code>.</p> <ol> <li> <p>See \"A general note on safety\" in https://git-scm.com/docs/git-push#Documentation/git-push.txt---no-force-with-lease \u21a9</p> </li> </ol>"},{"location":"cli-reference.html","title":"CLI Reference","text":"<p>Warning</p> <p>This CLI reference is experimental. It is automatically generated, but does not match the <code>jj help</code> output exactly.</p> <p>Run <code>jj help &lt;COMMAND&gt;</code> for more authoritative documentation.</p> <p>If you see a significant difference, feel free to file a bug, or a PR to note the difference here.</p>"},{"location":"cli-reference.html#command-line-help-for-jj","title":"Command-Line Help for <code>jj</code>","text":"<p>This document contains the help content for the <code>jj</code> command-line program.</p> <p>Command Overview:</p> <ul> <li><code>jj</code>\u21b4</li> <li><code>jj abandon</code>\u21b4</li> <li><code>jj absorb</code>\u21b4</li> <li><code>jj backout</code>\u21b4</li> <li><code>jj bookmark</code>\u21b4</li> <li><code>jj bookmark create</code>\u21b4</li> <li><code>jj bookmark delete</code>\u21b4</li> <li><code>jj bookmark forget</code>\u21b4</li> <li><code>jj bookmark list</code>\u21b4</li> <li><code>jj bookmark move</code>\u21b4</li> <li><code>jj bookmark rename</code>\u21b4</li> <li><code>jj bookmark set</code>\u21b4</li> <li><code>jj bookmark track</code>\u21b4</li> <li><code>jj bookmark untrack</code>\u21b4</li> <li><code>jj commit</code>\u21b4</li> <li><code>jj config</code>\u21b4</li> <li><code>jj config edit</code>\u21b4</li> <li><code>jj config get</code>\u21b4</li> <li><code>jj config list</code>\u21b4</li> <li><code>jj config path</code>\u21b4</li> <li><code>jj config set</code>\u21b4</li> <li><code>jj config unset</code>\u21b4</li> <li><code>jj describe</code>\u21b4</li> <li><code>jj diff</code>\u21b4</li> <li><code>jj diffedit</code>\u21b4</li> <li><code>jj duplicate</code>\u21b4</li> <li><code>jj edit</code>\u21b4</li> <li><code>jj evolog</code>\u21b4</li> <li><code>jj file</code>\u21b4</li> <li><code>jj file annotate</code>\u21b4</li> <li><code>jj file chmod</code>\u21b4</li> <li><code>jj file list</code>\u21b4</li> <li><code>jj file show</code>\u21b4</li> <li><code>jj file track</code>\u21b4</li> <li><code>jj file untrack</code>\u21b4</li> <li><code>jj fix</code>\u21b4</li> <li><code>jj git</code>\u21b4</li> <li><code>jj git clone</code>\u21b4</li> <li><code>jj git export</code>\u21b4</li> <li><code>jj git fetch</code>\u21b4</li> <li><code>jj git import</code>\u21b4</li> <li><code>jj git init</code>\u21b4</li> <li><code>jj git push</code>\u21b4</li> <li><code>jj git remote</code>\u21b4</li> <li><code>jj git remote add</code>\u21b4</li> <li><code>jj git remote list</code>\u21b4</li> <li><code>jj git remote remove</code>\u21b4</li> <li><code>jj git remote rename</code>\u21b4</li> <li><code>jj git remote set-url</code>\u21b4</li> <li><code>jj help</code>\u21b4</li> <li><code>jj init</code>\u21b4</li> <li><code>jj interdiff</code>\u21b4</li> <li><code>jj log</code>\u21b4</li> <li><code>jj new</code>\u21b4</li> <li><code>jj next</code>\u21b4</li> <li><code>jj operation</code>\u21b4</li> <li><code>jj operation abandon</code>\u21b4</li> <li><code>jj operation diff</code>\u21b4</li> <li><code>jj operation log</code>\u21b4</li> <li><code>jj operation restore</code>\u21b4</li> <li><code>jj operation show</code>\u21b4</li> <li><code>jj operation undo</code>\u21b4</li> <li><code>jj parallelize</code>\u21b4</li> <li><code>jj prev</code>\u21b4</li> <li><code>jj rebase</code>\u21b4</li> <li><code>jj resolve</code>\u21b4</li> <li><code>jj restore</code>\u21b4</li> <li><code>jj root</code>\u21b4</li> <li><code>jj show</code>\u21b4</li> <li><code>jj simplify-parents</code>\u21b4</li> <li><code>jj sparse</code>\u21b4</li> <li><code>jj sparse edit</code>\u21b4</li> <li><code>jj sparse list</code>\u21b4</li> <li><code>jj sparse reset</code>\u21b4</li> <li><code>jj sparse set</code>\u21b4</li> <li><code>jj split</code>\u21b4</li> <li><code>jj squash</code>\u21b4</li> <li><code>jj status</code>\u21b4</li> <li><code>jj tag</code>\u21b4</li> <li><code>jj tag list</code>\u21b4</li> <li><code>jj util</code>\u21b4</li> <li><code>jj util completion</code>\u21b4</li> <li><code>jj util config-schema</code>\u21b4</li> <li><code>jj util exec</code>\u21b4</li> <li><code>jj util gc</code>\u21b4</li> <li><code>jj util install-man-pages</code>\u21b4</li> <li><code>jj util markdown-help</code>\u21b4</li> <li><code>jj undo</code>\u21b4</li> <li><code>jj version</code>\u21b4</li> <li><code>jj workspace</code>\u21b4</li> <li><code>jj workspace add</code>\u21b4</li> <li><code>jj workspace forget</code>\u21b4</li> <li><code>jj workspace list</code>\u21b4</li> <li><code>jj workspace rename</code>\u21b4</li> <li><code>jj workspace root</code>\u21b4</li> <li><code>jj workspace update-stale</code>\u21b4</li> </ul>"},{"location":"cli-reference.html#jj","title":"<code>jj</code>","text":"<p>Jujutsu (An experimental VCS)</p> <p>To get started, see the tutorial at https://jj-vcs.github.io/jj/latest/tutorial/.</p> <p>Usage: <code>jj [OPTIONS] [COMMAND]</code></p> <p>'jj help --help' lists available keywords. Use 'jj help -k' to show help for one of these keywords.</p>"},{"location":"cli-reference.html#subcommands","title":"Subcommands:","text":"<ul> <li><code>abandon</code> \u2014 Abandon a revision</li> <li><code>absorb</code> \u2014 Move changes from a revision into the stack of mutable revisions</li> <li><code>backout</code> \u2014 Apply the reverse of a revision on top of another revision</li> <li><code>bookmark</code> \u2014 Manage bookmarks [default alias: b]</li> <li><code>commit</code> \u2014 Update the description and create a new change on top</li> <li><code>config</code> \u2014 Manage config options</li> <li><code>describe</code> \u2014 Update the change description or other metadata</li> <li><code>diff</code> \u2014 Compare file contents between two revisions</li> <li><code>diffedit</code> \u2014 Touch up the content changes in a revision with a diff editor</li> <li><code>duplicate</code> \u2014 Create new changes with the same content as existing ones</li> <li><code>edit</code> \u2014 Sets the specified revision as the working-copy revision</li> <li><code>evolog</code> \u2014 Show how a change has evolved over time</li> <li><code>file</code> \u2014 File operations</li> <li><code>fix</code> \u2014 Update files with formatting fixes or other changes</li> <li><code>git</code> \u2014 Commands for working with Git remotes and the underlying Git repo</li> <li><code>help</code> \u2014 Print this message or the help of the given subcommand(s)</li> <li><code>init</code> \u2014 Create a new repo in the given directory</li> <li><code>interdiff</code> \u2014 Compare the changes of two commits</li> <li><code>log</code> \u2014 Show revision history</li> <li><code>new</code> \u2014 Create a new, empty change and (by default) edit it in the working copy</li> <li><code>next</code> \u2014 Move the working-copy commit to the child revision</li> <li><code>operation</code> \u2014 Commands for working with the operation log</li> <li><code>parallelize</code> \u2014 Parallelize revisions by making them siblings</li> <li><code>prev</code> \u2014 Change the working copy revision relative to the parent revision</li> <li><code>rebase</code> \u2014 Move revisions to different parent(s)</li> <li><code>resolve</code> \u2014 Resolve conflicted files with an external merge tool</li> <li><code>restore</code> \u2014 Restore paths from another revision</li> <li><code>root</code> \u2014 Show the current workspace root directory</li> <li><code>show</code> \u2014 Show commit description and changes in a revision</li> <li><code>simplify-parents</code> \u2014 Simplify parent edges for the specified revision(s)</li> <li><code>sparse</code> \u2014 Manage which paths from the working-copy commit are present in the working copy</li> <li><code>split</code> \u2014 Split a revision in two</li> <li><code>squash</code> \u2014 Move changes from a revision into another revision</li> <li><code>status</code> \u2014 Show high-level repo status</li> <li><code>tag</code> \u2014 Manage tags</li> <li><code>util</code> \u2014 Infrequently used commands such as for generating shell completions</li> <li><code>undo</code> \u2014 Undo an operation (shortcut for <code>jj op undo</code>)</li> <li><code>version</code> \u2014 Display version information</li> <li><code>workspace</code> \u2014 Commands for working with workspaces</li> </ul>"},{"location":"cli-reference.html#options","title":"Options:","text":"<ul> <li> <p><code>-R</code>, <code>--repository &lt;REPOSITORY&gt;</code> \u2014 Path to repository to operate on</p> <p>By default, Jujutsu searches for the closest .jj/ directory in an ancestor of the current working directory.</p> </li> <li> <p><code>--ignore-working-copy</code> \u2014 Don't snapshot the working copy, and don't update it</p> <p>By default, Jujutsu snapshots the working copy at the beginning of every command. The working copy is also updated at the end of the command, if the command modified the working-copy commit (<code>@</code>). If you want to avoid snapshotting the working copy and instead see a possibly stale working-copy commit, you can use <code>--ignore-working-copy</code>. This may be useful e.g. in a command prompt, especially if you have another process that commits the working copy.</p> <p>Loading the repository at a specific operation with <code>--at-operation</code> implies <code>--ignore-working-copy</code>.</p> </li> <li> <p><code>--ignore-immutable</code> \u2014 Allow rewriting immutable commits</p> <p>By default, Jujutsu prevents rewriting commits in the configured set of immutable commits. This option disables that check and lets you rewrite any commit but the root commit.</p> <p>This option only affects the check. It does not affect the <code>immutable_heads()</code> revset or the <code>immutable</code> template keyword.</p> </li> <li> <p><code>--at-operation &lt;AT_OPERATION&gt;</code> \u2014 Operation to load the repo at</p> <p>Operation to load the repo at. By default, Jujutsu loads the repo at the most recent operation, or at the merge of the divergent operations if any.</p> <p>You can use <code>--at-op=&lt;operation ID&gt;</code> to see what the repo looked like at an earlier operation. For example <code>jj --at-op=&lt;operation ID&gt; st</code> will show you what <code>jj st</code> would have shown you when the given operation had just finished. <code>--at-op=@</code> is pretty much the same as the default except that divergent operations will never be merged.</p> <p>Use <code>jj op log</code> to find the operation ID you want. Any unambiguous prefix of the operation ID is enough.</p> <p>When loading the repo at an earlier operation, the working copy will be ignored, as if <code>--ignore-working-copy</code> had been specified.</p> <p>It is possible to run mutating commands when loading the repo at an earlier operation. Doing that is equivalent to having run concurrent commands starting at the earlier operation. There's rarely a reason to do that, but it is possible.</p> </li> <li> <p><code>--debug</code> \u2014 Enable debug logging</p> </li> <li> <p><code>--color &lt;WHEN&gt;</code> \u2014 When to colorize output</p> <p>Possible values: <code>always</code>, <code>never</code>, <code>debug</code>, <code>auto</code></p> </li> <li> <p><code>--quiet</code> \u2014 Silence non-primary command output</p> <p>For example, <code>jj file list</code> will still list files, but it won't tell you if the working copy was snapshotted or if descendants were rebased.</p> <p>Warnings and errors will still be printed.</p> </li> <li> <p><code>--no-pager</code> \u2014 Disable the pager</p> </li> <li> <p><code>--config &lt;NAME=VALUE&gt;</code> \u2014 Additional configuration options (can be repeated)</p> <p>The name should be specified as TOML dotted keys. The value should be specified as a TOML expression. If string value doesn't contain any TOML constructs (such as array notation), quotes can be omitted.</p> </li> <li> <p><code>--config-file &lt;PATH&gt;</code> \u2014 Additional configuration files (can be repeated)</p> </li> </ul>"},{"location":"cli-reference.html#jj-abandon","title":"<code>jj abandon</code>","text":"<p>Abandon a revision</p> <p>Abandon a revision, rebasing descendants onto its parent(s). The behavior is similar to <code>jj restore --changes-in</code>; the difference is that <code>jj abandon</code> gives you a new change, while <code>jj restore</code> updates the existing change.</p> <p>If a working-copy commit gets abandoned, it will be given a new, empty commit. This is true in general; it is not specific to this command.</p> <p>Usage: <code>jj abandon [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 The revision(s) to abandon (default: @)</li> </ul>"},{"location":"cli-reference.html#options_1","title":"Options:","text":"<ul> <li><code>-s</code>, <code>--summary</code> \u2014 Do not print every abandoned commit on a separate line</li> <li> <p><code>--retain-bookmarks</code> \u2014 Do not delete bookmarks pointing to the revisions to abandon</p> <p>Bookmarks will be moved to the parent revisions instead.</p> </li> <li> <p><code>--restore-descendants</code> \u2014 Do not modify the content of the children of the abandoned commits</p> </li> </ul>"},{"location":"cli-reference.html#jj-absorb","title":"<code>jj absorb</code>","text":"<p>Move changes from a revision into the stack of mutable revisions</p> <p>This command splits changes in the source revision and moves each change to the closest mutable ancestor where the corresponding lines were modified last. If the destination revision cannot be determined unambiguously, the change will be left in the source revision.</p> <p>The source revision will be abandoned if all changes are absorbed into the destination revisions, and if the source revision has no description.</p> <p>The modification made by <code>jj absorb</code> can be reviewed by <code>jj op show -p</code>.</p> <p>Usage: <code>jj absorb [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_1","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Move only changes to these paths (instead of all paths)</li> </ul>"},{"location":"cli-reference.html#options_2","title":"Options:","text":"<ul> <li> <p><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Source revision to absorb from</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-t</code>, <code>--into &lt;REVSETS&gt;</code> \u2014 Destination revisions to absorb into</p> <p>Only ancestors of the source revision will be considered.</p> <p>Default value: <code>mutable()</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-backout","title":"<code>jj backout</code>","text":"<p>Apply the reverse of a revision on top of another revision</p> <p>Usage: <code>jj backout [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_3","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 The revision(s) to apply the reverse of</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-d</code>, <code>--destination &lt;REVSETS&gt;</code> \u2014 The revision to apply the reverse changes on top of</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark","title":"<code>jj bookmark</code>","text":"<p>Manage bookmarks [default alias: b]</p> <p>See the bookmark documentation for more information.</p> <p>Usage: <code>jj bookmark &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_1","title":"Subcommands:","text":"<ul> <li><code>create</code> \u2014 Create a new bookmark</li> <li><code>delete</code> \u2014 Delete an existing bookmark and propagate the deletion to remotes on the next push</li> <li><code>forget</code> \u2014 Forget everything about a bookmark, including its local and remote targets</li> <li><code>list</code> \u2014 List bookmarks and their targets</li> <li><code>move</code> \u2014 Move existing bookmarks to target revision</li> <li><code>rename</code> \u2014 Rename <code>old</code> bookmark name to <code>new</code> bookmark name</li> <li><code>set</code> \u2014 Create or update a bookmark to point to a certain commit</li> <li><code>track</code> \u2014 Start tracking given remote bookmarks</li> <li><code>untrack</code> \u2014 Stop tracking given remote bookmarks</li> </ul>"},{"location":"cli-reference.html#jj-bookmark-create","title":"<code>jj bookmark create</code>","text":"<p>Create a new bookmark</p> <p>Usage: <code>jj bookmark create [OPTIONS] &lt;NAMES&gt;...</code></p>"},{"location":"cli-reference.html#arguments_2","title":"Arguments:","text":"<ul> <li><code>&lt;NAMES&gt;</code> \u2014 The bookmarks to create</li> </ul>"},{"location":"cli-reference.html#options_4","title":"Options:","text":"<ul> <li><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The bookmark's target revision</li> </ul>"},{"location":"cli-reference.html#jj-bookmark-delete","title":"<code>jj bookmark delete</code>","text":"<p>Delete an existing bookmark and propagate the deletion to remotes on the next push</p> <p>Revisions referred to by the deleted bookmarks are not abandoned. To delete revisions as well as bookmarks, use <code>jj abandon</code>. For example, <code>jj abandon main..&lt;bookmark&gt;</code> will abandon revisions belonging to the <code>&lt;bookmark&gt;</code> branch (relative to the <code>main</code> branch.)</p> <p>Usage: <code>jj bookmark delete &lt;NAMES&gt;...</code></p>"},{"location":"cli-reference.html#arguments_3","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 The bookmarks to delete</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to select bookmarks by wildcard pattern.</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-forget","title":"<code>jj bookmark forget</code>","text":"<p>Forget everything about a bookmark, including its local and remote targets</p> <p>A forgotten bookmark will not impact remotes on future pushes. It will be recreated on future pulls if it still exists in the remote.</p> <p>Usage: <code>jj bookmark forget &lt;NAMES&gt;...</code></p>"},{"location":"cli-reference.html#arguments_4","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 The bookmarks to forget</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to select bookmarks by wildcard pattern.</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-list","title":"<code>jj bookmark list</code>","text":"<p>List bookmarks and their targets</p> <p>By default, a tracking remote bookmark will be included only if its target is different from the local target. A non-tracking remote bookmark won't be listed. For a conflicted bookmark (both local and remote), old target revisions are preceded by a \"-\" and new target revisions are preceded by a \"+\".</p> <p>See the bookmark documentation for more information.</p> <p>Usage: <code>jj bookmark list [OPTIONS] [NAMES]...</code></p>"},{"location":"cli-reference.html#arguments_5","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 Show bookmarks whose local name matches</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to select bookmarks by wildcard pattern.</p> </li> </ul>"},{"location":"cli-reference.html#options_5","title":"Options:","text":"<ul> <li><code>-a</code>, <code>--all-remotes</code> \u2014 Show all tracking and non-tracking remote bookmarks including the ones whose targets are synchronized with the local bookmarks</li> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 Show all tracking and non-tracking remote bookmarks belonging to this remote</p> <p>Can be combined with <code>--tracked</code> or <code>--conflicted</code> to filter the bookmarks shown (can be repeated.)</p> <p>By default, the specified remote name matches exactly. Use <code>glob:</code> prefix to select remotes by wildcard pattern.</p> </li> <li> <p><code>-t</code>, <code>--tracked</code> \u2014 Show remote tracked bookmarks only. Omits local Git-tracking bookmarks by default</p> </li> <li><code>-c</code>, <code>--conflicted</code> \u2014 Show conflicted bookmarks only</li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Show bookmarks whose local targets are in the given revisions</p> <p>Note that <code>-r deleted_bookmark</code> will not work since <code>deleted_bookmark</code> wouldn't have a local target.</p> </li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each bookmark using the given template</p> <p>All 0-argument methods of the [<code>RefName</code> type] are available as keywords in the template expression.</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-move","title":"<code>jj bookmark move</code>","text":"<p>Move existing bookmarks to target revision</p> <p>If bookmark names are given, the specified bookmarks will be updated to point to the target revision.</p> <p>If <code>--from</code> options are given, bookmarks currently pointing to the specified revisions will be updated. The bookmarks can also be filtered by names.</p> <p>Example: pull up the nearest bookmarks to the working-copy parent</p> <p>$ jj bookmark move --from 'heads(::@- &amp; bookmarks())' --to @-</p> <p>Usage: <code>jj bookmark move [OPTIONS] &lt;--from &lt;REVSETS&gt;|NAMES&gt;</code></p>"},{"location":"cli-reference.html#arguments_6","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 Move bookmarks matching the given name patterns</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to select bookmarks by wildcard pattern.</p> </li> </ul>"},{"location":"cli-reference.html#options_6","title":"Options:","text":"<ul> <li><code>--from &lt;REVSETS&gt;</code> \u2014 Move bookmarks from the given revisions</li> <li> <p><code>--to &lt;REVSET&gt;</code> \u2014 Move bookmarks to this revision</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-B</code>, <code>--allow-backwards</code> \u2014 Allow moving bookmarks backwards or sideways</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-rename","title":"<code>jj bookmark rename</code>","text":"<p>Rename <code>old</code> bookmark name to <code>new</code> bookmark name</p> <p>The new bookmark name points at the same commit as the old bookmark name.</p> <p>Usage: <code>jj bookmark rename &lt;OLD&gt; &lt;NEW&gt;</code></p>"},{"location":"cli-reference.html#arguments_7","title":"Arguments:","text":"<ul> <li><code>&lt;OLD&gt;</code> \u2014 The old name of the bookmark</li> <li><code>&lt;NEW&gt;</code> \u2014 The new name of the bookmark</li> </ul>"},{"location":"cli-reference.html#jj-bookmark-set","title":"<code>jj bookmark set</code>","text":"<p>Create or update a bookmark to point to a certain commit</p> <p>Usage: <code>jj bookmark set [OPTIONS] &lt;NAMES&gt;...</code></p>"},{"location":"cli-reference.html#arguments_8","title":"Arguments:","text":"<ul> <li><code>&lt;NAMES&gt;</code> \u2014 The bookmarks to update</li> </ul>"},{"location":"cli-reference.html#options_7","title":"Options:","text":"<ul> <li><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The bookmark's target revision</li> <li><code>-B</code>, <code>--allow-backwards</code> \u2014 Allow moving the bookmark backwards or sideways</li> </ul>"},{"location":"cli-reference.html#jj-bookmark-track","title":"<code>jj bookmark track</code>","text":"<p>Start tracking given remote bookmarks</p> <p>A tracking remote bookmark will be imported as a local bookmark of the same name. Changes to it will propagate to the existing local bookmark on future pulls.</p> <p>Usage: <code>jj bookmark track &lt;BOOKMARK@REMOTE&gt;...</code></p>"},{"location":"cli-reference.html#arguments_9","title":"Arguments:","text":"<ul> <li> <p><code>&lt;BOOKMARK@REMOTE&gt;</code> \u2014 Remote bookmarks to track</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to select bookmarks by wildcard pattern.</p> <p>Examples: bookmark@remote, glob:main@, glob:jjfan-@upstream</p> </li> </ul>"},{"location":"cli-reference.html#jj-bookmark-untrack","title":"<code>jj bookmark untrack</code>","text":"<p>Stop tracking given remote bookmarks</p> <p>A non-tracking remote bookmark is just a pointer to the last-fetched remote bookmark. It won't be imported as a local bookmark on future pulls.</p> <p>Usage: <code>jj bookmark untrack &lt;BOOKMARK@REMOTE&gt;...</code></p>"},{"location":"cli-reference.html#arguments_10","title":"Arguments:","text":"<ul> <li> <p><code>&lt;BOOKMARK@REMOTE&gt;</code> \u2014 Remote bookmarks to untrack</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to select bookmarks by wildcard pattern.</p> <p>Examples: bookmark@remote, glob:main@, glob:jjfan-@upstream</p> </li> </ul>"},{"location":"cli-reference.html#jj-commit","title":"<code>jj commit</code>","text":"<p>Update the description and create a new change on top</p> <p>Usage: <code>jj commit [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_11","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Put these paths in the first commit</li> </ul>"},{"location":"cli-reference.html#options_8","title":"Options:","text":"<ul> <li><code>-i</code>, <code>--interactive</code> \u2014 Interactively choose which changes to include in the first commit</li> <li><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used (implies --interactive)</li> <li><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The change description to use (don't open editor)</li> <li> <p><code>--reset-author</code> \u2014 Reset the author to the configured user</p> <p>This resets the author name, email, and timestamp.</p> <p>You can use it in combination with the JJ_USER and JJ_EMAIL environment variables to set a different author:</p> <p>$ JJ_USER='Foo Bar' JJ_EMAIL=foo@bar.com jj commit --reset-author</p> </li> <li> <p><code>--author &lt;AUTHOR&gt;</code> \u2014 Set author to the provided string</p> <p>This changes author name and email while retaining author timestamp for non-discardable commits.</p> </li> </ul>"},{"location":"cli-reference.html#jj-config","title":"<code>jj config</code>","text":"<p>Manage config options</p> <p>Operates on jj configuration, which comes from the config file and environment variables.</p> <p>See the config documentation for file locations, supported config options, and other details about <code>jj config</code>.</p> <p>Usage: <code>jj config &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_2","title":"Subcommands:","text":"<ul> <li><code>edit</code> \u2014 Start an editor on a jj config file</li> <li><code>get</code> \u2014 Get the value of a given config option.</li> <li><code>list</code> \u2014 List variables set in config file, along with their values</li> <li><code>path</code> \u2014 Print the path to the config file</li> <li><code>set</code> \u2014 Update config file to set the given option to a given value</li> <li><code>unset</code> \u2014 Update config file to unset the given option</li> </ul>"},{"location":"cli-reference.html#jj-config-edit","title":"<code>jj config edit</code>","text":"<p>Start an editor on a jj config file.</p> <p>Creates the file if it doesn't already exist regardless of what the editor does.</p> <p>Usage: <code>jj config edit &lt;--user|--repo&gt;</code></p>"},{"location":"cli-reference.html#options_9","title":"Options:","text":"<ul> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> </ul>"},{"location":"cli-reference.html#jj-config-get","title":"<code>jj config get</code>","text":"<p>Get the value of a given config option.</p> <p>Unlike <code>jj config list</code>, the result of <code>jj config get</code> is printed without extra formatting and therefore is usable in scripting. For example:</p> <p>$ jj config list user.name user.name=\"Martin von Zweigbergk\" $ jj config get user.name Martin von Zweigbergk</p> <p>Usage: <code>jj config get &lt;NAME&gt;</code></p>"},{"location":"cli-reference.html#arguments_12","title":"Arguments:","text":"<ul> <li><code>&lt;NAME&gt;</code></li> </ul>"},{"location":"cli-reference.html#jj-config-list","title":"<code>jj config list</code>","text":"<p>List variables set in config file, along with their values</p> <p>Usage: <code>jj config list [OPTIONS] [NAME]</code></p>"},{"location":"cli-reference.html#arguments_13","title":"Arguments:","text":"<ul> <li><code>&lt;NAME&gt;</code> \u2014 An optional name of a specific config option to look up</li> </ul>"},{"location":"cli-reference.html#options_10","title":"Options:","text":"<ul> <li><code>--include-defaults</code> \u2014 Whether to explicitly include built-in default values in the list</li> <li><code>--include-overridden</code> \u2014 Allow printing overridden values</li> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each variable using the given template</p> <p>The following keywords are available in the template expression:</p> <ul> <li><code>name: String</code>: Config name.</li> <li><code>value: ConfigValue</code>: Value to be formatted in TOML syntax.</li> <li><code>overridden: Boolean</code>: True if the value is shadowed by other.</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-config-path","title":"<code>jj config path</code>","text":"<p>Print the path to the config file</p> <p>A config file at that path may or may not exist.</p> <p>See <code>jj config edit</code> if you'd like to immediately edit the file.</p> <p>Usage: <code>jj config path &lt;--user|--repo&gt;</code></p>"},{"location":"cli-reference.html#options_11","title":"Options:","text":"<ul> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> </ul>"},{"location":"cli-reference.html#jj-config-set","title":"<code>jj config set</code>","text":"<p>Update config file to set the given option to a given value</p> <p>Usage: <code>jj config set &lt;--user|--repo&gt; &lt;NAME&gt; &lt;VALUE&gt;</code></p>"},{"location":"cli-reference.html#arguments_14","title":"Arguments:","text":"<ul> <li><code>&lt;NAME&gt;</code></li> <li> <p><code>&lt;VALUE&gt;</code> \u2014 New value to set</p> <p>The value should be specified as a TOML expression. If string value doesn't contain any TOML constructs (such as array notation), quotes can be omitted.</p> </li> </ul>"},{"location":"cli-reference.html#options_12","title":"Options:","text":"<ul> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> </ul>"},{"location":"cli-reference.html#jj-config-unset","title":"<code>jj config unset</code>","text":"<p>Update config file to unset the given option</p> <p>Usage: <code>jj config unset &lt;--user|--repo&gt; &lt;NAME&gt;</code></p>"},{"location":"cli-reference.html#arguments_15","title":"Arguments:","text":"<ul> <li><code>&lt;NAME&gt;</code></li> </ul>"},{"location":"cli-reference.html#options_13","title":"Options:","text":"<ul> <li><code>--user</code> \u2014 Target the user-level config</li> <li><code>--repo</code> \u2014 Target the repo-level config</li> </ul>"},{"location":"cli-reference.html#jj-describe","title":"<code>jj describe</code>","text":"<p>Update the change description or other metadata</p> <p>Starts an editor to let you edit the description of changes. The editor will be $EDITOR, or <code>pico</code> if that's not defined (<code>Notepad</code> on Windows).</p> <p>Usage: <code>jj describe [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_16","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 The revision(s) whose description to edit (default: @)</li> </ul>"},{"location":"cli-reference.html#options_14","title":"Options:","text":"<ul> <li> <p><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The change description to use (don't open editor)</p> <p>If multiple revisions are specified, the same description will be used for all of them.</p> </li> <li> <p><code>--stdin</code> \u2014 Read the change description from stdin</p> <p>If multiple revisions are specified, the same description will be used for all of them.</p> </li> <li> <p><code>--no-edit</code> \u2014 Don't open an editor</p> <p>This is mainly useful in combination with e.g. <code>--reset-author</code>.</p> </li> <li> <p><code>--edit</code> \u2014 Open an editor</p> <p>Forces an editor to open when using <code>--stdin</code> or <code>--message</code> to allow the message to be edited afterwards.</p> </li> <li> <p><code>--reset-author</code> \u2014 Reset the author to the configured user</p> <p>This resets the author name, email, and timestamp.</p> <p>You can use it in combination with the JJ_USER and JJ_EMAIL environment variables to set a different author:</p> <p>$ JJ_USER='Foo Bar' JJ_EMAIL=foo@bar.com jj describe --reset-author</p> </li> <li> <p><code>--author &lt;AUTHOR&gt;</code> \u2014 Set author to the provided string</p> <p>This changes author name and email while retaining author timestamp for non-discardable commits.</p> </li> </ul>"},{"location":"cli-reference.html#jj-diff","title":"<code>jj diff</code>","text":"<p>Compare file contents between two revisions</p> <p>With the <code>-r</code> option, which is the default, shows the changes compared to the parent revision. If there are several parent revisions (i.e., the given revision is a merge), then they will be merged and the changes from the result to the given revision will be shown.</p> <p>With the <code>--from</code> and/or <code>--to</code> options, shows the difference from/to the given revisions. If either is left out, it defaults to the working-copy commit. For example, <code>jj diff --from main</code> shows the changes from \"main\" (perhaps a bookmark name) to the working-copy commit.</p> <p>Usage: <code>jj diff [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_17","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Restrict the diff to these paths</li> </ul>"},{"location":"cli-reference.html#options_15","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 Show changes in this revision, compared to its parent(s)</p> <p>If the revision is a merge commit, this shows changes from the automatic merge of the contents of all of its parents to the contents of the revision itself.</p> </li> <li> <p><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Show changes from this revision</p> </li> <li><code>-t</code>, <code>--to &lt;REVSET&gt;</code> \u2014 Show changes to this revision</li> <li><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</li> <li><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</li> <li><code>-w</code>, <code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>-b</code>, <code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-diffedit","title":"<code>jj diffedit</code>","text":"<p>Touch up the content changes in a revision with a diff editor</p> <p>With the <code>-r</code> option, which is the default, starts a diff editor on the changes in the revision.</p> <p>With the <code>--from</code> and/or <code>--to</code> options, starts a diff editor comparing the \"from\" revision to the \"to\" revision.</p> <p>Edit the right side of the diff until it looks the way you want. Once you close the editor, the revision specified with <code>-r</code> or <code>--to</code> will be updated. Unless <code>--restore-descendants</code> is used, descendants will be rebased on top as usual, which may result in conflicts.</p> <p>See <code>jj restore</code> if you want to move entire files from one revision to another. For moving changes between revisions, see <code>jj squash -i</code>.</p> <p>Usage: <code>jj diffedit [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_16","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to touch up</p> <p>Defaults to @ if neither --to nor --from are specified.</p> </li> <li> <p><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Show changes from this revision</p> <p>Defaults to @ if --to is specified.</p> </li> <li> <p><code>-t</code>, <code>--to &lt;REVSET&gt;</code> \u2014 Edit changes in this revision</p> <p>Defaults to @ if --from is specified.</p> </li> <li> <p><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used</p> </li> <li> <p><code>--restore-descendants</code> \u2014 Preserve the content (not the diff) when rebasing descendants</p> <p>When rebasing a descendant on top of the rewritten revision, its diff compared to its parent(s) is normally preserved, i.e. the same way that descendants are always rebased. This flag makes it so the content/state is preserved instead of preserving the diff.</p> </li> </ul>"},{"location":"cli-reference.html#jj-duplicate","title":"<code>jj duplicate</code>","text":"<p>Create new changes with the same content as existing ones</p> <p>When none of the <code>--destination</code>, <code>--insert-after</code>, or <code>--insert-before</code> arguments are provided, commits will be duplicated onto their existing parents or onto other newly duplicated commits.</p> <p>When any of the <code>--destination</code>, <code>--insert-after</code>, or <code>--insert-before</code> arguments are provided, the roots of the specified commits will be duplicated onto the destination indicated by the arguments. Other specified commits will be duplicated onto these newly duplicated commits. If the <code>--insert-after</code> or <code>--insert-before</code> arguments are provided, the new children indicated by the arguments will be rebased onto the heads of the specified commits.</p> <p>Usage: <code>jj duplicate [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_18","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 The revision(s) to duplicate (default: @)</li> </ul>"},{"location":"cli-reference.html#options_17","title":"Options:","text":"<ul> <li><code>-d</code>, <code>--destination &lt;REVSETS&gt;</code> \u2014 The revision(s) to duplicate onto (can be repeated to create a merge commit)</li> <li><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> \u2014 The revision(s) to insert after (can be repeated to create a merge commit)</li> <li><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> \u2014 The revision(s) to insert before (can be repeated to create a merge commit)</li> </ul>"},{"location":"cli-reference.html#jj-edit","title":"<code>jj edit</code>","text":"<p>Sets the specified revision as the working-copy revision</p> <p>Note: it is generally recommended to instead use <code>jj new</code> and <code>jj squash</code>.</p> <p>Usage: <code>jj edit &lt;REVSET&gt;</code></p>"},{"location":"cli-reference.html#arguments_19","title":"Arguments:","text":"<ul> <li><code>&lt;REVSET&gt;</code> \u2014 The commit to edit</li> </ul>"},{"location":"cli-reference.html#jj-evolog","title":"<code>jj evolog</code>","text":"<p>Show how a change has evolved over time</p> <p>Lists the previous commits which a change has pointed to. The current commit of a change evolves when the change is updated, rebased, etc.</p> <p>Usage: <code>jj evolog [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_18","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code></p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-n</code>, <code>--limit &lt;LIMIT&gt;</code> \u2014 Limit number of revisions to show</p> <p>Applied after revisions are reordered topologically, but before being reversed.</p> </li> <li> <p><code>--reversed</code> \u2014 Show revisions in the opposite order (older revisions first)</p> </li> <li><code>--no-graph</code> \u2014 Don't show the graph, show a flat list of revisions</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each revision using the given template</p> <p>Run <code>jj log -T</code> to list the built-in templates.</p> <p>You can also specify arbitrary [template expressions] using the built-in keywords.</p> </li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch compared to the previous version of this change</p> <p>If the previous version has different parents, it will be temporarily rebased to the parents of the new version, so the diff is not contaminated by unrelated changes.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</li> <li><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-file","title":"<code>jj file</code>","text":"<p>File operations</p> <p>Usage: <code>jj file &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_3","title":"Subcommands:","text":"<ul> <li><code>annotate</code> \u2014 Show the source change for each line of the target file</li> <li><code>chmod</code> \u2014 Sets or removes the executable bit for paths in the repo</li> <li><code>list</code> \u2014 List files in a revision</li> <li><code>show</code> \u2014 Print contents of files in a revision</li> <li><code>track</code> \u2014 Start tracking specified paths in the working copy</li> <li><code>untrack</code> \u2014 Stop tracking specified paths in the working copy</li> </ul>"},{"location":"cli-reference.html#jj-file-annotate","title":"<code>jj file annotate</code>","text":"<p>Show the source change for each line of the target file.</p> <p>Annotates a revision line by line. Each line includes the source change that introduced the associated line. A path to the desired file must be provided. The per-line prefix for each line can be customized via template with the <code>templates.annotate_commit_summary</code> config variable.</p> <p>Usage: <code>jj file annotate [OPTIONS] &lt;PATH&gt;</code></p>"},{"location":"cli-reference.html#arguments_20","title":"Arguments:","text":"<ul> <li><code>&lt;PATH&gt;</code> \u2014 the file to annotate</li> </ul>"},{"location":"cli-reference.html#options_19","title":"Options:","text":"<ul> <li><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 an optional revision to start at</li> </ul>"},{"location":"cli-reference.html#jj-file-chmod","title":"<code>jj file chmod</code>","text":"<p>Sets or removes the executable bit for paths in the repo</p> <p>Unlike the POSIX <code>chmod</code>, <code>jj file chmod</code> also works on Windows, on conflicted files, and on arbitrary revisions.</p> <p>Usage: <code>jj file chmod [OPTIONS] &lt;MODE&gt; &lt;FILESETS&gt;...</code></p>"},{"location":"cli-reference.html#arguments_21","title":"Arguments:","text":"<ul> <li> <p><code>&lt;MODE&gt;</code></p> <p>Possible values:</p> <ul> <li><code>n</code>:   Make a path non-executable (alias: normal)</li> <li><code>x</code>:   Make a path executable (alias: executable)</li> </ul> </li> <li> <p><code>&lt;FILESETS&gt;</code> \u2014 Paths to change the executable bit for</p> </li> </ul>"},{"location":"cli-reference.html#options_20","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to update</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-file-list","title":"<code>jj file list</code>","text":"<p>List files in a revision</p> <p>Usage: <code>jj file list [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_22","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Only list files matching these prefixes (instead of all files)</li> </ul>"},{"location":"cli-reference.html#options_21","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to list files in</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each file entry using the given template</p> <p>All 0-argument methods of the [<code>TreeEntry</code> type] are available as keywords in the template expression.</p> </li> </ul>"},{"location":"cli-reference.html#jj-file-show","title":"<code>jj file show</code>","text":"<p>Print contents of files in a revision</p> <p>If the given path is a directory, files in the directory will be visited recursively.</p> <p>Usage: <code>jj file show [OPTIONS] &lt;FILESETS&gt;...</code></p>"},{"location":"cli-reference.html#arguments_23","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Paths to print</li> </ul>"},{"location":"cli-reference.html#options_22","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to get the file contents from</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-file-track","title":"<code>jj file track</code>","text":"<p>Start tracking specified paths in the working copy</p> <p>Without arguments, all paths that are not ignored will be tracked.</p> <p>New files in the working copy can be automatically tracked. You can configure which paths to automatically track by setting <code>snapshot.auto-track</code> (e.g. to <code>\"none()\"</code> or <code>\"glob:**/*.rs\"</code>). Files that don't match the pattern can be manually tracked using this command. The default pattern is <code>all()</code> and this command has no effect.</p> <p>Usage: <code>jj file track &lt;FILESETS&gt;...</code></p>"},{"location":"cli-reference.html#arguments_24","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Paths to track</li> </ul>"},{"location":"cli-reference.html#jj-file-untrack","title":"<code>jj file untrack</code>","text":"<p>Stop tracking specified paths in the working copy</p> <p>Usage: <code>jj file untrack &lt;FILESETS&gt;...</code></p>"},{"location":"cli-reference.html#arguments_25","title":"Arguments:","text":"<ul> <li> <p><code>&lt;FILESETS&gt;</code> \u2014 Paths to untrack. They must already be ignored.</p> <p>The paths could be ignored via a .gitignore or .git/info/exclude (in colocated repos).</p> </li> </ul>"},{"location":"cli-reference.html#jj-fix","title":"<code>jj fix</code>","text":"<p>Update files with formatting fixes or other changes</p> <p>The primary use case for this command is to apply the results of automatic code formatting tools to revisions that may not be properly formatted yet. It can also be used to modify files with other tools like <code>sed</code> or <code>sort</code>.</p> <p>The changed files in the given revisions will be updated with any fixes determined by passing their file content through any external tools the user has configured for those files. Descendants will also be updated by passing their versions of the same files through the same tools, which will ensure that the fixes are not lost. This will never result in new conflicts. Files with existing conflicts will be updated on all sides of the conflict, which can potentially increase or decrease the number of conflict markers.</p> <p>The external tools must accept the current file content on standard input, and return the updated file content on standard output. A tool's output will not be used unless it exits with a successful exit code. Output on standard error will be passed through to the terminal.</p> <p>Tools are defined in a table where the keys are arbitrary identifiers and the values have the following properties:</p> <ul> <li><code>command</code>: The arguments used to run the tool. The first argument is the    path to an executable file. Arguments can contain the substring <code>$path</code>,    which will be replaced with the repo-relative path of the file being    fixed. It is useful to provide the path to tools that include the path in    error messages, or behave differently based on the directory or file    name.</li> <li><code>patterns</code>: Determines which files the tool will affect. If this list is    empty, no files will be affected by the tool. If there are multiple    patterns, the tool is applied only once to each file in the union of the    patterns.</li> <li><code>enabled</code>: Enables or disables the tool. If omitted, the tool is enabled.    This is useful for defining disabled tools in user configuration that can    be enabled in individual repositories with one config setting.</li> </ul> <p>For example, the following configuration defines how two code formatters (<code>clang-format</code> and <code>black</code>) will apply to three different file extensions (<code>.cc</code>, <code>.h</code>, and <code>.py</code>):</p> <pre><code>[fix.tools.clang-format]\ncommand = [\"/usr/bin/clang-format\", \"--assume-filename=$path\"]\npatterns = [\"glob:'**/*.cc'\",\n            \"glob:'**/*.h'\"]\n\n[fix.tools.black]\ncommand = [\"/usr/bin/black\", \"-\", \"--stdin-filename=$path\"]\npatterns = [\"glob:'**/*.py'\"]\n</code></pre> <p>Execution order of tools that affect the same file is deterministic, but currently unspecified, and may change between releases. If two tools affect the same file, the second tool to run will receive its input from the output of the first tool.</p> <p>Usage: <code>jj fix [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_26","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Fix only these paths</li> </ul>"},{"location":"cli-reference.html#options_23","title":"Options:","text":"<ul> <li><code>-s</code>, <code>--source &lt;REVSETS&gt;</code> \u2014 Fix files in the specified revision(s) and their descendants. If no revisions are specified, this defaults to the <code>revsets.fix</code> setting, or <code>reachable(@, mutable())</code> if it is not set</li> <li><code>--include-unchanged-files</code> \u2014 Fix unchanged files in addition to changed ones. If no paths are specified, all files in the repo will be fixed</li> </ul>"},{"location":"cli-reference.html#jj-git","title":"<code>jj git</code>","text":"<p>Commands for working with Git remotes and the underlying Git repo</p> <p>See this comparison, including a table of commands.</p> <p>Usage: <code>jj git &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_4","title":"Subcommands:","text":"<ul> <li><code>clone</code> \u2014 Create a new repo backed by a clone of a Git repo</li> <li><code>export</code> \u2014 Update the underlying Git repo with changes made in the repo</li> <li><code>fetch</code> \u2014 Fetch from a Git remote</li> <li><code>import</code> \u2014 Update repo with changes made in the underlying Git repo</li> <li><code>init</code> \u2014 Create a new Git backed repo</li> <li><code>push</code> \u2014 Push to a Git remote</li> <li><code>remote</code> \u2014 Manage Git remotes</li> </ul>"},{"location":"cli-reference.html#jj-git-clone","title":"<code>jj git clone</code>","text":"<p>Create a new repo backed by a clone of a Git repo</p> <p>The Git repo will be a bare git repo stored inside the <code>.jj/</code> directory.</p> <p>Usage: <code>jj git clone [OPTIONS] &lt;SOURCE&gt; [DESTINATION]</code></p>"},{"location":"cli-reference.html#arguments_27","title":"Arguments:","text":"<ul> <li> <p><code>&lt;SOURCE&gt;</code> \u2014 URL or path of the Git repo to clone</p> <p>Local path will be resolved to absolute form.</p> </li> <li> <p><code>&lt;DESTINATION&gt;</code> \u2014 Specifies the target directory for the Jujutsu repository clone. If not provided, defaults to a directory named after the last component of the source URL. The full directory path will be created if it doesn't exist</p> </li> </ul>"},{"location":"cli-reference.html#options_24","title":"Options:","text":"<ul> <li> <p><code>--remote &lt;REMOTE_NAME&gt;</code> \u2014 Name of the newly created remote</p> <p>Default value: <code>origin</code></p> </li> <li> <p><code>--colocate</code> \u2014 Whether or not to colocate the Jujutsu repo with the git repo</p> </li> <li><code>--depth &lt;DEPTH&gt;</code> \u2014 Create a shallow clone of the given depth</li> </ul>"},{"location":"cli-reference.html#jj-git-export","title":"<code>jj git export</code>","text":"<p>Update the underlying Git repo with changes made in the repo</p> <p>Usage: <code>jj git export</code></p>"},{"location":"cli-reference.html#jj-git-fetch","title":"<code>jj git fetch</code>","text":"<p>Fetch from a Git remote</p> <p>If a working-copy commit gets abandoned, it will be given a new, empty commit. This is true in general; it is not specific to this command.</p> <p>Usage: <code>jj git fetch [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_25","title":"Options:","text":"<ul> <li> <p><code>-b</code>, <code>--branch &lt;BRANCH&gt;</code> \u2014 Fetch only some of the branches</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to expand <code>*</code> as a glob, e.g. <code>--branch 'glob:push-*'</code>. Other wildcard characters such as <code>?</code> are not supported.</p> <p>Default value: <code>glob:*</code></p> </li> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 The remote to fetch from (only named remotes are supported, can be repeated)</p> <p>This defaults to the <code>git.fetch</code> setting. If that is not configured, and if there are multiple remotes, the remote named \"origin\" will be used.</p> </li> <li> <p><code>--all-remotes</code> \u2014 Fetch from all remotes</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-import","title":"<code>jj git import</code>","text":"<p>Update repo with changes made in the underlying Git repo</p> <p>If a working-copy commit gets abandoned, it will be given a new, empty commit. This is true in general; it is not specific to this command.</p> <p>Usage: <code>jj git import</code></p>"},{"location":"cli-reference.html#jj-git-init","title":"<code>jj git init</code>","text":"<p>Create a new Git backed repo</p> <p>Usage: <code>jj git init [OPTIONS] [DESTINATION]</code></p>"},{"location":"cli-reference.html#arguments_28","title":"Arguments:","text":"<ul> <li> <p><code>&lt;DESTINATION&gt;</code> \u2014 The destination directory where the <code>jj</code> repo will be created. If the directory does not exist, it will be created. If no directory is given, the current directory is used.</p> <p>By default the <code>git</code> repo is under <code>$destination/.jj</code></p> <p>Default value: <code>.</code></p> </li> </ul>"},{"location":"cli-reference.html#options_26","title":"Options:","text":"<ul> <li> <p><code>--colocate</code> \u2014 Specifies that the <code>jj</code> repo should also be a valid <code>git</code> repo, allowing the use of both <code>jj</code> and <code>git</code> commands in the same directory.</p> <p>This is done by placing the backing git repo into a <code>.git</code> directory in the root of the <code>jj</code> repo along with the <code>.jj</code> directory. If the <code>.git</code> directory already exists, all the existing commits will be imported.</p> <p>This option is mutually exclusive with <code>--git-repo</code>.</p> </li> <li> <p><code>--git-repo &lt;GIT_REPO&gt;</code> \u2014 Specifies a path to an existing git repository to be used as the backing git repo for the newly created <code>jj</code> repo.</p> <p>If the specified <code>--git-repo</code> path happens to be the same as the <code>jj</code> repo path (both .jj and .git directories are in the same working directory), then both <code>jj</code> and <code>git</code> commands will work on the same repo. This is called a co-located repo.</p> <p>This option is mutually exclusive with <code>--colocate</code>.</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-push","title":"<code>jj git push</code>","text":"<p>Push to a Git remote</p> <p>By default, pushes tracking bookmarks pointing to <code>remote_bookmarks(remote=&lt;remote&gt;)..@</code>. Use <code>--bookmark</code> to push specific bookmarks. Use <code>--all</code> to push all bookmarks. Use <code>--change</code> to generate bookmark names based on the change IDs of specific commits.</p> <p>Unlike in Git, the remote to push to is not derived from the tracked remote bookmarks. Use <code>--remote</code> to select the remote Git repository by name. There is no option to push to multiple remotes.</p> <p>Before the command actually moves, creates, or deletes a remote bookmark, it makes several [safety checks]. If there is a problem, you may need to run <code>jj git fetch --remote &lt;remote name&gt;</code> and/or resolve some [bookmark conflicts].</p> <p>[safety checks]: https://jj-vcs.github.io/jj/latest/bookmarks/#pushing-bookmarks-safety-checks [bookmark conflicts]: https://jj-vcs.github.io/jj/latest/bookmarks/#conflicts</p> <p>Usage: <code>jj git push [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_27","title":"Options:","text":"<ul> <li> <p><code>--remote &lt;REMOTE&gt;</code> \u2014 The remote to push to (only named remotes are supported)</p> <p>This defaults to the <code>git.push</code> setting. If that is not configured, and if there are multiple remotes, the remote named \"origin\" will be used.</p> </li> <li> <p><code>-b</code>, <code>--bookmark &lt;BOOKMARK&gt;</code> \u2014 Push only this bookmark, or bookmarks matching a pattern (can be repeated)</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to select bookmarks by wildcard pattern.</p> </li> <li> <p><code>--all</code> \u2014 Push all bookmarks (including new and deleted bookmarks)</p> </li> <li> <p><code>--tracked</code> \u2014 Push all tracked bookmarks (including deleted bookmarks)</p> <p>This usually means that the bookmark was already pushed to or fetched from the relevant remote.</p> </li> <li> <p><code>--deleted</code> \u2014 Push all deleted bookmarks</p> <p>Only tracked bookmarks can be successfully deleted on the remote. A warning will be printed if any untracked bookmarks on the remote correspond to missing local bookmarks.</p> </li> <li> <p><code>-N</code>, <code>--allow-new</code> \u2014 Allow pushing new bookmarks</p> <p>Newly-created remote bookmarks will be tracked automatically.</p> <p>This can also be turned on by the <code>git.push-new-bookmarks</code> setting. If it's set to <code>true</code>, <code>--allow-new</code> is no-op.</p> </li> <li> <p><code>--allow-empty-description</code> \u2014 Allow pushing commits with empty descriptions</p> </li> <li> <p><code>--allow-private</code> \u2014 Allow pushing commits that are private</p> <p>The set of private commits can be configured by the <code>git.private-commits</code> setting. The default is <code>none()</code>, meaning all commits are eligible to be pushed.</p> </li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Push bookmarks pointing to these commits (can be repeated)</p> </li> <li> <p><code>-c</code>, <code>--change &lt;REVSETS&gt;</code> \u2014 Push this commit by creating a bookmark based on its change ID (can be repeated)</p> <p>The created bookmark will be tracked automatically. Use the <code>git.push-bookmark-prefix</code> setting to change the prefix for generated names.</p> </li> <li> <p><code>--dry-run</code> \u2014 Only display what will change on the remote</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-remote","title":"<code>jj git remote</code>","text":"<p>Manage Git remotes</p> <p>The Git repo will be a bare git repo stored inside the <code>.jj/</code> directory.</p> <p>Usage: <code>jj git remote &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_5","title":"Subcommands:","text":"<ul> <li><code>add</code> \u2014 Add a Git remote</li> <li><code>list</code> \u2014 List Git remotes</li> <li><code>remove</code> \u2014 Remove a Git remote and forget its bookmarks</li> <li><code>rename</code> \u2014 Rename a Git remote</li> <li><code>set-url</code> \u2014 Set the URL of a Git remote</li> </ul>"},{"location":"cli-reference.html#jj-git-remote-add","title":"<code>jj git remote add</code>","text":"<p>Add a Git remote</p> <p>Usage: <code>jj git remote add &lt;REMOTE&gt; &lt;URL&gt;</code></p>"},{"location":"cli-reference.html#arguments_29","title":"Arguments:","text":"<ul> <li><code>&lt;REMOTE&gt;</code> \u2014 The remote's name</li> <li> <p><code>&lt;URL&gt;</code> \u2014 The remote's URL or path</p> <p>Local path will be resolved to absolute form.</p> </li> </ul>"},{"location":"cli-reference.html#jj-git-remote-list","title":"<code>jj git remote list</code>","text":"<p>List Git remotes</p> <p>Usage: <code>jj git remote list</code></p>"},{"location":"cli-reference.html#jj-git-remote-remove","title":"<code>jj git remote remove</code>","text":"<p>Remove a Git remote and forget its bookmarks</p> <p>Usage: <code>jj git remote remove &lt;REMOTE&gt;</code></p>"},{"location":"cli-reference.html#arguments_30","title":"Arguments:","text":"<ul> <li><code>&lt;REMOTE&gt;</code> \u2014 The remote's name</li> </ul>"},{"location":"cli-reference.html#jj-git-remote-rename","title":"<code>jj git remote rename</code>","text":"<p>Rename a Git remote</p> <p>Usage: <code>jj git remote rename &lt;OLD&gt; &lt;NEW&gt;</code></p>"},{"location":"cli-reference.html#arguments_31","title":"Arguments:","text":"<ul> <li><code>&lt;OLD&gt;</code> \u2014 The name of an existing remote</li> <li><code>&lt;NEW&gt;</code> \u2014 The desired name for <code>old</code></li> </ul>"},{"location":"cli-reference.html#jj-git-remote-set-url","title":"<code>jj git remote set-url</code>","text":"<p>Set the URL of a Git remote</p> <p>Usage: <code>jj git remote set-url &lt;REMOTE&gt; &lt;URL&gt;</code></p>"},{"location":"cli-reference.html#arguments_32","title":"Arguments:","text":"<ul> <li><code>&lt;REMOTE&gt;</code> \u2014 The remote's name</li> <li> <p><code>&lt;URL&gt;</code> \u2014 The desired URL or path for <code>remote</code></p> <p>Local path will be resolved to absolute form.</p> </li> </ul>"},{"location":"cli-reference.html#jj-help","title":"<code>jj help</code>","text":"<p>Print this message or the help of the given subcommand(s)</p> <p>Usage: <code>jj help [OPTIONS] [COMMAND]...</code></p>"},{"location":"cli-reference.html#arguments_33","title":"Arguments:","text":"<ul> <li><code>&lt;COMMAND&gt;</code> \u2014 Print help for the subcommand(s)</li> </ul>"},{"location":"cli-reference.html#options_28","title":"Options:","text":"<ul> <li> <p><code>-k</code>, <code>--keyword &lt;KEYWORD&gt;</code> \u2014 Show help for keywords instead of commands</p> <p>Possible values:</p> <ul> <li><code>bookmarks</code>:   Named pointers to revisions (similar to Git's branches)</li> <li><code>config</code>:   How and where to set configuration options</li> <li><code>filesets</code>:   A functional language for selecting a set of files</li> <li><code>glossary</code>:   Definitions of various terms</li> <li><code>revsets</code>:   A functional language for selecting a set of revision</li> <li><code>templates</code>:   A functional language to customize command output</li> <li><code>tutorial</code>:   Show a tutorial to get started with jj</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-init","title":"<code>jj init</code>","text":"<p>Create a new repo in the given directory</p> <p>If the given directory does not exist, it will be created. If no directory is given, the current directory is used.</p> <p>Usage: <code>jj init [DESTINATION]</code></p>"},{"location":"cli-reference.html#arguments_34","title":"Arguments:","text":"<ul> <li> <p><code>&lt;DESTINATION&gt;</code> \u2014 The destination directory</p> <p>Default value: <code>.</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-interdiff","title":"<code>jj interdiff</code>","text":"<p>Compare the changes of two commits</p> <p>This excludes changes from other commits by temporarily rebasing <code>--from</code> onto <code>--to</code>'s parents. If you wish to compare the same change across versions, consider <code>jj evolog -p</code> instead.</p> <p>Usage: <code>jj interdiff [OPTIONS] &lt;--from &lt;REVSET&gt;|--to &lt;REVSET&gt;&gt; [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_35","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Restrict the diff to these paths</li> </ul>"},{"location":"cli-reference.html#options_29","title":"Options:","text":"<ul> <li><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Show changes from this revision</li> <li><code>-t</code>, <code>--to &lt;REVSET&gt;</code> \u2014 Show changes to this revision</li> <li><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</li> <li><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</li> <li><code>-w</code>, <code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>-b</code>, <code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-log","title":"<code>jj log</code>","text":"<p>Show revision history</p> <p>Renders a graphical view of the project's history, ordered with children before parents. By default, the output only includes mutable revisions, along with some additional revisions for context. Use <code>jj log -r ::</code> to see all revisions. See [<code>jj help -k revsets</code>] for information about the syntax.</p> <p>Spans of revisions that are not included in the graph per <code>--revisions</code> are rendered as a synthetic node labeled \"(elided revisions)\".</p> <p>The working-copy commit is indicated by a <code>@</code> symbol in the graph. Immutable revisions have a <code>\u25c6</code> symbol. Other commits have a <code>\u25cb</code> symbol. All of these symbols can be customized.</p> <p>Usage: <code>jj log [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_36","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Show revisions modifying the given paths</li> </ul>"},{"location":"cli-reference.html#options_30","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Which revisions to show</p> <p>If no paths nor revisions are specified, this defaults to the <code>revsets.log</code> setting.</p> </li> <li> <p><code>-n</code>, <code>--limit &lt;LIMIT&gt;</code> \u2014 Limit number of revisions to show</p> <p>Applied after revisions are filtered and reordered topologically, but before being reversed.</p> </li> <li> <p><code>--reversed</code> \u2014 Show revisions in the opposite order (older revisions first)</p> </li> <li><code>--no-graph</code> \u2014 Don't show the graph, show a flat list of revisions</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each revision using the given template</p> <p>Run <code>jj log -T</code> to list the built-in templates.</p> <p>You can also specify arbitrary [template expressions] using the built-in keywords.</p> <p>If not specified, this defaults to the <code>templates.log</code> setting.</p> <p>template expression: https://jj-vcs.github.io/jj/latest/templates/ built-in keywords: https://jj-vcs.github.io/jj/latest/templates/#commit-keywords</p> </li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch</p> </li> <li><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</li> <li><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-new","title":"<code>jj new</code>","text":"<p>Create a new, empty change and (by default) edit it in the working copy</p> <p>By default, <code>jj</code> will edit the new change, making the working copy represent the new commit. This can be avoided with <code>--no-edit</code>.</p> <p>Note that you can create a merge commit by specifying multiple revisions as argument. For example, <code>jj new @ main</code> will create a new commit with the working copy and the <code>main</code> bookmark as parents.</p> <p>Usage: <code>jj new [OPTIONS] [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_37","title":"Arguments:","text":"<ul> <li> <p><code>&lt;REVSETS&gt;</code> \u2014 Parent(s) of the new change</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#options_31","title":"Options:","text":"<ul> <li><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The change description to use</li> <li><code>--no-edit</code> \u2014 Do not edit the newly created change</li> <li><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> \u2014 Insert the new change after the given commit(s)</li> <li><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> \u2014 Insert the new change before the given commit(s)</li> </ul>"},{"location":"cli-reference.html#jj-next","title":"<code>jj next</code>","text":"<p>Move the working-copy commit to the child revision</p> <p>The command creates a new empty working copy revision that is the child of a descendant <code>offset</code> revisions ahead of the parent of the current working copy.</p> <p>For example, when the offset is 1:</p> <pre><code>D        D @\n|        |/\nC @  =&gt;  C\n|/       |\nB        B\n</code></pre> <p>If <code>--edit</code> is passed, the working copy revision is changed to the child of the current working copy revision.</p> <pre><code>D        D\n|        |\nC        C\n|        |\nB   =&gt;   @\n|        |\n@        A\n</code></pre> <p>Usage: <code>jj next [OPTIONS] [OFFSET]</code></p>"},{"location":"cli-reference.html#arguments_38","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OFFSET&gt;</code> \u2014 How many revisions to move forward. Advances to the next child by default</p> <p>Default value: <code>1</code></p> </li> </ul>"},{"location":"cli-reference.html#options_32","title":"Options:","text":"<ul> <li> <p><code>-e</code>, <code>--edit</code> \u2014 Instead of creating a new working-copy commit on top of the target commit (like <code>jj new</code>), edit the target commit directly (like <code>jj edit</code>)</p> <p>Takes precedence over config in <code>ui.movement.edit</code>; i.e. will negate <code>ui.movement.edit = false</code></p> </li> <li> <p><code>-n</code>, <code>--no-edit</code> \u2014 The inverse of <code>--edit</code></p> <p>Takes precedence over config in <code>ui.movement.edit</code>; i.e. will negate <code>ui.movement.edit = true</code></p> </li> <li> <p><code>--conflict</code> \u2014 Jump to the next conflicted descendant</p> </li> </ul>"},{"location":"cli-reference.html#jj-operation","title":"<code>jj operation</code>","text":"<p>Commands for working with the operation log</p> <p>See the operation log documentation for more information.</p> <p>Usage: <code>jj operation &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_6","title":"Subcommands:","text":"<ul> <li><code>abandon</code> \u2014 Abandon operation history</li> <li><code>diff</code> \u2014 Compare changes to the repository between two operations</li> <li><code>log</code> \u2014 Show the operation log</li> <li><code>restore</code> \u2014 Create a new operation that restores the repo to an earlier state</li> <li><code>show</code> \u2014 Show changes to the repository in an operation</li> <li><code>undo</code> \u2014 Create a new operation that undoes an earlier operation</li> </ul>"},{"location":"cli-reference.html#jj-operation-abandon","title":"<code>jj operation abandon</code>","text":"<p>Abandon operation history</p> <p>To discard old operation history, use <code>jj op abandon ..&lt;operation ID&gt;</code>. It will abandon the specified operation and all its ancestors. The descendants will be reparented onto the root operation.</p> <p>To discard recent operations, use <code>jj op restore &lt;operation ID&gt;</code> followed by <code>jj op abandon &lt;operation ID&gt;..@-</code>.</p> <p>The abandoned operations, commits, and other unreachable objects can later be garbage collected by using <code>jj util gc</code> command.</p> <p>Usage: <code>jj operation abandon &lt;OPERATION&gt;</code></p>"},{"location":"cli-reference.html#arguments_39","title":"Arguments:","text":"<ul> <li><code>&lt;OPERATION&gt;</code> \u2014 The operation or operation range to abandon</li> </ul>"},{"location":"cli-reference.html#jj-operation-diff","title":"<code>jj operation diff</code>","text":"<p>Compare changes to the repository between two operations</p> <p>Usage: <code>jj operation diff [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_33","title":"Options:","text":"<ul> <li><code>--operation &lt;OPERATION&gt;</code> \u2014 Show repository changes in this operation, compared to its parent</li> <li><code>-f</code>, <code>--from &lt;FROM&gt;</code> \u2014 Show repository changes from this operation</li> <li><code>-t</code>, <code>--to &lt;TO&gt;</code> \u2014 Show repository changes to this operation</li> <li><code>--no-graph</code> \u2014 Don't show the graph, show a flat list of modified changes</li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch of modifications to changes</p> <p>If the previous version has different parents, it will be temporarily rebased to the parents of the new version, so the diff is not contaminated by unrelated changes.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</li> <li><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-operation-log","title":"<code>jj operation log</code>","text":"<p>Show the operation log</p> <p>Like other commands, <code>jj op log</code> snapshots the current working-copy changes and reconciles divergent operations. Use <code>--at-op=@ --ignore-working-copy</code> to inspect the current state without mutation.</p> <p>Usage: <code>jj operation log [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_34","title":"Options:","text":"<ul> <li> <p><code>-n</code>, <code>--limit &lt;LIMIT&gt;</code> \u2014 Limit number of operations to show</p> <p>Applied after operations are reordered topologically, but before being reversed.</p> </li> <li> <p><code>--reversed</code> \u2014 Show operations in the opposite order (older operations first)</p> </li> <li><code>--no-graph</code> \u2014 Don't show the graph, show a flat list of operations</li> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each operation using the given template</p> <p>You can specify arbitrary [template expressions] using the built-in keywords.</p> </li> <li> <p><code>--op-diff</code> \u2014 Show changes to the repository at each operation</p> </li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch of modifications to changes (implies --op-diff)</p> <p>If the previous version has different parents, it will be temporarily rebased to the parents of the new version, so the diff is not contaminated by unrelated changes.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</li> <li><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-operation-restore","title":"<code>jj operation restore</code>","text":"<p>Create a new operation that restores the repo to an earlier state</p> <p>This restores the repo to the state at the specified operation, effectively undoing all later operations. It does so by creating a new operation.</p> <p>Usage: <code>jj operation restore [OPTIONS] &lt;OPERATION&gt;</code></p>"},{"location":"cli-reference.html#arguments_40","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OPERATION&gt;</code> \u2014 The operation to restore to</p> <p>Use <code>jj op log</code> to find an operation to restore to. Use e.g. <code>jj --at-op=&lt;operation ID&gt; log</code> before restoring to an operation to see the state of the repo at that operation.</p> </li> </ul>"},{"location":"cli-reference.html#options_35","title":"Options:","text":"<ul> <li> <p><code>--what &lt;WHAT&gt;</code> \u2014 What portions of the local state to restore (can be repeated)</p> <p>This option is EXPERIMENTAL.</p> <p>Default values: <code>repo</code>, <code>remote-tracking</code></p> <p>Possible values:</p> <ul> <li><code>repo</code>:   The jj repo state and local bookmarks</li> <li><code>remote-tracking</code>:   The remote-tracking bookmarks. Do not restore these if you'd like to push after the undo</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-operation-show","title":"<code>jj operation show</code>","text":"<p>Show changes to the repository in an operation</p> <p>Usage: <code>jj operation show [OPTIONS] [OPERATION]</code></p>"},{"location":"cli-reference.html#arguments_41","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OPERATION&gt;</code> \u2014 Show repository changes in this operation, compared to its parent(s)</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#options_36","title":"Options:","text":"<ul> <li><code>--no-graph</code> \u2014 Don't show the graph, show a flat list of modified changes</li> <li> <p><code>-p</code>, <code>--patch</code> \u2014 Show patch of modifications to changes</p> <p>If the previous version has different parents, it will be temporarily rebased to the parents of the new version, so the diff is not contaminated by unrelated changes.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</li> <li><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-operation-undo","title":"<code>jj operation undo</code>","text":"<p>Create a new operation that undoes an earlier operation</p> <p>This undoes an individual operation by applying the inverse of the operation.</p> <p>Usage: <code>jj operation undo [OPTIONS] [OPERATION]</code></p>"},{"location":"cli-reference.html#arguments_42","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OPERATION&gt;</code> \u2014 The operation to undo</p> <p>Use <code>jj op log</code> to find an operation to undo.</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#options_37","title":"Options:","text":"<ul> <li> <p><code>--what &lt;WHAT&gt;</code> \u2014 What portions of the local state to restore (can be repeated)</p> <p>This option is EXPERIMENTAL.</p> <p>Default values: <code>repo</code>, <code>remote-tracking</code></p> <p>Possible values:</p> <ul> <li><code>repo</code>:   The jj repo state and local bookmarks</li> <li><code>remote-tracking</code>:   The remote-tracking bookmarks. Do not restore these if you'd like to push after the undo</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-parallelize","title":"<code>jj parallelize</code>","text":"<p>Parallelize revisions by making them siblings</p> <p>Running <code>jj parallelize 1::2</code> will transform the history like this: <pre><code>3\n|             3\n2            / \\\n|    -&gt;     1   2\n1            \\ /\n|             0\n0\n</code></pre></p> <p>The command effectively says \"these revisions are actually independent\", meaning that they should no longer be ancestors/descendants of each other. However, revisions outside the set that were previously ancestors of a revision in the set will remain ancestors of it. For example, revision 0 above remains an ancestor of both 1 and 2. Similarly, revisions outside the set that were previously descendants of a revision in the set will remain descendants of it. For example, revision 3 above remains a descendant of both 1 and 2.</p> <p>Therefore, <code>jj parallelize '1 | 3'</code> is a no-op. That's because 2, which is not in the target set, was a descendant of 1 before, so it remains a descendant, and it was an ancestor of 3 before, so it remains an ancestor.</p> <p>Usage: <code>jj parallelize [REVSETS]...</code></p>"},{"location":"cli-reference.html#arguments_43","title":"Arguments:","text":"<ul> <li><code>&lt;REVSETS&gt;</code> \u2014 Revisions to parallelize</li> </ul>"},{"location":"cli-reference.html#jj-prev","title":"<code>jj prev</code>","text":"<p>Change the working copy revision relative to the parent revision</p> <p>The command creates a new empty working copy revision that is the child of an ancestor <code>offset</code> revisions behind the parent of the current working copy.</p> <p>For example, when the offset is 1:</p> <pre><code>D @      D\n|/       |\nA   =&gt;   A @\n|        |/\nB        B\n</code></pre> <p>If <code>--edit</code> is passed, the working copy revision is changed to the parent of the current working copy revision.</p> <pre><code>D @      D\n|/       |\nC   =&gt;   @\n|        |\nB        B\n|        |\nA        A\n</code></pre> <p>Usage: <code>jj prev [OPTIONS] [OFFSET]</code></p>"},{"location":"cli-reference.html#arguments_44","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OFFSET&gt;</code> \u2014 How many revisions to move backward. Moves to the parent by default</p> <p>Default value: <code>1</code></p> </li> </ul>"},{"location":"cli-reference.html#options_38","title":"Options:","text":"<ul> <li> <p><code>-e</code>, <code>--edit</code> \u2014 Edit the parent directly, instead of moving the working-copy commit</p> <p>Takes precedence over config in <code>ui.movement.edit</code>; i.e. will negate <code>ui.movement.edit = false</code></p> </li> <li> <p><code>-n</code>, <code>--no-edit</code> \u2014 The inverse of <code>--edit</code></p> <p>Takes precedence over config in <code>ui.movement.edit</code>; i.e. will negate <code>ui.movement.edit = true</code></p> </li> <li> <p><code>--conflict</code> \u2014 Jump to the previous conflicted ancestor</p> </li> </ul>"},{"location":"cli-reference.html#jj-rebase","title":"<code>jj rebase</code>","text":"<p>Move revisions to different parent(s)</p> <p>This command moves revisions to different parent(s) while preserving the changes (diff) in the revisions.</p> <p>There are three different ways of specifying which revisions to rebase:</p> <ul> <li><code>--source/-s</code> to rebase a revision and its descendants</li> <li><code>--branch/-b</code> to rebase a whole branch, relative to the destination</li> <li><code>--revisions/-r</code> to rebase the specified revisions without their   descendants</li> </ul> <p>If no option is specified, it defaults to <code>-b @</code>.</p> <p>There are three different ways of specifying where the revisions should be rebased to:</p> <ul> <li><code>--destination/-d</code> to rebase the revisions onto the specified targets</li> <li><code>--insert-after/-A</code> to rebase the revisions onto the specified targets and   to rebase the targets' descendants onto the rebased revisions</li> <li><code>--insert-before/-B</code> to rebase the revisions onto the specified targets'   parents and to rebase the targets and their descendants onto the rebased   revisions</li> </ul> <p>See the sections below for details about the different ways of specifying which revisions to rebase where.</p> <p>If a working-copy revision gets abandoned, it will be given a new, empty revision. This is true in general; it is not specific to this command.</p>"},{"location":"cli-reference.html#specifying-which-revisions-to-rebase","title":"Specifying which revisions to rebase","text":"<p>With <code>--source/-s</code>, the command rebases the specified revision and its descendants onto the destination. For example, <code>jj rebase -s M -d O</code> would transform your history like this (letters followed by an apostrophe are post-rebase versions):</p> <pre><code>O           N'\n|           |\n| N         M'\n| |         |\n| M         O\n| |    =&gt;   |\n| | L       | L\n| |/        | |\n| K         | K\n|/          |/\nJ           J\n</code></pre> <p>Each revision passed to <code>-s</code> will become a direct child of the destination, so if you instead run <code>jj rebase -s M -s N -d O</code> (or <code>jj rebase -s 'all:M|N' -d O</code>) in the example above, then N' would instead be a direct child of O.</p> <p>With <code>--branch/-b</code>, the command rebases the whole \"branch\" containing the specified revision. A \"branch\" is the set of revisions that includes:</p> <ul> <li>the specified revision and ancestors that are not also ancestors of the   destination</li> <li>all descendants of those revisions</li> </ul> <p>In other words, <code>jj rebase -b X -d Y</code> rebases revisions in the revset <code>(Y..X)::</code> (which is equivalent to <code>jj rebase -s 'roots(Y..X)' -d Y</code> for a single root). For example, either <code>jj rebase -b L -d O</code> or <code>jj rebase -b M -d O</code> would transform your history like this (because <code>L</code> and <code>M</code> are on the same \"branch\", relative to the destination):</p> <pre><code>O           N'\n|           |\n| N         M'\n| |         |\n| M         | L'\n| |    =&gt;   |/\n| | L       K'\n| |/        |\n| K         O\n|/          |\nJ           J\n</code></pre> <p>With <code>--revisions/-r</code>, the command rebases only the specified revisions onto the destination. Any \"hole\" left behind will be filled by rebasing descendants onto the specified revisions' parent(s). For example, <code>jj rebase -r K -d M</code> would transform your history like this:</p> <pre><code>M          K'\n|          |\n| L        M\n| |   =&gt;   |\n| K        | L'\n|/         |/\nJ          J\n</code></pre> <p>Multiple revisions can be specified, and any dependencies (graph edges) within the set will be preserved. For example, <code>jj rebase -r 'K|N' -d O</code> would transform your history like this:</p> <pre><code>O           N'\n|           |\n| N         K'\n| |         |\n| M         O\n| |    =&gt;   |\n| | L       | M'\n| |/        |/\n| K         | L'\n|/          |/\nJ           J\n</code></pre> <p><code>jj rebase -s X</code> is similar to <code>jj rebase -r X::</code> and will behave the same if X is a single revision. However, if X is a set of multiple revisions, or if you passed multiple <code>-s</code> arguments, then <code>jj rebase -s</code> will make each of the specified revisions an immediate child of the destination, while <code>jj rebase -r</code> will preserve dependencies within the set.</p> <p>Note that you can create a merge revision by repeating the <code>-d</code> argument. For example, if you realize that revision L actually depends on revision M in order to work (in addition to its current parent K), you can run <code>jj rebase -s L -d K -d M</code>:</p> <pre><code>M          L'\n|          |\\\n| L        M |\n| |   =&gt;   | |\n| K        | K\n|/         |/\nJ          J\n</code></pre>"},{"location":"cli-reference.html#specifying-where-to-rebase-the-revisions","title":"Specifying where to rebase the revisions","text":"<p>With <code>--destination/-d</code>, the command rebases the selected revisions onto the targets. Existing descendants of the targets will not be affected. See the section above for examples.</p> <p>With <code>--insert-after/-A</code>, the selected revisions will be inserted after the targets. This is similar to <code>-d</code>, but if the targets have any existing descendants, then those will be rebased onto the rebased selected revisions.</p> <p>For example, <code>jj rebase -r K -A L</code> will rewrite history like this: <pre><code>N           N'\n|           |\n| M         | M'\n|/          |/\nL      =&gt;   K'\n|           |\n| K         L\n|/          |\nJ           J\n</code></pre></p> <p>The <code>-A</code> (and <code>-B</code>) argument can also be used for reordering revisions. For example, <code>jj rebase -r M -A J</code> will rewrite history like this: <pre><code>M          L'\n|          |\nL          K'\n|     =&gt;   |\nK          M'\n|          |\nJ          J\n</code></pre></p> <p>With <code>--insert-before/-B</code>, the selected revisions will be inserted before the targets. This is achieved by rebasing the selected revisions onto the target revisions' parents, and then rebasing the target revisions and their descendants onto the rebased revisions.</p> <p>For example, <code>jj rebase -r K -B L</code> will rewrite history like this: <pre><code>N           N'\n|           |\n| M         | M'\n|/          |/\nL     =&gt;    L'\n|           |\n| K         K'\n|/          |\nJ           J\n</code></pre></p> <p>The <code>-A</code> and <code>-B</code> arguments can also be combined, which can be useful around merges. For example, you can use <code>jj rebase -r K -A J -B M</code> to create a new merge (but <code>jj rebase -r M -d L -d K</code> might be simpler in this particular case): <pre><code>M           M'\n|           |\\\nL           L |\n|     =&gt;    | |\n| K         | K'\n|/          |/\nJ           J\n</code></pre></p> <p>To insert a commit inside an existing merge with <code>jj rebase -r O -A K -B M</code>: <pre><code>O           N'\n|           |\\\nN           | M'\n|\\          | |\\\n| M         | O'|\n| |    =&gt;   |/ /\n| L         | L\n| |         | |\nK |         K |\n|/          |/\nJ           J\n</code></pre></p> <p>Usage: <code>jj rebase [OPTIONS] &lt;--destination &lt;REVSETS&gt;|--insert-after &lt;REVSETS&gt;|--insert-before &lt;REVSETS&gt;&gt;</code></p>"},{"location":"cli-reference.html#options_39","title":"Options:","text":"<ul> <li> <p><code>-b</code>, <code>--branch &lt;REVSETS&gt;</code> \u2014 Rebase the whole branch relative to destination's ancestors (can be repeated)</p> <p><code>jj rebase -b=br -d=dst</code> is equivalent to <code>jj rebase '-s=roots(dst..br)' -d=dst</code>.</p> <p>If none of <code>-b</code>, <code>-s</code>, or <code>-r</code> is provided, then the default is <code>-b @</code>.</p> </li> <li> <p><code>-s</code>, <code>--source &lt;REVSETS&gt;</code> \u2014 Rebase specified revision(s) together with their trees of descendants (can be repeated)</p> <p>Each specified revision will become a direct child of the destination revision(s), even if some of the source revisions are descendants of others.</p> <p>If none of <code>-b</code>, <code>-s</code>, or <code>-r</code> is provided, then the default is <code>-b @</code>.</p> </li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Rebase the given revisions, rebasing descendants onto this revision's parent(s)</p> <p>Unlike <code>-s</code> or <code>-b</code>, you may <code>jj rebase -r</code> a revision <code>A</code> onto a descendant of <code>A</code>.</p> <p>If none of <code>-b</code>, <code>-s</code>, or <code>-r</code> is provided, then the default is <code>-b @</code>.</p> </li> <li> <p><code>-d</code>, <code>--destination &lt;REVSETS&gt;</code> \u2014 The revision(s) to rebase onto (can be repeated to create a merge commit)</p> </li> <li><code>-A</code>, <code>--insert-after &lt;REVSETS&gt;</code> \u2014 The revision(s) to insert after (can be repeated to create a merge commit)</li> <li><code>-B</code>, <code>--insert-before &lt;REVSETS&gt;</code> \u2014 The revision(s) to insert before (can be repeated to create a merge commit)</li> <li><code>--skip-emptied</code> \u2014 If true, when rebasing would produce an empty commit, the commit is abandoned. It will not be abandoned if it was already empty before the rebase. Will never skip merge commits with multiple non-empty parents</li> </ul>"},{"location":"cli-reference.html#jj-resolve","title":"<code>jj resolve</code>","text":"<p>Resolve conflicted files with an external merge tool</p> <p>Only conflicts that can be resolved with a 3-way merge are supported. See docs for merge tool configuration instructions. External merge tools will be invoked for each conflicted file one-by-one until all conflicts are resolved. To stop resolving conflicts, exit the merge tool without making any changes.</p> <p>Note that conflicts can also be resolved without using this command. You may edit the conflict markers in the conflicted file directly with a text editor.</p> <p>Usage: <code>jj resolve [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_45","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Only resolve conflicts in these paths. You can use the <code>--list</code> argument to find paths to use here</li> </ul>"},{"location":"cli-reference.html#options_40","title":"Options:","text":"<ul> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code></p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-l</code>, <code>--list</code> \u2014 Instead of resolving conflicts, list all the conflicts</p> </li> <li><code>--tool &lt;NAME&gt;</code> \u2014 Specify 3-way merge tool to be used</li> </ul>"},{"location":"cli-reference.html#jj-restore","title":"<code>jj restore</code>","text":"<p>Restore paths from another revision</p> <p>That means that the paths get the same content in the destination (<code>--to</code>) as they had in the source (<code>--from</code>). This is typically used for undoing changes to some paths in the working copy (<code>jj restore &lt;paths&gt;</code>).</p> <p>If only one of <code>--from</code> or <code>--to</code> is specified, the other one defaults to the working copy.</p> <p>When neither <code>--from</code> nor <code>--to</code> is specified, the command restores into the working copy from its parent(s). <code>jj restore</code> without arguments is similar to <code>jj abandon</code>, except that it leaves an empty revision with its description and other metadata preserved.</p> <p>See <code>jj diffedit</code> if you'd like to restore portions of files rather than entire files.</p> <p>Usage: <code>jj restore [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_46","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Restore only these paths (instead of all paths)</li> </ul>"},{"location":"cli-reference.html#options_41","title":"Options:","text":"<ul> <li><code>-f</code>, <code>--from &lt;REVSET&gt;</code> \u2014 Revision to restore from (source)</li> <li><code>-t</code>, <code>--into &lt;REVSETS&gt;</code> \u2014 Revision to restore into (destination)</li> <li> <p><code>-c</code>, <code>--changes-in &lt;REVSET&gt;</code> \u2014 Undo the changes in a revision as compared to the merge of its parents.</p> <p>This undoes the changes that can be seen with <code>jj diff -r REVSET</code>. If <code>REVSET</code> only has a single parent, this option is equivalent to <code>jj restore --into REVSET --from REVSET-</code>.</p> <p>The default behavior of <code>jj restore</code> is equivalent to <code>jj restore --changes-in @</code>.</p> </li> <li> <p><code>-i</code>, <code>--interactive</code> \u2014 Interactively choose which parts to restore</p> </li> <li><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used (implies --interactive)</li> <li><code>--restore-descendants</code> \u2014 Preserve the content (not the diff) when rebasing descendants</li> </ul>"},{"location":"cli-reference.html#jj-root","title":"<code>jj root</code>","text":"<p>Show the current workspace root directory</p> <p>Usage: <code>jj root</code></p>"},{"location":"cli-reference.html#jj-show","title":"<code>jj show</code>","text":"<p>Show commit description and changes in a revision</p> <p>Usage: <code>jj show [OPTIONS] [REVSET]</code></p>"},{"location":"cli-reference.html#arguments_47","title":"Arguments:","text":"<ul> <li> <p><code>&lt;REVSET&gt;</code> \u2014 Show changes in this revision, compared to its parent(s)</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#options_42","title":"Options:","text":"<ul> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render a revision using the given template</p> <p>You can specify arbitrary [template expressions] using the built-in keywords.</p> </li> <li> <p><code>-s</code>, <code>--summary</code> \u2014 For each path, show only whether it was modified, added, or deleted</p> </li> <li><code>--stat</code> \u2014 Show a histogram of the changes</li> <li> <p><code>--types</code> \u2014 For each path, show only its type before and after</p> <p>The diff is shown as two letters. The first letter indicates the type before and the second letter indicates the type after. '-' indicates that the path was not present, 'F' represents a regular file, `L' represents a symlink, 'C' represents a conflict, and 'G' represents a Git submodule.</p> </li> <li> <p><code>--name-only</code> \u2014 For each path, show only its path</p> <p>Typically useful for shell commands like: <code>jj diff -r @- --name-only | xargs perl -pi -e's/OLD/NEW/g</code></p> </li> <li> <p><code>--git</code> \u2014 Show a Git-format diff</p> </li> <li><code>--color-words</code> \u2014 Show a word-level diff with changes indicated only by color</li> <li><code>--tool &lt;TOOL&gt;</code> \u2014 Generate diff by external command</li> <li><code>--context &lt;CONTEXT&gt;</code> \u2014 Number of lines of context to show</li> <li><code>--ignore-all-space</code> \u2014 Ignore whitespace when comparing lines</li> <li><code>--ignore-space-change</code> \u2014 Ignore changes in amount of whitespace when comparing lines</li> </ul>"},{"location":"cli-reference.html#jj-simplify-parents","title":"<code>jj simplify-parents</code>","text":"<p>Simplify parent edges for the specified revision(s).</p> <p>Removes all parents of each of the specified revisions that are also indirect ancestors of the same revisions through other parents. This has no effect on any revision's contents, including the working copy.</p> <p>In other words, for all (A, B, C) where A has (B, C) as parents and C is an ancestor of B, A will be rewritten to have only B as a parent instead of B+C.</p> <p>Usage: <code>jj simplify-parents [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_43","title":"Options:","text":"<ul> <li><code>-s</code>, <code>--source &lt;REVSETS&gt;</code> \u2014 Simplify specified revision(s) together with their trees of descendants (can be repeated)</li> <li> <p><code>-r</code>, <code>--revisions &lt;REVSETS&gt;</code> \u2014 Simplify specified revision(s) (can be repeated)</p> <p>If both <code>--source</code> and <code>--revisions</code> are not provided, this defaults to the <code>revsets.simplify-parents</code> setting, or <code>reachable(@, mutable())</code> if it is not set.</p> </li> </ul>"},{"location":"cli-reference.html#jj-sparse","title":"<code>jj sparse</code>","text":"<p>Manage which paths from the working-copy commit are present in the working copy</p> <p>Usage: <code>jj sparse &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_7","title":"Subcommands:","text":"<ul> <li><code>edit</code> \u2014 Start an editor to update the patterns that are present in the working copy</li> <li><code>list</code> \u2014 List the patterns that are currently present in the working copy</li> <li><code>reset</code> \u2014 Reset the patterns to include all files in the working copy</li> <li><code>set</code> \u2014 Update the patterns that are present in the working copy</li> </ul>"},{"location":"cli-reference.html#jj-sparse-edit","title":"<code>jj sparse edit</code>","text":"<p>Start an editor to update the patterns that are present in the working copy</p> <p>Usage: <code>jj sparse edit</code></p>"},{"location":"cli-reference.html#jj-sparse-list","title":"<code>jj sparse list</code>","text":"<p>List the patterns that are currently present in the working copy</p> <p>By default, a newly cloned or initialized repo will have have a pattern matching all files from the repo root. That pattern is rendered as <code>.</code> (a single period).</p> <p>Usage: <code>jj sparse list</code></p>"},{"location":"cli-reference.html#jj-sparse-reset","title":"<code>jj sparse reset</code>","text":"<p>Reset the patterns to include all files in the working copy</p> <p>Usage: <code>jj sparse reset</code></p>"},{"location":"cli-reference.html#jj-sparse-set","title":"<code>jj sparse set</code>","text":"<p>Update the patterns that are present in the working copy</p> <p>For example, if all you need is the <code>README.md</code> and the <code>lib/</code> directory, use <code>jj sparse set --clear --add README.md --add lib</code>. If you no longer need the <code>lib</code> directory, use <code>jj sparse set --remove lib</code>.</p> <p>Usage: <code>jj sparse set [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_44","title":"Options:","text":"<ul> <li><code>--add &lt;ADD&gt;</code> \u2014 Patterns to add to the working copy</li> <li><code>--remove &lt;REMOVE&gt;</code> \u2014 Patterns to remove from the working copy</li> <li><code>--clear</code> \u2014 Include no files in the working copy (combine with --add)</li> </ul>"},{"location":"cli-reference.html#jj-split","title":"<code>jj split</code>","text":"<p>Split a revision in two</p> <p>Starts a diff editor on the changes in the revision. Edit the right side of the diff until it has the content you want in the first revision. Once you close the editor, your edited content will replace the previous revision. The remaining changes will be put in a new revision on top.</p> <p>If the change you split had a description, you will be asked to enter a change description for each commit. If the change did not have a description, the second part will not get a description, and you will be asked for a description only for the first part.</p> <p>Splitting an empty commit is not supported because the same effect can be achieved with <code>jj new</code>.</p> <p>Usage: <code>jj split [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_48","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Files matching any of these filesets are put in the first commit</li> </ul>"},{"location":"cli-reference.html#options_45","title":"Options:","text":"<ul> <li> <p><code>-i</code>, <code>--interactive</code> \u2014 Interactively choose which parts to split</p> <p>This is the default if no filesets are provided.</p> </li> <li> <p><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used (implies --interactive)</p> </li> <li> <p><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 The revision to split</p> <p>Default value: <code>@</code></p> </li> <li> <p><code>-p</code>, <code>--parallel</code> \u2014 Split the revision into two parallel revisions instead of a parent and child</p> </li> </ul>"},{"location":"cli-reference.html#jj-squash","title":"<code>jj squash</code>","text":"<p>Move changes from a revision into another revision</p> <p>With the <code>-r</code> option, moves the changes from the specified revision to the parent revision. Fails if there are several parent revisions (i.e., the given revision is a merge).</p> <p>With the <code>--from</code> and/or <code>--into</code> options, moves changes from/to the given revisions. If either is left out, it defaults to the working-copy commit. For example, <code>jj squash --into @--</code> moves changes from the working-copy commit to the grandparent.</p> <p>If, after moving changes out, the source revision is empty compared to its parent(s), and <code>--keep-emptied</code> is not set, it will be abandoned. Without <code>--interactive</code> or paths, the source revision will always be empty.</p> <p>If the source was abandoned and both the source and destination had a non-empty description, you will be asked for the combined description. If either was empty, then the other one will be used.</p> <p>If a working-copy commit gets abandoned, it will be given a new, empty commit. This is true in general; it is not specific to this command.</p> <p>Usage: <code>jj squash [OPTIONS] [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_49","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Move only changes to these paths (instead of all paths)</li> </ul>"},{"location":"cli-reference.html#options_46","title":"Options:","text":"<ul> <li><code>-r</code>, <code>--revision &lt;REVSET&gt;</code> \u2014 Revision to squash into its parent (default: @)</li> <li><code>-f</code>, <code>--from &lt;REVSETS&gt;</code> \u2014 Revision(s) to squash from (default: @)</li> <li><code>-t</code>, <code>--into &lt;REVSET&gt;</code> \u2014 Revision to squash into (default: @)</li> <li><code>-m</code>, <code>--message &lt;MESSAGE&gt;</code> \u2014 The description to use for squashed revision (don't open editor)</li> <li><code>-u</code>, <code>--use-destination-message</code> \u2014 Use the description of the destination revision and discard the description(s) of the source revision(s)</li> <li><code>-i</code>, <code>--interactive</code> \u2014 Interactively choose which parts to squash</li> <li><code>--tool &lt;NAME&gt;</code> \u2014 Specify diff editor to be used (implies --interactive)</li> <li><code>-k</code>, <code>--keep-emptied</code> \u2014 The source revision will not be abandoned</li> </ul>"},{"location":"cli-reference.html#jj-status","title":"<code>jj status</code>","text":"<p>Show high-level repo status</p> <p>This includes:</p> <ul> <li>The working copy commit and its (first) parent, and a summary of the changes between them * Conflicted bookmarks</li> </ul> <p>Usage: <code>jj status [FILESETS]...</code></p>"},{"location":"cli-reference.html#arguments_50","title":"Arguments:","text":"<ul> <li><code>&lt;FILESETS&gt;</code> \u2014 Restrict the status display to these paths</li> </ul>"},{"location":"cli-reference.html#jj-tag","title":"<code>jj tag</code>","text":"<p>Manage tags</p> <p>Usage: <code>jj tag &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_8","title":"Subcommands:","text":"<ul> <li><code>list</code> \u2014 List tags</li> </ul>"},{"location":"cli-reference.html#jj-tag-list","title":"<code>jj tag list</code>","text":"<p>List tags</p> <p>Usage: <code>jj tag list [OPTIONS] [NAMES]...</code></p>"},{"location":"cli-reference.html#arguments_51","title":"Arguments:","text":"<ul> <li> <p><code>&lt;NAMES&gt;</code> \u2014 Show tags whose local name matches</p> <p>By default, the specified name matches exactly. Use <code>glob:</code> prefix to select tags by wildcard pattern.</p> </li> </ul>"},{"location":"cli-reference.html#options_47","title":"Options:","text":"<ul> <li> <p><code>-T</code>, <code>--template &lt;TEMPLATE&gt;</code> \u2014 Render each tag using the given template</p> <p>All 0-argument methods of the [<code>RefName</code> type] are available as keywords in the template expression.</p> </li> </ul>"},{"location":"cli-reference.html#jj-util","title":"<code>jj util</code>","text":"<p>Infrequently used commands such as for generating shell completions</p> <p>Usage: <code>jj util &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_9","title":"Subcommands:","text":"<ul> <li><code>completion</code> \u2014 Print a command-line-completion script</li> <li><code>config-schema</code> \u2014 Print the JSON schema for the jj TOML config format</li> <li><code>exec</code> \u2014 Execute an external command via jj</li> <li><code>gc</code> \u2014 Run backend-dependent garbage collection</li> <li><code>install-man-pages</code> \u2014 Install Jujutsu's manpages to the provided path</li> <li><code>markdown-help</code> \u2014 Print the CLI help for all subcommands in Markdown</li> </ul>"},{"location":"cli-reference.html#jj-util-completion","title":"<code>jj util completion</code>","text":"<p>Print a command-line-completion script</p> <p>Apply it by running one of these:</p> <ul> <li>Bash: <code>source &lt;(jj util completion bash)</code></li> <li>Fish: <code>jj util completion fish | source</code></li> <li>Nushell:     <pre><code>jj util completion nushell | save \"completions-jj.nu\"\nuse \"completions-jj.nu\" *  # Or `source \"completions-jj.nu\"`\n</code></pre></li> <li>Zsh:     <pre><code>autoload -U compinit\ncompinit\nsource &lt;(jj util completion zsh)\n</code></pre></li> </ul> <p>Usage: <code>jj util completion [SHELL]</code></p>"},{"location":"cli-reference.html#arguments_52","title":"Arguments:","text":"<ul> <li> <p><code>&lt;SHELL&gt;</code></p> <p>Possible values: <code>bash</code>, <code>elvish</code>, <code>fish</code>, <code>nushell</code>, <code>power-shell</code>, <code>zsh</code></p> </li> </ul>"},{"location":"cli-reference.html#jj-util-config-schema","title":"<code>jj util config-schema</code>","text":"<p>Print the JSON schema for the jj TOML config format</p> <p>Usage: <code>jj util config-schema</code></p>"},{"location":"cli-reference.html#jj-util-exec","title":"<code>jj util exec</code>","text":"<p>Execute an external command via jj</p> <p>This is useful for arbitrary aliases.</p> <p>!! WARNING !!</p> <p>The following technique just provides a convenient syntax for running arbitrary code on your system. Using it irresponsibly may cause damage ranging from breaking the behavior of <code>jj undo</code> to wiping your file system. Exercise the same amount of caution while writing these aliases as you would when typing commands into the terminal!</p> <p>This feature may be removed or replaced by an embedded scripting language in the future.</p> <p>Let's assume you have a script called \"my-jj-script\" in you $PATH and you would like to execute it as \"jj my-script\". You would add the following line to your configuration file to achieve that:</p> <pre><code>[aliases]\nmy-script = [\"util\", \"exec\", \"--\", \"my-jj-script\"]\n#                            ^^^^\n# This makes sure that flags are passed to your script instead of parsed by jj.\n</code></pre> <p>If you don't want to manage your script as a separate file, you can even inline it into your config file:</p> <pre><code>[aliases]\nmy-inline-script = [\"util\", \"exec\", \"--\", \"bash\", \"-c\", \"\"\"\n#!/usr/bin/env bash\nset -euo pipefail\necho \"Look Ma, everything in one file!\"\necho \"args: $@\"\n\"\"\", \"\"]\n#    ^^\n# This last empty string will become \"$0\" in bash, so your actual arguments\n# are all included in \"$@\" and start at \"$1\" as expected.\n</code></pre> <p>Usage: <code>jj util exec &lt;COMMAND&gt; [ARGS]...</code></p>"},{"location":"cli-reference.html#arguments_53","title":"Arguments:","text":"<ul> <li><code>&lt;COMMAND&gt;</code> \u2014 External command to execute</li> <li><code>&lt;ARGS&gt;</code> \u2014 Arguments to pass to the external command</li> </ul>"},{"location":"cli-reference.html#jj-util-gc","title":"<code>jj util gc</code>","text":"<p>Run backend-dependent garbage collection.</p> <p>To garbage-collect old operations and the commits/objects referenced by then, run <code>jj op abandon ..&lt;some old operation&gt;</code> before <code>jj util gc</code>.</p> <p>Previous versions of a change that are reachable via the evolution log are not garbage-collected.</p> <p>Usage: <code>jj util gc [OPTIONS]</code></p>"},{"location":"cli-reference.html#options_48","title":"Options:","text":"<ul> <li> <p><code>--expire &lt;EXPIRE&gt;</code> \u2014 Time threshold</p> <p>By default, only obsolete objects and operations older than 2 weeks are pruned.</p> <p>Only the string \"now\" can be passed to this parameter. Support for arbitrary absolute and relative timestamps will come in a subsequent release.</p> </li> </ul>"},{"location":"cli-reference.html#jj-util-install-man-pages","title":"<code>jj util install-man-pages</code>","text":"<p>Install Jujutsu's manpages to the provided path</p> <p>Usage: <code>jj util install-man-pages &lt;PATH&gt;</code></p>"},{"location":"cli-reference.html#arguments_54","title":"Arguments:","text":"<ul> <li><code>&lt;PATH&gt;</code> \u2014 The path where manpages will installed. An example path might be <code>/usr/share/man</code>. The provided path will be appended with <code>man1</code>, etc., as appropriate</li> </ul>"},{"location":"cli-reference.html#jj-util-markdown-help","title":"<code>jj util markdown-help</code>","text":"<p>Print the CLI help for all subcommands in Markdown</p> <p>Usage: <code>jj util markdown-help</code></p>"},{"location":"cli-reference.html#jj-undo","title":"<code>jj undo</code>","text":"<p>Undo an operation (shortcut for <code>jj op undo</code>)</p> <p>Usage: <code>jj undo [OPTIONS] [OPERATION]</code></p>"},{"location":"cli-reference.html#arguments_55","title":"Arguments:","text":"<ul> <li> <p><code>&lt;OPERATION&gt;</code> \u2014 The operation to undo</p> <p>Use <code>jj op log</code> to find an operation to undo.</p> <p>Default value: <code>@</code></p> </li> </ul>"},{"location":"cli-reference.html#options_49","title":"Options:","text":"<ul> <li> <p><code>--what &lt;WHAT&gt;</code> \u2014 What portions of the local state to restore (can be repeated)</p> <p>This option is EXPERIMENTAL.</p> <p>Default values: <code>repo</code>, <code>remote-tracking</code></p> <p>Possible values:</p> <ul> <li><code>repo</code>:   The jj repo state and local bookmarks</li> <li><code>remote-tracking</code>:   The remote-tracking bookmarks. Do not restore these if you'd like to push after the undo</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-version","title":"<code>jj version</code>","text":"<p>Display version information</p> <p>Usage: <code>jj version</code></p>"},{"location":"cli-reference.html#jj-workspace","title":"<code>jj workspace</code>","text":"<p>Commands for working with workspaces</p> <p>Workspaces let you add additional working copies attached to the same repo. A common use case is so you can run a slow build or test in one workspace while you're continuing to write code in another workspace.</p> <p>Each workspace has its own working-copy commit. When you have more than one workspace attached to a repo, they are indicated by <code>&lt;workspace name&gt;@</code> in <code>jj log</code>.</p> <p>Each workspace also has own sparse patterns.</p> <p>Usage: <code>jj workspace &lt;COMMAND&gt;</code></p>"},{"location":"cli-reference.html#subcommands_10","title":"Subcommands:","text":"<ul> <li><code>add</code> \u2014 Add a workspace</li> <li><code>forget</code> \u2014 Stop tracking a workspace's working-copy commit in the repo</li> <li><code>list</code> \u2014 List workspaces</li> <li><code>rename</code> \u2014 Renames the current workspace</li> <li><code>root</code> \u2014 Show the current workspace root directory</li> <li><code>update-stale</code> \u2014 Update a workspace that has become stale</li> </ul>"},{"location":"cli-reference.html#jj-workspace-add","title":"<code>jj workspace add</code>","text":"<p>Add a workspace</p> <p>By default, the new workspace inherits the sparse patterns of the current workspace. You can override this with the <code>--sparse-patterns</code> option.</p> <p>Usage: <code>jj workspace add [OPTIONS] &lt;DESTINATION&gt;</code></p>"},{"location":"cli-reference.html#arguments_56","title":"Arguments:","text":"<ul> <li><code>&lt;DESTINATION&gt;</code> \u2014 Where to create the new workspace</li> </ul>"},{"location":"cli-reference.html#options_50","title":"Options:","text":"<ul> <li> <p><code>--name &lt;NAME&gt;</code> \u2014 A name for the workspace</p> <p>To override the default, which is the basename of the destination directory.</p> </li> <li> <p><code>-r</code>, <code>--revision &lt;REVSETS&gt;</code> \u2014 A list of parent revisions for the working-copy commit of the newly created workspace. You may specify nothing, or any number of parents.</p> <p>If no revisions are specified, the new workspace will be created, and its working-copy commit will exist on top of the parent(s) of the working-copy commit in the current workspace, i.e. they will share the same parent(s).</p> <p>If any revisions are specified, the new workspace will be created, and the new working-copy commit will be created with all these revisions as parents, i.e. the working-copy commit will exist as if you had run <code>jj new r1 r2 r3 ...</code>.</p> </li> <li> <p><code>--sparse-patterns &lt;SPARSE_PATTERNS&gt;</code> \u2014 How to handle sparse patterns when creating a new workspace</p> <p>Default value: <code>copy</code></p> <p>Possible values:</p> <ul> <li><code>copy</code>:   Copy all sparse patterns from the current workspace</li> <li><code>full</code>:   Include all files in the new workspace</li> <li><code>empty</code>:   Clear all files from the workspace (it will be empty)</li> </ul> </li> </ul>"},{"location":"cli-reference.html#jj-workspace-forget","title":"<code>jj workspace forget</code>","text":"<p>Stop tracking a workspace's working-copy commit in the repo</p> <p>The workspace will not be touched on disk. It can be deleted from disk before or after running this command.</p> <p>Usage: <code>jj workspace forget [WORKSPACES]...</code></p>"},{"location":"cli-reference.html#arguments_57","title":"Arguments:","text":"<ul> <li><code>&lt;WORKSPACES&gt;</code> \u2014 Names of the workspaces to forget. By default, forgets only the current workspace</li> </ul>"},{"location":"cli-reference.html#jj-workspace-list","title":"<code>jj workspace list</code>","text":"<p>List workspaces</p> <p>Usage: <code>jj workspace list</code></p>"},{"location":"cli-reference.html#jj-workspace-rename","title":"<code>jj workspace rename</code>","text":"<p>Renames the current workspace</p> <p>Usage: <code>jj workspace rename &lt;NEW_WORKSPACE_NAME&gt;</code></p>"},{"location":"cli-reference.html#arguments_58","title":"Arguments:","text":"<ul> <li><code>&lt;NEW_WORKSPACE_NAME&gt;</code> \u2014 The name of the workspace to update to</li> </ul>"},{"location":"cli-reference.html#jj-workspace-root","title":"<code>jj workspace root</code>","text":"<p>Show the current workspace root directory</p> <p>Usage: <code>jj workspace root</code></p>"},{"location":"cli-reference.html#jj-workspace-update-stale","title":"<code>jj workspace update-stale</code>","text":"<p>Update a workspace that has become stale</p> <p>See the stale working copy documentation for more information.</p> <p>Usage: <code>jj workspace update-stale</code></p> <p>     This document was generated automatically by     <code>clap-markdown</code>. </p>"},{"location":"code-of-conduct.html","title":"Contributor Covenant Code of Conduct","text":""},{"location":"code-of-conduct.html#our-pledge","title":"Our Pledge","text":"<p>We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socioeconomic status, nationality, personal appearance, race, caste, color, religion, or sexual identity and orientation.</p> <p>We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community.</p>"},{"location":"code-of-conduct.html#our-standards","title":"Our Standards","text":"<p>Examples of behavior that contributes to a positive environment for our community include:</p> <ul> <li>Demonstrating empathy and kindness toward other people</li> <li>Being respectful of differing opinions, viewpoints, and experiences</li> <li>Giving and gracefully accepting constructive feedback</li> <li>Accepting responsibility and apologizing to those affected by our mistakes,   and learning from the experience</li> <li>Focusing on what is best not just for us as individuals, but for the overall   community</li> </ul> <p>Examples of unacceptable behavior include:</p> <ul> <li>The use of sexualized language or imagery, and sexual attention or advances of   any kind</li> <li>Trolling, insulting or derogatory comments, and personal or political attacks</li> <li>Public or private harassment</li> <li>Publishing others' private information, such as a physical or email address,   without their explicit permission</li> <li>Other conduct which could reasonably be considered inappropriate in a   professional setting</li> </ul>"},{"location":"code-of-conduct.html#enforcement-responsibilities","title":"Enforcement Responsibilities","text":"<p>Community leaders are responsible for clarifying and enforcing our standards of acceptable behavior and will take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful.</p> <p>Community leaders have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, and will communicate reasons for moderation decisions when appropriate.</p>"},{"location":"code-of-conduct.html#scope","title":"Scope","text":"<p>This Code of Conduct applies within all community spaces, and also applies when an individual is officially representing the community in public spaces. Examples of representing our community include using an official e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event.</p>"},{"location":"code-of-conduct.html#enforcement","title":"Enforcement","text":"<p>Instances of abusive, harassing, or otherwise unacceptable behavior may be reported to the community leaders responsible for enforcement at two or more of jaraco@jaraco.com, avamsi07@gmail.com, me@waleedkhan.name, and opensource@google.com. All complaints will be reviewed and investigated promptly and fairly.</p> <p>All community leaders are obligated to respect the privacy and security of the reporter of any incident.</p>"},{"location":"code-of-conduct.html#enforcement-guidelines","title":"Enforcement Guidelines","text":"<p>Community leaders will follow these Community Impact Guidelines in determining the consequences for any action they deem in violation of this Code of Conduct:</p>"},{"location":"code-of-conduct.html#1-correction","title":"1. Correction","text":"<p>Community Impact: Use of inappropriate language or other behavior deemed unprofessional or unwelcome in the community.</p> <p>Consequence: A private, written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.</p>"},{"location":"code-of-conduct.html#2-warning","title":"2. Warning","text":"<p>Community Impact: A violation through a single incident or series of actions.</p> <p>Consequence: A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban.</p>"},{"location":"code-of-conduct.html#3-temporary-ban","title":"3. Temporary Ban","text":"<p>Community Impact: A serious violation of community standards, including sustained inappropriate behavior.</p> <p>Consequence: A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.</p>"},{"location":"code-of-conduct.html#4-permanent-ban","title":"4. Permanent Ban","text":"<p>Community Impact: Demonstrating a pattern of violation of community standards, including sustained inappropriate behavior, harassment of an individual, or aggression toward or disparagement of classes of individuals.</p> <p>Consequence: A permanent ban from any sort of public interaction within the community.</p>"},{"location":"code-of-conduct.html#attribution","title":"Attribution","text":"<p>This Code of Conduct is adapted from the Contributor Covenant, version 2.1, available at https://www.contributor-covenant.org/version/2/1/code_of_conduct.html.</p> <p>Community Impact Guidelines were inspired by Mozilla's code of conduct enforcement ladder.</p> <p>For answers to common questions about this code of conduct, see the FAQ at https://www.contributor-covenant.org/faq. Translations are available at https://www.contributor-covenant.org/translations.</p>"},{"location":"community_tools.html","title":"Community-built tools around Jujutsu","text":"<p>Important: Many of these are not complete yet, just like Jujutsu itself. But they already simplify many workflows and can improve your experience.</p>"},{"location":"community_tools.html#diffedit3","title":"Diffedit3","text":"<p>Diffedit3 is a web-based alternate to Meld, as it no longer is packaged and available for all Distros. Its creator is also a frequent contributor.</p> <p>Find it here</p>"},{"location":"community_tools.html#gg-gui-for-jj","title":"GG - GUI for JJ","text":"<p>GG is a cross platform GUI for Jujutsu which makes all graph manipulating workflows quite easy. Take a look at its README.md as it quite descriptive.</p> <p>Find it here.</p>"},{"location":"community_tools.html#hunknvim","title":"Hunk.nvim","text":"<p>Hunk.nvim is a Neovim based diff-editor for Jujutsu which can be used as an alternative to the default <code>:builtin</code> diff-editor.</p> <p>Find it here.</p>"},{"location":"community_tools.html#jj-fzf","title":"JJ-FZF","text":"<p>Centered around the <code>jj log</code> graph view, jj-fzf provides previews of diffs, the evolution-log, browses the op log and offers a large number of key bindings for commonly used <code>jj</code> operations from rebase to undo, and helps with divergent commits.</p> <p>Find it here.</p>"},{"location":"community_tools.html#jj-tui","title":"JJ TUI","text":"<p>This is TUI for Jujutsu built in Ocaml, it is unopiniated and its creator is open to feedback.</p> <p>Find it here.</p>"},{"location":"community_tools.html#lazyjj","title":"LazyJJ","text":"<p>lazyjj is a lazygit inspired TUI for Jujutsu.</p> <p>Find it here.</p>"},{"location":"community_tools.html#visual-jujutsu","title":"Visual Jujutsu","text":"<p>VJJ is a fzf (fuzzy finder) wrapper for Jujutsu, which is meant to be used interactively in the terminal.</p> <p>Find it here.</p>"},{"location":"community_tools.html#visualjj","title":"VisualJJ","text":"<p>VisualJJ is a plugin for Visual Studio Code which provides native integration for Jujutsu, not relying on Git colocation. Unlike other tools on this page, VisualJJ is not open-source.</p> <p>Find it here.</p>"},{"location":"community_tools.html#finding-other-integrations","title":"Finding other integrations","text":"<p>You can find other community contributed tools and integrations in our Wiki.</p>"},{"location":"config.html","title":"Configuration","text":"<p>These are the config settings available to jj/Jujutsu.</p>"},{"location":"config.html#config-files-and-toml","title":"Config files and TOML","text":"<p><code>jj</code> loads several types of config settings:</p> <ul> <li> <p>The built-in settings. These cannot be edited. They can be viewed in the   <code>cli/src/config/</code> directory in <code>jj</code>'s source repo.</p> </li> <li> <p>The user settings. These can be edited with <code>jj config edit --user</code>. User settings are located in the user config file, which can be found with <code>jj config path --user</code>.</p> </li> <li> <p>The repo settings. These can be edited with <code>jj config edit --repo</code> and are located in <code>.jj/repo/config.toml</code>.</p> </li> <li> <p>Settings specified in the command-line.</p> </li> </ul> <p>These are listed in the order they are loaded; the settings from earlier items in the list are overridden by the settings from later items if they disagree. Every type of config except for the built-in settings is optional.</p> <p>You can enable JSON Schema validation in your editor by adding a <code>$schema</code> reference at the top of your TOML config files. See JSON Schema Support for details.</p> <p>See the TOML site and the syntax guide for a detailed description of the syntax. We cover some of the basics below.</p> <p>The first thing to remember is that the value of a setting (the part to the right of the <code>=</code> sign) should be surrounded in quotes if it's a string.</p>"},{"location":"config.html#dotted-style-and-headings","title":"Dotted style and headings","text":"<p>In TOML, anything under a heading can be dotted instead. For example, <code>user.name = \"YOUR NAME\"</code> is equivalent to:</p> <pre><code>[user]\nname = \"YOUR NAME\"\n</code></pre> <p>For future reference, here are a couple of more complicated examples,</p> <pre><code># Dotted style\ntemplate-aliases.\"format_short_id(id)\" = \"id.shortest(12)\"\ncolors.\"commit_id prefix\".bold = true\n\n# is equivalent to:\n[template-aliases]\n\"format_short_id(id)\" = \"id.shortest(12)\"\n\n[colors]\n\"commit_id prefix\" = { bold = true }\n</code></pre> <p>The docs below refer to keys in text using dotted notation, but example blocks will use heading notation to be unambiguous. If you are confident with TOML then use whichever suits you in your config. If you mix dotted keys and headings, you must put the dotted keys before the first heading.</p> <p>That's probably enough TOML to keep you out of trouble but the syntax guide is very short if you ever need to check.</p>"},{"location":"config.html#user-settings","title":"User settings","text":"<pre><code>[user]\nname = \"YOUR NAME\"\nemail = \"YOUR_EMAIL@example.com\"\n</code></pre> <p>Don't forget to change these to your own details!</p>"},{"location":"config.html#ui-settings","title":"UI settings","text":""},{"location":"config.html#colorizing-output","title":"Colorizing output","text":"<p>Possible values are <code>always</code>, <code>never</code>, <code>debug</code> and <code>auto</code> (default: <code>auto</code>). <code>auto</code> will use color only when writing to a terminal. <code>debug</code> will print the active labels alongside the regular colorized output.</p> <p>This setting overrides the <code>NO_COLOR</code> environment variable (if set).</p> <pre><code>[ui]\ncolor = \"never\" # Turn off color\n</code></pre>"},{"location":"config.html#custom-colors-and-styles","title":"Custom colors and styles","text":"<p>You can customize the colors used for various elements of the UI. For example:</p> <pre><code>[colors]\ncommit_id = \"green\"\n</code></pre> <p>The following colors are available:</p> <ul> <li>black</li> <li>red</li> <li>green</li> <li>yellow</li> <li>blue</li> <li>magenta</li> <li>cyan</li> <li>white</li> <li>default</li> </ul> <p>All of them but \"default\" come in a bright version too, e.g. \"bright red\". The \"default\" color can be used to override a color defined by a parent style (explained below).</p> <p>You can also use a 6-digit hex code for more control over the exact color used:</p> <pre><code>[colors]\nchange_id = \"#ff1525\"\n</code></pre> <p>If you use a string value for a color, as in the examples above, it will be used for the foreground color. You can also set the background color, or make the text bold, italic, or underlined. For that, you need to use a table:</p> <pre><code>[colors]\ncommit_id = { fg = \"green\", bg = \"#ff1525\", bold = true, italic = true, underline = true }\n</code></pre> <p>The key names are called \"labels\". The above used <code>commit_id</code> as label. You can also create rules combining multiple labels. The rules work a bit like CSS selectors. For example, if you want to color commit IDs green in general but make the commit ID of the working-copy commit also be underlined, you can do this:</p> <pre><code>[colors]\ncommit_id = \"green\"\n\"working_copy commit_id\" = { underline = true }\n</code></pre> <p>Parts of the style that are not overridden - such as the foreground color in the example above - are inherited from the style of the parent label.</p> <p>Which elements can be colored is not yet documented, but see the default color configuration for some examples of what's possible.</p>"},{"location":"config.html#default-command","title":"Default command","text":"<p>When <code>jj</code> is run with no explicit subcommand, the value of the <code>ui.default-command</code> setting will be used instead. Possible values are any valid subcommand name, subcommand alias, or user-defined alias (defaults to <code>\"log\"</code>).</p> <pre><code>[ui]\ndefault-command = [\"log\", \"--reversed\"]\n</code></pre>"},{"location":"config.html#default-description","title":"Default description","text":"<p>The editor content of a commit description can be populated by the <code>draft_commit_description</code> template.</p> <pre><code>[templates]\ndraft_commit_description = '''\nconcat(\n  description,\n  surround(\n    \"\\nJJ: This commit contains the following changes:\\n\", \"\",\n    indent(\"JJ:     \", diff.stat(72)),\n  ),\n  \"\\nJJ: ignore-rest\\n\",\n  diff.git(),\n)\n'''\n</code></pre> <p>The value of the <code>ui.default-description</code> setting can also be used in order to fill in things like BUG=, TESTED= etc.</p> <pre><code>[ui]\ndefault-description = \"\\n\\nTESTED=TODO\"\n</code></pre>"},{"location":"config.html#diff-colors-and-styles","title":"Diff colors and styles","text":"<p>In color-words and git diffs, word-level hunks are rendered with underline. You can override the default style with the following keys:</p> <pre><code>[colors]\n# Highlight hunks with background\n\"diff removed token\" = { bg = \"#221111\", underline = false }\n\"diff added token\" = { bg = \"#002200\", underline = false }\n</code></pre>"},{"location":"config.html#diff-format","title":"Diff format","text":"<pre><code>[ui]\n# Possible values: \"color-words\" (default), \"git\", \"summary\"\ndiff.format = \"git\"\n</code></pre>"},{"location":"config.html#color-words-diff-options","title":"Color-words diff options","text":"<p>In color-words diffs, changed words are displayed inline by default. Because it's difficult to read a diff line with many removed/added words, there's a threshold to switch to traditional separate-line format. You can also change the default number of lines of context shown.</p> <ul> <li> <p><code>max-inline-alternation</code>: Maximum number of removed/added word alternation to   inline. For example, <code>&lt;added&gt; ... &lt;added&gt;</code> sequence has 1 alternation, so the   line will be inline if <code>max-inline-alternation &gt;= 1</code>. <code>&lt;added&gt; ... &lt;removed&gt;   ... &lt;added&gt;</code> sequence has 3 alternation.</p> <ul> <li><code>0</code>: disable inlining, making <code>--color-words</code> more similar to <code>--git</code></li> <li><code>1</code>: inline removes-only or adds-only lines</li> <li><code>2</code>, <code>3</code>, ..: inline up to <code>2</code>, <code>3</code>, .. alternation</li> <li><code>-1</code>: inline all lines</li> </ul> <p>The default is <code>3</code>.</p> <p>This parameter is experimental. The definition is subject to change.</p> </li> <li> <p><code>context</code>: Number of lines of context to show in the diff. The default is <code>3</code>.</p> </li> </ul> <pre><code>[diff.color-words]\nmax-inline-alternation = 3\ncontext = 3\n</code></pre>"},{"location":"config.html#git-diff-options","title":"Git diff options","text":"<p>In git diffs you can change the default number of lines of context shown.</p> <ul> <li><code>context</code>: Number of lines of context to show in the diff. The default is <code>3</code>.</li> </ul> <pre><code>[diff.git]\ncontext = 3\n</code></pre>"},{"location":"config.html#generating-diffs-by-external-command","title":"Generating diffs by external command","text":"<p>If <code>ui.diff.tool</code> is set, the specified diff command will be called instead of the internal diff function.</p> <pre><code>[ui]\n# Use Difftastic by default\ndiff.tool = [\"difft\", \"--color=always\", \"$left\", \"$right\"]\n# Use tool named \"&lt;name&gt;\" (see below)\ndiff.tool = \"&lt;name&gt;\"\n</code></pre> <p>The external diff tool can also be enabled by <code>diff --tool &lt;name&gt;</code> argument. For the tool named <code>&lt;name&gt;</code>, command arguments can be configured as follows.</p> <pre><code>[merge-tools.&lt;name&gt;]\n# program = \"&lt;name&gt;\"  # Defaults to the name of the tool if not specified\ndiff-args = [\"--color=always\", \"$left\", \"$right\"]\n</code></pre> <ul> <li><code>$left</code> and <code>$right</code> are replaced with the paths to the left and right   directories to diff respectively.</li> </ul> <p>By default <code>jj</code> will invoke external tools with a directory containing the left and right sides.  The <code>diff-invocation-mode</code> config can change this to file by file invocations as follows:</p> <pre><code>[ui]\ndiff.tool = \"vimdiff\"\n\n[merge-tools.vimdiff]\ndiff-invocation-mode = \"file-by-file\"\n</code></pre> <p>By default <code>jj</code> will display a warning when the command exits with a non-success error code. The <code>diff-expected-exit-codes</code> config can suppress this warning message for specific exit codes:</p> <pre><code>[merge-tools.delta]\ndiff-expected-exit-codes = [0, 1]\n</code></pre>"},{"location":"config.html#conflict-marker-style","title":"Conflict marker style","text":"<p>You can configure which style of conflict markers to use when materializing conflicts:</p> <pre><code>[ui]\n# Shows a single snapshot and one or more diffs to apply to it\nconflict-marker-style = \"diff\"\n# Shows a snapshot for each side and base of the conflict\nconflict-marker-style = \"snapshot\"\n# Uses Git's \"diff3\" conflict markers to support tools that depend on it\nconflict-marker-style = \"git\"\n</code></pre> <p>For more details about these conflict marker styles, see the conflicts page.</p>"},{"location":"config.html#set-of-immutable-commits","title":"Set of immutable commits","text":"<p>You can configure the set of immutable commits via <code>revset-aliases.\"immutable_heads()\"</code>. The default set of immutable heads is <code>builtin_immutable_heads()</code>, which in turn is defined as <code>present(trunk()) | tags() | untracked_remote_bookmarks()</code>. For example, to also consider the <code>release@origin</code> bookmark immutable:</p> <pre><code>[revset-aliases]\n\"immutable_heads()\" = \"builtin_immutable_heads() | release@origin\"\n</code></pre> <p>To prevent rewriting commits authored by other users:</p> <pre><code># The `trunk().. &amp;` bit is an optimization to scan for non-`mine()` commits\n# only among commits that are not in `trunk()`.\n[revset-aliases]\n\"immutable_heads()\" = \"builtin_immutable_heads() | (trunk().. &amp; ~mine())\"\n</code></pre> <p>Ancestors of the configured set are also immutable. The root commit is always immutable even if the set is empty.</p>"},{"location":"config.html#behavior-of-prev-and-next-commands","title":"Behavior of prev and next commands","text":"<p>If you prefer using an \"edit-based\" workflow, rather than squashing modifications into parent changes, you may find yourself using the <code>prev</code> and <code>next</code> commands with their <code>--edit</code> flag often to move between your changes. You can avoid having to type the <code>--edit</code> flag every time you need it by actually making it the default:</p> <pre><code>[ui.movement]\nedit = true\n</code></pre> <p>You can pass the <code>--no-edit</code> flag to <code>prev</code> and <code>next</code> if you find yourself needing the original behavior.</p>"},{"location":"config.html#log","title":"Log","text":""},{"location":"config.html#default-revisions","title":"Default revisions","text":"<p>You can configure the revisions <code>jj log</code> would show when neither <code>-r</code> nor any paths are specified.</p> <pre><code>[revsets]\n# Show commits that are not in `main@origin`\nlog = \"main@origin..\"\n</code></pre> <p>The default value for <code>revsets.log</code> is <code>'present(@) | ancestors(immutable_heads().., 2) | present(trunk())'</code>.</p>"},{"location":"config.html#default-template","title":"Default Template","text":"<p>You can configure the template used when no <code>-T</code> is specified.</p> <ul> <li><code>templates.log</code> for <code>jj log</code></li> <li><code>templates.op_log</code> for <code>jj op log</code></li> <li><code>templates.show</code> for <code>jj show</code></li> </ul> <pre><code>[templates]\n# Use builtin log template\nlog = \"builtin_log_compact\"\n# Use builtin op log template\nop_log = \"builtin_op_log_compact\"\n# Use builtin show template\nshow = \"builtin_log_detailed\"\n</code></pre> <p>If you want to see the full description when you do <code>jj log</code> you can add this to your config:</p> <pre><code>[templates]\nlog = \"builtin_log_compact_full_description\"\n</code></pre>"},{"location":"config.html#graph-style","title":"Graph style","text":"<pre><code>[ui]\n# Possible values: \"curved\" (default), \"square\", \"ascii\", \"ascii-large\"\ngraph.style = \"square\"\n</code></pre>"},{"location":"config.html#node-style","title":"Node style","text":"<p>The symbols used to represent commits or operations can be customized via templates.</p> <ul> <li><code>templates.log_node</code> for commits (with <code>Option&lt;Commit&gt;</code> keywords)</li> <li><code>templates.op_log_node</code> for operations (with <code>Operation</code> keywords)</li> </ul> <p>For example: <pre><code>[templates]\nlog_node = '''\ncoalesce(\n  if(!self, \"\ud83e\udf80\"),\n  if(current_working_copy, \"@\"),\n  if(root, \"\u2534\"),\n  if(immutable, \"\u25cf\", \"\u25cb\"),\n)\n'''\nop_log_node = 'if(current_operation, \"@\", \"\u25cb\")'\n</code></pre></p>"},{"location":"config.html#wrap-log-content","title":"Wrap log content","text":"<p>If enabled, <code>log</code>/<code>evolog</code>/<code>op log</code> content will be wrapped based on the terminal width.</p> <pre><code>[ui]\nlog-word-wrap = true\n</code></pre>"},{"location":"config.html#display-of-commit-and-change-ids","title":"Display of commit and change ids","text":"<p>Can be customized by the <code>format_short_id()</code> template alias.</p> <pre><code>[template-aliases]\n# Highlight unique prefix and show at least 12 characters (default)\n'format_short_id(id)' = 'id.shortest(12)'\n# Just the shortest possible unique prefix\n'format_short_id(id)' = 'id.shortest()'\n# Show unique prefix and the rest surrounded by brackets\n'format_short_id(id)' = 'id.shortest(12).prefix() ++ \"[\" ++ id.shortest(12).rest() ++ \"]\"'\n# Always show 12 characters\n'format_short_id(id)' = 'id.short(12)'\n</code></pre> <p>To customize these separately, use the <code>format_short_commit_id()</code> and <code>format_short_change_id()</code> aliases:</p> <pre><code>[template-aliases]\n# Uppercase change ids. `jj` treats change and commit ids as case-insensitive.\n'format_short_change_id(id)' = 'format_short_id(id).upper()'\n</code></pre> <p>To get shorter prefixes for certain revisions, set <code>revsets.short-prefixes</code>:</p> <pre><code>[revsets]\n# Prioritize the current bookmark\nshort-prefixes = \"(main..@)::\"\n</code></pre>"},{"location":"config.html#relative-timestamps","title":"Relative timestamps","text":"<p>Can be customized by the <code>format_timestamp()</code> template alias.</p> <pre><code>[template-aliases]\n# Full timestamp in ISO 8601 format\n'format_timestamp(timestamp)' = 'timestamp'\n# Relative timestamp rendered as \"x days/hours/seconds ago\"\n'format_timestamp(timestamp)' = 'timestamp.ago()'\n</code></pre> <p><code>jj op log</code> defaults to relative timestamps. To use absolute timestamps, you will need to modify the <code>format_time_range()</code> template alias.</p> <pre><code>[template-aliases]\n'format_time_range(time_range)' = 'time_range.start() ++ \" - \" ++ time_range.end()'\n</code></pre>"},{"location":"config.html#author-format","title":"Author format","text":"<p>Can be customized by the <code>format_short_signature()</code> template alias.</p> <pre><code>[template-aliases]\n# Full email address (default)\n'format_short_signature(signature)' = 'signature.email()'\n# Both name and email address\n'format_short_signature(signature)' = 'signature'\n# Username part of the email address\n'format_short_signature(signature)' = 'signature.username()'\n</code></pre>"},{"location":"config.html#commit-timestamp","title":"Commit timestamp","text":"<p>Commits have both an \"author timestamp\" and \"committer timestamp\". By default, jj displays the committer timestamp, but can be changed to show the author timestamp instead.</p> <p>The function must return a timestamp because the return value will likely be formatted with <code>format_timestamp()</code>.</p> <pre><code>[template-aliases]\n'commit_timestamp(commit)' = 'commit.author().timestamp()'\n</code></pre>"},{"location":"config.html#signature-format","title":"Signature format","text":"<p>Can be enabled with <code>ui.show-cryptographic-signatures</code>, and customized with <code>format_short_cryptographic_signature(sig)</code> and <code>format_detailed_cryptographic_signature(sig)</code>.</p> <p>Note that the formatting functions take an <code>Option&lt;CryptographicSignature&gt;</code>. This allows you to emit a custom message if a signature is not present, but will raise an error if you try to access methods on a signature that is not available.</p> <pre><code>[ui]\n# default is false\nshow-cryptographic-signatures = true\n\n[template-aliases]\n'format_short_cryptographic_signature(sig)' = '''\n  if(sig,\n    sig.status(),\n    \"(no sig)\",\n  )\n'''\n</code></pre>"},{"location":"config.html#allow-large-revsets-by-default","title":"Allow \"large\" revsets by default","text":"<p>Certain commands (such as <code>jj rebase</code>) can take multiple revset arguments, but default to requiring each of those revsets to expand to a single revision. This restriction can be overridden by prefixing a revset that the user wants to be able to expand to more than one revision with the <code>all:</code> modifier.</p> <p>Another way you can override this check is by setting <code>ui.always-allow-large-revsets</code> to <code>true</code>. Then, <code>jj</code> will allow every one of the revset arguments of such commands to expand to any number of revisions.</p> <pre><code>[ui]\n# Assume `all:` prefix before revsets whenever it would make a difference\nalways-allow-large-revsets = true\n</code></pre>"},{"location":"config.html#pager","title":"Pager","text":"<p>The default pager is can be set via <code>ui.pager</code> or the <code>PAGER</code> environment variable. The priority is as follows (environment variables are marked with a <code>$</code>):</p> <p><code>ui.pager</code> &gt; <code>$PAGER</code></p> <p><code>less -FRX</code> is the default pager in the absence of any other setting, except on Windows where it is <code>:builtin</code>.</p> <p>The special value <code>:builtin</code> enables usage of the integrated pager.</p> <p>If you are using a standard Linux distro, your system likely already has <code>$PAGER</code> set and that will be preferred over the built-in. To use the built-in:</p> <pre><code>jj config set --user ui.pager :builtin\n</code></pre> <p>It is possible the default will change to <code>:builtin</code> for all platforms in the future.</p> <p>Additionally, paging behavior can be toggled via <code>ui.paginate</code> like so:</p> <pre><code>[ui]\n# Enable pagination for commands that support it (default)\npaginate = \"auto\"\n# Disable all pagination, equivalent to using --no-pager\npaginate = \"never\"\n</code></pre>"},{"location":"config.html#builtin-pager","title":"Builtin pager","text":"<p>Our builtin pager is based on <code>streampager</code> but is configured within <code>jj</code>'s config. It is configured via the <code>ui.streampager</code> table.</p>"},{"location":"config.html#key-bindings","title":"Key bindings","text":"<p>The built-in pager supports both navigation via arrows and Vim-style navigation. Beyond that, here are some useful keybindings for the pager:</p> Key Action <code>Ctrl-c</code> or <code>q</code> Quit <code>h</code> or <code>F1</code> Show all key bindings <code>Esc</code> Close help or prompt <code>\\</code> Toggle line wrapping <code>#</code> Toggle line numbers <code>Ctrl-r</code> Toggle the ruler <p>The built-in pager does not support mouse input.</p>"},{"location":"config.html#wrapping-config","title":"Wrapping config","text":"<p>Wrapping performed by the pager happens in addition to any wrapping that <code>jj</code> itself does.</p> <pre><code>[ui.streampager]\nwrapping = \"anywhere\"  # wrap at screen edge (default)\nwrapping = \"word\"      # wrap on word boundaries\nwrapping = \"none\"      # strip long lines, allow scrolling\n                       # left and right like `less -S`\n</code></pre>"},{"location":"config.html#auto-exit-clearing-the-screen-on-startup-or-exit","title":"Auto-exit, clearing the screen on startup or exit","text":"<p>You can configure whether the pager clears the screen on startup or exit, and whether it quits automatically on short inputs. When the pager auto-quits, features like word-wrapping are disabled.</p> <pre><code>[ui.streampager]\n# Do not clear screen on exit. Use a full-screen interface for long\n# output only. Like `less -FX`.\ninterface = \"quit-if-one-page\"  # (default).\n# Always use a full-screen interface, ask the terminal to clear the\n# screen on exit. Like `less -+FX`.\ninterface = \"full-screen-clear-output\"\n# Use the alternate screen if the input is either long or takes more\n# than 2 seconds to finish. Similar but not identical to `less -F -+X`.\ninterface = \"quit-quickly-or-clear-output\"\n</code></pre>"},{"location":"config.html#processing-contents-to-be-paged","title":"Processing contents to be paged","text":"<p>If you'd like to pass the output through a formatter e.g. <code>diff-so-fancy</code> before piping it through a pager you must do it using a subshell as, unlike <code>git</code> or <code>hg</code>, the command will be executed directly. For example:</p> <pre><code>[ui]\npager = [\"sh\", \"-c\", \"diff-so-fancy | less -RFX\"]\n</code></pre> <p>Some formatters (like <code>delta</code>) require git style diffs for formatting. You can configure this style of diff as the default with the <code>ui.diff</code> setting. For example:</p> <pre><code>[ui]\npager = \"delta\"\n\n[ui.diff]\nformat = \"git\"\n</code></pre>"},{"location":"config.html#aliases","title":"Aliases","text":"<p>You can define aliases for commands, including their arguments. For example:</p> <pre><code>[aliases]\n# `jj l` shows commits on the working-copy commit's (anonymous) bookmark\n# compared to the `main` bookmark\nl = [\"log\", \"-r\", \"(main..@):: | (main..@)-\"]\n</code></pre> <p>This alias syntax can only run a single jj command. However, you may want to execute multiple jj commands with a single alias, or run arbitrary scripts that complement your version control workflow. This can be done, but be aware of the danger:</p> <p>Warning</p> <p>The following technique just provides a convenient syntax for running arbitrary code on your system. Using it irresponsibly may cause damage ranging from breaking the behavior of <code>jj undo</code> to wiping your file system. Exercise the same amount of caution while writing these aliases as you would when typing commands into the terminal!</p> <p>This feature may be removed or replaced by an embedded scripting language in the future.</p> <p>The command <code>jj util exec</code> will simply run any command you pass to it as an argument. Additional arguments are passed through. Here are some examples:</p> <pre><code>[aliases]\nmy-script = [\"util\", \"exec\", \"--\", \"my-jj-script\"]\n#                            ^^^^\n# This makes sure that flags are passed to your script instead of parsed by jj.\nmy-inline-script = [\"util\", \"exec\", \"--\", \"bash\", \"-c\", \"\"\"\n#!/usr/bin/env bash\nset -euo pipefail\necho \"Look Ma, everything in one file!\"\necho \"args: $@\"\n\"\"\", \"\"]\n#    ^^\n# This last empty string will become \"$0\" in bash, so your actual arguments\n# are all included in \"$@\" and start at \"$1\" as expected.\n</code></pre>"},{"location":"config.html#editor","title":"Editor","text":"<p>The default editor is set via <code>ui.editor</code>, though there are several places to set it. The priority is as follows (environment variables are marked with a <code>$</code>):</p> <p><code>$JJ_EDITOR</code> &gt; <code>ui.editor</code> &gt; <code>$VISUAL</code> &gt; <code>$EDITOR</code></p> <p>Pico is the default editor (Notepad on Windows) in the absence of any other setting, but you could set it explicitly too.</p> <pre><code>[ui]\neditor = \"pico\"\n</code></pre> <p>To use NeoVim instead:</p> <pre><code>[ui]\neditor = \"nvim\"\n</code></pre> <p>For GUI editors you possibly need to use a <code>-w</code> or <code>--wait</code>. Some examples:</p> <pre><code>[ui]\neditor = \"code -w\"       # VS Code\neditor = \"code.cmd -w\"   # VS Code on Windows\neditor = \"bbedit -w\"     # BBEdit\neditor = \"subl -n -w\"    # Sublime Text\neditor = \"mate -w\"       # TextMate\neditor = [\"C:/Program Files/Notepad++/notepad++.exe\",\n    \"-multiInst\", \"-notabbar\", \"-nosession\", \"-noPlugin\"] # Notepad++\neditor = \"idea --temp-project --wait\"   #IntelliJ\n</code></pre> <p>Obviously, you would only set one line, don't copy them all in!</p>"},{"location":"config.html#editing-diffs","title":"Editing diffs","text":"<p>The <code>ui.diff-editor</code> setting affects the default tool used for editing diffs (e.g.  <code>jj split</code>, <code>jj squash -i</code>). If it is not set, the special value <code>:builtin</code> is used. It launches a built-in TUI tool (known as scm-diff-editor) to edit the diff in your terminal.</p> <p>You can try a different tool temporarily by doing e.g. <code>jj split --tool meld</code> or you can set the option to change the default. This requires that you have an appropriate tool installed, see for example the instructions for using Meld.</p> <p>Suggestion: If possible, it is recommended to try an external diff tool like Meld (see below for some other possibilities) for splitting commits and other diff editing, in addition to the built-in diff editor. It is good to know the capabilities of both. The built-in diff editor does not require external tools to be available, is faster for tasks like picking hunks, and does not require leaving the terminal. External tools give you the flexibility of picking out portions of lines from the diff or even arbitrarily editing the text of the files.</p> <p>If <code>ui.diff-editor</code> is a string, e.g. <code>\"meld\"</code>, the arguments will be read from the following config keys.</p> <pre><code>[merge-tools.meld]\n# program = \"meld\"      # Defaults to the name of the tool if not specified\nprogram = \"/path/to/meld\" # May be necessary if `meld` is not in the PATH\nedit-args = [\"--newtab\", \"$left\", \"$right\"]\n</code></pre> <p><code>jj</code> makes the following substitutions:</p> <ul> <li> <p><code>$left</code> and <code>$right</code> are replaced with the paths to the left and right   directories to diff respectively.</p> </li> <li> <p>If no <code>edit-args</code> are specified, <code>[\"$left\", \"$right\"]</code> are set by default.</p> </li> </ul> <p>Finally, <code>ui.diff-editor</code> can be a list that specifies a command and its arguments.</p> <p>Some examples:</p> <pre><code>[ui]\n# Use merge-tools.meld.edit-args\ndiff-editor = \"meld\"  # Or `kdiff3`, or `diffedit3`, ...\n# Specify edit-args inline\ndiff-editor = [\"/path/to/binary\", \"--be-helpful\", \"$left\", \"$right\"]\n# Equivalent to [\"binary\", \"$left\", \"$right\"] arguments by default\ndiff-editor = \"binary\"\n</code></pre>"},{"location":"config.html#experimental-3-pane-diff-editing","title":"Experimental 3-pane diff editing","text":"<p>We offer two special \"3-pane\" diff editor configs:</p> <ul> <li><code>meld-3</code>, which requires installing Meld, and</li> <li><code>diffedit3</code>, which requires installing <code>diffedit3</code>.</li> </ul> <p><code>Meld</code> is a graphical application that is recommended, but can be difficult to install in some situations. <code>diffedit3</code> is designed to be easy to install and to be usable in environments where Meld is difficult to use (e.g. over SSH via port forwarding). <code>diffedit3</code> starts a local server that can be accessed via a web browser, similarly to Jupyter.</p> <p>There is also the <code>diffedit3-ssh</code> which is similar to <code>diffedit3</code> but does not try to open the web browser pointing to the local server (the URL printed to the terminal) automatically. <code>diffedit3-ssh</code> also always uses ports in between 17376-17380 and fails if they are all busy. This can be useful when working over SSH. Open the fold below for more details of how to set that up.</p>  Tips for using `diffedit3-ssh` over SSH   To use `diffedit3` over SSH, you need to set up port forwarding. One way to do this is to start SSH as follows (copy-paste the relevant lines):  <pre><code>ssh -L 17376:localhost:17376 \\\n    -L 17377:localhost:17377 \\\n    -L 17378:localhost:17378 \\\n    -L 17379:localhost:17379 \\\n    -L 17380:localhost:17380 \\\n    myhost.example.com\n</code></pre>  `diffedit3-ssh` is set up to use these 5 ports by default. Usually, only the first of them will be used. The rest are used if another program happens to use one of them, or if you run multiple instances of `diffedit3` at the same time.  Another way is to add a snippet to `~/.ssh/config`:  <pre><code>Host myhost\n    User     myself\n    Hostname myhost.example.com\n    LocalForward 17376 localhost:17376\n    LocalForward 17377 localhost:17377\n    LocalForward 17378 localhost:17378\n    LocalForward 17379 localhost:17379\n    LocalForward 17380 localhost:17380\n</code></pre>  With that configuration, you should be able to simply `ssh myhost`.   <p>Setting either <code>ui.diff-editor = \"meld-3\"</code> or <code>ui.diff-editor = \"diffedit3\"</code> will result in the diff editor showing 3 panes: the diff on the left and right, and an editing pane in the middle. This allow you to see both sides of the original diff while editing.</p> <p>If you use <code>ui.diff-editor = \"meld-3\"</code>, note that you can still get the 2-pane Meld view using <code>jj diff --tool meld</code>. <code>diffedit3</code> has a button you can use to switch to a 2-pane view.</p> <p>To configure other diff editors in this way, you can include <code>$output</code> together with <code>$left</code> and <code>$right</code> in <code>merge-tools.TOOL.edit-args</code>. <code>jj</code> will replace <code>$output</code> with the directory where the diff editor will be expected to put the result of the user's edits. Initially, the contents of <code>$output</code> will be the same as the contents of <code>$right</code>.</p>"},{"location":"config.html#jj-instructions","title":"<code>JJ-INSTRUCTIONS</code>","text":"<p>When editing a diff, jj will include a synthetic file called <code>JJ-INSTRUCTIONS</code> in the diff with instructions on how to edit the diff. Any changes you make to this file will be ignored. To suppress the creation of this file, set <code>ui.diff-instructions = false</code>.</p>"},{"location":"config.html#using-meld-as-a-diff-editor","title":"Using Meld as a diff editor","text":"<p>Meld is a nice and polished free diff editor. It can be obtained as follows:</p> <ul> <li> <p>Linux: use your favorite package manager, e.g. <code>sudo apt install meld</code>.</p> </li> <li> <p>Windows: Meld can be downloaded from https://meldmerge.org/.</p> </li> <li> <p>Mac OS: Install Homebrew and run <code>brew install --cask dehesselle-meld</code>.   This will install both an app in <code>/Applications/Meld.app</code> and the command-line   <code>meld</code> command that <code>jj</code> uses. You can read about more details and other   options but,   as of this writing, this is by far the easiest.</p> <p>Warning</p> <p>Do not use the Homebrew <code>meld</code> package. It does not work on ARM Macs and may have problems on recent versions of macOS.</p> </li> </ul> <p><code>jj</code> has two diff editing configurations that use Meld: <code>meld</code> for a 2-pane view and <code>meld-3</code> for a three-pane view.</p> <p>There is also a <code>meld</code> merge tool that can be useful, but does not support displaying the merge base while merging.</p>"},{"location":"config.html#using-vim-as-a-diff-editor","title":"Using Vim as a diff editor","text":"<p>Using <code>ui.diff-editor = \"vimdiff\"</code> is possible but not recommended. For a better experience, you can follow instructions from the Wiki to configure the DirDiff Vim plugin and/or the vimtabdiff Python script.</p>"},{"location":"config.html#3-way-merge-tools-for-conflict-resolution","title":"3-way merge tools for conflict resolution","text":"<p>The <code>ui.merge-editor</code> key specifies the tool used for three-way merge tools by <code>jj resolve</code>. For example:</p> <pre><code>[ui]\n# Use merge-tools.meld.merge-args\nmerge-editor = \"meld\"  # Or \"vscode\" or \"vscodium\" or \"kdiff3\" or \"vimdiff\"\n# Specify merge-args inline\nmerge-editor = [\"meld\", \"$left\", \"$base\", \"$right\", \"-o\", \"$output\"]\n</code></pre> <p>The \"vscode\", \"vscodium\", \"meld\", \"kdiff3\", and \"vimdiff\" tools can be used out of the box, as long as they are installed.</p> <p>Using VS Code as a merge tool works well with VS Code's Remote Development functionality, as long as <code>jj</code> is called from VS Code's terminal.</p>"},{"location":"config.html#setting-up-a-custom-merge-tool","title":"Setting up a custom merge tool","text":"<p>To use a different tool named <code>TOOL</code>, the arguments to pass to the tool MUST be specified either inline or in the <code>merge-tools.TOOL.merge-args</code> key. As an example of how to set this key and other tool configuration options, here is the out-of-the-box configuration of the three default tools. (There is no need to copy it to your config file verbatim, but you are welcome to customize it.)</p> <pre><code>[merge-tools.kdiff3]\n# program  = \"kdiff3\"     # Defaults to the name of the tool if not specified\nmerge-args = [\"$base\", \"$left\", \"$right\", \"-o\", \"$output\", \"--auto\"]\n[merge-tools.meld]\nmerge-args = [\"$left\", \"$base\", \"$right\", \"-o\", \"$output\", \"--auto-merge\"]\n\n[merge-tools.vimdiff]\nmerge-args = [\"-f\", \"-d\", \"$output\", \"-M\",\n    \"$left\", \"$base\", \"$right\",\n    \"-c\", \"wincmd J\", \"-c\", \"set modifiable\",\n    \"-c\", \"set write\"]\nprogram = \"vim\"\nmerge-tool-edits-conflict-markers = true    # See below for an explanation\n</code></pre> <p><code>jj</code> makes the following substitutions:</p> <ul> <li> <p><code>$output</code> (REQUIRED) is replaced with the name of the file that the merge tool   should output. <code>jj</code> will read this file after the merge tool exits.</p> </li> <li> <p><code>$left</code> and <code>$right</code> are replaced with the paths to two files containing the   content of each side of the conflict.</p> </li> <li> <p><code>$base</code> is replaced with the path to a file containing the contents of the   conflicted file in the last common ancestor of the two sides of the conflict.</p> </li> <li> <p><code>$marker_length</code> is replaced with the length of the conflict markers which   should be used for the file. This can be useful if the merge tool parses   and/or generates conflict markers. Usually, <code>jj</code> uses conflict markers of   length 7, but they can be longer if necessary to make parsing unambiguous.</p> </li> </ul>"},{"location":"config.html#editing-conflict-markers-with-a-tool-or-a-text-editor","title":"Editing conflict markers with a tool or a text editor","text":"<p>By default, the merge tool starts with an empty output file. If the tool puts anything into the output file and exits with the 0 exit code, <code>jj</code> assumes that the conflict is fully resolved, while if the tool exits with a non-zero exit code, <code>jj</code> assumes that the merge should be cancelled. This is appropriate for most graphical merge tools.</p> <p>For merge tools which try to automatically resolve conflicts without user input, this behavior may not be desired. For instance, some automatic merge tools use an exit code of 1 to indicate that some conflicts were unable to be resolved and that the output file should contain conflict markers. In that case, you could set the config option <code>merge-tools.TOOL.merge-conflict-exit-codes = [1]</code> to tell <code>jj</code> to expect conflict markers in the output file if the exit code is 1. If a merge tool produces output using Git's \"diff3\" conflict style, <code>jj</code> should be able to parse it correctly, so many Git merge drivers should be usable with <code>jj</code> as well.</p> <p>Some tools (e.g. <code>vimdiff</code>) can present a multi-way diff but don't resolve conflict themselves. When using such tools, <code>jj</code> can help you by populating the output file with conflict markers before starting the merge tool (instead of leaving the output file empty and letting the merge tool fill it in). To do that, set the <code>merge-tools.vimdiff.merge-tool-edits-conflict-markers = true</code> option.</p> <p>With this option set, if the output file still contains conflict markers after the conflict is done, <code>jj</code> assumes that the conflict was only partially resolved and parses the conflict markers to get the new state of the conflict. The conflict is considered fully resolved when there are no conflict markers left. The conflict marker style can also be customized per tool using the <code>merge-tools.TOOL.conflict-marker-style</code> option, which takes the same values as <code>ui.conflict-marker-style</code>.</p>"},{"location":"config.html#code-formatting-and-other-file-content-transformations","title":"Code formatting and other file content transformations","text":"<p>The <code>jj fix</code> command allows you to efficiently rewrite files in complex commit graphs with no risk of introducing conflicts, using tools like <code>clang-format</code> or <code>prettier</code>. The tools run as subprocesses that take file content on standard input and repeat it, with any desired changes, on standard output. The file is only rewritten if the subprocess produces a successful exit code.</p>"},{"location":"config.html#enforce-coding-style-rules","title":"Enforce coding style rules","text":"<p>Suppose you want to use <code>clang-format</code> to format your <code>*.c</code> and <code>*.h</code> files, as well as sorting their <code>#include</code> directives.</p> <p><code>jj fix</code> provides the file content anonymously on standard input, but the name of the file being formatted may be important for include sorting or other output like error messages. To address this, you can use the <code>$path</code> substitution to provide the name of the file in a command argument.</p> <pre><code>[fix.tools.clang-format]\ncommand = [\"/usr/bin/clang-format\", \"--sort-includes\", \"--assume-filename=$path\"]\npatterns = [\"glob:'**/*.c'\",\n            \"glob:'**/*.h'\"]\n</code></pre>"},{"location":"config.html#sort-and-remove-duplicate-lines-from-a-file","title":"Sort and remove duplicate lines from a file","text":"<p><code>jj fix</code> can also be used with tools that are not considered code formatters.</p> <p>Suppose you have a list of words in a text file in your repository, and you want to keep the file sorted alphabetically and remove any duplicate words.</p> <pre><code>[fix.tools.sort-word-list]\ncommand = [\"sort\", \"-u\"]\npatterns = [\"word_list.txt\"]\n</code></pre>"},{"location":"config.html#execution-order-of-tools","title":"Execution order of tools","text":"<p>If two or more tools affect the same file, they are executed in the ascending lexicographical order of their configured names. This will remain as a tie breaker if other ordering mechanisms are introduced in the future. If you use numbers in tool names to control execution order, remember to include enough leading zeros so that, for example, <code>09</code> sorts before <code>10</code>.</p> <p>Suppose you want to keep only the 10 smallest numbers in a text file that contains one number on each line. This can be accomplished with <code>sort</code> and <code>head</code>, but execution order is important.</p> <pre><code>[fix.tools.1-sort-numbers-file]\ncommand = [\"sort\", \"-n\"]\npatterns = [\"numbers.txt\"]\n\n[fix.tools.2-truncate-numbers-file]\ncommand = [\"head\", \"-n\", \"10\"]\npatterns = [\"numbers.txt\"]\n</code></pre>"},{"location":"config.html#disabling-and-enabling-tools","title":"Disabling and enabling tools","text":"<p>Tools can be disabled and enabled with the optional <code>enabled</code> config. This allows you to define tools globally but enable them only for specific repositories.</p> <p>In the user configuration, define a disabled tool for running rustfmt:</p> <pre><code>[fix.tools.rustfmt]\nenabled = false\ncommand = [\"rustfmt\", \"--emit\", \"stdout\"]\npatterns = [\"glob:'**/*.rs'\"]\n</code></pre> <p>Then to use the tool in a specific repository, set the <code>enabled</code> config:</p> <pre><code>$ jj config set --repo fix.tools.rustfmt.enabled true\n</code></pre>"},{"location":"config.html#commit-signing","title":"Commit Signing","text":"<p><code>jj</code> can be configured to sign and verify the commits it creates using either GnuPG or SSH signing keys.</p> <p>To do this you need to configure a signing backend.</p> <p>Setting the backend to <code>\"none\"</code> disables signing.</p>"},{"location":"config.html#gnupg-signing","title":"GnuPG Signing","text":"<pre><code>[signing]\nsign-all = true\nbackend = \"gpg\"\nkey = \"4ED556E9729E000F\"\n## You can set `key` to anything accepted by `gpg -u`\n# key = \"signing@example.com\"\n</code></pre> <p>By default the gpg backend will look for a <code>gpg</code> binary on your path. If you want to change the program used or specify a path to <code>gpg</code> explicitly you can set:</p> <pre><code>[signing]\nbackends.gpg.program = \"gpg2\"\n</code></pre> <p>Also by default the gpg backend will ignore key expiry when verifying commit signatures. To consider expired keys as invalid you can set:</p> <pre><code>[signing]\nbackends.gpg.allow-expired-keys = false\n</code></pre>"},{"location":"config.html#ssh-signing","title":"SSH Signing","text":"<pre><code>[signing]\nsign-all = true\nbackend = \"ssh\"\nkey = \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIGj+J6N6SO+4P8dOZqfR1oiay2yxhhHnagH52avUqw5h\"\n## You can also use a path instead of embedding the key\n# key = \"~/.ssh/id_for_signing.pub\"\n</code></pre> <p>By default the ssh backend will look for a <code>ssh-keygen</code> binary on your path. If you want to change the program used or specify a path to <code>ssh-keygen</code> explicitly you can set:</p> <pre><code>[signing]\nbackends.ssh.program = \"/path/to/ssh-keygen\"\n</code></pre> <p>When verifying commit signatures the ssh backend needs to be provided with an allowed-signers file containing the public keys of authors whose signatures you want to be able to verify.</p> <p>You can find the format for this file in the ssh-keygen man page. This can be provided as follows:</p> <pre><code>[signing]\nbackends.ssh.allowed-signers = \"/path/to/allowed-signers\"\n</code></pre>"},{"location":"config.html#sign-commits-only-on-jj-git-push","title":"Sign commits only on <code>jj git push</code>","text":"<p>Instead of signing all commits during creation when <code>signing.sign-all</code> is set to <code>true</code>, the <code>git.sign-on-push</code> configuration can be used to sign commits only upon running <code>jj git push</code>. All mutable unsigned commits being pushed will be signed prior to pushing. This might be preferred if the signing backend requires user interaction or is slow, so that signing is performed in a single batch operation.</p> <pre><code># Configure signing backend as before, without setting `signing.sign-all`\n[signing]\nbackend = \"ssh\"\nkey = \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIGj+J6N6SO+4P8dOZqfR1oiay2yxhhHnagH52avUqw5h\"\n\n[git]\nsign-on-push = true\n</code></pre>"},{"location":"config.html#commit-signature-verification","title":"Commit Signature Verification","text":"<p>By default signature verification and display is disabled as it incurs a performance cost when rendering medium to large change logs.</p> <p>If you want to display commit signatures in your templates, you can use <code>commit.signature()</code> (see Commit type). The returned CryptographicSignature Type provides methods to retrieve signature details.</p>"},{"location":"config.html#git-settings","title":"Git settings","text":""},{"location":"config.html#default-remotes-for-jj-git-fetch-and-jj-git-push","title":"Default remotes for <code>jj git fetch</code> and <code>jj git push</code>","text":"<p>By default, if a single remote exists it is used for <code>jj git fetch</code> and <code>jj git push</code>; however if multiple remotes exist, the default remote is assumed to be named <code>\"origin\"</code>, just like in Git. Sometimes this is undesirable, e.g. when you want to fetch from a different remote than you push to, such as a GitHub fork.</p> <p>To change this behavior, you can modify the repository configuration variable <code>git.fetch</code>, which can be a single remote, or a list of remotes to fetch from multiple places:</p> <pre><code>jj config set --repo git.fetch \"upstream\"\njj config set --repo git.fetch '[\"origin\", \"upstream\"]'\n</code></pre> <p>Similarly, you can also set the variable <code>git.push</code> to cause <code>jj git push</code> to push to a different remote:</p> <pre><code>jj config set --repo git.push \"github\"\n</code></pre> <p>Note that unlike <code>git.fetch</code>, <code>git.push</code> can currently only be a single remote. This is not a hard limitation, and could be changed in the future if there is demand.</p>"},{"location":"config.html#automatic-local-bookmark-creation","title":"Automatic local bookmark creation","text":"<p>When <code>jj</code> imports a new remote-tracking bookmark from Git, it can also create a local bookmark with the same name. This feature is disabled by default because it may be undesirable in some repositories, e.g.:</p> <ul> <li>There is a remote with a lot of historical bookmarks that you don't   want to be exported to the co-located Git repo.</li> <li>There are multiple remotes with conflicting views of that bookmark,   resulting in an unhelpful conflicted state.</li> </ul> <p>You can enable this behavior by setting <code>git.auto-local-bookmark</code> like so,</p> <pre><code>[git]\nauto-local-bookmark = true\n</code></pre> <p>This setting is applied only to new remote bookmarks. Existing remote bookmarks can be tracked individually by using <code>jj bookmark track</code>/<code>untrack</code> commands.</p> <pre><code># import feature1 bookmark and start tracking it\njj bookmark track feature1@origin\n# delete local gh-pages bookmark and stop tracking it\njj bookmark delete gh-pages\njj bookmark untrack gh-pages@upstream\n</code></pre>"},{"location":"config.html#abandon-commits-that-became-unreachable-in-git","title":"Abandon commits that became unreachable in Git","text":"<p>By default, when <code>jj</code> imports refs from Git, it will look for commits that used to be reachable but no longer are reachable. Those commits will then be abandoned, and any descendant commits will be rebased off of them (as usual when commits are abandoned). You can disable this behavior and instead leave the Git-unreachable commits in your repo by setting:</p> <pre><code>[git]\nabandon-unreachable-commits = false\n</code></pre>"},{"location":"config.html#prefix-for-generated-bookmarks-on-push","title":"Prefix for generated bookmarks on push","text":"<p><code>jj git push --change</code> generates bookmark names with a prefix of \"push-\" by default. You can pick a different prefix by setting <code>git.push-bookmark-prefix</code>. For example:</p> <pre><code>[git]\npush-bookmark-prefix = \"martinvonz/push-\"\n</code></pre>"},{"location":"config.html#set-of-private-commits","title":"Set of private commits","text":"<p>You can configure the set of private commits by setting <code>git.private-commits</code> to a revset. The value is a revset of commits that Jujutsu will refuse to push. If unset, all commits are eligible to be pushed.</p> <pre><code>[git]\n# Prevent pushing work in progress or anything explicitly labeled \"private\"\nprivate-commits = \"description(glob:'wip:*') | description(glob:'private:*')\"\n</code></pre> <p>If a commit is in <code>git.private-commits</code> but is already on the remote, then it is not considered a private commit. Commits that are immutable are also excluded from the private set.</p> <p>Private commits prevent their descendants from being pushed, since doing so would require pushing the private commit as well.</p>"},{"location":"config.html#git-subprocessing-behaviour","title":"Git subprocessing behaviour","text":"<p>By default, Git remote interactions are handled by <code>libgit2</code>. This sometimes causes SSH problems that cannot be solved by <code>jj</code> directly.</p> <p>To sidestep this, there is an option to spawn a <code>git</code> subprocess to handle those remote interactions:</p> <pre><code>[git]\nsubprocess = true\n</code></pre> <p>Additionally, if <code>git</code> is not on your OS path, or you want to specify a particular binary, you can:</p> <pre><code>[git]\nexecutable-path = \"/path/to/git\"\n</code></pre>"},{"location":"config.html#filesystem-monitor","title":"Filesystem monitor","text":"<p>In large repositories, it may be beneficial to use a \"filesystem monitor\" to track changes to the working copy. This allows <code>jj</code> to take working copy snapshots without having to rescan the entire working copy.</p> <p>This is governed by the <code>core.fsmonitor</code> option. Currently, the valid values are <code>\"none\"</code> or <code>\"watchman\"</code>.</p>"},{"location":"config.html#watchman","title":"Watchman","text":"<p>To configure the Watchman filesystem monitor, set <code>core.fsmonitor = \"watchman\"</code>. Ensure that you have installed the Watchman executable on your system.</p> <p>You can configure <code>jj</code> to use watchman triggers to automatically create snapshots on filesystem changes by setting <code>core.watchman.register_snapshot_trigger = true</code>.</p> <p>You can check whether Watchman is enabled and whether it is installed correctly using <code>jj debug watchman status</code>.</p>"},{"location":"config.html#snapshot-settings","title":"Snapshot settings","text":""},{"location":"config.html#paths-to-automatically-track","title":"Paths to automatically track","text":"<p>All new files in the working copy that don't match the ignore patterns are tracked by default. You can set the <code>snapshot.auto-track</code> to set which paths get automatically tracked when they're added to the working copy. See the fileset documentation for the syntax. Files with paths matching ignore files are never tracked automatically.</p> <p>You can use <code>jj file untrack</code> to untrack a file while keeping it in the working copy. However, first ignore them or remove them from the <code>snapshot.auto-track</code> patterns; otherwise they will be immediately tracked again.</p>"},{"location":"config.html#maximum-size-for-new-files","title":"Maximum size for new files","text":"<p>By default, as an anti-footgun measure, <code>jj</code> will refuse to add new files to the snapshot that are larger than a certain size; the default is 1MiB. This can be changed by setting <code>snapshot.max-new-file-size</code> to a different value. For example:</p> <pre><code>[snapshot]\nmax-new-file-size = \"10MiB\"\n# the following is equivalent\nmax-new-file-size = 10485760\n</code></pre> <p>The value can be specified using a human readable string with typical suffixes; <code>B</code>, <code>MiB</code>, <code>GB</code>, etc. By default, if no suffix is provided, or the value is a raw integer literal, the value is interpreted as if it were specified in bytes.</p> <p>Files that already exist in the working copy are not subject to this limit.</p> <p>Setting this value to zero will disable the limit entirely.</p>"},{"location":"config.html#ways-to-specify-jj-config-details","title":"Ways to specify <code>jj</code> config: details","text":""},{"location":"config.html#user-config-file","title":"User config file","text":"<p>An easy way to find the user config file is:</p> <pre><code>jj config path --user\n</code></pre> <p>The rest of this section covers the details of where this file can be located.</p> <p>On all platforms, the user's global <code>jj</code> configuration file is located at either <code>~/.jjconfig.toml</code> (where <code>~</code> represents <code>$HOME</code> on Unix-likes, or <code>%USERPROFILE%</code> on Windows) or in a platform-specific directory. The platform-specific location is recommended for better integration with platform services. It is an error for both of these files to exist.</p> Platform Value Example Linux <code>$XDG_CONFIG_HOME/jj/config.toml</code> <code>/home/alice/.config/jj/config.toml</code> macOS <code>$HOME/Library/Application Support/jj/config.toml</code> <code>/Users/Alice/Library/Application Support/jj/config.toml</code> Windows <code>{FOLDERID_RoamingAppData}\\jj\\config.toml</code> <code>C:\\Users\\Alice\\AppData\\Roaming\\jj\\config.toml</code> <p>The location of the <code>jj</code> config file can also be overridden with the <code>JJ_CONFIG</code> environment variable. If it is not empty, it should contain the path to a TOML file that will be used instead of any configuration file in the default locations. For example,</p> <pre><code>env JJ_CONFIG=/dev/null jj log       # Ignores any settings specified in the config file.\n</code></pre>"},{"location":"config.html#json-schema-support","title":"JSON Schema Support","text":"<p>Many popular editors support TOML file syntax highlighting and validation. To enable schema validation in your editor, add this line at the top of your TOML config files:</p> <pre><code>\"$schema\" = \"https://jj-vcs.github.io/jj/latest/config-schema.json\"\n</code></pre> <p>This enables features like:</p> <ul> <li>Autocomplete for config keys</li> <li>Type checking of values</li> <li>Documentation on hover</li> <li>Validation of settings</li> </ul> <p>Here are some popular editors with TOML schema validation support:</p> <ul> <li> <p>VS Code</p> <ul> <li>Install Even Better TOML</li> </ul> </li> <li> <p>Neovim/Vim</p> <ul> <li>Use with nvim-lspconfig and taplo</li> </ul> </li> <li> <p>JetBrains IDEs (IntelliJ, PyCharm, etc)</p> <ul> <li>Install TOML plugin</li> </ul> </li> <li> <p>Sublime Text</p> <ul> <li>Install LSP and LSP-taplo</li> </ul> </li> <li> <p>Emacs</p> <ul> <li>Install lsp-mode and toml-mode</li> <li>Configure taplo as the LSP server</li> </ul> </li> </ul>"},{"location":"config.html#specifying-config-on-the-command-line","title":"Specifying config on the command-line","text":"<p>You can use one or more <code>--config</code>/<code>--config-file</code> options on the command line to specify additional configuration settings. This overrides settings defined in config files or environment variables. For example,</p> <pre><code># Must not have spaces around the `=`\njj --config ui.color=always --config ui.diff-editor=meld split\n</code></pre> <p>Config value should be specified as a TOML expression. If string value doesn't contain any TOML constructs (such as array notation), quotes can be omitted. Here is an example with more advanced TOML constructs:</p> <pre><code># Single quotes and the '\\' are interpreted by the shell and assume a Unix shell\n# Double quotes are passed to jj and are parsed as TOML syntax\njj log --config \\\n  'template-aliases.\"format_timestamp(timestamp)\"=\"\"\"timestamp.format(\"%Y-%m-%d %H:%M %:::z\")\"\"\"'\n</code></pre> <p>To load an entire TOML document, use <code>--config-file</code>:</p> <pre><code>jj --config-file=extra-config.toml log\n</code></pre>"},{"location":"config.html#conditional-variables","title":"Conditional variables","text":"<p>You can conditionally enable config variables by using <code>--when</code> and <code>[[--scope]]</code> tables. Variables defined in <code>[[--scope]]</code> tables are expanded to the root table. <code>--when</code> specifies the condition to enable the scope table.</p> <p>If no conditions are specified, table is always enabled. If multiple conditions are specified, the intersection is used.</p> <pre><code>[user]\nname = \"YOUR NAME\"\nemail = \"YOUR_DEFAULT_EMAIL@example.com\"\n\n# override user.email if the repository is located under ~/oss\n[[--scope]]\n--when.repositories = [\"~/oss\"]\n[--scope.user]\nemail = \"YOUR_OSS_EMAIL@example.org\"\n\n# disable pagination for `jj status`, use `delta` for `jj diff` and `jj show`\n[[--scope]]\n--when.commands = [\"status\"]\n[--scope.ui]\npaginate = \"never\"\n[[--scope]]\n--when.commands = [\"diff\", \"show\"]\n[--scope.ui]\npager = \"delta\"\n</code></pre> <p>Condition keys:</p> <ul> <li> <p><code>--when.repositories</code>: List of paths to match the repository path prefix.</p> <p>Paths should be absolute. Each path component (directory or file name, drive letter, etc.) is compared case-sensitively on all platforms. A path starting with <code>~</code> is expanded to the home directory. On Windows, directory separator may be either <code>\\</code> or <code>/</code>. (Beware that <code>\\</code> needs escape in double-quoted strings.)</p> <p>Use <code>jj root</code> to see the workspace root directory. Note that the repository path is in the main workspace if you're using multiple workspaces with <code>jj workspace</code>.</p> </li> <li> <p><code>--when.commands</code>: List of subcommands to match.</p> <p>Subcommands are space-separated and matched by prefix.</p> <pre><code>--when.commands = [\"file\"]        # matches `jj file show`, `jj file list`, etc\n--when.commands = [\"file show\"]   # matches `jj file show` but *NOT* `jj file list`\n--when.commands = [\"file\", \"log\"] # matches `jj file` *OR* `jj log` (or subcommand of either)\n</code></pre> </li> </ul>"},{"location":"conflicts.html","title":"First-class conflicts","text":""},{"location":"conflicts.html#introduction","title":"Introduction","text":"<p>Conflicts happen when Jujutsu can't figure out how to merge different changes made to the same file. For instance, this can happen if two people are working on the same file and make different changes to the same part of the file, and then their commits are merged together with <code>jj new</code> (or one is rebased onto the other with <code>jj rebase</code>).</p> <p>Unlike most other VCSs, Jujutsu can record conflicted states in commits. For example, if you rebase a commit and it results in a conflict, the conflict will be recorded in the rebased commit and the rebase operation will succeed. You can then resolve the conflict whenever you want. Conflicted states can be further rebased, merged, or backed out. Note that what's stored in the commit is a logical representation of the conflict, not conflict markers; rebasing a conflict doesn't result in a nested conflict markers (see technical doc for how this works).</p>"},{"location":"conflicts.html#advantages","title":"Advantages","text":"<p>The deeper understanding of conflicts has many advantages:</p> <ul> <li>Removes the need for things like   <code>git rebase/merge/cherry-pick/etc --continue</code>. Instead, you get a single   workflow for resolving conflicts: check out the conflicted commit, resolve   conflicts, and amend.</li> <li>Enables the \"auto-rebase\" feature, where descendants of rewritten commits   automatically get rewritten. This feature mostly replaces Mercurial's   Changeset Evolution.</li> <li>Lets us define the change in a merge commit as being compared to the merged   parents. That way, we can rebase merge commits correctly (unlike both Git and   Mercurial). That includes conflict resolutions done in the merge commit,   addressing a common use case for   git rerere.   Since the changes in a merge commit are displayed and rebased as expected,   evil merges   are arguably not as evil anymore.</li> <li>Allows you to postpone conflict resolution until you're ready for it. You   can easily keep all your work-in-progress commits rebased onto upstream's head   if you like.</li> <li>Criss-cross merges   and octopus merges   become trivial (implementation-wise); some cases that Git can't currently   handle, or that would result in nested conflict markers, can be automatically   resolved.</li> <li>Enables collaborative conflict resolution. (This assumes that you can share   the conflicts with others, which you probably shouldn't do if some people   interact with your project using Git.)</li> </ul> <p>For information about how conflicts are handled in the working copy, see here.</p>"},{"location":"conflicts.html#conflict-markers","title":"Conflict markers","text":"<p>Conflicts are \"materialized\" using conflict markers in various contexts. For example, when you run <code>jj new</code> or <code>jj edit</code> on a commit with a conflict, it will be materialized in the working copy. Conflicts are also materialized when they are part of diff output (e.g. <code>jj show</code> on a commit that introduces or resolves a conflict).</p> <p>As an example, imagine that you have a file which contains the following text, all in lowercase:</p> <pre><code>apple\ngrape\norange\n</code></pre> <p>One person replaces the word \"grape\" with \"grapefruit\" in commit A, while another person changes every line to uppercase in commit B. If you merge the changes together with <code>jj new A B</code>, the resulting commit will have a conflict since Jujutsu can't figure out how to combine these changes. Therefore, Jujutsu will materialize the conflict in the working copy using conflict markers, which would look like this:</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; Conflict 1 of 1\n%%%%%%% Changes from base to side #1\n apple\n-grape\n+grapefruit\n orange\n+++++++ Contents of side #2\nAPPLE\nGRAPE\nORANGE\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; Conflict 1 of 1 ends\n</code></pre> <p>The markers <code>&lt;&lt;&lt;&lt;&lt;&lt;&lt;</code> and <code>&gt;&gt;&gt;&gt;&gt;&gt;&gt;</code> indicate the start and end of a conflict respectively. The marker <code>+++++++</code> indicates the start of a snapshot, while the marker <code>%%%%%%%</code> indicates the start of a diff to apply to the snapshot. Therefore, to resolve this conflict, you would apply the diff (changing \"grape\" to \"grapefruit\") to the snapshot (the side with every line in uppercase), editing the file to look like this:</p> <pre><code>APPLE\nGRAPEFRUIT\nORANGE\n</code></pre> <p>In practice, conflicts are usually 2-sided, meaning that there's only 2 conflicting changes being merged together at a time, but Jujutsu supports conflicts with arbitrarily many sides, which can happen when merging 3 or more commits at once. In that case, you would see a single snapshot section and multiple diff sections.</p> <p>Compared to just showing the content of each side of the conflict, the main benefit of Jujutsu's style of conflict markers is that you don't need to spend time manually comparing the sides to spot the differences between them. This is especially beneficial for many-sided conflicts, since resolving them just requires applying each diff to the snapshot one-by-one.</p>"},{"location":"conflicts.html#alternative-conflict-marker-styles","title":"Alternative conflict marker styles","text":"<p>If you prefer to just see the contents of each side of the conflict without the diff, Jujutsu also supports a \"snapshot\" style, which can be enabled by setting the <code>ui.conflict-marker-style</code> config option to \"snapshot\":</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; Conflict 1 of 1\n+++++++ Contents of side #1\napple\ngrapefruit\norange\n------- Contents of base\napple\ngrape\norange\n+++++++ Contents of side #2\nAPPLE\nGRAPE\nORANGE\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; Conflict 1 of 1 ends\n</code></pre> <p>Some tools expect Git-style conflict markers, so Jujutsu also supports Git's \"diff3\" style conflict markers by setting the <code>ui.conflict-marker-style</code> config option to \"git\":</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; Side #1 (Conflict 1 of 1)\napple\ngrapefruit\norange\n||||||| Base\napple\ngrape\norange\n=======\nAPPLE\nGRAPE\nORANGE\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; Side #2 (Conflict 1 of 1 ends)\n</code></pre> <p>This conflict marker style only supports 2-sided conflicts though, so it falls back to the similar \"snapshot\" conflict markers if there are more than 2 sides to the conflict.</p>"},{"location":"conflicts.html#long-conflict-markers","title":"Long conflict markers","text":"<p>Some files may contain lines which could be confused for conflict markers. For instance, a line could start with <code>=======</code>, which looks like a Git-style conflict marker. To ensure that it's always unambiguous which lines are conflict markers and which are just part of the file contents, <code>jj</code> sometimes uses conflict markers which are longer than normal:</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt; Conflict 1 of 1\n%%%%%%%%%%%%%%% Changes from base to side #1\n-Heading\n+HEADING\n =======\n+++++++++++++++ Contents of side #2\nNew Heading\n===========\n&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt; Conflict 1 of 1 ends\n</code></pre>"},{"location":"conflicts.html#conflicts-with-missing-terminating-newline","title":"Conflicts with missing terminating newline","text":"<p>When materializing conflicts, <code>jj</code> outputs them in a line-based format. This format is easiest to interpret for text files that consist of a series of lines, with each line terminated by a newline character (<code>\\n</code>). This means that a text file should either be empty, or it should end with a newline character.</p> <p>While most text files follow this convention, some do not. When <code>jj</code> encounters a missing terminating newline character in a conflict, it will add a comment to the conflict markers to make the conflict easier to interpret. If you don't care about whether your file ends with a terminating newline character, you can generally ignore this comment and resolve the conflict normally.</p> <p>For instance, if a file originally contained <code>grape</code> with no terminating newline character, and one person changed <code>grape</code> to <code>grapefruit</code>, while another person added the missing newline character to make <code>grape\\n</code>, the resulting conflict would look like this:</p> <pre><code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; Conflict 1 of 1\n+++++++ Contents of side #1 (no terminating newline)\ngrapefruit\n%%%%%%% Changes from base to side #2 (adds terminating newline)\n-grape\n+grape\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; Conflict 1 of 1 ends\n</code></pre> <p>Therefore, a resolution of this conflict could be <code>grapefruit\\n</code>, with the terminating newline character added.</p>"},{"location":"contributing.html","title":"How to Contribute","text":""},{"location":"contributing.html#policies","title":"Policies","text":"<p>We'd love to accept your patches and contributions to this project. There are just a few small guidelines you need to follow.</p>"},{"location":"contributing.html#contributor-license-agreement","title":"Contributor License Agreement","text":"<p>Contributions to this project must be accompanied by a Contributor License Agreement. You (or your employer) retain the copyright to your contribution; this simply gives us permission to use and redistribute your contributions as part of the project. Head over to https://cla.developers.google.com/ to see your current agreements on file or to sign a new one.</p> <p>You generally only need to submit a CLA once, so if you've already submitted one (even if it was for a different project), you probably don't need to do it again.</p>"},{"location":"contributing.html#commit-guidelines","title":"Commit guidelines","text":"<p>Unlike many GitHub projects (but like many VCS projects), we care more about the contents of commits than about the contents of PRs. We review each commit separately, and we don't squash-merge the PR (so please manually squash any fixup commits before sending for review).</p> <p>Each commit should ideally do one thing. For example, if you need to refactor a function in order to add a new feature cleanly, put the refactoring in one commit and the new feature in a different commit. If the refactoring itself consists of many parts, try to separate out those into separate commits. You can use <code>jj split</code> to do it if you didn't realize ahead of time how it should be split up. Include tests and documentation in the same commit as the code they test and document.</p> <p>The commit message should describe the changes in the commit; the PR description can even be empty, but feel free to include a personal message. We start the commit message with <code>&lt;topic&gt;:</code>  and don't use conventional commits. This means if you modified a command in the CLI, use its name as the topic, e.g. <code>next/prev: &lt;your-modification&gt;</code> or <code>conflicts: &lt;your-modification&gt;</code>. We don't currently have a specific guidelines on what to write in the topic field, but the reviewers will help you provide a topic if you have difficulties choosing it. How to Write a Git Commit Message is a good guide if you're new to writing good commit messages. We are not particularly strict about the style, but please do explain the reason for the change unless it's obvious.</p>"},{"location":"contributing.html#code-reviews","title":"Code reviews","text":"<p>All submissions, including submissions by project members, require review. We use GitHub pull requests for this purpose. Consult GitHub Help for more information on using pull requests.</p> <p>When you address comments on a PR, don't make the changes in a commit on top (as is typical on GitHub). Instead, please make the changes in the appropriate commit. You can do that by creating a new commit on top of the initial commit  (<code>jj new &lt;commit&gt;</code>) and then squash in the changes when you're done (<code>jj squash</code>). <code>jj git push</code> will automatically force-push the bookmark.</p> <p>When your first PR has been approved, we typically invite you to the <code>jj-vcs/contributors</code> team to give you contributor access, so you can address any remaining minor comments and then merge the PR yourself when you're ready. If you realize that some comments require non-trivial changes, please ask your reviewer to take another look.</p> <p>To avoid conflicts of interest, please don't merge a PR that has only been approved by someone from the same organization. Similarly, as a reviewer, there is no need to approve your coworkers' PRs, since the author should await an approval from someone else anyway. It is of course still appreciated if you review and comment on their PRs. Also, if the PR seems completely unrelated to your company's interests, do feel free to approve it.</p>"},{"location":"contributing.html#community-guidelines","title":"Community Guidelines","text":"<p>This project follows Google's Open Source Community Guidelines.</p>"},{"location":"contributing.html#contributing-large-patches","title":"Contributing large patches","text":"<p>Before sending a PR for a large change which designs/redesigns or reworks an existing component, we require an architecture review from  multiple stakeholders, which we do with Design Docs, see the process here.</p>"},{"location":"contributing.html#contributing-to-the-documentation","title":"Contributing to the documentation","text":"<p>We appreciate bug reports about any problems, however small, lurking in our documentation website or in the <code>jj help &lt;command&gt;</code> docs. If a part of the bug report template does not apply, you can just delete it.</p> <p>Before reporting a problem with the documentation website, we'd appreciate it if you could check that the problem still exists in the \"prerelease\" version of the documentation (as opposed to the docs for one of the released versions of <code>jj</code>). You can use the version switcher in the top-left of the website to do so.</p> <p>If you are willing to make a PR fixing a documentation problem, even better!</p> <p>The documentation website sources are Markdown files located in the <code>docs/</code> directory. You do not need to know Rust to work with them. See below for instructions on how to preview the HTML docs as you edit the Markdown files. Doing so is optional, but recommended.</p> <p>The <code>jj help</code> docs are sourced from the \"docstring\" comments inside the Rust sources, currently from the <code>cli/src/commands</code> directory. Working on them requires setting up a Rust development environment, as described below, and may occasionally require adjusting a test.</p>"},{"location":"contributing.html#learning-rust","title":"Learning Rust","text":"<p>In addition to the Rust Book and the other excellent resources at https://www.rust-lang.org/learn, we recommend the \"Comprehensive Rust\" mini-course for an overview, especially if you are familiar with C++.</p>"},{"location":"contributing.html#setting-up-a-development-environment","title":"Setting up a development environment","text":"<p>To develop <code>jj</code>, the mandatory steps are simply to install Rust (the default installer options are fine), clone the repository, and use <code>cargo build</code> , <code>cargo fmt</code>, <code>cargo clippy --workspace --all-targets</code>, and <code>cargo test --workspace</code>. If you are preparing a PR, there are some additional recommended steps.</p>"},{"location":"contributing.html#summary","title":"Summary","text":"<p>One-time setup:</p> <pre><code>rustup toolchain add nightly  # wanted for 'rustfmt'\nrustup toolchain add 1.76     # also specified in Cargo.toml\ncargo install --locked bacon\ncargo install --locked cargo-insta\ncargo install --locked cargo-nextest\n</code></pre> <p>During development (adapt according to your preference):</p> <pre><code>bacon clippy-all\ncargo +nightly fmt # Occasionally\ncargo nextest run --workspace # Occasionally\ncargo insta test --workspace --test-runner nextest # Occasionally\n</code></pre> <p>Warning</p> <p>Build artifacts from debug builds and especially from repeated invocations of <code>cargo test</code> can quickly take up 10s of GB of disk space. Cargo will happily use up your entire hard drive. If this happens, run <code>cargo clean</code>.</p>"},{"location":"contributing.html#explanation","title":"Explanation","text":"<p>These are listed roughly in order of decreasing importance.</p> <ol> <li> <p>Nearly any change to <code>jj</code>'s CLI will require writing or updating snapshot    tests that use the <code>insta</code> crate. To make this    convenient, install the <code>cargo-insta</code> binary.    Use <code>cargo insta test --workspace</code> to run tests,    and <code>cargo insta review --workspace</code> to update the snapshot tests.    The <code>--workspace</code> flag is needed to run the tests on all crates; by default,    only the crate in the current directory is tested.</p> </li> <li> <p>GitHub CI checks require that the code is formatted with the nightly    version of <code>rustfmt</code>. To do this on your computer, install the nightly    toolchain and use <code>cargo +nightly fmt</code>.</p> </li> <li> <p>Your code will be rejected if it cannot be compiled with the minimal    supported version of Rust (\"MSRV\"). Currently, <code>jj</code> follows a rather    casual MSRV policy: \"The current <code>rustc</code> stable version, minus one.\"    As of this writing, that version is 1.76.0.</p> </li> <li> <p>Your code needs to pass <code>cargo clippy</code>. You can also    use <code>cargo +nightly clippy</code> if you wish to see more warnings.</p> </li> <li> <p>You may also want to install and use <code>bacon</code>,    to automatically build, check, and / or run tests.</p> </li> <li> <p>To run tests more quickly, use <code>cargo nextest run --workspace</code>. To    use <code>nextest</code> with <code>insta</code>, use <code>cargo insta test --workspace    --test-runner nextest</code>.</p> <p>On Linux, you may be able to speed up <code>nextest</code> even further by using  the <code>mold</code> linker, as explained below.</p> </li> </ol>"},{"location":"contributing.html#configuring-jj-fix-to-run-rustfmt","title":"Configuring <code>jj fix</code> to run <code>rustfmt</code>","text":"<p>Run this in the jj repo:</p> <pre><code>jj config set --repo fix.tools.rustfmt '{ command = [\"rustfmt\", \"+nightly\"], patterns = [\"glob:**/*.rs\"] }'\n</code></pre>"},{"location":"contributing.html#using-mold-for-faster-tests-on-linux","title":"Using <code>mold</code> for faster tests on Linux","text":"<p>On a machine with a multi-core CPU, one way to speed up <code>cargo nextest</code> on Linux is to use the multi-threaded <code>mold</code> linker. This linker may help if, currently, your CPU is underused while Rust is linking test binaries. Before proceeding with <code>mold</code>, you can check whether this is an issue worth solving using a system monitoring tool such as <code>htop</code>.</p> <p><code>mold</code> is packaged for many distributions. On Debian, for example, <code>sudo apt install mold</code> should just work.</p> <p>A simple way to use <code>mold</code> is via the <code>-run</code> option, e.g.:</p> <pre><code>mold -run cargo insta test --workspace --test-runner nextest\n</code></pre> <p>There will be no indication that a different linker is used, except for higher CPU usage while linking and, hopefully, faster completion. You can verify that <code>mold</code> was indeed used by running <code>readelf -p .comment target/debug/jj</code>.</p> <p>There are also ways of having Rust use <code>mold</code> by default, see the \"How to use\" instructions.</p> <p>On recent versions of MacOS, the default linker Rust uses is already multi-threaded. It should use all the CPU cores without any configuration.</p>"},{"location":"contributing.html#editor-setup","title":"Editor setup","text":""},{"location":"contributing.html#visual-studio-code","title":"Visual Studio Code","text":"<p>We recommend at least these settings:</p> <pre><code>{\n    \"files.insertFinalNewline\": true,\n    \"files.trimTrailingWhitespace\": true,\n    \"[rust]\": {\n        \"files.trimTrailingWhitespace\": false\n    }\n}\n</code></pre>"},{"location":"contributing.html#zed","title":"Zed","text":"<pre><code>// .zed/settings.json\n{\n  \"ensure_final_newline_on_save\": true,\n  \"remove_trailing_whitespace_on_save\": true,\n\n  \"languages\": {\n    // We don't use a formatter for Markdown files, so format_on_save would just\n    // mess with others' docs\n    \"Markdown\": { \"format_on_save\": \"off\" }\n    \"Rust\": {\n      \"format_on_save\": \"on\",\n      // Avoid removing trailing spaces within multi-line string literals\n      \"remove_trailing_whitespace_on_save\": false\n    }\n  },\n\n  \"lsp\": {\n    \"rust-analyzer\": {\n      \"initialization_options\": {\n        // If you are working on docs and don't need `cargo check`, uncomment\n        // this option:\n        //\n        //   \"checkOnSave\": false,\n\n        // Use nightly `rustfmt`, equivalent to `cargo +nightly fmt`\n        \"rustfmt\": { \"extraArgs\": [\"+nightly\"] }\n      }\n    }\n  }\n}\n</code></pre>"},{"location":"contributing.html#previewing-the-html-documentation","title":"Previewing the HTML documentation","text":"<p>The documentation for <code>jj</code> is automatically published online at https://jj-vcs.github.io/jj/.</p> <p>When editing documentation, you should check your changes locally \u2014 especially if you are adding a new page, or doing a major rewrite.</p>"},{"location":"contributing.html#install-uv","title":"Install <code>uv</code>","text":"<p>The only thing you need is <code>uv</code> (version 0.5.1 or newer).</p> <p><code>uv</code> is a Python project manager written in Rust. It will fetch the right Python version and the dependencies needed to build the docs. Install it like so:</p> macOS/LinuxWindowsHomebrewCargoOther options <pre><code>curl -LsSf https://astral.sh/uv/install.sh | sh\n</code></pre> <p>Note</p> <p>If you don't have <code>~/.local/bin</code> in your <code>PATH</code>, the installer will modify your shell profile. To avoid it:</p> <pre><code>curl -LsSf https://astral.sh/uv/install.sh | env INSTALLER_NO_MODIFY_PATH=1 sh\n</code></pre> <pre><code>powershell -ExecutionPolicy ByPass -c \"irm https://astral.sh/uv/install.ps1 | iex\"\n</code></pre> <pre><code>brew install uv\n</code></pre> <pre><code># This might take a while\ncargo install --git https://github.com/astral-sh/uv uv\n</code></pre> <ul> <li>Directly download the binaries from GitHub: uv releases.</li> <li>Even more options: Installing uv.</li> </ul>"},{"location":"contributing.html#build-the-docs","title":"Build the docs","text":"<p>To build the docs, run from the root of the <code>jj</code> repository:</p> <pre><code>uv run mkdocs serve\n</code></pre> <p>Open http://127.0.0.1:8000 in your browser to see the docs.</p> <p>As you edit the <code>.md</code> files in <code>docs/</code>, the website should be rebuilt and reloaded in your browser automatically.</p> <p>If the docs are not updating</p> <p>Check the terminal from which you ran <code>uv run mkdocs serve</code> for any build errors or warnings. Warnings about <code>\"GET /versions.json HTTP/1.1\" code 404</code> are expected and harmless.</p>"},{"location":"contributing.html#building-the-entire-website","title":"Building the entire website","text":"<p>Tip</p> <p>Building the entire website is not usually necessary. If you are editing documentation, the previous section is enough.</p> <p>These instructions are relevant if you are working on the versioning of the documentation that we currently do with <code>mike</code>.</p> <p>The full <code>jj</code> website includes the documentation for several <code>jj</code> versions (<code>prerelease</code>, latest release, and the older releases). The top-level URL https://jj-vcs.github.io/jj redirects to https://jj-vcs.github.io/jj/latest, which in turn redirects to the docs for the last stable version.</p> <p>The different versions of documentation are managed and deployed with <code>mike</code>, which can be run with <code>uv run mike</code>.</p> <p>On a POSIX system or WSL, one way to build the entire website is as follows (on Windows, you'll need to understand and adapt the shell script):</p> <ol> <li> <p>Check out <code>jj</code> as a co-located <code>jj + git</code> repository (<code>jj clone --colocate</code>), cloned from your fork of <code>jj</code> (e.g. <code>github.com/jjfan/jj</code>). You can also use a pure Git repo if you prefer.</p> </li> <li> <p>Make sure <code>github.com/jjfan/jj</code> includes the <code>gh-pages</code> bookmark of the jj repo and run <code>git fetch origin gh-pages</code>.</p> </li> <li> <p>Go to the GitHub repository settings, enable GitHub Pages, and configure them to use the <code>gh-pages</code> bookmark (this is usually the default).</p> </li> <li> <p>Install <code>uv</code> as explained in Previewing the HTML documentation, and run the same <code>sh</code> script that is used in GitHub CI (details below):</p> <pre><code>.github/scripts/docs-build-deploy 'https://jjfan.github.io/jj/'\\\n    prerelease main --push\n</code></pre> <p>This should build the version of the docs from the current commit,   deploy it as a new commit to the <code>gh-pages</code> bookmark,   and push the <code>gh-pages</code> bookmark to the origin.</p> </li> <li> <p>Now, you should be able to see the full website, including your latest changes to the <code>prerelease</code> version, at <code>https://jjfan.github.io/jj/prerelease/</code>.</p> </li> <li> <p>(Optional) The previous steps actually only rebuild <code>https://jjfan.github.io/jj/prerelease/</code> and its alias <code>https://jjfan.github.io/jj/main/</code>. If you'd like to test out version switching back and forth, you can also rebuild the docs for the latest release as follows.</p> <pre><code>jj new v1.33.1  # Let's say `jj 1.33.1` is the currently the latest release\n.github/scripts/docs-build-deploy 'https://jjfan.github.io/jj/'\\\n    v1.33.1 latest --push\n</code></pre> </li> <li> <p>(Optional) When you are done, you may want to reset the <code>gh-pages</code> bookmark to the same spot as it is upstream. If you configured the \"upstream\" remote, this can be done with:</p> <pre><code># This will LOSE any changes you made to `gh-pages`\njj git fetch --remote upstream\njj bookmark set gh-pages -r gh-pages@upstream\njj git push --remote origin --bookmark gh-pages\n</code></pre> <p>If you want to preserve some of the changes you made, you can do <code>jj bookmark   set my-changes -r gh-pages</code> BEFORE running the above commands.</p> </li> </ol>"},{"location":"contributing.html#explanation-of-the-docs-build-deploy-script","title":"Explanation of the <code>docs-build-deploy</code> script","text":"<p>The script sets up the <code>site_url</code> mkdocs config to <code>'https://jjfan.github.io/jj/'</code>. If this config does not match the URL where you loaded the website, some minor website features (like the version switching widget) will have reduced functionality.</p> <p>Then, the script passes the rest of its arguments to <code>uv run mike deploy</code>, which does the rest of the job. Run <code>uv run mike help deploy</code> to find out what the arguments do.</p> <p>If you need to do something more complicated, you can use <code>uv run mike ...</code> commands. You can also edit the <code>gh-pages</code> bookmark directly, but take care to avoid files that will be overwritten by future invocations of <code>mike</code>. Then, you can submit a PR based on the <code>gh-pages</code> bookmark of https://martinvonz.github.com/jj (instead of the usual <code>main</code> bookmark).</p>"},{"location":"contributing.html#modifying-protobuffers-this-is-not-common","title":"Modifying protobuffers (this is not common)","text":"<p>Occasionally, you may need to change the <code>.proto</code> files that define jj's data  storage format. In this case, you will need to add a few steps to the above  workflow.</p> <ul> <li>Install the <code>protoc</code> compiler. This usually means either <code>apt-get install    protobuf-compiler</code> or downloading an official release. The    <code>prost</code> library docs have additional advice.</li> <li>Run <code>cargo run -p gen-protos</code> regularly (or after every edit to a <code>.proto</code>    file). This is the same as running <code>cargo run</code> from <code>lib/gen-protos</code>. The    <code>gen-protos</code> binary will use the <code>prost-build</code> library to compile the    <code>.proto</code> files into <code>.rs</code> files.</li> <li>If you are adding a new <code>.proto</code> file, you will need to edit the list of    these files in <code>lib/gen-protos/src/main.rs</code>.</li> </ul> <p>The <code>.rs</code> files generated from <code>.proto</code> files are included in the repository,  and there is a GitHub CI check that will complain if they do not match.</p>"},{"location":"contributing.html#logging","title":"Logging","text":"<p>You can print internal jj logs using <code>JJ_LOG</code>. It acts like the <code>RUST_LOG</code> environment variable, frequent in Rust codebases, and accepts one or more directives. You can also use the <code>--debug</code> global option that sets <code>debug</code> log level for all targets by default. <code>JJ_LOG</code> is still respected when using <code>--debug</code>.</p>"},{"location":"contributing.html#profiling","title":"Profiling","text":"<p>One easy-to-use sampling profiler is samply. For example: <pre><code>cargo install samply\nsamply record jj diff\n</code></pre> Then just open the link it prints.</p> <p>Another option is to use the instrumentation we've added manually (using <code>tracing::instrument</code>) in various places. For example: <pre><code>JJ_TRACE=/tmp/trace.json jj diff\n</code></pre> Then go to <code>https://ui.perfetto.dev/</code> in Chrome and load <code>/tmp/trace.json</code> from there.</p>"},{"location":"design_doc_blueprint.html","title":"Title","text":"<p>A cool name for your Project</p> <p>Author: Your-Name</p> <p>If there are multiple authors, just list them all</p>"},{"location":"design_doc_blueprint.html#summary","title":"Summary","text":"<p>A short summary of your project/re-design/component and what problems it addresses in about 3-10 sentences.</p>"},{"location":"design_doc_blueprint.html#state-of-the-feature-as-of-version-optional","title":"State of the Feature as of <code>$VERSION</code> (optional)","text":"<p>The state of the feature you want to improve and where it currently falls short. If there's nothing to compare to, leave it out.</p>"},{"location":"design_doc_blueprint.html#prior-work-optional","title":"Prior work (optional)","text":"<p>Does this feature exist somewhere else and which tradeoffs it made.</p> <p>If there's no prior work, then use the related work section below.</p>"},{"location":"design_doc_blueprint.html#goals-and-non-goals","title":"Goals and non-goals","text":"<p>Direct goals of the project and features deemed not worth pursuing.</p>"},{"location":"design_doc_blueprint.html#overview","title":"Overview","text":"<p>A detailed overview of the project and the improvements it brings.</p>"},{"location":"design_doc_blueprint.html#detailed-design","title":"Detailed Design","text":"<p>The place to describe all new interfaces and interactions and how it plays into the existing code and behavior. This is the place for all nitty-gritty details which interact with the system.</p>"},{"location":"design_doc_blueprint.html#alternatives-considered-optional","title":"Alternatives considered (optional)","text":"<p>Other alternatives to your suggested approach, and why they fall short.</p>"},{"location":"design_doc_blueprint.html#issues-addressed-optional","title":"Issues addressed (optional)","text":"<p>A list of issues which are addressed by this design.</p>"},{"location":"design_doc_blueprint.html#related-work-optional","title":"Related Work (optional)","text":"<p>If there's a feature in another VCS which shares some similarities to your proposed work, it belongs here. An example would be Jujutsu sparse workspaces and Perforce client workspaces.</p>"},{"location":"design_doc_blueprint.html#future-possibilities","title":"Future Possibilities","text":"<p>The section for things which could be added to it or deemed out of scope during the discussion.</p>"},{"location":"design_docs.html","title":"Jujutsu Design Docs","text":"<p>Jujutsu uses Design Docs to drive technical decisions on large projects and it is the place to discuss your proposed design or new component. It is a very thorough process, in which the design doc must be approved before PRs for the feature will be accepted. It shares some similarities with Rust RFCs but mostly addresses technical problems and  gauges the technical and social concerns of all stakeholders.</p> <p>So if you want to start building the native backend or the server component for Jujutsu, you'll need to go through this process.</p>"},{"location":"design_docs.html#process","title":"Process","text":"<ol> <li>Add a new markdown document to <code>docs/design</code>, named after your improvement    or project.</li> <li>Describe the current state of the world and the things you want to improve.</li> <li>Wait for the Maintainers and Stakeholders to show up.</li> <li>Iterate until everyone accepts the change in normal codereview fashion.</li> </ol>"},{"location":"design_docs.html#blueprint-template","title":"Blueprint (Template)","text":"<p>You can find the base template of a new Design Doc here.</p>"},{"location":"filesets.html","title":"Filesets","text":"<p>Jujutsu supports a functional language for selecting a set of files. Expressions in this language are called \"filesets\" (the idea comes from Mercurial). The language consists of file patterns, operators, and functions.</p> <p>Many <code>jj</code> commands accept fileset expressions as positional arguments. File names passed to these commands must be quoted if they contain whitespace or meta characters. However, as a special case, quotes can be omitted if the expression has no operators nor function calls. For example:</p> <ul> <li><code>jj diff 'Foo Bar'</code> (shell quotes are required, but inner quotes are optional)</li> <li><code>jj diff '~\"Foo Bar\"'</code> (both shell and inner quotes are required)</li> <li><code>jj diff '\"Foo(1)\"'</code> (both shell and inner quotes are required)</li> </ul> <p>Glob characters aren't considered meta characters, but shell quotes are still required:</p> <ul> <li><code>jj diff '~glob:**/*.rs'</code></li> </ul>"},{"location":"filesets.html#file-patterns","title":"File patterns","text":"<p>The following patterns are supported:</p> <ul> <li><code>\"path\"</code>, <code>path</code> (the quotes are optional), or <code>cwd:\"path\"</code>: Matches   cwd-relative path prefix (file or files under directory recursively.)</li> <li><code>cwd-file:\"path\"</code> or <code>file:\"path\"</code>: Matches cwd-relative file (or exact) path.</li> <li><code>cwd-glob:\"pattern\"</code> or <code>glob:\"pattern\"</code>: Matches file paths with cwd-relative   Unix-style shell wildcard <code>pattern</code>. For example, <code>glob:\"*.c\"</code> will   match all <code>.c</code> files in the current working directory non-recursively.</li> <li><code>root:\"path\"</code>: Matches workspace-relative path prefix (file or files under   directory recursively.)</li> <li><code>root-file:\"path\"</code>: Matches workspace-relative file (or exact) path.</li> <li><code>root-glob:\"pattern\"</code>: Matches file paths with workspace-relative Unix-style   shell wildcard <code>pattern</code>.</li> </ul>"},{"location":"filesets.html#operators","title":"Operators","text":"<p>The following operators are supported. <code>x</code> and <code>y</code> below can be any fileset expressions.</p> <ul> <li><code>~x</code>: Matches everything but <code>x</code>.</li> <li><code>x &amp; y</code>: Matches both <code>x</code> and <code>y</code>.</li> <li><code>x ~ y</code>: Matches <code>x</code> but not <code>y</code>.</li> <li><code>x | y</code>: Matches either <code>x</code> or <code>y</code> (or both).</li> </ul> <p>(listed in order of binding strengths)</p> <p>You can use parentheses to control evaluation order, such as <code>(x &amp; y) | z</code> or <code>x &amp; (y | z)</code>.</p>"},{"location":"filesets.html#functions","title":"Functions","text":"<p>You can also specify patterns by using functions.</p> <ul> <li><code>all()</code>: Matches everything.</li> <li><code>none()</code>: Matches nothing.</li> </ul>"},{"location":"filesets.html#examples","title":"Examples","text":"<p>Show diff excluding <code>Cargo.lock</code>.</p> <pre><code>jj diff '~Cargo.lock'\n</code></pre> <p>List files in <code>src</code> excluding Rust sources.</p> <pre><code>jj file list 'src ~ glob:\"**/*.rs\"'\n</code></pre> <p>Split a revision in two, putting <code>foo</code> into the second commit.</p> <pre><code>jj split '~foo'\n</code></pre>"},{"location":"git-comparison.html","title":"Comparison with Git","text":""},{"location":"git-comparison.html#introduction","title":"Introduction","text":"<p>This document attempts to describe how Jujutsu is different from Git. See the Git-compatibility doc for information about how the <code>jj</code> command interoperates with Git repos.</p>"},{"location":"git-comparison.html#overview","title":"Overview","text":"<p>Here is a list of conceptual differences between Jujutsu and Git, along with links to more details where applicable and available. There's a table further down explaining how to achieve various use cases.</p> <ul> <li>The working copy is automatically committed. That results in a simpler and   more consistent CLI because the working copy is now treated like any other   commit. Details.</li> <li>There's no index (staging area). Because the working copy is automatically   committed, an index-like concept doesn't make sense. The index is very similar   to an intermediate commit between <code>HEAD</code> and the working copy, so workflows   that depend on it can be modeled using proper commits instead. Jujutsu has   excellent support for moving changes between commits. Details.</li> <li>No need for branch names (but they are supported as   bookmarks). Git lets you check out a commit without   attaching a branch to it. It calls this state \"detached HEAD\". This is the   normal state in Jujutsu (there's actually no way -- yet, at least -- to have   an active branch/bookmark). However, Jujutsu keeps track of all visible heads   (leaves) of the commit graph, so the commits won't get lost or   garbage-collected.</li> <li> <p>No current branch. Git lets you check out a branch, making it the 'current   branch', and new commits will automatically update the branch. This is   necessary in Git because Git might otherwise lose track of the new commits.</p> <p>Jujutsu does not have a corresponding concept of a 'current bookmark'; instead, you update bookmarks manually. For example, if you start work on top of a commit with a bookmark, new commits are created on top of the bookmark, then you issue a later command to update the bookmark.</p> </li> <li> <p>Conflicts can be committed. No commands fail because of merge conflicts.   The conflicts are instead recorded in commits and you can resolve them later.   Details.</p> </li> <li>Descendant commits are automatically rebased. Whenever you rewrite a   commit (e.g. by running <code>jj rebase</code>), all its descendants commits will   automatically be rebased on top. Branches pointing to it will also get   updated, and so will the working copy if it points to any of the rebased   commits.</li> <li>Bookmarks/branches are identified by their names (across remotes). For   example, if you pull from a remote that has a <code>main</code> branch, you'll get a   bookmark by that name in your local repo. If you then move it and push back to   the remote, the <code>main</code> branch on the remote will be updated.   Details.</li> <li>The operation log replaces reflogs. The operation log is similar to   reflogs, but is much more powerful. It keeps track of atomic updates to all   refs at once (Jujutsu thus improves on Git's per-ref history much in the same   way that Subversion improved on RCS's per-file history). The operation log   powers e.g. the undo functionality. Details</li> <li>There's a single, virtual root commit. Like Mercurial, Jujutsu has a   virtual commit (with a hash consisting of only zeros) called the \"root commit\"   (called the \"null revision\" in Mercurial). This commit is a common ancestor of   all commits. That removes the awkward state Git calls the \"unborn branch\"   state (which is the state a newly initialized Git repo is in), and related   command-line flags (e.g. <code>git rebase --root</code>, <code>git checkout --orphan</code>).</li> </ul>"},{"location":"git-comparison.html#the-index","title":"The index","text":"<p>Git's \"index\" has multiple roles. One role is as a cache of file system information. Jujutsu has something similar. Unfortunately, Git exposes the index to the user, which makes the CLI unnecessarily complicated (learning what the different flavors of <code>git reset</code> do, especially when combined with commits and/or paths, usually takes a while). Jujutsu, like Mercurial, doesn't make that mistake.</p> <p>As a Git power-user, you may think that you need the power of the index to commit only part of the working copy. However, Jujutsu provides commands for more directly achieving most use cases you're used to using Git's index for. For example, to create a commit from part of the changes in the working copy, you might be used to using <code>git add -p; git commit</code>. With Jujutsu, you'd instead use <code>jj split</code> to split the working-copy commit into two commits. To add more changes into the parent commit, which you might normally use <code>git add -p; git commit --amend</code> for, you can instead use <code>jj squash -i</code> to choose which changes to move into the parent commit, or <code>jj squash &lt;file&gt;</code> to move a specific file.</p>"},{"location":"git-comparison.html#command-equivalence-table","title":"Command equivalence table","text":"<p>Note that all <code>jj</code> commands can be run on any commit (not just the working-copy commit), but that's left out of the table to keep it simple. For example, <code>jj squash -r &lt;revision&gt;</code> will move the diff from that revision into its parent.</p> Use case Jujutsu command Git command Create a new repo <code>jj git init [--colocate]</code> <code>git init</code> Clone an existing repo <code>jj git clone &lt;source&gt; &lt;destination&gt; [--remote &lt;remote name&gt;]</code> (there is no support           for cloning non-Git repos yet) <code>git clone &lt;source&gt; &lt;destination&gt; [--origin &lt;remote name&gt;]</code> Update the local repo with all bookmarks/branches from a remote <code>jj git fetch [--remote &lt;remote&gt;]</code> (there is no           support for fetching into non-Git repos yet) <code>git fetch [&lt;remote&gt;]</code> Update a remote repo with all bookmarks/branches from the local repo <code>jj git push --all [--remote &lt;remote&gt;]</code> (there is no           support for pushing from non-Git repos yet) <code>git push --all [&lt;remote&gt;]</code> Update a remote repo with a single bookmark from the local repo <code>jj git push --bookmark &lt;bookmark name&gt;                 [--remote &lt;remote&gt;]</code> (there is no support for                 pushing from non-Git repos yet) <code>git push &lt;remote&gt; &lt;bookmark name&gt;</code> Add a remote target to the repo <code>jj git remote add &lt;remote&gt; &lt;url&gt;</code> <code>git remote add &lt;remote&gt; &lt;url&gt;</code> Show summary of current work and repo status <code>jj st</code> <code>git status</code> Show diff of the current change <code>jj diff</code> <code>git diff HEAD</code> Show diff of another change <code>jj diff -r &lt;revision&gt;</code> <code>git diff &lt;revision&gt;^ &lt;revision&gt;</code> Show diff from another change to the current change <code>jj diff --from &lt;revision&gt;</code> <code>git diff &lt;revision&gt;</code> Show diff from change A to change B <code>jj diff --from A --to B</code> <code>git diff A B</code> Show description and diff of a change <code>jj show &lt;revision&gt;</code> <code>git show &lt;revision&gt;</code> Add a file to the current change <code>touch filename</code> <code>touch filename; git add filename</code> Remove a file from the current change <code>rm filename</code> <code>git rm filename</code> Modify a file in the current change <code>echo stuff &gt;&gt; filename</code> <code>echo stuff &gt;&gt; filename</code> Finish work on the current change and start a new change <code>jj commit</code> <code>git commit -a</code> See log of ancestors of the current commit <code>jj log -r ::@</code> <code>git log --oneline --graph --decorate</code> See log of all reachable commits <code>jj log -r 'all()'</code> or <code>jj log -r ::</code> <code>git log --oneline --graph --decorate --branches</code> Show log of commits not on the main bookmark <code>jj log</code> (TODO) List versioned files in the working copy <code>jj file list</code> <code>git ls-files --cached</code> Search among files versioned in the repository <code>grep foo $(jj file list)</code>, or <code>rg --no-require-git foo</code> <code>git grep foo</code> Abandon the current change and start a new change <code>jj abandon</code> <code>git reset --hard</code> (cannot be undone) Make the current change empty <code>jj restore</code> <code>git reset --hard</code> (same as abandoning a change since Git           has no concept of a \"change\") Abandon the parent of the working copy, but keep its diff in the working copy <code>jj squash --from @-</code> <code>git reset --soft HEAD~</code> Discard working copy changes in some files <code>jj restore &lt;paths&gt;...</code> <code>git restore &lt;paths&gt;...</code> or <code>git checkout HEAD -- &lt;paths&gt;...</code> Edit description (commit message) of the current change <code>jj describe</code> Not supported Edit description (commit message) of the previous change <code>jj describe @-</code> <code>git commit --amend --only</code> Temporarily put away the current change <code>jj new @-</code> (the old working-copy commit remains as a sibling commit)           (the old working-copy commit X can be restored with <code>jj edit X</code>) <code>git stash</code> Start working on a new change based on the &lt;main&gt; bookmark/branch <code>jj new main</code> <code>git switch -c topic main</code> or         <code>git checkout -b topic main</code> (may need to stash or commit         first) Move bookmark/branch A onto bookmark/branch B <code>jj rebase -b A -d B</code> <code>git rebase B A</code>           (may need to rebase other descendant branches separately) Move change A and its descendants onto change B <code>jj rebase -s A -d B</code> <code>git rebase --onto B A^ &lt;some descendant bookmark&gt;</code>           (may need to rebase other descendant bookmarks separately) Reorder changes from A-B-C-D to A-C-B-D <code>jj rebase -r C --before B</code> <code>git rebase -i A</code> Move the diff in the current change into the parent change <code>jj squash</code> <code>git commit --amend -a</code> Interactively move part of the diff in the current change into the           parent change <code>jj squash -i</code> <code>git add -p; git commit --amend</code> Move the diff in the working copy into an ancestor <code>jj squash --into X</code> <code>git commit --fixup=X; git rebase -i --autosquash X^</code> Interactively move part of the diff in an arbitrary change to another           arbitrary change <code>jj squash -i --from X --into Y</code> Not supported Interactively split the changes in the working copy in two <code>jj split</code> <code>git commit -p</code> Interactively split an arbitrary change in two <code>jj split -r &lt;revision&gt;</code> Not supported (can be emulated with the \"edit\" action in           <code>git rebase -i</code>) Interactively edit the diff in a given change <code>jj diffedit -r &lt;revision&gt;</code> Not supported (can be emulated with the \"edit\" action in           <code>git rebase -i</code>) Resolve conflicts and continue interrupted operation <code>echo resolved &gt; filename; jj squash</code> (operations           don't get interrupted, so no need to continue) <code>echo resolved &gt; filename; git add filename; git           rebase/merge/cherry-pick --continue</code> Create a copy of a commit on top of another commit <code>jj duplicate &lt;source&gt; -d &lt;destination&gt;</code> <code>git co &lt;destination&gt;; git cherry-pick &lt;source&gt;</code> Find the root of the working copy (or check if in a repo) <code>jj workspace root</code> <code>git rev-parse --show-toplevel</code> List bookmarks/branches <code>jj bookmark list</code> or <code>jj b l</code> for short <code>git branch</code> Create a bookmark/branch <code>jj bookmark create &lt;name&gt; -r &lt;revision&gt;</code> <code>git branch &lt;name&gt; &lt;revision&gt;</code> Move a bookmark/branch forward <code>jj bookmark move &lt;name&gt; --to &lt;revision&gt;</code>         or <code>jj b m &lt;name&gt; --to &lt;revision&gt;</code> for short <code>git branch -f &lt;name&gt; &lt;revision&gt;</code> Move a bookmark/branch backward or sideways <code>jj bookmark move &lt;name&gt; --to &lt;revision&gt; --allow-backwards</code> <code>git branch -f &lt;name&gt; &lt;revision&gt;</code> Delete a bookmark/branch <code>jj bookmark delete &lt;name&gt; </code> <code>git branch --delete &lt;name&gt;</code> See log of operations performed on the repo <code>jj op log</code> Not supported Undo an earlier operation <code>jj [op] undo &lt;operation ID&gt;</code>           (<code>jj undo</code> is an alias for <code>jj op undo</code>)        Not supported Create a commit that cancels out a previous commit <code>jj backout -r &lt;revision&gt;</code> <code>git revert &lt;revision&gt;</code> Show what revision and author last modified each line of a file <code>jj file annotate &lt;path&gt;</code> <code>git blame &lt;file&gt;</code>"},{"location":"git-compatibility.html","title":"Git compatibility","text":"<p>Jujutsu has two backends for storing commits. One of them uses a regular Git repo, which means that you can collaborate with Git users without them even knowing that you're not using the <code>git</code> CLI.</p> <p>See <code>jj help git</code> for help about the <code>jj git</code> family of commands, and e.g. <code>jj help git push</code> for help about a specific command (use <code>jj git push -h</code> for briefer help).</p>"},{"location":"git-compatibility.html#supported-features","title":"Supported features","text":"<p>The following list describes which Git features Jujutsu is compatible with. For a comparison with Git, including how workflows are different, see the Git-comparison doc.</p> <ul> <li>Configuration: Partial. The only configuration from Git (e.g. in   <code>~/.gitconfig</code>) that's respected is the following. Feel free to file a bug if   you miss any particular configuration options.<ul> <li>The configuration of remotes (<code>[remote \"&lt;name&gt;\"]</code>). Only the names and URLs   are respected (refspecs are not respected, and   only the last pushurl is   respected).</li> <li><code>core.excludesFile</code></li> </ul> </li> <li>Authentication: Partial. Only <code>ssh-agent</code>, a password-less key (   only <code>~/.ssh/id_rsa</code>, <code>~/.ssh/id_ed25519</code> or <code>~/.ssh/id_ed25519_sk</code>), or   a <code>credential.helper</code>.</li> <li>Branches: Yes. You can read more about   how branches work in Jujutsu   and how they interoperate with Git.</li> <li>Tags: Partial. You can check out tagged commits by name (pointed to be   either annotated or lightweight tags), but you cannot create new tags.</li> <li>.gitignore: Yes. Patterns in <code>.gitignore</code> files are supported. So are   ignores in <code>.git/info/exclude</code> or configured via Git's <code>core.excludesfile</code>   config. Since working-copy files are snapshotted by every <code>jj</code> command, you   might need to run <code>jj file untrack</code> to exclude newly ignored files from the   working-copy commit. It's recommended to set up the ignore patterns earlier.   The <code>.gitignore</code> support uses a native implementation, so please report a bug   if you notice any difference compared to <code>git</code>.</li> <li>.gitattributes: No. There's #53   about adding support for at least the <code>eol</code> attribute.</li> <li>Hooks: No. There's #405   specifically for providing the checks from https://pre-commit.com.</li> <li>Merge commits: Yes. Octopus merges (i.e. with more than 2 parents) are   also supported.</li> <li>Detached HEAD: Yes. Jujutsu supports anonymous branches, so this is a   natural state.</li> <li>Orphan branch: Yes. Jujutsu has a virtual root commit that appears as   parent of all commits Git would call \"root commits\".</li> <li>Staging area: Kind of. The staging area will be ignored. For example,   <code>jj diff</code> will show a diff from the Git HEAD to the working copy. There are   ways of fulfilling your use cases without a staging   area.</li> <li>Garbage collection: Yes. It should be safe to run <code>git gc</code> in the Git   repo, but it's not tested, so it's probably a good idea to make a backup of   the whole workspace first. There's no garbage collection and repacking of   Jujutsu's own data structures yet,   however.</li> <li>Bare repositories: Yes. You can use <code>jj git init --git-repo=&lt;path&gt;</code> to   create a repo backed by a bare Git repo.</li> <li>Submodules: No. They will not show up in the working copy, but they will   not be lost either.</li> <li>Partial clones: No. We use the libgit2 library,   which doesn't have support for partial clones.</li> <li>Shallow clones: Kind of. Shallow commits all have the virtual root commit as   their parent. However, deepening or fully unshallowing a repository is currently not yet   supported and will cause issues.</li> <li>git-worktree: No. However, there's native support for multiple working   copies backed by a single repo. See the <code>jj workspace</code> family of commands.</li> <li>Sparse checkouts: No. However, there's native support for sparse   checkouts. See the <code>jj sparse</code> command.</li> <li>Signed commits: Partial.   So far only by configuration,   later perhaps a command.</li> <li>Git LFS: No. (#80)</li> </ul>"},{"location":"git-compatibility.html#creating-an-empty-repo","title":"Creating an empty repo","text":"<p>To create an empty repo using the Git backend, use <code>jj init --git &lt;name&gt;</code>. Since the command creates a Jujutsu repo, it will have a <code>.jj/</code> directory. The underlying Git repo will be inside of that directory (currently in <code>.jj/repo/store/git/</code>).</p>"},{"location":"git-compatibility.html#creating-a-repo-backed-by-an-existing-git-repo","title":"Creating a repo backed by an existing Git repo","text":"<p>To create a Jujutsu repo backed by a Git repo you already have on disk, use <code>jj git init --git-repo=&lt;path to Git repo&gt; &lt;name&gt;</code>. The repo will work similar to a Git worktree, meaning that the working copies files and the record of the working-copy commit will be separate, but the commits will be accessible in both repos. Use <code>jj git import</code> to update the Jujutsu repo with changes made in the Git repo. Use <code>jj git export</code> to update the Git repo with changes made in the Jujutsu repo.</p>"},{"location":"git-compatibility.html#creating-a-repo-by-cloning-a-git-repo","title":"Creating a repo by cloning a Git repo","text":"<p>To create a Jujutsu repo from a remote Git URL, use <code>jj git clone &lt;URL&gt; [&lt;destination&gt;]</code>. For example, <code>jj git clone https://github.com/octocat/Hello-World</code> will clone GitHub's \"Hello-World\" repo into a directory by the same name.</p> <p>By default, the remote repository will be named <code>origin</code>. You can use a name of your choice by adding <code>--remote &lt;remote name&gt;</code> to the <code>jj git clone</code> command.</p>"},{"location":"git-compatibility.html#co-located-jujutsugit-repos","title":"Co-located Jujutsu/Git repos","text":"<p>A \"co-located\" Jujutsu repo is a hybrid Jujutsu/Git repo. These can be created if you initialize the Jujutsu repo in an existing Git repo by running <code>jj git init --colocate</code> or with <code>jj git clone --colocate</code>. The Git repo and the Jujutsu repo then share the same working copy. Jujutsu will import and export from and to the Git repo on every <code>jj</code> command automatically.</p> <p>This mode is very convenient when tools (e.g. build tools) expect a Git repo to be present.</p> <p>It is allowed to mix <code>jj</code> and <code>git</code> commands in such a repo in any order. However, it may be easier to keep track of what is going on if you mostly use read-only <code>git</code> commands and use <code>jj</code> to make changes to the repo. One reason for this (see below for more) is that <code>jj</code> commands will usually put the git repo in a \"detached HEAD\" state, since in <code>jj</code> there is not concept of a \"currently tracked branch\". Before doing mutating Git commands, you may need to tell Git what the current branch should be with a <code>git switch</code> command.</p> <p>You can undo the results of mutating <code>git</code> commands using <code>jj undo</code> and <code>jj op restore</code>. Inside <code>jj op log</code>, changes by <code>git</code> will be represented as an \"import git refs\" operation.</p> <p>There are a few downsides to this mode of operation. Generally, using co-located repos may require you to deal with more involved Jujutsu and Git concepts.</p> <ul> <li> <p>Interleaving <code>jj</code> and <code>git</code> commands increases the chance of confusing branch   conflicts or conflicted (AKA divergent) change   ids. These never lose data, but can be   annoying.</p> <p>Such interleaving can happen unknowingly. For example, some IDEs can cause it because they automatically run <code>git fetch</code> in the background from time to time.</p> </li> <li> <p>In co-located repos with a very large number of branches or other refs, <code>jj</code>   commands can get noticeably slower because of the automatic <code>jj git import</code>   executed on each command. This can be mitigated by occasionally running <code>jj util   gc</code> to speed up the import (that command includes packing the Git refs).</p> </li> <li> <p>Git tools will have trouble with revisions that contain conflicted files. While   <code>jj</code> renders these files with conflict markers in the working copy, they are   stored in a non-human-readable fashion inside the repo. Git tools will often   see this non-human-readable representation.</p> </li> <li> <p>When a <code>jj</code> branch is conflicted, the position of the branch in the Git repo   will disagree with one or more of the conflicted positions. The state of that   branch in git will be labeled as though it belongs to a remote named \"git\",   e.g. <code>branch@git</code>.</p> </li> <li> <p>Jujutsu will ignore Git's staging area. It will not understand merge conflicts   as Git represents them, unfinished <code>git rebase</code> states, as well as other less   common states a Git repository can be in.</p> </li> <li> <p>Colocated repositories are less resilient to   concurrency   issues if you share the repo using an NFS filesystem or Dropbox. In general,   such use of Jujutsu is not currently thoroughly tested.</p> </li> <li> <p>There may still be bugs when interleaving mutating <code>jj</code> and <code>git</code> commands,   usually having to do with a branch pointer ending up in the wrong place. We   are working on the known ones, and are not aware of any major ones. Please   report any new ones you find, or if any of the known bugs are less minor than   they appear.</p> </li> </ul>"},{"location":"git-compatibility.html#converting-a-repo-into-a-co-located-repo","title":"Converting a repo into a co-located repo","text":"<p>A Jujutsu repo backed by a Git repo has a full Git repo inside, so it is technically possible (though not officially supported) to convert it into a co-located repo like so:</p> <pre><code># Ignore the .jj directory in Git\necho '/*' &gt; .jj/.gitignore\n# Move the Git repo\nmv .jj/repo/store/git .git\n# Tell jj where to find it\necho -n '../../../.git' &gt; .jj/repo/store/git_target\n# Make the Git repository non-bare and set HEAD\ngit config --unset core.bare\n# Convince jj to update .git/HEAD to point to the working-copy commit's parent\njj new &amp;&amp; jj undo\n</code></pre> <p>We may officially support this in the future. If you try this, we would appreciate feedback and bug reports.</p>"},{"location":"git-compatibility.html#branches","title":"Branches","text":"<p>TODO: Describe how branches are mapped</p>"},{"location":"git-compatibility.html#format-mapping-details","title":"Format mapping details","text":"<p>Paths are assumed to be UTF-8. I have no current plans to support paths with other encodings.</p> <p>Commits created by <code>jj</code> have a ref starting with <code>refs/jj/</code> to prevent GC.</p> <p>Commit metadata that cannot be represented in Git commits (such as the Change ID and information about conflicts) is stored outside of the Git repo (currently in <code>.jj/store/extra/</code>).</p> <p>Commits with conflicts cannot be represented in Git. They appear in the Git commit as as root directories called<code>.jjconflict-base-*/</code> and <code>.jjconflict-side-*/</code>. Note that the purpose of this representation is only to prevent GC of the relevant trees; the authoritative information is in the Git-external storage mentioned in the paragraph above. As long as you use <code>jj</code> commands to work with them, you won't notice those paths. If, on the other hand, you use e.g. <code>git switch</code> to check one of them out, you will see those directories in your working copy. If you then run e.g. <code>jj status</code>, the resulting snapshot will contain those directories, making it look like they replaced all the other paths in your repo. You will probably want to run <code>jj abandon</code> to get back to the state with the unresolved conflicts.</p>"},{"location":"github.html","title":"Using Jujutsu with GitHub and GitLab Projects","text":"<p>This guide assumes a basic understanding of either Git or Mercurial.</p>"},{"location":"github.html#set-up-an-ssh-key","title":"Set up an SSH key","text":"<p>As of October 2023 it's recommended to set up an SSH key to work with GitHub projects. See GitHub's Tutorial. This restriction may be lifted in the future, see issue #469 for more information and progress on authenticated HTTP.</p>"},{"location":"github.html#basic-workflow","title":"Basic workflow","text":"<p>The simplest way to start with Jujutsu is to create a stack of commits first. You will only need to create a bookmark when you need to push the stack to a remote. There are two primary workflows: using a generated bookmark name or naming a bookmark.</p>"},{"location":"github.html#using-a-generated-bookmark-name","title":"Using a generated bookmark name","text":"<p>In this example we're letting Jujutsu auto-create a bookmark.</p> <pre><code># Start a new commit off of the default bookmark.\n$ jj new main\n# Refactor some files, then add a description and start a new commit\n$ jj commit -m 'refactor(foo): restructure foo()'\n# Add a feature, then add a description and start a new commit\n$ jj commit -m 'feat(bar): add support for bar'\n# Let Jujutsu generate a bookmark name and push that to GitHub. Note that we\n# push the working-copy commit's *parent* because the working-copy commit\n# itself is empty.\n$ jj git push -c @-\n</code></pre>"},{"location":"github.html#using-a-named-bookmark","title":"Using a named bookmark","text":"<p>In this example, we create a bookmark named <code>bar</code> and then push it to the remote.</p> <pre><code># Start a new commit off of the default bookmark.\n$ jj new main\n# Refactor some files, then add a description and start a new commit\n$ jj commit -m 'refactor(foo): restructure foo()'\n# Add a feature, then add a description and start a new commit\n$ jj commit -m 'feat(bar): add support for bar'\n# Create a bookmark so we can push it to GitHub. Note that we created the bookmark\n# on the working-copy commit's *parent* because the working copy itself is empty.\n$ jj bookmark create bar -r @- # `bar` now contains the previous two commits.\n# Push the bookmark to GitHub (pushes only `bar`)\n$ jj git push --allow-new\n</code></pre> <p>While it's possible to create a bookmark in advance and commit on top of it in a Git-like manner, you will then need to move the bookmark manually when you create a new commits. Unlike Git, Jujutsu will not do it automatically.</p>"},{"location":"github.html#updating-the-repository","title":"Updating the repository","text":"<p>As of October 2023, Jujutsu has no equivalent to a <code>git pull</code> command (see issue #1039). Until such a command is added, you need to use <code>jj git fetch</code> followed by a <code>jj rebase -d $main_bookmark</code> to update your changes.</p>"},{"location":"github.html#working-in-a-git-co-located-repository","title":"Working in a Git co-located repository","text":"<p>After doing <code>jj git init --colocate</code>, Git will be in a detached HEAD state, which is unusual, as Git mainly works with named branches; jj does not.</p> <p>In a co-located repository, every <code>jj</code> command will automatically synchronize Jujutsu's view of the repo with Git's view. For example, <code>jj commit</code> updates the HEAD of the Git repository, enabling an incremental migration.</p> <pre><code>$ nvim docs/tutorial.md\n$ # Do some more work.\n$ jj commit -m \"Update tutorial\"\n# Create a bookmark on the working-copy commit's parent\n$ jj bookmark create doc-update -r @-\n$ jj git push --allow-new\n</code></pre>"},{"location":"github.html#working-in-a-jujutsu-repository","title":"Working in a Jujutsu repository","text":"<p>In a Jujutsu repository, the workflow is simplified. If there's no need for explicitly named bookmarks, you can just generate one for a change. As Jujutsu is able to create a bookmark for a revision.</p> <pre><code>$ # Do your work\n$ jj commit\n$ # Push change \"mw\", letting Jujutsu automatically create a bookmark called\n$ # \"push-mwmpwkwknuz\"\n$ jj git push --change mw\n</code></pre>"},{"location":"github.html#addressing-review-comments","title":"Addressing review comments","text":"<p>There are two workflows for addressing review comments, depending on your project's preference. Many projects prefer that you address comments by adding commits to your bookmark<sup>1</sup>. Some projects (such as Jujutsu and LLVM) instead prefer that you keep your commits clean by rewriting them and then force-pushing<sup>2</sup>.</p>"},{"location":"github.html#adding-new-commits","title":"Adding new commits","text":"<p>If your project prefers that you address review comments by adding commits on top, you can do that by doing something like this:</p> <pre><code>$ # Create a new commit on top of the `your-feature` bookmark from above.\n$ jj new your-feature\n$ # Address the comments by updating the code. Then review the changes.\n$ jj diff\n$ # Give the fix a description and create a new working-copy on top.\n$ jj commit -m 'address pr comments'\n$ # Update the bookmark to point to the new commit.\n$ jj bookmark move your-feature --to @-\n$ # Push it to your remote\n$ jj git push\n</code></pre> <p>Notably, the above workflow creates a new commit for you. The same can be achieved without creating a new commit.</p> <p>Warning</p> <p>We strongly suggest to <code>jj new</code> after the example below, as all further edits still get amended to the previous commit.</p> <pre><code>$ # Create a new commit on top of the `your-feature` bookmark from above.\n$ jj new your-feature\n$ # Address the comments by updating the code. Then review the changes.\n$ jj diff\n$ # Give the fix a description.\n$ jj describe -m 'address pr comments'\n$ # Update the bookmark to point to the current commit.\n$ jj bookmark move your-feature --to @\n$ # Push it to your remote\n$ jj git push\n</code></pre>"},{"location":"github.html#rewriting-commits","title":"Rewriting commits","text":"<p>If your project prefers that you keep commits clean, you can do that by doing something like this:</p> <pre><code>$ # Create a new commit on top of the second-to-last commit in `your-feature`,\n$ # as reviewers requested a fix there.\n$ jj new your-feature- # NOTE: the trailing hyphen is not a typo!\n$ # Address the comments by updating the code. Then review the changes.\n$ jj diff\n$ # Squash the changes into the parent commit\n$ jj squash\n$ # Push the updated bookmark to the remote. Jujutsu automatically makes it a\n$ # force push\n$ jj git push --bookmark your-feature\n</code></pre> <p>The hyphen after <code>your-feature</code> comes from the revset syntax.</p>"},{"location":"github.html#working-with-other-peoples-bookmarks","title":"Working with other people's bookmarks","text":"<p>By default, <code>jj git clone</code> imports the default remote bookmark (which is usually <code>main</code> or <code>master</code>), but <code>jj git fetch</code> doesn't import new remote bookmarks to local bookmarks. This means that if you want to iterate or test another contributor's bookmark, you'll need to do <code>jj new &lt;bookmark&gt;@&lt;remote&gt;</code> onto it.</p> <p>If you want to import all remote bookmarks including inactive ones, set <code>git.auto-local-bookmark = true</code> in the config file. Then you can specify a contributor's bookmark as <code>jj new &lt;bookmark&gt;</code> instead of <code>jj new &lt;bookmark&gt;@&lt;remote&gt;</code>.</p> <p>You can find more information on that setting here.</p>"},{"location":"github.html#using-github-cli","title":"Using GitHub CLI","text":"<p>GitHub CLI will have trouble finding the proper Git repository path in jj repos that aren't co-located (see issue #1008). You can configure the <code>$GIT_DIR</code> environment variable to point it to the right path:</p> <pre><code>$ GIT_DIR=.jj/repo/store/git gh issue list\n</code></pre> <p>You can make that automatic by installing direnv and defining hooks in a <code>.envrc</code> file in the repository root to configure <code>$GIT_DIR</code>. Just add this line into <code>.envrc</code>:</p> <pre><code>export GIT_DIR=$PWD/.jj/repo/store/git\n</code></pre> <p>and run <code>direnv allow</code> to approve it for direnv to run. Then GitHub CLI will work automatically even in repos that aren't co-located so you can execute commands like <code>gh issue list</code> normally.</p>"},{"location":"github.html#useful-revsets","title":"Useful Revsets","text":"<p>Log all revisions across all local bookmarks that aren't on the main bookmark nor on any remote:</p> <pre><code>$ jj log -r 'bookmarks() &amp; ~(main | remote_bookmarks())'\n</code></pre> <p>Log all revisions that you authored, across all bookmarks that aren't on any remote:</p> <pre><code>$ jj log -r 'mine() &amp; bookmarks() &amp; ~remote_bookmarks()'\n</code></pre> <p>Log all remote bookmarks that you authored or committed to:</p> <pre><code>$ jj log -r 'remote_bookmarks() &amp; (mine() | committer(your@email.com))'\n</code></pre> <p>Log all ancestors of the current working copy that aren't on any remote:</p> <pre><code>$ jj log -r 'remote_bookmarks()..@'\n</code></pre>"},{"location":"github.html#merge-conflicts","title":"Merge conflicts","text":"<p>For a detailed overview, how Jujutsu handles conflicts, revisit the tutorial.</p>"},{"location":"github.html#using-several-remotes","title":"Using several remotes","text":"<p>It is common to use several remotes when contributing to a shared repository. For example, \"upstream\" can designate the remote where the changes will be merged through a pull-request while \"origin\" is your private fork of the project.</p> <pre><code>$ jj git clone --remote upstream https://github.com/upstream-org/repo\n$ cd repo\n$ jj git remote add origin git@github.com:your-org/your-repo-fork\n</code></pre> <p>This will automatically setup your repository to track the main bookmark from the upstream repository, typically <code>main@upstream</code> or <code>master@upstream</code>.</p> <p>You might want to <code>jj git fetch</code> from \"upstream\" and to <code>jj git push</code> to \"origin\". You can configure the default remotes to fetch from and push to in your configuration file (for example, <code>.jj/repo/config.toml</code>):</p> <pre><code>[git]\nfetch = \"upstream\"\npush = \"origin\"\n</code></pre> <p>The default for both <code>git.fetch</code> and <code>git.push</code> is \"origin\".</p> <p>If you usually work on a project from several computers, you may configure <code>jj</code> to fetch from both repositories by default, in order to keep your own bookmarks synchronized through your <code>origin</code> repository:</p> <pre><code>[git]\nfetch = [\"upstream\", \"origin\"]\npush = \"origin\"\n</code></pre> <ol> <li> <p>This is a GitHub-style review, as GitHub currently only is able to compare bookmarks.\u00a0\u21a9</p> </li> <li> <p>If you're wondering why we prefer clean commits in this project, see e.g. this blog post \u21a9</p> </li> </ol>"},{"location":"glossary.html","title":"Glossary","text":""},{"location":"glossary.html#anonymous-branch","title":"Anonymous branch","text":"<p>An anonymous branch is a chain of commits that doesn't necessarily have any bookmarks pointing to it or to any of its descendants. Unlike Git, Jujutsu keeps commits on anonymous branches around until they are explicitly abandoned. Visible anonymous branches are tracked by the view, which stores a list of heads of such branches.</p>"},{"location":"glossary.html#backend","title":"Backend","text":"<p>A backend is an implementation of the storage layer. There are currently two builtin commit backends: the Git backend and the native backend. The Git backend stores commits in a Git repository. The native backend is used for testing purposes only. Alternative backends could be used, for example, if somebody wanted to use jj with a humongous monorepo (as Google does).</p> <p>There are also pluggable backends for storing other information than commits, such as the \"operation store backend\" for storing the operation log.</p>"},{"location":"glossary.html#bookmark","title":"Bookmark","text":"<p>A bookmark is a named pointer to a commit. They are similar to Git's branches and even more similar to Mercurial's bookmarks. See here for details.</p> <p>Unlike in Git, there is no concept of a \"current bookmark\"; bookmarks do not move when you create a new commit. Bookmarks do automatically follow the commit if it gets rewritten.</p>"},{"location":"glossary.html#branch","title":"Branch","text":"<p>In the context of <code>jj</code>, the work \"branch\" usually refers to an anonymous branch or, less formally, a branch of the commit \"tree\" (which is itself an informal way to refer to the commit graph, parts of which might resemble a tree even when it's not mathematically a tree).</p> <p>We also sometimes discuss Git's branches and branches on Git remotes. Locally, these correspond to bookmarks. In a co-located repository, each local Git branch corresponds to a <code>jj</code> bookmark.</p>"},{"location":"glossary.html#change","title":"Change","text":"<p>A change is a commit as it evolves over time. Changes themselves don't exist as an object in the data model; only the change ID does. The change ID is a property of a commit.</p>"},{"location":"glossary.html#change-id","title":"Change ID","text":"<p>A change ID is a unique identifier for a change. They are typically 16 bytes long and are often randomly generated. By default, <code>jj log</code> presents them as a sequence of 12 letters in the k-z range, at the beginning of a line. These are actually hexadecimal numbers that use \"digits\" z-k instead of 0-9a-f.</p> <p>For the Git backend, Change IDs are currently maintained only locally and not exchanged via push/fetch operations.</p>"},{"location":"glossary.html#commit","title":"Commit","text":"<p>A snapshot of the files in the repository at a given point in time (technically a tree object), together with some metadata. The metadata includes the author, the date, and pointers to the commit's parents. Through the pointers to the parents, the commits form a Directed Acyclic Graph (DAG) .</p> <p>Note that even though commits are stored as snapshots, they are often treated as differences between snapshots, namely compared to their parent's snapshot. If they have more than one parent, then the difference is computed against the result of merging the parents. For example, <code>jj diff</code> will show the differences introduced by a commit compared to its parent(s), and <code>jj rebase</code> will apply those changes onto another base commit.</p> <p>The word \"revision\" is used as a synonym for \"commit\".</p>"},{"location":"glossary.html#commit-id","title":"Commit ID","text":"<p>A commit ID is a unique identifier for a commit. They are 20 bytes long when using the Git backend. They are presented in regular hexadecimal format at the end of the line in <code>jj log</code>, using 12 hexadecimal digits by default. When using the Git backend, the commit ID is the Git commit ID.</p>"},{"location":"glossary.html#co-located-repos","title":"Co-located repos","text":"<p>When using the Git backend and the backing Git repository's <code>.git/</code> directory is a sibling of <code>.jj/</code>, we call the repository \"co-located\". Most tools designed for Git can be easily used on such repositories. <code>jj</code> and <code>git</code> commands can be used interchangeably.</p> <p>See here for details.</p>"},{"location":"glossary.html#conflict","title":"Conflict","text":"<p>Conflicts can occur in many places. The most common type is conflicts in files. Those are the conflicts that users coming from other VCSs are usually familiar with. You can see them in <code>jj status</code> and in <code>jj log</code> (the red \"conflict\" label at the end of the line). See here for details.</p> <p>Conflicts can also occur in bookmarks. For example, if you moved a bookmark locally, and it was also moved on the remote, then the bookmark will be in a conflicted state after you pull from the remote. See here for details.</p> <p>Similar to a bookmark conflict, when a change is rewritten locally and remotely, for example, then the change will be in a conflicted state. We call that a divergent change.</p>"},{"location":"glossary.html#divergent-change","title":"Divergent change","text":"<p>A divergent change is a change that has more than one visible commit.</p>"},{"location":"glossary.html#head","title":"Head","text":"<p>A head is a commit with no descendants. The context in which it has no descendants varies. For example, the <code>heads(X)</code> revset function returns commits that have no descendants within the set <code>X</code> itself. The view records which anonymous heads (heads without a bookmark pointing to them) are visible at a given operation. Note that this is quite different from Git's HEAD.</p>"},{"location":"glossary.html#hidden-commits-abandoned-commits","title":"Hidden commits, abandoned commits","text":"<p>See visible commits.</p>"},{"location":"glossary.html#operation","title":"Operation","text":"<p>A snapshot of the visible commits and bookmarks at a given point in time (technically a view object), together with some metadata. The metadata includes the username, hostname, timestamps, and pointers to the operation's parents.</p>"},{"location":"glossary.html#operation-log","title":"Operation log","text":"<p>The operation log is the DAG formed by operation objects, much in the same way that commits form a DAG, which is sometimes called the \"commit history\". When operations happen in sequence, they form a single line in the graph. Operations that happen concurrently from jj's perspective result in forks and merges in the DAG.</p>"},{"location":"glossary.html#repository","title":"Repository","text":"<p>Basically everything under <code>.jj/</code>, i.e. the full set of operations and commits.</p>"},{"location":"glossary.html#remote","title":"Remote","text":"<p>TODO</p>"},{"location":"glossary.html#revision","title":"Revision","text":"<p>A synonym for Commit.</p>"},{"location":"glossary.html#revset","title":"Revset","text":"<p>Jujutsu supports a functional language for selecting a set of revisions. Expressions in this language are called \"revsets\". See here for details. We also often use the term \"revset\" for the set of revisions selected by a revset.</p>"},{"location":"glossary.html#rewrite","title":"Rewrite","text":"<p>To \"rewrite\" a commit means to create a new version of that commit with different contents, metadata (including parent pointers), or both. Rewriting a commit results in a new commit, and thus a new commit ID, but the change ID generally remains the same. Some examples of rewriting a commit would be changing its description or rebasing it. Modifying the working copy rewrites the working copy commit.</p>"},{"location":"glossary.html#root-commit","title":"Root commit","text":"<p>The root commit is a virtual commit at the root of every repository. It has a commit ID consisting of all '0's (<code>00000000...</code>) and a change ID consisting of all 'z's (<code>zzzzzzzz...</code>). It can be referred to in revsets by the function <code>root()</code>. Note that our definition of \"root commit\" is different from Git's; Git's \"root commits\" are the first commit(s) in the repository, i.e. the commits <code>jj log -r 'root()+'</code> will show.</p>"},{"location":"glossary.html#tree","title":"Tree","text":"<p>A tree object represents a snapshot of a directory in the repository. Tree objects are defined recursively; each tree object only has the files and directories contained directly in the directory it represents.</p>"},{"location":"glossary.html#tracked-bookmarks-and-tracking-bookmarks","title":"Tracked bookmarks and tracking bookmarks","text":"<p>A remote bookmark can be made \"tracked\" with the <code>jj bookmark track</code> command. This results in a \"tracking\" local bookmark that tracks the remote bookmark.</p> <p>See the bookmarks documentation for a more detailed definition of these terms.</p>"},{"location":"glossary.html#visible-commits","title":"Visible commits","text":"<p>Visible commits are the commits you see in <code>jj log -r 'all()'</code>. They are the commits that are reachable from an anonymous head in the view. Ancestors of a visible commit are implicitly visible.</p> <p>Intuitively, visible commits are the \"latest versions\" of a revision with a given change id. A commit that's abandoned or rewritten stops being visible and is labeled as \"hidden\". Such commits are no longer accessible using a change id, but they are still accessible by their commit id.</p>"},{"location":"glossary.html#view","title":"View","text":"<p>A view is a snapshot of bookmarks and their targets, anonymous heads, and working-copy commits. The anonymous heads define which commits are visible.</p> <p>A view object is similar to a tree object in that it represents a snapshot without history, and an operation object is similar to a commit object in that it adds metadata and history.</p>"},{"location":"glossary.html#workspace","title":"Workspace","text":"<p>A workspace is a working copy and an associated repository. There can be multiple workspaces for a single repository. Each workspace has a <code>.jj/</code> directory, but the commits and operations will be stored in the initial workspace; the other workspaces will have pointers to the initial workspace. See here for details.</p> <p>This is what Git calls a \"worktree\".</p>"},{"location":"glossary.html#working-copy","title":"Working copy","text":"<p>The working copy contains the files you're currently working on. It is automatically snapshot at the beginning of almost every <code>jj</code> command, thus creating a new working-copy commit if any changes had been made in the working copy. Conversely, the working copy is automatically updated to the state of the working-copy commit at the end of almost every <code>jj</code> command. See here for details.</p> <p>This is what Git calls a \"working tree\".</p>"},{"location":"glossary.html#working-copy-commit","title":"Working-copy commit","text":"<p>A commit that corresponds to the current state of the working copy. There is one working-copy commit per workspace. The current working-copy commits are tracked in the operation log.</p>"},{"location":"install-and-setup.html","title":"Installation and setup","text":""},{"location":"install-and-setup.html#installation","title":"Installation","text":""},{"location":"install-and-setup.html#download-pre-built-binaries-for-a-release","title":"Download pre-built binaries for a release","text":"<p>There are pre-built binaries of the last released version of <code>jj</code> for Windows, Mac, or Linux (the \"musl\" version should work on all distributions).</p>"},{"location":"install-and-setup.html#cargo-binstall","title":"Cargo Binstall","text":"<p>If you use <code>cargo-binstall</code>, you can install binaries of the latest <code>jj</code> release from GitHub as follows:</p> <pre><code># Will put the jj binary for the latest release in ~/.cargo/bin by default\ncargo binstall --strategies crate-meta-data jj-cli\n</code></pre> <p>Without the <code>--strategies</code> option, you may get equivalent binaries that should be compiled from the same source code.</p> <p>Note</p> <p>If you'd like to install a prerelease version, you'll need to use one of the options below.</p>"},{"location":"install-and-setup.html#linux","title":"Linux","text":""},{"location":"install-and-setup.html#from-source","title":"From Source","text":"<p>First make sure that you have a Rust version &gt;= 1.76 and that the <code>libssl-dev</code>, <code>openssl</code>, <code>pkg-config</code>, and <code>build-essential</code> packages are installed by running something like this:</p> <pre><code>sudo apt-get install libssl-dev openssl pkg-config build-essential\n</code></pre> <p>Now run either:</p> <pre><code># To install the *prerelease* version from the main branch\ncargo install --git https://github.com/jj-vcs/jj.git --locked --bin jj jj-cli\n</code></pre> <p>or:</p> <pre><code># To install the latest release\ncargo install --locked --bin jj jj-cli\n</code></pre>"},{"location":"install-and-setup.html#arch-linux","title":"Arch Linux","text":"<p>You can install the <code>jujutsu</code> package from the official extra repository:</p> <pre><code>pacman -S jujutsu\n</code></pre> <p>Or install from the AUR repository with an AUR Helper:</p> <pre><code>yay -S jujutsu-git\n</code></pre>"},{"location":"install-and-setup.html#nix-os","title":"Nix OS","text":"<p>If you're on Nix OS you can install a released version of <code>jj</code> using the nixpkgs <code>jujutsu</code> package.</p> <p>To install a prerelease version, you can use the flake for this repository. For example, if you want to run <code>jj</code> loaded from the flake, use:</p> <pre><code>nix run 'github:jj-vcs/jj'\n</code></pre> <p>You can also add this flake url to your system input flakes. Or you can install the flake to your user profile:</p> <pre><code># Installs the prerelease version from the main branch\nnix profile install 'github:jj-vcs/jj'\n</code></pre>"},{"location":"install-and-setup.html#homebrew","title":"Homebrew","text":"<p>If you use Homebrew, you can run:</p> <pre><code># Installs the latest release\nbrew install jj\n</code></pre>"},{"location":"install-and-setup.html#gentoo-linux","title":"Gentoo Linux","text":"<p><code>dev-vcs/jj</code> is available in the GURU repository. Details on how to enable the GURU repository can be found here.</p> <p>Once you have synced the GURU repository, you can install <code>dev-vcs/jj</code> via Portage:</p> <pre><code>emerge -av dev-vcs/jj\n</code></pre>"},{"location":"install-and-setup.html#mac","title":"Mac","text":""},{"location":"install-and-setup.html#from-source-vendored-openssl","title":"From Source, Vendored OpenSSL","text":"<p>First make sure that you have a Rust version &gt;= 1.76. You may also need to run:</p> <pre><code>xcode-select --install\n</code></pre> <p>Now run either:</p> <pre><code># To install the *prerelease* version from the main branch\ncargo install --git https://github.com/jj-vcs/jj.git \\\n     --features vendored-openssl --locked --bin jj jj-cli\n</code></pre> <p>or:</p> <pre><code># To install the latest release\ncargo install --features vendored-openssl --locked --bin jj jj-cli\n</code></pre>"},{"location":"install-and-setup.html#from-source-homebrew-openssl","title":"From Source, Homebrew OpenSSL","text":"<p>First make sure that you have a Rust version &gt;= 1.76. You will also need Homebrew installed. You may then need to run some or all of these:</p> <pre><code>xcode-select --install\nbrew install openssl\nbrew install pkg-config\nexport PKG_CONFIG_PATH=\"$(brew --prefix)/opt/openssl@3/lib/pkgconfig\"\n</code></pre> <p>Now run either:</p> <pre><code># To install the *prerelease* version from the main branch\ncargo install --git https://github.com/jj-vcs/jj.git --locked --bin jj jj-cli\n</code></pre> <p>or:</p> <pre><code># To install the latest release\ncargo install --locked --bin jj jj-cli\n</code></pre>"},{"location":"install-and-setup.html#homebrew_1","title":"Homebrew","text":"<p>If you use Homebrew, you can run:</p> <pre><code># Installs the latest release\nbrew install jj\n</code></pre>"},{"location":"install-and-setup.html#macports","title":"MacPorts","text":"<p>You can also install <code>jj</code> via the MacPorts <code>jujutsu</code> port:</p> <pre><code># Installs the latest release\nsudo port install jujutsu\n</code></pre>"},{"location":"install-and-setup.html#windows","title":"Windows","text":"<p>First make sure that you have a Rust version &gt;= 1.76. Now run either:</p> <pre><code># To install the *prerelease* version from the main branch\ncargo install --git https://github.com/jj-vcs/jj.git --locked --bin jj jj-cli --features vendored-openssl\n</code></pre> <p>or:</p> <pre><code># To install the latest release\ncargo install --locked --bin jj jj-cli --features vendored-openssl\n</code></pre>"},{"location":"install-and-setup.html#initial-configuration","title":"Initial configuration","text":"<p>You may want to configure your name and email so commits are made in your name.</p> <pre><code>$ jj config set --user user.name \"Martin von Zweigbergk\"\n$ jj config set --user user.email \"martinvonz@google.com\"\n</code></pre>"},{"location":"install-and-setup.html#command-line-completion","title":"Command-line completion","text":"<p>To set up command-line completion, source the output of <code>jj util completion bash/zsh/fish</code>. Exactly how to source it depends on your shell.</p> <p>Improved completions are also available. They will complete things like bookmarks, aliases, revisions, operations and files. They can be context aware, for example they respect the global flags <code>--repository</code> and <code>--at-operation</code> as well as some command-specific ones like <code>--revision</code>, <code>--from</code> and <code>--to</code>. You can activate them with the alternative \"dynamic\" instructions below. They should still complete everything the static completions did, so only activate one of them. Please let us know if you encounter any issues, so we can ensure a smooth transition once we default to these new completions.</p> <p>Why are the improved completions not the default?</p> <p>To generate the dynamic completion script, execute <code>jj</code> with <code>$COMPLETE</code> set to the name of your shell (see examples below). See the upstream clap issue #3166 for the explanation.</p>"},{"location":"install-and-setup.html#bash","title":"Bash","text":""},{"location":"install-and-setup.html#standard","title":"Standard","text":"<pre><code>source &lt;(jj util completion bash)\n</code></pre>"},{"location":"install-and-setup.html#dynamic","title":"Dynamic","text":"<pre><code>source &lt;(COMPLETE=bash jj)\n</code></pre>"},{"location":"install-and-setup.html#zsh","title":"Zsh","text":""},{"location":"install-and-setup.html#standard_1","title":"Standard","text":"<pre><code>autoload -U compinit\ncompinit\nsource &lt;(jj util completion zsh)\n</code></pre>"},{"location":"install-and-setup.html#dynamic_1","title":"Dynamic","text":"<pre><code>source &lt;(COMPLETE=zsh jj)\n</code></pre>"},{"location":"install-and-setup.html#fish","title":"Fish","text":""},{"location":"install-and-setup.html#standard_2","title":"Standard","text":"<pre><code>jj util completion fish | source\n</code></pre>"},{"location":"install-and-setup.html#dynamic_2","title":"Dynamic","text":"<pre><code>COMPLETE=fish jj | source\n</code></pre>"},{"location":"install-and-setup.html#nushell","title":"Nushell","text":"<pre><code>jj util completion nushell | save completions-jj.nu\nuse completions-jj.nu *  # Or `source completions-jj.nu`\n</code></pre> <p>(dynamic completions not available yet)</p>"},{"location":"install-and-setup.html#xonsh","title":"Xonsh","text":"<pre><code>source-bash $(jj util completion)\n</code></pre> <p>(dynamic completions not available yet)</p>"},{"location":"install-and-setup.html#powershell","title":"Powershell","text":"<p>Insert this line in your $PROFILE file: (usually $HOME\\Documents\\PowerShell\\Microsoft.PowerShell_profile.ps1)</p> <pre><code>Invoke-Expression (&amp; { (jj util completion power-shell | Out-String) })\n</code></pre> <p>(dynamic completions not available yet)</p>"},{"location":"operation-log.html","title":"Operation log","text":""},{"location":"operation-log.html#introduction","title":"Introduction","text":"<p>Jujutsu records each operation that modifies the repo in the \"operation log\". You can see the log with <code>jj op log</code>. Each operation object contains a snapshot of how the repo looked at the end of the operation. We call this snapshot a \"view\" object. The view contains information about where each bookmark, tag, and Git ref (in Git-backed repos) pointed, as well as the set of heads in the repo, and the current working-copy commit in each workspace. The operation object also (in addition to the view) contains pointers to the operation(s) immediately before it, as well as metadata about the operation, such as timestamps, username, hostname, description.</p> <p>The operation log allows you to undo an operation (<code>jj [op] undo</code>), which doesn't need to be the most recent one. It also lets you restore the entire repo to the way it looked at an earlier point (<code>jj op restore</code>).</p> <p>When referring to operations, you can use <code>@</code> to represent the current operation.</p> <p>The following operators are supported:</p> <ul> <li><code>x-</code>: Parents of <code>x</code> (e.g. <code>@-</code>)</li> <li><code>x+</code>: Children of <code>x</code></li> </ul>"},{"location":"operation-log.html#divergent-operations","title":"divergent operations","text":"<p>One benefit of the operation log (and the reason for its creation) is that it allows lock-free concurrency -- you can run concurrent <code>jj</code> commands without corrupting the repo, even if you run the commands on different machines that access the repo via a distributed file system (as long as the file system guarantees that a write is only visible once previous writes are visible). When you run a <code>jj</code> command, it will start by loading the repo at the latest operation. It will not see any changes written by concurrent commands. If there are conflicts, you will be informed of them by subsequent <code>jj st</code> and/or <code>jj log</code> commands.</p> <p>As an example, let's say you had started editing the description of a change and then also update the contents of the change (maybe because you had forgotten the editor). When you eventually close your editor, the command will succeed and e.g. <code>jj log</code> will indicate that the change has diverged.</p>"},{"location":"operation-log.html#loading-an-old-version-of-the-repo","title":"Loading an old version of the repo","text":"<p>The top-level <code>--at-operation/--at-op</code> option allows you to load the repo at a specific operation. This can be useful for understanding how your repo got into the current state. It can be even more useful for understanding why someone else's repo got into its current state.</p> <p>When you use <code>--at-op</code>, the automatic snapshotting of the working copy will not take place. When referring to a revision with the <code>@</code> symbol (as many commands do by default), that will resolve to the working-copy commit recorded in the operation's view (which is actually how it always works -- it's just the snapshotting that's skipped with <code>--at-op</code>).</p> <p>As a top-level option, <code>--at-op</code> can be passed to any command. However, you will typically only want to run read-only commands. For example, <code>jj log</code>, <code>jj st</code>, and <code>jj diff</code> all make sense. It's still possible to run e.g. <code>jj --at-op=&lt;some operation ID&gt; describe</code>. That's equivalent to having started <code>jj describe</code> back when the specified operation was the most recent operation and then let it run until now (which can be done for that particular command by not closing the editor). There's practically no good reason to do that other than to simulate concurrent commands.</p>"},{"location":"related-work.html","title":"Related work","text":"<p>Similar tools:</p> <ul> <li>git-branchless: Helps you use a   branchless workflow in your Git repo. Supports anonymous branching, undo,   and faster rebase (<code>git move</code>). Under heavy development and quickly gaining   new features.</li> <li>Sapling: A heavily modified fork of   Mercurial developed and used at Meta. It   is compatible with Git, has undo functionality, and   a graphical interface.   See how it is different from Jujutsu.</li> <li>GitUp: A Mac-only GUI for Git. Like Jujutsu, supports   undo and restoring the repo to an earlier snapshot. Backed by its   GitUpKit library.</li> <li>Gitless: Another attempt at providing a simpler   interface for Git. Like Jujutsu, does not have an \"index\"/\"staging area\"   concept. Also doesn't move the working-copy changes between branches (which   we do simply as a consequence of making the working copy a commit).</li> <li>Breezy: Another VCS that's similar in that it   has multiple storage backends, including its own format as well as .git   support.</li> <li>Sturdy: A Git backed GUI that eliminates local and   remote as well as the idea of an \"index\"/\"staging area\".</li> </ul>"},{"location":"releasing.html","title":"How to do a release","text":""},{"location":"releasing.html#update-changelog-and-cargo-versions","title":"Update changelog and Cargo versions","text":"<p>Send a PR similar to https://github.com/jj-vcs/jj/pull/5215. Feel free to copy-edit the changelog in order to:</p> <ul> <li>Populate \"Release highlights\" if relevant</li> <li>Put more important items first so the reader doesn't miss them</li> <li>Make items consistent when it comes to language and formatting</li> </ul> <p>Producing the list of contributors is a bit annoying. The current suggestion is to run something like this:</p> <pre><code>jj log --no-graph -r 'heads(tags())..main' -T 'author ++ \"\\n\"' | sort | uniq -c\n</code></pre> <p>Then try to find the right GitHub username for each person and copy their name and username from the GitHub page for the person (e.g. https://github.com/martinvonz).</p> <p>Get the PR through review and get it merged as usual.</p>"},{"location":"releasing.html#create-a-tag-and-a-github-release","title":"Create a tag and a GitHub release","text":"<ol> <li>Go to https://github.com/jj-vcs/jj/releases and click \"Draft a new release\"</li> <li>Click \"Choose a tag\" and enter \"v0.\\&lt;number&gt;.0\" (e.g. \"v0.26.0\") to create a    new tag</li> <li>Click \"Target\", then \"Recent commits\", and select the commit from your merged    PR</li> <li>Use the name (e.g. \"v0.26.0\") as \"Release title\". Paste the changelog entries    into the message body</li> <li>Check \"Create a discussion for this release\"</li> <li>Click \"Publish release\"</li> </ol>"},{"location":"releasing.html#publish-the-crates-to-cratesio","title":"Publish the crates to crates.io","text":"<p>Go to a terminal and create a new clone of the repo <sup>1</sup>:</p> <pre><code>cd $(mktemp -d)\njj git clone https://github.com/jj-vcs/jj\ncd jj\njj new v0.&lt;number&gt;.0\n</code></pre> <p>Publish each crate:</p> <pre><code>(cd lib/proc-macros &amp;&amp; cargo publish)\n(cd lib &amp;&amp; cargo publish)\n(cd cli &amp;&amp; cargo publish)\n</code></pre> <ol> <li> <p>We recommend publishing from a new clone because <code>cargo publish</code> will   archive ignored files if they match the patterns in <code>[include]</code>   (example),   so it's a security risk to run it an existing clone where you may have   left sensitive content in an ignored file.\u00a0\u21a9</p> </li> </ol>"},{"location":"revsets.html","title":"Revsets","text":"<p>Jujutsu supports a functional language for selecting a set of revisions. Expressions in this language are called \"revsets\" (the idea comes from Mercurial). The language consists of symbols, operators, and functions.</p> <p>Most <code>jj</code> commands accept a revset (or multiple). Many commands, such as <code>jj diff -r &lt;revset&gt;</code> expect the revset to resolve to a single commit; it is an error to pass a revset that resolves to more than one commit (or zero commits) to such commands.</p> <p>The words \"revisions\" and \"commits\" are used interchangeably in this document.</p> <p>Most revsets search only the visible commits. Other commits are only included if you explicitly mention them (e.g. by commit ID or a Git ref pointing to them).</p>"},{"location":"revsets.html#symbols","title":"Symbols","text":"<p>The <code>@</code> expression refers to the working copy commit in the current workspace. Use <code>&lt;workspace name&gt;@</code> to refer to the working-copy commit in another workspace. Use <code>&lt;name&gt;@&lt;remote&gt;</code> to refer to a remote-tracking bookmark.</p> <p>A full commit ID refers to a single commit. A unique prefix of the full commit ID can also be used. It is an error to use a non-unique prefix.</p> <p>A full change ID refers to all visible commits with that change ID (there is typically only one visible commit with a given change ID). A unique prefix of the full change ID can also be used. It is an error to use a non-unique prefix.</p> <p>Use single or double quotes to prevent a symbol from being interpreted as an expression. For example, <code>\"x-\"</code> is the symbol <code>x-</code>, not the parents of symbol <code>x</code>. Taking shell quoting into account, you may need to use something like <code>jj log -r '\"x-\"'</code>.</p>"},{"location":"revsets.html#priority","title":"Priority","text":"<p>Jujutsu attempts to resolve a symbol in the following order:</p> <ol> <li>Tag name</li> <li>Bookmark name</li> <li>Git ref</li> <li>Commit ID or change ID</li> </ol>"},{"location":"revsets.html#operators","title":"Operators","text":"<p>The following operators are supported. <code>x</code> and <code>y</code> below can be any revset, not only symbols.</p> <ul> <li><code>x-</code>: Parents of <code>x</code>, can be empty.</li> <li><code>x+</code>: Children of <code>x</code>, can be empty.</li> <li><code>x::</code>: Descendants of <code>x</code>, including the commits in <code>x</code> itself. Shorthand for   <code>x::visible_heads()</code>.</li> <li><code>x..</code>: Revisions that are not ancestors of <code>x</code>. Shorthand for   <code>x..visible_heads()</code>.</li> <li><code>::x</code>: Ancestors of <code>x</code>, including the commits in <code>x</code> itself. Shorthand for   <code>root()::x</code>.</li> <li><code>..x</code>: Ancestors of <code>x</code>, including the commits in <code>x</code> itself, but excluding   the root commit. Shorthand for <code>root()..x</code>. Equivalent to <code>::x ~ root()</code>.</li> <li><code>x::y</code>: Descendants of <code>x</code> that are also ancestors of <code>y</code>. Equivalent    to <code>x:: &amp; ::y</code>. This is what <code>git log</code> calls <code>--ancestry-path x..y</code>.</li> <li><code>x..y</code>: Ancestors of <code>y</code> that are not also ancestors of <code>x</code>. Equivalent to   <code>::y ~ ::x</code>. This is what <code>git log</code> calls <code>x..y</code> (i.e. the same as we call it).</li> <li><code>::</code>: All visible commits in the repo. Shorthand for   <code>root()::visible_heads()</code>. Equivalent to <code>all()</code>.</li> <li><code>..</code>: All visible commits in the repo, but excluding the root commit.   Shorthand for <code>root()..visible_heads()</code>. Equivalent to <code>~root()</code>.</li> <li><code>~x</code>: Revisions that are not in <code>x</code>.</li> <li><code>x &amp; y</code>: Revisions that are in both <code>x</code> and <code>y</code>.</li> <li><code>x ~ y</code>: Revisions that are in <code>x</code> but not in <code>y</code>.</li> <li><code>x | y</code>: Revisions that are in either <code>x</code> or <code>y</code> (or both).</li> </ul> <p>(listed in order of binding strengths)</p> <p>You can use parentheses to control evaluation order, such as <code>(x &amp; y) | z</code> or <code>x &amp; (y | z)</code>.</p> Examples <p>Given this history: <pre><code>D\n|\\\n| o C\n| |\no | B\n|/\no A\n|\no root()\n</code></pre></p> <p>Operator <code>x-</code></p> <ul> <li><code>D-</code> \u21d2 <code>{C,B}</code></li> <li><code>B-</code> \u21d2 <code>{A}</code></li> <li><code>A-</code> \u21d2 <code>{root()}</code></li> <li><code>root()-</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>none()-</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(D|A)-</code> \u21d2 <code>{C,B,root()}</code></li> <li><code>(C|B)-</code> \u21d2 <code>{A}</code></li> </ul> <p>Operator <code>x+</code></p> <ul> <li><code>D+</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>B+</code> \u21d2 <code>{D}</code></li> <li><code>A+</code> \u21d2 <code>{B,C}</code></li> <li><code>root()+</code> \u21d2 <code>{A}</code></li> <li><code>none()+</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(C|B)+</code> \u21d2 <code>{D}</code></li> <li><code>(B|root())+</code> \u21d2 <code>{D,A}</code></li> </ul> <p>Operator <code>x::</code></p> <ul> <li><code>D::</code> \u21d2 <code>{D}</code></li> <li><code>B::</code> \u21d2 <code>{D,B}</code></li> <li><code>A::</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>root()::</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>none()::</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(C|B)::</code> \u21d2 <code>{D,C,B}</code></li> </ul> <p>Operator <code>x..</code></p> <ul> <li><code>D..</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>B..</code> \u21d2 <code>{D,C}</code> (note that, unlike <code>B::</code>, this includes <code>C</code>)</li> <li><code>A..</code> \u21d2 <code>{D,C,B}</code></li> <li><code>root()..</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>none()..</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>(C|B)..</code> \u21d2 <code>{D}</code></li> </ul> <p>Operator <code>::x</code></p> <ul> <li><code>::D</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>::B</code> \u21d2 <code>{B,A,root()}</code></li> <li><code>::A</code> \u21d2 <code>{A,root()}</code></li> <li><code>::root()</code> \u21d2 <code>{root()}</code></li> <li><code>::none()</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>::(C|B)</code> \u21d2 <code>{C,B,A,root()}</code></li> </ul> <p>Operator <code>..x</code></p> <ul> <li><code>..D</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>..B</code> \u21d2 <code>{B,A}</code></li> <li><code>..A</code> \u21d2 <code>{A}</code></li> <li><code>..root()</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>..none()</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>..(C|B)</code> \u21d2 <code>{C,B,A}</code></li> </ul> <p>Operator <code>x::y</code></p> <ul> <li><code>D::D</code> \u21d2 <code>{D}</code></li> <li><code>B::D</code> \u21d2 <code>{D,B}</code> (note that, unlike <code>B..D</code>, this includes <code>B</code> and excludes <code>C</code>)</li> <li><code>A::D</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>root()::D</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>none()::D</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>D::B</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(C|B)::(C|B)</code> \u21d2 <code>{C,B}</code></li> </ul> <p>Operator <code>x..y</code></p> <ul> <li><code>D..D</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>B..D</code> \u21d2 <code>{D,C}</code> (note that, unlike <code>B::D</code>, this includes <code>C</code> and excludes <code>B</code>)</li> <li><code>A..D</code> \u21d2 <code>{D,C,B}</code></li> <li><code>root()..D</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>none()..D</code> \u21d2 <code>{D,C,B,A,root()}</code></li> <li><code>D..B</code> \u21d2 <code>{}</code> (empty set)</li> <li><code>(C|B)..(C|B)</code> \u21d2 <code>{}</code> (empty set)</li> </ul>"},{"location":"revsets.html#functions","title":"Functions","text":"<p>You can also specify revisions by using functions. Some functions take other revsets (expressions) as arguments.</p> <ul> <li> <p><code>parents(x)</code>: Same as <code>x-</code>.</p> </li> <li> <p><code>children(x)</code>: Same as <code>x+</code>.</p> </li> <li> <p><code>ancestors(x[, depth])</code>: <code>ancestors(x)</code> is the same as <code>::x</code>.   <code>ancestors(x, depth)</code> returns the ancestors of <code>x</code> limited to the given   <code>depth</code>.</p> </li> <li> <p><code>descendants(x[, depth])</code>: <code>descendants(x)</code> is the same as <code>x::</code>.   <code>descendants(x, depth)</code> returns the descendants of <code>x</code> limited to the given   <code>depth</code>.</p> </li> <li> <p><code>reachable(srcs, domain)</code>: All commits reachable from <code>srcs</code> within   <code>domain</code>, traversing all parent and child edges.</p> </li> <li> <p><code>connected(x)</code>: Same as <code>x::x</code>. Useful when <code>x</code> includes several commits.</p> </li> <li> <p><code>all()</code>: All visible commits in the repo.</p> </li> <li> <p><code>none()</code>: No commits. This function is rarely useful; it is provided for   completeness.</p> </li> <li> <p><code>bookmarks([pattern])</code>: All local bookmark targets. If <code>pattern</code> is specified,   this selects the bookmarks whose name match the given string   pattern. For example, <code>bookmarks(push)</code> would match the   bookmarks <code>push-123</code> and <code>repushed</code> but not the bookmark <code>main</code>. If a bookmark is   in a conflicted state, all its possible targets are included.</p> </li> <li> <p><code>remote_bookmarks([bookmark_pattern[, [remote=]remote_pattern]])</code>: All remote   bookmarks targets across all remotes. If just the <code>bookmark_pattern</code> is   specified, the bookmarks whose names match the given string   pattern across all remotes are selected. If both   <code>bookmark_pattern</code> and <code>remote_pattern</code> are specified, the selection is   further restricted to just the remotes whose names match <code>remote_pattern</code>.</p> <p>For example, <code>remote_bookmarks(push, ri)</code> would match the bookmarks <code>push-123@origin</code> and <code>repushed@private</code> but not <code>push-123@upstream</code> or <code>main@origin</code> or <code>main@upstream</code>. If a bookmark is in a conflicted state, all its possible targets are included.</p> <p>While Git-tracking bookmarks can be selected by <code>&lt;name&gt;@git</code>, these bookmarks aren't included in <code>remote_bookmarks()</code>.</p> </li> <li> <p><code>tracked_remote_bookmarks([bookmark_pattern[, [remote=]remote_pattern]])</code>: All   targets of tracked remote bookmarks. Supports the same optional arguments as   <code>remote_bookmarks()</code>.</p> </li> <li> <p><code>untracked_remote_bookmarks([bookmark_pattern[, [remote=]remote_pattern]])</code>:   All targets of untracked remote bookmarks. Supports the same optional arguments   as <code>remote_bookmarks()</code>.</p> </li> <li> <p><code>tags([pattern])</code>: All tag targets. If <code>pattern</code> is specified,   this selects the tags whose name match the given string   pattern. For example, <code>tags(v1)</code> would match the   tags <code>v123</code> and <code>rev1</code> but not the tag <code>v2</code>. If a tag is   in a conflicted state, all its possible targets are included.</p> </li> <li> <p><code>git_refs()</code>:  All Git ref targets as of the last import. If a Git ref   is in a conflicted state, all its possible targets are included.</p> </li> <li> <p><code>git_head()</code>: The Git <code>HEAD</code> target as of the last import.</p> </li> <li> <p><code>visible_heads()</code>: All visible heads (same as <code>heads(all())</code>).</p> </li> <li> <p><code>root()</code>: The virtual commit that is the oldest ancestor of all other commits.</p> </li> <li> <p><code>heads(x)</code>: Commits in <code>x</code> that are not ancestors of other commits in <code>x</code>.   Note that this is different from   Mercurial's <code>heads(x)</code>   function, which is equivalent to <code>x ~ x-</code>.</p> </li> <li> <p><code>roots(x)</code>: Commits in <code>x</code> that are not descendants of other commits in <code>x</code>.   Note that this is different from   Mercurial's <code>roots(x)</code>   function, which is equivalent to <code>x ~ x+</code>.</p> </li> <li> <p><code>latest(x[, count])</code>: Latest <code>count</code> commits in <code>x</code>, based on committer   timestamp. The default <code>count</code> is 1.</p> </li> <li> <p><code>fork_point(x)</code>: The fork point of all commits in <code>x</code>. The fork point is the   common ancestor(s) of all commits in <code>x</code> which do not have any descendants   that are also common ancestors of all commits in <code>x</code>. It is equivalent to   the revset <code>heads(::x_1 &amp; ::x_2 &amp; ... &amp; ::x_N)</code>, where <code>x_{1..N}</code> are commits   in <code>x</code>. If <code>x</code> resolves to a single commit, <code>fork_point(x)</code> resolves to <code>x</code>.</p> </li> <li> <p><code>merges()</code>: Merge commits.</p> </li> <li> <p><code>description(pattern)</code>: Commits that have a description matching the given   string pattern.</p> <p>A non-empty description is usually terminated with newline character. For example, <code>description(exact:\"\")</code> matches commits without description, and <code>description(exact:\"foo\\n\")</code> matches commits with description <code>\"foo\\n\"</code>.</p> </li> <li> <p><code>subject(pattern)</code>: Commits that have a subject matching the given string   pattern. A subject is the first line of the description   (without newline character.)</p> </li> <li> <p><code>author(pattern)</code>: Commits with the author's name or email matching the given   string pattern. Equivalent to <code>author_name(pattern) |   author_email(pattern)</code>.</p> </li> <li> <p><code>author_name(pattern)</code>: Commits with the author's name matching the given   string pattern.</p> </li> <li> <p><code>author_email(pattern)</code>: Commits with the author's email matching the given   string pattern.</p> </li> <li> <p><code>author_date(pattern)</code>: Commits with author dates matching the specified date   pattern.</p> </li> <li> <p><code>mine()</code>: Commits where the author's email matches the email of the current   user. Equivalent to <code>author_email(exact-i:&lt;user-email&gt;)</code></p> </li> <li> <p><code>committer(pattern)</code>: Commits with the committer's name or email matching the   given string pattern. Equivalent to   <code>committer_name(pattern) | committer_email(pattern)</code>.</p> </li> <li> <p><code>committer_name(pattern)</code>: Commits with the committer's name matching the   given string pattern.</p> </li> <li> <p><code>committer_email(pattern)</code>: Commits with the committer's email matching the   given string pattern.</p> </li> <li> <p><code>committer_date(pattern)</code>: Commits with committer dates matching the specified   date pattern.</p> </li> <li> <p><code>empty()</code>: Commits modifying no files. This also includes <code>merges()</code> without   user modifications and <code>root()</code>.</p> </li> <li> <p><code>files(expression)</code>: Commits modifying paths matching the given fileset   expression.</p> <p>Paths are relative to the directory <code>jj</code> was invoked from. A directory name will match all files in that directory and its subdirectories.</p> <p>For example, <code>files(foo)</code> will match files <code>foo</code>, <code>foo/bar</code>, <code>foo/bar/baz</code>. It will not match <code>foobar</code> or <code>bar/foo</code>.</p> <p>Some file patterns might need quoting because the <code>expression</code> must also be parsable as a revset. For example, <code>.</code> has to be quoted in <code>files(\".\")</code>.</p> </li> <li> <p><code>diff_contains(text[, files])</code>: Commits containing diffs matching the given   <code>text</code> pattern line by line.</p> <p>The search paths can be narrowed by the <code>files</code> expression. All modified files are scanned by default, but it is likely to change in future version to respect the command line path arguments.</p> <p>For example, <code>diff_contains(\"TODO\", \"src\")</code> will search revisions where \"TODO\" is added to or removed from files under \"src\".</p> </li> <li> <p><code>conflicts()</code>: Commits with conflicts.</p> </li> <li> <p><code>present(x)</code>: Same as <code>x</code>, but evaluated to <code>none()</code> if any of the commits   in <code>x</code> doesn't exist (e.g. is an unknown bookmark name.)</p> </li> <li> <p><code>coalesce(revsets...)</code>: Commits in the first revset in the list of <code>revsets</code>   which does not evaluate to <code>none()</code>. If all revsets evaluate to <code>none()</code>, then   the result of <code>coalesce</code> will also be <code>none()</code>.</p> </li> <li> <p><code>working_copies()</code>: The working copy commits across all the workspaces.</p> </li> <li> <p><code>at_operation(op, x)</code>: Evaluates <code>x</code> at the specified operation. For   example, <code>at_operation(@-, visible_heads())</code> will return all heads which were   visible at the previous operation.</p> </li> </ul> Examples <p>Given this history: <pre><code>E\n|\n| D\n|/|\n| o C\n| |\no | B\n|/\no A\n|\no root()\n</code></pre></p> <p>function <code>reachable()</code></p> <ul> <li><code>reachable(E, A..)</code> \u21d2 <code>{E,D,C,B}</code></li> <li><code>reachable(D, A..)</code> \u21d2 <code>{E,D,C,B}</code></li> <li><code>reachable(C, A..)</code> \u21d2 <code>{E,D,C,B}</code></li> <li><code>reachable(B, A..)</code> \u21d2 <code>{E,D,C,B}</code></li> <li><code>reachable(A, A..)</code> \u21d2 <code>{}</code> (empty set)</li> </ul> <p>function <code>connected()</code></p> <ul> <li><code>connected(E|A)</code> \u21d2 <code>{E,B,A}</code></li> <li><code>connected(D|A)</code> \u21d2 <code>{D,C,B,A}</code></li> <li><code>connected(A)</code> \u21d2 <code>{A}</code></li> </ul> <p>function <code>heads()</code></p> <ul> <li><code>heads(E|D)</code> \u21d2 <code>{E,D}</code></li> <li><code>heads(E|C)</code> \u21d2 <code>{E,C}</code></li> <li><code>heads(E|B)</code> \u21d2 <code>{E}</code></li> <li><code>heads(E|A)</code> \u21d2 <code>{E}</code></li> <li><code>heads(A)</code> \u21d2 <code>{A}</code></li> </ul> <p>function <code>roots()</code></p> <ul> <li><code>roots(E|D)</code> \u21d2 <code>{E,D}</code></li> <li><code>roots(E|C)</code> \u21d2 <code>{E,C}</code></li> <li><code>roots(E|B)</code> \u21d2 <code>{B}</code></li> <li><code>roots(E|A)</code> \u21d2 <code>{A}</code></li> <li><code>roots(A)</code> \u21d2 <code>{A}</code></li> </ul> <p>function <code>fork_point()</code></p> <ul> <li><code>fork_point(E|D)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(E|C)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(E|B)</code> \u21d2 <code>{B}</code></li> <li><code>fork_point(E|A)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(D|C)</code> \u21d2 <code>{C}</code></li> <li><code>fork_point(D|B)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(B|C)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(A)</code> \u21d2 <code>{A}</code></li> <li><code>fork_point(none())</code> \u21d2 <code>{}</code></li> </ul>"},{"location":"revsets.html#string-patterns","title":"String patterns","text":"<p>Functions that perform string matching support the following pattern syntax:</p> <ul> <li><code>\"string\"</code>, or <code>string</code> (the quotes are optional), or <code>substring:\"string\"</code>:   Matches strings that contain <code>string</code>.</li> <li><code>exact:\"string\"</code>: Matches strings exactly equal to <code>string</code>.</li> <li><code>glob:\"pattern\"</code>: Matches strings with Unix-style shell wildcard   <code>pattern</code>.</li> <li><code>regex:\"pattern\"</code>: Matches substrings with regular   expression <code>pattern</code>.</li> </ul> <p>You can append <code>-i</code> after the kind to match case\u2010insensitively (e.g. <code>glob-i:\"fix*jpeg*\"</code>).</p>"},{"location":"revsets.html#date-patterns","title":"Date patterns","text":"<p>Functions that perform date matching support the following pattern syntax:</p> <ul> <li><code>after:\"string\"</code>: Matches dates exactly at or after the given date.</li> <li><code>before:\"string\"</code>: Matches dates before, but not including, the given date.</li> </ul> <p>Date strings can be specified in several forms, including:</p> <ul> <li>2024-02-01</li> <li>2024-02-01T12:00:00</li> <li>2024-02-01T12:00:00-08:00</li> <li>2024-02-01 12:00:00</li> <li>2 days ago</li> <li>5 minutes ago</li> <li>yesterday</li> <li>yesterday 5pm</li> <li>yesterday 10:30</li> <li>yesterday 15:30</li> </ul>"},{"location":"revsets.html#aliases","title":"Aliases","text":"<p>New symbols and functions can be defined in the config file, by using any combination of the predefined symbols/functions and other aliases.</p> <p>Alias functions can be overloaded by the number of parameters. However, builtin function will be shadowed by name, and can't co-exist with aliases.</p> <p>For example:</p> <pre><code>[revset-aliases]\n'HEAD' = '@-'\n'user()' = 'user(\"me@example.org\")'\n'user(x)' = 'author(x) | committer(x)'\n</code></pre>"},{"location":"revsets.html#built-in-aliases","title":"Built-in Aliases","text":"<p>The following aliases are built-in and used for certain operations. These functions are defined as aliases in order to allow you to overwrite them as needed. See revsets.toml for a comprehensive list.</p> <ul> <li> <p><code>trunk()</code>: Resolves to the head commit for the trunk bookmark of the remote   named <code>origin</code> or <code>upstream</code>. The bookmarks <code>main</code>, <code>master</code>, and <code>trunk</code> are   tried. If more than one potential trunk commit exists, the newest one is   chosen. If none of the bookmarks exist, the revset evaluates to <code>root()</code>.</p> <p>When working with an existing Git repository (via <code>jj git clone</code> or <code>jj git init</code>), <code>trunk()</code> will be overridden at the repository level to the default bookmark of the remote <code>origin</code>.</p> <p>You can override this as appropriate. If you do, make sure it always resolves to exactly one commit. For example:</p> <pre><code>[revset-aliases]\n'trunk()' = 'your-bookmark@your-remote'\n</code></pre> </li> <li> <p><code>builtin_immutable_heads()</code>: Resolves to   <code>present(trunk()) | tags() | untracked_remote_bookmarks()</code>. It is used as the    default definition for <code>immutable_heads()</code> below. It is not recommended to    redefine this alias. Prefer to redefine <code>immutable_heads()</code> instead.</p> </li> <li> <p><code>immutable_heads()</code>: Resolves to   <code>present(trunk()) | tags() | untracked_remote_bookmarks()</code> by default. It is   actually defined as <code>builtin_immutable_heads()</code>, and can be overridden as   required. See here for details.</p> </li> <li> <p><code>immutable()</code>: The set of commits that <code>jj</code> treats as immutable. This is   equivalent to <code>::(immutable_heads() | root())</code>. It is not recommended to redefine   this alias. Note that modifying this will not change whether a commit is immutable.   To do that, edit <code>immutable_heads()</code>.</p> </li> <li> <p><code>mutable()</code>: The set of commits that <code>jj</code> treats as mutable. This is   equivalent to <code>~immutable()</code>. It is not recommended to redefined this alias.   Note that modifying this will not change whether a commit is immutable.   To do that, edit <code>immutable_heads()</code>.</p> </li> </ul>"},{"location":"revsets.html#the-all-modifier","title":"The <code>all:</code> modifier","text":"<p>Certain commands (such as <code>jj rebase</code>) can take multiple revset arguments, and each of these may resolve to one-or-many revisions. By default, <code>jj</code> will not allow revsets that resolve to more than one revision \u2014 a so-called \"large revset\" \u2014 and will ask you to confirm that you want to proceed by prefixing it with the <code>all:</code> modifier.</p> <p>If you set the <code>ui.always-allow-large-revsets</code> option to <code>true</code>, <code>jj</code> will behave as though the <code>all:</code> modifier was used every time it would matter.</p> <p>An <code>all:</code> modifier before a revset expression does not otherwise change its meaning. Strictly speaking, it is not part of the revset language. The notation is similar to the modifiers like <code>glob:</code> allowed before string patterms.</p> <p>For example, <code>jj rebase -r w -d xyz+</code> will rebase <code>w</code> on top of the child of <code>xyz</code> as long as <code>xyz</code> has exactly one child.</p> <p>If <code>xyz</code> has more than one child, the <code>all:</code> modifier is not specified, and <code>ui.always-allow-large-revsets</code> is <code>false</code> (the default), <code>jj rebase -r w -d xyz+</code> will return an error.</p> <p>If <code>ui.always-allow-large-revsets</code> was <code>true</code>, the above command would act as if <code>all:</code> was set (see the next paragraph).</p> <p>With the <code>all:</code> modifier, <code>jj rebase -r w -d all:xyz+</code> will make <code>w</code> into a merge commit if <code>xyz</code> has more than one child. The <code>all:</code> modifier confirms that the user expected <code>xyz</code> to have more than one child.</p> <p>A more useful example: if <code>w</code> is a merge commit, <code>jj rebase -s w -d all:w- -d xyz</code> will add <code>xyz</code> to the list of <code>w</code>'s parents.</p>"},{"location":"revsets.html#examples","title":"Examples","text":"<p>Show the parent(s) of the working-copy commit (like <code>git log -1 HEAD</code>):</p> <pre><code>jj log -r @-\n</code></pre> <p>Show all ancestors of the working copy (like plain <code>git log</code>)</p> <pre><code>jj log -r ::@\n</code></pre> <p>Show commits not on any remote bookmark:</p> <pre><code>jj log -r 'remote_bookmarks()..'\n</code></pre> <p>Show commits not on <code>origin</code> (if you have other remotes like <code>fork</code>):</p> <pre><code>jj log -r 'remote_bookmarks(remote=origin)..'\n</code></pre> <p>Show the initial commits in the repo (the ones Git calls \"root commits\"):</p> <pre><code>jj log -r 'root()+'\n</code></pre> <p>Show some important commits (like <code>git --simplify-by-decoration</code>):</p> <pre><code>jj log -r 'tags() | bookmarks()'\n</code></pre> <p>Show local commits leading up to the working copy, as well as descendants of those commits:</p> <pre><code>jj log -r '(remote_bookmarks()..@)::'\n</code></pre> <p>Show commits authored by \"martinvonz\" and containing the word \"reset\" in the description:</p> <pre><code>jj log -r 'author(martinvonz) &amp; description(reset)'\n</code></pre>"},{"location":"roadmap.html","title":"Roadmap","text":"<p>This documents some of the goals we have. Many of them are quite independent.</p> <p>Note: Most people contributing to Jujutsu do so in their spare time, which  means that we cannot attach any target dates to any of the goals below.</p>"},{"location":"roadmap.html#support-for-copies-and-renames","title":"Support for copies and renames","text":"<p>We want to support copy tracing in a way that leaves it up to the commit backend to either record or detect copies. That should let us work with existing Git repos (Git does not record copies, it detects them on the fly) as well as with very large repos where detection would be too slow. See design doc.</p>"},{"location":"roadmap.html#forge-integrations","title":"Forge integrations","text":"<p>We would like to make it easier to work with various popular forges by providing something like <code>jj github submit</code>, <code>jj gitlab submit</code>, and <code>jj gerrit send</code>. For popular forges, we might include that support by default in the standard <code>jj</code> binary.</p>"},{"location":"roadmap.html#submodule-support","title":"Submodule support","text":"<p>Git submodules are used frequently enough in large Git repos that we will probably need to support them. There are still big open questions around UX.</p>"},{"location":"roadmap.html#better-rust-api-for-uis","title":"Better Rust API for UIs","text":"<p>UIs like gg currently have to duplicate quite a bit of logic from <code>jj-cli</code>. We need to make this code not specific to the CLI (e.g. return status objects instead of printing messages) and move it into <code>jj-lib</code>.</p>"},{"location":"roadmap.html#rpc-api","title":"RPC API","text":"<p>One problem with writing tools using the Rust API is that they will only work with the backends they were compiled with. For example, a regular gg build will not work on Google repos because it doesn't have the backends necessary to load them. We want to provide an RPC API for tools that want to work with an unknown build of <code>jj</code> by having the tool run something like <code>jj api</code> to give it an address to talk to.</p> <p>In addition to helping with the problem of unknown backends, having an RPC API should make it easier for tools like VS Code that are not written in Rust. The RPC API will probably be at a higher abstraction level than the Rust API.</p> <p>See design doc.</p>"},{"location":"roadmap.html#open-source-cloud-based-repos-server-and-daemon-process","title":"Open-source cloud-based repos (server and daemon process)","text":"<p>Google has an internal Jujutsu server backed by a database. This server allows commits and repos (operation logs) to be stored in the cloud (i.e. the database). Working copies can still be stored locally.</p> <p>In order to reduce latency, there is a local daemon process that caches reads and writes. It also prefetches of objects it thinks the client might ask for next. In also helps with write latency by optimistically answering write requests (it therefore needs to know the server's hashing scheme so it can return the right IDs).</p> <p>We (the project, not necessarily Google) want to provide a similar experience for all users. We would therefore like to create a similar server and daemon. The daemon might be the same process as for the RPC API mentioned above.</p>"},{"location":"roadmap.html#virtual-file-system-vfs","title":"Virtual file system (VFS)","text":"<p>For very large projects and/or large files, it can be expensive to update the working copy. We want to provide a VFS to help with that. Updating the working copy to another commit can then be done simply by telling the VFS to use the other commit as base, without needing to download any large files in the target commit until the user asks for them via the file system. A VFS can also make it cheap to snapshot the working copy by keeping track of all changes compared to the base commit.</p> <p>Having a VFS can also be very benefial for <code>jj run</code>, since we can then cheaply create temporary working copies for the commands to run in.</p>"},{"location":"roadmap.html#better-support-for-large-files","title":"Better support for large files","text":"<p>We have talked about somehow using content-defined chunking (CDC) to reduce storage and transfer costs for large files. Maybe we will store files in our future cloud-based server using the same model as XetHub.</p>"},{"location":"sapling-comparison.html","title":"Comparison with Sapling","text":""},{"location":"sapling-comparison.html#introduction","title":"Introduction","text":"<p>This document attempts to describe how jj is different from Sapling. Sapling is a VCS developed by Meta. It was announced about 3 years after development started on jj. It is a heavily modified fork of Mercurial. Because jj has copied many ideas from Mercurial, there are many similarities between the two tools, such as:</p> <ul> <li>A user-friendly CLI</li> <li>A \"revset\" language for selecting revisions</li> <li>Good support for working with stacked commits, including tracking \"anonymous   heads\" (no \"detached HEAD\" state like in Git) and <code>split</code> commands, and   automatically rebasing descendant commits when you amend a commit.</li> <li>Flexible customization of output using templates</li> </ul>"},{"location":"sapling-comparison.html#differences","title":"Differences","text":"<p>Here is a list of some differences between jj and Sapling.</p> <ul> <li> <p>Working copy: When using Sapling (like most VCSs), the   user explicitly tells the tool when to create a commit and which files to   include. When using jj, the working copy   is automatically snapshotted by every command. New files   are automatically tracked and deleted files are automatically untracked. This   has several advantages:</p> <ul> <li>The working copy is effectively backed up every time you run a command.</li> <li>No commands fail because you have changes in the working copy (\"abort: 1   conflicting file changes: ...\"). No need for <code>sl shelve</code>.</li> <li>Simpler and more consistent CLI because the working copy is treated like any   other commit.</li> </ul> </li> <li> <p>Conflicts: Like most VCSs, Sapling requires the user to   resolve conflicts before committing. jj lets   you commit conflicts. Note that it's a representation of the   conflict that's committed, not conflict markers (<code>&lt;&lt;&lt;&lt;&lt;&lt;&lt;</code> etc.). This also   has several advantages:</p> <ul> <li>Merge conflicts won't prevent you from checking out another commit.</li> <li>You can resolve the conflicts when you feel like it.</li> <li>Rebasing descendants always succeeds. Like jj, Sapling automatically   rebases, but it will fail if there are conflicts.</li> <li>Merge commits can be rebased correctly (Sapling sometimes fails).</li> <li>You can rebase conflicts and conflict resolutions.</li> </ul> </li> <li> <p>Undo: jj's undo is powered by the operation log, which   records how the repo has changed over time. Sapling has a similar feature   with its MetaLog.   They seem to provide similar functionality, but jj also exposes the log to the   user via <code>jj op log</code>, so you can tell how far back you want to go back.   Sapling has <code>sl debugmetalog</code>, but that seems to show the history of a single   commit, not the whole repo's history. Thanks to jj snapshotting the working   copy, it's possible to undo changes to the working copy. For example, if   you <code>jj undo</code> a <code>jj commit</code>, <code>jj diff</code> will show the same changes as   before <code>jj commit</code>, but if you <code>sl undo</code> a <code>sl commit</code>, the working copy will   be clean.</p> </li> <li>Git interop: Sapling supports cloning, pushing, and pulling from a remote   Git repo. jj also does, and it also supports sharing a working copy with a Git   repo, so you can use <code>jj</code> and <code>git</code> interchangeably in the same repo.</li> <li>Polish: Sapling is more polished and feature-complete. For example, jj   has no <code>bisect</code> command. Sapling also has very nice built-in web UI called   Interactive Smartlog, which lets   you drag and drop commits to rebase them, among other things.</li> <li>Forge workflow: Sapling has <code>sl pr submit --stack</code>, which lets you   push a stack of commits as separate GitHub PRs, including setting the base   branch. It only supports GitHub. jj doesn't have any direct integration with   GitHub or any other forge. However, it has <code>jj git push --change</code> for   automatically creating branches for specified commits. You have to specify   each commit you want to create a branch for by using   <code>jj git push --change X --change Y ...</code>, and you have to manually set up any   base branches in GitHub's UI (or GitLab's or ...). On subsequent pushes, you   can update all at once by specifying something like <code>jj git push -r main..@</code>   (to push all branches on the current stack of commits from where it forked   from <code>main</code>).</li> </ul>"},{"location":"templates.html","title":"Templates","text":"<p>Jujutsu supports a functional language to customize output of commands. The language consists of literals, keywords, operators, functions, and methods.</p> <p>A couple of <code>jj</code> commands accept a template via <code>-T</code>/<code>--template</code> option.</p>"},{"location":"templates.html#keywords","title":"Keywords","text":"<p>Keywords represent objects of different types; the types are described in a follow-up section. In addition to context-specific keywords, the top-level object can be referenced as <code>self</code>.</p>"},{"location":"templates.html#commit-keywords","title":"Commit keywords","text":"<p>In <code>jj log</code>/<code>jj evolog</code> templates, all 0-argument methods of the <code>Commit</code> type are available as keywords. For example, <code>commit_id</code> is equivalent to <code>self.commit_id()</code>.</p>"},{"location":"templates.html#operation-keywords","title":"Operation keywords","text":"<p>In <code>jj op log</code> templates, all 0-argument methods of the <code>Operation</code> type are available as keywords. For example, <code>current_operation</code> is equivalent to <code>self.current_operation()</code>.</p>"},{"location":"templates.html#operators","title":"Operators","text":"<p>The following operators are supported.</p> <ul> <li><code>x.f()</code>: Method call.</li> <li><code>-x</code>: Negate integer value.</li> <li><code>!x</code>: Logical not.</li> <li><code>x &gt;= y</code>, <code>x &gt; y</code>, <code>x &lt;= y</code>, <code>x &lt; y</code>: Greater than or equal/greater than/   lesser than or equal/lesser than. Operands must be <code>Integer</code>s.</li> <li><code>x == y</code>, <code>x != y</code>: Equal/not equal. Operands must be either <code>Boolean</code>,   <code>Integer</code>, or <code>String</code>.</li> <li><code>x &amp;&amp; y</code>: Logical and, short-circuiting.</li> <li><code>x || y</code>: Logical or, short-circuiting.</li> <li><code>x ++ y</code>: Concatenate <code>x</code> and <code>y</code> templates.</li> </ul> <p>(listed in order of binding strengths)</p>"},{"location":"templates.html#global-functions","title":"Global functions","text":"<p>The following functions are defined.</p> <ul> <li><code>fill(width: Integer, content: Template) -&gt; Template</code>: Fill lines at   the given <code>width</code>.</li> <li><code>indent(prefix: Template, content: Template) -&gt; Template</code>: Indent   non-empty lines by the given <code>prefix</code>.</li> <li><code>pad_start(width: Integer, content: Template[, fill_char: Template])</code>: Pad (or   right-justify) content by adding leading fill characters. The <code>content</code>   shouldn't have newline character.</li> <li><code>pad_end(width: Integer, content: Template[, fill_char: Template])</code>: Pad (or   left-justify) content by adding trailing fill characters. The <code>content</code>   shouldn't have newline character.</li> <li><code>pad_centered(width: Integer, content: Template[, fill_char: Template])</code>: Pad   content by adding both leading and trailing fill characters. If an odd number   of fill characters are needed, the trailing fill will be one longer than the   leading fill. The <code>content</code> shouldn't have newline characters.</li> <li><code>truncate_start(width: Integer, content: Template)</code>: Truncate <code>content</code> by   removing leading characters. The <code>content</code> shouldn't have newline character.</li> <li><code>truncate_end(width: Integer, content: Template)</code>: Truncate <code>content</code> by   removing trailing characters. The <code>content</code> shouldn't have newline character.</li> <li><code>label(label: Template, content: Template) -&gt; Template</code>: Apply label to   the content. The <code>label</code> is evaluated as a space-separated string.</li> <li><code>raw_escape_sequence(content: Template) -&gt; Template</code>: Preserves any escape   sequences in <code>content</code> (i.e., bypasses sanitization) and strips labels.   Note: This function is intended for escape sequences and as such, its output   is expected to be invisible / of no display width. Outputting content with   nonzero display width may break wrapping, indentation etc.</li> <li><code>if(condition: Boolean, then: Template[, else: Template]) -&gt; Template</code>:   Conditionally evaluate <code>then</code>/<code>else</code> template content.</li> <li><code>coalesce(content: Template...) -&gt; Template</code>: Returns the first non-empty   content.</li> <li><code>concat(content: Template...) -&gt; Template</code>:   Same as <code>content_1 ++ ... ++ content_n</code>.</li> <li><code>separate(separator: Template, content: Template...) -&gt; Template</code>:   Insert separator between non-empty contents.</li> <li><code>surround(prefix: Template, suffix: Template, content: Template) -&gt; Template</code>:   Surround non-empty content with texts such as parentheses.</li> <li><code>config(name: String) -&gt; ConfigValue</code>: Look up configuration value by <code>name</code>.</li> </ul>"},{"location":"templates.html#types","title":"Types","text":""},{"location":"templates.html#boolean-type","title":"Boolean type","text":"<p>No methods are defined. Can be constructed with <code>false</code> or <code>true</code> literal.</p>"},{"location":"templates.html#commit-type","title":"Commit type","text":"<p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>description() -&gt; String</code></li> <li><code>change_id() -&gt; ChangeId</code></li> <li><code>commit_id() -&gt; CommitId</code></li> <li><code>parents() -&gt; List&lt;Commit&gt;</code></li> <li><code>author() -&gt; Signature</code></li> <li><code>committer() -&gt; Signature</code></li> <li><code>signature() -&gt; Option&lt;CryptographicSignature&gt;</code></li> <li><code>mine() -&gt; Boolean</code>: Commits where the author's email matches the email of the current   user.</li> <li><code>working_copies() -&gt; String</code>: For multi-workspace repository, indicate   working-copy commit as <code>&lt;workspace name&gt;@</code>.</li> <li><code>current_working_copy() -&gt; Boolean</code>: True for the working-copy commit of the   current workspace.</li> <li><code>bookmarks() -&gt; List&lt;RefName&gt;</code>: Local and remote bookmarks pointing to the   commit. A tracking remote bookmark will be included only if its target is   different from the local one.</li> <li><code>local_bookmarks() -&gt; List&lt;RefName&gt;</code>: All local bookmarks pointing to the commit.</li> <li><code>remote_bookmarks() -&gt; List&lt;RefName&gt;</code>: All remote bookmarks pointing to the commit.</li> <li><code>tags() -&gt; List&lt;RefName&gt;</code></li> <li><code>git_refs() -&gt; List&lt;RefName&gt;</code></li> <li><code>git_head() -&gt; Boolean</code>: True for the Git <code>HEAD</code> commit.</li> <li><code>divergent() -&gt; Boolean</code>: True if the commit's change id corresponds to multiple   visible commits.</li> <li><code>hidden() -&gt; Boolean</code>: True if the commit is not visible (a.k.a. abandoned).</li> <li><code>immutable() -&gt; Boolean</code>: True if the commit is included in the set of   immutable commits.</li> <li><code>contained_in(revset: String) -&gt; Boolean</code>: True if the commit is included in the provided revset.</li> <li><code>conflict() -&gt; Boolean</code>: True if the commit contains merge conflicts.</li> <li><code>empty() -&gt; Boolean</code>: True if the commit modifies no files.</li> <li><code>diff([files: String]) -&gt; TreeDiff</code>: Changes from the parents within the   <code>files</code> expression. All files are compared by default, but it is   likely to change in future version to respect the command line path arguments.</li> <li><code>root() -&gt; Boolean</code>: True if the commit is the root commit.</li> </ul>"},{"location":"templates.html#commitid-changeid-type","title":"CommitId / ChangeId type","text":"<p>The following methods are defined.</p> <ul> <li><code>.normal_hex() -&gt; String</code>: Normal hex representation (0-9a-f), useful for   ChangeId, whose canonical hex representation is \"reversed\" (z-k).</li> <li><code>.short([len: Integer]) -&gt; String</code></li> <li><code>.shortest([min_len: Integer]) -&gt; ShortestIdPrefix</code>: Shortest unique prefix.</li> </ul>"},{"location":"templates.html#configvalue-type","title":"ConfigValue type","text":"<p>This type can be printed in TOML syntax. The following methods are defined.</p> <ul> <li><code>.as_boolean() -&gt; Boolean</code>: Extract boolean.</li> <li><code>.as_integer() -&gt; Integer</code>: Extract integer.</li> <li><code>.as_string() -&gt; String</code>: Extract string. This does not convert non-string   value (e.g. integer) to string.</li> <li><code>.as_string_list() -&gt; List&lt;String&gt;</code>: Extract list of strings.</li> </ul>"},{"location":"templates.html#cryptographicsignature-type","title":"CryptographicSignature type","text":"<p>The following methods are defined.</p> <ul> <li><code>.status() -&gt; String</code>: The signature's status (<code>\"good\"</code>, <code>\"bad\"</code>, <code>\"unknown\"</code>, <code>\"invalid\"</code>).</li> <li><code>.key() -&gt; String</code>: The signature's key id representation (for GPG, this is the key fingerprint).</li> <li><code>.display() -&gt; String</code>: The signature's display string (for GPG this is the formatted primary user ID).</li> </ul> <p>Warning</p> <p>Calling any of <code>.status()</code>, <code>.key()</code>, or <code>.display()</code> is slow, as it incurs the performance cost of verifying the signature (for example shelling out to <code>gpg</code> or <code>ssh-keygen</code>). Though consecutive calls will be faster, because the backend caches the verification result.</p> <p>Info</p> <p>As opposed to calling any of <code>.status()</code>, <code>.key()</code>, or <code>.display()</code>, checking for signature presence through boolean coercion is fast: <pre><code>if(commit.signature(), \"commit has a signature\", \"commit is unsigned\")\n</code></pre></p>"},{"location":"templates.html#diffstats-type","title":"DiffStats type","text":"<p>This type can be printed as a histogram of the changes. The following methods are defined.</p> <ul> <li><code>.total_added() -&gt; Integer</code>: Total number of insertions.</li> <li><code>.total_removed() -&gt; Integer</code>: Total number of deletions.</li> </ul>"},{"location":"templates.html#email-type","title":"Email type","text":"<p>The email field of a signature may or may not look like an email address. It may be empty, may not contain the symbol <code>@</code>, and could in principle contain multiple <code>@</code>s.</p> <p>The following methods are defined.</p> <ul> <li><code>.local() -&gt; String</code>: the part of the email before the first <code>@</code>, usually the   username.</li> <li><code>.domain() -&gt; String</code>: the part of the email after the first <code>@</code> or the empty   string.</li> </ul>"},{"location":"templates.html#integer-type","title":"Integer type","text":"<p>No methods are defined.</p>"},{"location":"templates.html#list-type","title":"List type","text":"<p>A list can be implicitly converted to <code>Boolean</code>. The following methods are defined.</p> <ul> <li><code>.len() -&gt; Integer</code>: Number of elements in the list.</li> <li><code>.join(separator: Template) -&gt; Template</code>: Concatenate elements with   the given <code>separator</code>.</li> <li><code>.filter(|item| expression) -&gt; List</code>: Filter list elements by predicate   <code>expression</code>. Example: <code>description.lines().filter(|s| s.contains(\"#\"))</code></li> <li><code>.map(|item| expression) -&gt; ListTemplate</code>: Apply template <code>expression</code>   to each element. Example: <code>parents.map(|c| c.commit_id().short())</code></li> </ul>"},{"location":"templates.html#listtemplate-type","title":"ListTemplate type","text":"<p>The following methods are defined. See also the <code>List</code> type.</p> <ul> <li><code>.join(separator: Template) -&gt; Template</code></li> </ul>"},{"location":"templates.html#operation-type","title":"Operation type","text":"<p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>current_operation() -&gt; Boolean</code></li> <li><code>description() -&gt; String</code></li> <li><code>id() -&gt; OperationId</code></li> <li><code>tags() -&gt; String</code></li> <li><code>time() -&gt; TimestampRange</code></li> <li><code>user() -&gt; String</code></li> <li><code>snapshot() -&gt; Boolean</code>: True if the operation is a snapshot operation.</li> <li><code>root() -&gt; Boolean</code>: True if the operation is the root operation.</li> </ul>"},{"location":"templates.html#operationid-type","title":"OperationId type","text":"<p>The following methods are defined.</p> <ul> <li><code>.short([len: Integer]) -&gt; String</code></li> </ul>"},{"location":"templates.html#option-type","title":"Option type","text":"<p>An option can be implicitly converted to <code>Boolean</code> denoting whether the contained value is set. If set, all methods of the contained value can be invoked. If not set, an error will be reported inline on method call.</p>"},{"location":"templates.html#refname-type","title":"RefName type","text":"<p>The following methods are defined.</p> <ul> <li><code>.name() -&gt; String</code>: Local bookmark or tag name.</li> <li><code>.remote() -&gt; String</code>: Remote name or empty if this is a local ref.</li> <li><code>.present() -&gt; Boolean</code>: True if the ref points to any commit.</li> <li><code>.conflict() -&gt; Boolean</code>: True if the bookmark or tag is   conflicted.</li> <li><code>.normal_target() -&gt; Option&lt;Commit&gt;</code>: Target commit if the ref is not   conflicted and points to a commit.</li> <li><code>.removed_targets() -&gt; List&lt;Commit&gt;</code>: Old target commits if conflicted.</li> <li><code>.added_targets() -&gt; List&lt;Commit&gt;</code>: New target commits. The list usually   contains one \"normal\" target.</li> <li><code>.tracked() -&gt; Boolean</code>: True if the ref is tracked by a local ref. The local   ref might have been deleted (but not pushed yet.)</li> <li><code>.tracking_present() -&gt; Boolean</code>: True if the ref is tracked by a local ref,     and if the local ref points to any commit.</li> <li><code>.tracking_ahead_count() -&gt; SizeHint</code>: Number of commits ahead of the tracking   local ref.</li> <li><code>.tracking_behind_count() -&gt; SizeHint</code>: Number of commits behind of the   tracking local ref.</li> </ul>"},{"location":"templates.html#repopath-type","title":"RepoPath type","text":"<p>A slash-separated path relative to the repository root. The following methods are defined.</p> <ul> <li><code>.display() -&gt; String</code>: Format path for display. The formatted path uses   platform-native separator, and is relative to the current working directory.</li> <li><code>.parent() -&gt; Option&lt;RepoPath&gt;</code>: Parent directory path.</li> </ul>"},{"location":"templates.html#shortestidprefix-type","title":"ShortestIdPrefix type","text":"<p>The following methods are defined.</p> <ul> <li><code>.prefix() -&gt; String</code></li> <li><code>.rest() -&gt; String</code></li> <li><code>.upper() -&gt; ShortestIdPrefix</code></li> <li><code>.lower() -&gt; ShortestIdPrefix</code></li> </ul>"},{"location":"templates.html#signature-type","title":"Signature type","text":"<p>The following methods are defined.</p> <ul> <li><code>.name() -&gt; String</code></li> <li><code>.email() -&gt; Email</code></li> <li><code>.timestamp() -&gt; Timestamp</code></li> </ul>"},{"location":"templates.html#sizehint-type","title":"SizeHint type","text":"<p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.lower() -&gt; Integer</code>: Lower bound.</li> <li><code>.upper() -&gt; Option&lt;Integer&gt;</code>: Upper bound if known.</li> <li><code>.exact() -&gt; Option&lt;Integer&gt;</code>: Exact value if upper bound is known and it   equals to the lower bound.</li> <li><code>.zero() -&gt; Boolean</code>: True if upper bound is known and is <code>0</code>.</li> </ul>"},{"location":"templates.html#string-type","title":"String type","text":"<p>A string can be implicitly converted to <code>Boolean</code>. The following methods are defined.</p> <ul> <li><code>.len() -&gt; Integer</code>: Length in UTF-8 bytes.</li> <li><code>.contains(needle: Template) -&gt; Boolean</code></li> <li><code>.first_line() -&gt; String</code></li> <li><code>.lines() -&gt; List&lt;String&gt;</code>: Split into lines excluding newline characters.</li> <li><code>.upper() -&gt; String</code></li> <li><code>.lower() -&gt; String</code></li> <li><code>.starts_with(needle: Template) -&gt; Boolean</code></li> <li><code>.ends_with(needle: Template) -&gt; Boolean</code></li> <li><code>.remove_prefix(needle: Template) -&gt; String</code>: Removes the passed prefix, if present</li> <li><code>.remove_suffix(needle: Template) -&gt; String</code>: Removes the passed suffix, if present</li> <li><code>.substr(start: Integer, end: Integer) -&gt; String</code>: Extract substring. The   <code>start</code>/<code>end</code> indices should be specified in UTF-8 bytes. Negative values   count from the end of the string.</li> </ul>"},{"location":"templates.html#string-literals","title":"String literals","text":"<p>String literals must be surrounded by single or double quotes (<code>'</code> or <code>\"</code>). A double-quoted string literal supports the following escape sequences:</p> <ul> <li><code>\\\"</code>: double quote</li> <li><code>\\\\</code>: backslash</li> <li><code>\\t</code>: horizontal tab</li> <li><code>\\r</code>: carriage return</li> <li><code>\\n</code>: new line</li> <li><code>\\0</code>: null</li> <li><code>\\e</code>: escape (i.e., <code>\\x1b</code>)</li> <li><code>\\xHH</code>: byte with hex value <code>HH</code></li> </ul> <p>Other escape sequences are not supported. Any UTF-8 characters are allowed inside a string literal, with two exceptions: unescaped <code>\"</code>-s and uses of <code>\\</code> that don't form a valid escape sequence.</p> <p>A single-quoted string literal has no escape syntax. <code>'</code> can't be expressed inside a single-quoted string literal.</p>"},{"location":"templates.html#template-type","title":"Template type","text":"<p>Most types can be implicitly converted to <code>Template</code>. No methods are defined.</p>"},{"location":"templates.html#timestamp-type","title":"Timestamp type","text":"<p>The following methods are defined.</p> <ul> <li><code>.ago() -&gt; String</code>: Format as relative timestamp.</li> <li><code>.format(format: String) -&gt; String</code>: Format with the specified strftime-like   format string.</li> <li><code>.utc() -&gt; Timestamp</code>: Convert timestamp into UTC timezone.</li> <li><code>.local() -&gt; Timestamp</code>: Convert timestamp into local timezone.</li> <li><code>.after(date: String) -&gt; Boolean</code>: True if the timestamp is exactly at or after the given date.</li> <li><code>.before(date: String) -&gt; Boolean</code>: True if the timestamp is before, but not including, the given date.</li> </ul>"},{"location":"templates.html#timestamprange-type","title":"TimestampRange type","text":"<p>The following methods are defined.</p> <ul> <li><code>.start() -&gt; Timestamp</code></li> <li><code>.end() -&gt; Timestamp</code></li> <li><code>.duration() -&gt; String</code></li> </ul>"},{"location":"templates.html#treediff-type","title":"TreeDiff type","text":"<p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.files() -&gt; List&lt;TreeDiffEntry&gt;</code>: Changed files.</li> <li><code>.color_words([context: Integer]) -&gt; Template</code>: Format as a word-level diff   with changes indicated only by color.</li> <li><code>.git([context: Integer]) -&gt; Template</code>: Format as a Git diff.</li> <li><code>.stat([width: Integer]) -&gt; DiffStats</code>: Calculate stats of changed lines.</li> <li><code>.summary() -&gt; Template</code>: Format as a list of status code and path pairs.</li> </ul>"},{"location":"templates.html#treediffentry-type","title":"TreeDiffEntry type","text":"<p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.path() -&gt; RepoPath</code>: Path to the entry. If the entry is a copy/rename, this   points to the target (or right) entry.</li> <li><code>.status() -&gt; String</code>: One of <code>\"modified\"</code>, <code>\"added\"</code>, <code>\"removed\"</code>,   <code>\"copied\"</code>, or <code>\"renamed\"</code>.</li> <li><code>.source() -&gt; TreeEntry</code>: The source (or left) entry.</li> <li><code>.target() -&gt; TreeEntry</code>: The target (or right) entry.</li> </ul>"},{"location":"templates.html#treeentry-type","title":"TreeEntry type","text":"<p>This type cannot be printed. The following methods are defined.</p> <ul> <li><code>.path() -&gt; RepoPath</code>: Path to the entry.</li> <li><code>.conflict() -&gt; Boolean</code>: True if the entry is a merge conflict.</li> <li><code>.file_type() -&gt; String</code>: One of <code>\"file\"</code>, <code>\"symlink\"</code>, <code>\"tree\"</code>,   <code>\"git-submodule\"</code>, or <code>\"conflict\"</code>.</li> <li><code>.executable() -&gt; Boolean</code>: True if the entry is an executable file.</li> </ul>"},{"location":"templates.html#configuration","title":"Configuration","text":"<p>The default templates and aliases() are defined in the <code>[templates]</code> and <code>[template-aliases]</code> sections of the config respectively. The exact definitions can be seen in the <code>cli/src/config/templates.toml</code> file in jj's source tree.</p> <p>New keywords and functions can be defined as aliases, by using any combination of the predefined keywords/functions and other aliases.</p> <p>Alias functions can be overloaded by the number of parameters. However, builtin functions will be shadowed by name, and can't co-exist with aliases.</p> <p>For example:</p> <pre><code>[template-aliases]\n'commit_change_ids' = '''\nconcat(\n  format_field(\"Commit ID\", commit_id),\n  format_field(\"Change ID\", change_id),\n)\n'''\n'format_field(key, value)' = 'key ++ \": \" ++ value ++ \"\\n\"'\n</code></pre>"},{"location":"templates.html#examples","title":"Examples","text":"<p>Get short commit IDs of the working-copy parents:</p> <pre><code>jj log --no-graph -r @ -T 'parents.map(|c| c.commit_id().short()).join(\",\")'\n</code></pre> <p>Show machine-readable list of full commit and change IDs:</p> <pre><code>jj log --no-graph -T 'commit_id ++ \" \" ++ change_id ++ \"\\n\"'\n</code></pre>"},{"location":"testimonials.html","title":"Testimonials","text":"<p>You might not be ready to make the jump to Jujutsu yet. It's understandable; new tools come with new lessons, failures, and ideas to absorb. They require practice. In order to provide some motivation, we've collected a number of real, 100% authentic testimonials \u2014 from our loving users, our silly developers \u2014 all to tip the scales and get you on our side!</p>"},{"location":"testimonials.html#what-the-users-have-to-say","title":"What the users have to say","text":"<p>I've spent many years of my career working on version control. What I like most about Jujutsu is how it has non-obvious solutions to UX problems that we've run into in the past. What most people may not realize is that there are many novel features which all interlock to make it easy to use.</p> <p>For example, consider Jujutsu's support for automatically rebasing descendants of amended revisions. When we implemented that in Mercurial, we ran into an issue: what if there's a merge conflict? Our solution was to warn users and just not perform the auto-rebase. Now, suddenly, users have to understand that there can be old versions of the same revision visible in their log, and learn how to fix this state.</p> <p>In contrast, Jujutsu's solution is to simply make merge conflicts first-class. This is not just an improvement in general, it is also specifically an improvement for auto-rebase \u2014 users no longer have to learn about old versions of a revision unless they want to look at the obslog.</p> <p>Over and over, I'm struck by how well Jujutsu demonstrates this kind of evolved thinking, which as an experienced version control developer I deeply appreciate.</p> <p>\u2014 Rain, engineer at Oxide Computer Company, former VCS developer</p> <p>Jujutsu is amazing... I couldn't have come up with anything remotely as elegant.</p> <p>It's so rare that a solution attacks the innermost core of a problem so thoroughly, I genuinely feel blessed to be in its presence. And also a bit vindicated in not even trying to learn to use any of the tools that felt like more crutches stacked upon a sand castle</p> <p>\u2014 Anonymous user, speaking from the shadows</p> <p>It's the easiest time I've ever had learning a tool this deeply this quickly, because of the ability to experiment and undo, instead of triple-checking before trying a new scary command.</p> <p>\u2014 Scott Olson, advanced Git user and now a Jujutsu user</p> <p>I initially started to use Jujutsu for personal repos, and it has quickly gone from \"neat, let's try this more\" to \"very neat, added to my permanent config and automatically installed for new machines\".</p> <p>\u2014 Poliorcetics, on GitHub</p> <p>when i worked on the rust compiler, my job was to chain together a bunch of strange and cursed tools that broke often. jujutsu breaks about half as much, so that's pretty good i guess</p> <p>\u2014 jyn514, Rust contributor</p> <p>Jujutsu is pretty cool, you can even keep most of your existing workflows</p> <p>\u2014 Ben, who doesn't want you keeping your existing workflow</p> <p>Wait, it's not called Jujitsu?</p> <p>\u2014 Phil, Mercurial contributor (who doesn't have to learn Git, now that Jujutsu exists)</p> <p>When I heard about Jujutsu I decided to try it out before forming an opinion. Technically it never formed, because I haven't considered going back.</p> <p>\u2014 gul banana, computer programmer</p>"},{"location":"testimonials.html#what-the-developers-have-to-say","title":"What the developers have to say","text":"<p>I've been a FOSS contributor using Git for over 16 years, and Jujutsu continues to amaze me every day. It has that sweet simplicity I was fond of in Darcs, but it boils down all my most core and fundamental workflows \u2014 developed over years of experience \u2014 into a simple set of primitives. The internal design is simple and beautiful; it looks like a database, making the implementation elegant, safe, and extensible. All this, using the same Git repositories my coworkers use.</p> <p>It's like if you found out one day that you built your entire home on a vein of rich gold. Every day I seem to find new and beautiful emergent behaviors, all adding up to a tool that is greater than the sum of its parts.</p> <p>\u2014 Austin Seipp, \"No 1. Jujutsu Fan\"</p> <p>Honestly, I implemented signing support mostly for that sweet dopamine hit that you get from the green checkmark on GitHub. Yeah.</p> <p>\u2014 Anton Bulakh, contributor and dopamine enthusiast</p> <p>I'm sometimes still surprised that navigating with <code>jj next</code> and <code>jj prev</code> works.</p> <p>\u2014 Philip Metzger, author of <code>jj next</code> and <code>jj prev</code></p> <p>I'm surprised when it works.</p> <p>\u2014 Martin von Zweigbergk, project creator and leader</p>"},{"location":"testimonials.html#spread-the-word-yourself","title":"Spread the word yourself","text":"<p>Are you satisfied with Jujutsu? Ready to recommend it to a Jujillion of your friends and coworkers? Great! The easiest way to help the project grow is word of mouth. So make sure to talk to them about it and show off your hip new tool. Maybe post a link to it on your other favorite tool that you love using, Slack?</p> <p>If you're not sure what to say, we hired the cheapest marketing team we could find to design a list of Pre-Approved Endorsements in their laboratory. Just copy and paste these right into a text box! Shilling for an open source project has never been easier than this.</p> <p>Jujutsu is an alright tool. I guess.</p> <p>Jujutsu is my favorite software tool of all time. I am saying this for no particular reason, definitely not because I was paid to.</p> <p>I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu.</p>"},{"location":"tutorial.html","title":"Tutorial","text":"<p>Hint: This tutorial has become somewhat out of date. Many people find the alternative (not quite finished) tutorial by Steve Klabnik helpful.</p> <p>This text assumes that the reader is familiar with Git.</p>"},{"location":"tutorial.html#preparation","title":"Preparation","text":"<p>If you haven't already, make sure you install and configure Jujutsu.</p>"},{"location":"tutorial.html#cloning-a-git-repository","title":"Cloning a Git repository","text":"<p>Hint: Most identifiers used in this tutorial will be different when you try this at home!</p> <p>Let's start by cloning GitHub's Hello-World repo using <code>jj</code>:</p> <pre><code># Note the \"git\" before \"clone\" (there is no support for cloning native jj\n# repos yet)\n$ jj git clone https://github.com/octocat/Hello-World\nFetching into new repo in \"/tmp/tmp.O1DWMiaKd4/Hello-World\"\nbookmark: master@origin          [new] untracked\nbookmark: octocat-patch-1@origin [new] untracked\nbookmark: test@origin            [new] untracked\nSetting the revset alias \"trunk()\" to \"master@origin\"\nWorking copy now at: kntqzsqt d7439b06 (empty) (no description set)\nParent commit      : orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\nAdded 1 files, modified 0 files, removed 0 files\n$ cd Hello-World\n</code></pre> <p>Running <code>jj st</code> (short for <code>jj status</code>) now yields something like this:</p> <pre><code>$ jj st\nThe working copy is clean\nWorking copy : kntqzsqt d7439b06 (empty) (no description set)\nParent commit: orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\n</code></pre> <p>Let's look at that output as it introduces new concepts. You can see two commits: Parent and working copy. Both are identified using two separate identifiers: the \"change ID\" and the \"commit ID\".</p> <p>The parent commit, for example, has the change ID <code>orrkosyo</code> and the commit ID <code>7fd1a60b</code>.</p> <p>Git users: The commit ID/hash is what you're used to from Git and should match what you see when you look at the repository using <code>git log</code> in a Git checkout of the repository. The change ID however, is a new concept, unique to Jujutsu.</p> <p>We can also see from the output above that our working copy is an actual commit with a commit ID (<code>d7439b06</code> in the example). When you make a change in the working copy, the working-copy commit gets automatically amended by the next <code>jj</code> command.</p> <p>Git users: This is a huge difference from Git where the working copy is a separate concept and not yet a commit.</p>"},{"location":"tutorial.html#changes","title":"Changes","text":"<p>A change is a commit that can evolve while keeping a stable identifier (similar to Gerrit's Change-Id). In other words: You can make changes to files in a change, resulting in a new commit hash, but the change ID will remain the same.</p> <p>You can see that our clone operation automatically created a new change:</p> <pre><code>Working copy : kntqzsqt d7439b06 (empty) (no description set)\n</code></pre> <p>This new change has the ID <code>kntqzsqt</code> and it is currently empty (contains no changes compared to the parent) and has no description.</p>"},{"location":"tutorial.html#creating-our-first-change","title":"Creating our first change","text":"<p>Let's say we want to edit the <code>README</code> file in the repo to say \"Goodbye\" instead of \"Hello\". Start by describing the change (adding a commit message) so we don't forget what we're working on:</p> <pre><code># This brings up $EDITOR (or `pico` or `Notepad` by default).\n# Enter something like \"Say goodbye\" in the editor and then save the file and close\n# the editor.\n$ jj describe\nWorking copy now at: kntqzsqt e427edcf (empty) Say goodbye\nParent commit      : orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\n</code></pre> <p>Now make the change in the README:</p> <pre><code># Adjust as necessary for compatibility with your flavor of `sed`\n$ sed -i 's/Hello/Goodbye/' README\n$ jj st\nWorking copy changes:\nM README\nWorking copy : kntqzsqt 5d39e19d Say goodbye\nParent commit: orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\n</code></pre> <p>Note that you didn't have to tell Jujutsu to add the change like you would with <code>git add</code>. You actually don't even need to tell it when you add new files or remove existing files. To untrack a path, add it to your <code>.gitignore</code> and run <code>jj file untrack &lt;path&gt;</code>.</p> <p>Also note that the commit hash for our current change (<code>kntqzsqt</code>) changed from <code>e427edcf</code> to <code>5d39e19d</code>!</p> <p>To see the diff, run <code>jj diff</code>:</p> <pre><code>$ jj diff --git  # Feel free to skip the `--git` flag\ndiff --git a/README b/README\nindex 980a0d5f19...1ce3f81130 100644\n--- a/README\n+++ b/README\n@@ -1,1 +1,1 @@\n-Hello World!\n+Goodbye World!\n</code></pre> <p>Jujutsu's diff format currently defaults to inline coloring of the diff (like <code>git diff --color-words</code>), so we used <code>--git</code> above to make the diff readable in this tutorial.</p> <p>As you may have noticed, the working-copy commit's ID changed both when we edited the description and when we edited the README. However, the parent commit stayed the same. Each change to the working-copy commit amends the previous version. So how do we tell Jujutsu that we are done amending the current change and want to start working on a new one? That is what <code>jj new</code> is for. That will create a new commit on top of your current working-copy commit. The new commit is for the working-copy changes.</p> <p>So, let's say we're now done with this change, so we create a new change:</p> <pre><code>$ jj new\nWorking copy now at: mpqrykyp aef4df99 (empty) (no description set)\nParent commit      : kntqzsqt 5d39e19d Say goodbye\n$ jj st\nThe working copy is clean\nWorking copy : mpqrykyp aef4df99 (empty) (no description set)\nParent commit: kntqzsqt 5d39e19d Say goodbye\n</code></pre> <p>If we later realize that we want to make further changes, we can make them in the working copy and then run <code>jj squash</code>. That command squashes (moves) the changes from a given commit into its parent commit. Like most commands, it acts on the working-copy commit by default. When run on the working-copy commit, it behaves very similar to <code>git commit --amend</code>.</p> <p>Alternatively, we can use <code>jj edit &lt;commit&gt;</code> to resume editing a commit in the working copy. Any further changes in the working copy will then amend the commit. Whether you choose to create a new change and squash, or to edit, typically depends on how done you are with the change; if the change is almost done, it makes sense to use <code>jj new</code> so you can easily review your adjustments with <code>jj diff</code> before running <code>jj squash</code>.</p> <p>To view how a change has evolved over time, we can use <code>jj evolog</code> to see each recorded change for the current commit. This records changes to the working copy, message, squashes, rebases, etc.</p>"},{"location":"tutorial.html#the-log-command-and-revsets","title":"The log command and \"revsets\"","text":"<p>You're probably familiar with <code>git log</code>. Jujutsu has very similar functionality in its <code>jj log</code> command:</p> <pre><code>$ jj log\n@  mpqrykyp martinvonz@google.com 2023-02-12 15:00:22.000 -08:00 aef4df99\n\u2502  (empty) (no description set)\n\u25c9  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59.000 -08:00 5d39e19d\n\u2502  Say goodbye\n\u2502 \u25c9  tpstlust support+octocat@github.com 2018-05-10 12:55:19.000 -05:00 octocat-patch-1@origin b1b3f972\n\u251c\u2500\u256f  sentence case\n\u2502 \u25c9  kowxouwz octocat@nowhere.com 2014-06-10 15:22:26.000 -07:00 test@origin b3cbd5bb\n\u251c\u2500\u256f  Create CONTRIBUTING.md\n\u25c9  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50.000 -08:00 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>The <code>@</code> indicates the working-copy commit. The first ID on a line (e.g. \"mpqrykyp\" above) is the change ID. The second ID is the commit ID. You can give either ID to commands that take revisions as arguments. We will generally prefer change IDs because they stay the same when the commit is rewritten.</p> <p>By default, <code>jj log</code> lists your local commits, with some remote commits added for context. The <code>~</code> indicates that the commit has parents that are not included in the graph. We can use the <code>--revisions</code>/<code>-r</code> flag to select a different set of revisions to list. The flag accepts a \"revset\", which is an expression in a simple language for specifying revisions. For example, <code>@</code> refers to the working-copy commit, <code>root()</code> refers to the root commit, <code>bookmarks()</code> refers to all commits pointed to by bookmarks (similar to Git's branches). We can combine expressions with <code>|</code> for union, <code>&amp;</code> for intersection and <code>~</code> for difference. For example:</p> <pre><code>$ jj log -r '@ | root() | bookmarks()'\n@  mpqrykyp martinvonz@google.com 2023-02-12 15:00:22.000 -08:00 aef4df99\n\u2577  (empty) (no description set)\n\u25c9  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50.000 -08:00 master 7fd1a60b\n\u2577  (empty) Merge pull request #6 from Spaceghost/patch-1\n\u25c9  zzzzzzzz root() 00000000\n</code></pre> <p>The <code>00000000</code> commit (change ID <code>zzzzzzzz</code>) is a virtual commit that's called the \"root commit\". It's the root commit of every repo. The <code>root()</code> function in the revset matches it.</p> <p>There are also operators for getting the parents (<code>foo-</code>), children (<code>foo+</code>), ancestors (<code>::foo</code>), descendants (<code>foo::</code>), DAG range (<code>foo::bar</code>, like <code>git log --ancestry-path</code>), range (<code>foo..bar</code>, same as Git's). See the revset documentation for all revset operators and functions.</p> <p>Hint: If the default <code>jj log</code> omits some commits you expect to see, you can always run <code>jj log -r ::</code> (or, equivalently, <code>jj log -r 'all()'</code>) to see all the commits.</p>"},{"location":"tutorial.html#conflicts","title":"Conflicts","text":"<p>Now let's see how Jujutsu deals with merge conflicts. We'll start by making some commits. We use <code>jj new</code> with the <code>--message</code>/<code>-m</code> option to set change descriptions (commit messages) right away.</p> <pre><code># Start creating a chain of commits off of the `master` bookmark\n$ jj new master -m A; echo a &gt; file1\nWorking copy now at: nuvyytnq 00a2aeed (empty) A\nParent commit      : orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\nAdded 0 files, modified 1 files, removed 0 files\n$ jj new -m B1; echo b1 &gt; file1\nWorking copy now at: ovknlmro 967d9f9f (empty) B1\nParent commit      : nuvyytnq 5dda2f09 A\n$ jj new -m B2; echo b2 &gt; file1\nWorking copy now at: puqltutt 8ebeaffa (empty) B2\nParent commit      : ovknlmro 7d7c6e6b B1\n$ jj new -m C; echo c &gt; file2\nWorking copy now at: qzvqqupx 62a3c6d3 (empty) C\nParent commit      : puqltutt daa6ffd5 B2\n$ jj log\n@  qzvqqupx martinvonz@google.com 2023-02-12 15:07:41.946 -08:00 2370ddf3\n\u2502  C\n\u25c9  puqltutt martinvonz@google.com 2023-02-12 15:07:33.000 -08:00 daa6ffd5\n\u2502  B2\n\u25c9  ovknlmro martinvonz@google.com 2023-02-12 15:07:24.000 -08:00 7d7c6e6b\n\u2502  B1\n\u25c9  nuvyytnq martinvonz@google.com 2023-02-12 15:07:05.000 -08:00 5dda2f09\n\u2502  A\n\u2502 \u25c9  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59.000 -08:00 5d39e19d\n\u251c\u2500\u256f  Say goodbye\n\u2502 \u25c9  tpstlust support+octocat@github.com 2018-05-10 12:55:19.000 -05:00 octocat-patch-1@origin b1b3f972\n\u251c\u2500\u256f  sentence case\n\u2502 \u25c9  kowxouwz octocat@nowhere.com 2014-06-10 15:22:26.000 -07:00 test@origin b3cbd5bb\n\u251c\u2500\u256f  Create CONTRIBUTING.md\n\u25c9  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50.000 -08:00 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>We now have a few commits, where A, B1, and B2 modify the same file, while C modifies a different file. Let's now rebase B2 directly onto A. We use the <code>--source</code>/<code>-s</code> option on the change ID of B2, and <code>--destination</code>/<code>-d</code> option on A.</p> <pre><code>$ jj rebase -s puqltutt -d nuvyytnq  # Replace the IDs by what you have for B2 and A\nRebased 2 commits\nWorking copy now at: qzvqqupx 1978b534 (conflict) C\nParent commit      : puqltutt f7fb5943 (conflict) B2\nAdded 0 files, modified 1 files, removed 0 files\nThere are unresolved conflicts at these paths:\nfile1    2-sided conflict\nNew conflicts appeared in these commits:\n  qzvqqupx 1978b534 (conflict) C\n  puqltutt f7fb5943 (conflict) B2\nTo resolve the conflicts, start by updating to the first one:\n  jj new puqltuttzvly\nThen use `jj resolve`, or edit the conflict markers in the file directly.\nOnce the conflicts are resolved, you may want to inspect the result with `jj diff`.\nThen run `jj squash` to move the resolution into the conflicted commit.\n\n$ jj log\n@  qzvqqupx martinvonz@google.com 2023-02-12 15:08:33.000 -08:00 1978b534 conflict\n\u2502  C\n\u25c9  puqltutt martinvonz@google.com 2023-02-12 15:08:33.000 -08:00 f7fb5943 conflict\n\u2502  B2\n\u2502 \u25c9  ovknlmro martinvonz@google.com 2023-02-12 15:07:24.000 -08:00 7d7c6e6b\n\u251c\u2500\u256f  B1\n\u25c9  nuvyytnq martinvonz@google.com 2023-02-12 15:07:05.000 -08:00 5dda2f09\n\u2502  A\n\u2502 \u25c9  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59.000 -08:00 5d39e19d\n\u251c\u2500\u256f  Say goodbye\n\u2502 \u25c9  tpstlust support+octocat@github.com 2018-05-10 12:55:19.000 -05:00 octocat-patch-1@origin b1b3f972\n\u251c\u2500\u256f  sentence case\n\u2502 \u25c9  kowxouwz octocat@nowhere.com 2014-06-10 15:22:26.000 -07:00 test@origin b3cbd5bb\n\u251c\u2500\u256f  Create CONTRIBUTING.md\n\u25c9  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50.000 -08:00 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>There are several things worth noting here. First, the <code>jj rebase</code> command said \"Rebased 2 commits\". That's because we asked it to rebase commit B2 with the <code>-s</code> option, which also rebases descendants (commit C in this case). Second, because B2 modified the same file (and word) as B1, rebasing it resulted in conflicts, as the output indicates. Third, the conflicts did not prevent the rebase from completing successfully, nor did it prevent C from getting rebased on top.</p> <p>Now let's resolve the conflict in B2. We'll do that by creating a new commit on top of B2. Once we've resolved the conflict, we'll squash the conflict resolution into the conflicted B2. That might look like this:</p> <pre><code>$ jj new puqltutt  # Replace the ID by what you have for B2\nWorking copy now at: zxoosnnp c7068d1c (conflict) (empty) (no description set)\nParent commit      : puqltutt f7fb5943 (conflict) B2\nAdded 0 files, modified 0 files, removed 1 files\nThere are unresolved conflicts at these paths:\nfile1    2-sided conflict\n\n$ jj st\nThe working copy is clean\nThere are unresolved conflicts at these paths:\nfile1    2-sided conflict\nWorking copy : zxoosnnp c7068d1c (conflict) (empty) (no description set)\nParent commit: puqltutt f7fb5943 (conflict) B2\nTo resolve the conflicts, start by updating to it:\n  jj new puqltutt\nThen use `jj resolve`, or edit the conflict markers in the file directly.\nOnce the conflicts are resolved, you may want to inspect the result with `jj diff`.\nThen run `jj squash` to move the resolution into the conflicted commit.\n\n$ cat file1\n&lt;&lt;&lt;&lt;&lt;&lt;&lt; Conflict 1 of 1\n%%%%%%% Changes from base to side #1\n-b1\n+a\n+++++++ Contents of side #2\nb2\n&gt;&gt;&gt;&gt;&gt;&gt;&gt; Conflict 1 of 1 ends\n\n$ echo resolved &gt; file1\n\n$ jj st\nWorking copy changes:\nM file1\nWorking copy : zxoosnnp c2a31a06 (no description set)\nParent commit: puqltutt f7fb5943 (conflict) B2\nConflict in parent commit has been resolved in working copy\n\n$ jj squash\nRebased 1 descendant commits\nWorking copy now at: ntxxqymr e3c279cc (empty) (no description set)\nParent commit      : puqltutt 2c7a658e B2\nExisting conflicts were resolved or abandoned from these commits:\n  qzvqqupx hidden 1978b534 (conflict) C\n  puqltutt hidden f7fb5943 (conflict) B2\n\n$ jj log\n@  ntxxqymr martinvonz@google.com 2023-02-12 19:34:09.000 -08:00 e3c279cc\n\u2502  (empty) (no description set)\n\u2502 \u25c9  qzvqqupx martinvonz@google.com 2023-02-12 19:34:09.000 -08:00 b9da9d28\n\u251c\u2500\u256f  C\n\u25c9  puqltutt martinvonz@google.com 2023-02-12 19:34:09.000 -08:00 2c7a658e\n\u2502  B2\n\u2502 \u25c9  ovknlmro martinvonz@google.com 2023-02-12 15:07:24.000 -08:00 7d7c6e6b\n\u251c\u2500\u256f  B1\n\u25c9  nuvyytnq martinvonz@google.com 2023-02-12 15:07:05.000 -08:00 5dda2f09\n\u2502  A\n\u2502 \u25c9  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59.000 -08:00 5d39e19d\n\u251c\u2500\u256f  Say goodbye\n\u2502 \u25c9  tpstlust support+octocat@github.com 2018-05-10 12:55:19.000 -05:00 octocat-patch-1@origin b1b3f972\n\u251c\u2500\u256f  sentence case\n\u2502 \u25c9  kowxouwz octocat@nowhere.com 2014-06-10 15:22:26.000 -07:00 test@origin b3cbd5bb\n\u251c\u2500\u256f  Create CONTRIBUTING.md\n\u25c9  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50.000 -08:00 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>Note that commit C automatically got rebased on top of the resolved B2, and that C is also resolved (since it modified only a different file).</p> <p>By the way, if we want to get rid of B1 now, we can run <code>jj abandon ovknlmro</code>. That will hide the commit from the log output and will rebase any descendants to its parent.</p>"},{"location":"tutorial.html#the-operation-log","title":"The operation log","text":"<p>Jujutsu keeps a record of all changes you've made to the repo in what's called the \"operation log\". Use the <code>jj op</code> (short for <code>jj operation</code>) family of commands to interact with it. To list the operations, use <code>jj op log</code>:</p> <pre><code>$ jj op log\n@  d3b77addea49 martinvonz@vonz.svl.corp.google.com 3 minutes ago, lasted 3 milliseconds\n\u2502  squash commit 63874fe6c4fba405ffc38b0dd926f03b715cf7ef\n\u2502  args: jj squash\n\u25c9  6fc1873c1180 martinvonz@vonz.svl.corp.google.com 3 minutes ago, lasted 1 milliseconds\n\u2502  snapshot working copy\n\u2502  args: jj squash\n\u25c9  ed91f7bcc1fb martinvonz@vonz.svl.corp.google.com 6 minutes ago, lasted 1 milliseconds\n\u2502  new empty commit\n\u2502  args: jj new puqltutt\n\u25c9  367400773f87 martinvonz@vonz.svl.corp.google.com 12 minutes ago, lasted 3 milliseconds\n\u2502  rebase commit daa6ffd5a09a8a7d09a65796194e69b7ed0a566d and descendants\n\u2502  args: jj rebase -s puqltutt -d nuvyytnq\n[many more lines]\n</code></pre> <p>The most useful command is <code>jj undo</code> (alias for <code>jj op undo</code>), which will undo an operation. By default, it will undo the most recent operation. Let's try it:</p> <pre><code>$ jj undo\nNew conflicts appeared in these commits:\n  qzvqqupx 1978b534 (conflict) C\n  puqltutt f7fb5943 (conflict) B2\nTo resolve the conflicts, start by updating to the first one:\n  jj new puqltuttzvly\nThen use `jj resolve`, or edit the conflict markers in the file directly.\nOnce the conflicts are resolved, you may want to inspect the result with `jj diff`.\nThen run `jj squash` to move the resolution into the conflicted commit.\nWorking copy now at: zxoosnnp 63874fe6 (no description set)\nParent commit      : puqltutt f7fb5943 (conflict) B2\n\n$ jj log\n@  zxoosnnp martinvonz@google.com 2023-02-12 19:34:09.000 -08:00 63874fe6\n\u2502  (no description set)\n\u2502 \u25c9  qzvqqupx martinvonz@google.com 2023-02-12 15:08:33.000 -08:00 1978b534 conflict\n\u251c\u2500\u256f  C\n\u25c9  puqltutt martinvonz@google.com 2023-02-12 15:08:33.000 -08:00 f7fb5943 conflict\n\u2502  B2\n\u2502 \u25c9  ovknlmro martinvonz@google.com 2023-02-12 15:07:24.000 -08:00 7d7c6e6b\n\u251c\u2500\u256f  B1\n\u25c9  nuvyytnq martinvonz@google.com 2023-02-12 15:07:05.000 -08:00 5dda2f09\n\u2502  A\n\u2502 \u25c9  kntqzsqt martinvonz@google.com 2023-02-12 14:56:59.000 -08:00 5d39e19d\n\u251c\u2500\u256f  Say goodbye\n\u2502 \u25c9  tpstlust support+octocat@github.com 2018-05-10 12:55:19.000 -05:00 octocat-patch-1@origin b1b3f972\n\u251c\u2500\u256f  sentence case\n\u2502 \u25c9  kowxouwz octocat@nowhere.com 2014-06-10 15:22:26.000 -07:00 test@origin b3cbd5bb\n\u251c\u2500\u256f  Create CONTRIBUTING.md\n\u25c9  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50.000 -08:00 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>As you can perhaps see, that undid the <code>jj squash</code> invocation we used for squashing the conflict resolution into commit B2 earlier. Notice that it also updated the working copy.</p> <p>You can also view the repo the way it looked after some earlier operation. For example, if you want to see <code>jj log</code> output right after the <code>jj rebase</code> operation, try <code>jj log --at-op=367400773f87</code> but use the hash from your own <code>jj op log</code>.</p>"},{"location":"tutorial.html#moving-content-changes-between-commits","title":"Moving content changes between commits","text":"<p>You have already seen how <code>jj squash</code> can combine the changes from two commits into one. There are several other commands for changing the contents of existing commits.</p> <p>We'll need some more complex content to test these commands, so let's create a few more commits:</p> <pre><code>$ jj new master -m abc; printf 'a\\nb\\nc\\n' &gt; file\nWorking copy now at: ztqrpvnw f94e49cf (empty) abc\nParent commit      : orrkosyo 7fd1a60b master | (empty) Merge pull request #6 from Spaceghost/patch-1\nAdded 0 files, modified 0 files, removed 1 files\n\n$ jj new -m ABC; printf 'A\\nB\\nc\\n' &gt; file\nWorking copy now at: kwtuwqnm 6f30cd1f (empty) ABC\nParent commit      : ztqrpvnw 51002261 ab\n\n$ jj new -m ABCD; printf 'A\\nB\\nC\\nD\\n' &gt; file\nWorking copy now at: mrxqplyk a6749154 (empty) ABCD\nParent commit      : kwtuwqnm 30aecc08 ABC\n\n$ jj log -r master::@\n@  mrxqplyk martinvonz@google.com 2023-02-12 19:38:21.000 -08:00 b98c607b\n\u2502  ABCD\n\u25c9  kwtuwqnm martinvonz@google.com 2023-02-12 19:38:12.000 -08:00 30aecc08\n\u2502  ABC\n\u25c9  ztqrpvnw martinvonz@google.com 2023-02-12 19:38:03.000 -08:00 51002261\n\u2502  abc\n\u25c9  orrkosyo octocat@nowhere.com 2012-03-06 15:06:50.000 -08:00 master 7fd1a60b\n\u2502  (empty) Merge pull request #6 from Spaceghost/patch-1\n~\n</code></pre> <p>We \"forgot\" to capitalize \"c\" in the second commit when we capitalized the other letters. We then fixed that in the third commit when we also added \"D\". It would be cleaner to move the capitalization of \"c\" into the second commit. We can do that by running <code>jj squash</code> with the <code>--interactive</code>/<code>-i</code> option on the third commit. Remember that <code>jj squash</code> moves all the changes from one commit into its parent. <code>jj squash -i</code> moves only part of the changes into its parent. Now try that:</p> <pre><code>$ jj squash -i\nHint: Using default editor ':builtin'; run `jj config set --user ui.diff-editor :builtin` to disable this message.\nRebased 1 descendant commits\nWorking copy now at: mrxqplyk 52a6c7fd ABCD\nParent commit      : kwtuwqnm 643061ac ABC\n</code></pre> <p>That will bring up the built-in diff editor<sup>1</sup> with a diff of the changes in the \"ABCD\" commit. Expand the file by clicking on <code>(+)</code> or with right arrow, then select the sections/line to include by clicking or using space. Once complete, press <code>c</code> to confirm changes, or <code>q</code> to exit without saving. You can also use the mouse to click on the menu items to see more options (keyboard navigation is currently limited).</p> <p>If we look at the diff of the second commit, we now see that all three lines got capitalized:</p> <pre><code>$ jj diff -r @- --git\ndiff --git a/file b/file\nindex de980441c3..b1e67221af 100644\n--- a/file\n+++ b/file\n@@ -1,3 +1,3 @@\n-a\n-b\n-c\n+A\n+B\n+C\n</code></pre> <p>The child change (\"ABCD\" in our case) will have the same content state after the <code>jj squash</code> command. That means that you can move any changes you want into the parent change, even if they touch the same word, and it won't cause any conflicts.</p> <p>Let's try one final command for changing the contents of an exiting commit. That command is <code>jj diffedit</code>, which lets you edit the changes in a commit without checking it out.</p> <pre><code>$ jj diffedit -r @-\nHint: Using default editor ':builtin'; run `jj config set --user ui.diff-editor :builtin` to disable this message.\nCreated kwtuwqnm 70985eaa (empty) ABC\nRebased 1 descendant commits\nWorking copy now at: mrxqplyk 1c72cd50 (conflict) ABCD\nParent commit      : kwtuwqnm 70985eaa (empty) ABC\nAdded 0 files, modified 1 files, removed 0 files\nThere are unresolved conflicts at these paths:\nfile    2-sided conflict\nNew conflicts appeared in these commits:\n  mrxqplyk 1c72cd50 (conflict) ABCD\nTo resolve the conflicts, start by updating to it:\n  jj new mrxqplykmyqv\nThen use `jj resolve`, or edit the conflict markers in the file directly.\nOnce the conflicts are resolved, you may want to inspect the result with `jj diff`.\nThen run `jj squash` to move the resolution into the conflicted commit.\n</code></pre> <p>In the diff editor, use the arrow keys and spacebar to select all lines but the last. Press 'c' to save the changes and close it. You can now inspect the rewritten commit with <code>jj diff -r @-</code> again, and you should see your deletion of the last line. Unlike <code>jj squash -i</code>, which left the content state of the commit unchanged, <code>jj diffedit</code> (typically) results in a different state, which means that descendant commits may have conflicts.</p> <p>Another command for rewriting contents of existing commits is <code>jj split</code>. Now that you've seen how <code>jj squash -i</code> and <code>jj diffedit</code> work, you can hopefully figure out how it works (with the help of the instructions in the diff).</p> <ol> <li> <p>There are many other diff editors you could use. For example, if you have Meld installed and in the PATH, you can use it via <code>jj squash -i --tool meld</code> or a fancier config with <code>jj squash -i --tool meld-3</code>. You can configure the default with the <code>ui.diff-editor</code> option; those docs also explain how to specify a path to an executable if it is not in the PATH.\u00a0\u21a9</p> </li> </ol>"},{"location":"windows.html","title":"Working on Windows","text":"<p>Jujutsu works the same on all platforms, but there are some caveats that Windows users should be aware of.</p>"},{"location":"windows.html#line-endings-are-not-converted","title":"Line endings are not converted","text":"<p>Jujutsu does not currently honor <code>.gitattributes</code> and does not have a setting like Git's <code>core.autocrlf</code>. This means that line endings will be checked out exactly as they are committed and committed exactly as authored. This is true on all platforms, but Windows users are most likely to miss CRLF conversion.</p> <p>Your Git repository may expect Windows users to have <code>core.autocrlf</code> set to <code>true</code>, so that files are checked out with line endings converted from LF to CRLF but committed with line endings converted from CRLF back to LF. Jujutsu doesn't understand this and preserves CRLF line endings in files when committing.</p> <p>After creating a colocated repository on Windows, you most likely want to set <code>core.autocrlf</code> to <code>input</code>, then <code>jj abandon</code> to convert all files on disk to LF line endings:</p> <pre><code>PS&gt; git config core.autocrlf input\n\n# Abandoning the working copy will cause Jujutsu to overwrite all files with\n# CRLF line endings with the line endings they are committed with, probably LF\nPS&gt; jj abandon\n</code></pre> <p>This setting ensures Git will check out files with LF line endings without converting them to CRLF. You'll want to make sure any tooling you use, especially IDEs, preserve LF line endings.</p>"},{"location":"windows.html#pagination","title":"Pagination","text":"<p>On Windows, <code>jj</code> will use its integrated pager called <code>streampager</code> by default, unless the environment variable <code>%PAGER%</code> or the config <code>ui.pager</code> is explicitly set. See the pager section of the config docs for more details.</p> <p>If the built-in pager doesn't meet your needs and you have Git installed, you can switch to using Git's pager as follows:</p> <pre><code>PS&gt; jj config set --user ui.pager '[\"C:\\\\Program Files\\\\Git\\\\usr\\\\bin\\\\less.exe\", \"-FRX\"]'\nPS&gt; jj config set --user ui.paginate auto\n</code></pre>"},{"location":"windows.html#typing-in-powershell","title":"Typing <code>@</code> in PowerShell","text":"<p>PowerShell uses <code>@</code> as part the array sub-expression operator, so it often needs to be escaped or quoted in commands:</p> <pre><code>PS&gt; jj log -r `@\nPS&gt; jj log -r '@'\n</code></pre> <p>One solution is to create a revset alias. For example, to make <code>HEAD</code> an alias for <code>@</code>:</p> <pre><code>PS&gt; jj config set --user revset-aliases.HEAD '@'\nPS&gt; jj log -r HEAD\n</code></pre>"},{"location":"windows.html#wsl-sets-the-execute-bit-on-all-files","title":"WSL sets the execute bit on all files","text":"<p>When viewing a Windows drive from WSL (via /mnt/c or a similar path), Windows exposes all files with the execute bit set. Since Jujutsu automatically records changes to the working copy, this sets the execute bit on all files committed in your repository.</p> <p>If you only need to access the repository in WSL, the best solution is to clone the repository in the Linux file system (for example, in <code>~/my-repo</code>).</p> <p>If you need to use the repository in both WSL and Windows, one solution is to create a workspace in the Linux file system:</p> <pre><code>PS&gt; jj workspace add --name wsl ~/my-repo\n</code></pre> <p>Then only use the <code>~/my-repo</code> workspace from Linux.</p>"},{"location":"windows.html#symbolic-link-support","title":"Symbolic link support","text":"<p><code>jj</code> supports symlinks on Windows only when they are enabled by the operating system. This requires Windows 10 version 14972 or higher, as well as Developer Mode. If those conditions are not satisfied, <code>jj</code> will materialize symlinks as ordinary files.</p> <p>For colocated repositories, Git support must also be enabled using the <code>git config</code> option <code>core.symlinks=true</code>.</p>"},{"location":"working-copy.html","title":"Working copy","text":""},{"location":"working-copy.html#introduction","title":"Introduction","text":"<p>The working copy is where the current working-copy commit's files are written so you can interact with them. It is also where files are read from in order to create new commits (though there are many other ways of creating new commits).</p> <p>Unlike most other VCSs, Jujutsu will automatically create commits from the working-copy contents when they have changed. Most <code>jj</code> commands you run will commit the working-copy changes if they have changed. The resulting revision will replace the previous working-copy revision.</p> <p>Also unlike most other VCSs, added files are implicitly tracked by default. That means that if you add a new file to the working copy, it will be automatically committed once you run e.g. <code>jj st</code>. Similarly, if you remove a file from the working copy, it will implicitly be untracked.</p> <p>The <code>snapshot.auto-track</code> config option controls which paths get automatically tracked when they're added to the working copy. See the fileset documentation for the syntax. Files with paths matching ignore files are never tracked automatically.</p> <p>You can use <code>jj file untrack</code> to untrack a file while keeping it in the working copy. However, first ignore them or remove them from the <code>snapshot.auto-track</code> patterns; otherwise they will be immediately tracked again.</p>"},{"location":"working-copy.html#conflicts","title":"Conflicts","text":"<p>When you check out a commit with conflicts, those conflicts need to be represented in the working copy somehow. However, the file system doesn't understand conflicts. Jujutsu's solution is to add conflict markers to conflicted files when it writes them to the working copy. It also keeps track of the (typically 3) different parts involved in the conflict. Whenever it scans the working copy thereafter, it parses the conflict markers and recreates the conflict state from them. You can resolve conflicts by replacing the conflict markers by the resolved text. You don't need to resolve all conflicts at once. You can even resolve part of a conflict by updating the different parts of the conflict marker.</p> <p>To resolve conflicts in a commit, use <code>jj new &lt;commit&gt;</code> to create a working-copy commit on top. You would then have the same conflicts in the working-copy commit. Once you have resolved the conflicts, you can inspect the conflict resolutions with <code>jj diff</code>. Then run <code>jj squash</code> to move the conflict resolutions into the conflicted commit. Alternatively, you can edit the commit with conflicts directly in the working copy by using <code>jj edit &lt;commit&gt;</code>. The main disadvantage of that is that it's harder to inspect the conflict resolutions.</p> <p>With the <code>jj resolve</code> command, you can use an external merge tool to resolve conflicts that have 2 sides and a base.  There is not yet a good way of resolving conflicts between directories, files, and symlinks (https://github.com/jj-vcs/jj/issues/19). You can use <code>jj restore</code> to choose one side of the conflict, but there's no way to even see where the involved parts came from.</p>"},{"location":"working-copy.html#ignored-files","title":"Ignored files","text":"<p>You probably don't want build outputs and temporary files to be under version control. You can tell Jujutsu to not automatically track certain files by using <code>.gitignore</code> files (there's no such thing as <code>.jjignore</code> yet). See https://git-scm.com/docs/gitignore for details about the format. <code>.gitignore</code> files are supported in any directory in the working copy, as well as in <code>$XDG_CONFIG_HOME/git/ignore</code> and <code>$GIT_DIR/info/exclude</code>.</p> <p>Ignored files are never tracked automatically (regardless of the value of <code>snapshot.auto-track</code>), but they can still end up being tracked for a few reasons:</p> <ul> <li>if they were tracked in the parent commit</li> <li>because of an explicit <code>jj file track</code> command</li> </ul> <p>You can untrack such files with the <code>jj file untrack</code> command.</p>"},{"location":"working-copy.html#workspaces","title":"Workspaces","text":"<p>You can have multiple working copies backed by a single repo. Use <code>jj workspace add</code> to create a new working copy. The working copy will have a <code>.jj/</code> directory linked to the main repo. The working copy and the <code>.jj/</code> directory together is called a \"workspace\". Each workspace can have a different commit checked out.</p> <p>Having multiple workspaces can be useful for running long-running tests in a one while you continue developing in another, for example. If needed, <code>jj workspace root</code> prints the root path of the current workspace.</p> <p>When you're done using a workspace, use <code>jj workspace forget</code> to make the repo forget about it. The files can be deleted from disk separately (either before or after).</p>"},{"location":"working-copy.html#stale-working-copy","title":"Stale working copy","text":"<p>Almost all commands go through three main steps:</p> <ol> <li>Snapshot the working copy (which gets recorded as an operation)</li> <li>Create new commits etc. \"in memory\" and record that as a new operation</li> <li>Update the working copy to match the new operation, i.e. to the commit that    the operation says that <code>@</code> should point to</li> </ol> <p>If step 3 doesn't happen for some reason, the working copy is considered \"stale\". We can detect that because the working copy (<code>.jj/working_copy/</code>) keeps track of which operation it was last updated to. When the working copy is stale, use <code>jj workspace update-stale</code> to update the files in the working copy.</p> <p>A common reason that step 3 doesn't happen for a working copy is that you rewrote the commit from another workspace. When you modify workspace A's working-copy commit from workspace B, workspace A's working copy will become stale.</p> <p>A working copy can also become stale because some error, such as <code>^C</code> prevented step 3 from completing. It's also possible that it was successfully updated in step 3 but the operation has then been lost (e.g. by <code>jj op abandon</code> or \"spontaneously\" by certain storage backends). If the operation has been lost, then <code>jj workspace update-stale</code> will create a recovery commit with the contents of the working copy but parented to the current operation's working-copy commit.</p>"},{"location":"design/copy-tracking.html","title":"Copy Tracking and Tracing Design","text":"<p>Authors: Daniel Ploch</p> <p>Summary: This Document documents an approach to tracking and detecting copy information in jj repos, in a way that is compatible with both Git's detection model and with custom backends that have more complicated tracking of copy information. This design affects the output of diff commands as well as the results of rebasing across remote copies.</p>"},{"location":"design/copy-tracking.html#objective","title":"Objective","text":"<p>Implement extensible APIs for recording and retrieving copy info for the purposes of diffing and rebasing across renames and copies more accurately. This should be performant both for Git, which synthesizes copy info on the fly between arbitrary trees, and for custom extensions which may explicitly record and re-serve copy info over arbitrarily large commit ranges.</p> <p>The APIs should be defined in a way that makes it easy for custom backends to ignore copy info entirely until they are ready to implement it.</p>"},{"location":"design/copy-tracking.html#interface-design","title":"Interface Design","text":""},{"location":"design/copy-tracking.html#read-api","title":"Read API","text":"<p>Copy information will be served both by a new Backend trait method described below, as well as a new field on Commit objects for backends that support copy tracking:</p> <pre><code>/// An individual copy source.\npub struct CopySource {\n    /// The source path a target was copied from.\n    ///\n    /// It is not required that the source path is different than the target\n    /// path. A custom backend may choose to represent 'rollbacks' as copies\n    /// from a file unto itself, from a specific prior commit.\n    path: RepoPathBuf,\n    file: FileId,\n    /// The source commit the target was copied from. If not specified, then the\n    /// parent of the target commit is the source commit. Backends may use this\n    /// field to implement 'integration' logic, where a source may be\n    /// periodically merged into a target, similar to a branch, but the\n    /// branching occurs at the file level rather than the repository level. It\n    /// also follows naturally that any copy source targeted to a specific\n    /// commit should avoid copy propagation on rebasing, which is desirable\n    /// for 'fork' style copies.\n    ///\n    /// If specified, it is required that the commit id is an ancestor of the\n    /// commit with which this copy source is associated.\n    commit: Option&lt;CommitId&gt;,\n}\n\npub enum CopySources {\n    Resolved(CopySource),\n    Conflict(HashSet&lt;CopySource&gt;),\n}\n\n/// An individual copy event, from file A -&gt; B.\npub struct CopyRecord {\n    /// The destination of the copy, B.\n    target: RepoPathBuf,\n    /// The CommitId where the copy took place.\n    id: CommitId,\n    /// The source of the copy, A.\n    sources: CopySources,\n}\n\n/// Backend options for fetching copy records.\npub struct CopyRecordOpts {\n    // TODO: Probably something for git similarity detection\n}\n\npub type CopyRecordStream = BoxStream&lt;BackendResult&lt;CopyRecord&gt;&gt;;\n\npub trait Backend {\n    /// Get all copy records for `paths` in the dag range `roots..heads`.\n    ///\n    /// The exact order these are returned is unspecified, but it is guaranteed\n    /// to be reverse-topological. That is, for any two copy records with\n    /// different commit ids A and B, if A is an ancestor of B, A is streamed\n    /// after B.\n    ///\n    /// Streaming by design to better support large backends which may have very\n    /// large single-file histories. This also allows more iterative algorithms\n    /// like blame/annotate to short-circuit after a point without wasting\n    /// unnecessary resources.\n    async fn get_copy_records(&amp;self, paths: &amp;[RepoPathBuf], roots: &amp;[CommitId], heads: &amp;[CommitId]) -&gt; CopyRecordStream;\n}\n</code></pre> <p>Obtaining copy records for a single commit requires first computing the files list for that commit, then calling get_copy_records with <code>heads = [id]</code> and <code>roots = parents()</code>. This enables commands like <code>jj diff</code> to produce better diffs that take copy sources into account.</p>"},{"location":"design/copy-tracking.html#write-api","title":"Write API","text":"<p>Backends that support tracking copy records at the commit level will do so through a new field on <code>backend::Commit</code> objects:</p> <pre><code>pub struct Commit {\n    ...\n    copies: Option&lt;HashMap&lt;RepoPathBuf, CopySources&gt;&gt;,\n}\n\npub trait Backend {\n    /// Whether this backend supports storing explicit copy records on write.\n    fn supports_copy_tracking(&amp;self) -&gt; bool;\n}\n</code></pre> <p>This field will be ignored by backends that do not support copy tracking, and always set to <code>None</code> when read from such backends. Backends that do support copy tracking are required to preserve the field value always.</p> <p>This API will enable the creation of new <code>jj</code> commands for recording copies:</p> <pre><code>jj cp $SRC $DEST [OPTIONS]\njj mv $SRC $DEST [OPTIONS]\n</code></pre> <p>These commands will rewrite the target commit to reflect the given move/copy instructions in its tree, as well as recording the rewrites on the Commit object itself for backends that support it (for backends that do not, these copy records will be silently discarded).</p> <p>Flags for the first two commands will include:</p> <pre><code>-r/--revision\n    perform the copy or move at the specified revision\n    defaults to the working copy commit if unspecified\n-f\n    force overwrite the destination path\n--after\n    record the copy retroactively, without modifying the targeted commit tree\n--resolve\n    overwrite all previous copy intents for this $DEST\n--allow-ignore-copy\n    don't error if the backend doesn't support copy tracking\n--from REV\n    specify a commit id for the copy source that isn't the parent commit\n</code></pre> <p>For backends which do not support copy tracking, it will be an error to use <code>--after</code>, since this has no effect on anything and the user should know that. The <code>supports_copy_tracking()</code> trait method is used to determine this.</p> <p>An additional command is provided to deliberately discard copy info for a destination path, possibly as a means of resolving a conflict.</p> <pre><code>jj forget-cp $DEST [-r REV]\n</code></pre>"},{"location":"design/copy-tracking.html#behavioral-changes","title":"Behavioral Changes","text":""},{"location":"design/copy-tracking.html#rebase-changes","title":"Rebase Changes","text":"<p>In general, we want to support the following use cases:</p> <ul> <li>A rebase of an edited file A across a rename of A-&gt;B should transparently move the edits to B.</li> <li>A rebase of an edited file A across a copy from A-&gt;B should optionally copy the edits to B. A configuration option should be defined to enable/disable this behavior.</li> <li>TODO: Others?</li> </ul> <p>Using the aforementioned copy tracing API, both of these should be feasible. A detailed approach to a specific edge case is detailed in the next section.</p>"},{"location":"design/copy-tracking.html#rename-of-an-added-file","title":"Rename of an added file","text":"<p>A well known and thorny problem in Mercurial occurs in the following scenario:</p> <ol> <li>Create a new file A</li> <li>Create new commits on top that make changes to file A</li> <li>Whoops, I should rename file A to B. Do so, amend the first commit.</li> <li>Because the first commit created file A, there is no rename to record; it's changing to a commit that instead creates file B.</li> <li>All child commits get sad on evolve</li> </ol> <p>In jj, we have an opportunity to fix this because all rebasing occurs atomically and transactionally within memory. The exact implementation of this is yet to be determined, but conceptually the following should produce desirable results:</p> <ol> <li>Rebase commit A from parents [B] to parents [C]</li> <li>Get copy records from [D]-&gt;[B] and [D]-&gt;[C], where [D] are the common ancestors of [B] and [C]</li> <li>DescendantRebaser maintains an in-memory map of commits to extra copy info, which it may inject into (2). When squashing a rename of a newly created file into the commit that creates that file, DescendentRebase will return this rename for all rebases of descendants of the newly modified commit. The rename lives ephemerally in memory and has no persistence after the rebase completes.</li> <li>A to-be-determined algorithm diffs the copy records between [D]-&gt;[B] and [D]-&gt;[C] in order to make changes to the rebased commit. This results in edits to renamed files being propagated to those renamed files, and avoiding conflicts on the deletion of their sources. A copy/move may also be undone in this way; abandoning a commit which renames A-&gt;B should move all descendant edits of B back into A.</li> </ol>"},{"location":"design/copy-tracking.html#conflicts","title":"Conflicts","text":"<p>With copy-tracking, a whole new class of conflicts become possible. These need to be well-defined and have well documented resolution paths. Because copy info in a commit is keyed by destination, conflicts can only occur at the destination of a copy, not at a source (that's called forking).</p>"},{"location":"design/copy-tracking.html#split-conflicts","title":"Split conflicts","text":"<p>Suppose we create commit A by renaming file F1 -&gt; F2, then we split A. What happens to the copy info? I argue that this is straightforward:</p> <ul> <li>If F2 is preserved at all in the parent commit, the copy info stays on the parent commit.</li> <li>Otherwise, the copy info goes onto the child commit.</li> </ul> <p>Things get a little messier if A also modifies F1, and this modification is separated from the copy, but I think this is messy only in an academic sense and the user gets a sane result either way. If they want to separate the modification from the copy while still putting it in an earlier commit, they can express this intent after with <code>jj cp --after --from</code>.</p>"},{"location":"design/copy-tracking.html#merge-commit-conflicts","title":"Merge commit conflicts","text":"<p>Suppose we create commit A by renaming file F1 -&gt; F, then we create a sibling commit B by renaming file F2 -&gt; F. What happens when we create a merge commit with parents A and B?</p> <p>In terms of copy info there is no conflict here, because C does not have copy info and needs none, but resolving the contents of F becomes more complicated. We need to (1) identify the greatest common ancestor of A and B (D) (which we do anyway), and (2) invoke <code>get_copy_records()</code> on F for each of <code>D::A</code> and <code>D::B</code> to identify the 'real' source file id for each parent. If these are the same, then we can use that as the base for a better 3-way merge. Otherwise, we must treat it as an add+add conflict where the base is the empty file id.</p> <p>It is possible that F1 and F2 both came from a common source file G, but that these copies precede D. In such case, we will not produce as good of a merge resolution as we theoretically could, but (1) this seems extremely niche and unlikely, and (2) we cannot reasonably achieve this without implementing some analogue of Mercurial's linknodes concept, and it would be nice to avoid that additional complexity.</p>"},{"location":"design/copy-tracking.html#squash-conflicts","title":"Squash conflicts","text":"<p>Suppose we create commit A by renaming file F1 -&gt; F, then we create child commit B in which we replace F by renaming F2 -&gt; F. This touches on two issues.</p> <p>Firstly, if these two commits are squashed together, then we have a destination F with two copy sources, F1 and F2. In this case, we can store a <code>CopySources::Conflict([F1, F2])</code> as the copy source for F, and treat this commit as 'conflicted' in <code>jj log</code>. <code>jj status</code> will need modification to show this conflicted state, and <code>jj resolve</code> will need some way of handling the conflicted copy sources (possibly printing them in some structured text form, and using the user's merge tool to resolve them). Alternatively, the user can 'resolve directly' by running <code>jj cp --after --resolve</code> with the desired copy info.</p> <p>Secondly, who is to say that commit B is 'replacing' F at all? In some version control systems, it is possible to 'integrate' a file X into an existing file Y, by e.g. propagating changes in X since its previous 'integrate' into Y, without erasing Y's prior history in that moment for the purpose of archaeology. With the commit metadata currently defined, it is not possible to distinguish between a 'replacement' operation and an 'integrate' operation.</p>"},{"location":"design/copy-tracking.html#track-replacements-explicitly","title":"Track replacements explicitly","text":"<p>One solution is to add a <code>destructive: bool</code> field or similar to the <code>CopySource</code> struct, to explicitly distinguish between these two types of copy records. It then becomes possible to record a non-destructive copy using <code>--after</code> to recognize that a file F was 'merged into' its destination, which can be useful in handling parallel edits of F that later sync this information.</p>"},{"location":"design/copy-tracking.html#always-assume-replacement","title":"Always assume replacement","text":"<p>Alternatively, we can keep copy-tracking simple in jj by taking a stronger stance here and treating all copies-onto-existing-files as 'replacement' operations. This makes integrations with more complex VCSs that do support 'integrate'-style operations trickier, but it is possible that a more generic commit extension system is better suited to such backends.</p>"},{"location":"design/copy-tracking.html#future-changes","title":"Future Changes","text":"<p>An implementation of <code>jj blame</code> or <code>jj annotate</code> does not currently exist, but when it does we'll definitely want it to be copy-tracing aware to provide better annotations for users doing archaeology. The Read APIs provided are expected to be sufficient for these use cases.</p>"},{"location":"design/copy-tracking.html#non-goals","title":"Non-goals","text":""},{"location":"design/copy-tracking.html#tracking-copies-in-git","title":"Tracking copies in Git","text":"<p>Git uses rename detection rather than copy tracking, generating copy info on the fly between two arbitrary trees. It does not have any place for explicit copy info that exchanges with other users of the same git repo, so any enhancements jj adds here would be local only and could potentially introduce confusion when collaborating with other users.</p>"},{"location":"design/copy-tracking.html#directory-copiesmoves","title":"Directory copies/moves","text":"<p>All copy/move information will be read and written at the file level. While <code>jj cp|mv</code> may accept directory paths as a convenience and perform the appropriate tree modification operations, the renames will be recorded at the file level, one for each copied/moved file.</p>"},{"location":"design/git-submodule-storage.html","title":"Git submodule storage","text":""},{"location":"design/git-submodule-storage.html#objective","title":"Objective","text":"<p>Decide what approach(es) to Git submodule storage we should pursue. The decision will be recorded in ./git-submodules.md.</p>"},{"location":"design/git-submodule-storage.html#use-cases-to-consider","title":"Use cases to consider","text":"<p>The submodule storage format should support the workflows specified in the submodules roadmap. It should be obvious how \"Phase 1\" requirements will be supported, and we should have an idea of how \"Phases 2,3,X\" might be supported.</p> <p>Notable use cases and workflows are noted below.</p>"},{"location":"design/git-submodule-storage.html#fetching-submodule-commits","title":"Fetching submodule commits","text":"<p>Git's protocol is designed for communicating between copies of the same repository. Notably, a Git fetch calculates the list of required objects by performing reachability checks between the refs on the local and the remote side. We should expect that this will only work well if the submodule repository is stored as a local Git repository.</p> <p>Rolling our own Git fetch is too complex to be worth the effort.</p>"},{"location":"design/git-submodule-storage.html#jj-op-restore-and-operation-log-format","title":"\"jj op restore\" and operation log format","text":"<p>We want <code>jj op restore</code> to restore to an \"expected\" state in the submodule. There is a potential distinction between running <code>jj op restore</code> in the superproject vs in the submodule, and the expected behavior may be different in each case, e.g. in the superproject, it might be enough to restore the submodule working copy, but in the submodule, refs also need to be restored.</p> <p>Currently, the operation log only references objects and refs in the superproject, so it is likely that proposed approaches will need to extend this format. It is also worth considering that submodules may be added, updated or removed in superproject commits, thus the list of submodules is likely to change over the repository's lifetime.</p>"},{"location":"design/git-submodule-storage.html#nested-submodules","title":"Nested submodules","text":"<p>Git submodules may contain submodules themselves, so our chosen storage schemes should support that.</p> <p>We should consider limiting the recursion depth to avoid nasty edge cases (e.g. cyclical submodules.) that might surprise users.</p>"},{"location":"design/git-submodule-storage.html#supporting-future-extensions","title":"Supporting future extensions","text":"<p>There are certain extensions we may want to make in the future, but we don't have a timeline for them today. Proposed approaches should take these extensions into account (e.g. the approach should be theoretically extensible), but a full proposal for implementing them is not necessary.</p> <p>These extensions are:</p> <ul> <li>Non-git subrepos</li> <li>Colocated Git repos</li> <li>The superproject using a non-git backend</li> </ul>"},{"location":"design/git-submodule-storage.html#proposed-design","title":"Proposed design","text":"<p>Git submodules will be stored as full jj repos. In the code, jj commands will only interact with the submodule's repo as an entire unit, e.g. it cannot query the submodule's commit backend directly. A well-abstracted submodule will extend well to non-git backends and non-git subrepos.</p> <p>The main challenge with this approach is that the submodule repo can be in a state that is internally valid (when considering only the submodule's repo), but invalid when considering the superproject-submodule system. This will be managed by requiring all submodule interactions go through the superproject so that superproject-submodule coordination can occur. For example, jj will not allow the user to work on the submodule's repo without going through the superproject (unlike Git).</p> <p>The notable workflows could be addressed like so:</p>"},{"location":"design/git-submodule-storage.html#fetching-submodule-commits_1","title":"Fetching submodule commits","text":"<p>The submodule would fetch using the equivalent of <code>jj git fetch</code>. It remains to be decided how a \"recursive\" fetch should work, especially if a newly fetched superproject commit references an unfetched submodule commit. A reasonable approximation would be to fetch all branches in the submodule, and then, if the submodule commit is still missing, gracefully handle it.</p>"},{"location":"design/git-submodule-storage.html#jj-op-restore-and-operation-log-format_1","title":"\"jj op restore\" and operation log format","text":"<p>As full repos, each submodule will have its own operation log. We will continue to use the existing operation log format, where each operation log tracks their own repo's commits. As commands are run in the superproject, corresponding commands will be run in the submodule as necessary, e.g. checking out a superproject commit will cause a submodule commit to also be checked out.</p> <p>Since there is no association between a superproject operation and a submodule operation, <code>jj op restore</code> in the superproject will not restore the submodule to a previous operation. Instead, the appropriate submodule operation(s) will be created. This is sufficient to preserve the superproject-submodule relationship; it precludes \"recursive\" restore (e.g. restoring branches in the superproject and submodules) but it seems unlikely that we will need such a thing.</p>"},{"location":"design/git-submodule-storage.html#nested-submodules_1","title":"Nested submodules","text":"<p>Since submodules are full repos, they can contain submodules themselves. Nesting is unlikely to complicate any of the core features, since the top-level superproject/submodule relationship is almost identical to the submodule/nested submodule relationship.</p>"},{"location":"design/git-submodule-storage.html#extending-to-colocated-git-repos","title":"Extending to colocated Git repos","text":"<p>Git expects submodules to be in <code>.git/modules</code>, so it will not understand this storage format. To support colocated Git repos, we will have to change Git to allow a submodule's gitdir to be in an alternate location (e.g. we could add a new <code>submodule.&lt;name&gt;.gitdir</code> config option). This is a simple change, so it should be feasible.</p>"},{"location":"design/git-submodule-storage.html#alternatives-considered","title":"Alternatives considered","text":""},{"location":"design/git-submodule-storage.html#git-repos-in-the-main-git-backend","title":"Git repos in the main Git backend","text":"<p>Since the Git backend contains a Git repository, an 'obvious' default would be to store them in the Git superproject the same way Git does, i.e. in <code>.git/modules</code>. Since Git submodules are full repositories that can have submodules, this storage scheme naturally extends to nested submodules.</p> <p>Most of the work in storing submodules and querying them would be well-isolated to the Git backend, which gives us a lot of flexibility to make changes without affecting the rest of jj. However, the operation log will need a significant rework since it isn't designed to reference submodules, and handling edge cases (e.g. a submodule being added/removed, nested submodules) will be tricky.</p> <p>This is rejected because handling that operation log complexity isn't worth it when very little of the work extends to non-Git backends.</p>"},{"location":"design/git-submodule-storage.html#store-git-submodules-as-alternate-git-backends","title":"Store Git submodules as alternate Git backends","text":"<p>Teach jj to use multiple commit backends and store Git submodules as Git backends. Since submodules are separate from the 'main' backend, a repository can use whatever backend it wants as its 'main' one, while still having Git submodules in the 'alternate' Git backends.</p> <p>This approach extends fairly well to non-Git submodules (which would be stored in non-Git commit backends). However, this requires significantly reworking the operation log to account for multiple commit backends. It is also not clear how nested submodules will be supported since there isn't an obvious way to represent a nested submodule's relationship to its superproject.</p>"},{"location":"design/git-submodules.html","title":"Git submodules","text":"<p>This is an aspirational document that describes how jj will support Git submodules. Readers are assumed to have some familiarity with Git and Git submodules.</p> <p>This document is a work in progress; submodules are a big feature, and relevant details will be filled in incrementally.</p>"},{"location":"design/git-submodules.html#objective","title":"Objective","text":"<p>This proposal aims to replicate the workflows users are used to with Git submodules, e.g.:</p> <ul> <li>Cloning submodules</li> <li>Making new submodule commits and updating the superproject</li> <li>Fetching and pushing updates to the submodule's remote</li> <li>Viewing submodule history</li> </ul> <p>When it is convenient, this proposal will also aim to make submodules easier to use than Git's implementation.</p>"},{"location":"design/git-submodules.html#non-goals","title":"Non-goals","text":"<ul> <li>Non-Git 'submodules' (e.g. native jj submodules, other VCSes)</li> <li>Non-Git backends (e.g. Google internal backend)</li> <li>Changing how Git submodules are implemented in Git</li> </ul>"},{"location":"design/git-submodules.html#background","title":"Background","text":"<p>We mainly want to support Git submodules for feature parity, since Git submodules are a standard feature in Git and are popular enough that we have received user requests for them. Secondarily (and distantly so), Git submodules are notoriously difficult to use, so there is an opportunity to improve the UX over Git's implementation.</p>"},{"location":"design/git-submodules.html#intro-to-git-submodules","title":"Intro to Git Submodules","text":"<p>Git submodules are a feature of Git that allow a repository (submodule) to be embedded inside another repository (the superproject). Notably, a submodule is a full repository, complete with its own index, object store and ref store. It can be interacted with like any other repository, regardless of the superproject.</p> <p>In a superproject commit, submodule information is captured in two places:</p> <ul> <li> <p>A <code>gitlink</code> entry in the commit's tree, where the value of the <code>gitlink</code> entry   is the submodule commit id. This tells Git what to populate in the working   tree.</p> </li> <li> <p>A top level <code>.gitmodules</code> file. This file is in Git's config syntax and   entries take the form <code>submodule.&lt;submodule-name&gt;.*</code>. These include many   settings about the submodules, but most importantly:</p> <ul> <li> <p><code>submodule&lt;submodule-name&gt;.path</code> contains the path from the root of the tree   to the <code>gitlink</code> being described.</p> </li> <li> <p><code>submodule&lt;submodule-name&gt;.url</code> contains the url to clone the submodule   from.</p> </li> </ul> </li> </ul> <p>In the working tree, Git notices the presence of a submodule by the <code>.git</code> entry (signifying the root of a Git repository working tree). This is either the submodule's actual Git directory (an \"old-form\" submodule), or a <code>.git</code> file pointing to <code>&lt;superproject-git-directory&gt;/modules/&lt;submodule-name&gt;</code>. The latter is sometimes called the \"absorbed form\", and is Git's preferred mode of operation.</p>"},{"location":"design/git-submodules.html#roadmap","title":"Roadmap","text":"<p>Git submodules should be implemented in an order that supports an increasing set of workflows, with the goal of getting feedback early and often. When support is incomplete, jj should not crash, but instead provide fallback behavior and warn the user where needed.</p> <p>The goal is to land good support for pure Jujutsu repositories, while colocated repositories will be supported when convenient.</p> <p>This section should be treated as a set of guidelines, not a strict order of work.</p>"},{"location":"design/git-submodules.html#phase-1-readonly-submodules","title":"Phase 1: Readonly submodules","text":"<p>This includes work that inspects submodule contents but does not create new objects in the submodule. This requires a way to store submodules in a jj repository that supports readonly operations.</p>"},{"location":"design/git-submodules.html#outcomes","title":"Outcomes","text":"<ul> <li>Submodules can be cloned anew</li> <li>New submodule commits can be fetched</li> <li>Submodule history and branches can be viewed</li> <li>Submodule contents are populated in the working copy</li> <li>Superproject gitlink can be updated to an existing submodule commit</li> <li>Conflicts in the superproject gitlink can be resolved to an existing submodule   commit</li> </ul>"},{"location":"design/git-submodules.html#phase-2-snapshotting-new-changes","title":"Phase 2: Snapshotting new changes","text":"<p>This allows a user to write new contents to a submodule and its remote.</p>"},{"location":"design/git-submodules.html#outcomes_1","title":"Outcomes","text":"<ul> <li>Changes in the working copy can be recorded in a submodule commit</li> <li>Submodule branches can be modified</li> <li>Submodules and their branches can be pushed to their remote</li> </ul>"},{"location":"design/git-submodules.html#phase-3-mergingrebasingconflicts","title":"Phase 3: Merging/rebasing/conflicts","text":"<p>This allows merging and rebasing of superproject commits in a content-aware way (in contrast to Git, where only the gitlink commit ids are compared), as well as workflows that make resolving conflicts easy and sensible.</p> <p>This can be done in tandem with Phase 2, but will likely require a significant amount of design work on its own.</p>"},{"location":"design/git-submodules.html#outcomes_2","title":"Outcomes","text":"<ul> <li>Merged/rebased submodules result in merged/rebased working copy content</li> <li>Merged/rebased working copy content can be committed, possibly by creating   sensible merged/rebased submodule commits</li> <li>Merge/rebase between submodule and non-submodule gives a sensible result</li> <li>Merge/rebase between submodule A and submodule B gives a sensible result</li> </ul>"},{"location":"design/git-submodules.html#phase-an-ideal-world","title":"Phase ?: An ideal world","text":"<p>I.e. outcomes we would like to see if there were no constraints whatsoever.</p> <ul> <li>Rewriting submodule commits rewrites descendants correctly and updates   superproject gitlinks.</li> <li>Submodule conflicts automatically resolve to the 'correct' submodule commits,   e.g. a merge between superproject commits creating a merge of the submodule   commits.</li> <li>Nested submodules are as easy to work with as non-nested submodules.</li> <li>The operation log captures changes in the submodule.</li> </ul>"},{"location":"design/git-submodules.html#design","title":"Design","text":""},{"location":"design/git-submodules.html#guiding-principles","title":"Guiding principles","text":"<p>TODO</p>"},{"location":"design/git-submodules.html#storing-submodules","title":"Storing submodules","text":"<p>Possible approaches under discussion. See ./git-submodule-storage.md.</p>"},{"location":"design/git-submodules.html#snapshotting-new-submodule-changes","title":"Snapshotting new submodule changes","text":"<p>TODO</p>"},{"location":"design/git-submodules.html#mergingrebasing-with-submodules","title":"Merging/rebasing with submodules","text":"<p>TODO</p>"},{"location":"design/run.html","title":"Introducing JJ run","text":"<p>Authors: Philip Metzger, Martin von Zweigberk, Danny Hooper, Waleed Khan</p> <p>Initial Version, 10.12.2022 (view full history here)</p> <p>Summary: This Document documents the design of a new <code>run</code> command for Jujutsu which will be used to seamlessly integrate with build systems, linters and formatters. This is achieved by running a user-provided command or script across multiple revisions. For more details, read the Use-Cases of jj run.</p>"},{"location":"design/run.html#preface","title":"Preface","text":"<p>The goal of this Design Document is to specify the correct behavior of <code>jj run</code>. The points we decide on here I (Philip Metzger) will try to implement. There exists some prior work in other DVCS:</p> <ul> <li><code>git test</code>: part of git-branchless. Similar to this proposal for <code>jj run</code>.</li> <li><code>hg run</code>: Google's internal Mercurial extension. Similar to this proposal for <code>jj run</code>. Details not available.</li> <li><code>hg fix</code>: Google's open source Mercurial extension: source code. A more specialized approach to rewriting file content without full context of the working directory.</li> <li><code>git rebase -x</code>: runs commands opportunistically as part of rebase.</li> <li><code>git bisect run</code>: run a command to determine which commit introduced a bug.</li> </ul>"},{"location":"design/run.html#context-and-scope","title":"Context and Scope","text":"<p>The initial need for some kind of command runner integrated in the VCS, surfaced in a github discussion. In a discussion on discord about the git-hook model, there was consensus about not repeating their mistakes.</p> <p>For <code>jj run</code> there is prior art in Mercurial, git branchless and Google's internal Mercurial. Currently git-branchless <code>git test</code> and <code>hg fix</code> implement some kind of command runner. The Google internal <code>hg run</code> works in conjunction with CitC (Clients in the Cloud) which allows it to lazily apply the current command to any affected file. Currently no Jujutsu backend (Git, Native) has a fancy virtual filesystem supporting it, so we can't apply this optimization. We could do the same once we have an implementation of the working copy based on a virtual file system. Until then, we have to run the commands in regular local-disk working copies.</p>"},{"location":"design/run.html#goals-and-non-goals","title":"Goals and Non-Goals","text":""},{"location":"design/run.html#goals","title":"Goals","text":"<ul> <li>We should be able to apply the command to any revision, published or unpublished.</li> <li>We should be able to parallelize running the actual command, while preserving a good console output.</li> <li>The run command should be able to work in any commit, the working-copy commit itself or any other commit.</li> <li>There should exist some way to signal hard failure.</li> <li>The command should build enough infrastructure for <code>jj test</code>, <code>jj fix</code> and <code>jj format</code>.</li> <li>The main goal is to be good enough, as we can always expand the functionality in the future.</li> </ul>"},{"location":"design/run.html#non-goals","title":"Non-Goals","text":"<ul> <li>While we should build a base for <code>jj test</code>, <code>jj format</code> and <code>jj fix</code>, we shouldn't mash their use-cases into <code>jj run</code>.</li> <li>The command shouldn't be too smart, as too many assumptions about workflows makes the command confusing for users.</li> <li>The smart caching of outputs, as user input commands can be unpredictable. makes the command confusing for users.</li> <li>Avoid the smart caching of outputs, as user input commands can be unpredictable.</li> <li>Fine grained user facing configuration, as it's unwarranted complexity.</li> <li>A <code>fix</code> subcommand as it cuts too much design space.</li> </ul>"},{"location":"design/run.html#use-cases-of-jj-run","title":"Use-Cases of jj run","text":"<p>Linting and Formatting:</p> <ul> <li><code>jj run 'pre-commit run' -r $revset</code></li> <li><code>jj run 'cargo clippy' -r $revset</code></li> <li><code>jj run 'cargo +nightly fmt'</code></li> </ul> <p>Large scale changes across repositories, local and remote:</p> <ul> <li><code>jj run 'sed /some/test/' -r 'mine() &amp; ~remote_bookmarks(exact:\"origin\")'</code></li> <li><code>jj run '$rewrite-tool' -r '$revset'</code></li> </ul> <p>Build systems:</p> <ul> <li><code>jj run 'bazel build //some/target:somewhere'</code></li> <li><code>jj run 'ninja check-lld'</code></li> </ul> <p>Some of these use-cases should get a specialized command, as this allows further optimization. A command could be <code>jj format</code>, which runs a list of formatters over a subset of a file in a revision. Another command could be <code>jj fix</code>, which runs a command like <code>rustfmt --fix</code> or <code>cargo clippy --fix</code> over a subset of a file in a revision.</p>"},{"location":"design/run.html#design","title":"Design","text":""},{"location":"design/run.html#base-design","title":"Base Design","text":"<p>All the work will be done in the <code>.jj/</code> directory. This allows us to hide all complexity from the users, while preserving the user's current workspace.</p> <p>We will copy the approach from git-branchless's <code>git test</code> of creating a temporary working copy for each parallel command. The working copies will be reused between <code>jj run</code> invocations. They will also be reused within <code>jj run</code> invocation if there are more commits to run on than there are parallel jobs.</p> <p>We will leave ignored files in the temporary directory between runs. That enables incremental builds (e.g. by letting cargo reuse its <code>target/</code> directory). However, it also means that runs potentially become less reproducible. We will provide a flag for removing ignored files from the temporary working copies to address that.</p> <p>Another problem with leaving ignored files in the temporary directories is that they take up space. That is especially problematic in the case of cargo (the <code>target/</code> directory often takes up tens of GBs). The same flag for cleaning up ignored files can be used to address that. We may want to also have a flag for cleaning up temporary working copies after running the command.</p> <p>An early version of the command will directly use Treestate to to manage the temporary working copies. That means that running <code>jj</code> inside the temporary working copies will not work . We can later extend that to use a full Workspace. To prevent operations in the working copies from impacting the repo, we can use a separate OpHeadsStore for it.</p>"},{"location":"design/run.html#modifying-the-working-copy","title":"Modifying the Working Copy","text":"<p>Since the subprocesses will run in temporary working copies, they won't interfere with the user's working copy. The user can therefore continue to work in it while <code>jj run</code> is running.</p> <p>We want subprocesses to be able to make changes to the repo by updating their assigned working copy. Let's say the user runs <code>jj run</code> on just commits A and B, where B's parent is A. Any changes made on top of A would be squashed into A, forming A'. Similarly B' would be formed by squasing it into B. We can then either do a normal rebase of B' onto A', or we can simply update its parent to A'. The former is useful, e.g. when the subprocess only makes a partial update of the tree based on the parent commit. In addition to these two modes, we may want to have an option to ignore any changes made in the subprocess's working copy.</p>"},{"location":"design/run.html#modifying-the-repo","title":"Modifying the Repo","text":"<p>Once we give the subprocess access to a fork of the repo via separate OpHeadsStore, it will be able to create new operations in its fork. If the user runs <code>jj run -r foo</code> and the subprocess checks out another commit, it's not clear what that should do. We should probably just verify that the working-copy commit's parents are unchanged after the subprocess returns. Any operations created by the subprocess will be ignored.</p>"},{"location":"design/run.html#rewriting-the-revisions","title":"Rewriting the revisions","text":"<p>Like all commands, <code>jj run</code> will refuse to rewrite public/immutable commits. For private/unpublished revisions, we either amend or reparent the changes, which are available as command options.</p>"},{"location":"design/run.html#execution-orderparallelism","title":"Execution order/parallelism","text":"<p>It may be useful to execute commands in topological order. For example, commands with costs proportional to incremental changes, like build systems. There may also be other relevant heuristics, but topological order is an easy and effective way to start.</p> <p>Parallel execution of commands on different commits may choose to schedule commits to still reduce incremental changes in the working copy used by each execution slot/\"thread\". However, running the command on all commits concurrently should be possible if desired.</p> <p>Executing commands in topological order allows for more meaningful use of any potential features that stop execution \"at the first failure\". For example, when running tests on a chain of commits, it might be useful to proceed in topological/chronological order, and stop on the first failure, because it might imply that the remaining executions will be undesirable because they will also fail.</p>"},{"location":"design/run.html#dealing-with-failure","title":"Dealing with failure","text":"<p>It will be useful to have multiple strategies to deal with failures on a single or multiple revisions. The reason for these strategies is to allow customized conflict handling. These strategies then can be exposed in the ui with a matching option.</p> <p>Continue: If any subprocess fails, we will continue the work on child revisions. Notify the user on exit about the failed revisions.</p> <p>Stop: Signal a fatal failure and cancel any scheduled work that has not yet started running, but let any already started subprocess finish. Notify the user about the failed command and display the generated error from the subprocess.</p> <p>Fatal: Signal a fatal failure and immediately stop processing and kill any running processes. Notify the user that we failed to apply the command to the specific revision.</p> <p>We will leave any affected commit in its current state, if any subprocess fails. This allows us to provide a better user experience, as leaving revisions in an undesirable state, e.g partially formatted, may confuse users.</p>"},{"location":"design/run.html#resource-constraints","title":"Resource constraints","text":"<p>It will be useful to constrain the execution to prevent resource exhaustion. Relevant resources could include:</p> <ul> <li>CPU and memory available on the machine running the commands. <code>jj run</code> can provide some simple mitigations like limiting parallelism to \"number of CPUs\" by default, and limiting parallelism by dividing \"available memory\" by some estimate or measurement of per-invocation memory use of the commands.</li> <li>External resources that are not immediately known to jj. For example, commands run in parallel may wish to limit the total number of connections to a server. We might choose to defer any handling of this to the implementation of the command being invoked, instead of trying to communicate that information to jj.</li> </ul>"},{"location":"design/run.html#command-options","title":"Command Options","text":"<p>The base command of any jj command should be usable. By default <code>jj run</code> works on the <code>@</code> the current working copy.</p> <ul> <li>--command, explicit name of the first argument</li> <li>-x, for git compatibility (may alias another command)</li> <li>-j, --jobs, the amount of parallelism to use</li> <li>-k, --keep-going, continue on failure (may alias another command)</li> <li>--show, display the diff for an affected revision</li> <li>--dry-run, do the command execution without doing any work, logging all intended files and arguments</li> <li>--rebase, rebase all parents on the consulitng diff (may alias another command)</li> <li>--reparent, change the parent of an effected revision to the new change (may alias another command)</li> <li>--clean, remove existing workspaces and remove the ignored files</li> <li>--readonly, ignore changes across multiple run invocations</li> <li>--error-strategy=<code>continue|stop|fatal</code>, see Dealing with failure</li> </ul>"},{"location":"design/run.html#integrating-with-other-commands","title":"Integrating with other commands","text":"<p><code>jj log</code>: No special handling needed <code>jj diff</code>: No special handling needed <code>jj st</code>: For now reprint the final output of <code>jj run</code> <code>jj op log</code>: No special handling needed, but awaits further discussion in #963 <code>jj undo/jj op undo</code>: No special handling needed</p>"},{"location":"design/run.html#open-points","title":"Open Points","text":"<p>Should the command be working copy backend specific? How do we manage the Processes which the command will spawn? Configuration options, User and Repository Wide?</p>"},{"location":"design/run.html#future-possibilities","title":"Future possibilities","text":"<ul> <li>We could rewrite the file in memory, which is a neat optimization</li> <li>Exposing some internal state, to allow preciser resource constraints</li> <li>Integration options for virtual filesystems, which allow them to cache the needed working copies.</li> <li>A Jujutsu wide concept for a cached working copy, as they could be expensive to materialize.</li> <li>Customized failure messages, this maybe useful for bots, it could be similar to Bazel's <code>select(..., message = \"arch not supported for $project\")</code>.</li> <li>Make <code>jj run</code> asynchronous by spawning a <code>main</code> process, directly return to the user and incrementally updating the output of <code>jj st</code>.</li> </ul>"},{"location":"design/sparse-v2.html","title":"Sparse Patterns v2 redesign","text":"<p>Authors: Daniel Ploch</p> <p>Summary: This Document documents a redesign of the sparse command and it's internal storage format in jj, in order to facilitate several desirable improvements for large repos. It covers both the migration path and the planned end state.</p>"},{"location":"design/sparse-v2.html#objective","title":"Objective","text":"<p>Redesign Sparse Patterns to accommodate more advanced features for native and custom implementations. This includes three main goals:</p> <ol> <li>Sparse Patterns should be versioned with the working copy</li> <li>Sparse Patterns should support more flexible matching rules</li> <li>Sparse Patterns should support client path remapping</li> </ol>"},{"location":"design/sparse-v2.html#current-state-as-of-jj-0130","title":"Current State (as of jj 0.13.0)","text":"<p>Sparse patterns are an effectively unordered list of prefix strings:</p> <pre><code>path/one\npath/to/dir/two\n</code></pre> <p>The set of files identified by the Sparse Patterns is all paths which match any provided prefix. This governs what gets materialized in the working copy on checkout, and what is updated on snapshot. The set is stored in working copy state files which are not versioned in the Op Store.</p> <p>Because all paths are bare strings with no escaping or higher-level formatting, the current design makes it difficult to add new features like exclusions or path remappings.</p>"},{"location":"design/sparse-v2.html#proposed-state-sparse-patterns-v2","title":"Proposed State (Sparse Patterns v2)","text":"<p>Sparse Patterns v2 will be stored as objects in the Op Store, referenced by a <code>WorkingCopyPatternsId</code> from the active <code>View</code>. They will have a new, ordered structure which can fully represent previous patterns.</p> <pre><code>/// Analogues of RepoPath, specifically describing paths in the working copy.\nstruct WorkingCopyPathBuf {\n    String\n}\nstruct WorkingCopyPath {\n    str\n}\n\npub enum SparsePatternsPathType {\n    Dir,    // Everything under &lt;path&gt;/...\n    Files,  // Files under &lt;path&gt;/*\n    Exact,  // &lt;path&gt; exactly\n}\n\npub struct SparsePatternsPath {\n    path_type: SparsePatternsPathType,\n    include: bool,  // True if included, false if excluded.\n    path: RepoPathBuf,\n}\n\npub struct WorkingCopyMapping {\n    src_path: RepoPathBuf,\n    dst_path: WorkingCopyPathBuf,\n    recursive: bool,  // If false, only immediate children of src_path (files) are renamed.\n}\n\npub struct WorkingCopyPatterns {\n    sparse_paths: Vec&lt;SparsePatternsPath&gt;,\n    mappings: Vec&lt;WorkingCopyMapping&gt;,\n}\n\npub trait OpStore {\n    ...\n    pub fn read_working_copy_patterns(&amp;self, id: &amp;WorkingCopyPatternsId) -&gt; OpStoreResult&lt;WorkingCopyPatterns&gt; { ... }\n    pub fn write_working_copy_patterns(&amp;self, sparse_patterns: &amp;WorkingCopyPatterns) -&gt; OpStoreResult&lt;WorkingCopyPatternsId&gt; { .. }\n}\n</code></pre> <p>To support these more complex behaviors, a new <code>WorkingCopyPatterns</code> trait will be introduced, initially only as a thin wrapper around the existing prefix format, but soon to be expanded with richer types and functionality.</p> <pre><code>impl WorkingCopyPatterns {\n    pub fn to_matcher(&amp;self) -&gt; Box&lt;dyn Matcher&gt; {\n        ...\n    }\n\n    ...\n}\n</code></pre>"},{"location":"design/sparse-v2.html#command-syntax","title":"Command Syntax","text":"<p><code>SparsePatternsPath</code> rules can be specified on the CLI and in an editor via a compact syntax:</p> <pre><code>(include|exclude):(dir|files|exact):&lt;path&gt;\n</code></pre> <p>If both prefix terms are omitted, then <code>include:dir:</code> is assumed. If any prefix is specified, both must be specified. The editor and CLI will both accept path rules in either format going forward.</p> <ul> <li><code>jj sparse set --add foo/bar</code> is equal to <code>jj sparse set --add include:dir:foo/bar</code></li> <li><code>jj sparse set --add exclude:dir:foo/bar</code> adds a new <code>Dir</code> type rule with <code>include = false</code></li> <li><code>jj sparse set --exclude foo/bar</code> as a possible shorthand for the above</li> <li><code>jj sparse list</code> will print the explicit rules</li> </ul> <p>Paths will be stored in an ordered, canonical form which unambiguously describes the set of files to be included. Every <code>--add</code> command will append to the end of this list before the patterns are canonicalized. Whether a file is included is determined by the first matching rule in reverse order.</p> <p>For example:</p> <pre><code>include:dir:foo\nexclude:dir:foo/bar\ninclude:dir:foo/bar/baz\nexclude:dir:foo/bar/baz/qux\n</code></pre> <p>Produces rule set which includes \"foo/file.txt\", excludes \"foo/bar/file.txt\", includes \"foo/bar/baz/file.txt\", and excludes \"foo/bar/baz/qux/file.txt\".</p> <p>If the rules are subtly re-ordered, they become canonicalized to a smaller, but functionally equivalent form:</p> <pre><code># Before\ninclude:dir:foo\nexclude:dir:foo/bar/baz/qux\ninclude:dir:foo/bar/baz\nexclude:dir:foo/bar\n\n# Canonicalized\ninclude:dir:foo\nexclude:dir:foo/bar\n</code></pre>"},{"location":"design/sparse-v2.html#canonicalization","title":"Canonicalization","text":"<p>There are many ways to represent functionally equivalent <code>WorkingCopyPatterns</code>. For instance, the following 4 rule sets are all functionally equivalent:</p> <pre><code># Set 1\ninclude:dir:bar\ninclude:dir:foo\n\n# Set 2\ninclude:dir:foo\ninclude:dir:bar\n\n# Set 3\ninclude:dir:bar\ninclude:dir:bar/baz/qux\ninclude:dir:foo\n\n# Set 4\ninclude:dir:foo\nexclude:dir:foo/baz\ninclude:dir:bar\ninclude:dir:foo/baz\n</code></pre> <p>Because these patterns are stored in the Op Store now, it is useful for all of these representations to be rewritten into a minimal, canonical form before serialization. In this case, <code>Set 1</code> will be the canonical set. The canonical form of a <code>WorkingCopyPatterns</code> is defined as the form such that:</p> <ul> <li>Every rule affects the functionality (there are no redundant rules)</li> <li>Rules are sorted lexicographically, but with '/' sorted before all else<ul> <li>This special sorting order is useful for constructing path tries</li> </ul> </li> </ul>"},{"location":"design/sparse-v2.html#working-copy-map","title":"Working Copy Map","text":"<p>Warning</p> <p>This section is intentionally lacking, more research is needed.</p> <p>All <code>WorkingCopyPatterns</code> will come equipped with a default no-op mapping. These mappings are inspired by and similar to Perforce client views.</p> <pre><code>vec![WorkingCopyMapping {\n    src_path: RepoPathBuf::root(),\n    dst_path: WorkingCopyPathBuf::root(),\n    recursive: true,\n}]\n</code></pre> <p><code>WorkingCopyPatterns</code> will provide an interface to map working copy paths into repo paths and vice versa. The `WorkingCopy`` trait will apply this mapping to all snapshot and checkout operations, and jj commands which accept relative paths will need to be updated to perform working copy path -&gt; repo path translations as needed. It's not clear at this time which commands will need changing, as some are more likely to refer to repo paths rather than working copy paths.</p> <p>TODO: Expand this section.</p> <p>In particular, the path rules for sparse patterns will always be repo paths, not working copy paths. Thus, if the working copy wants to track \"foo\" and rename it to \"subdir/bar\", they must <code>jj sparse set --add foo</code> and <code>jj map set --from foo --to bar</code>. In other words, the mapping operation can be thought of as always after the sparse operation.</p>"},{"location":"design/sparse-v2.html#command-syntax_1","title":"Command Syntax","text":"<p>New commands will enable editing of the <code>WorkingCopyMapping</code>s:</p> <p>TODO: Maybe this should be <code>jj workspace map ...</code>?</p> <ul> <li><code>jj map list</code> will print all mapping pairs.</li> <li><code>jj map add --from foo --to bar</code> will add a new mapping to the end of the list.</li> <li><code>jj map remove --from foo</code> will remove a specific mapping rule.</li> <li><code>jj map edit</code> will pull up a text editor for manual editing.</li> </ul> <p>Like sparse paths, mappings will have a compact text syntax for editing in file form, or for adding a rule textually on the CLI:</p> <pre><code>\"&lt;from&gt;\" -&gt; \"&lt;to&gt;\" [nonrecursive]\n</code></pre> <p>Like sparse paths, mapping rules are defined to apply in order and on any save operation will be modified to a minimal canonical form. Thus, <code>jj map set --from \"\" --to \"\"</code> will always completely wipe the map. The first matching rule in reverse list order determines how a particular repo path should be mapped into the working copy, and likewise how a particular working copy path should be mapped into the repo. For simplicity, the 'last rule wins' applies both for repo-&gt;WC conversions, as well as WC-&gt;repo conversions, using the same ordering.</p> <p>If a working copy mapping places the same repo file at two distinct working copy paths, snapshotting will fail unless these files are identical. Some specialized filesystems may even treat these as the 'same' file, allowing this to work in some cases.</p> <p>If a working copy mapping places two distinct repo files at the same working copy path, checkout will fail with an error regardless of equivalence.</p>"},{"location":"design/sparse-v2.html#versioning-and-storage","title":"Versioning and Storage","text":"<p>Updating the active <code>WorkingCopyPatterns</code> for a particular working copy will now take place in two separate steps: one transaction which updates the op store, and a separate <code>LockedWorkingCopy</code> operation which actually updates the working copy. The working copy proto will no longer store <code>WorkingCopyPatterns</code> directly, instead storing only a <code>WorkingCopyPatternsId</code>. On mismatch with the current op head, the user will be prompted to run <code>jj workspace update-stale</code>.</p> <p>This gives the user the ability to update the active <code>WorkingCopyPatterns</code> whilst not interacting with the local working copy, which is useful for custom integrations which may not be able to check out particular working copy patterns due to problems with the backend (encoding, permission errors, etc.). A bad <code>jj sparse set --add oops</code> command can thus be undone, even via <code>jj op undo</code> if desired.</p>"},{"location":"design/sparse-v2.html#view-updates","title":"View Updates","text":"<p>The View object will be migrated to store working copy patterns via id. The indirection will save on storage since working copy patterns are not expected to change very frequently.</p> <pre><code>// Before:\npub wc_commit_ids: HashMap&lt;WorkspaceId, CommitId&gt;,\n\n// After:\npub struct WorkingCopyInfo {\n    pub commit_id: CommitId,\n    pub wc_patterns_id: WorkingCopyPatternsId,\n}\n...\npub wc_info: HashMap&lt;WorkspaceId, WorkingCopyInfo&gt;,\n</code></pre> <p>A View object with no stored working copy patterns will be modified at read time to include the current working copy patterns, thus all <code>read_view</code> operations will need to pass in the current working copy patterns for a migration period of at least 6 months. After that, we may choose to auto-fill missing working copy infos with a default <code>WorkingCopyPatterns</code> as needed.</p>"},{"location":"design/sparse-v2.html#appendix","title":"Appendix","text":""},{"location":"design/sparse-v2.html#related-work","title":"Related Work","text":"<p>Perforce client maps  are very similar in concept to the entirety of <code>WorkingCopyPatterns</code>, and this  design aims to achieve similar functionality.</p> <p>The Josh Project implements partial git clones in a way similar to how sparse patterns try to work.</p>"},{"location":"design/sparse-v2.html#patterns-via-configuration","title":"Patterns via configuration","text":"<p>There may be some scenarios where it is valuable to configure working copy patterns via a configuration file, rather than through explicit commands. Generally this only makes sense for automated repos, with the configuration coming from outside the repo - there are too many caveats and edge cases if the configuration comes from inside the repo and/or is fought with by a human.</p> <p>No configuration syntax is planned at this time but if we add any, we should probably reuse the compact line syntaxes as much as possible for consistency.</p>"},{"location":"design/tracking-branches.html","title":"Remote/<code>@git</code> tracking branches","text":"<p>This is a plan to implement more Git-like remote tracking branch UX.</p>"},{"location":"design/tracking-branches.html#objective","title":"Objective","text":"<p><code>jj</code> imports all remote branches to local branches by default. As described in #1136, this doesn't interact nicely with Git if we have multiple Git remotes with a number of branches. The <code>git.auto-local-bookmark</code> config can mitigate this problem, but we'll get locally-deleted branches instead.</p> <p>The goal of this plan is to implement</p> <ul> <li>proper support for tracking/non-tracking remote branches</li> <li>logically consistent data model for importing/exporting Git refs</li> </ul>"},{"location":"design/tracking-branches.html#current-data-model-as-of-jj-080","title":"Current data model (as of jj 0.8.0)","text":"<p>Under the current model, all remote branches are \"tracking\" branches, and remote changes are merged into the local counterparts.</p> <pre><code>branches\n  [name]:\n    local_target?\n    remote_targets[remote]: target\ntags\n  [name]: target\ngit_refs\n  [\"refs/heads/{name}\"]: target             # last-known local branches\n  [\"refs/remotes/{remote}/{name}\"]: target  # last-known remote branches\n                                            # (copied to remote_targets)\n  [\"refs/tags/{name}\"]: target              # last-known tags\ngit_head: target?\n</code></pre> <ul> <li>Remote branches are stored in both <code>branches[name].remote_targets</code> and   <code>git_refs[\"refs/remotes\"]</code>. These two are mostly kept in sync, but there   are two scenarios where remote-tracking branches and git refs can diverge:<ol> <li><code>jj branch forget</code></li> <li><code>jj op undo</code>/<code>restore</code> in colocated repo</li> </ol> </li> <li>Pseudo <code>@git</code> tracking branches are stored in <code>git_refs[\"refs/heads\"]</code>. We   need special case to resolve <code>@git</code> branches, and their behavior is slightly   different from the other remote-tracking branches.</li> </ul>"},{"location":"design/tracking-branches.html#proposed-data-model","title":"Proposed data model","text":"<p>We'll add a per-remote-branch <code>state</code> to distinguish non-tracking branches from tracking ones.</p> <pre><code>state = new        # not merged in the local branch or tag\n      | tracking   # merged in the local branch or tag\n# `ignored` state could be added if we want to manage it by view, not by\n# config file. target of ignored remote branch would be absent.\n</code></pre> <p>We'll add a per-remote view-like object to record the last known remote branches. It will replace <code>branches[name].remote_targets</code> in the current model. <code>@git</code> branches will be stored in <code>remotes[\"git\"]</code>.</p> <pre><code>branches\n  [name]: target\ntags\n  [name]: target\nremotes\n  [\"git\"]:\n    branches\n      [name]: target, state                 # refs/heads/{name}\n    tags\n      [name]: target, state = tracking      # refs/tags/{name}\n    head: target?, state = TBD              # refs/HEAD\n  [remote]:\n    branches\n      [name]: target, state                 # refs/remotes/{remote}/{name}\n    tags: (empty)\n    head: (empty)\ngit_refs                                    # last imported/exported refs\n  [\"refs/heads/{name}\"]: target\n  [\"refs/remotes/{remote}/{name}\"]: target\n  [\"refs/tags/{name}\"]: target\n</code></pre> <p>With the proposed data model, we can</p> <ul> <li>naturally support remote branches which have no local counterparts</li> <li>deduplicate <code>branches[name].remote_targets</code> and <code>git_refs[\"refs/remotes\"]</code></li> </ul>"},{"location":"design/tracking-branches.html#importexport-data-flow","title":"Import/export data flow","text":"<pre><code>       export flow                              import flow\n       -----------                              -----------\n                        +----------------+                   --.\n   +-------------------&gt;|backing Git repo|---+                 :\n   |                    +----------------+   |                 : unchanged\n   |[update]                                 |[copy]           : on \"op restore\"\n   |                      +----------+       |                 :\n   |      +--------------&gt;| git_refs |&lt;------+                 :\n   |      |               +----------+       |               --'\n   +--[compare]                            [diff]--+\n          |   .--       +---------------+    |     |         --.\n          |   :    +---&gt;|remotes[\"git\"] |    |     |           :\n          +---:    |    |               |&lt;---+     |           :\n              :    |    |remotes[remote]|          |           : restored\n              '--  |    +---------------+          |[merge]    : on \"op restore\"\n                   |                               |           : by default\n             [copy]|    +---------------+          |           :\n                   +----| (local)       |&lt;---------+           :\n                        | branches/tags |                      :\n                        +---------------+                    --'\n</code></pre> <ul> <li><code>jj git import</code> applies diff between <code>git_refs</code> and <code>remotes[]</code>. <code>git_refs</code> is   always copied from the backing Git repo.</li> <li><code>jj git export</code> copies jj's <code>remotes</code> view back to the Git repo. If a ref in   the Git repo has been updated since the last import, the ref isn't exported.</li> <li><code>jj op restore</code> never rolls back <code>git_refs</code>.</li> </ul>"},{"location":"design/tracking-branches.html#tracking-state","title":"Tracking state","text":"<p>The <code>git.auto-local-bookmark</code> config knob is applied when importing new remote branch. <code>jj branch</code> sub commands will be added to change the tracking state.</p> <pre><code>fn default_state_for_newly_imported_branch(config, remote) {\n    if remote == \"git\" {\n        State::Tracking\n    } else if config[\"git.auto-local-bookmark\"] {\n        State::Tracking\n    } else {\n        State::New\n    }\n}\n</code></pre> <p>A branch target to be merged is calculated based on the <code>state</code>.</p> <pre><code>fn target_in_merge_context(known_target, state) {\n    match state {\n        State::New =&gt; RefTarget::absent(),\n        State::Tracking =&gt; known_target,\n    }\n}\n</code></pre>"},{"location":"design/tracking-branches.html#mapping-to-the-current-data-model","title":"Mapping to the current data model","text":"<ul> <li>New <code>remotes[\"git\"].branches</code> corresponds to <code>git_refs[\"refs/heads\"]</code>, but   forgotten branches are removed from <code>remotes[\"git\"].branches</code>.</li> <li>New <code>remotes[\"git\"].tags</code> corresponds to <code>git_refs[\"refs/tags\"]</code>.</li> <li>New <code>remotes[\"git\"].head</code> corresponds to <code>git_head</code>.</li> <li>New <code>remotes[remote].branches</code> corresponds to   <code>branches[].remote_targets[remote]</code>.</li> <li><code>state = new|tracking</code> doesn't exist in the current model. It's determined   by <code>git.auto-local-bookmark</code> config.</li> </ul>"},{"location":"design/tracking-branches.html#common-command-behaviors","title":"Common command behaviors","text":"<p>In the following sections, a merge is expressed as <code>adds - removes</code>. In particular, a merge of local and remote targets is <code>[local, remote] - [known_remote]</code>.</p>"},{"location":"design/tracking-branches.html#fetchimport","title":"fetch/import","text":"<ul> <li> <p><code>jj git fetch</code></p> <ol> <li>Fetches remote changes to the backing Git repo.</li> <li>Import changes only for <code>remotes[remote].branches[glob]</code> (see below)<ul> <li>TODO: how about fetched <code>.tags</code>?</li> </ul> </li> </ol> </li> <li> <p><code>jj git import</code></p> <ol> <li>Copies <code>git_refs</code> from the backing Git repo.</li> <li>Calculates diff from the known <code>remotes</code> to the new <code>git_refs</code>.<ul> <li><code>git_refs[\"refs/heads\"] - remotes[\"git\"].branches</code></li> <li><code>git_refs[\"refs/tags\"] - remotes[\"git\"].tags</code></li> <li>TBD: <code>\"HEAD\" - remotes[\"git\"].head</code> (unused)</li> <li><code>git_refs[\"refs/remotes/{remote}\"] - remotes[remote]</code></li> </ul> </li> <li>Merges diff in local <code>branches</code> and <code>tags</code> if <code>state</code> is <code>tracking</code>.<ul> <li>If the known <code>target</code> is <code>absent</code>, the default <code>state</code> should be    calculated. This also applies to previously-forgotten branches.</li> </ul> </li> <li>Updates <code>remotes</code> reflecting the import.</li> <li>Abandons commits that are no longer referenced.</li> </ol> </li> </ul>"},{"location":"design/tracking-branches.html#pushexport","title":"push/export","text":"<ul> <li> <p><code>jj git push</code></p> <ol> <li>Calculates diff from the known <code>remotes[remote]</code> to the local changes.<ul> <li><code>branches - remotes[remote].branches</code><ul> <li>If <code>state</code> is <code>new</code> (i.e. untracked), the known remote branch <code>target</code>    is considered <code>absent</code>.</li> <li>If <code>state</code> is <code>new</code>, and if the local branch <code>target</code> is <code>absent</code>, the    diff <code>[absent, remote] - absent</code> is noop. So it's not allowed to push    deleted branch to untracked remote.</li> <li>TODO: Copy Git's <code>--force-with-lease</code> behavior?</li> </ul> </li> <li>~<code>tags</code>~ (not implemented, but should be the same as <code>branches</code>)</li> </ul> </li> <li>Pushes diff to the remote Git repo (as well as remote tracking branches    in the backing Git repo.)</li> <li>Updates <code>remotes[remote]</code> and <code>git_refs</code> reflecting the push.</li> </ol> </li> <li> <p><code>jj git export</code></p> <ol> <li>Copies local <code>branches</code>/<code>tags</code> back to <code>remotes[\"git\"]</code>.<ul> <li>Conceptually, <code>remotes[\"git\"].branches[name].state</code> can be set to    untracked. Untracked local branches won't be exported to Git.</li> <li>If <code>remotes[\"git\"].branches[name]</code> is <code>absent</code>, the default    <code>state = tracking</code> applies. This also applies to forgotten branches.</li> <li>~<code>tags</code>~ (not implemented, but should be the same as <code>branches</code>)</li> </ul> </li> <li>Calculates diff from the known <code>git_refs</code> to the new <code>remotes[remote]</code>.</li> <li>Applies diff to the backing Git repo.</li> <li>Updates <code>git_refs</code> reflecting the export.</li> </ol> <p>If a ref failed to export at the step 3, the preceding steps should also be rolled back for that ref.</p> </li> </ul>"},{"location":"design/tracking-branches.html#initclone","title":"init/clone","text":"<ul> <li> <p><code>jj init</code></p> <ul> <li>Import, track, and merge per <code>git.auto_local_branch</code> config.</li> <li>If <code>!git.auto_local_branch</code>, no <code>tracking</code> state will be set.</li> </ul> </li> <li> <p><code>jj git clone</code></p> <ul> <li>Import, track, and merge per <code>git.auto_local_branch</code> config.</li> <li>The default branch will be tracked regardless of <code>git.auto_local_branch</code>   config. This isn't technically needed, but will help users coming from Git.</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#branch","title":"branch","text":"<ul> <li><code>jj branch set {name}</code><ol> <li>Sets local <code>branches[name]</code> entry.</li> </ol> </li> <li><code>jj branch delete {name}</code><ol> <li>Removes local <code>branches[name]</code> entry.</li> </ol> </li> <li><code>jj branch forget {name}</code><ol> <li>Removes local <code>branches[name]</code> entry if exists.</li> <li>Removes <code>remotes[remote].branches[name]</code> entries if exist.    TODO: maybe better to not remove non-tracking remote branches?</li> </ol> </li> <li><code>jj branch track {name}@{remote}</code> (new command)<ol> <li>Merges <code>[local, remote] - [absent]</code> in local branch.<ul> <li>Same as \"fetching/importing existing branch from untracked remote\".</li> </ul> </li> <li>Sets <code>remotes[remote].branches[name].state = tracking</code>.</li> </ol> </li> <li><code>jj branch untrack {name}@{remote}</code> (new command)<ol> <li>Sets <code>remotes[remote].branches[name].state = new</code>.</li> </ol> </li> <li><code>jj branch list</code><ul> <li>TODO: hide non-tracking branches by default? ...</li> </ul> </li> </ul> <p>Note: desired behavior of <code>jj branch forget</code> is to</p> <ul> <li>discard both local and remote branches (without actually removing branches   at remotes)</li> <li>not abandon commits which belongs to those branches (even if the branch is   removed at a remote)</li> </ul>"},{"location":"design/tracking-branches.html#command-behavior-examples","title":"Command behavior examples","text":""},{"location":"design/tracking-branches.html#fetchimport_1","title":"fetch/import","text":"<ul> <li>Fetching/importing new branch<ol> <li>Decides new <code>state = new|tracking</code> based on <code>git.auto_local_branch</code></li> <li>If new <code>state</code> is <code>tracking</code>, merges <code>[absent, new_remote] - [absent]</code>    (i.e. creates local branch with <code>new_remote</code> target)</li> <li>Sets <code>remotes[remote].branches[name].state</code></li> </ol> </li> <li>Fetching/importing existing branch from tracking remote<ol> <li>Merges <code>[local, new_remote] - [known_remote]</code></li> </ol> </li> <li>Fetching/importing existing branch from untracked remote<ol> <li>Decides new <code>state = new|tracking</code> based on <code>git.auto_local_branch</code></li> <li>If new <code>state</code> is <code>tracking</code>, merges <code>[local, new_remote] - [absent]</code></li> <li>Sets <code>remotes[remote].branches[name].state</code></li> </ol> </li> <li>Fetching/importing remotely-deleted branch from tracking remote<ol> <li>Merges <code>[local, absent] - [known_remote]</code></li> <li>Removes <code>remotes[remote].branches[name]</code> (<code>target</code> becomes <code>absent</code>)    (i.e. the remote branch is no longer tracked)</li> <li>Abandons commits in the deleted branch</li> </ol> </li> <li>Fetching/importing remotely-deleted branch from untracked remote<ol> <li>Decides new <code>state = new|tracking</code> based on <code>git.auto_local_branch</code></li> <li>Noop anyway since <code>[local, absent] - [absent]</code> -&gt; <code>local</code></li> </ol> </li> <li>Fetching previously-forgotten branch from remote<ol> <li>Decides new <code>state = new|tracking</code> based on <code>git.auto_local_branch</code></li> <li>If new <code>state</code> is <code>tracking</code>, merges   <code>[absent, new_remote] - [absent]</code> -&gt; <code>new_remote</code></li> <li>Sets <code>remotes[remote].branches[name].state</code></li> </ol> </li> <li>Fetching forgotten and remotely-deleted branch<ul> <li>Same as \"remotely-deleted branch from untracked remote\" since forgotten   remote branch should be <code>state = new</code></li> <li>Therefore, no local commits should be abandoned</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#push","title":"push","text":"<ul> <li>Pushing new branch, remote doesn't exist<ol> <li>Pushes <code>[local, absent] - [absent]</code> -&gt; <code>local</code></li> <li>Sets <code>remotes[remote].branches[name].target = local</code>, <code>.state = tracking</code></li> </ol> </li> <li>Pushing new branch, untracked remote exists<ol> <li>Pushes <code>[local, remote] - [absent]</code><ul> <li>Fails if <code>local</code> moved backwards or sideways</li> </ul> </li> <li>Sets <code>remotes[remote].branches[name].target = local</code>, <code>.state = tracking</code></li> </ol> </li> <li>Pushing existing branch to tracking remote<ol> <li>Pushes <code>[local, remote] - [remote]</code> -&gt; <code>local</code><ul> <li>Fails if <code>local</code> moved backwards or sideways, and if <code>remote</code> is out of    sync</li> </ul> </li> <li>Sets <code>remotes[remote].branches[name].target = local</code></li> </ol> </li> <li>Pushing existing branch to untracked remote<ul> <li>Same as \"new branch\"</li> </ul> </li> <li>Pushing deleted branch to tracking remote<ol> <li>Pushes <code>[absent, remote] - [remote]</code> -&gt; <code>absent</code><ul> <li>TODO: Fails if <code>remote</code> is out of sync?</li> </ul> </li> <li>Removes <code>remotes[remote].branches[name]</code> (<code>target</code> becomes <code>absent</code>)</li> </ol> </li> <li>Pushing deleted branch to untracked remote<ul> <li>Noop since <code>[absent, remote] - [absent]</code> -&gt; <code>remote</code></li> <li>Perhaps, UI will report error</li> </ul> </li> <li>Pushing forgotten branch to untracked remote<ul> <li>Same as \"deleted branch to untracked remote\"</li> </ul> </li> <li>Pushing previously-forgotten branch to remote<ul> <li>Same as \"new branch, untracked remote exists\"</li> <li>The <code>target</code> of forgotten remote branch is <code>absent</code></li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#export","title":"export","text":"<ul> <li>Exporting new local branch, git branch doesn't exist<ol> <li>Sets <code>remotes[\"git\"].branches[name].target = local</code>, <code>.state = tracking</code></li> <li>Exports <code>[local, absent] - [absent]</code> -&gt; <code>local</code></li> </ol> </li> <li>Exporting new local branch, git branch is out of sync<ol> <li>Exports <code>[local, git] - [absent]</code> -&gt; fail</li> </ol> </li> <li>Exporting existing local branch, git branch is synced<ol> <li>Sets <code>remotes[\"git\"].branches[name].target = local</code></li> <li>Exports <code>[local, git] - [git]</code> -&gt; <code>local</code></li> </ol> </li> <li>Exporting deleted local branch, git branch is synced<ol> <li>Removes <code>remotes[\"git\"].branches[name]</code></li> <li>Exports <code>[absent, git] - [git]</code> -&gt; <code>absent</code></li> </ol> </li> <li>Exporting forgotten branches, git branches are synced<ol> <li>Exports <code>[absent, git] - [git]</code> -&gt; <code>absent</code> for forgotten local/remote    branches</li> </ol> </li> </ul>"},{"location":"design/tracking-branches.html#undo-fetch","title":"undo fetch","text":"<ul> <li>Exporting undone fetch, git branches are synced<ol> <li>Exports <code>[old, git] - [git]</code> -&gt; <code>old</code> for undone local/remote branches</li> </ol> </li> <li>Redoing undone fetch without exporting<ul> <li>Same as plain fetch since the known <code>git_refs</code> isn't diffed against the   refs in the backing Git repo.</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#git-remote","title":"<code>@git</code> remote","text":"<ul> <li><code>jj branch untrack {name}@git</code><ul> <li>Maybe rejected (to avoid confusion)?</li> <li>Allowing this would mean different local branches of the same name coexist   in jj and git.</li> </ul> </li> <li><code>jj git fetch --remote git</code><ul> <li>Rejected. The implementation is different.</li> <li>Conceptually, it's <code>git::import_refs()</code> only for local branches.</li> </ul> </li> <li><code>jj git push --remote git</code><ul> <li>Rejected. The implementation is different.</li> <li>Conceptually, it's <code>jj branch track</code> and <code>git::export_refs()</code> only for   local branches.</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#remaining-issues","title":"Remaining issues","text":"<ul> <li>https://github.com/jj-vcs/jj/issues/1278 pushing to tracked remote<ul> <li>Option could be added to push to all <code>tracking</code> remotes?</li> </ul> </li> <li>Track remote branch locally with different name<ul> <li>Local branch name could be stored per remote branch</li> <li>Consider UI complexity</li> </ul> </li> <li>\"private\" state (suggested by @ilyagr)<ul> <li>\"private\" branches can be pushed to their own remote, but not to the   upstream repo</li> <li>This might be a state attached to a local branch (similar to Mercurial's   \"secret\" phase)</li> </ul> </li> </ul>"},{"location":"design/tracking-branches.html#references","title":"References","text":"<ul> <li>https://github.com/jj-vcs/jj/issues/1136</li> <li>https://github.com/jj-vcs/jj/issues/1666</li> <li>https://github.com/jj-vcs/jj/issues/1690</li> <li>https://github.com/jj-vcs/jj/issues/1734</li> <li>https://github.com/jj-vcs/jj/pull/1739</li> </ul>"},{"location":"governance/temporary-voting.html","title":"Getting Community Buy-in for Working Group Proposals","text":""},{"location":"governance/temporary-voting.html#introduction","title":"Introduction","text":"<p>We're introducing a temporary process to describe how we'll gain approval to adopt permanent governance policies - basically, how we make social and technical decisions as a community. This temporary process describes how the governance working group can propose these policies and how community members can influence them and vote on them. Once permanent governance policies are in place, the temporary process will stop being used, and the permanent governance policies will be used instead.</p>"},{"location":"governance/temporary-voting.html#context","title":"Context","text":"<p>The governance working group was appointed by recommendation from Martin (jj's original author and current sole maintainer), without recommendation or approval from the broader jj community. This isn't a problem in itself - but it does mean that the governance working group (Austin Seipp/aseipp, Waleed Khan/arxanas, Martin von Zweigbergk/martinvonz, and Emily Shaffer/nasamuffin) needs to get some community approval before setting policy for the entire jj project. If we skip this step, we risk being perceived as exercising excessive control over the project.</p>"},{"location":"governance/temporary-voting.html#goals-and-non-goals","title":"Goals and Non-Goals","text":"<ul> <li>This process will be used to approve things like a <code>governance.md</code> (describing   the formal structure of governance used for this project), technical design   approval process, and code review process.</li> <li>This is not a process that will be used forever. It is intended as a   temporary process, only used to approve more permanent processes and policies   for the project.</li> <li>This process is used to gather feedback, approval, and acceptance from   invested jj community members. Current members of the community should be able   to participate in voting without hardship.<ul> <li>Current community members include code committers, code reviewers, those   providing user support, those providing quality, actionable feedback, those   providing documentation (first-party or third-party), developers of   jj-compatible tools and add-ons (like GUIs or IDE extensions), and those   providing design input and feedback.<ul> <li>If you feel that you are a member of the community but do not fit into one   of these buckets, please reach out to one of the members of the working   group to have this list expanded.</li> </ul> </li> </ul> </li> <li>This process is the primary way for general community members to influence   governance policies and processes. It should invite constructive feedback and   help us form policies that are acceptable to the jj group as a whole.<ul> <li>It's intended to meet community members where they are - on GitHub and on   Discord, where all development occurs and most support and technical   discussion occurs.</li> </ul> </li> <li>This is not a process for gaining unanimous agreement - there are too   many of us for that to be feasible. Instead, it is a process for gaining   widespread community approval.</li> </ul>"},{"location":"governance/temporary-voting.html#process","title":"Process","text":""},{"location":"governance/temporary-voting.html#stage-1-advance-notice-of-effort","title":"Stage 1: Advance Notice of Effort","text":"<p>The working group lets the community know about upcoming policy drafts they're intending to share for approval. This must happen at least a week before entering stage 3, and ideally should happen even earlier.</p> <p>At this time, the working group should:</p> <ul> <li>Describe why the working group feels this policy is needed</li> <li>Describe the basic goals the policy should achieve</li> <li>Describe implementation details that are being considered, if any</li> <li>Create discussion thread on GitHub (and link to it from Discord). The GitHub   discussion thread is the canonical thread for discussion and will be reused   through the lifetime of a proposal as it moves through this process.</li> </ul> <p>At this time, the community is invited to:</p> <ul> <li>Recommend additional goals, or discuss nuances of the stated goals the working   group has already shared</li> <li>Recommend implementation details</li> </ul> <p>The working group will consider these recommendations in good faith, but may choose not to adopt them.</p>"},{"location":"governance/temporary-voting.html#stage-2-proposal-review-period","title":"Stage 2: Proposal Review Period","text":"<p>This stage lasts until the working group feels major concerns have been addressed and the proposal is ready for a vote. However, at least 72 hours must elapse between the proposal being published and the vote starting, to allow community members around the globe to read and comment. Typically, this stage should last at least one week.</p> <p>At this time, the working group should:</p> <ul> <li>Share the full text of the proposal as a GitHub pull request (PR)</li> <li>Link this GitHub PR to the existing Discord notification thread and GitHub   discussion</li> <li>Explain how the proposal meets the goals stated in Stage 1, either within the   proposal itself or in commentary next to the proposal</li> </ul> <p>At this time, the community is invited to:</p> <ul> <li>Share constructive recommendations in GitHub to modify the text of the   proposal, or discuss nuances of the proposal's wording</li> <li>Share showstopper concerns in GitHub about the proposal, including details   about how and why the concern is especially dire</li> </ul> <p>Think of this like a code review; the goal of this stage is to build a proposal that is representative of the community's will. Keep recommendations actionable and constructive: \"This clause discourages X; if we phrase it like \"foo bar baz\" it could be less exclusive\" is much more productive than \"It's obvious that the governance working group doesn't want X!\"</p> <p>At the discretion of the working group, but based on the outcome of the discussion, the proposal will go to a vote or the proposal will be dropped.</p>"},{"location":"governance/temporary-voting.html#stage-3-proposal-voting-period","title":"Stage 3: Proposal Voting Period","text":"<p>When the working group feels that major concerns have been addressed and is happy with the text of the proposal, the working group will open voting on the proposal.</p> <ul> <li>Voting occurs on GitHub using the poll feature and is advertised heavily on   Discord during the voting period.<ul> <li>If community members want to vote but aren't able to use GitHub, they can   message nasamuffin@ (on Discord, or nasamuffin at google dot com) with their   vote to have it manually included. Only one working group member is listed   in order to avoid accidental double-counting.</li> <li>When voting against, community members should comment on the post explaining   why and describe what change would be required for them to abstain or vote   in favor.</li> <li>Generally, assume that the votes may be publicly visible or may be made   publicly visible at a later time.</li> </ul> </li> <li>Voting is open for at least 1 week, but may be open as long as 2 weeks when   appropriate. After that deadline, the GitHub poll will be locked.     * The deadline must be announced at the beginning of the voting period -       once voting has begun, the deadline cannot change.     * The working group may set the voting period longer to encompass two       weekends (for more participation around day jobs), for less urgent or more       complex proposals, or to account for holidays during the voting period.</li> <li>Participants can vote in favor or against.<ul> <li>\"Participants\" means the group of community members as enumerated at the   beginning of this document.</li> </ul> </li> </ul> <p>Proposals with 2/3 or more votes in favor at the end of the voting period will be approved.</p> <p>After voting has concluded, either:</p> <ul> <li>The proposal will be implemented (if accepted)</li> <li>The proposal may be revised and begin again at stage 2 (if rejected)</li> <li>The proposal may be abandoned (if rejected)</li> </ul> <p>Deciding whether to revise or abandon is up to the discretion of the governance working group. The working group is expected to double-check their assumption that the goals the proposal is attempting to meet are desirable after the proposal fails to be accepted.</p>"},{"location":"governance/temporary-voting.html#stage-4-implementation","title":"Stage 4: Implementation","text":"<p>Typically, implementation will look like merging the document with the policy into the jj codebase and remembering to use that policy in conversations moving forward.</p> <p>In some cases, implementation may also involve nomination of individuals to a group or committee. When this is necessary, expect the policy being proposed to describe how these individuals will be nominated, both initially and moving into the future.</p> <p>It's possible (but unlikely) that during implementation, some obstacle will arise that means the policy doesn't actually work. If this does happen, expect the working group to be transparent with the community about the situation. We may reuse some of all of this process to figure out how to move forward.</p>"},{"location":"technical/architecture.html","title":"Architecture","text":""},{"location":"technical/architecture.html#data-model","title":"Data model","text":"<p>The commit data model is similar to Git's object model , but with some differences.</p>"},{"location":"technical/architecture.html#separation-of-library-from-ui","title":"Separation of library from UI","text":"<p>The <code>jj</code> binary consists of two Rust crates: the library crate (<code>jj-lib</code>) and the CLI crate (<code>jj-cli</code>). The library crate is currently only used by the CLI crate, but it is meant to also be usable from a GUI or TUI, or in a server serving requests from multiple users. As a result, the library should avoid interacting directly with the user via the terminal or by other means; all input/output is handled by the CLI crate <sup>1</sup>. Since the library crate is meant to usable in a server, it also cannot read configuration from the user's home directory, or from user-specific environment variables.</p> <p>A lot of thought has gone into making the library crate's API easy to use, but not much has gone into \"details\" such as which collection types are used, or which symbols are exposed in the API.</p>"},{"location":"technical/architecture.html#storage-independent-apis","title":"Storage-independent APIs","text":"<p>One overarching principle in the design is that it should be easy to change where data is stored. The goal was to be able to put storage on local-disk by default but also be able to move storage to the cloud at Google (and for anyone). To that end, commits (and trees, files, etc.) are stored by the commit backend, operations (and views) are stored by the operation backend, the heads of the operation log are stored by the \"op heads\" backend, the commit index is stored by the index backend, and the working copy is stored by the working copy backend. The interfaces are defined in terms of plain Rust data types, not tied to a specific format. The working copy doesn't have its own trait defined yet, but its interface is small and easy to create traits for when needed.</p> <p>The commit backend to use when loading a repo is specified in the <code>.jj/repo/store/type</code> file. There are similar files for the other backends (<code>.jj/repo/index/type</code>, <code>.jj/repo/op_store/type</code>, <code>.jj/repo/op_heads/type</code>).</p>"},{"location":"technical/architecture.html#design-of-the-library-crate","title":"Design of the library crate","text":""},{"location":"technical/architecture.html#overview","title":"Overview","text":"<p>Here's a diagram showing some important types in the library crate, and how they relate. For example, given a <code>Workspace</code>, you can use it to get a <code>WorkingCopy</code> or a <code>RepoLoader</code>. A <code>Transaction</code> is required to acquire a <code>MutableRepo</code>, etc. The following sections describe each component.</p> <p></p> <p>This diagram was created with Excalidraw. You can get a copy of it at this location, and Right Click &gt; \"Copy to Clipboard as SVG\".</p>"},{"location":"technical/architecture.html#backend","title":"Backend","text":"<p>The <code>Backend</code> trait defines the interface each commit backend needs to implement. The current in-tree commit backends are <code>GitBackend</code> and <code>LocalBackend</code>.</p> <p>Since there are non-commit backends, the <code>Backend</code> trait should probably be renamed to <code>CommitBackend</code>.</p>"},{"location":"technical/architecture.html#gitbackend","title":"GitBackend","text":"<p>The <code>GitBackend</code> stores commits in a Git repository. It uses <code>libgit2</code> to read and write commits and refs.</p> <p>To prevent GC from deleting commits that are still reachable from the operation log, the <code>GitBackend</code> stores a ref for each commit in the operation log in the <code>refs/jj/keep/</code> namespace.</p> <p>Commit data that is available in Jujutsu's model but not in Git's model is stored in a <code>StackedTable</code> in <code>.jj/repo/store/extra/</code>. That is currently the change ID and the list of predecessors. For commits that don't have any data in that table, which is any commit created by <code>git</code>, we use an empty list as predecessors, and the bit-reversed commit ID as change ID.</p> <p>Because we use the Git Object ID as commit ID, two commits that differ only in their change ID, for example, will get the same commit ID, so we error out when trying to write the second one of them.</p>"},{"location":"technical/architecture.html#localbackend","title":"LocalBackend","text":"<p>The <code>LocalBackend</code> is just a proof of concept. It stores objects addressed by their hash, with one file per object.</p>"},{"location":"technical/architecture.html#store","title":"Store","text":"<p>The <code>Store</code> type wraps the <code>Backend</code> and returns wrapped types for commits and trees to make them easier to use. The wrapped objects have a reference to the <code>Store</code> itself, so you can do e.g. <code>commit.parents()</code> without having to provide the <code>Store</code> as an argument.</p> <p>The <code>Store</code> type also provides caching of commits and trees.</p>"},{"location":"technical/architecture.html#readonlyrepo","title":"ReadonlyRepo","text":"<p>A <code>ReadonlyRepo</code> represents the state of a repo at a specific operation. It keeps the view object associated with that operation.</p> <p>The repository doesn't know where on disk any working copies live. It knows, via the view object, which commit is supposed to be the current working-copy commit in each workspace.</p>"},{"location":"technical/architecture.html#mutablerepo","title":"MutableRepo","text":"<p>A <code>MutableRepo</code> is a mutable version of <code>ReadonlyRepo</code>. It has a reference to its base <code>ReadonlyRepo</code>, but it has its own copy of the view object and lets the caller modify it.</p>"},{"location":"technical/architecture.html#transaction","title":"Transaction","text":"<p>The <code>Transaction</code> object has a <code>MutableRepo</code> and metadata that will go into the operation log. When the transaction commits, the <code>MutableRepo</code> becomes a view object in the operation log on disk, and the <code>Transaction</code> object becomes an operation object. In memory, <code>Transaction::commit()</code> returns a new <code>ReadonlyRepo</code>.</p>"},{"location":"technical/architecture.html#repoloader","title":"RepoLoader","text":"<p>The <code>RepoLoader</code> represents a repository at an unspecified operation. You can think of as a pointer to the <code>.jj/repo/</code> directory. It can create a <code>ReadonlyRepo</code> given an operation ID.</p>"},{"location":"technical/architecture.html#treestate","title":"TreeState","text":"<p>The <code>TreeState</code> type represents the state of the files in a working copy. It keep track of the mtime and size for each tracked file. It knows the <code>TreeId</code> that the working copy represents. It has a <code>snapshot()</code> method that will use the recorded mtimes and sizes and detect changes in the working copy. If anything changed, it will return a new <code>TreeId</code>. It also has <code>checkout()</code> for updating the files on disk to match a requested <code>TreeId</code>.</p> <p>The <code>TreeState</code> type supports sparse checkouts. In fact, all working copies are sparse; they simply track the full repo in most cases.</p>"},{"location":"technical/architecture.html#workingcopy","title":"WorkingCopy","text":"<p>The <code>WorkingCopy</code> type has a <code>TreeState</code> but also knows which <code>WorkspaceId</code> it has and at which operation it was most recently updated.</p>"},{"location":"technical/architecture.html#workspace","title":"Workspace","text":"<p>The <code>Workspace</code> type represents the combination of a repo and a working copy ( like Git's 'worktree' concept).</p> <p>The repo view at the current operation determines the desired working-copy commit in each workspace. The <code>WorkingCopy</code> determines what is actually in the working copy. The working copy can become stale if the working-copy commit was changed from another workspace (or if the process updating the working copy crashed, for example).</p>"},{"location":"technical/architecture.html#git","title":"Git","text":"<p>The <code>git</code> module contains functionality for interoperating with a Git repo, at a higher level than the <code>GitBackend</code>. The <code>GitBackend</code> is restricted by the <code>Backend</code> trait; the <code>git</code> module is specifically for Git-backed repos. It has functionality for importing refs from the Git repo and for exporting to refs in the Git repo. It also has functionality for pushing and pulling to/from Git remotes.</p>"},{"location":"technical/architecture.html#revsets","title":"Revsets","text":"<p>A user-provided revset expression string goes through a few different stages to be evaluated:</p> <ol> <li>Parse the expression into a <code>RevsetExpression</code>, which is close to an AST</li> <li>Resolve symbols and functions like <code>tags()</code> into specific commits. After    this stage, the expression is still a <code>RevsetExpression</code>, but it won't have    any <code>CommitRef</code> variants in it.</li> <li>Resolve visibility. This stage resolves <code>visible_heads()</code> and <code>all()</code> and    produces a <code>ResolvedExpression</code>.</li> <li>Evaluate the <code>ResolvedExpression</code> into a <code>Revset</code>.</li> </ol> <p>This evaluation step is performed by <code>Index::evaluate_revset()</code>, allowing the <code>Revset</code> implementation to leverage the specifics of a custom index implementation. The first three steps are independent of the index implementation.</p>"},{"location":"technical/architecture.html#stackedtable","title":"StackedTable","text":"<p><code>StackedTable</code> (actually <code>ReadonlyTable</code> and <code>MutableTable</code>) is a simple disk format for storing key-value pairs sorted by key. The keys have to have the same size but the values can have different sizes. We use our own format because we want lock-free concurrency and there doesn't seem to be an existing key-value store we could use.</p> <p>The file format contains a lookup table followed by concatenated values. The lookup table is a sorted list of keys, where each key is followed by the associated value's offset in the concatenated values.</p> <p>A table can have a parent table. When looking up a key, if it's not found in the current table, the parent table is searched. We never update a table in place. If the number of new entries to write is less than half the number of entries in the parent table, we create a new table with the new entries and a pointer to the parent. Otherwise, we copy the entries from the parent table and the new entries into a new table with the grandparent as the parent. We do that recursively so parent tables are at least 2 times as large as child tables. This results in O(log N) amortized insertion time and lookup time.</p> <p>There's no garbage collection of unreachable tables yet.</p> <p>The tables are named by their hash. We keep a separate directory of pointers to the current leaf tables, in the same way as we do for the operation log.</p>"},{"location":"technical/architecture.html#design-of-the-cli-crate","title":"Design of the CLI crate","text":""},{"location":"technical/architecture.html#templates","title":"Templates","text":"<p>The concept is copied from Mercurial, but the syntax is different. The main difference is that the top-level expression is a template expression, not a string like in Mercurial. There is also no string interpolation (e.g. <code>\"Commit ID: {node}\"</code> in Mercurial).</p>"},{"location":"technical/architecture.html#diff-editing","title":"Diff-editing","text":"<p>Diff-editing works by creating two very sparse working copies, containing only the files we want the user to edit. We then let the user edit the right-hand side of the diff. Then we simply snapshot that working copy to create the new tree.</p> <ol> <li> <p>There are a few exceptions, such as for messages printed during automatic upgrades of the repo format\u00a0\u21a9</p> </li> </ol>"},{"location":"technical/concurrency.html","title":"Concurrency","text":""},{"location":"technical/concurrency.html#introduction","title":"Introduction","text":"<p>Concurrent editing is a key feature of DVCSs -- that's why they're called Distributed Version Control Systems. A DVCS that didn't let users edit files and create commits on separate machines at the same time wouldn't be much of a distributed VCS.</p> <p>When conflicting changes are made in different clones, a DVCS will have to deal with that when you push or pull. For example, when using Mercurial, if the remote has updated a bookmark called <code>main</code> (Mercurial's bookmarks are similar to a Git's branches) and you had updated the same bookmark locally but made it point to a different target, Mercurial would add a bookmark called <code>main@origin</code> to indicate the conflict. Git instead prevents the conflict by renaming pulled branches to <code>origin/main</code> whether or not there was a conflict. However, most DVCSs treat local concurrency quite differently, typically by using lock files to prevent concurrent edits. Unlike those DVCSs, Jujutsu treats concurrent edits the same whether they're made locally or remotely.</p> <p>One problem with using lock files is that they don't work when the clone is in a distributed file system. Most clones are of course not stored in distributed file systems, but it is a big problem when they are (Mercurial repos frequently get corrupted, for example).</p> <p>Another problem with using lock files is related to complexity of implementation. The simplest way of using lock files is to take coarse-grained locks early: every command that may modify the repo takes a lock at the very beginning. However, that means that operations that wouldn't actually conflict would still have to wait for each other. The user experience can be improved by using finer-grained locks and/or taking the locks later. The drawback of that is complexity. For example, you need to verify that any assumptions you made before locking are still valid after you take the lock.</p> <p>To avoid depending on lock files, Jujutsu takes a different approach by accepting that concurrent changes can always happen. It instead exposes any conflicting changes to the user, much like other DVCSs do for conflicting changes made remotely.</p>"},{"location":"technical/concurrency.html#syncing-with-rsync-nfs-dropbox-etc","title":"Syncing with <code>rsync</code>, NFS, Dropbox, etc","text":"<p>Jujutsu's lock-free concurrency means that it's possible to update copies of the clone on different machines and then let <code>rsync</code> (or Dropbox, or NFS, etc.) merge them. The working copy may mismatch what's supposed to be checked out, but no changes to the repo will be lost (added commits, moved bookmarks, etc.). If conflicting changes were made, they will appear as conflicts. For example, if a bookmark was moved to two different locations, they will appear in <code>jj log</code> in both locations but with a \"?\" after the name, and <code>jj status</code> will also inform the user about the conflict.</p> <p>Note that, for now, there are known bugs in this area. Most notably, with the Git backend, repository corruption is possible because the backend is not entirely lock-free. If you know about the bug, it is relatively easy to recover from.</p> <p>Moreover, such use of Jujutsu is not currently thoroughly tested, especially in the context of co-located repositories. While the contents of commits should be safe, concurrent modification of a repository from different computers might conceivably lose some bookmark pointers. Note that, unlike in pure Git, losing a bookmark pointer does not lead to losing commits.</p>"},{"location":"technical/concurrency.html#operation-log","title":"Operation log","text":"<p>The most important piece in the lock-free design is the \"operation log\". That is what allows us to detect and merge divergent operations.</p> <p>The operation log is similar to a commit DAG (such as in Git's object model), but each commit object is instead an \"operation\" and each tree object is instead a \"view\". The view object contains the set of visible head commits, bookmarks, tags, and the working-copy commit in each workspace. The operation object contains a pointer to the view object (like how commit objects point to tree objects), pointers to parent operation(s) (like how commit objects point to parent commit(s)), and metadata about the operation. These types are defined in <code>op_store.proto</code> The operation log is normally linear. It becomes non-linear if there are divergent operations.</p> <p>When a command starts, it loads the repo at the latest operation. Because the associated view object completely defines the repo state, the running command will not see any changes made by other processes thereafter. When the operation completes, it is written with the start operation as parent. The operation cannot fail to commit (except for disk failures and such). It is left for the next command to notice if there were divergent operations. It will have to be able to do that anyway since the concurrent operation could have arrived via a distributed file system. This model -- where each operation sees a consistent view of the repo and is guaranteed to be able to commit their changes -- greatly simplifies the implementation of commands.</p> <p>It is possible to load the repo at a particular operation with <code>jj --at-operation=&lt;operation ID&gt; &lt;command&gt;</code>. If the command is mutational, that will result in a fork in the operation log. That works exactly the same as if any later operations had not existed when the command started. In other words, running commands on a repo loaded at an earlier operation works the same way as if the operations had been concurrent. This can be useful for simulating divergent operations.</p>"},{"location":"technical/concurrency.html#merging-divergent-operations","title":"Merging divergent operations","text":"<p>If Jujutsu tries to load the repo and finds multiple heads in the operation log, it will do a 3-way merge of the view objects based on their common ancestor (possibly several 3-way merges if there were more than two heads). Conflicts are recorded in the resulting view object. For example, if bookmark <code>main</code> was moved from commit A to commit B in one operation and moved to commit C in a concurrent operation, then <code>main</code> will be recorded as \"moved from A to B or C\". See the <code>RefTarget</code> definition in <code>op_store.proto</code>.</p> <p>Because we allow bookmarks (etc.) to be in a conflicted state rather than just erroring out when there are multiple heads, the user can continue to use the repo, including performing further operations on the repo. Of course, some commands will fail when using a conflicted bookmark. For example, <code>jj new main</code> when <code>main</code> is in a conflicted state will result in an error telling you that <code>main</code> resolved to multiple revisions.</p>"},{"location":"technical/concurrency.html#storage","title":"Storage","text":"<p>The operation objects and view objects are stored in content-addressed storage just like Git commits are. That makes them safe to write without locking.</p> <p>We also need a way of finding the current head of the operation log. We do that by keeping the ID of the current head(s) as a file in a directory. The ID is the name of the file; it has no contents. When an operation completes, we add a file pointing to the new operation and then remove the file pointing to the old operation. Writing the new file is what makes the operation visible (if the old file didn't get properly deleted, then future readers will take care of that). This scheme ensures that transactions are atomic.</p>"},{"location":"technical/conflicts.html","title":"First-class conflicts","text":""},{"location":"technical/conflicts.html#introduction","title":"Introduction","text":"<p>Conflicts can happen when two changes are applied to some state. This document is about conflicts between changes to files (not about conflicts between changes to bookmark targets, for example).</p> <p>For example, if you merge two branches in a repo, there may be conflicting changes between the two branches. Most DVCSs require you to resolve those conflicts before you can finish the merge operation. Jujutsu instead records the conflicts in the commit and lets you resolve the conflict when you feel like it.</p>"},{"location":"technical/conflicts.html#data-model","title":"Data model","text":"<p>When a merge conflict happens, it is recorded as an ordered list of tree objects linked from the commit (instead of the usual single tree per commit). There will always be an odd number of trees linked from the commit. You can think of the first tree as a start tree, and the subsequent pairs of trees to apply the diff between onto the start. Examples:</p> <ul> <li>If the commit has trees A, B, C, D, and E it means that the contents should be   calculated as A+(C-B)+(E-D).</li> <li>A three-way merge between A and C with B as base can be represented as a commit with trees A, B, and C, also known as A+(C-B).</li> </ul> <p>The resulting tree contents is calculated on demand. Note that we often don't need to merge the entire tree. For example, when checking out a commit in the working copy, we only need to merge parts of the tree that differs from the tree that was previously checked out in the working copy. As another example, when listing paths with conflicts, we only need to traverse parts of the tree that cannot be trivially resolved; if only one side modified <code>lib/</code>, then we don't need to look for conflicts in that sub-tree.</p> <p>When merging trees, if we can't resolve a sub-tree conflict trivially by looking at just the tree id, we recurse into the sub-tree. Similarly, if we can't resolve a file conflict trivially by looking at just the id, we recursive into the hunks within the file.</p> <p>See here for how conflicts are stored when using the Git commit backend.</p>"},{"location":"technical/conflicts.html#conflict-simplification","title":"Conflict simplification","text":"<p>Remember that a 3-way merge can be written <code>A+C-B</code>. If one of those states is itself a conflict, then we simply insert the conflict expression there. Then we simplify by removing canceling terms. These two steps are implemented in <code>Merge::flatten()</code> and <code>Merge::simplify()</code> in <code>merge.rs</code>.</p> <p>For example, let's say commit B is based on A and is rebased to C, where it results in conflicts (<code>B+C-A</code>), which the user leaves unresolved. If the commit is then rebased to D, the result will be <code>(B+C-A)+(D-C)</code> (<code>D-C</code> comes from changing the base from C to D). That expression can be simplified to <code>B+D-A</code>, which is a regular 3-way merge between B and D with A as base (no trace of C). This is what lets the user keep old commits rebased to head without resolving conflicts and still not get messy recursive conflicts.</p> <p>As another example, let's go through what happens when you back out a conflicted commit. Let's say we have the usual <code>B+C-A</code> conflict on top of non-conflict state C. We then back out that change. Backing out (\"reverting\" in Git-speak) a change means applying its reverse diff, so the result is <code>(B+C-A)+(A-(B+C-A))</code>, which we can simplify to just <code>A</code> (i.e. no conflict).</p>"}]}