/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class RecordingInputStream
extends FilterInputStream {
    protected ByteArrayOutputStream sink;

    public synchronized int read() throws IOException {
        int n = this.in.read();
        this.sink.write(n);
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        this.sink.write(byArray, n, n3);
        return n3;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized long skip(long l) throws IOException {
        long l2 = 0L;
        int n = 0;
        byte[] byArray = new byte[1024];
        while (l2 < l) {
            n = this.read(byArray, 0, (int)Math.min((long)byArray.length, l - l2));
            if (n == -1) break;
            l2 += (long)n;
        }
        return l2;
    }

    byte[] getBytes() {
        return this.sink.toByteArray();
    }

    void resetSink() {
        this.sink.reset();
    }

    RecordingInputStream(InputStream inputStream) {
        this(inputStream, new ByteArrayOutputStream());
    }

    RecordingInputStream(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream) {
        super(inputStream);
        this.sink = byteArrayOutputStream;
    }
}

