/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.Arrays;

public final class VMID
implements Serializable {
    static final long serialVersionUID = -538642295484486218L;
    static boolean areWeUnique;
    static byte[] localAddr;
    private byte[] addr = localAddr;
    transient int hash;
    private UID uid = new UID();

    public static final boolean isUnique() {
        return areWeUnique;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            int n = 0;
            while (n < localAddr.length) {
                this.hash += this.addr[n];
                ++n;
            }
            this.hash ^= this.uid.hashCode();
        }
        return this.hash;
    }

    public final boolean equals(Object object) {
        if (object instanceof VMID) {
            VMID vMID = (VMID)object;
            boolean bl = false;
            if (this.uid.equals(vMID.uid) && Arrays.equals(this.addr, vMID.addr)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("[VMID: ");
        int n = 0;
        while (n < this.addr.length) {
            if (n > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(Integer.toString(this.addr[n]));
            ++n;
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.uid.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 127;
        byArray[3] = 1;
        byte[] byArray2 = byArray;
        try {
            localAddr = InetAddress.getLocalHost().getAddress();
            areWeUnique = Arrays.equals(byArray2, localAddr) ^ true;
        }
        catch (UnknownHostException unknownHostException) {
            localAddr = byArray2;
            areWeUnique = false;
        }
    }
}

