/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public abstract class LookAndFeel {
    public UIDefaults getDefaults() {
        return null;
    }

    public abstract String getDescription();

    public static Object getDesktopPropertyValue(String systemPropertyName, Object fallbackValue) {
        Object value = Toolkit.getDefaultToolkit().getDesktopProperty(systemPropertyName);
        return value != null ? value : fallbackValue;
    }

    public abstract String getID();

    public abstract String getName();

    public boolean getSupportsWindowDecorations() {
        return false;
    }

    public void initialize() {
    }

    public static void installBorder(JComponent c, String defaultBorderName) {
        Border b = c.getBorder();
        if (b == null || b instanceof UIResource) {
            c.setBorder(UIManager.getBorder(defaultBorderName));
        }
    }

    public static void installColors(JComponent c, String defaultBgName, String defaultFgName) {
        Color fg;
        Color bg = c.getBackground();
        if (bg == null || bg instanceof UIResource) {
            c.setBackground(UIManager.getColor(defaultBgName));
        }
        if ((fg = c.getForeground()) == null || fg instanceof UIResource) {
            c.setForeground(UIManager.getColor(defaultFgName));
        }
    }

    public static void installColorsAndFont(JComponent component, String defaultBgName, String defaultFgName, String defaultFontName) {
        LookAndFeel.installColors(component, defaultBgName, defaultFgName);
        Font f = component.getFont();
        if (f == null || f instanceof UIResource) {
            component.setFont(UIManager.getFont(defaultFontName));
        }
    }

    public abstract boolean isNativeLookAndFeel();

    public abstract boolean isSupportedLookAndFeel();

    public static void loadKeyBindings(InputMap retMap, Object[] keys) {
        if (keys == null) {
            return;
        }
        int i = 0;
        while (i < keys.length - 1) {
            Object key = keys[i];
            KeyStroke keyStroke = key instanceof KeyStroke ? (KeyStroke)key : KeyStroke.getKeyStroke((String)key);
            retMap.put(keyStroke, keys[i + 1]);
            i += 2;
        }
    }

    public static ComponentInputMap makeComponentInputMap(JComponent c, Object[] keys) {
        ComponentInputMapUIResource retMap = new ComponentInputMapUIResource(c);
        LookAndFeel.loadKeyBindings(retMap, keys);
        return retMap;
    }

    public static Object makeIcon(Class baseClass, String gifFile) {
        final URL file = baseClass.getResource(gifFile);
        return new UIDefaults.LazyValue(){

            public final Object createValue(UIDefaults table) {
                return new IconUIResource(new ImageIcon(file));
            }
        };
    }

    public static InputMap makeInputMap(Object[] keys) {
        InputMapUIResource retMap = new InputMapUIResource();
        LookAndFeel.loadKeyBindings(retMap, keys);
        return retMap;
    }

    public static JTextComponent.KeyBinding[] makeKeyBindings(Object[] keyBindingList) {
        JTextComponent.KeyBinding[] retBindings = new JTextComponent.KeyBinding[keyBindingList.length / 2];
        int i = 0;
        while (i < keyBindingList.length - 1) {
            KeyStroke stroke = keyBindingList[i] instanceof KeyStroke ? (KeyStroke)keyBindingList[i] : KeyStroke.getKeyStroke((String)keyBindingList[i]);
            retBindings[i / 2] = new JTextComponent.KeyBinding(stroke, (String)keyBindingList[i + 1]);
            i += 2;
        }
        return retBindings;
    }

    public void provideErrorFeedback(Component component) {
        Toolkit.getDefaultToolkit().beep();
    }

    public String toString() {
        return "LookAndFeel";
    }

    public void uninitialize() {
    }

    public static void uninstallBorder(JComponent c) {
        if (c.getBorder() instanceof UIResource) {
            c.setBorder(null);
        }
    }
}

