/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.event;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.dockbar.ViewPane;
import org.flexdock.dockbar.layout.DockbarLayoutManager;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.util.RootWindow;

public class ResizeListener
extends MouseAdapter
implements MouseMotionListener {
    private DockbarManager manager;
    private Dockable dockable;
    private JPanel dragGlassPane;
    private Component cachedGlassPane;
    private RootWindow rootWindow;

    public ResizeListener(DockbarManager mgr) {
        this.manager = mgr;
        this.dragGlassPane = new JPanel();
        this.dragGlassPane.setOpaque(false);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.dockable = this.manager.getActiveDockable();
        this.rootWindow = this.manager.getWindow();
        this.cachedGlassPane = this.rootWindow.getGlassPane();
        this.rootWindow.setGlassPane(this.dragGlassPane);
        this.dragGlassPane.setCursor(this.manager.getResizeCursor());
        this.dragGlassPane.setVisible(true);
        this.manager.setDragging(true);
    }

    public void mouseReleased(MouseEvent e) {
        this.dockable = null;
        this.dragGlassPane.setVisible(false);
        this.manager.setDragging(false);
        if (this.rootWindow != null && this.cachedGlassPane != null) {
            this.rootWindow.setGlassPane(this.cachedGlassPane);
            this.cachedGlassPane = null;
            this.rootWindow = null;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dockable != null) {
            this.handleResizeEvent(e);
        }
    }

    private void handleResizeEvent(MouseEvent me) {
        int dim;
        ViewPane viewPane = this.manager.getViewPane();
        Point p = SwingUtilities.convertPoint((Component)me.getSource(), me.getPoint(), viewPane.getParent());
        Rectangle viewArea = DockbarLayoutManager.getManager().getViewArea(this.manager, this.dockable);
        p.x = Math.max(p.x, 0);
        p.x = Math.min(p.x, viewArea.width);
        p.y = Math.max(p.y, 0);
        p.y = Math.min(p.y, viewArea.height);
        int orientation = this.manager.getActiveEdge();
        int loc = orientation == 2 || orientation == 4 ? p.x : p.y;
        int n = dim = orientation == 2 || orientation == 4 ? viewArea.width : viewArea.height;
        if (orientation == 4 || orientation == 3) {
            loc = dim - loc;
        }
        float percent = (float)loc / (float)dim;
        float minPercent = 20.0f / (float)dim;
        percent = Math.max(percent, minPercent);
        DockablePropertySet props = this.dockable.getDockingProperties();
        props.setPreviewSize(percent);
        this.manager.revalidate();
    }
}

