/* -*- Mode: C; c-file-style: "gnu" -*-
   exceptions.h -- functions for dealing with exceptions in the interpreter.
   Created: Chris Toshok <toshok@hungry.com>
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1999, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef EXCEPTIONS_H
#define EXCEPTIONS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "objects.h"
#include "interp.h"
#include "jni.h"

  typedef struct BackTraceLevel {
    char *classname;
    MethodStruct *method;
    char *filename;
    u2 pc;
    struct BackTraceLevel *prev;
    struct BackTraceLevel *next;
  } BackTraceLevel;

  /* data associated with all thrown exceptions (using the NSA_ interface) */
  typedef struct {
    BackTraceLevel *head;
    BackTraceLevel *tail;
  } ExceptionInfo;

  void interp_athrow(StackFrame *f);

  void cleanup_exception(JNIEnv *env, japhar_obj exception);
  void throw_exception(JNIEnv *env, japhar_obj exception, StackFrame *f);
  void print_exception_backtrace(JNIEnv *env, japhar_obj throwable_ref);
  void toplevel_exception_handler(JNIEnv *env, japhar_obj throwable_ref);
  int method_pc_to_line_number(JNIEnv *env, MethodStruct *method, u2 pc);
  void fill_in_backtrace_from_stack(JNIEnv *env, japhar_obj throwable_ref);

  /* in abort.c:  used to offer a java stacktrace on fatal signals. */
  void fatal_signal_handler(int);

  /*
   * This should be used by all runtime methods to throw an exception.
   * NULL == msg is accepted.
   */
  void throw_Exception(JNIEnv *env, const char *exception_name, const char *msg);

#ifdef __cplusplus
};
#endif

#endif /* EXCEPTIONS_h */
