--
-- (C) 2020-24 - ntop.org
--

-- https://vulners.com/

local vs_module = {}

package.path = dirs.installdir .. "/scripts/lua/modules/vulnerability_scan/?.lua;" .. package.path
local vs_utils = require("vs_utils")

-- ##############################################

function vs_module:new()
   local obj = { name = "vulners" }

   setmetatable(obj, self)
   self.__index = self

   return obj
end

-- ##############################################

function vs_module:is_enabled()
   return(vs_utils.is_nmap_installed())
end

-- ##############################################

-- NOTE: ports are comma separated (e.g 80,443)

function vs_module:scan_host(host_ip, ports, use_coroutines, cidr)
   local nmap    = vs_utils.get_nmap_path()
   local command = nmap.." -sV --script=vulscan/vulscan.nse" -- <target> -p 80,233
   local is_up, scan_duration, start_scan, end_scan = vs_utils.nmap_check_host(host_ip, use_coroutines)
   if (is_up) then
      local now,result,duration,scan_result,num_open_ports,num_vulnerabilities_found, cve, udp_ports, tcp_ports = vs_utils.nmap_scan_host(command, host_ip, ports, use_coroutines, self.name)
      return now,result,duration,scan_result,num_open_ports,num_vulnerabilities_found, cve, udp_ports, tcp_ports, nil -- [[discovred_hosts]]
   end
   return start_scan,i18n("hosts_stats.page_scan_hosts.host_is_not_up_and_running"),scan_duration,vs_utils.scan_status.failed,0,0,{},{},{}, nil-- [[discovred_hosts]]

end

-- ##############################################

return vs_module

