/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.sablecc.sablecc.AlternativeElementTypes;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.ComputeCGNomenclature;
import org.sablecc.sablecc.ComputeInlining;
import org.sablecc.sablecc.ComputeSimpleTermPosition;
import org.sablecc.sablecc.ConflictException;
import org.sablecc.sablecc.ConstructParserGenerationDatas;
import org.sablecc.sablecc.ConstructProdsMap;
import org.sablecc.sablecc.GenerateAlternativeCodeForParser;
import org.sablecc.sablecc.Grammar;
import org.sablecc.sablecc.IntegerCast;
import org.sablecc.sablecc.IntegerComparator;
import org.sablecc.sablecc.InternalTransformationsToGrammar;
import org.sablecc.sablecc.LR0Collection;
import org.sablecc.sablecc.ListCast;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.PrettyPrinter;
import org.sablecc.sablecc.Production;
import org.sablecc.sablecc.ResolveAltIds;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.ResolveTransformIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.StringComparator;
import org.sablecc.sablecc.Symbol;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.TypedTreeMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AAst;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AHelperDef;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.PAlt;
import org.sablecc.sablecc.node.Start;

public class GenParser
extends DepthFirstAdapter {
    InternalTransformationsToGrammar bnf_and_CST_AST_Transformations;
    ConstructParserGenerationDatas genParserAdapter;
    private MacroExpander macros;
    private ResolveIds ids;
    private ResolveAltIds altIds;
    private ResolveTransformIds transformIds;
    private AlternativeElementTypes AET;
    private ComputeCGNomenclature CG;
    private ComputeSimpleTermPosition CTP;
    private File pkgDir;
    private String pkgName;
    private boolean hasProductions;
    private String firstProductionName;
    private boolean processInlining;
    private boolean prettyPrinting;
    private boolean grammarHasTransformations;
    private boolean activateFilter = true;
    GenerateAlternativeCodeForParser aParsedAltAdapter;
    private LinkedList listSimpleTermTransform = new LinkedList();
    public final Map simpleTermTransform = new TypedHashMap(NodeCast.instance, StringCast.instance);
    private final Map mapProductionTransformations = new TypedHashMap(StringCast.instance, ListCast.instance);
    private Map alts;
    private String currentProd;
    private String currentAlt;

    public GenParser(ResolveIds ids, ResolveAltIds altIds, ResolveTransformIds transformIds, String firstProductionName, boolean processInlining, boolean prettyPrinting, boolean grammarHasTransformations) {
        this.ids = ids;
        this.altIds = altIds;
        this.transformIds = transformIds;
        this.processInlining = processInlining;
        this.prettyPrinting = prettyPrinting;
        this.grammarHasTransformations = grammarHasTransformations;
        this.AET = new AlternativeElementTypes(ids);
        this.CG = new ComputeCGNomenclature(ids, transformIds.getProdTransformIds());
        this.CTP = new ComputeSimpleTermPosition(ids);
        this.firstProductionName = firstProductionName;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("parser.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to open parser.txt.");
        }
        this.pkgDir = new File(ids.pkgDir, "parser");
        String string = this.pkgName = ids.pkgName.equals("") ? "parser" : ids.pkgName + ".parser";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    @Override
    public void caseStart(Start tree) {
        tree.getPGrammar().apply(new DepthFirstAdapter(){

            @Override
            public void caseAProd(AProd node) {
                GenParser.this.hasProductions = true;
                if (node.getProdTransform() != null) {
                    GenParser.this.mapProductionTransformations.put("P" + ResolveIds.name(node.getId().getText()), node.getProdTransform().clone());
                }
            }
        });
        if (!this.hasProductions) {
            return;
        }
        this.bnf_and_CST_AST_Transformations = new InternalTransformationsToGrammar(this.ids, this.altIds, this.transformIds, this.listSimpleTermTransform, this.simpleTermTransform, this.mapProductionTransformations, this.transformIds.simpleTermOrsimpleListTermTypes);
        tree.getPGrammar().apply(this.bnf_and_CST_AST_Transformations);
        if (this.prettyPrinting) {
            tree.apply(new PrettyPrinter());
            return;
        }
        ConstructProdsMap mapOfProds = new ConstructProdsMap();
        tree.apply(mapOfProds);
        boolean computeLALR = false;
        do {
            this.reinit();
            this.reConstructSymbolTables(tree);
            tree.apply(new DepthFirstAdapter(){
                private boolean hasAlternative;

                @Override
                public void caseATokenDef(ATokenDef node) {
                    String name = (String)((GenParser)GenParser.this).ids.names.get(node);
                    String errorName = (String)((GenParser)GenParser.this).ids.errorNames.get(node);
                    if (!((GenParser)GenParser.this).ids.ignTokens.containsKey(name)) {
                        Grammar.addTerminal(name, errorName);
                    }
                }

                @Override
                public void inAProd(AProd node) {
                    this.hasAlternative = false;
                }

                @Override
                public void inAAlt(AAlt node) {
                    this.hasAlternative = true;
                }

                @Override
                public void outAProd(AProd node) {
                    if (this.hasAlternative) {
                        Grammar.addNonterminal((String)((GenParser)GenParser.this).ids.names.get(node));
                    }
                }
            });
            this.alts = new TypedHashMap(StringCast.instance, NodeCast.instance);
            tree.getPGrammar().apply(new ConstructParserGenerationDatas(this.ids, this.alts));
            try {
                Grammar.computeLALR();
                computeLALR = true;
            }
            catch (ConflictException ce) {
                if (this.activateFilter) {
                    this.activateFilter = false;
                }
                if (this.processInlining) {
                    ComputeInlining grammarToBeInlinedWithConflictualProductions = new ComputeInlining(ce.getConflictualProductions(), mapOfProds.productionsMap, tree);
                    if (!grammarToBeInlinedWithConflictualProductions.computeInlining()) {
                        System.out.println("\nA previous conflict that we've tried to solve by inline some productions inside the grammars cannot be solved that way. The transformed grammar is : ");
                        tree.apply(new PrettyPrinter());
                        throw new RuntimeException(ce.getMessage());
                    }
                    System.out.println();
                    System.out.println("Inlining.");
                    continue;
                }
                throw new RuntimeException(ce.getMessage());
            }
        } while (!computeLALR);
        tree.getPGrammar().apply(this.AET);
        this.CG.setAltElemTypes(this.AET.getMapOfAltElemType());
        tree.getPGrammar().apply(this.CG);
        tree.getPGrammar().apply(this.CTP);
        this.createParser();
        this.createParserException();
        this.createState();
        this.createTokenIndex();
    }

    public void reinit() {
        LR0Collection.reinit();
        Symbol.reinit();
        Production.reinit();
        Grammar.reinit();
        this.ids.reinit();
    }

    public void reConstructSymbolTables(Start tree) {
        tree.apply(new DepthFirstAdapter(){

            @Override
            public void caseAProd(AProd node) {
                GenParser.this.currentProd = ResolveIds.name(node.getId().getText());
                String name = "P" + GenParser.this.currentProd;
                ((GenParser)GenParser.this).ids.names.put(node, name);
                Object[] list_alt = node.getAlts().toArray();
                for (int i = 0; i < list_alt.length; ++i) {
                    ((PAlt)list_alt[i]).apply(this);
                }
            }

            @Override
            public void outAHelperDef(AHelperDef node) {
                String name = node.getId().getText();
                ((GenParser)GenParser.this).ids.names.put(node, name);
            }

            @Override
            public void outATokenDef(ATokenDef node) {
                String name = "T" + ResolveIds.name(node.getId().getText());
                ((GenParser)GenParser.this).ids.names.put(node, name);
            }

            @Override
            public void caseAAlt(AAlt alt) {
                if (alt.getAltName() != null) {
                    GenParser.this.currentAlt = "A" + ResolveIds.name(alt.getAltName().getText()) + GenParser.this.currentProd;
                    ((GenParser)GenParser.this).ids.names.put(alt, GenParser.this.currentAlt);
                } else {
                    GenParser.this.currentAlt = "A" + GenParser.this.currentProd;
                    ((GenParser)GenParser.this).ids.names.put(alt, GenParser.this.currentAlt);
                }
                AElem[] list_elem = alt.getElems().toArray(new AElem[0]);
                for (int i = 0; i < list_elem.length; ++i) {
                    list_elem[i].apply(this);
                }
            }

            @Override
            public void caseAAst(AAst node) {
            }

            @Override
            public void caseAElem(AElem elem) {
                if (elem.getElemName() != null) {
                    ((GenParser)GenParser.this).ids.names.put(elem, ResolveIds.name(elem.getElemName().getText()));
                } else {
                    ((GenParser)GenParser.this).ids.names.put(elem, ResolveIds.name(elem.getId().getText()));
                }
            }
        });
    }

    private void createParser() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Parser.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Parser.java").getAbsolutePath());
        }
        try {
            Vector innerArray;
            int i;
            Symbol[] nonterminals = Symbol.nonterminals();
            Production[] productions = Production.productions();
            this.macros.apply(file, "ParserHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "lexer" : this.ids.pkgName + ".lexer", this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node", this.ids.pkgName.equals("") ? "analysis" : this.ids.pkgName + ".analysis"});
            if (this.activateFilter && !this.grammarHasTransformations) {
                this.macros.apply(file, "ParserNoInliningPushHeader");
                this.macros.apply(file, "ParserCommon", new String[]{", true", ", false"});
            } else {
                this.macros.apply(file, "ParserInliningPushHeader");
                this.macros.apply(file, "ParserCommon", new String[]{"", ""});
            }
            for (i = 500; i < productions.length - 1; i += 500) {
                this.macros.apply(file, "ParseReduceElseIf", new String[]{"" + (i + 500), "" + i});
            }
            this.macros.apply(file, "ParserParseTail", new String[]{this.firstProductionName});
            this.macros.apply(file, "ParserReduceHead", new String[]{"0"});
            for (i = 0; i < productions.length - 1; ++i) {
                if (i % 500 == 0 && i != 0) {
                    this.macros.apply(file, "ParserReduceTail", new String[0]);
                    this.macros.apply(file, "ParserReduceHead", new String[]{"" + i});
                }
                if (this.activateFilter && !this.grammarHasTransformations) {
                    this.macros.apply(file, "ParserNoInliningReduce", new String[]{"" + productions[i].index, "" + productions[i].leftside, "" + (productions[i].name.startsWith("ANonTerminal$") || productions[i].name.startsWith("ATerminal$")), productions[i].name});
                    continue;
                }
                this.macros.apply(file, "ParserInliningReduce", new String[]{"" + productions[i].index, "" + productions[i].leftside, productions[i].name});
            }
            this.macros.apply(file, "ParserReduceTail", new String[0]);
            for (i = 0; i < productions.length - 1; ++i) {
                this.macros.apply(file, "ParserNewHeader", new String[]{"" + productions[i].index, productions[i].name});
                Node node = (Node)this.alts.get(productions[i].name);
                final LinkedList stack = new LinkedList();
                node.apply(new DepthFirstAdapter(){
                    private int current;

                    @Override
                    public void caseAElem(AElem elem) {
                        ++this.current;
                        stack.addFirst(new Element("ParserNewBodyDecl", new String[]{"" + this.current}));
                    }
                });
                try {
                    for (Element e : stack) {
                        this.macros.apply(file, e.macro, e.arguments);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Parser.java").getAbsolutePath());
                }
                String nodeName = (String)this.ids.names.get(node);
                String realnodeName = (String)this.ids.names.get(node);
                this.aParsedAltAdapter = new GenerateAlternativeCodeForParser(this.pkgDir, nodeName, realnodeName, file, this.transformIds, this.CG, this.CTP, this.simpleTermTransform, this.macros, this.listSimpleTermTransform, this.transformIds.simpleTermOrsimpleListTermTypes);
                node.apply(this.aParsedAltAdapter);
            }
            this.macros.apply(file, "ParserActionHeader");
            StringBuffer table = new StringBuffer();
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.pkgDir, "parser.dat"))));
            Vector<Object> outerArray = new Vector<Object>();
            for (int i2 = 0; i2 < Grammar.action_.length; ++i2) {
                int j;
                innerArray = new Vector();
                String mostFrequentAction = "ERROR";
                int mostFrequentDestination = i2;
                int frequence = 0;
                TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>(IntegerComparator.instance);
                for (j = 0; j < Grammar.action_[i2].length; ++j) {
                    if (Grammar.action_[i2][j] == null || Grammar.action_[i2][j][0] != 1) continue;
                    Integer index = new Integer(Grammar.action_[i2][j][1]);
                    Integer count = (Integer)map.get(index);
                    int freq = count == null ? 0 : count;
                    map.put(index, new Integer(++freq));
                    if (freq <= frequence) continue;
                    frequence = freq;
                    mostFrequentAction = "REDUCE";
                    mostFrequentDestination = Grammar.action_[i2][j][1];
                }
                table.append("\t\t\t{");
                table.append("{-1, " + mostFrequentAction + ", " + mostFrequentDestination + "}, ");
                innerArray.addElement(new int[]{-1, mostFrequentAction.equals("ERROR") ? 3 : 1, mostFrequentDestination});
                block19: for (j = 0; j < Grammar.action_[i2].length; ++j) {
                    if (Grammar.action_[i2][j] == null) continue;
                    switch (Grammar.action_[i2][j][0]) {
                        case 0: {
                            table.append("{" + j + ", SHIFT, " + Grammar.action_[i2][j][1] + "}, ");
                            innerArray.addElement(new int[]{j, 0, Grammar.action_[i2][j][1]});
                            continue block19;
                        }
                        case 1: {
                            if (Grammar.action_[i2][j][1] == mostFrequentDestination) continue block19;
                            table.append("{" + j + ", REDUCE, " + Grammar.action_[i2][j][1] + "}, ");
                            innerArray.addElement(new int[]{j, 1, Grammar.action_[i2][j][1]});
                            continue block19;
                        }
                        case 2: {
                            table.append("{" + j + ", ACCEPT, -1}, ");
                            innerArray.addElement(new int[]{j, 2, -1});
                        }
                    }
                }
                table.append("}," + System.getProperty("line.separator"));
                outerArray.addElement(innerArray);
            }
            file.write("" + table);
            out.writeInt(outerArray.size());
            Enumeration e = outerArray.elements();
            while (e.hasMoreElements()) {
                innerArray = (Vector)e.nextElement();
                out.writeInt(innerArray.size());
                Enumeration n = innerArray.elements();
                while (n.hasMoreElements()) {
                    int[] array = (int[])n.nextElement();
                    for (int i3 = 0; i3 < 3; ++i3) {
                        out.writeInt(array[i3]);
                    }
                }
            }
            this.macros.apply(file, "ParserActionTail");
            this.macros.apply(file, "ParserGotoHeader");
            table = new StringBuffer();
            outerArray = new Vector();
            for (int j = 0; j < nonterminals.length - 1; ++j) {
                int i4;
                innerArray = new Vector();
                int mostFrequent = -1;
                int frequence = 0;
                TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>(IntegerComparator.instance);
                for (i4 = 0; i4 < Grammar.goto_.length; ++i4) {
                    if (Grammar.goto_[i4][j] == -1) continue;
                    Integer index = new Integer(Grammar.goto_[i4][j]);
                    Integer count = (Integer)map.get(index);
                    int freq = count == null ? 0 : count;
                    map.put(index, new Integer(++freq));
                    if (freq <= frequence) continue;
                    frequence = freq;
                    mostFrequent = Grammar.goto_[i4][j];
                }
                table.append("\t\t\t{");
                table.append("{-1, " + mostFrequent + "}, ");
                innerArray.addElement(new int[]{-1, mostFrequent});
                for (i4 = 0; i4 < Grammar.goto_.length; ++i4) {
                    if (Grammar.goto_[i4][j] == -1 || Grammar.goto_[i4][j] == mostFrequent) continue;
                    table.append("{" + i4 + ", " + Grammar.goto_[i4][j] + "}, ");
                    innerArray.addElement(new int[]{i4, Grammar.goto_[i4][j]});
                }
                table.append("}," + System.getProperty("line.separator"));
                outerArray.addElement(innerArray);
            }
            file.write("" + table);
            out.writeInt(outerArray.size());
            e = outerArray.elements();
            while (e.hasMoreElements()) {
                innerArray = (Vector)e.nextElement();
                out.writeInt(innerArray.size());
                Enumeration n = innerArray.elements();
                while (n.hasMoreElements()) {
                    int[] array = (int[])n.nextElement();
                    for (int i5 = 0; i5 < 2; ++i5) {
                        out.writeInt(array[i5]);
                    }
                }
            }
            this.macros.apply(file, "ParserGotoTail");
            this.macros.apply(file, "ParserErrorsHeader");
            table = new StringBuffer();
            StringBuffer index = new StringBuffer();
            int nextIndex = 0;
            TypedTreeMap errorIndex = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)IntegerCast.instance);
            outerArray = new Vector();
            Vector<Object> indexArray = new Vector<Object>();
            index.append("\t\t\t");
            for (int i6 = 0; i6 < Grammar.action_.length; ++i6) {
                StringBuffer s = new StringBuffer();
                s.append("expecting: ");
                boolean comma = false;
                for (int j = 0; j < Grammar.action_[i6].length; ++j) {
                    if (Grammar.action_[i6][j] == null) continue;
                    if (comma) {
                        s.append(", ");
                    } else {
                        comma = true;
                    }
                    s.append(Symbol.symbol((int)j, (boolean)true).errorName);
                }
                if (errorIndex.containsKey(s.toString())) {
                    index.append(errorIndex.get(s.toString()) + ", ");
                    indexArray.addElement(errorIndex.get(s.toString()));
                    continue;
                }
                table.append("\t\t\t\"" + s + "\"," + System.getProperty("line.separator"));
                outerArray.addElement(s.toString());
                errorIndex.put(s.toString(), new Integer(nextIndex));
                indexArray.addElement(new Integer(nextIndex));
                index.append(nextIndex++ + ", ");
            }
            file.write("" + table);
            out.writeInt(outerArray.size());
            Enumeration e2 = outerArray.elements();
            while (e2.hasMoreElements()) {
                String s = (String)e2.nextElement();
                out.writeInt(s.length());
                int length = s.length();
                for (int i7 = 0; i7 < length; ++i7) {
                    out.writeChar(s.charAt(i7));
                }
            }
            out.writeInt(indexArray.size());
            e2 = indexArray.elements();
            while (e2.hasMoreElements()) {
                Integer n = (Integer)e2.nextElement();
                out.writeInt(n);
            }
            out.close();
            this.macros.apply(file, "ParserErrorsTail");
            this.macros.apply(file, "ParserErrorIndexHeader");
            file.write("" + index);
            this.macros.apply(file, "ParserErrorIndexTail");
            this.macros.apply(file, "ParserTail");
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Parser.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createTokenIndex() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "TokenIndex.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "TokenIndex.java").getAbsolutePath());
        }
        try {
            Symbol[] terminals = Symbol.terminals();
            this.macros.apply(file, "TokenIndexHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node", this.ids.pkgName.equals("") ? "analysis" : this.ids.pkgName + ".analysis"});
            for (int i = 0; i < terminals.length - 2; ++i) {
                this.macros.apply(file, "TokenIndexBody", new String[]{terminals[i].name, "" + i});
            }
            this.macros.apply(file, "TokenIndexTail", new String[]{"" + (terminals.length - 2)});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "TokenIndex.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createParserException() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "ParserException.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "ParserException.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "ParserException", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node"});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "ParserException.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createState() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "State.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "State.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "State", new String[]{this.pkgName});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "State.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class Element {
        String macro;
        String[] arguments;

        Element(String macro, String[] arguments) {
            this.macro = macro;
            this.arguments = arguments;
        }
    }
}

