from pytable.schemabuilder import *
schema = table(
	"my_table",
	comment = """Table for storing whatevers""",
	fields = (
		field(
			'mandatoryVar1', 'integer',0, # name, sql data-type, size
			constraints = (
				notNull(),
			),
		),
		field(
			'defaultVal1', 'integer',0, # name, sql data-type, size
			defaultValue = 32, # sql default value
			constraints = (
				notNull(),
			),
		),
		field(
			'Var2', 'timestamptz',0, # name, sql data-type, size
			defaultValue = '"timestamp"(\'now\'::text)', # sql default value
			constraints = (
				notNull(),
			),
		),
	),
	indices = (
		index( primary=1, fields=('mandatoryVar1', 'defaultVal1')),
	),
)

print schema.itemClass
help( schema.itemClass )
