/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.text.AttributedFormatBuffer;
import gnu.java.text.FormatBuffer;
import gnu.java.text.FormatCharacterIterator;
import gnu.java.text.StringFormatBuffer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DecimalFormat
extends NumberFormat {
    private static final int MAXIMUM_INTEGER_DIGITS = 309;
    private static final long serialVersionUID = 864413376551465018L;
    private static final DecimalFormatSymbols nonLocalizedSymbols = new DecimalFormatSymbols(Locale.US);
    private boolean decimalSeparatorAlwaysShown;
    private byte groupingSize;
    private byte minExponentDigits;
    private int exponentRound;
    private int multiplier;
    private String negativePrefix;
    private String negativeSuffix;
    private String positivePrefix;
    private String positiveSuffix;
    private int[] negativePrefixRanges;
    private int[] positivePrefixRanges;
    private HashMap[] negativePrefixAttrs;
    private HashMap[] positivePrefixAttrs;
    private int[] negativeSuffixRanges;
    private int[] positiveSuffixRanges;
    private HashMap[] negativeSuffixAttrs;
    private HashMap[] positiveSuffixAttrs;
    private int serialVersionOnStream;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation;

    private final int scanFix(String pattern2, int index, FormatBuffer buf, String patChars, DecimalFormatSymbols syms, boolean is_suffix) {
        int len = pattern2.length();
        boolean quoteStarted = false;
        buf.clear();
        boolean multiplierSet = false;
        while (index < len) {
            char c = pattern2.charAt(index);
            if (quoteStarted) {
                if (c == '\'') {
                    quoteStarted = false;
                } else {
                    buf.append(c);
                }
                ++index;
                continue;
            }
            if (c == '\'' && index + 1 < len && pattern2.charAt(index + 1) == '\'') {
                buf.append(c);
                ++index;
            } else if (c == '\'') {
                quoteStarted = true;
            } else if (c == '\u00a4') {
                buf.append(c);
            } else if (c == syms.getPercent()) {
                if (multiplierSet) {
                    throw new IllegalArgumentException("multiplier already set - index: " + index);
                }
                multiplierSet = true;
                this.multiplier = 100;
                buf.append(c, (AttributedCharacterIterator.Attribute)NumberFormat.Field.PERCENT);
            } else if (c == syms.getPerMill()) {
                if (multiplierSet) {
                    throw new IllegalArgumentException("multiplier already set - index: " + index);
                }
                multiplierSet = true;
                this.multiplier = 1000;
                buf.append(c, (AttributedCharacterIterator.Attribute)NumberFormat.Field.PERMILLE);
            } else {
                if (patChars.indexOf(c) != -1) break;
                buf.append(c);
            }
            ++index;
        }
        if (quoteStarted) {
            throw new IllegalArgumentException("pattern is lacking a closing quote");
        }
        return index;
    }

    private final int scanFormat(String pattern2, int index, String patChars, DecimalFormatSymbols syms, boolean is_positive) {
        char c;
        int max = pattern2.length();
        int countSinceGroup = 0;
        int zeroCount = 0;
        boolean saw_group = false;
        while (index < max) {
            c = pattern2.charAt(index);
            if (c == syms.getDigit()) {
                if (zeroCount > 0) {
                    throw new IllegalArgumentException("digit mark following zero - index: " + index);
                }
                ++countSinceGroup;
            } else if (c == syms.getZeroDigit()) {
                ++zeroCount;
                ++countSinceGroup;
            } else {
                if (c != syms.getGroupingSeparator()) break;
                countSinceGroup = 0;
                saw_group = true;
            }
            ++index;
        }
        if (is_positive) {
            this.groupingUsed = saw_group;
            this.groupingSize = (byte)countSinceGroup;
            this.minimumIntegerDigits = zeroCount;
        }
        if (index == max || pattern2.charAt(index) == syms.getGroupingSeparator()) {
            if (is_positive) {
                this.decimalSeparatorAlwaysShown = false;
            }
            return index;
        }
        if (pattern2.charAt(index) == syms.getDecimalSeparator()) {
            ++index;
            int hashCount = 0;
            zeroCount = 0;
            while (index < max) {
                char c2 = pattern2.charAt(index);
                if (c2 == syms.getZeroDigit()) {
                    if (hashCount > 0) {
                        throw new IllegalArgumentException("zero mark following digit - index: " + index);
                    }
                    ++zeroCount;
                } else if (c2 == syms.getDigit()) {
                    ++hashCount;
                } else {
                    if (c2 == syms.getExponential() || c2 == syms.getPatternSeparator() || c2 == syms.getPercent() || c2 == syms.getPerMill() || patChars.indexOf(c2) == -1) break;
                    throw new IllegalArgumentException("unexpected special character - index: " + index);
                }
                ++index;
            }
            if (is_positive) {
                this.maximumFractionDigits = hashCount + zeroCount;
                this.minimumFractionDigits = zeroCount;
            }
            if (index == max) {
                return index;
            }
        }
        if (pattern2.charAt(index) == syms.getExponential()) {
            zeroCount = 0;
            ++index;
            while (index < max) {
                c = pattern2.charAt(index);
                if (c == syms.getZeroDigit()) {
                    ++zeroCount;
                } else if (c == syms.getDigit()) {
                    if (zeroCount > 0) {
                        throw new IllegalArgumentException("digit mark following zero in exponent - index: " + index);
                    }
                } else {
                    if (patChars.indexOf(c) == -1) break;
                    throw new IllegalArgumentException("unexpected special character - index: " + index);
                }
                ++index;
            }
            if (is_positive) {
                this.useExponentialNotation = true;
                this.minExponentDigits = (byte)zeroCount;
            }
            this.maximumIntegerDigits = this.groupingSize;
            this.groupingSize = 0;
            if (this.maximumIntegerDigits > this.minimumIntegerDigits && this.maximumIntegerDigits > 0) {
                this.minimumIntegerDigits = 1;
                this.exponentRound = this.maximumIntegerDigits;
            } else {
                this.exponentRound = 1;
            }
        }
        return index;
    }

    private final String patternChars(DecimalFormatSymbols syms) {
        StringBuffer buf = new StringBuffer();
        buf.append(syms.getDecimalSeparator());
        buf.append(syms.getDigit());
        buf.append(syms.getExponential());
        buf.append(syms.getGroupingSeparator());
        buf.append(syms.getPatternSeparator());
        buf.append(syms.getPercent());
        buf.append(syms.getPerMill());
        buf.append(syms.getZeroDigit());
        buf.append('\u00a4');
        return buf.toString();
    }

    private final void applyPatternWithSymbols(String pattern2, DecimalFormatSymbols syms) {
        this.negativePrefix = "";
        this.negativeSuffix = "";
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.decimalSeparatorAlwaysShown = false;
        this.groupingSize = 0;
        this.minExponentDigits = 0;
        this.multiplier = 1;
        this.useExponentialNotation = false;
        this.groupingUsed = false;
        this.maximumFractionDigits = 0;
        this.maximumIntegerDigits = 309;
        this.minimumFractionDigits = 0;
        this.minimumIntegerDigits = 1;
        AttributedFormatBuffer buf = new AttributedFormatBuffer();
        String patChars = this.patternChars(syms);
        int max = pattern2.length();
        int index = this.scanFix(pattern2, 0, buf, patChars, syms, false);
        buf.sync();
        this.positivePrefix = buf.getBuffer().toString();
        this.positivePrefixRanges = buf.getRanges();
        this.positivePrefixAttrs = buf.getAttributes();
        index = this.scanFormat(pattern2, index, patChars, syms, true);
        index = this.scanFix(pattern2, index, buf, patChars, syms, true);
        buf.sync();
        this.positiveSuffix = buf.getBuffer().toString();
        this.positiveSuffixRanges = buf.getRanges();
        this.positiveSuffixAttrs = buf.getAttributes();
        if (index == pattern2.length()) {
            this.negativePrefix = null;
            this.negativeSuffix = null;
        } else {
            if (pattern2.charAt(index) != syms.getPatternSeparator()) {
                throw new IllegalArgumentException("separator character expected - index: " + index);
            }
            index = this.scanFix(pattern2, index + 1, buf, patChars, syms, false);
            buf.sync();
            this.negativePrefix = buf.getBuffer().toString();
            this.negativePrefixRanges = buf.getRanges();
            this.negativePrefixAttrs = buf.getAttributes();
            index = this.scanFormat(pattern2, index, patChars, syms, false);
            index = this.scanFix(pattern2, index, buf, patChars, syms, true);
            buf.sync();
            this.negativeSuffix = buf.getBuffer().toString();
            this.negativeSuffixRanges = buf.getRanges();
            this.negativeSuffixAttrs = buf.getAttributes();
            if (index != pattern2.length()) {
                throw new IllegalArgumentException("end of pattern expected - index: " + index);
            }
        }
    }

    public void applyLocalizedPattern(String pattern2) {
        this.applyPatternWithSymbols(pattern2, this.symbols);
    }

    public void applyPattern(String pattern2) {
        this.applyPatternWithSymbols(pattern2, nonLocalizedSymbols);
    }

    public Object clone() {
        DecimalFormat c = (DecimalFormat)super.clone();
        c.symbols = (DecimalFormatSymbols)this.symbols.clone();
        return c;
    }

    private final boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            boolean bl = false;
            if (s1 == s2) {
                bl = true;
            }
            return bl;
        }
        return s1.equals(s2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat dup = (DecimalFormat)obj;
        boolean bl = false;
        if (this.decimalSeparatorAlwaysShown == dup.decimalSeparatorAlwaysShown && this.groupingUsed == dup.groupingUsed && this.groupingSize == dup.groupingSize && this.multiplier == dup.multiplier && this.useExponentialNotation == dup.useExponentialNotation && this.minExponentDigits == dup.minExponentDigits && this.minimumIntegerDigits == dup.minimumIntegerDigits && this.maximumIntegerDigits == dup.maximumIntegerDigits && this.minimumFractionDigits == dup.minimumFractionDigits && this.maximumFractionDigits == dup.maximumFractionDigits && this.equals(this.negativePrefix, dup.negativePrefix) && this.equals(this.negativeSuffix, dup.negativeSuffix) && this.equals(this.positivePrefix, dup.positivePrefix) && this.equals(this.positiveSuffix, dup.positiveSuffix) && this.symbols.equals(dup.symbols)) {
            bl = true;
        }
        return bl;
    }

    private final void formatInternal(double number, FormatBuffer dest, FieldPosition fieldPos) {
        boolean is_neg;
        if (Double.isNaN(number)) {
            dest.append(this.symbols.getNaN());
            if (fieldPos != null && (fieldPos.getField() == 0 || fieldPos.getFieldAttribute() == NumberFormat.Field.INTEGER)) {
                int index = dest.length();
                fieldPos.setBeginIndex(index - this.symbols.getNaN().length());
                fieldPos.setEndIndex(index);
            }
            return;
        }
        boolean bl = false;
        if (number < 0.0) {
            bl = true;
        }
        if (is_neg = bl) {
            if (this.negativePrefix != null) {
                dest.append(this.substituteCurrency(this.negativePrefix, number), this.negativePrefixRanges, this.negativePrefixAttrs);
            } else {
                dest.append(this.symbols.getMinusSign(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.SIGN);
                dest.append(this.substituteCurrency(this.positivePrefix, number), this.positivePrefixRanges, this.positivePrefixAttrs);
            }
            number = -number;
        } else {
            dest.append(this.substituteCurrency(this.positivePrefix, number), this.positivePrefixRanges, this.positivePrefixAttrs);
        }
        int integerBeginIndex = dest.length();
        int integerEndIndex = 0;
        int zeroStart = this.symbols.getZeroDigit() - 48;
        if (Double.isInfinite(number)) {
            dest.append(this.symbols.getInfinity());
            integerEndIndex = dest.length();
        } else {
            double fracPart;
            double baseNumber;
            number *= (double)this.multiplier;
            long exponent = 0L;
            if (this.useExponentialNotation) {
                exponent = (long)Math.floor(Math.log(number) / Math.log(10.0));
                exponent -= exponent % (long)this.exponentRound;
                if (this.minimumIntegerDigits > 0) {
                    exponent -= (long)(this.minimumIntegerDigits - 1);
                }
                baseNumber = number / Math.pow(10.0, exponent);
            } else {
                baseNumber = number;
            }
            int index = dest.length();
            String intPart = Long.toString((long)Math.floor(baseNumber += (double)5 * Math.pow(10.0, -this.maximumFractionDigits - 1)));
            int groupPosition = intPart.length();
            dest.setDefaultAttribute(NumberFormat.Field.INTEGER);
            int count = 0;
            while (count < this.minimumIntegerDigits - intPart.length()) {
                dest.append(this.symbols.getZeroDigit());
                ++count;
            }
            count = 0;
            while (count < this.maximumIntegerDigits && count < intPart.length()) {
                char dig = intPart.charAt(count);
                if (this.groupingUsed && count > 0 && this.groupingSize != 0 && groupPosition % this.groupingSize == 0) {
                    dest.append(this.symbols.getGroupingSeparator(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.GROUPING_SEPARATOR);
                    dest.setDefaultAttribute(NumberFormat.Field.INTEGER);
                }
                dest.append((char)(zeroStart + dig));
                --groupPosition;
                ++count;
            }
            dest.setDefaultAttribute(null);
            int decimal_index = integerEndIndex = dest.length();
            int consecutive_zeros = 0;
            int total_digits = 0;
            int localMaximumFractionDigits = this.maximumFractionDigits;
            if (this.useExponentialNotation) {
                localMaximumFractionDigits += this.minimumIntegerDigits - count;
            }
            if (((fracPart = baseNumber - Math.floor(baseNumber)) != 0.0 || this.minimumFractionDigits > 0) && localMaximumFractionDigits > 0 || this.decimalSeparatorAlwaysShown) {
                dest.append(this.symbols.getDecimalSeparator(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.DECIMAL_SEPARATOR);
            }
            int fraction_begin = dest.length();
            dest.setDefaultAttribute(NumberFormat.Field.FRACTION);
            count = 0;
            while (count < localMaximumFractionDigits && (fracPart != 0.0 || count < this.minimumFractionDigits)) {
                ++total_digits;
                long dig = (long)(fracPart *= 10.0);
                consecutive_zeros = dig == 0L ? ++consecutive_zeros : 0;
                dest.append((char)((long)this.symbols.getZeroDigit() + dig));
                fracPart -= Math.floor(fracPart);
                ++count;
            }
            int extra_zeros = Math.min(consecutive_zeros, total_digits - this.minimumFractionDigits);
            if (extra_zeros > 0) {
                dest.cutTail(extra_zeros);
                if ((total_digits -= extra_zeros) == 0 && !this.decimalSeparatorAlwaysShown) {
                    dest.cutTail(1);
                }
            }
            if (fieldPos != null && fieldPos.getField() == 1) {
                fieldPos.setBeginIndex(fraction_begin);
                fieldPos.setEndIndex(dest.length());
            }
            if (this.useExponentialNotation) {
                dest.append(this.symbols.getExponential(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.EXPONENT_SYMBOL);
                if (exponent < 0L) {
                    dest.append(this.symbols.getMinusSign(), (AttributedCharacterIterator.Attribute)NumberFormat.Field.EXPONENT_SIGN);
                    exponent = -exponent;
                }
                index = dest.length();
                dest.setDefaultAttribute(NumberFormat.Field.EXPONENT);
                String exponentString = Long.toString(exponent);
                count = 0;
                while (count < this.minExponentDigits - exponentString.length()) {
                    dest.append(this.symbols.getZeroDigit());
                    ++count;
                }
                count = 0;
                while (count < exponentString.length()) {
                    char dig = exponentString.charAt(count);
                    dest.append((char)(zeroStart + dig));
                    ++count;
                }
            }
        }
        if (fieldPos != null && (fieldPos.getField() == 0 || fieldPos.getFieldAttribute() == NumberFormat.Field.INTEGER)) {
            fieldPos.setBeginIndex(integerBeginIndex);
            fieldPos.setEndIndex(integerEndIndex);
        }
        if (is_neg && this.negativeSuffix != null) {
            dest.append(this.substituteCurrency(this.negativeSuffix, number), this.negativeSuffixRanges, this.negativeSuffixAttrs);
        } else {
            dest.append(this.substituteCurrency(this.positiveSuffix, number), this.positiveSuffixRanges, this.positiveSuffixAttrs);
        }
    }

    public StringBuffer format(double number, StringBuffer dest, FieldPosition fieldPos) {
        this.formatInternal(number, new StringFormatBuffer(dest), fieldPos);
        return dest;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object value) {
        AttributedFormatBuffer sbuf = new AttributedFormatBuffer();
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Cannot format given Object as a Number");
        }
        this.formatInternal(((Number)value).doubleValue(), sbuf, null);
        sbuf.sync();
        return new FormatCharacterIterator(sbuf.getBuffer().toString(), sbuf.getRanges(), sbuf.getAttributes());
    }

    public StringBuffer format(long number, StringBuffer dest, FieldPosition fieldPos) {
        boolean is_neg;
        if (this.useExponentialNotation) {
            return this.format((double)number, dest, fieldPos);
        }
        boolean bl = false;
        if (number < 0L) {
            bl = true;
        }
        if (is_neg = bl) {
            if (this.negativePrefix != null) {
                dest.append(this.substituteCurrency(this.negativePrefix, number));
            } else {
                dest.append(this.symbols.getMinusSign());
                dest.append(this.substituteCurrency(this.positivePrefix, number));
            }
            number = -number;
        } else {
            dest.append(this.substituteCurrency(this.positivePrefix, number));
        }
        int integerBeginIndex = dest.length();
        int index = dest.length();
        int count = 0;
        number *= (long)this.multiplier;
        while (count < this.maximumIntegerDigits && (number > 0L || count < this.minimumIntegerDigits)) {
            long dig = number % 10L;
            number /= 10L;
            if (dig < 0L) {
                dig = -dig;
                number = -number;
            }
            if (this.groupingUsed && count > 0 && this.groupingSize != 0 && count % this.groupingSize == 0) {
                dest.insert(index, this.symbols.getGroupingSeparator());
            }
            dest.insert(index, (char)((long)this.symbols.getZeroDigit() + dig));
            ++count;
        }
        if (fieldPos != null && fieldPos.getField() == 0) {
            fieldPos.setBeginIndex(integerBeginIndex);
            fieldPos.setEndIndex(dest.length());
        }
        if (this.decimalSeparatorAlwaysShown || this.minimumFractionDigits > 0) {
            dest.append(this.symbols.getDecimalSeparator());
            if (fieldPos != null && fieldPos.getField() == 1) {
                fieldPos.setBeginIndex(dest.length());
                fieldPos.setEndIndex(dest.length() + this.minimumFractionDigits);
            }
        }
        count = 0;
        while (count < this.minimumFractionDigits) {
            dest.append(this.symbols.getZeroDigit());
            ++count;
        }
        dest.append(is_neg && this.negativeSuffix != null ? this.substituteCurrency(this.negativeSuffix, number) : this.substituteCurrency(this.positiveSuffix, number));
        return dest;
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public int hashCode() {
        return this.toPattern().hashCode();
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public Number parse(String str, ParsePosition pos) {
        boolean use_long;
        boolean is_neg = false;
        int index = pos.getIndex();
        StringBuffer int_buf = new StringBuffer();
        boolean got_pos = str.startsWith(this.positivePrefix, index);
        String np = this.negativePrefix != null ? this.negativePrefix : this.positivePrefix + this.symbols.getMinusSign();
        boolean got_neg = str.startsWith(np, index);
        if (got_pos && got_neg) {
            if (np.length() > this.positivePrefix.length()) {
                is_neg = true;
                index += np.length();
            } else {
                index += this.positivePrefix.length();
            }
        } else if (got_neg) {
            is_neg = true;
            index += np.length();
        } else if (got_pos) {
            index += this.positivePrefix.length();
        } else {
            pos.setErrorIndex(index);
            return null;
        }
        StringBuffer buf = int_buf;
        StringBuffer frac_buf = null;
        StringBuffer exp_buf = null;
        int start_index = index;
        int max = str.length();
        int exp_index = -1;
        int last = index + this.maximumIntegerDigits;
        if (this.maximumFractionDigits > 0) {
            last += this.maximumFractionDigits + 1;
        }
        if (this.useExponentialNotation) {
            last += this.minExponentDigits + 1;
        }
        if (last > 0 && max > last) {
            max = last;
        }
        char zero = this.symbols.getZeroDigit();
        int last_group = -1;
        boolean int_part = true;
        boolean exp_part = false;
        while (index < max) {
            char c = str.charAt(index);
            if (this.groupingUsed && c == this.symbols.getGroupingSeparator()) {
                if (last_group != -1 && this.groupingSize != 0 && (index - last_group) % this.groupingSize != 0) {
                    pos.setErrorIndex(index);
                    return null;
                }
                last_group = index + 1;
            } else if (c >= zero && c <= zero + 9) {
                buf.append((char)(c - zero + 48));
            } else {
                if (this.parseIntegerOnly) break;
                if (c == this.symbols.getDecimalSeparator()) {
                    if (last_group != -1 && this.groupingSize != 0 && (index - last_group) % this.groupingSize != 0) {
                        pos.setErrorIndex(index);
                        return null;
                    }
                    buf = frac_buf = new StringBuffer();
                    frac_buf.append('.');
                    int_part = false;
                } else if (c == this.symbols.getExponential()) {
                    buf = exp_buf = new StringBuffer();
                    int_part = false;
                    exp_part = true;
                    exp_index = index + 1;
                } else {
                    if (!exp_part || c != '+' && c != '-' && c != this.symbols.getMinusSign()) break;
                    buf.append(c);
                }
            }
            ++index;
        }
        if (index == start_index) {
            pos.setErrorIndex(index);
            return null;
        }
        boolean got_pos_suf = str.startsWith(this.positiveSuffix, index);
        String ns = this.negativePrefix == null ? this.positiveSuffix : this.negativeSuffix;
        boolean got_neg_suf = str.startsWith(ns, index);
        if (is_neg) {
            if (!got_neg_suf) {
                pos.setErrorIndex(index);
                return null;
            }
        } else if (got_pos && got_neg && got_neg_suf) {
            is_neg = true;
        } else {
            if (got_pos != got_pos_suf && got_neg != got_neg_suf) {
                pos.setErrorIndex(index);
                return null;
            }
            if (!got_pos_suf) {
                pos.setErrorIndex(index);
                return null;
            }
        }
        String suffix = is_neg ? ns : this.positiveSuffix;
        long parsedMultiplier = 1L;
        if (is_neg) {
            int_buf.insert(0, '-');
        }
        if (exp_buf != null) {
            int exponent_value;
            try {
                exponent_value = Integer.parseInt(exp_buf.toString());
            }
            catch (NumberFormatException x1) {
                pos.setErrorIndex(exp_index);
                return null;
            }
            if (frac_buf == null) {
                int i = 0;
                while (i < exponent_value) {
                    int_buf.append('0');
                    ++i;
                }
                use_long = true;
            } else {
                boolean long_sufficient;
                if (exponent_value < frac_buf.length() - 1) {
                    int lastNonNull = -1;
                    int i = 1;
                    while (i < frac_buf.length()) {
                        if (frac_buf.charAt(i) != '0') {
                            lastNonNull = i;
                        }
                        ++i;
                    }
                    boolean bl = false;
                    if (lastNonNull < 0 || lastNonNull <= exponent_value) {
                        bl = true;
                    }
                    long_sufficient = bl;
                } else {
                    long_sufficient = true;
                }
                if (long_sufficient) {
                    int i = 1;
                    while (i < frac_buf.length() && i < exponent_value) {
                        int_buf.append(frac_buf.charAt(i));
                        ++i;
                    }
                    i = frac_buf.length() - 1;
                    while (i < exponent_value) {
                        int_buf.append('0');
                        ++i;
                    }
                    use_long = true;
                } else {
                    int_buf.append(frac_buf);
                    int_buf.append('E');
                    int_buf.append(exp_buf);
                    use_long = false;
                }
            }
        } else if (frac_buf != null) {
            int i = 1;
            while (i < frac_buf.length()) {
                if (frac_buf.charAt(i) != '0') break;
                ++i;
            }
            if (i != frac_buf.length()) {
                use_long = false;
                int_buf.append(frac_buf);
            } else {
                use_long = true;
            }
        } else {
            use_long = true;
        }
        String t = int_buf.toString();
        Number result = null;
        if (use_long) {
            try {
                result = new Long(t);
            }
            catch (NumberFormatException x1) {}
        } else {
            try {
                result = new Double(t);
            }
            catch (NumberFormatException x2) {
                // empty catch block
            }
        }
        if (result == null) {
            pos.setErrorIndex(index);
            return null;
        }
        pos.setIndex(index + suffix.length());
        return result;
    }

    public void setCurrency(Currency currency) {
        this.symbols.setCurrency(currency);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        this.symbols = (DecimalFormatSymbols)newSymbols.clone();
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        this.decimalSeparatorAlwaysShown = newValue;
    }

    public void setGroupingSize(int groupSize) {
        this.groupingSize = (byte)groupSize;
    }

    public void setMaximumFractionDigits(int newValue) {
        super.setMaximumFractionDigits(Math.min(newValue, 340));
    }

    public void setMaximumIntegerDigits(int newValue) {
        super.setMaximumIntegerDigits(Math.min(newValue, 309));
    }

    public void setMinimumFractionDigits(int newValue) {
        super.setMinimumFractionDigits(Math.min(newValue, 340));
    }

    public void setMinimumIntegerDigits(int newValue) {
        super.setMinimumIntegerDigits(Math.min(newValue, 309));
    }

    public void setMultiplier(int newValue) {
        this.multiplier = newValue;
    }

    public void setNegativePrefix(String newValue) {
        this.negativePrefix = newValue;
    }

    public void setNegativeSuffix(String newValue) {
        this.negativeSuffix = newValue;
    }

    public void setPositivePrefix(String newValue) {
        this.positivePrefix = newValue;
    }

    public void setPositiveSuffix(String newValue) {
        this.positiveSuffix = newValue;
    }

    private final void quoteFix(StringBuffer buf, String text, String patChars) {
        int len = text.length();
        int index = 0;
        while (index < len) {
            char c = text.charAt(index);
            if (patChars.indexOf(c) != -1) {
                buf.append('\'');
                buf.append(c);
                buf.append('\'');
            } else {
                buf.append(c);
            }
            ++index;
        }
    }

    private final String computePattern(DecimalFormatSymbols syms) {
        StringBuffer mainPattern = new StringBuffer();
        int total_digits = Math.max(this.minimumIntegerDigits, this.groupingUsed ? this.groupingSize + 1 : this.groupingSize);
        int i = 0;
        while (i < total_digits - this.minimumIntegerDigits) {
            mainPattern.append(syms.getDigit());
            ++i;
        }
        i = total_digits - this.minimumIntegerDigits;
        while (i < total_digits) {
            mainPattern.append(syms.getZeroDigit());
            ++i;
        }
        if (this.groupingUsed) {
            mainPattern.insert(mainPattern.length() - this.groupingSize, syms.getGroupingSeparator());
        }
        if (this.minimumFractionDigits > 0 || this.maximumFractionDigits > 0 || this.decimalSeparatorAlwaysShown) {
            mainPattern.append(syms.getDecimalSeparator());
        }
        i = 0;
        while (i < this.minimumFractionDigits) {
            mainPattern.append(syms.getZeroDigit());
            ++i;
        }
        i = this.minimumFractionDigits;
        while (i < this.maximumFractionDigits) {
            mainPattern.append(syms.getDigit());
            ++i;
        }
        if (this.useExponentialNotation) {
            mainPattern.append(syms.getExponential());
            i = 0;
            while (i < this.minExponentDigits) {
                mainPattern.append(syms.getZeroDigit());
                ++i;
            }
            if (this.minExponentDigits == 0) {
                mainPattern.append(syms.getDigit());
            }
        }
        String main = mainPattern.toString();
        String patChars = this.patternChars(syms);
        mainPattern.setLength(0);
        this.quoteFix(mainPattern, this.positivePrefix, patChars);
        mainPattern.append(main);
        this.quoteFix(mainPattern, this.positiveSuffix, patChars);
        if (this.negativePrefix != null) {
            this.quoteFix(mainPattern, this.negativePrefix, patChars);
            mainPattern.append(main);
            this.quoteFix(mainPattern, this.negativeSuffix, patChars);
        }
        return mainPattern.toString();
    }

    public String toLocalizedPattern() {
        return this.computePattern(this.symbols);
    }

    public String toPattern() {
        return this.computePattern(nonLocalizedSymbols);
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
            this.serialVersionOnStream = 1;
        }
    }

    private final String substituteCurrency(String string, double number) {
        int index = 0;
        int length = string.length();
        StringBuffer buf = new StringBuffer();
        while (index < length) {
            char currentChar = string.charAt(index);
            if (string.charAt(index) == '\u00a4') {
                if (index + 1 < length && string.charAt(index + 1) == '\u00a4') {
                    buf.append(this.symbols.getInternationalCurrencySymbol());
                    index += 2;
                    continue;
                }
                String symbol = this.symbols.getCurrencySymbol();
                if (symbol.startsWith("=")) {
                    String[] bounds = symbol.substring(1).split("\\|");
                    int[] boundValues = new int[3];
                    String[] boundSymbols = new String[3];
                    int a = 0;
                    while (a < 3) {
                        String[] bound = bounds[a].split("[#<]");
                        boundValues[a] = Integer.parseInt(bound[0]);
                        boundSymbols[a] = bound[1];
                        ++a;
                    }
                    if (number <= (double)boundValues[0]) {
                        buf.append(boundSymbols[0]);
                    } else if (number >= (double)boundValues[2]) {
                        buf.append(boundSymbols[2]);
                    } else {
                        buf.append(boundSymbols[1]);
                    }
                    ++index;
                    continue;
                }
                buf.append(symbol);
                ++index;
                continue;
            }
            buf.append(string.charAt(index));
            ++index;
        }
        return buf.toString();
    }

    private final /* synthetic */ void this() {
        this.serialVersionOnStream = 1;
    }

    public DecimalFormat() {
        this("#,##0.###");
    }

    public DecimalFormat(String pattern2) {
        this(pattern2, new DecimalFormatSymbols());
    }

    public DecimalFormat(String pattern2, DecimalFormatSymbols symbols) {
        this.this();
        this.symbols = (DecimalFormatSymbols)symbols.clone();
        this.applyPattern(pattern2);
    }
}

