/*
* MyGoGrinder - a program to practice Go problems
* Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
* Portions Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;

/**
 *
 * @author  Ruediger Klehn
 * @author  tkington
 */
// This displays only the help for the command line switches
public class CmdLineHelp{

    public CmdLineHelp(){helpSwitches();}

    private void helpSwitches(){ 
      // coming:
      //                 valid for validate
      // helpSwitches1 for console message, helpSwitches2 for GUI message
      String helpSwitches1 =   "\n There are some command line switches for MyGoGrinder: \n"
+ "  -l=xx, -language=xx - set the GUI language; valid values for xx are \n"
+ "                          " + Main.LANGUAGE_TOKENS + "\n"
+ "                          Omitting the token lets the program start with the \n"
+ "                          program's default (which is English). \n"
// from console, validate seems to be buggy // repair that and then let (also) give a folder from command line
+ "  -nosplash           - start the Grinder without a splash image \n"
+ "  -p, -portable       - start the Grinder as portable application (all settings\n"
+ "                          and SGF files in the program's folder) \n"
+ "  -strings            - we need a folder with resource files from the .jar file\n"
+ "                          (messages*.properties). Then we will parse the files\n"
+ "                          for missing translations in one of them (compared to\n"
+ "                          the default file, which is \"messages.properties\"). \n" 
// -strings: this looks bad on usual consoles - need to resize: width, buffer; 
// better, if we would redirect this to a file (a choosen file?)
+ "  -sysinfo            - shows your Java's environment info on the console and \n"
+ "                          copies it to the clipboard \n"
+ "  -validate           - parses a folder (to be selected) for invalid or defect\n" 
+ "                          sgf files \n"
+ "  -h, -?, -help       - they do what?";
    
      String helpSwitches2 =   "<HTML><br/> There are some command line switches for MyGoGrinder: <br/>"
      + "<PRE>"
+ " -l=xx, -language=xx  - set the GUI language; valid values for xx are  " + Main.LANGUAGE_TOKENS + " <br/>"
+ "                          Omitting the token resets the language to your system's language. <br/>"
+ "                          Omitting the token and the equal sign lets the program temporary start with <br/>"
+ "                          the program's default (which is english). <br/>"
+ " -nosplash            - start the Grinder without a splash image <br/>"
+ " -p, -portable        - start the Grinder as portable application (all settings and SGF files in <br/>"
+ "                          the program's folder)<br/>"
+ " -strings             - we need a folder with resource files (messages*.properties) from the <br/>"
+ "                          .jar file. Then we will parse the files for missing translations in one <br/>"
+ "                          of them (compared to the default file, which is \"messages.properties\"). <br/>" 
+ " -sysinfo             - shows your Java's environment info on the console and copies it to the clipboard. <br/>"
+ " -validate            - parses a folder (to be selected) for invalid or defect sgf files <br/>"
+ " -h, -?, -help        - they do what?" + "</PRE>";
      System.out.println(helpSwitches1);
      javax.swing.JOptionPane.showMessageDialog(null, helpSwitches2); 
        // this could be directly in parseCommandLine
      System.exit(0);
    }
}