/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.client.Localizable;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.client.PluralRule;
import com.google.gwt.i18n.client.impl.plurals.DefaultRule;
import com.google.gwt.i18n.server.Parameter;
import com.google.gwt.i18n.server.PluralRuleAdapter;
import com.google.gwt.i18n.server.Type;
import com.google.gwt.i18n.shared.AlternateMessageSelector;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.lang.annotation.Annotation;

public abstract class AbstractParameter
implements Parameter {
    protected final GwtLocaleFactory localeFactory;
    protected final int index;
    protected final Type type;
    private AlternateMessageSelector altMsgSelector;

    public static PluralRule getLocalizedPluralRule(Class<? extends PluralRule> pluralClass, GwtLocale locale) {
        if (PluralRule.class == pluralClass) {
            pluralClass = DefaultRule.class;
        }
        if (!Localizable.class.isAssignableFrom(pluralClass)) {
            try {
                return pluralClass.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        String fqcn = pluralClass.getCanonicalName();
        for (GwtLocale search : locale.getCompleteSearchList()) {
            String cn = fqcn;
            if (!search.isDefault()) {
                cn = cn + "_" + search.getAsString();
            }
            try {
                Class<?> clazz = Class.forName(cn);
                pluralClass = clazz.asSubclass(PluralRule.class);
                return pluralClass.newInstance();
            }
            catch (ClassCastException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
        }
        return null;
    }

    public AbstractParameter(GwtLocaleFactory localeFactory, int index, Type type) {
        this.localeFactory = localeFactory;
        this.index = index;
        this.type = type;
    }

    @Override
    public synchronized AlternateMessageSelector getAlternateMessageSelector() {
        if (this.altMsgSelector == null) {
            this.altMsgSelector = this.computeAlternateMessageSelector();
        }
        return this.altMsgSelector;
    }

    @Override
    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public abstract String getName();

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotClass) {
        return this.getAnnotation(annotClass) != null;
    }

    private AlternateMessageSelector computeAlternateMessageSelector() {
        Messages.PluralCount pluralAnnot = this.getAnnotation(Messages.PluralCount.class);
        if (pluralAnnot != null) {
            Class<? extends PluralRule> pluralClass = pluralAnnot.value();
            LocalizableResource.DefaultLocale defLocaleAnnot = this.getAnnotation(LocalizableResource.DefaultLocale.class);
            String defaultLocale = null;
            defaultLocale = defLocaleAnnot != null ? defLocaleAnnot.value() : "en";
            PluralRule pluralRule = AbstractParameter.getLocalizedPluralRule(pluralClass, this.localeFactory.fromString(defaultLocale));
            return new PluralRuleAdapter(pluralRule);
        }
        Messages.Select selectAnnot = this.getAnnotation(Messages.Select.class);
        if (selectAnnot != null) {
            final String[] validValues = this.type.getEnumValues();
            return new AlternateMessageSelector(){

                @Override
                public boolean isFormAcceptable(String form) {
                    if (validValues == null || "other".equals(form)) {
                        return true;
                    }
                    for (String value : validValues) {
                        if (!value.equals(form)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return null;
    }
}

