/**
 * This module provides a wrapper to encapsulate a lot of the common combinations of
 * user interaction we use in Moodle.
 *
 * @module     core/custom_interaction_events
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.2
 */
define("core/custom_interaction_events",["jquery","core/key_codes"],(function($,keyCodes){var events={activate:"cie:activate",keyboardActivate:"cie:keyboardactivate",escape:"cie:escape",down:"cie:down",up:"cie:up",home:"cie:home",end:"cie:end",next:"cie:next",previous:"cie:previous",asterix:"cie:asterix",scrollLock:"cie:scrollLock",scrollTop:"cie:scrollTop",scrollBottom:"cie:scrollBottom",ctrlPageUp:"cie:ctrlPageUp",ctrlPageDown:"cie:ctrlPageDown",enter:"cie:enter",accessibleChange:"cie:accessibleChange"},triggeredEvents={},isModifierPressed=function(e){return e.shiftKey||e.metaKey||e.altKey||e.ctrlKey},triggerEvent=function(eventName,e){var eventTypeKey="";return e.hasOwnProperty("originalEvent")?(eventTypeKey="triggeredCustom_"+eventName,e.originalEvent.hasOwnProperty(eventTypeKey)?void 0:(e.originalEvent[eventTypeKey]=!0,void $(e.target).trigger(eventName,[{originalEvent:e}]))):(eventTypeKey=""+eventName+e.type+e.timeStamp,void(triggeredEvents.hasOwnProperty(eventTypeKey)||(triggeredEvents[eventTypeKey]=!0,$(e.target).trigger(eventName,[{originalEvent:e}]))))},addKeyboardEvent=function(element,event,keyCode){element.off("keydown."+event).on("keydown."+event,(function(e){isModifierPressed(e)||e.keyCode==keyCode&&triggerEvent(event,e)}))},addActivateListener=function(element){element.off("click.cie.activate").on("click.cie.activate",(function(e){triggerEvent(events.activate,e)})),element.off("keydown.cie.activate").on("keydown.cie.activate",(function(e){isModifierPressed(e)||e.keyCode!=keyCodes.enter&&e.keyCode!=keyCodes.space||triggerEvent(events.activate,e)}))},addKeyboardActivateListener=function(element){element.off("keydown.cie.keyboardactivate").on("keydown.cie.keyboardactivate",(function(e){isModifierPressed(e)||e.keyCode!=keyCodes.enter&&e.keyCode!=keyCodes.space||triggerEvent(events.keyboardActivate,e)}))},addEscapeListener=function(element){addKeyboardEvent(element,events.escape,keyCodes.escape)},addDownListener=function(element){addKeyboardEvent(element,events.down,keyCodes.arrowDown)},addUpListener=function(element){addKeyboardEvent(element,events.up,keyCodes.arrowUp)},addHomeListener=function(element){addKeyboardEvent(element,events.home,keyCodes.home)},addEndListener=function(element){addKeyboardEvent(element,events.end,keyCodes.end)},addNextListener=function(element){var keyCode="rtl"==$("html").attr("dir")?keyCodes.arrowLeft:keyCodes.arrowRight;addKeyboardEvent(element,events.next,keyCode)},addPreviousListener=function(element){var keyCode="rtl"==$("html").attr("dir")?keyCodes.arrowRight:keyCodes.arrowLeft;addKeyboardEvent(element,events.previous,keyCode)},addAsterixListener=function(element){addKeyboardEvent(element,events.asterix,keyCodes.asterix)},addScrollTopListener=function(element){element.off("scroll.cie.scrollTop").on("scroll.cie.scrollTop",(function(e){0===element.scrollTop()&&triggerEvent(events.scrollTop,e)}))},addScrollBottomListener=function(element){element.off("scroll.cie.scrollBottom").on("scroll.cie.scrollBottom",(function(e){element.scrollTop()+element.innerHeight()>=element[0].scrollHeight&&triggerEvent(events.scrollBottom,e)}))},addScrollLockListener=function(element){element.off("DOMMouseScroll.cie.DOMMouseScrollLock mousewheel.cie.mousewheelLock").on("DOMMouseScroll.cie.DOMMouseScrollLock mousewheel.cie.mousewheelLock",(function(e){var scrollTop=element.scrollTop(),scrollHeight=element[0].scrollHeight,height=element.height(),delta="DOMMouseScroll"==e.type?-40*e.originalEvent.detail:e.originalEvent.wheelDelta,up=delta>0;return!up&&-delta>scrollHeight-height-scrollTop?(element.scrollTop(scrollHeight),e.stopPropagation(),e.preventDefault(),e.returnValue=!1,triggerEvent(events.scrollLock,e),!1):!(up&&delta>scrollTop)||(element.scrollTop(0),e.stopPropagation(),e.preventDefault(),e.returnValue=!1,triggerEvent(events.scrollLock,e),!1)}))},addCtrlPageUpListener=function(element){element.off("keydown.cie.ctrlpageup").on("keydown.cie.ctrlpageup",(function(e){e.ctrlKey&&e.keyCode==keyCodes.pageUp&&triggerEvent(events.ctrlPageUp,e)}))},addCtrlPageDownListener=function(element){element.off("keydown.cie.ctrlpagedown").on("keydown.cie.ctrlpagedown",(function(e){e.ctrlKey&&e.keyCode==keyCodes.pageDown&&triggerEvent(events.ctrlPageDown,e)}))},addEnterListener=function(element){addKeyboardEvent(element,events.enter,keyCodes.enter)},addAccessibleChangeListener=function(element){var onMac=-1!==navigator.userAgent.indexOf("Macintosh"),touchEnabled="ontouchstart"in window||"msMaxTouchPoints"in navigator&&navigator.msMaxTouchPoints>0;if(onMac||touchEnabled)element.on("change",(function(e){triggerEvent(events.accessibleChange,e)}));else{var checkAndTriggerAccessibleChange=function(e){"initValue"in e.target.dataset&&e.target.value!==e.target.dataset.initValue&&(e.target.dataset.initValue=e.target.value,triggerEvent(events.accessibleChange,e))},nativeElement=element.get()[0];nativeElement.addEventListener("focus",(function(e){var target;(target=e.target).dataset.initValue=target.value}),!0),nativeElement.addEventListener("blur",(function(e){checkAndTriggerAccessibleChange(e)}),!0),element.on("keydown",(function(e){var target;e.which===keyCodes.enter?checkAndTriggerAccessibleChange(e):e.which===keyCodes.escape?("initValue"in(target=e.target).dataset&&(target.value=target.dataset.initValue),e.target.dataset.ignoreChange=!0):e.target.dataset.ignoreChange=!0})),element.on("change",(function(e){e.target.dataset.ignoreChange||checkAndTriggerAccessibleChange(e)})),element.on("keyup",(function(e){delete e.target.dataset.ignoreChange})),element.on("click",(function(e){checkAndTriggerAccessibleChange(e)}))}};return{define:function(element,include){var handlers;(element=$(element),include=include||[],element.length&&include.length)&&$.each(((handlers={})[events.activate]=addActivateListener,handlers[events.keyboardActivate]=addKeyboardActivateListener,handlers[events.escape]=addEscapeListener,handlers[events.down]=addDownListener,handlers[events.up]=addUpListener,handlers[events.home]=addHomeListener,handlers[events.end]=addEndListener,handlers[events.next]=addNextListener,handlers[events.previous]=addPreviousListener,handlers[events.asterix]=addAsterixListener,handlers[events.scrollLock]=addScrollLockListener,handlers[events.scrollTop]=addScrollTopListener,handlers[events.scrollBottom]=addScrollBottomListener,handlers[events.ctrlPageUp]=addCtrlPageUpListener,handlers[events.ctrlPageDown]=addCtrlPageDownListener,handlers[events.enter]=addEnterListener,handlers[events.accessibleChange]=addAccessibleChangeListener,handlers),(function(eventType,handler){(function(eventType,include){return!(!(include=include||[]).length||-1===include.indexOf(eventType))})(eventType,include)&&handler(element)}))},events:events}}));

//# sourceMappingURL=custom_interaction_events.min.js.map