/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.InputStream;
import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.xmlrpc.DefaultHandlerMapping;
import org.apache.xmlrpc.DefaultXmlRpcContext;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcContext;
import org.apache.xmlrpc.XmlRpcHandlerMapping;
import org.apache.xmlrpc.XmlRpcWorker;

public class XmlRpcServer {
    private Stack pool = new Stack();
    private int nbrWorkers = 0;
    private DefaultHandlerMapping handlerMapping = new DefaultHandlerMapping();

    public void addHandler(String string, Object object) {
        this.handlerMapping.addHandler(string, object);
    }

    public void removeHandler(String string) {
        this.handlerMapping.removeHandler(string);
    }

    public XmlRpcHandlerMapping getHandlerMapping() {
        return this.handlerMapping;
    }

    public byte[] execute(InputStream inputStream) {
        return this.execute(inputStream, new DefaultXmlRpcContext(null, null, this.getHandlerMapping()));
    }

    public byte[] execute(InputStream inputStream, String string, String string2) {
        return this.execute(inputStream, new DefaultXmlRpcContext(string, string2, this.getHandlerMapping()));
    }

    public byte[] execute(InputStream inputStream, XmlRpcContext xmlRpcContext) {
        XmlRpcWorker xmlRpcWorker = this.getWorker();
        byte[] byArray = xmlRpcWorker.execute(inputStream, xmlRpcContext);
        this.pool.push(xmlRpcWorker);
        return byArray;
    }

    protected XmlRpcWorker getWorker() {
        try {
            return (XmlRpcWorker)this.pool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            int n = XmlRpc.getMaxThreads();
            if (this.nbrWorkers < n) {
                ++this.nbrWorkers;
                if ((double)this.nbrWorkers >= (double)n * 0.95) {
                    System.out.println("95% of XML-RPC server threads in use");
                }
                return this.createWorker();
            }
            throw new RuntimeException("System overload");
        }
    }

    protected XmlRpcWorker createWorker() {
        return new XmlRpcWorker(this.handlerMapping);
    }
}

