/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPSourceInfoCache;
import com.sun.media.rtp.SSRCInfo;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.rtcp.SourceDescription;

public abstract class RTPSourceInfo
implements Participant {
    RTPSourceInfoCache sic;
    private SSRCInfo[] ssrc;
    private SourceDescription cname;

    RTPSourceInfo(String cname, RTPSourceInfoCache sic) {
        this.cname = new SourceDescription(1, cname, 0, false);
        this.sic = sic;
        this.ssrc = new SSRCInfo[0];
    }

    SourceDescription getCNAMESDES() {
        return this.cname;
    }

    public String getCNAME() {
        return this.cname.getDescription();
    }

    public Vector getStreams() {
        Vector<SSRCInfo> recvstreams = new Vector<SSRCInfo>();
        int i2 = 0;
        while (i2 < this.ssrc.length) {
            if (this.ssrc[i2].isActive()) {
                recvstreams.addElement(this.ssrc[i2]);
            }
            ++i2;
        }
        recvstreams.trimToSize();
        return recvstreams;
    }

    RTPStream getSSRCStream(long filterssrc) {
        int i2 = 0;
        while (i2 < this.ssrc.length) {
            if (this.ssrc[i2] instanceof RTPStream && this.ssrc[i2].ssrc == (int)filterssrc) {
                return (RTPStream)((Object)this.ssrc[i2]);
            }
            ++i2;
        }
        return null;
    }

    public Vector getReports() {
        Vector<SSRCInfo> reportlist = new Vector<SSRCInfo>();
        int i2 = 0;
        while (i2 < this.ssrc.length) {
            reportlist.addElement(this.ssrc[i2]);
            ++i2;
        }
        reportlist.trimToSize();
        return reportlist;
    }

    public Vector getSourceDescription() {
        Vector sdeslist = null;
        if (this.ssrc.length == 0) {
            sdeslist = new Vector(0);
            return sdeslist;
        }
        sdeslist = this.ssrc[0].getSourceDescription();
        return sdeslist;
    }

    synchronized void addSSRC(SSRCInfo ssrcinfo) {
        int i2 = 0;
        while (i2 < this.ssrc.length) {
            if (this.ssrc[i2] == ssrcinfo) {
                return;
            }
            ++i2;
        }
        this.ssrc = new SSRCInfo[this.ssrc.length + 1];
        System.arraycopy(this.ssrc, 0, this.ssrc, 0, this.ssrc.length - 1);
        this.ssrc[this.ssrc.length - 1] = ssrcinfo;
    }

    synchronized void removeSSRC(SSRCInfo ssrcinfo) {
        if (ssrcinfo.dsource != null) {
            this.sic.ssrccache.sm.removeDataSource(ssrcinfo.dsource);
        }
        int i2 = 0;
        while (i2 < this.ssrc.length) {
            if (this.ssrc[i2] == ssrcinfo) {
                this.ssrc[i2] = this.ssrc[this.ssrc.length - 1];
                this.ssrc = new SSRCInfo[this.ssrc.length - 1];
                System.arraycopy(this.ssrc, 0, this.ssrc, 0, this.ssrc.length);
                break;
            }
            ++i2;
        }
        if (this.ssrc.length == 0) {
            this.sic.remove(this.cname.getDescription());
        }
    }

    int getStreamCount() {
        return this.ssrc.length;
    }
}

