/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Locale;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.internal.health.memory.MemoryAmount;

public class MaximumHeapHelper {
    public long getDefaultMaximumHeapSize(long osTotalMemory) {
        if (this.isIbmJvm()) {
            long totalMemoryHalf = osTotalMemory / 2L;
            long halfGB = MemoryAmount.parseNotation("512m");
            return totalMemoryHalf > halfGB ? halfGB : totalMemoryHalf;
        }
        long totalMemoryFourth = osTotalMemory / 4L;
        long oneGB = MemoryAmount.parseNotation("1g");
        switch (this.getJvmBitMode()) {
            case 32: {
                return totalMemoryFourth > oneGB ? oneGB : totalMemoryFourth;
            }
        }
        if (this.isServerJvm()) {
            long thirtyTwoGB = MemoryAmount.parseNotation("32g");
            return totalMemoryFourth > thirtyTwoGB ? thirtyTwoGB : totalMemoryFourth;
        }
        return totalMemoryFourth > oneGB ? oneGB : totalMemoryFourth;
    }

    @VisibleForTesting
    boolean isIbmJvm() {
        return Jvm.current().isIbmJvm();
    }

    @VisibleForTesting
    int getJvmBitMode() {
        for (String property : Arrays.asList("sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch")) {
            if (!System.getProperty(property, "").contains("64")) continue;
            return 64;
        }
        return 32;
    }

    @VisibleForTesting
    boolean isServerJvm() {
        return !System.getProperty("java.vm.name").toLowerCase(Locale.US).contains("client");
    }
}

