/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileImageInputStream
extends ImageInputStreamImpl {
    private RandomAccessFile file;

    public void close() throws IOException {
        this.file.close();
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public int read() throws IOException {
        this.setBitOffset(0);
        return this.file.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.setBitOffset(0);
        return this.file.read(byArray, n, n2);
    }

    public void seek(long l) throws IOException {
        super.seek(l);
        this.file.seek(l);
    }

    public FileImageInputStream(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("file may not be null");
        }
        this.file = new RandomAccessFile(file, "r");
    }

    public FileImageInputStream(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            throw new IllegalArgumentException("file may not be null");
        }
        this.file = randomAccessFile;
    }
}

