/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringRange
extends AbstractRange<String> {
    private String _lower;
    private String _upper;

    public StringRange(String lower, String upper) {
        this.adjust(lower, upper);
    }

    @Override
    public Range<String> createIntermediate(Range<String> targetRange, double position) {
        return null;
    }

    @Override
    public String lower() {
        return this._lower;
    }

    @Override
    public String upper() {
        return this._lower;
    }

    @Override
    public void adjust(String lower, String upper) {
        this.setMin(lower);
        this.setMax(upper);
    }

    protected void setMin(String lower) {
        String old = this._lower;
        this._lower = lower;
        this.firePropertyChange("min", old, this._lower);
    }

    protected void setMax(String upper) {
        String old = this._upper;
        this._upper = upper;
        this.firePropertyChange("max", old, this._upper);
    }

    @Override
    public double minimum() {
        throw new UnsupportedOperationException("minimum() is not implemented in StringRange");
    }

    @Override
    public double maximum() {
        throw new UnsupportedOperationException("maximum() is not implemented in StringRange");
    }

    @Override
    public double size() {
        return Math.abs(this._lower.compareTo(this._upper));
    }

    @Override
    public boolean contains(String x) {
        if (x == null) {
            return false;
        }
        return x.compareTo(this.lower()) >= 0 && x.compareTo(this.upper()) <= 0;
    }

    public String toString() {
        return "StringRange{lower='" + this._lower + '\'' + ", upper='" + this._upper + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringRange)) {
            return false;
        }
        StringRange that = (StringRange)o;
        if (this._lower != null ? !this._lower.equals(that._lower) : that._lower != null) {
            return false;
        }
        return !(this._upper != null ? !this._upper.equals(that._upper) : that._upper != null);
    }

    public int hashCode() {
        int result = this._lower != null ? this._lower.hashCode() : 0;
        result = 31 * result + (this._upper != null ? this._upper.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Range o) {
        if (o instanceof StringRange) {
            int lowerGap = this._lower.compareTo(((StringRange)o)._lower);
            if (this.size() == 0.0 && o.size() == 0.0) {
                return lowerGap;
            }
            if (this.size() == 0.0 && this.size() < o.size()) {
                return -1;
            }
            if (o.size() == 0.0 && this.size() > o.size()) {
                return 1;
            }
            return lowerGap == 0 ? this._upper.compareTo(((StringRange)o)._upper) : lowerGap;
        }
        return 0;
    }
}

