/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.support.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.activemq.apollo.openwire.command.ActiveMQBlobMessage;
import org.apache.activemq.apollo.openwire.support.OpenwireException;
import org.apache.activemq.apollo.openwire.support.blob.BlobTransferPolicy;
import org.apache.activemq.apollo.openwire.support.blob.BlobUploadStrategy;

public class BlobUploader {
    private BlobTransferPolicy blobTransferPolicy;
    private File file;
    private InputStream in;

    public BlobUploader(BlobTransferPolicy blobTransferPolicy, InputStream in) {
        this.blobTransferPolicy = blobTransferPolicy;
        this.in = in;
    }

    public BlobUploader(BlobTransferPolicy blobTransferPolicy, File file) {
        this.blobTransferPolicy = blobTransferPolicy;
        this.file = file;
    }

    public URL upload(ActiveMQBlobMessage message) throws OpenwireException, IOException {
        if (this.file != null) {
            return this.getStrategy().uploadFile(message, this.file);
        }
        return this.getStrategy().uploadStream(message, this.in);
    }

    public BlobTransferPolicy getBlobTransferPolicy() {
        return this.blobTransferPolicy;
    }

    public BlobUploadStrategy getStrategy() {
        return this.getBlobTransferPolicy().getUploadStrategy();
    }
}

