/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.diylc.appframework.images.IconLoader;

public class DoubleTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static final Format format = new DecimalFormat("0.#####");
    public static final String VALUE_PROPERTY = "DoubleValue";
    private Double value;
    private JLabel errorLabel;
    private boolean ignoreChanges = false;

    public DoubleTextField(Double value) {
        this();
        this.setValue(value);
    }

    public DoubleTextField() {
        this.setLayout(new BorderLayout());
        this.errorLabel = new JLabel(IconLoader.Warning.getIcon());
        this.errorLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.add((Component)this.errorLabel, "East");
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DoubleTextField.this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DoubleTextField.this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DoubleTextField.this.textChanged();
            }
        });
    }

    public Double getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Double value) {
        this.firePropertyChange(VALUE_PROPERTY, this.value, value);
        this.value = value;
        this.ignoreChanges = true;
        this.errorLabel.setVisible(value == null);
        try {
            this.setText(value == null ? "" : format.format(value));
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    private void textChanged() {
        if (!this.ignoreChanges) {
            try {
                Double newValue;
                if (this.getText().trim().isEmpty()) {
                    newValue = null;
                } else {
                    Object parsed = format.parseObject(this.getText());
                    if (parsed instanceof Long) {
                        newValue = ((Long)parsed).doubleValue();
                    } else if (parsed instanceof Integer) {
                        newValue = ((Integer)parsed).doubleValue();
                    } else if (parsed instanceof Double) {
                        newValue = (Double)parsed;
                    } else if (parsed instanceof Float) {
                        newValue = ((Float)parsed).doubleValue();
                    } else {
                        throw new RuntimeException("Unrecognized data type: " + parsed.getClass().getName());
                    }
                }
                this.firePropertyChange(VALUE_PROPERTY, this.value, newValue);
                this.value = newValue;
                this.errorLabel.setVisible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.value = null;
                this.errorLabel.setVisible(true);
            }
        }
    }
}

