/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.processor.rtp;

import com.sun.media.BasicProcessor;
import com.sun.media.JMFSecurity;
import com.sun.media.Log;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class Handler
extends BasicProcessor
implements ReceiveStreamListener {
    RTPSessionMgr[] mgrs = null;
    DataSource[] sources = null;
    Processor processor = null;
    Format[] formats = null;
    Vector locators = null;
    Object dataLock = new Object();
    boolean dataReady = false;
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    String sessionError = "cannot create and initialize the RTP Session.";
    Object closeSync = new Object();

    public Handler() {
        this.framePositioning = false;
    }

    protected synchronized boolean doConfigure() {
        super.doConfigure();
        try {
            if (this.source instanceof RTPSocket) {
                this.mgrs = new RTPSessionMgr[1];
                this.mgrs[1] = new RTPSessionMgr((RTPSocket)this.source);
                this.mgrs[1].addReceiveStreamListener(this);
                this.sources = new DataSource[1];
                this.sources[0] = this.source;
                this.formats = new Format[1];
                this.dataReady = false;
            } else {
                SessionAddress localAddr = new SessionAddress();
                this.mgrs = new RTPSessionMgr[this.locators.size()];
                this.sources = new DataSource[this.locators.size()];
                this.formats = new Format[this.locators.size()];
                this.dataReady = false;
                int i2 = 0;
                while (i2 < this.locators.size()) {
                    SessionAddress destAddr;
                    RTPMediaLocator rml = (RTPMediaLocator)this.locators.elementAt(i2);
                    this.mgrs[i2] = (RTPSessionMgr)RTPManager.newInstance();
                    this.mgrs[i2].addReceiveStreamListener(this);
                    InetAddress ipAddr = InetAddress.getByName(rml.getSessionAddress());
                    if (ipAddr.isMulticastAddress()) {
                        localAddr = new SessionAddress(ipAddr, rml.getSessionPort(), rml.getTTL());
                        destAddr = new SessionAddress(ipAddr, rml.getSessionPort(), rml.getTTL());
                    } else {
                        localAddr = new SessionAddress(InetAddress.getLocalHost(), rml.getSessionPort());
                        destAddr = new SessionAddress(ipAddr, rml.getSessionPort());
                    }
                    this.mgrs[i2].initialize(localAddr);
                    this.mgrs[i2].addTarget(destAddr);
                    ++i2;
                }
            }
        }
        catch (Exception e2) {
            Log.error("Cannot create the RTP Session: " + e2.getMessage());
            this.processError = this.sessionError;
            return false;
        }
        try {
            Object e2 = this.dataLock;
            synchronized (e2) {
                while (!(this.dataReady || this.isInterrupted() || this.closed)) {
                    this.dataLock.wait();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.closed || this.isInterrupted()) {
            this.resetInterrupt();
            this.processError = "no RTP data was received.";
            return false;
        }
        return true;
    }

    protected void completeConfigure() {
        this.state = 180;
        super.completeConfigure();
    }

    protected void doFailedConfigure() {
        this.closeSessions();
        super.doFailedConfigure();
    }

    private void closeSessions() {
        Object object = this.closeSync;
        synchronized (object) {
            int i2 = 0;
            while (i2 < this.mgrs.length) {
                if (this.mgrs[i2] != null) {
                    this.mgrs[i2].removeTargets("Closing session from the RTP Handler");
                    this.mgrs[i2].dispose();
                    this.mgrs[i2] = null;
                }
                ++i2;
            }
        }
    }

    protected boolean doRealize() {
        return this.waitForRealize(this.processor);
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    protected void doFailedRealize() {
        this.closeSessions();
        super.doFailedRealize();
    }

    protected void doStart() {
        super.doStart();
        this.waitForStart(this.processor);
    }

    protected void doStop() {
        super.doStop();
        this.waitForStop(this.processor);
    }

    protected void doDeallocate() {
        this.processor.deallocate();
        Object object = this.dataLock;
        synchronized (object) {
            this.dataLock.notifyAll();
        }
    }

    protected void doClose() {
        this.closed = true;
        Object object = this.dataLock;
        synchronized (object) {
            this.dataLock.notify();
        }
        this.stop();
        if (this.processor != null) {
            this.processor.close();
        }
        this.closeSessions();
        super.doClose();
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
    }

    protected TimeBase getMasterTimeBase() {
        return new SystemTimeBase();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent e2) {
        super.sendEvent(e2);
    }

    public void update(ReceiveStreamEvent event) {
        RTPSessionMgr mgr = (RTPSessionMgr)event.getSource();
        int idx = 0;
        while (idx < this.mgrs.length) {
            if (this.mgrs[idx] == mgr) break;
            ++idx;
        }
        if (idx >= this.mgrs.length) {
            System.err.println("Unknown manager: " + mgr);
            return;
        }
        if (event instanceof RemotePayloadChangeEvent) {
            Log.comment("Received an RTP PayloadChangeEvent");
            Log.error("The RTP processor cannot handle mid-stream payload change.\n");
            this.sendEvent(new ControllerErrorEvent(this, "Cannot handle mid-stream payload change."));
            this.close();
        }
        if (event instanceof NewReceiveStreamEvent) {
            if (this.sources[idx] != null) {
                return;
            }
            ReceiveStream stream = null;
            try {
                DataSource mixDS;
                stream = ((NewReceiveStreamEvent)event).getReceiveStream();
                this.sources[idx] = stream.getDataSource();
                RTPControl ctl = (RTPControl)this.sources[idx].getControl("javax.media.rtp.RTPControl");
                if (ctl != null) {
                    this.formats[idx] = ctl.getFormat();
                    if (this.formats[idx] instanceof AudioFormat) {
                        this.audioEnabled = true;
                    }
                    if (this.formats[idx] instanceof VideoFormat) {
                        this.videoEnabled = true;
                    }
                }
                if (this.source instanceof RTPSocket) {
                    ((RTPSocket)this.source).setChild(this.sources[idx]);
                } else {
                    ((com.sun.media.protocol.rtp.DataSource)this.source).setChild((com.sun.media.protocol.rtp.DataSource)this.sources[idx]);
                }
                int i2 = 0;
                while (i2 < this.sources.length) {
                    if (this.sources[i2] == null) {
                        return;
                    }
                    ++i2;
                }
                try {
                    mixDS = Manager.createMergingDataSource(this.sources);
                }
                catch (Exception e2) {
                    System.err.println("Cannot merge data sources.");
                    return;
                }
                try {
                    this.processor = Manager.createProcessor(mixDS);
                }
                catch (Exception e3) {
                    System.err.println("Cannot create the mix processor.");
                    return;
                }
                if (!this.waitForConfigure(this.processor)) {
                    return;
                }
                Object object = this.dataLock;
                synchronized (object) {
                    this.dataReady = true;
                    this.dataLock.notifyAll();
                }
            }
            catch (Exception e4) {
                System.err.println("NewReceiveStreamEvent exception " + e4.getMessage());
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        RTPControl ctl;
        super.setSource(source);
        if (source instanceof com.sun.media.protocol.rtp.DataSource) {
            MediaLocator ml = source.getLocator();
            String mlStr = ml.getRemainder();
            int start = 0;
            while (mlStr.charAt(start) == '/') {
                ++start;
            }
            this.locators = new Vector();
            try {
                RTPMediaLocator rml;
                String str;
                int idx;
                while (start < mlStr.length() && (idx = mlStr.indexOf("&", start)) != -1) {
                    void var6_6;
                    str = mlStr.substring(start, (int)var6_6);
                    rml = new RTPMediaLocator("rtp://" + str);
                    this.locators.addElement(rml);
                    start = var6_6 + true;
                }
                str = start != 0 ? mlStr.substring(start) : mlStr;
                rml = new RTPMediaLocator("rtp://" + str);
                this.locators.addElement(rml);
            }
            catch (Exception e2) {
                throw new IncompatibleSourceException();
            }
        } else if (!(source instanceof RTPSocket)) {
            throw new IncompatibleSourceException();
        }
        if ((ctl = (RTPControl)source.getControl("javax.media.rtp.RTPControl")) != null) {
            ctl.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.processor.getVisualComponent();
    }

    public Control[] getControls() {
        return this.processor.getControls();
    }

    public void updateStats() {
        if (this.processor != null) {
            ((BasicProcessor)this.processor).updateStats();
        }
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        super.getTrackControls();
        return this.processor.getTrackControls();
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        super.getSupportedContentDescriptors();
        return this.processor.getSupportedContentDescriptors();
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor ocd) throws NotConfiguredError {
        super.setContentDescriptor(ocd);
        return this.processor.setContentDescriptor(ocd);
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        super.getContentDescriptor();
        return this.processor.getContentDescriptor();
    }

    public DataSource getDataOutput() throws NotRealizedError {
        super.getDataOutput();
        return this.processor.getDataOutput();
    }

    private boolean waitForConfigure(Processor p) {
        return new StateWaiter().waitForConfigure(p);
    }

    private boolean waitForRealize(Processor p) {
        return new StateWaiter().waitForRealize(p);
    }

    private void waitForStart(Player p) {
        new StateWaiter().waitForStart(p, true);
    }

    private void waitForStop(Player p) {
        new StateWaiter().waitForStart(p, false);
    }

    private void waitForClose(Player p) {
        new StateWaiter().waitForClose(p);
    }

    class StateWaiter
    implements ControllerListener {
        boolean closeDown = false;
        Object stateLock = new Object();

        StateWaiter() {
        }

        public boolean waitForConfigure(Processor p) {
            p.addControllerListener(this);
            p.configure();
            Object object = this.stateLock;
            synchronized (object) {
                while (p.getState() != 180 && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
            return !this.closeDown;
        }

        public boolean waitForRealize(Processor p) {
            p.addControllerListener(this);
            p.realize();
            Object object = this.stateLock;
            synchronized (object) {
                while (p.getState() != 300 && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
            return !this.closeDown;
        }

        public void waitForStart(Player p, boolean startOn) {
            p.addControllerListener(this);
            if (startOn) {
                p.start();
            } else {
                p.stop();
            }
            Object object = this.stateLock;
            synchronized (object) {
                while ((startOn && p.getState() != 600 || !startOn && p.getState() == 600) && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
        }

        public void waitForClose(Player p) {
            p.addControllerListener(this);
            p.close();
            Object object = this.stateLock;
            synchronized (object) {
                while (!this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            p.removeControllerListener(this);
        }

        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent || ce instanceof ControllerErrorEvent) {
                this.closeDown = true;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notify();
            }
        }
    }
}

