/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Interval;
import java.io.Serializable;
import java.util.Comparator;

public class IntervalCoordinateComparator
implements Comparator<Interval>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SAMFileHeader header;

    public IntervalCoordinateComparator(SAMFileHeader header) {
        this.header = header;
    }

    @Override
    public int compare(Interval lhs, Interval rhs) {
        int rhsIndex;
        int lhsIndex = this.header.getSequenceIndex(lhs.getContig());
        int retval = lhsIndex - (rhsIndex = this.header.getSequenceIndex(rhs.getContig()));
        if (retval == 0) {
            retval = lhs.getStart() - rhs.getStart();
        }
        if (retval == 0) {
            retval = lhs.getEnd() - rhs.getEnd();
        }
        if (retval == 0) {
            if (lhs.isPositiveStrand() && rhs.isNegativeStrand()) {
                retval = -1;
            } else if (lhs.isNegativeStrand() && rhs.isPositiveStrand()) {
                retval = 1;
            }
        }
        if (retval == 0) {
            if (lhs.getName() == null) {
                if (rhs.getName() == null) {
                    return 0;
                }
                return -1;
            }
            if (rhs.getName() == null) {
                return 1;
            }
            return lhs.getName().compareTo(rhs.getName());
        }
        return retval;
    }
}

