/* -*- Mode: C; c-file-style: "gnu" -*-
   sig.h -- signature mangling stuff.
   Created: Chris Toshok <toshok@hungry.com>, 10-Aug-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef sig_h
#define sig_h

#include "jni.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef enum {
    SIG_PRIM,
    SIG_CLASS,
    SIG_METHOD,
    SIG_ARRAY
  } SigTag;

  /* forward reference needed by methods and arrays. */
  typedef union SignatureUnion Signature;

  typedef enum {
    SIG_JBOOLEAN,
    SIG_JBYTE,
    SIG_JCHAR,
    SIG_JSHORT,
    SIG_JINT,
    SIG_JFLOAT,
    SIG_JDOUBLE,
    SIG_JLONG,
    SIG_JVOID,
    SIG_JOBJECT,
    /* these four are not used in normal sigs.  They're in because they can
       appear split up on the stack. */
    SIG_JDOUBLE1,
    SIG_JDOUBLE2,
    SIG_JLONG1,
    SIG_JLONG2
  } SigPrimType;

  typedef struct {
    SigTag tag;
  } AnySigStruct;

  typedef struct {
    SigTag tag;
    SigPrimType type;
  } PrimitiveSigStruct;

  typedef struct {
    SigTag tag;
    char *java_class; /* e.g., java/lang/String */
  } ClassSigStruct;

  typedef struct {
    SigTag tag;  
    Signature *return_type;
    int num_params;
    Signature *params[100];
  } MethodSigStruct;

  typedef struct {
    SigTag tag;
    Signature *subtype;
  } ArraySigStruct;

  union SignatureUnion
  {
    AnySigStruct any;
    PrimitiveSigStruct prim;
    ClassSigStruct clazz;
    MethodSigStruct method;
    ArraySigStruct array;
  };

  extern Signature *SIG_parseFromJavaSig(JNIEnv *env, char *sig_string);
  extern char *SIG_formatPrimitiveTypeToC(JNIEnv *env, SigPrimType sig_prim_type);
  extern char *SIG_formatReturnTypeToC(JNIEnv *env, Signature *method_sig);
  extern char *SIG_formatToC(JNIEnv *env, Signature *sig);
  extern char *SIG_formatToJavaSig(JNIEnv *env, Signature *sig);
  extern char *SIG_formatToJavaSource(JNIEnv *env, Signature *sig);
  extern char *SIG_formatToNativeName(JNIEnv *env, Signature *sig);
  extern char *SIG_formatStringToNativeName(JNIEnv *env, char *sig_str);
  extern int SIG_formatStringToNativeName_buf(JNIEnv *env, char *sig_str, char *buf, int buf_len);
  extern int SIG_sizeInBytes(JNIEnv *env, Signature *sig);
  extern int SIG_sizeInWords(JNIEnv *env, Signature *sig);
  extern int SIG_numParams(JNIEnv *env, Signature *sig);
  extern char SIG_toUnionSelector(JNIEnv *env, Signature *sig);
  extern void SIG_free(JNIEnv *env, Signature *sig);

  /* a whole slew of predicates. */
  extern int SIG_isVoid(JNIEnv *env, Signature *sig);
  extern int SIG_equal(JNIEnv *env, Signature *sig1, Signature *sig2);

#ifdef __cplusplus
};
#endif

#endif /* sig_h */
