# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

import gtk

import logging
log = logging.getLogger(__name__)

from kiwi.ui.delegates import SlaveDelegate

from lottanzb.config import GConfigSection
from lottanzb.hellaconfig import HellaConfig
from lottanzb.modes.frontend import Mode as _Mode
from lottanzb.util import gproperty, _

class Config(GConfigSection):
    config_file = gproperty(type=str, default=HellaConfig.locate())

class Mode(_Mode):
    title = _("Local front-end mode")
    short = _("Local front-end")
    description = _("Monitor a HellaNZB daemon on this computer, which is "
        "already configured and running.")
    icon = gtk.STOCK_CONNECT
    
    def __init__(self, config):
        _Mode.__init__(self, config)
    
    def enter(self):
        if not self.config.config_file:
            raise
        
        self.hella_config = HellaConfig(self.config.config_file, read_only=True)
        self.hella_config.load()
        
        _Mode.enter(self)
    
    def get_connection_args(self):
        return (
            self.hella_config.XMLRPC_SERVER,
            self.hella_config.XMLRPC_PORT,
            self.hella_config.XMLRPC_PASSWORD
        )
    
    def handle_disconnect(self, backend):
        _Mode.handle_disconnect(self, backend,
            hint=_("Please make sure HellaNZB is running and the correct "
            "configuration file is selected.")
        )
    
    def get_config_view(self):
        return ConfigView(self)

class ConfigView(SlaveDelegate):
    gladefile = "local_frontend_config_view"
    
    def __init__(self, mode):
        SlaveDelegate.__init__(self)
        
        self.mode = mode
        self.config_file.set_filename(self.mode.config.config_file)
    
    def on_config_file__selection_changed(self, widget):
        if widget.get_filename():
            self.mode.config.config_file = widget.get_filename()