/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.behaviour;

import java.awt.Color;
import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.ColorBehaviourListener;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.behaviour.ColorActivityBase;

public class ColorFade
extends ColorActivityBase {
    private float _from_r;
    private float _from_g;
    private float _from_b;
    private float _from_a;
    private float _to_r;
    private float _to_g;
    private float _to_b;
    private float _to_a;
    private double _duration;
    private double _timeout;

    public ColorFade() {
        this(Color.black, Color.white, 1.0);
    }

    public ColorFade(Color color, Color color2, double d) {
        this.setFrom(color);
        this.setTo(color2);
        this._duration = d;
        this._timeout = 0.0;
    }

    public Color getFrom() {
        return new Color(this._from_r, this._from_g, this._from_b, this._from_a);
    }

    public void setFrom(Color color) {
        this._from_r = (float)((double)color.getRed() / 255.0);
        this._from_g = (float)((double)color.getGreen() / 255.0);
        this._from_b = (float)((double)color.getBlue() / 255.0);
        this._from_a = (float)((double)color.getAlpha() / 255.0);
    }

    public Color getTo() {
        return new Color(this._to_r, this._to_g, this._to_b, this._to_a);
    }

    public void setTo(Color color) {
        this._to_r = (float)((double)color.getRed() / 255.0);
        this._to_g = (float)((double)color.getGreen() / 255.0);
        this._to_b = (float)((double)color.getBlue() / 255.0);
        this._to_a = (float)((double)color.getAlpha() / 255.0);
    }

    public double getDuration() {
        return this._duration;
    }

    public void setDuration(double d) {
        this._duration = d;
    }

    public Color getValue() {
        return new Color(this.current(this._from_r, this._to_r), this.current(this._from_g, this._to_g), this.current(this._from_b, this._to_g), this.current(this._from_a, this._to_a));
    }

    public boolean isFinite() {
        return true;
    }

    public void reset() {
        this._timeout = 0.0;
        this.postUpdate(this.getValue());
    }

    public void performActivity(double d) {
        this._timeout += d;
        if (this._timeout >= this._duration) {
            this._timeout = this._duration;
            this.postActivityComplete();
        } else {
            this.postUpdate(this.getValue());
        }
    }

    private final double ratio() {
        return this._timeout / this._duration;
    }

    private final float current(float f, float f2) {
        return (float)((double)f + this.ratio() * (double)(f2 - f));
    }

    public final ColorBehaviourListener newFromAdapter() {
        return new FromAdapter();
    }

    public final ColorBehaviourListener newToAdapter() {
        return new ToAdapter();
    }

    public final DoubleBehaviourListener newDurationAdapter() {
        return new DurationAdapter();
    }

    class DurationAdapter
    implements DoubleBehaviourListener,
    Serializable {
        DurationAdapter() {
        }

        public void behaviourUpdated(double d) {
            ColorFade.this.setDuration(d);
        }
    }

    class ToAdapter
    implements ColorBehaviourListener,
    Serializable {
        ToAdapter() {
        }

        public void behaviourUpdated(Color color) {
            ColorFade.this.setTo(color);
        }
    }

    class FromAdapter
    implements ColorBehaviourListener,
    Serializable {
        FromAdapter() {
        }

        public void behaviourUpdated(Color color) {
            ColorFade.this.setFrom(color);
        }
    }
}

