/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.HeadingMap;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.ListStyleConverter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.latex.style.StyleMap;
import writer2latex.office.FontDeclaration;
import writer2latex.office.ListStyle;
import writer2latex.office.ParStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class ParStyleConverter
extends StyleConverter {
    private String[] sHeadingStyles = new String[11];

    public ParStyleConverter(WriterStyleCollection wsc, Config config, ConverterPalette palette) {
        super(wsc, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.config.formatting() >= 3) {
            decl.append("\\raggedbottom").nl();
        }
        this.appendHeadingStyles(decl);
        if (this.config.formatting() >= 3) {
            decl.append("% Paragraph styles").nl();
            this.palette.getCharSc().applyDefaultFont(this.wsc.getDefaultParStyle(), decl);
            super.appendDeclarations(pack, decl);
        }
    }

    public void applyParStyle(String sName, BeforeAfter ba, Context context) {
        this.applyParStyle(sName, ba, context, true);
    }

    private void applyParStyle(String sName, BeforeAfter ba, Context context, boolean bBreakInside) {
        ParStyle style;
        if (sName == null) {
            return;
        }
        ba.add("", "\n");
        if (!this.styleMap.contains(sName)) {
            this.createParStyle(sName);
        }
        String sBefore = this.styleMap.getBefore(sName);
        String sAfter = this.styleMap.getAfter(sName);
        ba.add(sBefore, sAfter);
        if (bBreakInside && this.styleMap.getLineBreak(sName)) {
            if (sBefore.length() > 0) {
                ba.add("\n", "");
            }
            if (sAfter.length() > 0 && !"}".equals(sAfter)) {
                ba.add("", "\n");
            }
        }
        if ((style = this.wsc.getParStyle(sName)) == null) {
            return;
        }
        this.palette.getPageSc().collectMasterPage(style);
        context.updateFormattingFromStyle(style);
        context.setVerbatim(this.styleMap.getVerbatim(sName));
    }

    private void createParStyle(String sName) {
        Context context = (Context)this.palette.getMainContext().clone();
        StyleMap sm = this.config.getParStyleMap();
        if (sm.contains(sName)) {
            this.styleMap.put(sName, sm.getBefore(sName), sm.getAfter(sName), sm.getLineBreak(sName), sm.getVerbatim(sName));
            return;
        }
        ParStyle style = this.wsc.getParStyle(sName);
        if (style == null) {
            this.styleMap.put(sName, "", "");
            return;
        }
        switch (this.config.formatting()) {
            case 3: {
                if (style.isAutomatic()) {
                    this.createAutomaticParStyle(style, context);
                    return;
                }
            }
            case 4: {
                this.createSoftParStyle(style, context);
                return;
            }
            case 1: 
            case 2: {
                this.createSimpleParStyle(style, context);
                return;
            }
        }
        this.styleMap.put(sName, "", "");
    }

    private void createAutomaticParStyle(ParStyle style, Context context) {
        BeforeAfter ba = new BeforeAfter();
        BeforeAfter baPar = new BeforeAfter();
        BeforeAfter baText = new BeforeAfter();
        String sParentName = style.getParentName();
        if (this.styleMap.getVerbatim(sParentName)) {
            this.styleMap.put(style.getName(), this.styleMap.getBefore(sParentName), this.styleMap.getAfter(sParentName), this.styleMap.getLineBreak(sParentName), this.styleMap.getVerbatim(sParentName));
            return;
        }
        this.applyParStyle(sParentName, baPar, context, false);
        this.applyPageBreak(style, false, ba);
        this.palette.getI18n().applyLanguage(style, true, false, baText);
        this.palette.getCharSc().applyFont(style, true, false, baText, context);
        if (baPar.isEmpty() && !baText.isEmpty()) {
            ba.add("{", "}");
        } else {
            ba.add(baPar.getBefore(), baPar.getAfter());
        }
        ba.add(baText.getBefore(), baText.getAfter());
        boolean bLineBreak = this.styleMap.getLineBreak(sParentName);
        if (!bLineBreak && !baText.isEmpty()) {
            ba.add(" ", "");
        }
        this.styleMap.put(style.getName(), ba.getBefore(), ba.getAfter(), bLineBreak, false);
    }

    private void createSimpleParStyle(ParStyle style, Context context) {
        if (style.isAutomatic() && this.config.getParStyleMap().contains(style.getParentName())) {
            this.createAutomaticParStyle(style, context);
        }
        BeforeAfter ba = new BeforeAfter();
        BeforeAfter baText = new BeforeAfter();
        this.applyPageBreak(style, false, ba);
        String sTextAlign = style.getProperty("fo:text-align", true);
        if ("center".equals(sTextAlign)) {
            baText.add("\\centering", "\\par");
        } else if ("end".equals(sTextAlign)) {
            baText.add("\\raggedleft", "\\par");
        }
        this.palette.getI18n().applyLanguage(style, true, true, baText);
        this.palette.getCharSc().applyFont(style, true, true, baText, context);
        if (!baText.isEmpty()) {
            ba.add("{", "}");
        }
        ba.add(baText.getBefore(), baText.getAfter());
        this.styleMap.put(style.getName(), ba.getBefore(), ba.getAfter());
    }

    private void createSoftParStyle(ParStyle style, Context context) {
        if (style.isAutomatic() && this.config.getParStyleMap().contains(style.getParentName())) {
            this.createAutomaticParStyle(style, context);
        }
        BeforeAfter ba = new BeforeAfter();
        this.applyParProperties(style, ba);
        ba.add("\\writerlistparindent\\writerlistleftskip", "");
        this.palette.getI18n().applyLanguage(style, true, true, ba);
        ba.add("\\leavevmode", "");
        this.palette.getCharSc().applyNormalFont(ba);
        this.palette.getCharSc().applyFont(style, true, true, ba, context);
        ba.add("\\writerlistlabel", "");
        ba.add("\\ignorespaces", "");
        String sTeXName = "style" + this.styleNames.getExportName(style.getName());
        this.styleMap.put(style.getName(), "\\begin{" + sTeXName + "}", "\\end{" + sTeXName + "}");
        this.declarations.append("\\newenvironment{").append(sTeXName).append("}{").append(ba.getBefore()).append("}{").append(ba.getAfter()).append("}").nl();
    }

    public void applyHardHeadingStyle(int nLevel, String sStyleName, BeforeAfter baPage, BeforeAfter baText, Context context) {
        ParStyle style = this.wsc.getParStyle(sStyleName);
        if (style == null) {
            return;
        }
        this.palette.getPageSc().collectMasterPage(style);
        if (this.sHeadingStyles[nLevel] == null) {
            String string = this.sHeadingStyles[nLevel] = style.isAutomatic() ? style.getParentName() : sStyleName;
        }
        if (style.isAutomatic()) {
            this.applyPageBreak(style, false, baPage);
            this.palette.getCharSc().applyHardCharFormatting(style, baText);
        }
        context.updateFormattingFromStyle(style);
    }

    public String getFontName(String sStyleName) {
        ParStyle style = this.wsc.getParStyle(sStyleName);
        if (style == null) {
            return null;
        }
        String sName = style.getProperty("style:font-name");
        if (sName == null) {
            return null;
        }
        FontDeclaration fd = this.wsc.getFontDeclaration(sName);
        if (fd == null) {
            return null;
        }
        return fd.getProperty("fo:font-family");
    }

    public void applyPageBreak(ParStyle style, boolean bInherit, BeforeAfter ba) {
        String sMasterPage;
        if (style == null) {
            return;
        }
        if (style.isAutomatic() && this.config.ignoreHardPageBreaks()) {
            return;
        }
        String s = style.getProperty("fo:break-before", bInherit);
        if ("page".equals(s)) {
            ba.add("\\clearpage", "");
        }
        if ("page".equals(s = style.getProperty("fo:break-after", bInherit))) {
            ba.add("", "\\clearpage");
        }
        if ((sMasterPage = style.getMasterPageName()) == null || sMasterPage.length() == 0) {
            return;
        }
        ba.add("\\clearpage", "");
        this.palette.getPageSc().applyMasterPage(sMasterPage, ba);
    }

    private void applyLineSpacing(ParStyle style, BeforeAfter ba) {
        if (style == null) {
            return;
        }
        String sLineHeight = style.getProperty("fo:line-height");
        if (sLineHeight == null || !sLineHeight.endsWith("%")) {
            return;
        }
        float fPercent = Misc.getFloat(sLineHeight.substring(0, sLineHeight.length() - 1), 1.0f);
        ba.add("\\renewcommand\\baselinestretch{" + fPercent / 120.0f + "}", "");
    }

    private String getLength(ParStyle style, String sProperty) {
        String s = style.getAbsoluteProperty(sProperty);
        if (s == null) {
            return "0cm";
        }
        return s;
    }

    private String createBorder(String sLeft, String sRight, String sTop, String sHeight, String sColor) {
        BeforeAfter baColor = new BeforeAfter();
        this.palette.getCharSc().applyThisColor(sColor, false, baColor);
        return "{\\setlength\\parindent{0pt}\\setlength\\leftskip{" + sLeft + "}" + "\\setlength\\baselineskip{0pt}\\setlength\\parskip{" + sHeight + "}" + baColor.getBefore() + "\\rule{\\textwidth-" + sLeft + "-" + sRight + "}{" + sHeight + "}" + baColor.getAfter() + "\\par}";
    }

    private void applyMargins(ParStyle style, BeforeAfter ba) {
        String sPaddingTop = this.getLength(style, "fo:padding-top");
        String sPaddingBottom = this.getLength(style, "fo:padding-bottom");
        String sPaddingLeft = this.getLength(style, "fo:padding-left");
        String sPaddingRight = this.getLength(style, "fo:padding-right");
        String sMarginTop = this.getLength(style, "fo:margin-top");
        String sMarginBottom = this.getLength(style, "fo:margin-bottom");
        String sMarginLeft = this.getLength(style, "fo:margin-left");
        String sMarginRight = this.getLength(style, "fo:margin-right");
        String sTextIndent = "true".equals(style.getProperty("style:auto-text-indent")) ? "2em" : this.getLength(style, "fo:text-indent");
        boolean bRaggedLeft = false;
        boolean bRaggedRight = false;
        boolean bParFill = false;
        String sTextAlign = style.getProperty("fo:text-align");
        if ("center".equals(sTextAlign)) {
            bRaggedLeft = true;
            bRaggedRight = true;
        } else if ("start".equals(sTextAlign)) {
            bRaggedRight = true;
            bParFill = true;
        } else if ("end".equals(sTextAlign)) {
            bRaggedLeft = true;
        } else if (!"justify".equals(style.getProperty("fo:text-align-last"))) {
            bParFill = true;
        }
        ba.add("\\setlength\\leftskip{" + sMarginLeft + (bRaggedLeft ? " plus 1fil" : "") + "}", "");
        ba.add("\\setlength\\rightskip{" + sMarginRight + (bRaggedRight ? " plus 1fil" : "") + "}", "");
        ba.add("\\setlength\\parindent{" + sTextIndent + "}", "");
        ba.add("\\setlength\\parfillskip{" + (bParFill ? "0pt plus 1fil" : "0pt") + "}", "");
        ba.add("\\setlength\\parskip{" + sMarginTop + "}", "\\unskip\\vspace{" + sMarginBottom + "}");
    }

    private void applyAlignment(ParStyle style, boolean bIsSimple, boolean bInherit, BeforeAfter ba) {
        if (bIsSimple || style == null) {
            return;
        }
        String sTextAlign = style.getProperty("fo:text-align", bInherit);
        if ("center".equals(sTextAlign)) {
            ba.add("\\centering", "");
        } else if ("start".equals(sTextAlign)) {
            ba.add("\\raggedright", "");
        } else if ("end".equals(sTextAlign)) {
            ba.add("\\raggedleft", "");
        }
    }

    private void applyParProperties(ParStyle style, BeforeAfter ba) {
        this.applyPageBreak(style, true, ba);
        ba.add("", "\\par");
        this.applyLineSpacing(style, ba);
        this.applyMargins(style, ba);
    }

    private void appendHeadingStyles(LaTeXDocumentPortion ldp) {
        boolean bOnlyNum;
        if (this.config.formatting() <= 1) {
            return;
        }
        HeadingMap hm = this.config.getHeadingMap();
        int nMaxLevel = 0;
        int i = 1;
        while (i <= 5) {
            if (this.sHeadingStyles[i] != null) {
                nMaxLevel = i;
            }
            ++i;
        }
        if (nMaxLevel == 0) {
            return;
        }
        if (nMaxLevel > hm.getMaxLevel()) {
            nMaxLevel = hm.getMaxLevel();
        }
        boolean bl = bOnlyNum = this.config.formatting() == 2;
        if (bOnlyNum) {
            ldp.append("% Outline numbering").nl();
        } else {
            ldp.append("% Headings and outline numbering").nl().append("\\makeatletter").nl();
        }
        if (!bOnlyNum) {
            int i2 = 1;
            while (i2 <= nMaxLevel) {
                ParStyle style;
                if (this.sHeadingStyles[i2] != null && (style = this.wsc.getParStyle(this.sHeadingStyles[i2])) != null) {
                    BeforeAfter decl = new BeforeAfter();
                    BeforeAfter comm = new BeforeAfter();
                    this.applyPageBreak(style, true, decl);
                    this.palette.getCharSc().applyNormalFont(decl);
                    this.palette.getCharSc().applyFont(style, true, true, decl, new Context());
                    this.applyAlignment(style, false, true, decl);
                    this.palette.getI18n().applyLanguage(style, false, true, comm);
                    this.palette.getCharSc().applyFontEffects(style, true, comm);
                    String sMarginTop = this.getLength(style, "fo:margin-top");
                    String sMarginBottom = this.getLength(style, "fo:margin-bottom");
                    String sMarginLeft = this.getLength(style, "fo:margin-left");
                    String sSecName = hm.getName(i2);
                    if (!comm.isEmpty()) {
                        ldp.append("\\newcommand\\cs").append(sSecName).append("[1]{").append(comm.getBefore()).append("#1").append(comm.getAfter()).append("}").nl();
                    }
                    ldp.append("\\renewcommand\\").append(sSecName).append("{\\@startsection{").append(sSecName).append("}{" + hm.getLevel(i2)).append("}{" + sMarginLeft + "}{");
                    ldp.append(sMarginTop).append("}{").append(sMarginBottom).append("}{");
                    ldp.append(decl.getBefore());
                    if (!comm.isEmpty()) {
                        ldp.append("\\cs").append(sSecName);
                    }
                    ldp.append("}}").nl();
                }
                ++i2;
            }
        }
        if (!bOnlyNum) {
            ldp.append("\\renewcommand\\@seccntformat[1]{").append("\\csname @textstyle#1\\endcsname{\\csname the#1\\endcsname}").append("\\csname @distance#1\\endcsname}").nl();
        }
        int nSecnumdepth = nMaxLevel;
        ListStyle outline = this.wsc.getOutlineStyle();
        String[] sNumFormat = new String[6];
        int i3 = nMaxLevel;
        while (i3 >= 1) {
            sNumFormat[i3] = ListStyleConverter.numFormat(outline.getLevelProperty(i3, "style:num-format"));
            if (sNumFormat[i3] == null || "".equals(sNumFormat[i3])) {
                nSecnumdepth = i3 - 1;
            }
            --i3;
        }
        ldp.append("\\setcounter{secnumdepth}{" + nSecnumdepth + "}").nl();
        int i4 = 1;
        while (i4 <= nMaxLevel) {
            if (sNumFormat[i4] == null || "".equals(sNumFormat[i4])) {
                if (!bOnlyNum) {
                    ldp.append("\\newcommand\\@distance").append(hm.getName(i4)).append("{}").nl().append("\\newcommand\\@textstyle").append(hm.getName(i4)).append("[1]{#1}").nl();
                }
            } else {
                if (!bOnlyNum) {
                    String sDistance = outline.getLevelProperty(i4, "text:min-label-distance");
                    ldp.append("\\newcommand\\@distance").append(hm.getName(i4)).append("{");
                    if (sDistance != null) {
                        ldp.append("\\hspace{").append(sDistance).append("{");
                    }
                    ldp.append("}").nl();
                    String sStyleName = outline.getLevelProperty(i4, "text:style-name");
                    BeforeAfter baText = new BeforeAfter();
                    if (!bOnlyNum) {
                        this.palette.getCharSc().applyTextStyle(sStyleName, baText, new Context());
                    }
                    ldp.append("\\newcommand\\@textstyle").append(hm.getName(i4)).append("[1]{").append(baText.getBefore()).append("#1").append(baText.getAfter()).append("}").nl();
                }
                String sPrefix = outline.getLevelProperty(i4, "style:num-prefix");
                String sSuffix = outline.getLevelProperty(i4, "style:num-suffix");
                int nLevels = Misc.getPosInteger(outline.getLevelProperty(i4, "text:display-levels"), 1);
                ldp.append("\\renewcommand\\the").append(hm.getName(i4)).append("{");
                StringBuffer labelbuf = new StringBuffer();
                if (sPrefix != null) {
                    labelbuf.append(sPrefix);
                }
                int j = i4 - nLevels + 1;
                while (j < i4) {
                    labelbuf.append(sNumFormat[j]).append("{").append(ParStyleConverter.sectionName(j)).append("}").append(".");
                    ++j;
                }
                labelbuf.append(sNumFormat[i4]).append("{").append(hm.getName(i4)).append("}");
                if (sSuffix != null) {
                    labelbuf.append(sSuffix);
                }
                if (bOnlyNum) {
                    ldp.append(labelbuf.toString().trim());
                } else {
                    ldp.append(labelbuf.toString());
                }
                ldp.append("}").nl();
            }
            ++i4;
        }
        if (!bOnlyNum) {
            ldp.append("\\makeatother").nl();
        }
    }

    static final String sectionName(int nLevel) {
        switch (nLevel) {
            case 1: {
                return "section";
            }
            case 2: {
                return "subsection";
            }
            case 3: {
                return "subsubsection";
            }
            case 4: {
                return "paragraph";
            }
            case 5: {
                return "subparagraph";
            }
        }
        return null;
    }
}

