/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.HttpResponseException;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.google.GoogleUtils;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.LoadFromURLDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;

public class LoadFromURLMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFilesMenuAction.class);
    public static final String LOAD_FROM_DAS = "Load from DAS...";
    public static final String LOAD_FROM_URL = "Load from URL...";
    public static final String LOAD_FILE_AND_INDEX_FROM_URLS = "Load file and index from URLs...";
    public static final String LOAD_GENOME_FROM_URL = "Load Genome from URL...";
    private IGV igv;

    public LoadFromURLMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String url;
        JPanel ta = new JPanel();
        ta.setPreferredSize(new Dimension(600, 20));
        if (e.getActionCommand().equalsIgnoreCase(LOAD_FROM_URL)) {
            String url2;
            LoadFromURLDialog dlg = new LoadFromURLDialog(IGV.getMainFrame());
            dlg.setVisible(true);
            if (!dlg.isCanceled() && (url2 = dlg.getFileURL()) != null && url2.trim().length() > 0) {
                if ((url2 = this.mapURL(url2.trim())).endsWith(".xml") || url2.endsWith(".session")) {
                    try {
                        boolean merge = false;
                        String locus = null;
                        this.igv.doRestoreSession(url2, locus, merge);
                    }
                    catch (Exception ex) {
                        MessageUtils.showMessage("Error loading url: " + url2 + " (" + ex.toString() + ")");
                    }
                } else {
                    try {
                        String key;
                        String bucket;
                        AmazonUtils.s3ObjectAccessResult res;
                        if (AmazonUtils.isAwsS3Path(url2).booleanValue() && !(res = AmazonUtils.isObjectAccessible(bucket = AmazonUtils.getBucketFromS3URL(url2), key = AmazonUtils.getKeyFromS3URL(url2))).isObjectAvailable()) {
                            MessageUtils.showErrorMessage(res.getErrorReason(), null);
                            return;
                        }
                    }
                    catch (NullPointerException npe) {
                        AmazonUtils.checkLogin();
                    }
                    ResourceLocator rl = new ResourceLocator(url2.trim());
                    if (dlg.getIndexURL() != null) {
                        String indexUrl = dlg.getIndexURL().trim();
                        if (GoogleUtils.isGoogleCloud(indexUrl) || GoogleUtils.isGoogleDrive(indexUrl)) {
                            this.enableGoogleMenu();
                        }
                        rl.setIndexPath(indexUrl);
                    }
                    this.igv.loadTracks(Arrays.asList(rl));
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase(LOAD_FROM_DAS)) {
            String url3 = JOptionPane.showInputDialog(IGV.getMainFrame(), ta, "Enter DAS feature source URL", 3);
            if (url3 != null && url3.trim().length() > 0) {
                ResourceLocator rl = new ResourceLocator(url3.trim());
                rl.setType("das");
                this.igv.loadTracks(Arrays.asList(rl));
            }
        } else if (e.getActionCommand().equalsIgnoreCase(LOAD_GENOME_FROM_URL) && (url = JOptionPane.showInputDialog(IGV.getMainFrame(), ta, "Enter URL to .genome or FASTA file", 3)) != null && url.trim().length() > 0) {
            try {
                url = this.mapURL(url);
                GenomeManager.getInstance().loadGenome(url.trim(), null);
            }
            catch (Exception e1) {
                MessageUtils.showMessage("Error loading genome: " + e1.getMessage());
            }
        }
    }

    private String mapURL(String url) {
        if (GoogleUtils.isGoogleCloud(url = url.trim()) || GoogleUtils.isGoogleDrive(url)) {
            this.enableGoogleMenu();
        }
        return url;
    }

    private void enableGoogleMenu() {
        if (!PreferencesManager.getPreferences().getAsBoolean("ENABLE_GOOGLE_MENU")) {
            PreferencesManager.getPreferences().put("ENABLE_GOOGLE_MENU", true);
            IGVMenuBar.getInstance().enableGoogleMenu(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ping(String url) {
        InputStream is = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("Range", "bytes=0-10");
            byte[] buffer = new byte[10];
            is = HttpUtils.getInstance().openConnectionStream(HttpUtils.createURL(url), params);
            is.read(buffer);
            is.close();
        }
        catch (HttpResponseException e1) {
            MessageUtils.showMessage(e1.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

