"""Generated message classes for admin version directory_v1.

Manages enterprise resources such as users and groups, administrative
notifications, security features, and more.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import message_types as _message_types
from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types

package = 'admin'


class AdminChannelsStopResponse(_messages.Message):
  r"""An empty AdminChannelsStop response."""


class Alias(_messages.Message):
  r"""JSON template for Alias object in Directory API.

  Fields:
    alias: A alias email
    etag: ETag of the resource.
    id: Unique id of the group (Read-only) Unique id of the user (Read-only)
    kind: Kind of resource this is.
    primaryEmail: Group's primary email (Read-only) User's primary email
      (Read-only)
  """

  alias = _messages.StringField(1)
  etag = _messages.StringField(2)
  id = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'admin#directory#alias')
  primaryEmail = _messages.StringField(5)


class Aliases(_messages.Message):
  r"""JSON response template to list aliases in Directory API.

  Fields:
    aliases: List of alias objects.
    etag: ETag of the resource.
    kind: Kind of resource this is.
  """

  aliases = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)
  etag = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'admin#directory#aliases')


class AppAccessCollections(_messages.Message):
  r"""JSON template for App Access Collections Resource object in Directory

  API.

  Fields:
    blockedApiAccessBuckets: List of blocked api access buckets.
    enforceSettingsForAndroidDrive: Boolean to indicate whether to enforce app
      access settings on Android Drive or not.
    errorMessage: Error message provided by the Admin that will be shown to
      the user when an app is blocked.
    etag: ETag of the resource.
    kind: Identifies the resource as an app access collection. Value:
      admin#directory#appaccesscollection
    resourceId: Unique ID of app access collection. (Readonly)
    resourceName: Resource name given by the customer while creating/updating.
      Should be unique under given customer.
    trustDomainOwnedApps: Boolean that indicates whether to trust domain owned
      apps.
  """

  blockedApiAccessBuckets = _messages.StringField(1, repeated=True)
  enforceSettingsForAndroidDrive = _messages.BooleanField(2)
  errorMessage = _messages.StringField(3)
  etag = _messages.StringField(4)
  kind = _messages.StringField(
      5, default=u'admin#directory#appaccesscollection')
  resourceId = _messages.IntegerField(6)
  resourceName = _messages.StringField(7)
  trustDomainOwnedApps = _messages.BooleanField(8)


class Asp(_messages.Message):
  r"""The template that returns individual ASP (Access Code) data.

  Fields:
    codeId: The unique ID of the ASP.
    creationTime: The time when the ASP was created. Expressed in Unix time
      format.
    etag: ETag of the ASP.
    kind: The type of the API resource. This is always admin#directory#asp.
    lastTimeUsed: The time when the ASP was last used. Expressed in Unix time
      format.
    name: The name of the application that the user, represented by their
      userId, entered when the ASP was created.
    userKey: The unique ID of the user who issued the ASP.
  """

  codeId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creationTime = _messages.IntegerField(2)
  etag = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'admin#directory#asp')
  lastTimeUsed = _messages.IntegerField(5)
  name = _messages.StringField(6)
  userKey = _messages.StringField(7)


class Asps(_messages.Message):
  r"""A Asps object.

  Fields:
    etag: ETag of the resource.
    items: A list of ASP resources.
    kind: The type of the API resource. This is always
      admin#directory#aspList.
  """

  etag = _messages.StringField(1)
  items = _messages.MessageField('Asp', 2, repeated=True)
  kind = _messages.StringField(3, default=u'admin#directory#aspList')


class Building(_messages.Message):
  r"""JSON template for Building object in Directory API.

  Fields:
    address: The postal address of the building. See PostalAddress for
      details. Note that only a single address line and region code are
      required.
    buildingId: Unique identifier for the building. The maximum length is 100
      characters.
    buildingName: The building name as seen by users in Calendar. Must be
      unique for the customer. For example, "NYC-CHEL". The maximum length is
      100 characters.
    coordinates: The geographic coordinates of the center of the building,
      expressed as latitude and longitude in decimal degrees.
    description: A brief description of the building. For example, "Chelsea
      Market".
    etags: ETag of the resource.
    floorNames: The display names for all floors in this building. The floors
      are expected to be sorted in ascending order, from lowest floor to
      highest floor. For example, ["B2", "B1", "L", "1", "2", "2M", "3", "PH"]
      Must contain at least one entry.
    kind: Kind of resource this is.
  """

  address = _messages.MessageField('BuildingAddress', 1)
  buildingId = _messages.StringField(2)
  buildingName = _messages.StringField(3)
  coordinates = _messages.MessageField('BuildingCoordinates', 4)
  description = _messages.StringField(5)
  etags = _messages.StringField(6)
  floorNames = _messages.StringField(7, repeated=True)
  kind = _messages.StringField(
      8, default=u'admin#directory#resources#buildings#Building')


class BuildingAddress(_messages.Message):
  r"""JSON template for the postal address of a building in Directory API.

  Fields:
    addressLines: Unstructured address lines describing the lower levels of an
      address.
    administrativeArea: Optional. Highest administrative subdivision which is
      used for postal addresses of a country or region.
    languageCode: Optional. BCP-47 language code of the contents of this
      address (if known).
    locality: Optional. Generally refers to the city/town portion of the
      address. Examples: US city, IT comune, UK post town. In regions of the
      world where localities are not well defined or do not fit into this
      structure well, leave locality empty and use addressLines.
    postalCode: Optional. Postal code of the address.
    regionCode: Required. CLDR region code of the country/region of the
      address.
    sublocality: Optional. Sublocality of the address.
  """

  addressLines = _messages.StringField(1, repeated=True)
  administrativeArea = _messages.StringField(2)
  languageCode = _messages.StringField(3)
  locality = _messages.StringField(4)
  postalCode = _messages.StringField(5)
  regionCode = _messages.StringField(6)
  sublocality = _messages.StringField(7)


class BuildingCoordinates(_messages.Message):
  r"""JSON template for coordinates of a building in Directory API.

  Fields:
    latitude: Latitude in decimal degrees.
    longitude: Longitude in decimal degrees.
  """

  latitude = _messages.FloatField(1)
  longitude = _messages.FloatField(2)


class Buildings(_messages.Message):
  r"""JSON template for Building List Response object in Directory API.

  Fields:
    buildings: The Buildings in this page of results.
    etag: ETag of the resource.
    kind: Kind of resource this is.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  buildings = _messages.MessageField('Building', 1, repeated=True)
  etag = _messages.StringField(2)
  kind = _messages.StringField(
      3, default=u'admin#directory#resources#buildings#buildingsList')
  nextPageToken = _messages.StringField(4)


class CalendarResource(_messages.Message):
  r"""JSON template for Calendar Resource object in Directory API.

  Fields:
    buildingId: Unique ID for the building a resource is located in.
    capacity: Capacity of a resource, number of seats in a room.
    etags: ETag of the resource.
    featureInstances: A extra_types.JsonValue attribute.
    floorName: Name of the floor a resource is located on.
    floorSection: Name of the section within a floor a resource is located in.
    generatedResourceName: The read-only auto-generated name of the calendar
      resource which includes metadata about the resource such as building
      name, floor, capacity, etc. For example, "NYC-2-Training Room 1A (16)".
    kind: The type of the resource. For calendar resources, the value is
      admin#directory#resources#calendars#CalendarResource.
    resourceCategory: The category of the calendar resource. Either
      CONFERENCE_ROOM or OTHER. Legacy data is set to CATEGORY_UNKNOWN.
    resourceDescription: Description of the resource, visible only to admins.
    resourceEmail: The read-only email for the calendar resource. Generated as
      part of creating a new calendar resource.
    resourceId: The unique ID for the calendar resource.
    resourceName: The name of the calendar resource. For example, "Training
      Room 1A".
    resourceType: The type of the calendar resource, intended for non-room
      resources.
    userVisibleDescription: Description of the resource, visible to users and
      admins.
  """

  buildingId = _messages.StringField(1)
  capacity = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  etags = _messages.StringField(3)
  featureInstances = _messages.MessageField('extra_types.JsonValue', 4)
  floorName = _messages.StringField(5)
  floorSection = _messages.StringField(6)
  generatedResourceName = _messages.StringField(7)
  kind = _messages.StringField(
      8, default=u'admin#directory#resources#calendars#CalendarResource')
  resourceCategory = _messages.StringField(9)
  resourceDescription = _messages.StringField(10)
  resourceEmail = _messages.StringField(11)
  resourceId = _messages.StringField(12)
  resourceName = _messages.StringField(13)
  resourceType = _messages.StringField(14)
  userVisibleDescription = _messages.StringField(15)


class CalendarResources(_messages.Message):
  r"""JSON template for Calendar Resource List Response object in Directory

  API.

  Fields:
    etag: ETag of the resource.
    items: The CalendarResources in this page of results.
    kind: Identifies this as a collection of CalendarResources. This is always
      admin#directory#resources#calendars#calendarResourcesList.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  etag = _messages.StringField(1)
  items = _messages.MessageField('CalendarResource', 2, repeated=True)
  kind = _messages.StringField(
      3, default=u'admin#directory#resources#calendars#calendarResourcesList')
  nextPageToken = _messages.StringField(4)


class Channel(_messages.Message):
  r"""An notification channel used to watch for resource changes.

  Messages:
    ParamsValue: Additional parameters controlling delivery channel behavior.
      Optional.

  Fields:
    address: The address where notifications are delivered for this channel.
    expiration: Date and time of notification channel expiration, expressed as
      a Unix timestamp, in milliseconds. Optional.
    id: A UUID or similar unique string that identifies this channel.
    kind: Identifies this as a notification channel used to watch for changes
      to a resource, which is "api#channel".
    params: Additional parameters controlling delivery channel behavior.
      Optional.
    payload: A Boolean value to indicate whether payload is wanted. Optional.
    resourceId: An opaque ID that identifies the resource being watched on
      this channel. Stable across different API versions.
    resourceUri: A version-specific identifier for the watched resource.
    token: An arbitrary string delivered to the target address with each
      notification delivered over this channel. Optional.
    type: The type of delivery mechanism used for this channel.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamsValue(_messages.Message):
    r"""Additional parameters controlling delivery channel behavior.

    Optional.

    Messages:
      AdditionalProperty: An additional property for a ParamsValue object.

    Fields:
      additionalProperties: Declares a new parameter by name.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParamsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField(
        'AdditionalProperty', 1, repeated=True)

  address = _messages.StringField(1)
  expiration = _messages.IntegerField(2)
  id = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'api#channel')
  params = _messages.MessageField('ParamsValue', 5)
  payload = _messages.BooleanField(6)
  resourceId = _messages.StringField(7)
  resourceUri = _messages.StringField(8)
  token = _messages.StringField(9)
  type = _messages.StringField(10)


class ChromeOsDevice(_messages.Message):
  r"""JSON template for Chrome Os Device resource in Directory API.

  Messages:
    ActiveTimeRangesValueListEntry: A ActiveTimeRangesValueListEntry object.
    CpuStatusReportsValueListEntry: A CpuStatusReportsValueListEntry object.
    DeviceFilesValueListEntry: A DeviceFilesValueListEntry object.
    DiskVolumeReportsValueListEntry: A DiskVolumeReportsValueListEntry object.
    RecentUsersValueListEntry: A RecentUsersValueListEntry object.
    SystemRamFreeReportsValueListEntry: A SystemRamFreeReportsValueListEntry
      object.
    TpmVersionInfoValue: Trusted Platform Module (TPM) (Read-only)

  Fields:
    activeTimeRanges: List of active time ranges (Read-only)
    annotatedAssetId: AssetId specified during enrollment or through later
      annotation
    annotatedLocation: Address or location of the device as noted by the
      administrator
    annotatedUser: User of the device
    autoUpdateExpiration: (Read-only) The timestamp after which the device
      will stop receiving Chrome updates or support
    bootMode: Chromebook boot mode (Read-only)
    cpuStatusReports: Reports of CPU utilization and temperature (Read-only)
    deviceFiles: List of device files to download (Read-only)
    deviceId: Unique identifier of Chrome OS Device (Read-only)
    diskVolumeReports: Reports of disk space and other info about
      mounted/connected volumes.
    dockMacAddress: (Read-only) Built-in MAC address for the docking station
      that the device connected to. Factory sets Media access control address
      (MAC address) assigned for use by a dock. Currently this is only
      supported on the Dell Arcada / Sarien devices and the Dell WD19 / WD19TB
      Docking Station. It is reserved specifically for MAC pass through device
      policy. The format is twelve (12) hexadecimal digits without any
      delimiter (uppercase letters). This is only relevant for Dell devices.
    etag: ETag of the resource.
    ethernetMacAddress: Chromebook Mac Address on ethernet network interface
      (Read-only)
    ethernetMacAddress0: (Read-only) MAC address used by the Chromebook's
      internal ethernet port, and for onboard network (ethernet) interface.
      The format is twelve (12) hexadecimal digits without any delimiter
      (uppercase letters). This is only relevant for some devices.
    firmwareVersion: Chromebook firmware version (Read-only)
    kind: Kind of resource this is.
    lastEnrollmentTime: Date and time the device was last enrolled (Read-only)
    lastSync: Date and time the device was last synchronized with the policy
      settings in the G Suite administrator control panel (Read-only)
    macAddress: Chromebook Mac Address on wifi network interface (Read-only)
    manufactureDate: (Read-only) The date the device was manufactured in yyyy-
      mm-dd format.
    meid: Contains either the Mobile Equipment identifier (MEID) or the
      International Mobile Equipment Identity (IMEI) for the 3G mobile card in
      the Chromebook (Read-only)
    model: Chromebook Model (Read-only)
    notes: Notes added by the administrator
    orderNumber: Chromebook order number (Read-only)
    orgUnitPath: OrgUnit of the device
    osVersion: Chromebook Os Version (Read-only)
    platformVersion: Chromebook platform version (Read-only)
    recentUsers: List of recent device users, in descending order by last
      login time (Read-only)
    serialNumber: Chromebook serial number (Read-only)
    status: status of the device (Read-only)
    supportEndDate: Final date the device will be supported (Read-only)
    systemRamFreeReports: Reports of amounts of available RAM memory (Read-
      only)
    systemRamTotal: Total RAM on the device [in bytes] (Read-only)
    tpmVersionInfo: Trusted Platform Module (TPM) (Read-only)
    willAutoRenew: Will Chromebook auto renew after support end date (Read-
      only)
  """

  class ActiveTimeRangesValueListEntry(_messages.Message):
    r"""A ActiveTimeRangesValueListEntry object.

    Fields:
      activeTime: Duration in milliseconds
      date: Date of usage
    """

    activeTime = _messages.IntegerField(1, variant=_messages.Variant.INT32)
    date = extra_types.DateField(2)

  class CpuStatusReportsValueListEntry(_messages.Message):
    r"""A CpuStatusReportsValueListEntry object.

    Messages:
      CpuTemperatureInfoValueListEntry: A CpuTemperatureInfoValueListEntry
        object.

    Fields:
      cpuTemperatureInfo: List of CPU temperature samples.
      cpuUtilizationPercentageInfo: A integer attribute.
      reportTime: Date and time the report was received.
    """

    class CpuTemperatureInfoValueListEntry(_messages.Message):
      r"""A CpuTemperatureInfoValueListEntry object.

      Fields:
        label: CPU label
        temperature: Temperature in Celsius degrees.
      """

      label = _messages.StringField(1)
      temperature = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    cpuTemperatureInfo = _messages.MessageField(
        'CpuTemperatureInfoValueListEntry', 1, repeated=True)
    cpuUtilizationPercentageInfo = _messages.IntegerField(
        2, repeated=True, variant=_messages.Variant.INT32)
    reportTime = _message_types.DateTimeField(3)

  class DeviceFilesValueListEntry(_messages.Message):
    r"""A DeviceFilesValueListEntry object.

    Fields:
      createTime: Date and time the file was created
      downloadUrl: File download URL
      name: File name
      type: File type
    """

    createTime = _message_types.DateTimeField(1)
    downloadUrl = _messages.StringField(2)
    name = _messages.StringField(3)
    type = _messages.StringField(4)

  class DiskVolumeReportsValueListEntry(_messages.Message):
    r"""A DiskVolumeReportsValueListEntry object.

    Messages:
      VolumeInfoValueListEntry: A VolumeInfoValueListEntry object.

    Fields:
      volumeInfo: Disk volumes
    """

    class VolumeInfoValueListEntry(_messages.Message):
      r"""A VolumeInfoValueListEntry object.

      Fields:
        storageFree: Free disk space [in bytes]
        storageTotal: Total disk space [in bytes]
        volumeId: Volume id
      """

      storageFree = _messages.IntegerField(1)
      storageTotal = _messages.IntegerField(2)
      volumeId = _messages.StringField(3)

    volumeInfo = _messages.MessageField(
        'VolumeInfoValueListEntry', 1, repeated=True)

  class RecentUsersValueListEntry(_messages.Message):
    r"""A RecentUsersValueListEntry object.

    Fields:
      email: Email address of the user. Present only if the user type is
        managed
      type: The type of the user
    """

    email = _messages.StringField(1)
    type = _messages.StringField(2)

  class SystemRamFreeReportsValueListEntry(_messages.Message):
    r"""A SystemRamFreeReportsValueListEntry object.

    Fields:
      reportTime: Date and time the report was received.
      systemRamFreeInfo: A string attribute.
    """

    reportTime = _message_types.DateTimeField(1)
    systemRamFreeInfo = _messages.IntegerField(2, repeated=True)

  class TpmVersionInfoValue(_messages.Message):
    r"""Trusted Platform Module (TPM) (Read-only)

    Fields:
      family: TPM family.
      firmwareVersion: TPM firmware version.
      manufacturer: TPM manufacturer code.
      specLevel: TPM specification level.
      tpmModel: TPM model number.
      vendorSpecific: Vendor-specific information such as Vendor ID.
    """

    family = _messages.StringField(1)
    firmwareVersion = _messages.StringField(2)
    manufacturer = _messages.StringField(3)
    specLevel = _messages.StringField(4)
    tpmModel = _messages.StringField(5)
    vendorSpecific = _messages.StringField(6)

  activeTimeRanges = _messages.MessageField(
      'ActiveTimeRangesValueListEntry', 1, repeated=True)
  annotatedAssetId = _messages.StringField(2)
  annotatedLocation = _messages.StringField(3)
  annotatedUser = _messages.StringField(4)
  autoUpdateExpiration = _messages.IntegerField(5)
  bootMode = _messages.StringField(6)
  cpuStatusReports = _messages.MessageField(
      'CpuStatusReportsValueListEntry', 7, repeated=True)
  deviceFiles = _messages.MessageField(
      'DeviceFilesValueListEntry', 8, repeated=True)
  deviceId = _messages.StringField(9)
  diskVolumeReports = _messages.MessageField(
      'DiskVolumeReportsValueListEntry', 10, repeated=True)
  dockMacAddress = _messages.StringField(11)
  etag = _messages.StringField(12)
  ethernetMacAddress = _messages.StringField(13)
  ethernetMacAddress0 = _messages.StringField(14)
  firmwareVersion = _messages.StringField(15)
  kind = _messages.StringField(16, default=u'admin#directory#chromeosdevice')
  lastEnrollmentTime = _message_types.DateTimeField(17)
  lastSync = _message_types.DateTimeField(18)
  macAddress = _messages.StringField(19)
  manufactureDate = _messages.StringField(20)
  meid = _messages.StringField(21)
  model = _messages.StringField(22)
  notes = _messages.StringField(23)
  orderNumber = _messages.StringField(24)
  orgUnitPath = _messages.StringField(25)
  osVersion = _messages.StringField(26)
  platformVersion = _messages.StringField(27)
  recentUsers = _messages.MessageField(
      'RecentUsersValueListEntry', 28, repeated=True)
  serialNumber = _messages.StringField(29)
  status = _messages.StringField(30)
  supportEndDate = _message_types.DateTimeField(31)
  systemRamFreeReports = _messages.MessageField(
      'SystemRamFreeReportsValueListEntry', 32, repeated=True)
  systemRamTotal = _messages.IntegerField(33)
  tpmVersionInfo = _messages.MessageField('TpmVersionInfoValue', 34)
  willAutoRenew = _messages.BooleanField(35)


class ChromeOsDeviceAction(_messages.Message):
  r"""JSON request template for firing actions on ChromeOs Device in Directory

  Devices API.

  Fields:
    action: Action to be taken on the ChromeOs Device
    deprovisionReason: A string attribute.
  """

  action = _messages.StringField(1)
  deprovisionReason = _messages.StringField(2)


class ChromeOsDevices(_messages.Message):
  r"""JSON response template for List Chrome OS Devices operation in Directory

  API.

  Fields:
    chromeosdevices: List of Chrome OS Device objects.
    etag: ETag of the resource.
    kind: Kind of resource this is.
    nextPageToken: Token used to access next page of this result.
  """

  chromeosdevices = _messages.MessageField('ChromeOsDevice', 1, repeated=True)
  etag = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'admin#directory#chromeosdevices')
  nextPageToken = _messages.StringField(4)


class ChromeOsMoveDevicesToOu(_messages.Message):
  r"""JSON request template for moving ChromeOs Device to given OU in

  Directory Devices API.

  Fields:
    deviceIds: ChromeOs Devices to be moved to OU
  """

  deviceIds = _messages.StringField(1, repeated=True)


class Customer(_messages.Message):
  r"""JSON template for Customer Resource object in Directory API.

  Fields:
    alternateEmail: The customer's secondary contact email address. This email
      address cannot be on the same domain as the customerDomain
    customerCreationTime: The customer's creation time (Readonly)
    customerDomain: The customer's primary domain name string. Do not include
      the www prefix when creating a new customer.
    etag: ETag of the resource.
    id: The unique ID for the customer's G Suite account. (Readonly)
    kind: Identifies the resource as a customer. Value:
      admin#directory#customer
    language: The customer's ISO 639-2 language code. The default value is en-
      US
    phoneNumber: The customer's contact phone number in E.164 format.
    postalAddress: The customer's postal address information.
  """

  alternateEmail = _messages.StringField(1)
  customerCreationTime = _message_types.DateTimeField(2)
  customerDomain = _messages.StringField(3)
  etag = _messages.StringField(4)
  id = _messages.StringField(5)
  kind = _messages.StringField(6, default=u'admin#directory#customer')
  language = _messages.StringField(7)
  phoneNumber = _messages.StringField(8)
  postalAddress = _messages.MessageField('CustomerPostalAddress', 9)


class CustomerPostalAddress(_messages.Message):
  r"""JSON template for postal address of a customer.

  Fields:
    addressLine1: A customer's physical address. The address can be composed
      of one to three lines.
    addressLine2: Address line 2 of the address.
    addressLine3: Address line 3 of the address.
    contactName: The customer contact's name.
    countryCode: This is a required property. For countryCode information see
      the ISO 3166 country code elements.
    locality: Name of the locality. An example of a locality value is the city
      of San Francisco.
    organizationName: The company or company division name.
    postalCode: The postal code. A postalCode example is a postal zip code
      such as 10009. This is in accordance with - http://portablecontacts.net
      /draft-spec.html#address_element.
    region: Name of the region. An example of a region value is NY for the
      state of New York.
  """

  addressLine1 = _messages.StringField(1)
  addressLine2 = _messages.StringField(2)
  addressLine3 = _messages.StringField(3)
  contactName = _messages.StringField(4)
  countryCode = _messages.StringField(5)
  locality = _messages.StringField(6)
  organizationName = _messages.StringField(7)
  postalCode = _messages.StringField(8)
  region = _messages.StringField(9)


class DirectoryAspsDeleteRequest(_messages.Message):
  r"""A DirectoryAspsDeleteRequest object.

  Fields:
    codeId: The unique ID of the ASP to be deleted.
    userKey: Identifies the user in the API request. The value can be the
      user's primary email address, alias email address, or unique user ID.
  """

  codeId = _messages.IntegerField(
      1, required=True, variant=_messages.Variant.INT32)
  userKey = _messages.StringField(2, required=True)


class DirectoryAspsDeleteResponse(_messages.Message):
  r"""An empty DirectoryAspsDelete response."""


class DirectoryAspsGetRequest(_messages.Message):
  r"""A DirectoryAspsGetRequest object.

  Fields:
    codeId: The unique ID of the ASP.
    userKey: Identifies the user in the API request. The value can be the
      user's primary email address, alias email address, or unique user ID.
  """

  codeId = _messages.IntegerField(
      1, required=True, variant=_messages.Variant.INT32)
  userKey = _messages.StringField(2, required=True)


class DirectoryAspsListRequest(_messages.Message):
  r"""A DirectoryAspsListRequest object.

  Fields:
    userKey: Identifies the user in the API request. The value can be the
      user's primary email address, alias email address, or unique user ID.
  """

  userKey = _messages.StringField(1, required=True)


class DirectoryChromeosdevicesActionRequest(_messages.Message):
  r"""A DirectoryChromeosdevicesActionRequest object.

  Fields:
    chromeOsDeviceAction: A ChromeOsDeviceAction resource to be passed as the
      request body.
    customerId: Immutable ID of the G Suite account
    resourceId: Immutable ID of Chrome OS Device
  """

  chromeOsDeviceAction = _messages.MessageField('ChromeOsDeviceAction', 1)
  customerId = _messages.StringField(2, required=True)
  resourceId = _messages.StringField(3, required=True)


class DirectoryChromeosdevicesActionResponse(_messages.Message):
  r"""An empty DirectoryChromeosdevicesAction response."""


class DirectoryChromeosdevicesGetRequest(_messages.Message):
  r"""A DirectoryChromeosdevicesGetRequest object.

  Enums:
    ProjectionValueValuesEnum: Restrict information returned to a set of
      selected fields.

  Fields:
    customerId: Immutable ID of the G Suite account
    deviceId: Immutable ID of Chrome OS Device
    projection: Restrict information returned to a set of selected fields.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""Restrict information returned to a set of selected fields.

    Values:
      BASIC: Includes only the basic metadata fields (e.g., deviceId,
        serialNumber, status, and user)
      FULL: Includes all metadata fields
    """
    BASIC = 0
    FULL = 1

  customerId = _messages.StringField(1, required=True)
  deviceId = _messages.StringField(2, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 3)


class DirectoryChromeosdevicesListRequest(_messages.Message):
  r"""A DirectoryChromeosdevicesListRequest object.

  Enums:
    OrderByValueValuesEnum: Column to use for sorting results
    ProjectionValueValuesEnum: Restrict information returned to a set of
      selected fields.
    SortOrderValueValuesEnum: Whether to return results in ascending or
      descending order. Only of use when orderBy is also used

  Fields:
    customerId: Immutable ID of the G Suite account
    maxResults: Maximum number of results to return. Max allowed value is 200.
    orderBy: Column to use for sorting results
    orgUnitPath: Full path of the organizational unit or its ID
    pageToken: Token to specify next page in the list
    projection: Restrict information returned to a set of selected fields.
    query: Search string in the format given at
      http://support.google.com/chromeos/a/bin/answer.py?answer=1698333
    sortOrder: Whether to return results in ascending or descending order.
      Only of use when orderBy is also used
  """

  class OrderByValueValuesEnum(_messages.Enum):
    r"""Column to use for sorting results

    Values:
      annotatedLocation: Chromebook location as annotated by the
        administrator.
      annotatedUser: Chromebook user as annotated by administrator.
      lastSync: Chromebook last sync.
      notes: Chromebook notes as annotated by the administrator.
      serialNumber: Chromebook Serial Number.
      status: Chromebook status.
      supportEndDate: Chromebook support end date.
    """
    annotatedLocation = 0
    annotatedUser = 1
    lastSync = 2
    notes = 3
    serialNumber = 4
    status = 5
    supportEndDate = 6

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""Restrict information returned to a set of selected fields.

    Values:
      BASIC: Includes only the basic metadata fields (e.g., deviceId,
        serialNumber, status, and user)
      FULL: Includes all metadata fields
    """
    BASIC = 0
    FULL = 1

  class SortOrderValueValuesEnum(_messages.Enum):
    r"""Whether to return results in ascending or descending order.

    Only of
    use when orderBy is also used

    Values:
      ASCENDING: Ascending order.
      DESCENDING: Descending order.
    """
    ASCENDING = 0
    DESCENDING = 1

  customerId = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(
      2, variant=_messages.Variant.INT32, default=100)
  orderBy = _messages.EnumField('OrderByValueValuesEnum', 3)
  orgUnitPath = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 6)
  query = _messages.StringField(7)
  sortOrder = _messages.EnumField('SortOrderValueValuesEnum', 8)


class DirectoryChromeosdevicesMoveDevicesToOuRequest(_messages.Message):
  r"""A DirectoryChromeosdevicesMoveDevicesToOuRequest object.

  Fields:
    chromeOsMoveDevicesToOu: A ChromeOsMoveDevicesToOu resource to be passed
      as the request body.
    customerId: Immutable ID of the G Suite account
    orgUnitPath: Full path of the target organizational unit or its ID
  """

  chromeOsMoveDevicesToOu = _messages.MessageField('ChromeOsMoveDevicesToOu', 1)
  customerId = _messages.StringField(2, required=True)
  orgUnitPath = _messages.StringField(3, required=True)


class DirectoryChromeosdevicesMoveDevicesToOuResponse(_messages.Message):
  r"""An empty DirectoryChromeosdevicesMoveDevicesToOu response."""


class DirectoryChromeosdevicesPatchRequest(_messages.Message):
  r"""A DirectoryChromeosdevicesPatchRequest object.

  Enums:
    ProjectionValueValuesEnum: Restrict information returned to a set of
      selected fields.

  Fields:
    chromeOsDevice: A ChromeOsDevice resource to be passed as the request
      body.
    customerId: Immutable ID of the G Suite account
    deviceId: Immutable ID of Chrome OS Device
    projection: Restrict information returned to a set of selected fields.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""Restrict information returned to a set of selected fields.

    Values:
      BASIC: Includes only the basic metadata fields (e.g., deviceId,
        serialNumber, status, and user)
      FULL: Includes all metadata fields
    """
    BASIC = 0
    FULL = 1

  chromeOsDevice = _messages.MessageField('ChromeOsDevice', 1)
  customerId = _messages.StringField(2, required=True)
  deviceId = _messages.StringField(3, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 4)


class DirectoryChromeosdevicesUpdateRequest(_messages.Message):
  r"""A DirectoryChromeosdevicesUpdateRequest object.

  Enums:
    ProjectionValueValuesEnum: Restrict information returned to a set of
      selected fields.

  Fields:
    chromeOsDevice: A ChromeOsDevice resource to be passed as the request
      body.
    customerId: Immutable ID of the G Suite account
    deviceId: Immutable ID of Chrome OS Device
    projection: Restrict information returned to a set of selected fields.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""Restrict information returned to a set of selected fields.

    Values:
      BASIC: Includes only the basic metadata fields (e.g., deviceId,
        serialNumber, status, and user)
      FULL: Includes all metadata fields
    """
    BASIC = 0
    FULL = 1

  chromeOsDevice = _messages.MessageField('ChromeOsDevice', 1)
  customerId = _messages.StringField(2, required=True)
  deviceId = _messages.StringField(3, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 4)


class DirectoryCustomersGetRequest(_messages.Message):
  r"""A DirectoryCustomersGetRequest object.

  Fields:
    customerKey: Id of the customer to be retrieved
  """

  customerKey = _messages.StringField(1, required=True)


class DirectoryCustomersPatchRequest(_messages.Message):
  r"""A DirectoryCustomersPatchRequest object.

  Fields:
    customer: A Customer resource to be passed as the request body.
    customerKey: Id of the customer to be updated
  """

  customer = _messages.MessageField('Customer', 1)
  customerKey = _messages.StringField(2, required=True)


class DirectoryCustomersUpdateRequest(_messages.Message):
  r"""A DirectoryCustomersUpdateRequest object.

  Fields:
    customer: A Customer resource to be passed as the request body.
    customerKey: Id of the customer to be updated
  """

  customer = _messages.MessageField('Customer', 1)
  customerKey = _messages.StringField(2, required=True)


class DirectoryDomainAliasesDeleteRequest(_messages.Message):
  r"""A DirectoryDomainAliasesDeleteRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    domainAliasName: Name of domain alias to be retrieved.
  """

  customer = _messages.StringField(1, required=True)
  domainAliasName = _messages.StringField(2, required=True)


class DirectoryDomainAliasesDeleteResponse(_messages.Message):
  r"""An empty DirectoryDomainAliasesDelete response."""


class DirectoryDomainAliasesGetRequest(_messages.Message):
  r"""A DirectoryDomainAliasesGetRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    domainAliasName: Name of domain alias to be retrieved.
  """

  customer = _messages.StringField(1, required=True)
  domainAliasName = _messages.StringField(2, required=True)


class DirectoryDomainAliasesInsertRequest(_messages.Message):
  r"""A DirectoryDomainAliasesInsertRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    domainAlias: A DomainAlias resource to be passed as the request body.
  """

  customer = _messages.StringField(1, required=True)
  domainAlias = _messages.MessageField('DomainAlias', 2)


class DirectoryDomainAliasesListRequest(_messages.Message):
  r"""A DirectoryDomainAliasesListRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    parentDomainName: Name of the parent domain for which domain aliases are
      to be fetched.
  """

  customer = _messages.StringField(1, required=True)
  parentDomainName = _messages.StringField(2)


class DirectoryDomainsDeleteRequest(_messages.Message):
  r"""A DirectoryDomainsDeleteRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    domainName: Name of domain to be deleted
  """

  customer = _messages.StringField(1, required=True)
  domainName = _messages.StringField(2, required=True)


class DirectoryDomainsDeleteResponse(_messages.Message):
  r"""An empty DirectoryDomainsDelete response."""


class DirectoryDomainsGetRequest(_messages.Message):
  r"""A DirectoryDomainsGetRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    domainName: Name of domain to be retrieved
  """

  customer = _messages.StringField(1, required=True)
  domainName = _messages.StringField(2, required=True)


class DirectoryDomainsInsertRequest(_messages.Message):
  r"""A DirectoryDomainsInsertRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    domains: A Domains resource to be passed as the request body.
  """

  customer = _messages.StringField(1, required=True)
  domains = _messages.MessageField('Domains', 2)


class DirectoryDomainsListRequest(_messages.Message):
  r"""A DirectoryDomainsListRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
  """

  customer = _messages.StringField(1, required=True)


class DirectoryGroupsAliasesDeleteRequest(_messages.Message):
  r"""A DirectoryGroupsAliasesDeleteRequest object.

  Fields:
    alias: The alias to be removed
    groupKey: Email or immutable ID of the group
  """

  alias = _messages.StringField(1, required=True)
  groupKey = _messages.StringField(2, required=True)


class DirectoryGroupsAliasesDeleteResponse(_messages.Message):
  r"""An empty DirectoryGroupsAliasesDelete response."""


class DirectoryGroupsAliasesInsertRequest(_messages.Message):
  r"""A DirectoryGroupsAliasesInsertRequest object.

  Fields:
    alias: A Alias resource to be passed as the request body.
    groupKey: Email or immutable ID of the group
  """

  alias = _messages.MessageField('Alias', 1)
  groupKey = _messages.StringField(2, required=True)


class DirectoryGroupsAliasesListRequest(_messages.Message):
  r"""A DirectoryGroupsAliasesListRequest object.

  Fields:
    groupKey: Email or immutable ID of the group
  """

  groupKey = _messages.StringField(1, required=True)


class DirectoryGroupsDeleteRequest(_messages.Message):
  r"""A DirectoryGroupsDeleteRequest object.

  Fields:
    groupKey: Email or immutable ID of the group
  """

  groupKey = _messages.StringField(1, required=True)


class DirectoryGroupsDeleteResponse(_messages.Message):
  r"""An empty DirectoryGroupsDelete response."""


class DirectoryGroupsGetRequest(_messages.Message):
  r"""A DirectoryGroupsGetRequest object.

  Fields:
    groupKey: Email or immutable ID of the group
  """

  groupKey = _messages.StringField(1, required=True)


class DirectoryGroupsListRequest(_messages.Message):
  r"""A DirectoryGroupsListRequest object.

  Enums:
    OrderByValueValuesEnum: Column to use for sorting results
    SortOrderValueValuesEnum: Whether to return results in ascending or
      descending order. Only of use when orderBy is also used

  Fields:
    customer: Immutable ID of the G Suite account. In case of multi-domain, to
      fetch all groups for a customer, fill this field instead of domain.
    domain: Name of the domain. Fill this field to get groups from only this
      domain. To return all groups in a multi-domain fill customer field
      instead.
    maxResults: Maximum number of results to return. Max allowed value is 200.
    orderBy: Column to use for sorting results
    pageToken: Token to specify next page in the list
    query: Query string search. Should be of the form "". Complete
      documentation is at https://developers.google.com/admin-
      sdk/directory/v1/guides/search-groups
    sortOrder: Whether to return results in ascending or descending order.
      Only of use when orderBy is also used
    userKey: Email or immutable ID of the user if only those groups are to be
      listed, the given user is a member of. If it's an ID, it should match
      with the ID of the user object.
  """

  class OrderByValueValuesEnum(_messages.Enum):
    r"""Column to use for sorting results

    Values:
      email: Email of the group.
    """
    email = 0

  class SortOrderValueValuesEnum(_messages.Enum):
    r"""Whether to return results in ascending or descending order.

    Only of
    use when orderBy is also used

    Values:
      ASCENDING: Ascending order.
      DESCENDING: Descending order.
    """
    ASCENDING = 0
    DESCENDING = 1

  customer = _messages.StringField(1)
  domain = _messages.StringField(2)
  maxResults = _messages.IntegerField(
      3, variant=_messages.Variant.INT32, default=200)
  orderBy = _messages.EnumField('OrderByValueValuesEnum', 4)
  pageToken = _messages.StringField(5)
  query = _messages.StringField(6)
  sortOrder = _messages.EnumField('SortOrderValueValuesEnum', 7)
  userKey = _messages.StringField(8)


class DirectoryGroupsPatchRequest(_messages.Message):
  r"""A DirectoryGroupsPatchRequest object.

  Fields:
    group: A Group resource to be passed as the request body.
    groupKey: Email or immutable ID of the group. If ID, it should match with
      id of group object
  """

  group = _messages.MessageField('Group', 1)
  groupKey = _messages.StringField(2, required=True)


class DirectoryGroupsUpdateRequest(_messages.Message):
  r"""A DirectoryGroupsUpdateRequest object.

  Fields:
    group: A Group resource to be passed as the request body.
    groupKey: Email or immutable ID of the group. If ID, it should match with
      id of group object
  """

  group = _messages.MessageField('Group', 1)
  groupKey = _messages.StringField(2, required=True)


class DirectoryMembersDeleteRequest(_messages.Message):
  r"""A DirectoryMembersDeleteRequest object.

  Fields:
    groupKey: Email or immutable ID of the group
    memberKey: Email or immutable ID of the member
  """

  groupKey = _messages.StringField(1, required=True)
  memberKey = _messages.StringField(2, required=True)


class DirectoryMembersDeleteResponse(_messages.Message):
  r"""An empty DirectoryMembersDelete response."""


class DirectoryMembersGetRequest(_messages.Message):
  r"""A DirectoryMembersGetRequest object.

  Fields:
    groupKey: Email or immutable ID of the group
    memberKey: Email or immutable ID of the member
  """

  groupKey = _messages.StringField(1, required=True)
  memberKey = _messages.StringField(2, required=True)


class DirectoryMembersHasMemberRequest(_messages.Message):
  r"""A DirectoryMembersHasMemberRequest object.

  Fields:
    groupKey: Identifies the group in the API request. The value can be the
      group's email address, group alias, or the unique group ID.
    memberKey: Identifies the user member in the API request. The value can be
      the user's primary email address, alias, or unique ID.
  """

  groupKey = _messages.StringField(1, required=True)
  memberKey = _messages.StringField(2, required=True)


class DirectoryMembersInsertRequest(_messages.Message):
  r"""A DirectoryMembersInsertRequest object.

  Fields:
    groupKey: Email or immutable ID of the group
    member: A Member resource to be passed as the request body.
  """

  groupKey = _messages.StringField(1, required=True)
  member = _messages.MessageField('Member', 2)


class DirectoryMembersListRequest(_messages.Message):
  r"""A DirectoryMembersListRequest object.

  Fields:
    groupKey: Email or immutable ID of the group
    includeDerivedMembership: Whether to list indirect memberships. Default:
      false.
    maxResults: Maximum number of results to return. Max allowed value is 200.
    pageToken: Token to specify next page in the list
    roles: Comma separated role values to filter list results on.
  """

  groupKey = _messages.StringField(1, required=True)
  includeDerivedMembership = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(
      3, variant=_messages.Variant.INT32, default=200)
  pageToken = _messages.StringField(4)
  roles = _messages.StringField(5)


class DirectoryMembersPatchRequest(_messages.Message):
  r"""A DirectoryMembersPatchRequest object.

  Fields:
    groupKey: Email or immutable ID of the group. If ID, it should match with
      id of group object
    member: A Member resource to be passed as the request body.
    memberKey: Email or immutable ID of the user. If ID, it should match with
      id of member object
  """

  groupKey = _messages.StringField(1, required=True)
  member = _messages.MessageField('Member', 2)
  memberKey = _messages.StringField(3, required=True)


class DirectoryMembersUpdateRequest(_messages.Message):
  r"""A DirectoryMembersUpdateRequest object.

  Fields:
    groupKey: Email or immutable ID of the group. If ID, it should match with
      id of group object
    member: A Member resource to be passed as the request body.
    memberKey: Email or immutable ID of the user. If ID, it should match with
      id of member object
  """

  groupKey = _messages.StringField(1, required=True)
  member = _messages.MessageField('Member', 2)
  memberKey = _messages.StringField(3, required=True)


class DirectoryMobiledevicesActionRequest(_messages.Message):
  r"""A DirectoryMobiledevicesActionRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    mobileDeviceAction: A MobileDeviceAction resource to be passed as the
      request body.
    resourceId: Immutable ID of Mobile Device
  """

  customerId = _messages.StringField(1, required=True)
  mobileDeviceAction = _messages.MessageField('MobileDeviceAction', 2)
  resourceId = _messages.StringField(3, required=True)


class DirectoryMobiledevicesActionResponse(_messages.Message):
  r"""An empty DirectoryMobiledevicesAction response."""


class DirectoryMobiledevicesDeleteRequest(_messages.Message):
  r"""A DirectoryMobiledevicesDeleteRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    resourceId: Immutable ID of Mobile Device
  """

  customerId = _messages.StringField(1, required=True)
  resourceId = _messages.StringField(2, required=True)


class DirectoryMobiledevicesDeleteResponse(_messages.Message):
  r"""An empty DirectoryMobiledevicesDelete response."""


class DirectoryMobiledevicesGetRequest(_messages.Message):
  r"""A DirectoryMobiledevicesGetRequest object.

  Enums:
    ProjectionValueValuesEnum: Restrict information returned to a set of
      selected fields.

  Fields:
    customerId: Immutable ID of the G Suite account
    projection: Restrict information returned to a set of selected fields.
    resourceId: Immutable ID of Mobile Device
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""Restrict information returned to a set of selected fields.

    Values:
      BASIC: Includes only the basic metadata fields (e.g., deviceId, model,
        status, type, and status)
      FULL: Includes all metadata fields
    """
    BASIC = 0
    FULL = 1

  customerId = _messages.StringField(1, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 2)
  resourceId = _messages.StringField(3, required=True)


class DirectoryMobiledevicesListRequest(_messages.Message):
  r"""A DirectoryMobiledevicesListRequest object.

  Enums:
    OrderByValueValuesEnum: Column to use for sorting results
    ProjectionValueValuesEnum: Restrict information returned to a set of
      selected fields.
    SortOrderValueValuesEnum: Whether to return results in ascending or
      descending order. Only of use when orderBy is also used

  Fields:
    customerId: Immutable ID of the G Suite account
    maxResults: Maximum number of results to return. Max allowed value is 100.
    orderBy: Column to use for sorting results
    pageToken: Token to specify next page in the list
    projection: Restrict information returned to a set of selected fields.
    query: Search string in the format given at
      http://support.google.com/a/bin/answer.py?answer=1408863#search
    sortOrder: Whether to return results in ascending or descending order.
      Only of use when orderBy is also used
  """

  class OrderByValueValuesEnum(_messages.Enum):
    r"""Column to use for sorting results

    Values:
      deviceId: Mobile Device serial number.
      email: Owner user email.
      lastSync: Last policy settings sync date time of the device.
      model: Mobile Device model.
      name: Owner user name.
      os: Mobile operating system.
      status: Status of the device.
      type: Type of the device.
    """
    deviceId = 0
    email = 1
    lastSync = 2
    model = 3
    name = 4
    os = 5
    status = 6
    type = 7

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""Restrict information returned to a set of selected fields.

    Values:
      BASIC: Includes only the basic metadata fields (e.g., deviceId, model,
        status, type, and status)
      FULL: Includes all metadata fields
    """
    BASIC = 0
    FULL = 1

  class SortOrderValueValuesEnum(_messages.Enum):
    r"""Whether to return results in ascending or descending order.

    Only of
    use when orderBy is also used

    Values:
      ASCENDING: Ascending order.
      DESCENDING: Descending order.
    """
    ASCENDING = 0
    DESCENDING = 1

  customerId = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(
      2, variant=_messages.Variant.INT32, default=100)
  orderBy = _messages.EnumField('OrderByValueValuesEnum', 3)
  pageToken = _messages.StringField(4)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 5)
  query = _messages.StringField(6)
  sortOrder = _messages.EnumField('SortOrderValueValuesEnum', 7)


class DirectoryNotificationsDeleteRequest(_messages.Message):
  r"""A DirectoryNotificationsDeleteRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. The customerId
      is also returned as part of the Users resource.
    notificationId: The unique ID of the notification.
  """

  customer = _messages.StringField(1, required=True)
  notificationId = _messages.StringField(2, required=True)


class DirectoryNotificationsDeleteResponse(_messages.Message):
  r"""An empty DirectoryNotificationsDelete response."""


class DirectoryNotificationsGetRequest(_messages.Message):
  r"""A DirectoryNotificationsGetRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. The customerId
      is also returned as part of the Users resource.
    notificationId: The unique ID of the notification.
  """

  customer = _messages.StringField(1, required=True)
  notificationId = _messages.StringField(2, required=True)


class DirectoryNotificationsListRequest(_messages.Message):
  r"""A DirectoryNotificationsListRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account.
    language: The ISO 639-1 code of the language notifications are returned
      in. The default is English (en).
    maxResults: Maximum number of notifications to return per page. The
      default is 100.
    pageToken: The token to specify the page of results to retrieve.
  """

  customer = _messages.StringField(1, required=True)
  language = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(4)


class DirectoryNotificationsPatchRequest(_messages.Message):
  r"""A DirectoryNotificationsPatchRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account.
    notification: A Notification resource to be passed as the request body.
    notificationId: The unique ID of the notification.
  """

  customer = _messages.StringField(1, required=True)
  notification = _messages.MessageField('Notification', 2)
  notificationId = _messages.StringField(3, required=True)


class DirectoryNotificationsUpdateRequest(_messages.Message):
  r"""A DirectoryNotificationsUpdateRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account.
    notification: A Notification resource to be passed as the request body.
    notificationId: The unique ID of the notification.
  """

  customer = _messages.StringField(1, required=True)
  notification = _messages.MessageField('Notification', 2)
  notificationId = _messages.StringField(3, required=True)


class DirectoryOrgunitsDeleteRequest(_messages.Message):
  r"""A DirectoryOrgunitsDeleteRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    orgUnitPath: Full path of the organizational unit or its ID
  """

  customerId = _messages.StringField(1, required=True)
  orgUnitPath = _messages.StringField(2, required=True)


class DirectoryOrgunitsDeleteResponse(_messages.Message):
  r"""An empty DirectoryOrgunitsDelete response."""


class DirectoryOrgunitsGetRequest(_messages.Message):
  r"""A DirectoryOrgunitsGetRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    orgUnitPath: Full path of the organizational unit or its ID
  """

  customerId = _messages.StringField(1, required=True)
  orgUnitPath = _messages.StringField(2, required=True)


class DirectoryOrgunitsInsertRequest(_messages.Message):
  r"""A DirectoryOrgunitsInsertRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    orgUnit: A OrgUnit resource to be passed as the request body.
  """

  customerId = _messages.StringField(1, required=True)
  orgUnit = _messages.MessageField('OrgUnit', 2)


class DirectoryOrgunitsListRequest(_messages.Message):
  r"""A DirectoryOrgunitsListRequest object.

  Enums:
    TypeValueValuesEnum: Whether to return all sub-organizations or just
      immediate children

  Fields:
    customerId: Immutable ID of the G Suite account
    orgUnitPath: the URL-encoded organizational unit's path or its ID
    type: Whether to return all sub-organizations or just immediate children
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Whether to return all sub-organizations or just immediate children

    Values:
      all: All sub-organizational units.
      children: Immediate children only (default).
    """
    all = 0
    children = 1

  customerId = _messages.StringField(1, required=True)
  orgUnitPath = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class DirectoryOrgunitsPatchRequest(_messages.Message):
  r"""A DirectoryOrgunitsPatchRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    orgUnit: A OrgUnit resource to be passed as the request body.
    orgUnitPath: Full path of the organizational unit or its ID
  """

  customerId = _messages.StringField(1, required=True)
  orgUnit = _messages.MessageField('OrgUnit', 2)
  orgUnitPath = _messages.StringField(3, required=True)


class DirectoryOrgunitsUpdateRequest(_messages.Message):
  r"""A DirectoryOrgunitsUpdateRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    orgUnit: A OrgUnit resource to be passed as the request body.
    orgUnitPath: Full path of the organizational unit or its ID
  """

  customerId = _messages.StringField(1, required=True)
  orgUnit = _messages.MessageField('OrgUnit', 2)
  orgUnitPath = _messages.StringField(3, required=True)


class DirectoryPrivilegesListRequest(_messages.Message):
  r"""A DirectoryPrivilegesListRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
  """

  customer = _messages.StringField(1, required=True)


class DirectoryResolvedAppAccessSettingsGetSettingsRequest(_messages.Message):
  r"""A DirectoryResolvedAppAccessSettingsGetSettingsRequest object."""


class DirectoryResolvedAppAccessSettingsListTrustedAppsRequest(
    _messages.Message):
  r"""A DirectoryResolvedAppAccessSettingsListTrustedAppsRequest object."""


class DirectoryResourcesBuildingsDeleteRequest(_messages.Message):
  r"""A DirectoryResourcesBuildingsDeleteRequest object.

  Fields:
    buildingId: The ID of the building to delete.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  buildingId = _messages.StringField(1, required=True)
  customer = _messages.StringField(2, required=True)


class DirectoryResourcesBuildingsDeleteResponse(_messages.Message):
  r"""An empty DirectoryResourcesBuildingsDelete response."""


class DirectoryResourcesBuildingsGetRequest(_messages.Message):
  r"""A DirectoryResourcesBuildingsGetRequest object.

  Fields:
    buildingId: The unique ID of the building to retrieve.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  buildingId = _messages.StringField(1, required=True)
  customer = _messages.StringField(2, required=True)


class DirectoryResourcesBuildingsInsertRequest(_messages.Message):
  r"""A DirectoryResourcesBuildingsInsertRequest object.

  Enums:
    CoordinatesSourceValueValuesEnum: Source from which Building.coordinates
      are derived.

  Fields:
    building: A Building resource to be passed as the request body.
    coordinatesSource: Source from which Building.coordinates are derived.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  class CoordinatesSourceValueValuesEnum(_messages.Enum):
    r"""Source from which Building.coordinates are derived.

    Values:
      CLIENT_SPECIFIED: Building.coordinates are set to the coordinates
        included in the request.
      RESOLVED_FROM_ADDRESS: Building.coordinates are automatically populated
        based on the postal address.
      SOURCE_UNSPECIFIED: Defaults to RESOLVED_FROM_ADDRESS if postal address
        is provided. Otherwise, defaults to CLIENT_SPECIFIED if coordinates
        are provided.
    """
    CLIENT_SPECIFIED = 0
    RESOLVED_FROM_ADDRESS = 1
    SOURCE_UNSPECIFIED = 2

  building = _messages.MessageField('Building', 1)
  coordinatesSource = _messages.EnumField(
      'CoordinatesSourceValueValuesEnum', 2, default=u'SOURCE_UNSPECIFIED')
  customer = _messages.StringField(3, required=True)


class DirectoryResourcesBuildingsListRequest(_messages.Message):
  r"""A DirectoryResourcesBuildingsListRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    maxResults: Maximum number of results to return.
    pageToken: Token to specify the next page in the list.
  """

  customer = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class DirectoryResourcesBuildingsPatchRequest(_messages.Message):
  r"""A DirectoryResourcesBuildingsPatchRequest object.

  Enums:
    CoordinatesSourceValueValuesEnum: Source from which Building.coordinates
      are derived.

  Fields:
    building: A Building resource to be passed as the request body.
    buildingId: The ID of the building to update.
    coordinatesSource: Source from which Building.coordinates are derived.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  class CoordinatesSourceValueValuesEnum(_messages.Enum):
    r"""Source from which Building.coordinates are derived.

    Values:
      CLIENT_SPECIFIED: Building.coordinates are set to the coordinates
        included in the request.
      RESOLVED_FROM_ADDRESS: Building.coordinates are automatically populated
        based on the postal address.
      SOURCE_UNSPECIFIED: Defaults to RESOLVED_FROM_ADDRESS if postal address
        is provided. Otherwise, defaults to CLIENT_SPECIFIED if coordinates
        are provided.
    """
    CLIENT_SPECIFIED = 0
    RESOLVED_FROM_ADDRESS = 1
    SOURCE_UNSPECIFIED = 2

  building = _messages.MessageField('Building', 1)
  buildingId = _messages.StringField(2, required=True)
  coordinatesSource = _messages.EnumField(
      'CoordinatesSourceValueValuesEnum', 3, default=u'SOURCE_UNSPECIFIED')
  customer = _messages.StringField(4, required=True)


class DirectoryResourcesBuildingsUpdateRequest(_messages.Message):
  r"""A DirectoryResourcesBuildingsUpdateRequest object.

  Enums:
    CoordinatesSourceValueValuesEnum: Source from which Building.coordinates
      are derived.

  Fields:
    building: A Building resource to be passed as the request body.
    buildingId: The ID of the building to update.
    coordinatesSource: Source from which Building.coordinates are derived.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  class CoordinatesSourceValueValuesEnum(_messages.Enum):
    r"""Source from which Building.coordinates are derived.

    Values:
      CLIENT_SPECIFIED: Building.coordinates are set to the coordinates
        included in the request.
      RESOLVED_FROM_ADDRESS: Building.coordinates are automatically populated
        based on the postal address.
      SOURCE_UNSPECIFIED: Defaults to RESOLVED_FROM_ADDRESS if postal address
        is provided. Otherwise, defaults to CLIENT_SPECIFIED if coordinates
        are provided.
    """
    CLIENT_SPECIFIED = 0
    RESOLVED_FROM_ADDRESS = 1
    SOURCE_UNSPECIFIED = 2

  building = _messages.MessageField('Building', 1)
  buildingId = _messages.StringField(2, required=True)
  coordinatesSource = _messages.EnumField(
      'CoordinatesSourceValueValuesEnum', 3, default=u'SOURCE_UNSPECIFIED')
  customer = _messages.StringField(4, required=True)


class DirectoryResourcesCalendarsDeleteRequest(_messages.Message):
  r"""A DirectoryResourcesCalendarsDeleteRequest object.

  Fields:
    calendarResourceId: The unique ID of the calendar resource to delete.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  calendarResourceId = _messages.StringField(1, required=True)
  customer = _messages.StringField(2, required=True)


class DirectoryResourcesCalendarsDeleteResponse(_messages.Message):
  r"""An empty DirectoryResourcesCalendarsDelete response."""


class DirectoryResourcesCalendarsGetRequest(_messages.Message):
  r"""A DirectoryResourcesCalendarsGetRequest object.

  Fields:
    calendarResourceId: The unique ID of the calendar resource to retrieve.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  calendarResourceId = _messages.StringField(1, required=True)
  customer = _messages.StringField(2, required=True)


class DirectoryResourcesCalendarsInsertRequest(_messages.Message):
  r"""A DirectoryResourcesCalendarsInsertRequest object.

  Fields:
    calendarResource: A CalendarResource resource to be passed as the request
      body.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  calendarResource = _messages.MessageField('CalendarResource', 1)
  customer = _messages.StringField(2, required=True)


class DirectoryResourcesCalendarsListRequest(_messages.Message):
  r"""A DirectoryResourcesCalendarsListRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    maxResults: Maximum number of results to return.
    orderBy: Field(s) to sort results by in either ascending or descending
      order. Supported fields include resourceId, resourceName, capacity,
      buildingId, and floorName. If no order is specified, defaults to
      ascending. Should be of the form "field [asc|desc], field [asc|desc],
      ...". For example buildingId, capacity desc would return results sorted
      first by buildingId in ascending order then by capacity in descending
      order.
    pageToken: Token to specify the next page in the list.
    query: String query used to filter results. Should be of the form "field
      operator value" where field can be any of supported fields and operators
      can be any of supported operations. Operators include '=' for exact
      match and ':' for prefix match or HAS match where applicable. For prefix
      match, the value should always be followed by a *. Supported fields
      include generatedResourceName, name, buildingId,
      featureInstances.feature.name. For example buildingId=US-NYC-9TH AND
      featureInstances.feature.name:Phone.
  """

  customer = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  query = _messages.StringField(5)


class DirectoryResourcesCalendarsPatchRequest(_messages.Message):
  r"""A DirectoryResourcesCalendarsPatchRequest object.

  Fields:
    calendarResource: A CalendarResource resource to be passed as the request
      body.
    calendarResourceId: The unique ID of the calendar resource to update.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  calendarResource = _messages.MessageField('CalendarResource', 1)
  calendarResourceId = _messages.StringField(2, required=True)
  customer = _messages.StringField(3, required=True)


class DirectoryResourcesCalendarsUpdateRequest(_messages.Message):
  r"""A DirectoryResourcesCalendarsUpdateRequest object.

  Fields:
    calendarResource: A CalendarResource resource to be passed as the request
      body.
    calendarResourceId: The unique ID of the calendar resource to update.
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
  """

  calendarResource = _messages.MessageField('CalendarResource', 1)
  calendarResourceId = _messages.StringField(2, required=True)
  customer = _messages.StringField(3, required=True)


class DirectoryResourcesFeaturesDeleteRequest(_messages.Message):
  r"""A DirectoryResourcesFeaturesDeleteRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    featureKey: The unique ID of the feature to delete.
  """

  customer = _messages.StringField(1, required=True)
  featureKey = _messages.StringField(2, required=True)


class DirectoryResourcesFeaturesDeleteResponse(_messages.Message):
  r"""An empty DirectoryResourcesFeaturesDelete response."""


class DirectoryResourcesFeaturesGetRequest(_messages.Message):
  r"""A DirectoryResourcesFeaturesGetRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    featureKey: The unique ID of the feature to retrieve.
  """

  customer = _messages.StringField(1, required=True)
  featureKey = _messages.StringField(2, required=True)


class DirectoryResourcesFeaturesInsertRequest(_messages.Message):
  r"""A DirectoryResourcesFeaturesInsertRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    feature: A Feature resource to be passed as the request body.
  """

  customer = _messages.StringField(1, required=True)
  feature = _messages.MessageField('Feature', 2)


class DirectoryResourcesFeaturesListRequest(_messages.Message):
  r"""A DirectoryResourcesFeaturesListRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    maxResults: Maximum number of results to return.
    pageToken: Token to specify the next page in the list.
  """

  customer = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class DirectoryResourcesFeaturesPatchRequest(_messages.Message):
  r"""A DirectoryResourcesFeaturesPatchRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    feature: A Feature resource to be passed as the request body.
    featureKey: The unique ID of the feature to update.
  """

  customer = _messages.StringField(1, required=True)
  feature = _messages.MessageField('Feature', 2)
  featureKey = _messages.StringField(3, required=True)


class DirectoryResourcesFeaturesRenameRequest(_messages.Message):
  r"""A DirectoryResourcesFeaturesRenameRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    featureRename: A FeatureRename resource to be passed as the request body.
    oldName: The unique ID of the feature to rename.
  """

  customer = _messages.StringField(1, required=True)
  featureRename = _messages.MessageField('FeatureRename', 2)
  oldName = _messages.StringField(3, required=True)


class DirectoryResourcesFeaturesRenameResponse(_messages.Message):
  r"""An empty DirectoryResourcesFeaturesRename response."""


class DirectoryResourcesFeaturesUpdateRequest(_messages.Message):
  r"""A DirectoryResourcesFeaturesUpdateRequest object.

  Fields:
    customer: The unique ID for the customer's G Suite account. As an account
      administrator, you can also use the my_customer alias to represent your
      account's customer ID.
    feature: A Feature resource to be passed as the request body.
    featureKey: The unique ID of the feature to update.
  """

  customer = _messages.StringField(1, required=True)
  feature = _messages.MessageField('Feature', 2)
  featureKey = _messages.StringField(3, required=True)


class DirectoryRoleAssignmentsDeleteRequest(_messages.Message):
  r"""A DirectoryRoleAssignmentsDeleteRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    roleAssignmentId: Immutable ID of the role assignment.
  """

  customer = _messages.StringField(1, required=True)
  roleAssignmentId = _messages.StringField(2, required=True)


class DirectoryRoleAssignmentsDeleteResponse(_messages.Message):
  r"""An empty DirectoryRoleAssignmentsDelete response."""


class DirectoryRoleAssignmentsGetRequest(_messages.Message):
  r"""A DirectoryRoleAssignmentsGetRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    roleAssignmentId: Immutable ID of the role assignment.
  """

  customer = _messages.StringField(1, required=True)
  roleAssignmentId = _messages.StringField(2, required=True)


class DirectoryRoleAssignmentsInsertRequest(_messages.Message):
  r"""A DirectoryRoleAssignmentsInsertRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    roleAssignment: A RoleAssignment resource to be passed as the request
      body.
  """

  customer = _messages.StringField(1, required=True)
  roleAssignment = _messages.MessageField('RoleAssignment', 2)


class DirectoryRoleAssignmentsListRequest(_messages.Message):
  r"""A DirectoryRoleAssignmentsListRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    maxResults: Maximum number of results to return.
    pageToken: Token to specify the next page in the list.
    roleId: Immutable ID of a role. If included in the request, returns only
      role assignments containing this role ID.
    userKey: The user's primary email address, alias email address, or unique
      user ID. If included in the request, returns role assignments only for
      this user.
  """

  customer = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  roleId = _messages.StringField(4)
  userKey = _messages.StringField(5)


class DirectoryRolesDeleteRequest(_messages.Message):
  r"""A DirectoryRolesDeleteRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    roleId: Immutable ID of the role.
  """

  customer = _messages.StringField(1, required=True)
  roleId = _messages.StringField(2, required=True)


class DirectoryRolesDeleteResponse(_messages.Message):
  r"""An empty DirectoryRolesDelete response."""


class DirectoryRolesGetRequest(_messages.Message):
  r"""A DirectoryRolesGetRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    roleId: Immutable ID of the role.
  """

  customer = _messages.StringField(1, required=True)
  roleId = _messages.StringField(2, required=True)


class DirectoryRolesInsertRequest(_messages.Message):
  r"""A DirectoryRolesInsertRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    role: A Role resource to be passed as the request body.
  """

  customer = _messages.StringField(1, required=True)
  role = _messages.MessageField('Role', 2)


class DirectoryRolesListRequest(_messages.Message):
  r"""A DirectoryRolesListRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    maxResults: Maximum number of results to return.
    pageToken: Token to specify the next page in the list.
  """

  customer = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class DirectoryRolesPatchRequest(_messages.Message):
  r"""A DirectoryRolesPatchRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    role: A Role resource to be passed as the request body.
    roleId: Immutable ID of the role.
  """

  customer = _messages.StringField(1, required=True)
  role = _messages.MessageField('Role', 2)
  roleId = _messages.StringField(3, required=True)


class DirectoryRolesUpdateRequest(_messages.Message):
  r"""A DirectoryRolesUpdateRequest object.

  Fields:
    customer: Immutable ID of the G Suite account.
    role: A Role resource to be passed as the request body.
    roleId: Immutable ID of the role.
  """

  customer = _messages.StringField(1, required=True)
  role = _messages.MessageField('Role', 2)
  roleId = _messages.StringField(3, required=True)


class DirectorySchemasDeleteRequest(_messages.Message):
  r"""A DirectorySchemasDeleteRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    schemaKey: Name or immutable ID of the schema
  """

  customerId = _messages.StringField(1, required=True)
  schemaKey = _messages.StringField(2, required=True)


class DirectorySchemasDeleteResponse(_messages.Message):
  r"""An empty DirectorySchemasDelete response."""


class DirectorySchemasGetRequest(_messages.Message):
  r"""A DirectorySchemasGetRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    schemaKey: Name or immutable ID of the schema
  """

  customerId = _messages.StringField(1, required=True)
  schemaKey = _messages.StringField(2, required=True)


class DirectorySchemasInsertRequest(_messages.Message):
  r"""A DirectorySchemasInsertRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    schema: A Schema resource to be passed as the request body.
  """

  customerId = _messages.StringField(1, required=True)
  schema = _messages.MessageField('Schema', 2)


class DirectorySchemasListRequest(_messages.Message):
  r"""A DirectorySchemasListRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
  """

  customerId = _messages.StringField(1, required=True)


class DirectorySchemasPatchRequest(_messages.Message):
  r"""A DirectorySchemasPatchRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    schema: A Schema resource to be passed as the request body.
    schemaKey: Name or immutable ID of the schema.
  """

  customerId = _messages.StringField(1, required=True)
  schema = _messages.MessageField('Schema', 2)
  schemaKey = _messages.StringField(3, required=True)


class DirectorySchemasUpdateRequest(_messages.Message):
  r"""A DirectorySchemasUpdateRequest object.

  Fields:
    customerId: Immutable ID of the G Suite account
    schema: A Schema resource to be passed as the request body.
    schemaKey: Name or immutable ID of the schema.
  """

  customerId = _messages.StringField(1, required=True)
  schema = _messages.MessageField('Schema', 2)
  schemaKey = _messages.StringField(3, required=True)


class DirectoryTokensDeleteRequest(_messages.Message):
  r"""A DirectoryTokensDeleteRequest object.

  Fields:
    clientId: The Client ID of the application the token is issued to.
    userKey: Identifies the user in the API request. The value can be the
      user's primary email address, alias email address, or unique user ID.
  """

  clientId = _messages.StringField(1, required=True)
  userKey = _messages.StringField(2, required=True)


class DirectoryTokensDeleteResponse(_messages.Message):
  r"""An empty DirectoryTokensDelete response."""


class DirectoryTokensGetRequest(_messages.Message):
  r"""A DirectoryTokensGetRequest object.

  Fields:
    clientId: The Client ID of the application the token is issued to.
    userKey: Identifies the user in the API request. The value can be the
      user's primary email address, alias email address, or unique user ID.
  """

  clientId = _messages.StringField(1, required=True)
  userKey = _messages.StringField(2, required=True)


class DirectoryTokensListRequest(_messages.Message):
  r"""A DirectoryTokensListRequest object.

  Fields:
    userKey: Identifies the user in the API request. The value can be the
      user's primary email address, alias email address, or unique user ID.
  """

  userKey = _messages.StringField(1, required=True)


class DirectoryUsersAliasesDeleteRequest(_messages.Message):
  r"""A DirectoryUsersAliasesDeleteRequest object.

  Fields:
    alias: The alias to be removed
    userKey: Email or immutable ID of the user
  """

  alias = _messages.StringField(1, required=True)
  userKey = _messages.StringField(2, required=True)


class DirectoryUsersAliasesDeleteResponse(_messages.Message):
  r"""An empty DirectoryUsersAliasesDelete response."""


class DirectoryUsersAliasesInsertRequest(_messages.Message):
  r"""A DirectoryUsersAliasesInsertRequest object.

  Fields:
    alias: A Alias resource to be passed as the request body.
    userKey: Email or immutable ID of the user
  """

  alias = _messages.MessageField('Alias', 1)
  userKey = _messages.StringField(2, required=True)


class DirectoryUsersAliasesListRequest(_messages.Message):
  r"""A DirectoryUsersAliasesListRequest object.

  Enums:
    EventValueValuesEnum: Event on which subscription is intended (if
      subscribing)

  Fields:
    event: Event on which subscription is intended (if subscribing)
    userKey: Email or immutable ID of the user
  """

  class EventValueValuesEnum(_messages.Enum):
    r"""Event on which subscription is intended (if subscribing)

    Values:
      add: Alias Created Event
      delete: Alias Deleted Event
    """
    add = 0
    delete = 1

  event = _messages.EnumField('EventValueValuesEnum', 1)
  userKey = _messages.StringField(2, required=True)


class DirectoryUsersAliasesWatchRequest(_messages.Message):
  r"""A DirectoryUsersAliasesWatchRequest object.

  Enums:
    EventValueValuesEnum: Event on which subscription is intended (if
      subscribing)

  Fields:
    channel: A Channel resource to be passed as the request body.
    event: Event on which subscription is intended (if subscribing)
    userKey: Email or immutable ID of the user
  """

  class EventValueValuesEnum(_messages.Enum):
    r"""Event on which subscription is intended (if subscribing)

    Values:
      add: Alias Created Event
      delete: Alias Deleted Event
    """
    add = 0
    delete = 1

  channel = _messages.MessageField('Channel', 1)
  event = _messages.EnumField('EventValueValuesEnum', 2)
  userKey = _messages.StringField(3, required=True)


class DirectoryUsersDeleteRequest(_messages.Message):
  r"""A DirectoryUsersDeleteRequest object.

  Fields:
    userKey: Email or immutable ID of the user
  """

  userKey = _messages.StringField(1, required=True)


class DirectoryUsersDeleteResponse(_messages.Message):
  r"""An empty DirectoryUsersDelete response."""


class DirectoryUsersGetRequest(_messages.Message):
  r"""A DirectoryUsersGetRequest object.

  Enums:
    ProjectionValueValuesEnum: What subset of fields to fetch for this user.
    ViewTypeValueValuesEnum: Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC
      view of the user.

  Fields:
    customFieldMask: Comma-separated list of schema names. All fields from
      these schemas are fetched. This should only be set when
      projection=custom.
    projection: What subset of fields to fetch for this user.
    userKey: Email or immutable ID of the user
    viewType: Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC view of the
      user.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""What subset of fields to fetch for this user.

    Values:
      basic: Do not include any custom fields for the user.
      custom: Include custom fields from schemas mentioned in customFieldMask.
      full: Include all fields associated with this user.
    """
    basic = 0
    custom = 1
    full = 2

  class ViewTypeValueValuesEnum(_messages.Enum):
    r"""Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC view of the user.

    Values:
      admin_view: Fetches the ADMIN_VIEW of the user.
      domain_public: Fetches the DOMAIN_PUBLIC view of the user.
    """
    admin_view = 0
    domain_public = 1

  customFieldMask = _messages.StringField(1)
  projection = _messages.EnumField(
      'ProjectionValueValuesEnum', 2, default=u'basic')
  userKey = _messages.StringField(3, required=True)
  viewType = _messages.EnumField(
      'ViewTypeValueValuesEnum', 4, default=u'admin_view')


class DirectoryUsersListRequest(_messages.Message):
  r"""A DirectoryUsersListRequest object.

  Enums:
    EventValueValuesEnum: Event on which subscription is intended (if
      subscribing)
    OrderByValueValuesEnum: Column to use for sorting results
    ProjectionValueValuesEnum: What subset of fields to fetch for this user.
    SortOrderValueValuesEnum: Whether to return results in ascending or
      descending order.
    ViewTypeValueValuesEnum: Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC
      view of the user.

  Fields:
    customFieldMask: Comma-separated list of schema names. All fields from
      these schemas are fetched. This should only be set when
      projection=custom.
    customer: Immutable ID of the G Suite account. In case of multi-domain, to
      fetch all users for a customer, fill this field instead of domain.
    domain: Name of the domain. Fill this field to get users from only this
      domain. To return all users in a multi-domain fill customer field
      instead.
    event: Event on which subscription is intended (if subscribing)
    maxResults: Maximum number of results to return.
    orderBy: Column to use for sorting results
    pageToken: Token to specify next page in the list
    projection: What subset of fields to fetch for this user.
    query: Query string search. Should be of the form "". Complete
      documentation is at https://developers.google.com/admin-
      sdk/directory/v1/guides/search-users
    showDeleted: If set to true, retrieves the list of deleted users.
      (Default: false)
    sortOrder: Whether to return results in ascending or descending order.
    viewType: Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC view of the
      user.
  """

  class EventValueValuesEnum(_messages.Enum):
    r"""Event on which subscription is intended (if subscribing)

    Values:
      add: User Created Event
      delete: User Deleted Event
      makeAdmin: User Admin Status Change Event
      undelete: User Undeleted Event
      update: User Updated Event
    """
    add = 0
    delete = 1
    makeAdmin = 2
    undelete = 3
    update = 4

  class OrderByValueValuesEnum(_messages.Enum):
    r"""Column to use for sorting results

    Values:
      email: Primary email of the user.
      familyName: User's family name.
      givenName: User's given name.
    """
    email = 0
    familyName = 1
    givenName = 2

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""What subset of fields to fetch for this user.

    Values:
      basic: Do not include any custom fields for the user.
      custom: Include custom fields from schemas mentioned in customFieldMask.
      full: Include all fields associated with this user.
    """
    basic = 0
    custom = 1
    full = 2

  class SortOrderValueValuesEnum(_messages.Enum):
    r"""Whether to return results in ascending or descending order.

    Values:
      ASCENDING: Ascending order.
      DESCENDING: Descending order.
    """
    ASCENDING = 0
    DESCENDING = 1

  class ViewTypeValueValuesEnum(_messages.Enum):
    r"""Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC view of the user.

    Values:
      admin_view: Fetches the ADMIN_VIEW of the user.
      domain_public: Fetches the DOMAIN_PUBLIC view of the user.
    """
    admin_view = 0
    domain_public = 1

  customFieldMask = _messages.StringField(1)
  customer = _messages.StringField(2)
  domain = _messages.StringField(3)
  event = _messages.EnumField('EventValueValuesEnum', 4)
  maxResults = _messages.IntegerField(
      5, variant=_messages.Variant.INT32, default=100)
  orderBy = _messages.EnumField('OrderByValueValuesEnum', 6)
  pageToken = _messages.StringField(7)
  projection = _messages.EnumField(
      'ProjectionValueValuesEnum', 8, default=u'basic')
  query = _messages.StringField(9)
  showDeleted = _messages.StringField(10)
  sortOrder = _messages.EnumField('SortOrderValueValuesEnum', 11)
  viewType = _messages.EnumField(
      'ViewTypeValueValuesEnum', 12, default=u'admin_view')


class DirectoryUsersMakeAdminRequest(_messages.Message):
  r"""A DirectoryUsersMakeAdminRequest object.

  Fields:
    userKey: Email or immutable ID of the user as admin
    userMakeAdmin: A UserMakeAdmin resource to be passed as the request body.
  """

  userKey = _messages.StringField(1, required=True)
  userMakeAdmin = _messages.MessageField('UserMakeAdmin', 2)


class DirectoryUsersMakeAdminResponse(_messages.Message):
  r"""An empty DirectoryUsersMakeAdmin response."""


class DirectoryUsersPatchRequest(_messages.Message):
  r"""A DirectoryUsersPatchRequest object.

  Fields:
    user: A User resource to be passed as the request body.
    userKey: Email or immutable ID of the user. If ID, it should match with id
      of user object
  """

  user = _messages.MessageField('User', 1)
  userKey = _messages.StringField(2, required=True)


class DirectoryUsersPhotosDeleteRequest(_messages.Message):
  r"""A DirectoryUsersPhotosDeleteRequest object.

  Fields:
    userKey: Email or immutable ID of the user
  """

  userKey = _messages.StringField(1, required=True)


class DirectoryUsersPhotosDeleteResponse(_messages.Message):
  r"""An empty DirectoryUsersPhotosDelete response."""


class DirectoryUsersPhotosGetRequest(_messages.Message):
  r"""A DirectoryUsersPhotosGetRequest object.

  Fields:
    userKey: Email or immutable ID of the user
  """

  userKey = _messages.StringField(1, required=True)


class DirectoryUsersPhotosPatchRequest(_messages.Message):
  r"""A DirectoryUsersPhotosPatchRequest object.

  Fields:
    userKey: Email or immutable ID of the user
    userPhoto: A UserPhoto resource to be passed as the request body.
  """

  userKey = _messages.StringField(1, required=True)
  userPhoto = _messages.MessageField('UserPhoto', 2)


class DirectoryUsersPhotosUpdateRequest(_messages.Message):
  r"""A DirectoryUsersPhotosUpdateRequest object.

  Fields:
    userKey: Email or immutable ID of the user
    userPhoto: A UserPhoto resource to be passed as the request body.
  """

  userKey = _messages.StringField(1, required=True)
  userPhoto = _messages.MessageField('UserPhoto', 2)


class DirectoryUsersUndeleteRequest(_messages.Message):
  r"""A DirectoryUsersUndeleteRequest object.

  Fields:
    userKey: The immutable id of the user
    userUndelete: A UserUndelete resource to be passed as the request body.
  """

  userKey = _messages.StringField(1, required=True)
  userUndelete = _messages.MessageField('UserUndelete', 2)


class DirectoryUsersUndeleteResponse(_messages.Message):
  r"""An empty DirectoryUsersUndelete response."""


class DirectoryUsersUpdateRequest(_messages.Message):
  r"""A DirectoryUsersUpdateRequest object.

  Fields:
    user: A User resource to be passed as the request body.
    userKey: Email or immutable ID of the user. If ID, it should match with id
      of user object
  """

  user = _messages.MessageField('User', 1)
  userKey = _messages.StringField(2, required=True)


class DirectoryUsersWatchRequest(_messages.Message):
  r"""A DirectoryUsersWatchRequest object.

  Enums:
    EventValueValuesEnum: Event on which subscription is intended (if
      subscribing)
    OrderByValueValuesEnum: Column to use for sorting results
    ProjectionValueValuesEnum: What subset of fields to fetch for this user.
    SortOrderValueValuesEnum: Whether to return results in ascending or
      descending order.
    ViewTypeValueValuesEnum: Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC
      view of the user.

  Fields:
    channel: A Channel resource to be passed as the request body.
    customFieldMask: Comma-separated list of schema names. All fields from
      these schemas are fetched. This should only be set when
      projection=custom.
    customer: Immutable ID of the G Suite account. In case of multi-domain, to
      fetch all users for a customer, fill this field instead of domain.
    domain: Name of the domain. Fill this field to get users from only this
      domain. To return all users in a multi-domain fill customer field
      instead.
    event: Event on which subscription is intended (if subscribing)
    maxResults: Maximum number of results to return.
    orderBy: Column to use for sorting results
    pageToken: Token to specify next page in the list
    projection: What subset of fields to fetch for this user.
    query: Query string search. Should be of the form "". Complete
      documentation is at https://developers.google.com/admin-
      sdk/directory/v1/guides/search-users
    showDeleted: If set to true, retrieves the list of deleted users.
      (Default: false)
    sortOrder: Whether to return results in ascending or descending order.
    viewType: Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC view of the
      user.
  """

  class EventValueValuesEnum(_messages.Enum):
    r"""Event on which subscription is intended (if subscribing)

    Values:
      add: User Created Event
      delete: User Deleted Event
      makeAdmin: User Admin Status Change Event
      undelete: User Undeleted Event
      update: User Updated Event
    """
    add = 0
    delete = 1
    makeAdmin = 2
    undelete = 3
    update = 4

  class OrderByValueValuesEnum(_messages.Enum):
    r"""Column to use for sorting results

    Values:
      email: Primary email of the user.
      familyName: User's family name.
      givenName: User's given name.
    """
    email = 0
    familyName = 1
    givenName = 2

  class ProjectionValueValuesEnum(_messages.Enum):
    r"""What subset of fields to fetch for this user.

    Values:
      basic: Do not include any custom fields for the user.
      custom: Include custom fields from schemas mentioned in customFieldMask.
      full: Include all fields associated with this user.
    """
    basic = 0
    custom = 1
    full = 2

  class SortOrderValueValuesEnum(_messages.Enum):
    r"""Whether to return results in ascending or descending order.

    Values:
      ASCENDING: Ascending order.
      DESCENDING: Descending order.
    """
    ASCENDING = 0
    DESCENDING = 1

  class ViewTypeValueValuesEnum(_messages.Enum):
    r"""Whether to fetch the ADMIN_VIEW or DOMAIN_PUBLIC view of the user.

    Values:
      admin_view: Fetches the ADMIN_VIEW of the user.
      domain_public: Fetches the DOMAIN_PUBLIC view of the user.
    """
    admin_view = 0
    domain_public = 1

  channel = _messages.MessageField('Channel', 1)
  customFieldMask = _messages.StringField(2)
  customer = _messages.StringField(3)
  domain = _messages.StringField(4)
  event = _messages.EnumField('EventValueValuesEnum', 5)
  maxResults = _messages.IntegerField(
      6, variant=_messages.Variant.INT32, default=100)
  orderBy = _messages.EnumField('OrderByValueValuesEnum', 7)
  pageToken = _messages.StringField(8)
  projection = _messages.EnumField(
      'ProjectionValueValuesEnum', 9, default=u'basic')
  query = _messages.StringField(10)
  showDeleted = _messages.StringField(11)
  sortOrder = _messages.EnumField('SortOrderValueValuesEnum', 12)
  viewType = _messages.EnumField(
      'ViewTypeValueValuesEnum', 13, default=u'admin_view')


class DirectoryVerificationCodesGenerateRequest(_messages.Message):
  r"""A DirectoryVerificationCodesGenerateRequest object.

  Fields:
    userKey: Email or immutable ID of the user
  """

  userKey = _messages.StringField(1, required=True)


class DirectoryVerificationCodesGenerateResponse(_messages.Message):
  r"""An empty DirectoryVerificationCodesGenerate response."""


class DirectoryVerificationCodesInvalidateRequest(_messages.Message):
  r"""A DirectoryVerificationCodesInvalidateRequest object.

  Fields:
    userKey: Email or immutable ID of the user
  """

  userKey = _messages.StringField(1, required=True)


class DirectoryVerificationCodesInvalidateResponse(_messages.Message):
  r"""An empty DirectoryVerificationCodesInvalidate response."""


class DirectoryVerificationCodesListRequest(_messages.Message):
  r"""A DirectoryVerificationCodesListRequest object.

  Fields:
    userKey: Identifies the user in the API request. The value can be the
      user's primary email address, alias email address, or unique user ID.
  """

  userKey = _messages.StringField(1, required=True)


class DomainAlias(_messages.Message):
  r"""JSON template for Domain Alias object in Directory API.

  Fields:
    creationTime: The creation time of the domain alias. (Read-only).
    domainAliasName: The domain alias name.
    etag: ETag of the resource.
    kind: Kind of resource this is.
    parentDomainName: The parent domain name that the domain alias is
      associated with. This can either be a primary or secondary domain name
      within a customer.
    verified: Indicates the verification state of a domain alias. (Read-only)
  """

  creationTime = _messages.IntegerField(1)
  domainAliasName = _messages.StringField(2)
  etag = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'admin#directory#domainAlias')
  parentDomainName = _messages.StringField(5)
  verified = _messages.BooleanField(6)


class DomainAliases(_messages.Message):
  r"""JSON response template to list domain aliases in Directory API.

  Fields:
    domainAliases: List of domain alias objects.
    etag: ETag of the resource.
    kind: Kind of resource this is.
  """

  domainAliases = _messages.MessageField('DomainAlias', 1, repeated=True)
  etag = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'admin#directory#domainAliases')


class Domains(_messages.Message):
  r"""JSON template for Domain object in Directory API.

  Fields:
    creationTime: Creation time of the domain. (Read-only).
    domainAliases: List of domain alias objects. (Read-only)
    domainName: The domain name of the customer.
    etag: ETag of the resource.
    isPrimary: Indicates if the domain is a primary domain (Read-only).
    kind: Kind of resource this is.
    verified: Indicates the verification state of a domain. (Read-only).
  """

  creationTime = _messages.IntegerField(1)
  domainAliases = _messages.MessageField('DomainAlias', 2, repeated=True)
  domainName = _messages.StringField(3)
  etag = _messages.StringField(4)
  isPrimary = _messages.BooleanField(5)
  kind = _messages.StringField(6, default=u'admin#directory#domain')
  verified = _messages.BooleanField(7)


class Domains2(_messages.Message):
  r"""JSON response template to list Domains in Directory API.

  Fields:
    domains: List of domain objects.
    etag: ETag of the resource.
    kind: Kind of resource this is.
  """

  domains = _messages.MessageField('Domains', 1, repeated=True)
  etag = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'admin#directory#domains')


class Feature(_messages.Message):
  r"""JSON template for Feature object in Directory API.

  Fields:
    etags: ETag of the resource.
    kind: Kind of resource this is.
    name: The name of the feature.
  """

  etags = _messages.StringField(1)
  kind = _messages.StringField(
      2, default=u'admin#directory#resources#features#Feature')
  name = _messages.StringField(3)


class FeatureInstance(_messages.Message):
  r"""JSON template for a "feature instance".

  Fields:
    feature: The feature that this is an instance of. A calendar resource may
      have multiple instances of a feature.
  """

  feature = _messages.MessageField('Feature', 1)


class FeatureRename(_messages.Message):
  r"""JSON request template for renaming a feature.

  Fields:
    newName: New name of the feature.
  """

  newName = _messages.StringField(1)


class Features(_messages.Message):
  r"""JSON template for Feature List Response object in Directory API.

  Fields:
    etag: ETag of the resource.
    features: The Features in this page of results.
    kind: Kind of resource this is.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  etag = _messages.StringField(1)
  features = _messages.MessageField('Feature', 2, repeated=True)
  kind = _messages.StringField(
      3, default=u'admin#directory#resources#features#featuresList')
  nextPageToken = _messages.StringField(4)


class Group(_messages.Message):
  r"""JSON template for Group resource in Directory API.

  Fields:
    adminCreated: Is the group created by admin (Read-only) *
    aliases: List of aliases (Read-only)
    description: Description of the group
    directMembersCount: Group direct members count
    email: Email of Group
    etag: ETag of the resource.
    id: Unique identifier of Group (Read-only)
    kind: Kind of resource this is.
    name: Group name
    nonEditableAliases: List of non editable aliases (Read-only)
  """

  adminCreated = _messages.BooleanField(1)
  aliases = _messages.StringField(2, repeated=True)
  description = _messages.StringField(3)
  directMembersCount = _messages.IntegerField(4)
  email = _messages.StringField(5)
  etag = _messages.StringField(6)
  id = _messages.StringField(7)
  kind = _messages.StringField(8, default=u'admin#directory#group')
  name = _messages.StringField(9)
  nonEditableAliases = _messages.StringField(10, repeated=True)


class Groups(_messages.Message):
  r"""JSON response template for List Groups operation in Directory API.

  Fields:
    etag: ETag of the resource.
    groups: List of group objects.
    kind: Kind of resource this is.
    nextPageToken: Token used to access next page of this result.
  """

  etag = _messages.StringField(1)
  groups = _messages.MessageField('Group', 2, repeated=True)
  kind = _messages.StringField(3, default=u'admin#directory#groups')
  nextPageToken = _messages.StringField(4)


class Member(_messages.Message):
  r"""JSON template for Member resource in Directory API.

  Fields:
    delivery_settings: Delivery settings of member
    email: Email of member (Read-only)
    etag: ETag of the resource.
    id: The unique ID of the group member. A member id can be used as a member
      request URI's memberKey. Unique identifier of group (Read-only) Unique
      identifier of member (Read-only)
    kind: Kind of resource this is.
    role: Role of member
    status: Status of member (Immutable)
    type: Type of member (Immutable)
  """

  delivery_settings = _messages.StringField(1)
  email = _messages.StringField(2)
  etag = _messages.StringField(3)
  id = _messages.StringField(4)
  kind = _messages.StringField(5, default=u'admin#directory#member')
  role = _messages.StringField(6)
  status = _messages.StringField(7)
  type = _messages.StringField(8)


class Members(_messages.Message):
  r"""JSON response template for List Members operation in Directory API.

  Fields:
    etag: ETag of the resource.
    kind: Kind of resource this is.
    members: List of member objects.
    nextPageToken: Token used to access next page of this result.
  """

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'admin#directory#members')
  members = _messages.MessageField('Member', 3, repeated=True)
  nextPageToken = _messages.StringField(4)


class MembersHasMember(_messages.Message):
  r"""JSON template for Has Member response in Directory API.

  Fields:
    isMember: Identifies whether the given user is a member of the group.
      Membership can be direct or nested.
  """

  isMember = _messages.BooleanField(1)


class MobileDevice(_messages.Message):
  r"""JSON template for Mobile Device resource in Directory API.

  Messages:
    ApplicationsValueListEntry: A ApplicationsValueListEntry object.

  Fields:
    adbStatus: Adb (USB debugging) enabled or disabled on device (Read-only)
    applications: List of applications installed on Mobile Device
    basebandVersion: Mobile Device Baseband version (Read-only)
    bootloaderVersion: Mobile Device Bootloader version (Read-only)
    brand: Mobile Device Brand (Read-only)
    buildNumber: Mobile Device Build number (Read-only)
    defaultLanguage: The default locale used on the Mobile Device (Read-only)
    developerOptionsStatus: Developer options enabled or disabled on device
      (Read-only)
    deviceCompromisedStatus: Mobile Device compromised status (Read-only)
    deviceId: Mobile Device serial number (Read-only)
    devicePasswordStatus: DevicePasswordStatus (Read-only)
    email: List of owner user's email addresses (Read-only)
    encryptionStatus: Mobile Device Encryption Status (Read-only)
    etag: ETag of the resource.
    firstSync: Date and time the device was first synchronized with the policy
      settings in the G Suite administrator control panel (Read-only)
    hardware: Mobile Device Hardware (Read-only)
    hardwareId: Mobile Device Hardware Id (Read-only)
    imei: Mobile Device IMEI number (Read-only)
    kernelVersion: Mobile Device Kernel version (Read-only)
    kind: Kind of resource this is.
    lastSync: Date and time the device was last synchronized with the policy
      settings in the G Suite administrator control panel (Read-only)
    managedAccountIsOnOwnerProfile: Boolean indicating if this account is on
      owner/primary profile or not (Read-only)
    manufacturer: Mobile Device manufacturer (Read-only)
    meid: Mobile Device MEID number (Read-only)
    model: Name of the model of the device
    name: List of owner user's names (Read-only)
    networkOperator: Mobile Device mobile or network operator (if available)
      (Read-only)
    os: Name of the mobile operating system
    otherAccountsInfo: List of accounts added on device (Read-only)
    privilege: DMAgentPermission (Read-only)
    releaseVersion: Mobile Device release version version (Read-only)
    resourceId: Unique identifier of Mobile Device (Read-only)
    securityPatchLevel: Mobile Device Security patch level (Read-only)
    serialNumber: Mobile Device SSN or Serial Number (Read-only)
    status: Status of the device (Read-only)
    supportsWorkProfile: Work profile supported on device (Read-only)
    type: The type of device (Read-only)
    unknownSourcesStatus: Unknown sources enabled or disabled on device (Read-
      only)
    userAgent: Mobile Device user agent
    wifiMacAddress: Mobile Device WiFi MAC address (Read-only)
  """

  class ApplicationsValueListEntry(_messages.Message):
    r"""A ApplicationsValueListEntry object.

    Fields:
      displayName: Display name of application
      packageName: Package name of application
      permission: List of Permissions for application
      versionCode: Version code of application
      versionName: Version name of application
    """

    displayName = _messages.StringField(1)
    packageName = _messages.StringField(2)
    permission = _messages.StringField(3, repeated=True)
    versionCode = _messages.IntegerField(4, variant=_messages.Variant.INT32)
    versionName = _messages.StringField(5)

  adbStatus = _messages.BooleanField(1)
  applications = _messages.MessageField(
      'ApplicationsValueListEntry', 2, repeated=True)
  basebandVersion = _messages.StringField(3)
  bootloaderVersion = _messages.StringField(4)
  brand = _messages.StringField(5)
  buildNumber = _messages.StringField(6)
  defaultLanguage = _messages.StringField(7)
  developerOptionsStatus = _messages.BooleanField(8)
  deviceCompromisedStatus = _messages.StringField(9)
  deviceId = _messages.StringField(10)
  devicePasswordStatus = _messages.StringField(11)
  email = _messages.StringField(12, repeated=True)
  encryptionStatus = _messages.StringField(13)
  etag = _messages.StringField(14)
  firstSync = _message_types.DateTimeField(15)
  hardware = _messages.StringField(16)
  hardwareId = _messages.StringField(17)
  imei = _messages.StringField(18)
  kernelVersion = _messages.StringField(19)
  kind = _messages.StringField(20, default=u'admin#directory#mobiledevice')
  lastSync = _message_types.DateTimeField(21)
  managedAccountIsOnOwnerProfile = _messages.BooleanField(22)
  manufacturer = _messages.StringField(23)
  meid = _messages.StringField(24)
  model = _messages.StringField(25)
  name = _messages.StringField(26, repeated=True)
  networkOperator = _messages.StringField(27)
  os = _messages.StringField(28)
  otherAccountsInfo = _messages.StringField(29, repeated=True)
  privilege = _messages.StringField(30)
  releaseVersion = _messages.StringField(31)
  resourceId = _messages.StringField(32)
  securityPatchLevel = _messages.IntegerField(33)
  serialNumber = _messages.StringField(34)
  status = _messages.StringField(35)
  supportsWorkProfile = _messages.BooleanField(36)
  type = _messages.StringField(37)
  unknownSourcesStatus = _messages.BooleanField(38)
  userAgent = _messages.StringField(39)
  wifiMacAddress = _messages.StringField(40)


class MobileDeviceAction(_messages.Message):
  r"""JSON request template for firing commands on Mobile Device in Directory

  Devices API.

  Fields:
    action: Action to be taken on the Mobile Device
  """

  action = _messages.StringField(1)


class MobileDevices(_messages.Message):
  r"""JSON response template for List Mobile Devices operation in Directory

  API.

  Fields:
    etag: ETag of the resource.
    kind: Kind of resource this is.
    mobiledevices: List of Mobile Device objects.
    nextPageToken: Token used to access next page of this result.
  """

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'admin#directory#mobiledevices')
  mobiledevices = _messages.MessageField('MobileDevice', 3, repeated=True)
  nextPageToken = _messages.StringField(4)


class Notification(_messages.Message):
  r"""Template for a notification resource.

  Fields:
    body: Body of the notification (Read-only)
    etag: ETag of the resource.
    fromAddress: Address from which the notification is received (Read-only)
    isUnread: Boolean indicating whether the notification is unread or not.
    kind: The type of the resource.
    notificationId: A string attribute.
    sendTime: Time at which notification was sent (Read-only)
    subject: Subject of the notification (Read-only)
  """

  body = _messages.StringField(1)
  etag = _messages.StringField(2)
  fromAddress = _messages.StringField(3)
  isUnread = _messages.BooleanField(4)
  kind = _messages.StringField(5, default=u'admin#directory#notification')
  notificationId = _messages.StringField(6)
  sendTime = _message_types.DateTimeField(7)
  subject = _messages.StringField(8)


class Notifications(_messages.Message):
  r"""Template for notifications list response.

  Fields:
    etag: ETag of the resource.
    items: List of notifications in this page.
    kind: The type of the resource.
    nextPageToken: Token for fetching the next page of notifications.
    unreadNotificationsCount: Number of unread notification for the domain.
  """

  etag = _messages.StringField(1)
  items = _messages.MessageField('Notification', 2, repeated=True)
  kind = _messages.StringField(3, default=u'admin#directory#notifications')
  nextPageToken = _messages.StringField(4)
  unreadNotificationsCount = _messages.IntegerField(
      5, variant=_messages.Variant.INT32)


class OrgUnit(_messages.Message):
  r"""JSON template for Org Unit resource in Directory API.

  Fields:
    blockInheritance: Should block inheritance
    description: Description of OrgUnit
    etag: ETag of the resource.
    kind: Kind of resource this is.
    name: Name of OrgUnit
    orgUnitId: Id of OrgUnit
    orgUnitPath: Path of OrgUnit
    parentOrgUnitId: Id of parent OrgUnit
    parentOrgUnitPath: Path of parent OrgUnit
  """

  blockInheritance = _messages.BooleanField(1)
  description = _messages.StringField(2)
  etag = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'admin#directory#orgUnit')
  name = _messages.StringField(5)
  orgUnitId = _messages.StringField(6)
  orgUnitPath = _messages.StringField(7)
  parentOrgUnitId = _messages.StringField(8)
  parentOrgUnitPath = _messages.StringField(9)


class OrgUnits(_messages.Message):
  r"""JSON response template for List Organization Units operation in

  Directory API.

  Fields:
    etag: ETag of the resource.
    kind: Kind of resource this is.
    organizationUnits: List of user objects.
  """

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'admin#directory#orgUnits')
  organizationUnits = _messages.MessageField('OrgUnit', 3, repeated=True)


class Privilege(_messages.Message):
  r"""JSON template for privilege resource in Directory API.

  Fields:
    childPrivileges: A list of child privileges. Privileges for a service form
      a tree. Each privilege can have a list of child privileges; this list is
      empty for a leaf privilege.
    etag: ETag of the resource.
    isOuScopable: If the privilege can be restricted to an organization unit.
    kind: The type of the API resource. This is always
      admin#directory#privilege.
    privilegeName: The name of the privilege.
    serviceId: The obfuscated ID of the service this privilege is for. This
      value is returned with Privileges.list().
    serviceName: The name of the service this privilege is for.
  """

  childPrivileges = _messages.MessageField('Privilege', 1, repeated=True)
  etag = _messages.StringField(2)
  isOuScopable = _messages.BooleanField(3)
  kind = _messages.StringField(4, default=u'admin#directory#privilege')
  privilegeName = _messages.StringField(5)
  serviceId = _messages.StringField(6)
  serviceName = _messages.StringField(7)


class Privileges(_messages.Message):
  r"""JSON response template for List privileges operation in Directory API.

  Fields:
    etag: ETag of the resource.
    items: A list of Privilege resources.
    kind: The type of the API resource. This is always
      admin#directory#privileges.
  """

  etag = _messages.StringField(1)
  items = _messages.MessageField('Privilege', 2, repeated=True)
  kind = _messages.StringField(3, default=u'admin#directory#privileges')


class Role(_messages.Message):
  r"""JSON template for role resource in Directory API.

  Messages:
    RolePrivilegesValueListEntry: A RolePrivilegesValueListEntry object.

  Fields:
    etag: ETag of the resource.
    isSuperAdminRole: Returns true if the role is a super admin role.
    isSystemRole: Returns true if this is a pre-defined system role.
    kind: The type of the API resource. This is always admin#directory#role.
    roleDescription: A short description of the role.
    roleId: ID of the role.
    roleName: Name of the role.
    rolePrivileges: The set of privileges that are granted to this role.
  """

  class RolePrivilegesValueListEntry(_messages.Message):
    r"""A RolePrivilegesValueListEntry object.

    Fields:
      privilegeName: The name of the privilege.
      serviceId: The obfuscated ID of the service this privilege is for. This
        value is returned with Privileges.list().
    """

    privilegeName = _messages.StringField(1)
    serviceId = _messages.StringField(2)

  etag = _messages.StringField(1)
  isSuperAdminRole = _messages.BooleanField(2)
  isSystemRole = _messages.BooleanField(3)
  kind = _messages.StringField(4, default=u'admin#directory#role')
  roleDescription = _messages.StringField(5)
  roleId = _messages.IntegerField(6)
  roleName = _messages.StringField(7)
  rolePrivileges = _messages.MessageField(
      'RolePrivilegesValueListEntry', 8, repeated=True)


class RoleAssignment(_messages.Message):
  r"""JSON template for roleAssignment resource in Directory API.

  Fields:
    assignedTo: The unique ID of the user this role is assigned to.
    etag: ETag of the resource.
    kind: The type of the API resource. This is always
      admin#directory#roleAssignment.
    orgUnitId: If the role is restricted to an organization unit, this
      contains the ID for the organization unit the exercise of this role is
      restricted to.
    roleAssignmentId: ID of this roleAssignment.
    roleId: The ID of the role that is assigned.
    scopeType: The scope in which this role is assigned. Possible values are:
      - CUSTOMER - ORG_UNIT
  """

  assignedTo = _messages.StringField(1)
  etag = _messages.StringField(2)
  kind = _messages.StringField(3, default=u'admin#directory#roleAssignment')
  orgUnitId = _messages.StringField(4)
  roleAssignmentId = _messages.IntegerField(5)
  roleId = _messages.IntegerField(6)
  scopeType = _messages.StringField(7)


class RoleAssignments(_messages.Message):
  r"""JSON response template for List roleAssignments operation in Directory

  API.

  Fields:
    etag: ETag of the resource.
    items: A list of RoleAssignment resources.
    kind: The type of the API resource. This is always
      admin#directory#roleAssignments.
    nextPageToken: A string attribute.
  """

  etag = _messages.StringField(1)
  items = _messages.MessageField('RoleAssignment', 2, repeated=True)
  kind = _messages.StringField(3, default=u'admin#directory#roleAssignments')
  nextPageToken = _messages.StringField(4)


class Roles(_messages.Message):
  r"""JSON response template for List roles operation in Directory API.

  Fields:
    etag: ETag of the resource.
    items: A list of Role resources.
    kind: The type of the API resource. This is always admin#directory#roles.
    nextPageToken: A string attribute.
  """

  etag = _messages.StringField(1)
  items = _messages.MessageField('Role', 2, repeated=True)
  kind = _messages.StringField(3, default=u'admin#directory#roles')
  nextPageToken = _messages.StringField(4)


class Schema(_messages.Message):
  r"""JSON template for Schema resource in Directory API.

  Fields:
    displayName: Display name for the schema.
    etag: ETag of the resource.
    fields: Fields of Schema
    kind: Kind of resource this is.
    schemaId: Unique identifier of Schema (Read-only)
    schemaName: Schema name
  """

  displayName = _messages.StringField(1)
  etag = _messages.StringField(2)
  fields = _messages.MessageField('SchemaFieldSpec', 3, repeated=True)
  kind = _messages.StringField(4, default=u'admin#directory#schema')
  schemaId = _messages.StringField(5)
  schemaName = _messages.StringField(6)


class SchemaFieldSpec(_messages.Message):
  r"""JSON template for FieldSpec resource for Schemas in Directory API.

  Messages:
    NumericIndexingSpecValue: Indexing spec for a numeric field. By default,
      only exact match queries will be supported for numeric fields. Setting
      the numericIndexingSpec allows range queries to be supported.

  Fields:
    displayName: Display Name of the field.
    etag: ETag of the resource.
    fieldId: Unique identifier of Field (Read-only)
    fieldName: Name of the field.
    fieldType: Type of the field.
    indexed: Boolean specifying whether the field is indexed or not.
    kind: Kind of resource this is.
    multiValued: Boolean specifying whether this is a multi-valued field or
      not.
    numericIndexingSpec: Indexing spec for a numeric field. By default, only
      exact match queries will be supported for numeric fields. Setting the
      numericIndexingSpec allows range queries to be supported.
    readAccessType: Read ACLs on the field specifying who can view values of
      this field. Valid values are "ALL_DOMAIN_USERS" and "ADMINS_AND_SELF".
  """

  class NumericIndexingSpecValue(_messages.Message):
    r"""Indexing spec for a numeric field.

    By default, only exact match
    queries will be supported for numeric fields. Setting the
    numericIndexingSpec allows range queries to be supported.

    Fields:
      maxValue: Maximum value of this field. This is meant to be indicative
        rather than enforced. Values outside this range will still be indexed,
        but search may not be as performant.
      minValue: Minimum value of this field. This is meant to be indicative
        rather than enforced. Values outside this range will still be indexed,
        but search may not be as performant.
    """

    maxValue = _messages.FloatField(1)
    minValue = _messages.FloatField(2)

  displayName = _messages.StringField(1)
  etag = _messages.StringField(2)
  fieldId = _messages.StringField(3)
  fieldName = _messages.StringField(4)
  fieldType = _messages.StringField(5)
  indexed = _messages.BooleanField(6, default=True)
  kind = _messages.StringField(7, default=u'admin#directory#schema#fieldspec')
  multiValued = _messages.BooleanField(8)
  numericIndexingSpec = _messages.MessageField('NumericIndexingSpecValue', 9)
  readAccessType = _messages.StringField(10, default=u'ALL_DOMAIN_USERS')


class Schemas(_messages.Message):
  r"""JSON response template for List Schema operation in Directory API.

  Fields:
    etag: ETag of the resource.
    kind: Kind of resource this is.
    schemas: List of UserSchema objects.
  """

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'admin#directory#schemas')
  schemas = _messages.MessageField('Schema', 3, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: An opaque string that represents a user for quota purposes.
      Must not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: Deprecated. Please use quotaUser instead.
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class Token(_messages.Message):
  r"""JSON template for token resource in Directory API.

  Fields:
    anonymous: Whether the application is registered with Google. The value is
      true if the application has an anonymous Client ID.
    clientId: The Client ID of the application the token is issued to.
    displayText: The displayable name of the application the token is issued
      to.
    etag: ETag of the resource.
    kind: The type of the API resource. This is always admin#directory#token.
    nativeApp: Whether the token is issued to an installed application. The
      value is true if the application is installed to a desktop or mobile
      device.
    scopes: A list of authorization scopes the application is granted.
    userKey: The unique ID of the user that issued the token.
  """

  anonymous = _messages.BooleanField(1)
  clientId = _messages.StringField(2)
  displayText = _messages.StringField(3)
  etag = _messages.StringField(4)
  kind = _messages.StringField(5, default=u'admin#directory#token')
  nativeApp = _messages.BooleanField(6)
  scopes = _messages.StringField(7, repeated=True)
  userKey = _messages.StringField(8)


class Tokens(_messages.Message):
  r"""JSON response template for List tokens operation in Directory API.

  Fields:
    etag: ETag of the resource.
    items: A list of Token resources.
    kind: The type of the API resource. This is always
      admin#directory#tokenList.
  """

  etag = _messages.StringField(1)
  items = _messages.MessageField('Token', 2, repeated=True)
  kind = _messages.StringField(3, default=u'admin#directory#tokenList')


class TrustedAppId(_messages.Message):
  r"""JSON template for Trusted App Ids Resource object in Directory API.

  Fields:
    androidPackageName: Android package name.
    certificateHashSHA1: SHA1 signature of the app certificate.
    certificateHashSHA256: SHA256 signature of the app certificate.
    etag: A string attribute.
    kind: Identifies the resource as a trusted AppId.
  """

  androidPackageName = _messages.StringField(1)
  certificateHashSHA1 = _messages.StringField(2)
  certificateHashSHA256 = _messages.StringField(3)
  etag = _messages.StringField(4)
  kind = _messages.StringField(5, default=u'admin#directory#trustedappid')


class TrustedApps(_messages.Message):
  r"""JSON template for Trusted Apps response object of a user in Directory

  API.

  Fields:
    etag: ETag of the resource.
    kind: Identifies the resource as trusted apps response.
    nextPageToken: A string attribute.
    trustedApps: Trusted Apps list.
  """

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'admin#directory#trustedapplist')
  nextPageToken = _messages.StringField(3)
  trustedApps = _messages.MessageField('TrustedAppId', 4, repeated=True)


class User(_messages.Message):
  r"""JSON template for User object in Directory API.

  Messages:
    CustomSchemasValue: Custom fields of the user.

  Fields:
    addresses: A extra_types.JsonValue attribute.
    agreedToTerms: Indicates if user has agreed to terms (Read-only)
    aliases: List of aliases (Read-only)
    archived: Indicates if user is archived.
    changePasswordAtNextLogin: Boolean indicating if the user should change
      password in next login
    creationTime: User's G Suite account creation time. (Read-only)
    customSchemas: Custom fields of the user.
    customerId: CustomerId of User (Read-only)
    deletionTime: A apitools.base.protorpclite.message_types.DateTimeMessage
      attribute.
    emails: A extra_types.JsonValue attribute.
    etag: ETag of the resource.
    externalIds: A extra_types.JsonValue attribute.
    gender: A extra_types.JsonValue attribute.
    hashFunction: Hash function name for password. Supported are MD5, SHA-1
      and crypt
    id: Unique identifier of User (Read-only)
    ims: A extra_types.JsonValue attribute.
    includeInGlobalAddressList: Boolean indicating if user is included in
      Global Address List
    ipWhitelisted: Boolean indicating if ip is whitelisted
    isAdmin: Boolean indicating if the user is admin (Read-only)
    isDelegatedAdmin: Boolean indicating if the user is delegated admin (Read-
      only)
    isEnforcedIn2Sv: Is 2-step verification enforced (Read-only)
    isEnrolledIn2Sv: Is enrolled in 2-step verification (Read-only)
    isMailboxSetup: Is mailbox setup (Read-only)
    keywords: A extra_types.JsonValue attribute.
    kind: Kind of resource this is.
    languages: A extra_types.JsonValue attribute.
    lastLoginTime: User's last login time. (Read-only)
    locations: A extra_types.JsonValue attribute.
    name: User's name
    nonEditableAliases: List of non editable aliases (Read-only)
    notes: A extra_types.JsonValue attribute.
    orgUnitPath: OrgUnit of User
    organizations: A extra_types.JsonValue attribute.
    password: User's password
    phones: A extra_types.JsonValue attribute.
    posixAccounts: A extra_types.JsonValue attribute.
    primaryEmail: username of User
    recoveryEmail: Recovery email of the user.
    recoveryPhone: Recovery phone of the user. The phone number must be in the
      E.164 format, starting with the plus sign (+). Example: +16506661212.
    relations: A extra_types.JsonValue attribute.
    sshPublicKeys: A extra_types.JsonValue attribute.
    suspended: Indicates if user is suspended.
    suspensionReason: Suspension reason if user is suspended (Read-only)
    thumbnailPhotoEtag: ETag of the user's photo (Read-only)
    thumbnailPhotoUrl: Photo Url of the user (Read-only)
    websites: A extra_types.JsonValue attribute.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class CustomSchemasValue(_messages.Message):
    r"""Custom fields of the user.

    Messages:
      AdditionalProperty: An additional property for a CustomSchemasValue
        object.

    Fields:
      additionalProperties: Additional properties of type CustomSchemasValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a CustomSchemasValue object.

      Fields:
        key: Name of the additional property.
        value: A UserCustomProperties attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('UserCustomProperties', 2)

    additionalProperties = _messages.MessageField(
        'AdditionalProperty', 1, repeated=True)

  addresses = _messages.MessageField('extra_types.JsonValue', 1)
  agreedToTerms = _messages.BooleanField(2)
  aliases = _messages.StringField(3, repeated=True)
  archived = _messages.BooleanField(4)
  changePasswordAtNextLogin = _messages.BooleanField(5)
  creationTime = _message_types.DateTimeField(6)
  customSchemas = _messages.MessageField('CustomSchemasValue', 7)
  customerId = _messages.StringField(8)
  deletionTime = _message_types.DateTimeField(9)
  emails = _messages.MessageField('extra_types.JsonValue', 10)
  etag = _messages.StringField(11)
  externalIds = _messages.MessageField('extra_types.JsonValue', 12)
  gender = _messages.MessageField('extra_types.JsonValue', 13)
  hashFunction = _messages.StringField(14)
  id = _messages.StringField(15)
  ims = _messages.MessageField('extra_types.JsonValue', 16)
  includeInGlobalAddressList = _messages.BooleanField(17)
  ipWhitelisted = _messages.BooleanField(18)
  isAdmin = _messages.BooleanField(19)
  isDelegatedAdmin = _messages.BooleanField(20)
  isEnforcedIn2Sv = _messages.BooleanField(21)
  isEnrolledIn2Sv = _messages.BooleanField(22)
  isMailboxSetup = _messages.BooleanField(23)
  keywords = _messages.MessageField('extra_types.JsonValue', 24)
  kind = _messages.StringField(25, default=u'admin#directory#user')
  languages = _messages.MessageField('extra_types.JsonValue', 26)
  lastLoginTime = _message_types.DateTimeField(27)
  locations = _messages.MessageField('extra_types.JsonValue', 28)
  name = _messages.MessageField('UserName', 29)
  nonEditableAliases = _messages.StringField(30, repeated=True)
  notes = _messages.MessageField('extra_types.JsonValue', 31)
  orgUnitPath = _messages.StringField(32)
  organizations = _messages.MessageField('extra_types.JsonValue', 33)
  password = _messages.StringField(34)
  phones = _messages.MessageField('extra_types.JsonValue', 35)
  posixAccounts = _messages.MessageField('extra_types.JsonValue', 36)
  primaryEmail = _messages.StringField(37)
  recoveryEmail = _messages.StringField(38)
  recoveryPhone = _messages.StringField(39)
  relations = _messages.MessageField('extra_types.JsonValue', 40)
  sshPublicKeys = _messages.MessageField('extra_types.JsonValue', 41)
  suspended = _messages.BooleanField(42)
  suspensionReason = _messages.StringField(43)
  thumbnailPhotoEtag = _messages.StringField(44)
  thumbnailPhotoUrl = _messages.StringField(45)
  websites = _messages.MessageField('extra_types.JsonValue', 46)


class UserAbout(_messages.Message):
  r"""JSON template for About (notes) of a user in Directory API.

  Fields:
    contentType: About entry can have a type which indicates the content type.
      It can either be plain or html. By default, notes contents are assumed
      to contain plain text.
    value: Actual value of notes.
  """

  contentType = _messages.StringField(1)
  value = _messages.StringField(2)


class UserAddress(_messages.Message):
  r"""JSON template for address.

  Fields:
    country: Country.
    countryCode: Country code.
    customType: Custom type.
    extendedAddress: Extended Address.
    formatted: Formatted address.
    locality: Locality.
    poBox: Other parts of address.
    postalCode: Postal code.
    primary: If this is user's primary address. Only one entry could be marked
      as primary.
    region: Region.
    sourceIsStructured: User supplied address was structured. Structured
      addresses are NOT supported at this time. You might be able to write
      structured addresses, but any values will eventually be clobbered.
    streetAddress: Street.
    type: Each entry can have a type which indicates standard values of that
      entry. For example address could be of home, work etc. In addition to
      the standard type, an entry can have a custom type and can take any
      value. Such type should have the CUSTOM value as type and also have a
      customType value.
  """

  country = _messages.StringField(1)
  countryCode = _messages.StringField(2)
  customType = _messages.StringField(3)
  extendedAddress = _messages.StringField(4)
  formatted = _messages.StringField(5)
  locality = _messages.StringField(6)
  poBox = _messages.StringField(7)
  postalCode = _messages.StringField(8)
  primary = _messages.BooleanField(9)
  region = _messages.StringField(10)
  sourceIsStructured = _messages.BooleanField(11)
  streetAddress = _messages.StringField(12)
  type = _messages.StringField(13)


@encoding.MapUnrecognizedFields('additionalProperties')
class UserCustomProperties(_messages.Message):
  r"""JSON template for a set of custom properties (i.e.

  all fields in a
  particular schema)

  Messages:
    AdditionalProperty: An additional property for a UserCustomProperties
      object.

  Fields:
    additionalProperties: Additional properties of type UserCustomProperties
  """

  class AdditionalProperty(_messages.Message):
    r"""An additional property for a UserCustomProperties object.

    Fields:
      key: Name of the additional property.
      value: A extra_types.JsonValue attribute.
    """

    key = _messages.StringField(1)
    value = _messages.MessageField('extra_types.JsonValue', 2)

  additionalProperties = _messages.MessageField(
      'AdditionalProperty', 1, repeated=True)


class UserEmail(_messages.Message):
  r"""JSON template for an email.

  Fields:
    address: Email id of the user.
    customType: Custom Type.
    primary: If this is user's primary email. Only one entry could be marked
      as primary.
    type: Each entry can have a type which indicates standard types of that
      entry. For example email could be of home, work etc. In addition to the
      standard type, an entry can have a custom type and can take any value
      Such types should have the CUSTOM value as type and also have a
      customType value.
  """

  address = _messages.StringField(1)
  customType = _messages.StringField(2)
  primary = _messages.BooleanField(3)
  type = _messages.StringField(4)


class UserExternalId(_messages.Message):
  r"""JSON template for an externalId entry.

  Fields:
    customType: Custom type.
    type: The type of the Id.
    value: The value of the id.
  """

  customType = _messages.StringField(1)
  type = _messages.StringField(2)
  value = _messages.StringField(3)


class UserGender(_messages.Message):
  r"""A UserGender object.

  Fields:
    addressMeAs: AddressMeAs. A human-readable string containing the proper
      way to refer to the profile owner by humans, for example "he/him/his" or
      "they/them/their".
    customGender: Custom gender.
    type: Gender.
  """

  addressMeAs = _messages.StringField(1)
  customGender = _messages.StringField(2)
  type = _messages.StringField(3)


class UserIm(_messages.Message):
  r"""JSON template for instant messenger of a user.

  Fields:
    customProtocol: Custom protocol.
    customType: Custom type.
    im: Instant messenger id.
    primary: If this is user's primary im. Only one entry could be marked as
      primary.
    protocol: Protocol used in the instant messenger. It should be one of the
      values from ImProtocolTypes map. Similar to type, it can take a CUSTOM
      value and specify the custom name in customProtocol field.
    type: Each entry can have a type which indicates standard types of that
      entry. For example instant messengers could be of home, work etc. In
      addition to the standard type, an entry can have a custom type and can
      take any value. Such types should have the CUSTOM value as type and also
      have a customType value.
  """

  customProtocol = _messages.StringField(1)
  customType = _messages.StringField(2)
  im = _messages.StringField(3)
  primary = _messages.BooleanField(4)
  protocol = _messages.StringField(5)
  type = _messages.StringField(6)


class UserKeyword(_messages.Message):
  r"""JSON template for a keyword entry.

  Fields:
    customType: Custom Type.
    type: Each entry can have a type which indicates standard type of that
      entry. For example, keyword could be of type occupation or outlook. In
      addition to the standard type, an entry can have a custom type and can
      give it any name. Such types should have the CUSTOM value as type and
      also have a customType value.
    value: Keyword.
  """

  customType = _messages.StringField(1)
  type = _messages.StringField(2)
  value = _messages.StringField(3)


class UserLanguage(_messages.Message):
  r"""JSON template for a language entry.

  Fields:
    customLanguage: Other language. User can provide own language name if
      there is no corresponding Google III language code. If this is set
      LanguageCode can't be set
    languageCode: Language Code. Should be used for storing Google III
      LanguageCode string representation for language. Illegal values cause
      SchemaException.
  """

  customLanguage = _messages.StringField(1)
  languageCode = _messages.StringField(2)


class UserLocation(_messages.Message):
  r"""JSON template for a location entry.

  Fields:
    area: Textual location. This is most useful for display purposes to
      concisely describe the location. For example, "Mountain View, CA", "Near
      Seattle", "US-NYC-9TH 9A209A".
    buildingId: Building Identifier.
    customType: Custom Type.
    deskCode: Most specific textual code of individual desk location.
    floorName: Floor name/number.
    floorSection: Floor section. More specific location within the floor. For
      example, if a floor is divided into sections "A", "B", and "C", this
      field would identify one of those values.
    type: Each entry can have a type which indicates standard types of that
      entry. For example location could be of types default and desk. In
      addition to standard type, an entry can have a custom type and can give
      it any name. Such types should have "custom" as type and also have a
      customType value.
  """

  area = _messages.StringField(1)
  buildingId = _messages.StringField(2)
  customType = _messages.StringField(3)
  deskCode = _messages.StringField(4)
  floorName = _messages.StringField(5)
  floorSection = _messages.StringField(6)
  type = _messages.StringField(7)


class UserMakeAdmin(_messages.Message):
  r"""JSON request template for setting/revoking admin status of a user in

  Directory API.

  Fields:
    status: Boolean indicating new admin status of the user
  """

  status = _messages.BooleanField(1)


class UserName(_messages.Message):
  r"""JSON template for name of a user in Directory API.

  Fields:
    familyName: Last Name
    fullName: Full Name
    givenName: First Name
  """

  familyName = _messages.StringField(1)
  fullName = _messages.StringField(2)
  givenName = _messages.StringField(3)


class UserOrganization(_messages.Message):
  r"""JSON template for an organization entry.

  Fields:
    costCenter: The cost center of the users department.
    customType: Custom type.
    department: Department within the organization.
    description: Description of the organization.
    domain: The domain to which the organization belongs to.
    fullTimeEquivalent: The full-time equivalent millipercent within the
      organization (100000 = 100%).
    location: Location of the organization. This need not be fully qualified
      address.
    name: Name of the organization
    primary: If it user's primary organization.
    symbol: Symbol of the organization.
    title: Title (designation) of the user in the organization.
    type: Each entry can have a type which indicates standard types of that
      entry. For example organization could be of school, work etc. In
      addition to the standard type, an entry can have a custom type and can
      give it any name. Such types should have the CUSTOM value as type and
      also have a CustomType value.
  """

  costCenter = _messages.StringField(1)
  customType = _messages.StringField(2)
  department = _messages.StringField(3)
  description = _messages.StringField(4)
  domain = _messages.StringField(5)
  fullTimeEquivalent = _messages.IntegerField(
      6, variant=_messages.Variant.INT32)
  location = _messages.StringField(7)
  name = _messages.StringField(8)
  primary = _messages.BooleanField(9)
  symbol = _messages.StringField(10)
  title = _messages.StringField(11)
  type = _messages.StringField(12)


class UserPhone(_messages.Message):
  r"""JSON template for a phone entry.

  Fields:
    customType: Custom Type.
    primary: If this is user's primary phone or not.
    type: Each entry can have a type which indicates standard types of that
      entry. For example phone could be of home_fax, work, mobile etc. In
      addition to the standard type, an entry can have a custom type and can
      give it any name. Such types should have the CUSTOM value as type and
      also have a customType value.
    value: Phone number.
  """

  customType = _messages.StringField(1)
  primary = _messages.BooleanField(2)
  type = _messages.StringField(3)
  value = _messages.StringField(4)


class UserPhoto(_messages.Message):
  r"""JSON template for Photo object in Directory API.

  Fields:
    etag: ETag of the resource.
    height: Height in pixels of the photo
    id: Unique identifier of User (Read-only)
    kind: Kind of resource this is.
    mimeType: Mime Type of the photo
    photoData: Base64 encoded photo data
    primaryEmail: Primary email of User (Read-only)
    width: Width in pixels of the photo
  """

  etag = _messages.StringField(1)
  height = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  id = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'admin#directory#user#photo')
  mimeType = _messages.StringField(5)
  photoData = _messages.BytesField(6)
  primaryEmail = _messages.StringField(7)
  width = _messages.IntegerField(8, variant=_messages.Variant.INT32)


class UserPosixAccount(_messages.Message):
  r"""JSON template for a POSIX account entry.

  Description of the field
  family: go/fbs-posix.

  Fields:
    accountId: A POSIX account field identifier.
    gecos: The GECOS (user information) for this account.
    gid: The default group ID.
    homeDirectory: The path to the home directory for this account.
    operatingSystemType: The operating system type for this account.
    primary: If this is user's primary account within the SystemId.
    shell: The path to the login shell for this account.
    systemId: System identifier for which account Username or Uid apply to.
    uid: The POSIX compliant user ID.
    username: The username of the account.
  """

  accountId = _messages.StringField(1)
  gecos = _messages.StringField(2)
  gid = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  homeDirectory = _messages.StringField(4)
  operatingSystemType = _messages.StringField(5)
  primary = _messages.BooleanField(6)
  shell = _messages.StringField(7)
  systemId = _messages.StringField(8)
  uid = _messages.IntegerField(9, variant=_messages.Variant.UINT64)
  username = _messages.StringField(10)


class UserRelation(_messages.Message):
  r"""JSON template for a relation entry.

  Fields:
    customType: Custom Type.
    type: The relation of the user. Some of the possible values are mother,
      father, sister, brother, manager, assistant, partner.
    value: The name of the relation.
  """

  customType = _messages.StringField(1)
  type = _messages.StringField(2)
  value = _messages.StringField(3)


class UserSshPublicKey(_messages.Message):
  r"""JSON template for a POSIX account entry.

  Fields:
    expirationTimeUsec: An expiration time in microseconds since epoch.
    fingerprint: A SHA-256 fingerprint of the SSH public key. (Read-only)
    key: An SSH public key.
  """

  expirationTimeUsec = _messages.IntegerField(1)
  fingerprint = _messages.StringField(2)
  key = _messages.StringField(3)


class UserUndelete(_messages.Message):
  r"""JSON request template to undelete a user in Directory API.

  Fields:
    orgUnitPath: OrgUnit of User
  """

  orgUnitPath = _messages.StringField(1)


class UserWebsite(_messages.Message):
  r"""JSON template for a website entry.

  Fields:
    customType: Custom Type.
    primary: If this is user's primary website or not.
    type: Each entry can have a type which indicates standard types of that
      entry. For example website could be of home, work, blog etc. In addition
      to the standard type, an entry can have a custom type and can give it
      any name. Such types should have the CUSTOM value as type and also have
      a customType value.
    value: Website.
  """

  customType = _messages.StringField(1)
  primary = _messages.BooleanField(2)
  type = _messages.StringField(3)
  value = _messages.StringField(4)


class Users(_messages.Message):
  r"""JSON response template for List Users operation in Apps Directory API.

  Fields:
    etag: ETag of the resource.
    kind: Kind of resource this is.
    nextPageToken: Token used to access next page of this result.
    trigger_event: Event that triggered this response (only used in case of
      Push Response)
    users: List of user objects.
  """

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'admin#directory#users')
  nextPageToken = _messages.StringField(3)
  trigger_event = _messages.StringField(4)
  users = _messages.MessageField('User', 5, repeated=True)


class VerificationCode(_messages.Message):
  r"""JSON template for verification codes in Directory API.

  Fields:
    etag: ETag of the resource.
    kind: The type of the resource. This is always
      admin#directory#verificationCode.
    userId: The obfuscated unique ID of the user.
    verificationCode: A current verification code for the user. Invalidated or
      used verification codes are not returned as part of the result.
  """

  etag = _messages.StringField(1)
  kind = _messages.StringField(2, default=u'admin#directory#verificationCode')
  userId = _messages.StringField(3)
  verificationCode = _messages.StringField(4)


class VerificationCodes(_messages.Message):
  r"""JSON response template for List verification codes operation in
  Directory API.

  Fields:
    etag: ETag of the resource.
    items: A list of verification code resources.
    kind: The type of the resource. This is always
      admin#directory#verificationCodesList.
  """

  etag = _messages.StringField(1)
  items = _messages.MessageField('VerificationCode', 2, repeated=True)
  kind = _messages.StringField(
      3, default=u'admin#directory#verificationCodesList')
