# -*-mode: autoconf-*-
#
# acinclude.m4
#
# Copyright (c) 2003 Alan Eldridge <alane@geeksrus.net>.
# All rights reserved.
#
#
# 2003-01-04 Alan Eldridge <alane@geeksrus.net>
#

# REQUIRE_PATH_PROG
# -----------------
#  find a program or die.
AC_DEFUN([REQUIRE_PATH_PROG],
[AC_PATH_PROG([$1],[$2],[$3],[$4])
test "$$1" = "$$3" && AC_MSG_ERROR([\"[$2]\" is required.])
])# REQUIRE_PATH_PROG

# AC_PATH_RUBY
# -------------------
# check for Ruby interp
AC_DEFUN([AC_PATH_RUBY],
    [REQUIRE_PATH_PROG([RUBY], [ruby], [no])
    AC_SUBST([RUBY])
])# AC_PATH_RUBY

# AC_RUBY_VER
# --------------------
# check version of Ruby interp
AC_DEFUN([AC_RUBY_VER],
    [AC_REQUIRE([AC_PATH_RUBY])
    AC_MSG_CHECKING([for $RUBY version])
    RUBY_VER=`$RUBY -e 'print VERSION'|cut -d. -f1-2`
    AC_MSG_RESULT([$RUBY_VER])
    AC_SUBST([RUBY_VER])
])# AC_RUBY_VER

# AC_RUBY_SITELIBDIR
# ---------------------
# find sitelibdir for Ruby interp
AC_DEFUN([AC_RUBY_SITELIBDIR],
    [AC_REQUIRE([AC_PATH_RUBY])
    AC_MSG_CHECKING([for ruby site library dir])
    RUBY_SITELIBDIR=`$RUBY -e 'require "rbconfig"' \
      -e 'print Config::CONFIG[["sitelibdir"]]'`
    AC_MSG_RESULT([$RUBY_SITELIBDIR])
    AC_SUBST([RUBY_SITELIBDIR])
])# AC_RUBY_SITELIBDIR

# AC_PATH_RDOC
# ---------------
# find path to Ruby 'rdoc' program
AC_DEFUN([AC_PATH_RDOC],
    [AC_REQUIRE([AC_PATH_RUBY])
    REQUIRE_PATH_PROG([RDOC], [rdoc], [no])
    AC_SUBST([RDOC])
])# AC_PATH_RDOC

# AC_PATH_RD2
# ---------------
# find path to Ruby 'rd2' program
AC_DEFUN([AC_PATH_RD2],
    [AC_REQUIRE([AC_PATH_RUBY])
    REQUIRE_PATH_PROG([RD2], [rd2], [no])
    AC_SUBST([RD2])
])# AC_PATH_RD2

# AC_PATH_PERL
# -------------------
# check for Perl interp
AC_DEFUN([AC_PATH_PERL],
    [REQUIRE_PATH_PROG([PERL], [perl], [no])
    AC_SUBST([PERL])
])# AC_PATH_PERL

# AC_PATH_POD2TEXT
# ---------------
# find path to Perl 'pod2text' program
AC_DEFUN([AC_PATH_POD2TEXT],
    [AC_REQUIRE([AC_PATH_PERL])
    REQUIRE_PATH_PROG([POD2TEXT], [pod2text], [no])
    AC_SUBST([POD2TEXT])
])# AC_PATH_POD2TEXT

# AC_PATH_POD2HTML
# ---------------
# find path to Perl 'pod2html' program
AC_DEFUN([AC_PATH_POD2HTML],
    [AC_REQUIRE([AC_PATH_PERL])
    REQUIRE_PATH_PROG([POD2HTML], [pod2html], [no])
    AC_SUBST([POD2HTML])
])# AC_PATH_POD2HTML

# AC_PATH_POD2MAN
# ---------------
# find path to Perl 'pod2MAN' program
AC_DEFUN([AC_PATH_POD2MAN],
    [AC_REQUIRE([AC_PATH_PERL])
    REQUIRE_PATH_PROG([POD2MAN], [pod2man], [no])
    AC_SUBST([POD2MAN])
])# AC_PATH_POD2MAN

# AC_PATH_POD2LATEX
# ---------------
# find path to Perl 'pod2latex' program
AC_DEFUN([AC_PATH_POD2LATEX],
    [AC_REQUIRE([AC_PATH_PERL])
    REQUIRE_PATH_PROG([POD2LATEX], [pod2latex], [no])
    AC_SUBST([POD2LATEX])
])# AC_PATH_POD2LATEX

# AC_PATH_TEX
# ---------------
# find path to tex' program
AC_DEFUN([AC_PATH_TEX],
    [REQUIRE_PATH_PROG([TEX], [tex], [no])
    AC_SUBST([TEX])
])# AC_PATH_TEX

# AC_PATH_LATEX
# ----------------
# find path to 'latex' program
AC_DEFUN([AC_PATH_LATEX],
    [AC_REQUIRE([AC_PATH_TEX])
    REQUIRE_PATH_PROG([LATEX], [latex], [no])
    AC_SUBST([LATEX])
])# AC_PATH_LATEX

# AC_PATH_METAFONT
# --------------------
# find path to 'metafont' program
AC_DEFUN([AC_PATH_METAFONT],
    [AC_REQUIRE([AC_PATH_TEX])
    AC_MSG_CHECKING([MetaFont])
    AC_PATH_PROG([METAFONT], [mf], [no])
    test $METAFONT = no && AC_MSG_ERROR([MetaFont (\"mf\") is required.])
    AC_SUBST([METAFONT])
])# AC_PATH_METAFONT

# AC_PATH_DVIPS
# ----------------
# find path to 'dvips' program
AC_DEFUN([AC_PATH_DVIPS],
    [AC_REQUIRE([AC_PATH_METAFONT])
    REQUIRE_PATH_PROG([DVIPS], [dvips], [no])
    AC_SUBST([DVIPS])
])# AC_PATH_DVIPS

# AC_PATH_SH
# --------------
# find sh on this system
AC_DEFUN([AC_PATH_SH],
    [REQUIRE_PATH_PROG([SH], [sh], [no])
    CONFIG_SHELL=$SH
    AC_SUBST([CONFIG_SHELL])
    AC_SUBST([SHELL],[$CONFIG_SHELL])
])# AC_PATH_SH

# AC_PATH_KSH
# ---------------
# find ksh on this system
AC_DEFUN([AC_PATH_KSH],
    [AC_PATH_PROGS([KSH], [ksh ksh88 pdksh], [no])
    AC_SUBST([KSH])
])# AC_PATH_KSH

# AC_PATH_BASH
# ---------------
# find bash on this system
AC_DEFUN([AC_PATH_BASH],
    [AC_PATH_PROG([BASH], [bash], [no])
    AC_SUBST([BASH])
])# AC_PATH_BASH

# AC_PATH_POSIXSHELL
# ----------------
# find a posix shell on this system
AC_DEFUN([AC_PATH_POSIXSHELL],
    [AC_MSG_CHECKING([for Ksh-like shell])
    AC_REQUIRE([AC_PATH_SH])
    AC_REQUIRE([AC_PATH_KSH])
    AC_REQUIRE([AC_PATH_BASH])
    test $KSH != no && POSIXSHELL="$KSH" || POSIXSHELL="$BASH"
    test "`uname`" = "FreeBSD" && POSIXSHELL="$SH"
    AC_MSG_RESULT([$POSIXSHELL])
    test "$POSIXSHELL" = no && AC_MSG_ERROR([A Ksh-like shell is required.])
    AC_SUBST([POSIXSHELL])
])# AC_PATH_POSIXSHELL

#EOF
