/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javap;

import gnu.classpath.tools.javap.Javap;

public class JavapMain {
    public static void main(String[] stringArray) {
        Javap javap = JavapMain.parseArguments(stringArray);
        System.exit(0);
    }

    private static final Javap parseArguments(String[] stringArray) {
        Javap javap = null;
        try {
            javap = Javap.getInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException.getMessage());
            return null;
        }
        if (stringArray.length == 0) {
            JavapMain.usage();
        }
        boolean bl = true;
        int n = 0;
        while (bl) {
            if (stringArray[n].equals("-c")) {
                javap.setDisassemble(true);
            } else if (stringArray[n].equals("-classpath")) {
                javap.setClasspath(stringArray[++n]);
            } else if (stringArray[n].equals("-help")) {
                JavapMain.usage();
            } else if (stringArray[n].equals("-l")) {
                javap.setPrintLineNumbers(true);
                javap.setPrintLocalVariables(true);
            } else if (stringArray[n].equals("-public")) {
                javap.setShowPublic(true);
            } else if (stringArray[n].equals("-protected")) {
                javap.setShowProtected(true);
            } else if (stringArray[n].equals("-private")) {
                javap.setShowPrivate(true);
            } else if (stringArray[n].equals("-s")) {
                javap.setPrintSignatures(true);
            } else if (stringArray[n].equals("-verbose")) {
                javap.setPrintStackSize(true);
                javap.setPrintNumberLocals(true);
                javap.setPrintMethodArgs(true);
            } else {
                if (!stringArray[n].startsWith("-")) break;
                System.err.println("Invalid flag: " + stringArray[n]);
                JavapMain.usage();
            }
            ++n;
        }
        if (stringArray.length - n == 0) {
            JavapMain.usage();
        }
        int n2 = n;
        while (n2 < stringArray.length) {
            javap.printClassFile(stringArray[n2], System.out);
            ++n2;
        }
        return javap;
    }

    private static final void usage() {
        System.out.println("Usage: javap [OPTION]... [CLASS]...");
        System.out.println("Provide information about the given classes.");
        System.out.println("");
        System.out.println("   -c                        Disassemble the code");
        System.out.println("   -classpath PATH           Specify where to find user class files");
        System.out.println("   -help                     Print this usage message");
        System.out.println("   -l                        Print line number and local variable tables");
        System.out.println("   -public                   Show only public classes and members");
        System.out.println("   -protected                Show public and protected classes and members");
        System.out.println("   -private                  Show all classes and members");
        System.out.println("   -s                        Print internal type signatures");
        System.out.println("   -verbose                  Print stack size, number of locals and args for methods");
        System.exit(0);
    }
}

