/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.channels;

import gnu.java.nio.FileLockImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class FileChannelImpl
extends FileChannel {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int APPEND = 4;
    public static final int EXCL = 8;
    public static final int SYNC = 16;
    public static final int DSYNC = 32;
    public static FileChannelImpl in;
    public static FileChannelImpl out;
    public static FileChannelImpl err;
    private int fd;
    private int mode;
    final String description;

    private static final native void init();

    public static final FileChannelImpl create(File file, int mode) throws FileNotFoundException {
        return new FileChannelImpl(file, mode);
    }

    private final native int open(String var1, int var2) throws FileNotFoundException;

    public final native int available() throws IOException;

    private final native long implPosition() throws IOException;

    private final native void seek(long var1) throws IOException;

    private final native void implTruncate(long var1) throws IOException;

    public final native void unlock(long var1, long var3) throws IOException;

    public final native long size() throws IOException;

    protected final native void implCloseChannel() throws IOException;

    protected final void finalize() throws IOException {
        if (this.fd != -1) {
            this.close();
        }
    }

    public final int read(ByteBuffer dst) throws IOException {
        byte[] buffer = new byte[dst.remaining()];
        int result = this.read(buffer, 0, buffer.length);
        if (result > 0) {
            dst.put(buffer, 0, result);
        }
        return result;
    }

    public final int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position: " + position);
        }
        long oldPosition = this.implPosition();
        this.position(position);
        int result = this.read(dst);
        this.position(oldPosition);
        return result;
    }

    public final native int read() throws IOException;

    public final native int read(byte[] var1, int var2, int var3) throws IOException;

    public final long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long result = 0L;
        int i = offset;
        while (i < offset + length) {
            result += (long)this.read(dsts[i]);
            ++i;
        }
        return result;
    }

    public final int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        if (src.hasArray()) {
            byte[] buffer = src.array();
            this.write(buffer, src.arrayOffset() + src.position(), len);
            src.position(src.position() + len);
        } else {
            byte[] buffer = new byte[len];
            src.get(buffer, 0, len);
            this.write(buffer, 0, len);
        }
        return len;
    }

    public final int write(ByteBuffer src, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position: " + position);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        long oldPosition = this.implPosition();
        this.seek(position);
        int result = this.write(src);
        this.seek(oldPosition);
        return result;
    }

    public final native void write(byte[] var1, int var2, int var3) throws IOException;

    public final native void write(int var1) throws IOException;

    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long result = 0L;
        int i = offset;
        while (i < offset + length) {
            result += (long)this.write(srcs[i]);
            ++i;
        }
        return result;
    }

    public final native MappedByteBuffer mapImpl(char var1, long var2, int var4) throws IOException;

    public final MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        char nmode = '\u0000';
        if (mode == FileChannel.MapMode.READ_ONLY) {
            nmode = 'r';
            if ((this.mode & 1) == 0) {
                throw new NonReadableChannelException();
            }
        } else if (mode == FileChannel.MapMode.READ_WRITE || mode == FileChannel.MapMode.PRIVATE) {
            char c = nmode = mode == FileChannel.MapMode.READ_WRITE ? (char)'+' : 'c';
            if ((this.mode & 3) != 3) {
                throw new NonWritableChannelException();
            }
        } else {
            throw new IllegalArgumentException("mode: " + mode);
        }
        if (position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position: " + position + ", size: " + size);
        }
        return this.mapImpl(nmode, position, (int)size);
    }

    public final void force(boolean metaData) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.force();
    }

    private final native void force();

    private final int smallTransferTo(long position, int count, WritableByteChannel target) throws IOException {
        ByteBuffer buffer;
        try {
            buffer = this.map(FileChannel.MapMode.READ_ONLY, position, count);
        }
        catch (IOException e) {
            buffer = ByteBuffer.allocate(count);
            this.read(buffer, position);
            buffer.flip();
        }
        return target.write(buffer);
    }

    public final long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException("position: " + position + ", count: " + count);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        int pageSize = 65536;
        long total = 0L;
        while (count > 0L) {
            int transferred = this.smallTransferTo(position, (int)Math.min(count, 65536L), target);
            if (transferred < 0) break;
            total += (long)transferred;
            position += (long)transferred;
            count -= (long)transferred;
        }
        return total;
    }

    private final int smallTransferFrom(ReadableByteChannel src, long position, int count) throws IOException {
        ByteBuffer buffer = null;
        if (src instanceof FileChannel) {
            try {
                buffer = ((FileChannel)src).map(FileChannel.MapMode.READ_ONLY, position, count);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (buffer == null) {
            buffer = ByteBuffer.allocate(count);
            src.read(buffer);
            buffer.flip();
        }
        return this.write(buffer, position);
    }

    public final long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException("position: " + position + ", count: " + count);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        int pageSize = 65536;
        long total = 0L;
        while (count > 0L) {
            int transferred = this.smallTransferFrom(src, position, (int)Math.min(count, 65536L));
            if (transferred < 0) break;
            total += (long)transferred;
            position += (long)transferred;
            count -= (long)transferred;
        }
        return total;
    }

    private final void lockCheck(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L) {
            throw new IllegalArgumentException("position: " + position + ", size: " + size);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (shared && (this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        if (!shared && (this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileLock tryLock(long position, long size, boolean shared) throws IOException {
        FileLockImpl fileLockImpl;
        this.lockCheck(position, size, shared);
        boolean completed = false;
        try {
            this.begin();
            boolean lockable = this.lock(position, size, shared, false);
            completed = true;
            fileLockImpl = lockable ? new FileLockImpl(this, position, size, shared) : null;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.end(completed);
            throw throwable;
        }
        this.end(completed);
        return fileLockImpl;
    }

    private final native boolean lock(long var1, long var3, boolean var5, boolean var6) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileLock lock(long position, long size, boolean shared) throws IOException {
        FileLockImpl fileLockImpl;
        this.lockCheck(position, size, shared);
        boolean completed = false;
        try {
            boolean lockable = this.lock(position, size, shared, true);
            completed = true;
            fileLockImpl = lockable ? new FileLockImpl(this, position, size, shared) : null;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.end(completed);
            throw throwable;
        }
        this.end(completed);
        return fileLockImpl;
    }

    public final long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition();
    }

    public final FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPostition: " + newPosition);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.seek(newPosition);
        return this;
    }

    public final FileChannel truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("size: " + size);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        if (size < this.size()) {
            this.implTruncate(size);
        }
        return this;
    }

    public final String toString() {
        return this.getClass() + "[fd=" + this.fd + ",mode=" + this.mode + ',' + this.description + ']';
    }

    private final /* synthetic */ void this() {
        this.fd = -1;
    }

    private FileChannelImpl(File file, int mode) throws FileNotFoundException {
        String path;
        this.this();
        this.description = path = file.getPath();
        this.fd = this.open(path, mode);
        this.mode = mode;
        if (file.isDirectory()) {
            try {
                this.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new FileNotFoundException(this.description + " is a directory");
        }
    }

    FileChannelImpl(int fd, int mode) {
        this.this();
        this.fd = fd;
        this.mode = mode;
        this.description = "descriptor(" + fd + ')';
    }

    static {
        System.loadLibrary("javanio");
        FileChannelImpl.init();
        in = new FileChannelImpl(0, 1);
        out = new FileChannelImpl(1, 2);
        err = new FileChannelImpl(2, 2);
    }
}

