/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.model.StringTemplate;

public class Turn {
    private static int startingYear = 1492;
    private static int seasonYear = 1600;
    private static int seasonNumber = 2;
    private int turn = 1;

    public Turn(int turn) {
        this.turn = turn;
    }

    public static synchronized void initialize(int newStartingYear, int newSeasonYear, int newSeasonNumber) {
        startingYear = newStartingYear;
        seasonYear = newSeasonYear;
        seasonNumber = newSeasonNumber;
    }

    public static final synchronized int getStartingYear() {
        return startingYear;
    }

    public static final synchronized int getSeasonYear() {
        return seasonYear;
    }

    public static final synchronized int getSeasonNumber() {
        return seasonNumber;
    }

    public static int yearToTurn(int year) {
        return Turn.yearToTurn(year, 0);
    }

    public static int yearToTurn(int year, int season) {
        int ret = 1;
        int startingYear = Turn.getStartingYear();
        if (year >= startingYear) {
            ret += year - startingYear;
            int seasonYear = Turn.getSeasonYear();
            if (year >= seasonYear) {
                ret += (year - seasonYear) * (Turn.getSeasonNumber() - 1) + season;
            }
        }
        return ret;
    }

    public Turn next() {
        return new Turn(this.turn + 1);
    }

    public int getNumber() {
        return this.turn;
    }

    public int getYear() {
        return Turn.getYear(this.turn);
    }

    public static int getYear(int turn) {
        int seasonYear;
        int year = turn - 1 + Turn.getStartingYear();
        return year < (seasonYear = Turn.getSeasonYear()) ? year : seasonYear + (year - seasonYear) / Turn.getSeasonNumber();
    }

    public static int getSeason(int turn) {
        int year = turn - 1 + Turn.getStartingYear();
        return year < Turn.getSeasonYear() ? -1 : (year - seasonYear) % Turn.getSeasonNumber();
    }

    public int getSeason() {
        return Turn.getSeason(this.turn);
    }

    public StringTemplate getLabel() {
        return Turn.getLabel(this.turn);
    }

    public static StringTemplate getLabel(int turn) {
        int season = Turn.getSeason(turn);
        StringTemplate t = StringTemplate.label("");
        if (season >= 0) {
            t.addName(NameCache.getSeasonName(season));
            t.addName(" ");
        }
        t.addName(Integer.toString(Turn.getYear(turn)));
        return t;
    }

    public boolean isFirstTurn() {
        return this.turn == 1;
    }

    public boolean isFirstSeasonTurn() {
        return this.turn == Turn.yearToTurn(Turn.getSeasonYear());
    }

    public String getSaveGameSuffix() {
        int season = this.getSeason();
        String result = String.valueOf(this.getYear());
        if (season >= 0) {
            int SeasonNumberDigits = String.valueOf(Turn.getSeasonNumber()).length();
            result = result + "_" + String.format("%0" + String.valueOf(SeasonNumberDigits) + "d", season + 1) + "_" + NameCache.getSeasonName(season);
        }
        return result;
    }

    public static String getTurnsText(int turns) {
        return turns == Integer.MIN_VALUE ? Messages.message("notApplicable") : (turns >= 0 ? Integer.toString(turns) : ">" + Integer.toString(-turns - 1));
    }

    public boolean equals(Object o) {
        if (o instanceof Turn) {
            return this.turn == ((Turn)o).turn;
        }
        return false;
    }

    public int hashCode() {
        return this.turn;
    }

    public String toString() {
        return String.valueOf(this.turn);
    }
}

