#ifndef TABFUNCS_H
#define TABFUNCS

#include <stdio.h>
#include "queues.h"

typedef struct {
	Queue q;
	int hashsize;
} tabSpace;

typedef struct {
	Node n;
	char *name;
	char *def;
} tabEntry;

#ifdef _Windows
#define Xport _export far pascal
#else
#define Xport
#endif

extern tabSpace * Xport tabAlloc(int);
extern tabEntry * Xport tabLookup(tabSpace *, char *);
extern tabEntry * Xport tabInstall(tabSpace *, char *, char *);
extern tabEntry * Xport tabInstallPtr(tabSpace *, char *, char *);
extern tabSpace * Xport tabFree(tabSpace *);
extern tabSpace * Xport tabFree(tabSpace *);
extern void       Xport tabDebug(FILE *fp, tabSpace *ts);

#endif
