/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.util.Util;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.srp6.SRP6KeyAgreement;
import gnu.javax.crypto.key.srp6.SRPKeyPairGenerator;
import gnu.javax.crypto.key.srp6.SRPPrivateKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.crypto.sasl.srp.SRPAuthInfoProvider;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class SRP6Host
extends SRP6KeyAgreement {
    private KeyPair hostKeyPair;
    private SRPAuthInfoProvider passwordDB;

    protected void engineInit(Map map) throws KeyAgreementException {
        this.rnd = (SecureRandom)map.get("gnu.crypto.srp6.ka.prng");
        this.N = (BigInteger)map.get("gnu.crypto.srp6.ka.N");
        if (this.N == null) {
            throw new KeyAgreementException("missing shared modulus");
        }
        this.g = (BigInteger)map.get("gnu.crypto.srp6.ka.g");
        if (this.g == null) {
            throw new KeyAgreementException("missing generator");
        }
        String string = (String)map.get("gnu.crypto.srp6.ka.H");
        if (string == null || "".equals(string.trim())) {
            throw new KeyAgreementException("missing hash function");
        }
        this.srp = SRP.instance(string);
        this.passwordDB = (SRPAuthInfoProvider)map.get("gnu.crypto.srp6.ka.password.db");
        if (this.passwordDB == null) {
            throw new KeyAgreementException("missing SRP password database");
        }
    }

    protected OutgoingMessage engineProcessMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        switch (this.step) {
            case 0: {
                return this.computeSharedSecret(incomingMessage);
            }
        }
        throw new IllegalStateException("unexpected state");
    }

    protected void engineReset() {
        this.hostKeyPair = null;
        super.engineReset();
    }

    private final OutgoingMessage computeSharedSecret(IncomingMessage incomingMessage) throws KeyAgreementException {
        Map map;
        Serializable serializable;
        String string = incomingMessage.readString();
        BigInteger bigInteger = incomingMessage.readMPI();
        try {
            serializable = new HashMap();
            serializable.put("gnu.crypto.sasl.username", string);
            serializable.put("srp.md.name", this.srp.getAlgorithm());
            map = this.passwordDB.lookup((Map)((Object)serializable));
        }
        catch (IOException iOException) {
            throw new KeyAgreementException("computeSharedSecret()", iOException);
        }
        serializable = new BigInteger(1, Util.fromBase64((String)map.get("srp.salt")));
        BigInteger bigInteger2 = new BigInteger(1, Util.fromBase64((String)map.get("srp.user.verifier")));
        SRPKeyPairGenerator sRPKeyPairGenerator = new SRPKeyPairGenerator();
        HashMap hashMap = new HashMap();
        if (this.rnd != null) {
            hashMap.put("gnu.crypto.srp.prng", this.rnd);
        }
        hashMap.put("gnu.crypto.srp.N", this.N);
        hashMap.put("gnu.crypto.srp.g", this.g);
        hashMap.put("gnu.crypto.srp.v", bigInteger2);
        sRPKeyPairGenerator.setup(hashMap);
        this.hostKeyPair = sRPKeyPairGenerator.generate();
        BigInteger bigInteger3 = ((SRPPublicKey)this.hostKeyPair.getPublic()).getY();
        BigInteger bigInteger4 = this.uValue(bigInteger, bigInteger3);
        BigInteger bigInteger5 = ((SRPPrivateKey)this.hostKeyPair.getPrivate()).getX();
        BigInteger bigInteger6 = bigInteger.multiply(bigInteger2.modPow(bigInteger4, this.N)).modPow(bigInteger5, this.N);
        byte[] byArray = Util.trim(bigInteger6);
        IMessageDigest iMessageDigest = this.srp.newDigest();
        iMessageDigest.update(byArray, 0, byArray.length);
        this.K = new BigInteger(1, iMessageDigest.digest());
        OutgoingMessage outgoingMessage = new OutgoingMessage();
        outgoingMessage.writeMPI((BigInteger)serializable);
        outgoingMessage.writeMPI(bigInteger3);
        this.complete = true;
        return outgoingMessage;
    }
}

