/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.Serializable;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.metal.MetalSplitPaneUI;
import javax.swing.plaf.metal.MetalUtils;

class MetalSplitPaneDivider
extends BasicSplitPaneDivider {
    Color dark;
    Color light;
    JSplitPane splitPane;
    int orientation;

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
        MetalUtils.fillMetalPattern(this.splitPane, graphics, 2, 2, dimension.width - 4, dimension.height - 4, this.light, this.dark);
        if (this.splitPane.isOneTouchExpandable()) {
            ((BasicArrowButton)this.rightButton).paint(graphics);
            ((BasicArrowButton)this.leftButton).paint(graphics);
        }
    }

    public MetalSplitPaneDivider(MetalSplitPaneUI metalSplitPaneUI, Color color, Color color2) {
        super(metalSplitPaneUI);
        this.setLayout(new MetalDividerLayout());
        this.splitPane = ((BasicSplitPaneDivider)this).splitPane;
        this.orientation = ((BasicSplitPaneDivider)this).orientation;
        this.light = color;
        this.dark = color2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MetalDividerLayout
    implements LayoutManager {
        BasicArrowButton rb;
        BasicArrowButton lb;

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (MetalSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                Serializable serializable;
                if (container.getComponentCount() == 2) {
                    serializable = container.getComponent(0);
                    Component component = container.getComponent(1);
                    if (serializable instanceof BasicArrowButton && component instanceof BasicArrowButton) {
                        this.lb = (BasicArrowButton)serializable;
                        this.rb = (BasicArrowButton)component;
                    }
                }
                if (this.rb != null && this.lb != null) {
                    serializable = MetalSplitPaneDivider.this.getLocation();
                    this.lb.setSize(this.lb.getPreferredSize());
                    this.rb.setSize(this.rb.getPreferredSize());
                    this.lb.setLocation(((Point)serializable).x, ((Point)serializable).y);
                    if (MetalSplitPaneDivider.this.orientation == 1) {
                        this.rb.setDirection(3);
                        this.lb.setDirection(7);
                        this.rb.setLocation(((Point)serializable).x, ((Point)serializable).y + this.lb.getHeight());
                    } else {
                        this.rb.setDirection(5);
                        this.lb.setDirection(1);
                        this.rb.setLocation(((Point)serializable).x + this.lb.getWidth(), ((Point)serializable).y);
                    }
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = MetalSplitPaneDivider.this.getDividerSize();
            return new Dimension(n, n);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

