<?php

/**
 * BaseEmployeeSalary
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int             $id                                 Type: integer(4), primary key
 * @property int             $empNumber                          Type: integer(4)
 * @property int             $payGradeId                         Type: integer
 * @property string          $currencyCode                       Type: string(6)
 * @property string          $amount                             Type: string(100)
 * @property string          $payPeriodId                        Type: string(13)
 * @property string          $salaryName                         Type: string(100)
 * @property string          $notes                              Type: string(255)
 * @property CurrencyType    $currencyType                       
 * @property Employee        $employee                           
 * @property Payperiod       $payperiod                          
 * @property EmpDirectdebit  $directDebit                        
 * @property PayGrade        $payGrade                           
 *  
 * @method int               getId()                             Type: integer(4), primary key
 * @method int               getEmpnumber()                      Type: integer(4)
 * @method int               getPaygradeid()                     Type: integer
 * @method string            getCurrencycode()                   Type: string(6)
 * @method string            getAmount()                         Type: string(100)
 * @method string            getPayperiodid()                    Type: string(13)
 * @method string            getSalaryname()                     Type: string(100)
 * @method string            getNotes()                          Type: string(255)
 * @method CurrencyType      getCurrencyType()                   
 * @method Employee          getEmployee()                       
 * @method Payperiod         getPayperiod()                      
 * @method EmpDirectdebit    getDirectDebit()                    
 * @method PayGrade          getPayGrade()                       
 *  
 * @method EmployeeSalary    setId(int $val)                     Type: integer(4), primary key
 * @method EmployeeSalary    setEmpnumber(int $val)              Type: integer(4)
 * @method EmployeeSalary    setPaygradeid(int $val)             Type: integer
 * @method EmployeeSalary    setCurrencycode(string $val)        Type: string(6)
 * @method EmployeeSalary    setAmount(string $val)              Type: string(100)
 * @method EmployeeSalary    setPayperiodid(string $val)         Type: string(13)
 * @method EmployeeSalary    setSalaryname(string $val)          Type: string(100)
 * @method EmployeeSalary    setNotes(string $val)               Type: string(255)
 * @method EmployeeSalary    setCurrencyType(CurrencyType $val)  
 * @method EmployeeSalary    setEmployee(Employee $val)          
 * @method EmployeeSalary    setPayperiod(Payperiod $val)        
 * @method EmployeeSalary    setDirectDebit(EmpDirectdebit $val) 
 * @method EmployeeSalary    setPayGrade(PayGrade $val)          
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmployeeSalary extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_emp_basicsalary');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('emp_number as empNumber', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('sal_grd_code as payGradeId', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('currency_id as currencyCode', 'string', 6, array(
             'type' => 'string',
             'notnull' => true,
             'default' => '',
             'length' => 6,
             ));
        $this->hasColumn('ebsal_basic_salary as amount', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('payperiod_code as payPeriodId', 'string', 13, array(
             'type' => 'string',
             'length' => 13,
             ));
        $this->hasColumn('salary_component as salaryName', 'string', 100, array(
             'type' => 'string',
             'length' => 100,
             ));
        $this->hasColumn('comments as notes', 'string', 255, array(
             'type' => 'string',
             'length' => 255,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('CurrencyType as currencyType', array(
             'local' => 'currencyCode',
             'foreign' => 'currency_id'));

        $this->hasOne('Employee as employee', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasOne('Payperiod as payperiod', array(
             'local' => 'payPeriodId',
             'foreign' => 'payperiod_code'));

        $this->hasOne('EmpDirectdebit as directDebit', array(
             'local' => 'id',
             'foreign' => 'salary_id'));

        $this->hasOne('PayGrade as payGrade', array(
             'local' => 'payGradeId',
             'foreign' => 'id'));
    }
}