/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.InputMapUIResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SwingUtilities
implements SwingConstants {
    private static OwnerFrame ownerFrame;
    static /* synthetic */ Class class$javax$swing$JRootPane;
    static /* synthetic */ Class class$java$awt$Window;

    public static Rectangle calculateInsetArea(Rectangle base, Insets insets, Rectangle ret) {
        if (ret == null) {
            ret = new Rectangle();
        }
        ret.setBounds(base.x + insets.left, base.y + insets.top, base.width - (insets.left + insets.right), base.height - (insets.top + insets.bottom));
        return ret;
    }

    public static Rectangle calculateInnerArea(JComponent c, Rectangle r) {
        Rectangle b = SwingUtilities.getLocalBounds(c);
        return SwingUtilities.calculateInsetArea(b, c.getInsets(), r);
    }

    public static Component findFocusOwner(Component comp) {
        Component focusOwner;
        Component tmp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (tmp != null) {
            if (tmp == comp) {
                return focusOwner;
            }
            tmp = tmp.getParent();
        }
        return null;
    }

    public static Accessible getAccessibleAt(Component c, Point p) {
        return c.getAccessibleContext().getAccessibleComponent().getAccessibleAt(p);
    }

    public static Accessible getAccessibleChild(Component c, int i) {
        return c.getAccessibleContext().getAccessibleChild(i);
    }

    public static int getAccessibleChildrenCount(Component c) {
        return c.getAccessibleContext().getAccessibleChildrenCount();
    }

    public static int getAccessibleIndexInParent(Component c) {
        return c.getAccessibleContext().getAccessibleIndexInParent();
    }

    public static AccessibleStateSet getAccessibleStateSet(Component c) {
        return c.getAccessibleContext().getAccessibleStateSet();
    }

    public static Rectangle getLocalBounds(Component aComponent) {
        Rectangle bounds = aComponent.getBounds();
        return new Rectangle(0, 0, bounds.width, bounds.height);
    }

    public static JRootPane getRootPane(Component comp) {
        if (comp instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)comp)).getRootPane();
        }
        Class clazz = class$javax$swing$JRootPane;
        if (clazz == null) {
            clazz = class$javax$swing$JRootPane = SwingUtilities.class("[Ljavax.swing.JRootPane;", false);
        }
        return (JRootPane)SwingUtilities.getAncestorOfClass(clazz, comp);
    }

    public static Container getAncestorNamed(String name, Component comp) {
        while (comp != null && comp.getName() != name) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Container getAncestorOfClass(Class c, Component comp) {
        while (comp != null && !c.isInstance(comp)) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Window getWindowAncestor(Component comp) {
        Class clazz = class$java$awt$Window;
        if (clazz == null) {
            clazz = class$java$awt$Window = SwingUtilities.class("[Ljava.awt.Window;", false);
        }
        return (Window)SwingUtilities.getAncestorOfClass(clazz, comp);
    }

    public static Window windowForComponent(Component comp) {
        Class clazz = class$java$awt$Window;
        if (clazz == null) {
            clazz = class$java$awt$Window = SwingUtilities.class("[Ljava.awt.Window;", false);
        }
        return (Window)SwingUtilities.getAncestorOfClass(clazz, comp);
    }

    public static Component getRoot(Component comp) {
        Applet app = null;
        Window win = null;
        while (comp != null) {
            if (win == null && comp instanceof Window) {
                win = (Window)comp;
            } else if (comp instanceof Applet) {
                app = (Applet)comp;
            }
            comp = comp.getParent();
        }
        if (win != null) {
            return win;
        }
        return app;
    }

    public static boolean isDescendingFrom(Component a, Component b) {
        while (a != null && b != null) {
            if (a == b) {
                return true;
            }
            a = a.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y) {
        if (parent == null || !parent.contains(x, y)) {
            return null;
        }
        if (!(parent instanceof Container)) {
            return parent;
        }
        Container c = (Container)parent;
        return c.findComponentAt(x, y);
    }

    public static void convertPointToScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(c0.x, c0.y);
    }

    public static void convertPointFromScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(-c0.x, -c0.y);
    }

    public static Point convertPoint(Component source, int x, int y, Component destination) {
        Point pt = new Point(x, y);
        if (source == null && destination == null) {
            return pt;
        }
        if (source == null) {
            source = SwingUtilities.getRoot(destination);
        }
        if (destination == null) {
            destination = SwingUtilities.getRoot(source);
        }
        if (source.isShowing() && destination.isShowing()) {
            SwingUtilities.convertPointToScreen(pt, source);
            SwingUtilities.convertPointFromScreen(pt, destination);
        }
        return pt;
    }

    public static Point convertPoint(Component source, Point aPoint, Component destination) {
        return SwingUtilities.convertPoint(source, aPoint.x, aPoint.y, destination);
    }

    public static Rectangle convertRectangle(Component source, Rectangle rect, Component destination) {
        Point pt = SwingUtilities.convertPoint(source, rect.x, rect.y, destination);
        return new Rectangle(pt.x, pt.y, rect.width, rect.height);
    }

    public static MouseEvent convertMouseEvent(Component source, MouseEvent sourceEvent, Component destination) {
        Point newpt = SwingUtilities.convertPoint(source, sourceEvent.getX(), sourceEvent.getY(), destination);
        return new MouseEvent(destination, sourceEvent.getID(), sourceEvent.getWhen(), sourceEvent.getModifiersEx(), newpt.x, newpt.y, sourceEvent.getClickCount(), sourceEvent.isPopupTrigger(), sourceEvent.getButton());
    }

    public static void updateComponentTreeUI(Component comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof Container) {
            Component[] children = ((Container)comp).getComponents();
            int i = 0;
            while (i < children.length) {
                SwingUtilities.updateComponentTreeUI(children[i]);
                ++i;
            }
        }
        if (comp instanceof JComponent) {
            ((JComponent)comp).updateUI();
        }
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        if (horizontalTextPosition == 10) {
            horizontalTextPosition = c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 4 : 2;
        } else if (horizontalTextPosition == 11) {
            horizontalTextPosition = c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 2 : 4;
        }
        if (horizontalAlignment == 10) {
            horizontalAlignment = c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 4 : 2;
        } else if (horizontalAlignment == 11) {
            horizontalAlignment = c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 2 : 4;
        }
        return SwingUtilities.layoutCompoundLabel(fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int centerLine;
        if (icon == null) {
            textIconGap = 0;
            iconR.width = 0;
            iconR.height = 0;
        } else {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        }
        if (text == null || text.equals("")) {
            textIconGap = 0;
            textR.width = 0;
            textR.height = 0;
        } else {
            int fromIndex = 0;
            textR.width = fm.stringWidth(text);
            textR.height = fm.getHeight();
            while (text.indexOf(10, fromIndex) != -1) {
                textR.height += fm.getHeight();
                fromIndex = text.indexOf(10, fromIndex) + 1;
            }
        }
        switch (horizontalTextPosition) {
            case 2: {
                textR.x = 0;
                iconR.x = textR.width + textIconGap;
                break;
            }
            case 4: {
                iconR.x = 0;
                textR.x = iconR.width + textIconGap;
                break;
            }
            case 0: {
                centerLine = Math.max(textR.width, iconR.width) / 2;
                textR.x = centerLine - textR.width / 2;
                iconR.x = centerLine - iconR.width / 2;
                break;
            }
        }
        switch (verticalTextPosition) {
            case 1: {
                textR.y = 0;
                int n = 0;
                if (horizontalTextPosition == 0) {
                    n = textR.height + textIconGap;
                }
                iconR.y = n;
                break;
            }
            case 3: {
                iconR.y = 0;
                textR.y = horizontalTextPosition == 0 ? iconR.height + textIconGap : Math.max(iconR.height - textR.height, 0);
                break;
            }
            case 0: {
                centerLine = Math.max(textR.height, iconR.height) / 2;
                textR.y = centerLine - textR.height / 2;
                iconR.y = centerLine - iconR.height / 2;
                break;
            }
        }
        Rectangle u = textR.union(iconR);
        int horizontalAdjustment = viewR.x;
        int verticalAdjustment = viewR.y;
        switch (verticalAlignment) {
            case 1: {
                break;
            }
            case 3: {
                verticalAdjustment += viewR.height - u.height;
                break;
            }
            case 0: {
                verticalAdjustment += viewR.height / 2 - u.height / 2;
                break;
            }
        }
        switch (horizontalAlignment) {
            case 2: {
                break;
            }
            case 4: {
                horizontalAdjustment += viewR.width - u.width;
                break;
            }
            case 0: {
                horizontalAdjustment += viewR.width / 2 - u.width / 2;
                break;
            }
        }
        iconR.x += horizontalAdjustment;
        iconR.y += verticalAdjustment;
        textR.x += horizontalAdjustment;
        textR.y += verticalAdjustment;
        return text;
    }

    public static void invokeLater(Runnable doRun) {
        EventQueue.invokeLater(doRun);
    }

    public static void invokeAndWait(Runnable doRun) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(doRun);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h) {
        Container parent = c.getParent();
        if (parent != null) {
            parent.remove(c);
        }
        if (p != null) {
            p.add(c);
        }
        Shape savedClip = g.getClip();
        g.setClip(x, y, w, h);
        g.translate(x, y);
        c.paint(g);
        g.translate(-x, -y);
        g.setClip(savedClip);
    }

    public static void paintComponent(Graphics g, Component c, Container p, Rectangle r) {
        SwingUtilities.paintComponent(g, c, p, r.x, r.y, r.width, r.height);
    }

    static Frame getOwnerFrame() {
        if (ownerFrame == null) {
            ownerFrame = new OwnerFrame();
        }
        return ownerFrame;
    }

    public static boolean isLeftMouseButton(MouseEvent event) {
        boolean bl = false;
        if ((event.getModifiersEx() & 0x400) == 1024) {
            bl = true;
        }
        return bl;
    }

    public static boolean isMiddleMouseButton(MouseEvent event) {
        boolean bl = false;
        if ((event.getModifiersEx() & 0x800) == 2048) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRightMouseButton(MouseEvent event) {
        boolean bl = false;
        if ((event.getModifiersEx() & 0x1000) == 4096) {
            bl = true;
        }
        return bl;
    }

    public static boolean notifyAction(Action action, KeyStroke ks, KeyEvent event, Object sender, int modifiers) {
        if (action != null && action.isEnabled()) {
            String name = (String)action.getValue("ActionCommandKey");
            if (name == null && event.getKeyChar() != (char)-1) {
                name = new String(new char[]{event.getKeyChar()});
            }
            action.actionPerformed(new ActionEvent(sender, 1001, name, modifiers));
            return true;
        }
        return false;
    }

    public static void replaceUIActionMap(JComponent component, ActionMap uiActionMap) {
        ActionMap child = component.getActionMap();
        if (child == null) {
            component.setActionMap(uiActionMap);
        } else {
            ActionMap parent = child.getParent();
            while (parent != null) {
                child = parent;
                parent = child.getParent();
            }
            if (child != null) {
                child.setParent(uiActionMap);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void replaceUIInputMap(JComponent component, int condition, InputMap uiInputMap) {
        block2: {
            child = component.getInputMap(condition);
            if (child != null) ** GOTO lbl6
            component.setInputMap(condition, uiInputMap);
            break block2;
lbl-1000:
            // 1 sources

            {
                child = child.getParent();
lbl6:
                // 2 sources

                ** while (child.getParent() != null && !(child.getParent() instanceof InputMapUIResource))
            }
lbl7:
            // 1 sources

            if (child != null) {
                child.setParent(uiInputMap);
            }
        }
    }

    public static Rectangle[] computeDifference(Rectangle rectA, Rectangle rectB) {
        if (rectA == null || rectB == null) {
            return new Rectangle[0];
        }
        Rectangle[] r = new Rectangle[4];
        int x1 = rectA.x;
        int y1 = rectA.y;
        int w1 = rectA.width;
        int h1 = rectA.height;
        int x2 = rectB.x;
        int y2 = rectB.y;
        int w2 = rectB.width;
        int h2 = rectB.height;
        int n = 0;
        if (y2 > y1) {
            n = y2 - y1;
        }
        int H0 = n;
        int n2 = 0;
        if (y2 + h2 < y1 + h1) {
            n2 = y1 + h1 - y2 - h2;
        }
        int H3 = n2;
        int n3 = 0;
        if (x2 > x1) {
            n3 = x2 - x1;
        }
        int W1 = n3;
        int n4 = 0;
        if (x1 + w1 > x2 + w2) {
            n4 = x1 + w1 - x2 - w2;
        }
        int W2 = n4;
        int n5 = 0;
        if (H0 + H3 < h1) {
            n5 = h1 - H0 - H3;
        }
        int H12 = n5;
        r[0] = H0 > 0 ? new Rectangle(x1, y1, w1, H0) : null;
        r[1] = W1 > 0 && H12 > 0 ? new Rectangle(x1, y1 + H0, W1, H12) : null;
        r[2] = W2 > 0 && H12 > 0 ? new Rectangle(x2 + w2, y1 + H0, W2, H12) : null;
        r[3] = H3 > 0 ? new Rectangle(x1, y1 + H0 + H12, w1, H3) : null;
        int n6 = 0;
        int i = 0;
        while (i < 4) {
            if (r[i] != null) {
                ++n6;
            }
            ++i;
        }
        Rectangle[] out = new Rectangle[n6];
        int i2 = 3;
        while (i2 >= 0) {
            if (r[i2] != null) {
                out[--n6] = r[i2];
            }
            --i2;
        }
        return out;
    }

    public static Rectangle computeIntersection(int x, int y, int w, int h, Rectangle rect) {
        int dh;
        int x2 = (int)rect.getX();
        int y2 = (int)rect.getY();
        int w2 = (int)rect.getWidth();
        int h2 = (int)rect.getHeight();
        int dx = x > x2 ? x : x2;
        int dy = y > y2 ? y : y2;
        int dw = x + w < x2 + w2 ? x + w - dx : x2 + w2 - dx;
        int n = dh = y + h < y2 + h2 ? y + h - dy : y2 + h2 - dy;
        if (dw >= 0 && dh >= 0) {
            return new Rectangle(dx, dy, dw, dh);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static int computeStringWidth(FontMetrics fm, String str) {
        return fm.stringWidth(str);
    }

    public static Rectangle computeUnion(int x, int y, int w, int h, Rectangle rect) {
        int dh;
        int x2 = (int)rect.getX();
        int y2 = (int)rect.getY();
        int w2 = (int)rect.getWidth();
        int h2 = (int)rect.getHeight();
        int dx = x < x2 ? x : x2;
        int dy = y < y2 ? y : y2;
        int dw = x + w > x2 + w2 ? x + w - dx : x2 + w2 - dx;
        int n = dh = y + h > y2 + h2 ? y + h - dy : y2 + h2 - dy;
        if (dw >= 0 && dh >= 0) {
            return new Rectangle(dx, dy, dw, dh);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static boolean isRectangleContainingRectangle(Rectangle a, Rectangle b) {
        boolean bl = false;
        if (b.width >= 0 && b.height >= 0 && b.width >= 0 && b.height >= 0 && b.x >= a.x && b.x + b.width <= a.x + a.width && b.y >= a.y && b.y + b.height <= a.y + a.height) {
            bl = true;
        }
        return bl;
    }

    public static InputMap getUIInputMap(JComponent component, int cond) {
        if (UIManager.getUI(component) != null) {
            return component.getInputMap(cond).getParent();
        }
        return null;
    }

    public static ActionMap getUIActionMap(JComponent component) {
        if (UIManager.getUI(component) != null) {
            return component.getActionMap().getParent();
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private SwingUtilities() {
    }

    private static class OwnerFrame
    extends Frame {
        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return true;
        }

        private OwnerFrame() {
        }
    }
}

