/*
 * Decompiled with CFR 0.152.
 */
package lts;

public class StateCodec {
    int[] bitSize;
    int NBIT;
    int NBYTE;
    static int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE};
    int[] boundaries;

    public StateCodec(int[] nArray) {
        this.bitSize = new int[nArray.length];
        this.NBIT = 0;
        int n = 1;
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            this.bitSize[n2] = this.nbits(nArray[n2] - 1);
            if (this.NBIT + this.bitSize[n2] > n * 64) {
                this.NBIT = n * 64;
                ++n;
            }
            this.NBIT += this.bitSize[n2];
            --n2;
        }
        this.NBYTE = this.NBIT / 8;
        if (this.NBIT % 8 > 0) {
            ++this.NBYTE;
        }
        this.boundaries = new int[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray.length - 1;
        while (n5 >= 0) {
            if (n3 + this.bitSize[n5] <= 64) {
                n3 += this.bitSize[n5];
            } else {
                this.boundaries[n4] = n5 + 1;
                n3 = this.bitSize[n5];
                ++n4;
            }
            --n5;
        }
        this.boundaries[n4] = 0;
    }

    private void longToBytes(byte[] byArray, long l, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] | (byte)l);
            l >>>= 8;
        }
    }

    private long bytesToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = n2 - 1;
        while (n3 >= n) {
            l |= (long)byArray[n3] & 0xFFL;
            if (n3 > n) {
                l <<= 8;
            }
            --n3;
        }
        return l;
    }

    public int bits() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bitSize.length) {
            n += this.bitSize[n2];
            ++n2;
        }
        return n;
    }

    public byte[] zero() {
        return new byte[this.NBYTE];
    }

    public byte[] encode(int[] nArray) {
        byte[] byArray = new byte[this.NBYTE];
        int n = this.bitSize.length - 1;
        int n2 = this.NBYTE;
        int n3 = 0;
        while (n3 < this.boundaries.length) {
            long l = 0L;
            int n4 = n;
            while (n4 >= this.boundaries[n3]) {
                if (nArray[n4] < 0) {
                    return null;
                }
                l |= (long)nArray[n4];
                if (n4 > this.boundaries[n3]) {
                    l <<= this.bitSize[n4 - 1];
                }
                --n4;
            }
            int n5 = n2 - 8;
            if (n5 < 0) {
                n5 = 0;
            }
            this.longToBytes(byArray, l, n5, n2);
            n2 = n5;
            n = this.boundaries[n3] - 1;
            ++n3;
        }
        return byArray;
    }

    public int[] decode(byte[] byArray) {
        int[] nArray = new int[this.bitSize.length + 1];
        int n = this.bitSize.length;
        int n2 = this.NBYTE;
        int n3 = 0;
        while (n3 < this.boundaries.length) {
            int n4 = n2 - 8;
            if (n4 < 0) {
                n4 = 0;
            }
            long l = this.bytesToLong(byArray, n4, n2);
            int n5 = this.boundaries[n3];
            while (n5 < n) {
                nArray[n5] = (int)l & masks[this.bitSize[n5]];
                l >>>= this.bitSize[n5];
                ++n5;
            }
            n2 = n4;
            n = this.boundaries[n3];
            ++n3;
        }
        return nArray;
    }

    public static int hash(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < byArray.length) {
            l = l * 127L + (long)byArray[n];
            ++n;
        }
        int n2 = (int)(l ^ l >>> 32);
        return n2 & Integer.MAX_VALUE;
    }

    public static long hashLong(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < byArray.length) {
            l = l * 255L + (long)byArray[n];
            ++n;
        }
        return l;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return true;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private int nbits(int n) {
        int n2 = 0;
        while (n != 0) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }
}

