/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.wiztools.commons.CollectionsUtil;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.MultiValueMapLinkedHashSet;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.ui.KeyValMultiEntryDialog;
import org.wiztools.restclient.ui.MultiEntryAdd;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.TwoColumnTableModel;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.util.MultiEntryRes;

public final class TwoColumnTablePanel
extends JPanel {
    private RESTUserInterface rest_ui;
    private TwoColumnTableModel model;
    private Dimension tableDimension;
    private KeyValMultiEntryDialog jd_multi;
    private JMenuItem jmi_rm_selected = new JMenuItem("Remove Selected");

    private void initMultiEntryDialog() {
        MultiEntryAdd callback = new MultiEntryAdd(){

            @Override
            public void add(MultiEntryRes res) {
                Map<String, String> keyValuePair = res.getEntries();
                List<String> invalidLines = res.getInvalidLines();
                int successCount = 0;
                for (String key : keyValuePair.keySet()) {
                    String value = keyValuePair.get(key);
                    TwoColumnTablePanel.this.model.insertRow(key, value);
                    ++successCount;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Added ").append(successCount).append(" key/value pairs.\n\n");
                sb.append("\n**Lines Skipped Due To Pattern Mis-match**\n\n");
                if (invalidLines.isEmpty()) {
                    sb.append("- None -\n");
                } else {
                    for (String line : invalidLines) {
                        sb.append(line).append("\n");
                    }
                }
                TwoColumnTablePanel.this.rest_ui.getView().showMessage("Multi-insert Result", sb.toString());
            }
        };
        this.jd_multi = new KeyValMultiEntryDialog(this.rest_ui, callback);
    }

    public MultiValueMap<String, String> getData() {
        Object[][] d = this.model.getData();
        if (d.length == 0) {
            return CollectionsUtil.EMPTY_MULTI_VALUE_MAP;
        }
        MultiValueMapLinkedHashSet<String, String> out = new MultiValueMapLinkedHashSet<String, String>();
        for (Object[] d1 : d) {
            String key = (String)d1[0];
            String value = (String)d1[1];
            out.put(key, value);
        }
        return out;
    }

    public void setData(MultiValueMap<String, String> data) {
        this.model.setData(data);
    }

    public TwoColumnTablePanel(String[] title, RESTUserInterface ui) {
        this(title, Collections.EMPTY_LIST, ui);
    }

    public TwoColumnTablePanel(String[] title, List<String> keys, final RESTUserInterface ui) {
        this.rest_ui = ui;
        final JTable jt = new JTable();
        Dimension d = jt.getPreferredSize();
        d.height /= 2;
        jt.setPreferredScrollableViewportSize(d);
        this.tableDimension = d;
        this.model = new TwoColumnTableModel(title);
        jt.setModel(this.model);
        final JPopupMenu popupMenu = new JPopupMenu();
        this.jmi_rm_selected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectionCount = jt.getSelectedRowCount();
                if (selectionCount > 0) {
                    int[] rows = jt.getSelectedRows();
                    Arrays.sort(rows);
                    for (int i = rows.length - 1; i >= 0; --i) {
                        TwoColumnTablePanel.this.model.deleteRow(rows[i]);
                    }
                }
            }
        });
        popupMenu.add(this.jmi_rm_selected);
        JMenuItem jmi_rm_all = new JMenuItem("Remove All");
        jmi_rm_all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TwoColumnTablePanel.this.model.setData(CollectionsUtil.EMPTY_MULTI_VALUE_MAP);
            }
        });
        popupMenu.add(jmi_rm_all);
        jt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (jt.getSelectedRowCount() == 0) {
                    TwoColumnTablePanel.this.jmi_rm_selected.setEnabled(false);
                } else {
                    TwoColumnTablePanel.this.jmi_rm_selected.setEnabled(true);
                }
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        TwoColumnTablePanel jp = this;
        jp.setLayout(new BorderLayout());
        JPanel jp_north = new JPanel();
        jp_north.setLayout(new FlowLayout(0));
        JLabel jl_key = new JLabel("Key: ");
        JLabel jl_value = new JLabel("Value: ");
        int TEXT_FIELD_SIZE = 12;
        final JTextField jtf_key = new JTextField(12);
        if (!keys.isEmpty()) {
            AutoCompleteDecorator.decorate((JTextComponent)jtf_key, keys, false);
        }
        final JTextField jtf_value = new JTextField(12);
        jl_key.setDisplayedMnemonic('k');
        jl_key.setLabelFor(jtf_key);
        JButton jb_add = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/add.png"));
        jb_add.setToolTipText("Add");
        jb_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String key = jtf_key.getText();
                String value = jtf_value.getText();
                ArrayList<String> errors = null;
                if (StringUtil.isEmpty(key)) {
                    errors = new ArrayList<String>();
                    errors.add("Key is empty.");
                }
                if (StringUtil.isEmpty(value)) {
                    errors = errors == null ? new ArrayList<String>() : errors;
                    errors.add("Value is empty.");
                }
                Object[][] data = TwoColumnTablePanel.this.model.getData();
                if (errors != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html><ul>");
                    for (String error : errors) {
                        sb.append("<li>");
                        sb.append(error);
                        sb.append("</li>");
                    }
                    sb.append("</ul></html>");
                    JOptionPane.showMessageDialog(ui.getFrame(), sb.toString(), "Validation Error", 0);
                    return;
                }
                TwoColumnTablePanel.this.model.insertRow(key, value);
                jtf_key.setText("");
                jtf_value.setText("");
                jtf_key.requestFocus();
            }
        });
        JButton jb_multi_insert = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/insert_parameters.png"));
        jb_multi_insert.setToolTipText("Multi-insert");
        jb_multi_insert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TwoColumnTablePanel.this.jd_multi == null) {
                    TwoColumnTablePanel.this.initMultiEntryDialog();
                }
                TwoColumnTablePanel.this.jd_multi.setVisible(true);
            }
        });
        jp_north.add(jl_key);
        jp_north.add(jtf_key);
        jp_north.add(jl_value);
        jp_north.add(jtf_value);
        jp_north.add(jb_add);
        jp_north.add(jb_multi_insert);
        jp.add((Component)jp_north, "North");
        JPanel jp_center = new JPanel();
        jp_center.setLayout(new GridLayout(1, 1));
        JScrollPane jsp = new JScrollPane(jt);
        jp_center.add(jsp);
        jp.add((Component)jp_center, "Center");
    }

    public Dimension getTableDimension() {
        return this.tableDimension;
    }
}

