require "iconv"

module Color::RGB::JP::Base

  module Encode
    INTERNAL_ENCODING = "UTF-8"

    module_function

    def encode_to(to, from, value)
      return nil if value.nil?
      return value if to.nil?
      return value if from.nil?
      return value if from == to
      return Iconv.iconv(to, from, value)[0]
    end

    def with_internal_encoding(value, from)
      yield encode_to(INTERNAL_ENCODING, from, value)
    end
  end

end
