CREATE TABLE accounts (
  id INTEGER PRIMARY KEY NOT NULL,
  firm_id INTEGER DEFAULT NULL,
  credit_limit INTEGER DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE accounts_seq MINVALUE 10000;

CREATE TABLE funny_jokes (
  id INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(50) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE funny_jokes_seq MINVALUE 10000;

CREATE TABLE companies (
  id INTEGER PRIMARY KEY NOT NULL,
  type VARCHAR(50) DEFAULT NULL,
  ruby_type VARCHAR(50) DEFAULT NULL,
  firm_id INTEGER DEFAULT NULL,
  name VARCHAR(50) DEFAULT NULL,
  client_of INTEGER DEFAULT NULL,
  rating INTEGER DEFAULT 1
) WITH PAGE_SIZE=8192;

/* non-standard sequence name used to test set_sequence_name */
CREATE SEQUENCE companies_nonstd_seq MINVALUE 10000;

CREATE TABLE topics (
  id INTEGER PRIMARY KEY NOT NULL,
  title VARCHAR(255) DEFAULT NULL,
  author_name VARCHAR(255) DEFAULT NULL,
  author_email_address VARCHAR(255) DEFAULT NULL,
  written_on DATE DEFAULT NULL,
  bonus_time DATE DEFAULT NULL,
  last_read DATE DEFAULT NULL,
  content VARCHAR(255),
  approved TINYINT DEFAULT 1,
  replies_count INTEGER DEFAULT 0,
  parent_id INTEGER DEFAULT NULL,
  type VARCHAR(50) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE topics_seq MINVALUE 10000;

CREATE TABLE developers (
  id INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(100) DEFAULT NULL,
  salary INTEGER DEFAULT 70000,
  created_at DATE DEFAULT NULL,
  updated_at DATE DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE developers_seq MINVALUE 10000;

CREATE TABLE projects (
  id INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(100) DEFAULT NULL,
  type VARCHAR(255) DEFAULT NULL
  ) WITH PAGE_SIZE=8192;
CREATE SEQUENCE projects_seq MINVALUE 10000;

CREATE TABLE developers_projects (
  developer_id INTEGER NOT NULL,
  project_id INTEGER NOT NULL,
  joined_on DATE DEFAULT NULL,
  access_level SMALLINT DEFAULT 1
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE developers_projects_seq MINVALUE 10000;

CREATE TABLE customers (
  id INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(100) DEFAULT NULL,
  balance INTEGER DEFAULT 0,
  address_street VARCHAR(100) DEFAULT NULL,
  address_city VARCHAR(100) DEFAULT NULL,
  address_country VARCHAR(100) DEFAULT NULL,
  gps_location VARCHAR(100) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE customers_seq MINVALUE 10000;

CREATE TABLE orders (
  id INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(100) DEFAULT NULL,
  billing_customer_id INTEGER DEFAULT NULL,
  shipping_customer_id INTEGER DEFAULT NULL
  ) WITH PAGE_SIZE=8192;
CREATE SEQUENCE orders_seq MINVALUE 10000;

CREATE TABLE movies (
  movieid INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(100) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE movies_seq MINVALUE 10000;

CREATE TABLE subscribers (
  nick VARCHAR(100) NOT NULL,
  name VARCHAR(100) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE subscribers_seq MINVALUE 10000;

CREATE TABLE booleantests (
  id INTEGER PRIMARY KEY NOT NULL,
  value INTEGER DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE booleantests_seq MINVALUE 10000;

CREATE TABLE auto_id_tests (
  auto_id INTEGER PRIMARY KEY NOT NULL,
  value INTEGER DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE auto_id_tests_seq MINVALUE 10000;

CREATE TABLE entrants (
  id INTEGER NOT NULL PRIMARY KEY,
  name VARCHAR(255) NOT NULL,
  course_id INTEGER NOT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE entrants_seq MINVALUE 10000;

CREATE TABLE colnametests (
  id INTEGER PRIMARY KEY NOT NULL,
  references INTEGER NOT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE colnametests_seq MINVALUE 10000;

CREATE TABLE mixins (
  id INTEGER PRIMARY KEY NOT NULL,
  parent_id INTEGER DEFAULT NULL,
  pos INTEGER DEFAULT NULL,
  created_at DATE DEFAULT NULL,
  updated_at DATE DEFAULT NULL,
  lft INTEGER DEFAULT NULL,
  rgt INTEGER DEFAULT NULL,
  root_id INTEGER DEFAULT NULL,
  type VARCHAR(40) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE mixins_seq MINVALUE 10000;

CREATE TABLE people (
  id INTEGER NOT NULL PRIMARY KEY,
  first_name VARCHAR(40),
  lock_version INTEGER DEFAULT 0
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE people_seq MINVALUE 10000;

CREATE TABLE readers (
    id INTEGER PRIMARY KEY NOT NULL,
    post_id INTEGER NOT NULL,
    person_id INTEGER NOT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE readers_seq MINVALUE 10000;

CREATE TABLE binaries (
  id INTEGER PRIMARY KEY NOT NULL,
  data LONG BYTE
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE binaries_seq MINVALUE 10000;

CREATE TABLE computers (
  id INTEGER PRIMARY KEY NOT NULL,
  developer INTEGER NOT NULL,
  "extendedWarranty" INTEGER NOT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE computers_seq MINVALUE 10000;

CREATE TABLE posts (
  id INTEGER NOT NULL PRIMARY KEY,
  author_id INTEGER,
  title VARCHAR(255) DEFAULT NULL,
  body BYTE VARYING DEFAULT NULL,
  type VARCHAR(255) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE posts_seq MINVALUE 10000;

CREATE TABLE comments (
  id INTEGER PRIMARY KEY NOT NULL,
  post_id INTEGER DEFAULT NULL,
  body LONG VARCHAR,
  type VARCHAR(255) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE comments_seq MINVALUE 10000;

CREATE TABLE authors (
  id INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(255) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE authors_seq MINVALUE 10000;

CREATE TABLE tasks (
  id INTEGER PRIMARY KEY NOT NULL,
  starting DATE DEFAULT NULL,
  ending DATE DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE tasks_seq MINVALUE 10000;


CREATE TABLE categories (
  id INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(255) DEFAULT NULL,
  type VARCHAR(255) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE categories_seq MINVALUE 10000;

CREATE TABLE categories_posts (
  category_id INTEGER NOT NULL,
  post_id INTEGER NOT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE categories_posts_seq MINVALUE 10000;

CREATE TABLE fk_test_has_pk (
  id INTEGER PRIMARY KEY NOT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE fk_test_has_pk_seq MINVALUE 10000;

CREATE TABLE fk_test_has_fk (
  id    INTEGER PRIMARY KEY NOT NULL,
  fk_id INTEGER NOT NULL,

  FOREIGN KEY (fk_id) REFERENCES fk_test_has_pk(id)
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE fk_test_has_fk_seq MINVALUE 10000;

CREATE TABLE keyboards (
  key_number INTEGER PRIMARY KEY NOT NULL,
  name VARCHAR(50) DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE keyboards_seq MINVALUE 10000;

CREATE TABLE legacy_things (
  id INTEGER PRIMARY KEY NOT NULL,
  tps_report_number INTEGER DEFAULT NULL,
  version INTEGER DEFAULT 0
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE legacy_things_seq MINVALUE 10000;

CREATE TABLE numeric_data (
  id INTEGER PRIMARY KEY NOT NULL,
  bank_balance decimal(10,2),
  big_bank_balance decimal(15,2),
  world_population decimal(10,0),
  my_house_population decimal(2,0),
  decimal_number_with_default decimal(3,2) DEFAULT 2.78
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE numeric_data_seq MINVALUE 10000;

CREATE TABLE mixed_case_monkeys (
  "monkeyID" INTEGER PRIMARY KEY NOT NULL,
  "fleaCount" INTEGER DEFAULT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE mixed_case_monkeys_seq MINVALUE 10000;

CREATE TABLE minimalistics (
  id INTEGER PRIMARY KEY NOT NULL
) WITH PAGE_SIZE=8192;
CREATE SEQUENCE minimalistics_seq MINVALUE 10000;
