/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.threading;

import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.usadellab.trimmomatic.threading.BlockOfRecords;
import org.usadellab.trimmomatic.threading.TrimLogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimLogWorker
implements Runnable {
    private PrintStream trimLogStream;
    private ArrayBlockingQueue<Future<BlockOfRecords>> logQueue;
    private AtomicBoolean complete;

    public TrimLogWorker(PrintStream trimLogStream, ArrayBlockingQueue<Future<BlockOfRecords>> logQueue) {
        this.trimLogStream = trimLogStream;
        this.logQueue = logQueue;
        this.complete = new AtomicBoolean();
    }

    public boolean isComplete() {
        return this.complete.get();
    }

    private void logRec(TrimLogRecord rec) {
        this.trimLogStream.printf("%s %d %d %d %d\n", rec.getReadName(), rec.getLength(), rec.getStartPos(), rec.getEndPos(), rec.getTrimTail());
    }

    @Override
    public void run() {
        try {
            Future<BlockOfRecords> future = this.logQueue.take();
            BlockOfRecords bor = future.get();
            List<TrimLogRecord> recs = bor.getTrimLogRecs();
            while (recs != null) {
                for (TrimLogRecord rec : recs) {
                    this.logRec(rec);
                }
                future = this.logQueue.take();
                bor = future.get();
                recs = bor.getTrimLogRecs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.complete.set(true);
        }
    }
}

