/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DuplicateSet {
    private final List<SAMRecord> records = new ArrayList<SAMRecord>(10);
    private static final SAMRecordDuplicateComparator defaultComparator = new SAMRecordDuplicateComparator();
    private final SAMRecordDuplicateComparator comparator;
    private SAMRecord representative = null;
    private boolean needsSorting = false;
    private boolean setDuplicateFlag = false;

    public DuplicateSet() {
        this(true);
    }

    public DuplicateSet(boolean setDuplicateFlag) {
        this(setDuplicateFlag, defaultComparator);
    }

    public DuplicateSet(SAMRecordDuplicateComparator comparator) {
        this(true, comparator);
    }

    public DuplicateSet(boolean setDuplicateFlag, SAMRecordDuplicateComparator comparator) {
        this.setDuplicateFlag = setDuplicateFlag;
        this.comparator = comparator;
    }

    public int add(SAMRecord record) {
        if (!this.records.isEmpty()) {
            int cmp = this.comparator.duplicateSetCompare(this.representative, record);
            if (0 != cmp) {
                return cmp;
            }
            if (0 < this.comparator.compare(this.representative, record)) {
                this.representative = record;
            }
        } else {
            this.representative = record;
        }
        this.records.add(record);
        this.needsSorting = true;
        return 0;
    }

    private void sort() {
        if (!this.records.isEmpty()) {
            if (1 < this.records.size()) {
                Collections.sort(this.records, this.comparator);
            }
            if (this.setDuplicateFlag) {
                for (SAMRecord record : this.records) {
                    if (record.getReadUnmappedFlag() || record.isSecondaryOrSupplementary() || record.getReadName().equals(this.representative.getReadName())) continue;
                    record.setDuplicateReadFlag(true);
                }
                this.records.get(0).setDuplicateReadFlag(false);
            }
            if (!this.records.get(0).equals(this.representative)) {
                throw new SAMException("BUG: the representative was not the first record after sorting.\nFIRST: " + this.records.get(0).getSAMString() + "\nSECOND: " + this.representative.getSAMString());
            }
        }
        this.needsSorting = false;
    }

    public List<SAMRecord> getRecords(boolean sort) {
        if (sort && this.needsSorting) {
            this.sort();
        }
        return this.records;
    }

    public List<SAMRecord> getRecords() {
        return this.getRecords(true);
    }

    public SAMRecord getRepresentative() {
        return this.representative;
    }

    public int size() {
        return this.records.size();
    }

    public int numDuplicates() {
        int n = 0;
        for (SAMRecord record : this.records) {
            if (record.getReadUnmappedFlag() || record.isSecondaryOrSupplementary()) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public void setDuplicateFlag(boolean setDuplicateFlag) {
        this.setDuplicateFlag = setDuplicateFlag;
    }
}

