require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_RISCV_MUTEX_H_)) {
    eval 'sub _RISCV_MUTEX_H_ () {1;}' unless defined(&_RISCV_MUTEX_H_);
    require 'sys/types.ph';
    unless(defined(&__MUTEX_PRIVATE)) {
    } else {
	require 'sys/cdefs.ph';
	require 'sys/param.ph';
	require 'machine/intr.ph';
	if(defined(&_KERNEL)) {
	    if(defined(&_LP64)) {
		eval 'sub MTX_ASMOP_SFX () {".d";}' unless defined(&MTX_ASMOP_SFX);
	    } else {
		eval 'sub MTX_ASMOP_SFX () {".w";}' unless defined(&MTX_ASMOP_SFX);
	    }
	    eval 'sub MTX_LOCK () { &__BIT(8);}' unless defined(&MTX_LOCK);
	    eval 'sub MTX_IPL () { &__BITS(7,4);}' unless defined(&MTX_IPL);
	    undef(&MUTEX_SPIN_IPL) if defined(&MUTEX_SPIN_IPL);
	    eval 'sub MUTEX_SPIN_IPL {
	        my($a) = @_;
    		eval q( &riscv_mutex_spin_ipl($a));
	    }' unless defined(&MUTEX_SPIN_IPL);
	    eval 'sub MUTEX_INITIALIZE_SPIN_IPL {
	        my($a,$b) = @_;
    		eval q( &riscv_mutex_initialize_spin_ipl($a,$b));
	    }' unless defined(&MUTEX_INITIALIZE_SPIN_IPL);
	    eval 'sub MUTEX_SPINBIT_LOCK_INIT {
	        my($a) = @_;
    		eval q( &riscv_mutex_spinbit_lock_init($a));
	    }' unless defined(&MUTEX_SPINBIT_LOCK_INIT);
	    eval 'sub MUTEX_SPINBIT_LOCK_TRY {
	        my($a) = @_;
    		eval q( &riscv_mutex_spinbit_lock_try($a));
	    }' unless defined(&MUTEX_SPINBIT_LOCK_TRY);
	    eval 'sub MUTEX_SPINBIT_LOCKED_P {
	        my($a) = @_;
    		eval q( &riscv_mutex_spinbit_locked_p($a));
	    }' unless defined(&MUTEX_SPINBIT_LOCKED_P);
	    eval 'sub MUTEX_SPINBIT_LOCK_UNLOCK {
	        my($a) = @_;
    		eval q( &riscv_mutex_spinbit_lock_unlock($a));
	    }' unless defined(&MUTEX_SPINBIT_LOCK_UNLOCK);
	    eval 'sub riscv_mutex_spin_ipl {
	        my($__mtx) = @_;
    		eval q({ ( &ipl_cookie_t){. &_spl =  &__SHIFTOUT( ($__mtx->{mtx_owner}),  &MTX_IPL)}; });
	    }' unless defined(&riscv_mutex_spin_ipl);
	    eval 'sub riscv_mutex_initialize_spin_ipl {
	        my($__mtx,$ipl) = @_;
    		eval q({  ($__mtx->{mtx_owner}) = ( ($__mtx->{mtx_owner}) & ~ &MTX_IPL) |  &__SHIFTIN($ipl,  &MTX_IPL); });
	    }' unless defined(&riscv_mutex_initialize_spin_ipl);
	    eval 'sub riscv_mutex_spinbit_lock_init {
	        my($__mtx) = @_;
    		eval q({  ($__mtx->{mtx_owner}) &= ~ &MTX_LOCK; });
	    }' unless defined(&riscv_mutex_spinbit_lock_init);
	    eval 'sub riscv_mutex_spinbit_locked_p {
	        my($__mtx) = @_;
    		eval q({ ( ($__mtx->{mtx_owner}) &  &MTX_LOCK) != 0; });
	    }' unless defined(&riscv_mutex_spinbit_locked_p);
	    eval 'sub riscv_mutex_spinbit_lock_try {
	        my($__mtx) = @_;
    		eval q({  &uintptr_t  &__old;  &__asm  &__volatile( \\"amoor\\"  &MTX_ASMOP_SFX \\".aq\\\\t%0, %1, (%2)\\" : \\"=r\\"( &__old) : \\"r\\"( &MTX_LOCK), \\"r\\"($__mtx)); ( &__old &  &MTX_LOCK) == 0; });
	    }' unless defined(&riscv_mutex_spinbit_lock_try);
	    eval 'sub riscv_mutex_spinbit_lock_unlock {
	        my($__mtx) = @_;
    		eval q({  &__asm  &__volatile( \\"amoand\\"  &MTX_ASMOP_SFX \\".rl\\\\tx0, %0, (%1)\\" :: \\"r\\"(~ &MTX_LOCK), \\"r\\"($__mtx)); });
	    }' unless defined(&riscv_mutex_spinbit_lock_unlock);
	}
	if(0) {
	    eval 'sub __HAVE_MUTEX_STUBS () {1;}' unless defined(&__HAVE_MUTEX_STUBS);
	    eval 'sub __HAVE_SPIN_MUTEX_STUBS () {1;}' unless defined(&__HAVE_SPIN_MUTEX_STUBS);
	}
	eval 'sub __HAVE_SIMPLE_MUTEXES () {1;}' unless defined(&__HAVE_SIMPLE_MUTEXES);
    }
}
1;
